<?php

namespace PHPMaker2024\fibre;

// Page object
$RequestArchiveSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { request_archive: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var frequest_archivesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frequest_archivesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["r_from", [], fields.r_from.isInvalid],
            ["r_to", [], fields.r_to.isInvalid],
            ["reference", [ew.Validators.float], fields.reference.isInvalid],
            ["_message", [], fields._message.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["lead_info", [], fields.lead_info.isInvalid],
            ["status", [ew.Validators.integer], fields.status.isInvalid],
            ["Subject", [], fields.Subject.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["QueryGenerator", [], fields.QueryGenerator.isInvalid],
            ["forward_url", [], fields.forward_url.isInvalid],
            ["lead_by", [], fields.lead_by.isInvalid],
            ["lead_status", [], fields.lead_status.isInvalid],
            ["lead_type", [], fields.lead_type.isInvalid],
            ["type", [], fields.type.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "lead_status": <?= $Page->lead_status->toClientList($Page) ?>,
            "lead_type": <?= $Page->lead_type->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frequest_archivesearch" id="frequest_archivesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="request_archive">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="request_archive" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_from->Visible) { // r_from ?>
    <div id="r_r_from" class="row"<?= $Page->r_from->rowAttributes() ?>>
        <label for="x_r_from" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_r_from"><?= $Page->r_from->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_r_from" id="z_r_from" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_from->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_r_from" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_from->getInputTextType() ?>" name="x_r_from" id="x_r_from" data-table="request_archive" data-field="x_r_from" value="<?= $Page->r_from->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->r_from->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_from->formatPattern()) ?>"<?= $Page->r_from->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_from->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <div id="r_r_to" class="row"<?= $Page->r_to->rowAttributes() ?>>
        <label for="x_r_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_r_to"><?= $Page->r_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_r_to" id="z_r_to" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->r_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_r_to" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->r_to->getInputTextType() ?>" name="x_r_to" id="x_r_to" data-table="request_archive" data-field="x_r_to" value="<?= $Page->r_to->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->r_to->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->r_to->formatPattern()) ?>"<?= $Page->r_to->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->r_to->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference" class="row"<?= $Page->reference->rowAttributes() ?>>
        <label for="x_reference" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_reference"><?= $Page->reference->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reference" id="z_reference" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_reference" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="request_archive" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_message->Visible) { // message ?>
    <div id="r__message" class="row"<?= $Page->_message->rowAttributes() ?>>
        <label for="x__message" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive__message"><?= $Page->_message->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__message" id="z__message" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_message->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive__message" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_message->getInputTextType() ?>" name="x__message" id="x__message" data-table="request_archive" data-field="x__message" value="<?= $Page->_message->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->_message->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_message->formatPattern()) ?>"<?= $Page->_message->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_message->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="request_archive" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lead_info->Visible) { // lead_info ?>
    <div id="r_lead_info" class="row"<?= $Page->lead_info->rowAttributes() ?>>
        <label for="x_lead_info" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_lead_info"><?= $Page->lead_info->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lead_info" id="z_lead_info" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lead_info->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_lead_info" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lead_info->getInputTextType() ?>" name="x_lead_info" id="x_lead_info" data-table="request_archive" data-field="x_lead_info" value="<?= $Page->lead_info->EditValue ?>" size="30" maxlength="236" placeholder="<?= HtmlEncode($Page->lead_info->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_info->formatPattern()) ?>"<?= $Page->lead_info->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lead_info->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_status" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->status->getInputTextType() ?>" name="x_status" id="x_status" data-table="request_archive" data-field="x_status" value="<?= $Page->status->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Subject->Visible) { // Subject ?>
    <div id="r_Subject" class="row"<?= $Page->Subject->rowAttributes() ?>>
        <label for="x_Subject" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_Subject"><?= $Page->Subject->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Subject" id="z_Subject" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Subject->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_Subject" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Subject->getInputTextType() ?>" name="x_Subject" id="x_Subject" data-table="request_archive" data-field="x_Subject" value="<?= $Page->Subject->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->Subject->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Subject->formatPattern()) ?>"<?= $Page->Subject->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Subject->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="request_archive" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frequest_archivesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frequest_archivesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->QueryGenerator->Visible) { // QueryGenerator ?>
    <div id="r_QueryGenerator" class="row"<?= $Page->QueryGenerator->rowAttributes() ?>>
        <label for="x_QueryGenerator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_QueryGenerator"><?= $Page->QueryGenerator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_QueryGenerator" id="z_QueryGenerator" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->QueryGenerator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_QueryGenerator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->QueryGenerator->getInputTextType() ?>" name="x_QueryGenerator" id="x_QueryGenerator" data-table="request_archive" data-field="x_QueryGenerator" value="<?= $Page->QueryGenerator->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->QueryGenerator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->QueryGenerator->formatPattern()) ?>"<?= $Page->QueryGenerator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->QueryGenerator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->forward_url->Visible) { // forward_url ?>
    <div id="r_forward_url" class="row"<?= $Page->forward_url->rowAttributes() ?>>
        <label for="x_forward_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_forward_url"><?= $Page->forward_url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_forward_url" id="z_forward_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->forward_url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_forward_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->forward_url->getInputTextType() ?>" name="x_forward_url" id="x_forward_url" data-table="request_archive" data-field="x_forward_url" value="<?= $Page->forward_url->EditValue ?>" size="35" maxlength="128" placeholder="<?= HtmlEncode($Page->forward_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->forward_url->formatPattern()) ?>"<?= $Page->forward_url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->forward_url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lead_by->Visible) { // lead_by ?>
    <div id="r_lead_by" class="row"<?= $Page->lead_by->rowAttributes() ?>>
        <label for="x_lead_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_lead_by"><?= $Page->lead_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lead_by" id="z_lead_by" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lead_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_lead_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lead_by->getInputTextType() ?>" name="x_lead_by" id="x_lead_by" data-table="request_archive" data-field="x_lead_by" value="<?= $Page->lead_by->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Page->lead_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_by->formatPattern()) ?>"<?= $Page->lead_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lead_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lead_status->Visible) { // lead_status ?>
    <div id="r_lead_status" class="row"<?= $Page->lead_status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_lead_status"><?= $Page->lead_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lead_status" id="z_lead_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lead_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_lead_status" class="ew-search-field ew-search-field-single">
<template id="tp_x_lead_status">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="request_archive" data-field="x_lead_status" name="x_lead_status" id="x_lead_status"<?= $Page->lead_status->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_lead_status" class="ew-item-list"></div>
<selection-list hidden
    id="x_lead_status"
    name="x_lead_status"
    value="<?= HtmlEncode($Page->lead_status->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_lead_status"
    data-target="dsl_x_lead_status"
    data-repeatcolumn="3"
    class="form-control<?= $Page->lead_status->isInvalidClass() ?>"
    data-table="request_archive"
    data-field="x_lead_status"
    data-value-separator="<?= $Page->lead_status->displayValueSeparatorAttribute() ?>"
    <?= $Page->lead_status->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->lead_status->getErrorMessage(false) ?></div>
<?= $Page->lead_status->Lookup->getParamTag($Page, "p_x_lead_status") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lead_type->Visible) { // lead_type ?>
    <div id="r_lead_type" class="row"<?= $Page->lead_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_lead_type"><?= $Page->lead_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lead_type" id="z_lead_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lead_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_lead_type" class="ew-search-field ew-search-field-single">
<template id="tp_x_lead_type">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="request_archive" data-field="x_lead_type" name="x_lead_type" id="x_lead_type"<?= $Page->lead_type->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_lead_type" class="ew-item-list"></div>
<selection-list hidden
    id="x_lead_type"
    name="x_lead_type"
    value="<?= HtmlEncode($Page->lead_type->AdvancedSearch->SearchValue) ?>"
    data-type="select-one"
    data-template="tp_x_lead_type"
    data-target="dsl_x_lead_type"
    data-repeatcolumn="3"
    class="form-control<?= $Page->lead_type->isInvalidClass() ?>"
    data-table="request_archive"
    data-field="x_lead_type"
    data-value-separator="<?= $Page->lead_type->displayValueSeparatorAttribute() ?>"
    <?= $Page->lead_type->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->lead_type->getErrorMessage(false) ?></div>
<?= $Page->lead_type->Lookup->getParamTag($Page, "p_x_lead_type") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_request_archive_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_request_archive_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="frequest_archivesearch_x_type"
        <?php } ?>
        data-table="request_archive"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("frequest_archivesearch", function() {
    var options = { name: "x_type", selectId: "frequest_archivesearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequest_archivesearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "frequest_archivesearch" };
    } else {
        options.ajax = { id: "x_type", form: "frequest_archivesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.request_archive.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frequest_archivesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frequest_archivesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="frequest_archivesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("request_archive");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
