<?php

namespace PHPMaker2024\fibre;

// Page object
$Request2Add = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { request2: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var frequest2add;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("frequest2add")
        .setPageId("add")

        // Add fields
        .setFields([
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["r_from", [fields.r_from.visible && fields.r_from.required ? ew.Validators.required(fields.r_from.caption) : null], fields.r_from.isInvalid],
            ["r_to", [fields.r_to.visible && fields.r_to.required ? ew.Validators.required(fields.r_to.caption) : null], fields.r_to.isInvalid],
            ["lead_type", [fields.lead_type.visible && fields.lead_type.required ? ew.Validators.required(fields.lead_type.caption) : null], fields.lead_type.isInvalid],
            ["lead_status", [fields.lead_status.visible && fields.lead_status.required ? ew.Validators.required(fields.lead_status.caption) : null], fields.lead_status.isInvalid],
            ["lead_by", [fields.lead_by.visible && fields.lead_by.required ? ew.Validators.required(fields.lead_by.caption) : null], fields.lead_by.isInvalid],
            ["subject", [fields.subject.visible && fields.subject.required ? ew.Validators.required(fields.subject.caption) : null], fields.subject.isInvalid],
            ["_message", [fields._message.visible && fields._message.required ? ew.Validators.required(fields._message.caption) : null], fields._message.isInvalid],
            ["alert", [fields.alert.visible && fields.alert.required ? ew.Validators.required(fields.alert.caption) : null, ew.Validators.datetime(fields.alert.clientFormatPattern)], fields.alert.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null, ew.Validators.integer], fields.reference.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "r_from": <?= $Page->r_from->toClientList($Page) ?>,
            "r_to": <?= $Page->r_to->toClientList($Page) ?>,
            "lead_type": <?= $Page->lead_type->toClientList($Page) ?>,
            "lead_status": <?= $Page->lead_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frequest2add" id="frequest2add" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="request2">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_request2_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_request2_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="frequest2add_x_type"
        <?php } ?>
        data-table="request2"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("frequest2add", function() {
    var options = { name: "x_type", selectId: "frequest2add_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequest2add.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "frequest2add" };
    } else {
        options.ajax = { id: "x_type", form: "frequest2add", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.request2.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->r_to->Visible) { // r_to ?>
    <div id="r_r_to"<?= $Page->r_to->rowAttributes() ?>>
        <label id="elh_request2_r_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->r_to->caption() ?><?= $Page->r_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->r_to->cellAttributes() ?>>
<span id="el_request2_r_to">
<template id="tp_x_r_to">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="request2" data-field="x_r_to" name="x_r_to" id="x_r_to"<?= $Page->r_to->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_r_to" class="ew-item-list"></div>
<selection-list hidden
    id="x_r_to[]"
    name="x_r_to[]"
    value="<?= HtmlEncode($Page->r_to->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_r_to"
    data-target="dsl_x_r_to"
    data-repeatcolumn="5"
    class="form-control<?= $Page->r_to->isInvalidClass() ?>"
    data-table="request2"
    data-field="x_r_to"
    data-value-separator="<?= $Page->r_to->displayValueSeparatorAttribute() ?>"
    <?= $Page->r_to->editAttributes() ?>></selection-list>
<?= $Page->r_to->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->r_to->getErrorMessage() ?></div>
<?= $Page->r_to->Lookup->getParamTag($Page, "p_x_r_to") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_type->Visible) { // lead_type ?>
    <div id="r_lead_type"<?= $Page->lead_type->rowAttributes() ?>>
        <label id="elh_request2_lead_type" for="x_lead_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_type->caption() ?><?= $Page->lead_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_type->cellAttributes() ?>>
<span id="el_request2_lead_type">
    <select
        id="x_lead_type"
        name="x_lead_type"
        class="form-select ew-select<?= $Page->lead_type->isInvalidClass() ?>"
        <?php if (!$Page->lead_type->IsNativeSelect) { ?>
        data-select2-id="frequest2add_x_lead_type"
        <?php } ?>
        data-table="request2"
        data-field="x_lead_type"
        data-value-separator="<?= $Page->lead_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->lead_type->getPlaceHolder()) ?>"
        <?= $Page->lead_type->editAttributes() ?>>
        <?= $Page->lead_type->selectOptionListHtml("x_lead_type") ?>
    </select>
    <?= $Page->lead_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->lead_type->getErrorMessage() ?></div>
<?= $Page->lead_type->Lookup->getParamTag($Page, "p_x_lead_type") ?>
<?php if (!$Page->lead_type->IsNativeSelect) { ?>
<script>
loadjs.ready("frequest2add", function() {
    var options = { name: "x_lead_type", selectId: "frequest2add_x_lead_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequest2add.lists.lead_type?.lookupOptions.length) {
        options.data = { id: "x_lead_type", form: "frequest2add" };
    } else {
        options.ajax = { id: "x_lead_type", form: "frequest2add", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.request2.fields.lead_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_status->Visible) { // lead_status ?>
    <div id="r_lead_status"<?= $Page->lead_status->rowAttributes() ?>>
        <label id="elh_request2_lead_status" for="x_lead_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_status->caption() ?><?= $Page->lead_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_status->cellAttributes() ?>>
<span id="el_request2_lead_status">
    <select
        id="x_lead_status"
        name="x_lead_status"
        class="form-select ew-select<?= $Page->lead_status->isInvalidClass() ?>"
        <?php if (!$Page->lead_status->IsNativeSelect) { ?>
        data-select2-id="frequest2add_x_lead_status"
        <?php } ?>
        data-table="request2"
        data-field="x_lead_status"
        data-value-separator="<?= $Page->lead_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->lead_status->getPlaceHolder()) ?>"
        <?= $Page->lead_status->editAttributes() ?>>
        <?= $Page->lead_status->selectOptionListHtml("x_lead_status") ?>
    </select>
    <?= $Page->lead_status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->lead_status->getErrorMessage() ?></div>
<?= $Page->lead_status->Lookup->getParamTag($Page, "p_x_lead_status") ?>
<?php if (!$Page->lead_status->IsNativeSelect) { ?>
<script>
loadjs.ready("frequest2add", function() {
    var options = { name: "x_lead_status", selectId: "frequest2add_x_lead_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequest2add.lists.lead_status?.lookupOptions.length) {
        options.data = { id: "x_lead_status", form: "frequest2add" };
    } else {
        options.ajax = { id: "x_lead_status", form: "frequest2add", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.request2.fields.lead_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_by->Visible) { // lead_by ?>
    <div id="r_lead_by"<?= $Page->lead_by->rowAttributes() ?>>
        <label id="elh_request2_lead_by" for="x_lead_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_by->caption() ?><?= $Page->lead_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_by->cellAttributes() ?>>
<span id="el_request2_lead_by">
<input type="<?= $Page->lead_by->getInputTextType() ?>" name="x_lead_by" id="x_lead_by" data-table="request2" data-field="x_lead_by" value="<?= $Page->lead_by->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Page->lead_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_by->formatPattern()) ?>"<?= $Page->lead_by->editAttributes() ?> aria-describedby="x_lead_by_help">
<?= $Page->lead_by->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lead_by->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->subject->Visible) { // subject ?>
    <div id="r_subject"<?= $Page->subject->rowAttributes() ?>>
        <label id="elh_request2_subject" for="x_subject" class="<?= $Page->LeftColumnClass ?>"><?= $Page->subject->caption() ?><?= $Page->subject->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->subject->cellAttributes() ?>>
<span id="el_request2_subject">
<textarea data-table="request2" data-field="x_subject" name="x_subject" id="x_subject" cols="50" rows="2" placeholder="<?= HtmlEncode($Page->subject->getPlaceHolder()) ?>"<?= $Page->subject->editAttributes() ?> aria-describedby="x_subject_help"><?= $Page->subject->EditValue ?></textarea>
<?= $Page->subject->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->subject->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_message->Visible) { // message ?>
    <div id="r__message"<?= $Page->_message->rowAttributes() ?>>
        <label id="elh_request2__message" for="x__message" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_message->caption() ?><?= $Page->_message->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_message->cellAttributes() ?>>
<span id="el_request2__message">
<textarea data-table="request2" data-field="x__message" name="x__message" id="x__message" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_message->getPlaceHolder()) ?>"<?= $Page->_message->editAttributes() ?> aria-describedby="x__message_help"><?= $Page->_message->EditValue ?></textarea>
<?= $Page->_message->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_message->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->alert->Visible) { // alert ?>
    <div id="r_alert"<?= $Page->alert->rowAttributes() ?>>
        <label id="elh_request2_alert" for="x_alert" class="<?= $Page->LeftColumnClass ?>"><?= $Page->alert->caption() ?><?= $Page->alert->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->alert->cellAttributes() ?>>
<span id="el_request2_alert">
<input type="<?= $Page->alert->getInputTextType() ?>" name="x_alert" id="x_alert" data-table="request2" data-field="x_alert" value="<?= $Page->alert->EditValue ?>" placeholder="<?= HtmlEncode($Page->alert->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->alert->formatPattern()) ?>"<?= $Page->alert->editAttributes() ?> aria-describedby="x_alert_help">
<?= $Page->alert->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->alert->getErrorMessage() ?></div>
<?php if (!$Page->alert->ReadOnly && !$Page->alert->Disabled && !isset($Page->alert->EditAttrs["readonly"]) && !isset($Page->alert->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frequest2add", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frequest2add", "x_alert", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_request2_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_request2_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="request2"
        data-field="x_uploads"
        data-size="500"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference"<?= $Page->reference->rowAttributes() ?>>
        <label id="elh_request2_reference" for="x_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference->caption() ?><?= $Page->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference->cellAttributes() ?>>
<span id="el_request2_reference">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="request2" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?> aria-describedby="x_reference_help">
<?= $Page->reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frequest2add"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frequest2add" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("request2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var type = $("#x_type").val();
    		document.cookie = "type="+type+";path=/";
    		if (type == 0)
    		{
    			$("#r_lead_type").show();
    			$("#r_lead_status").show();
    			$("#r_lead_by").show();
    		}
    		else if (type == 2)
    		{
    			$("#r_lead_type").hide();
    			$("#r_lead_status").hide();
    			$("#r_lead_by").show();
    		}
    		else if (type == 1)
    		{
    			$("#r_lead_type").hide();
    			$("#r_lead_status").hide();
    			$("#r_lead_by").hide();
    		}
    		else if (type == 99)
    		{
    			$("#r_lead_type").hide();
    			$("#r_lead_status").hide();
    			$("#r_lead_by").hide();
    			$("#r_alert").hide();
    			if (getURL('type') != 99)
    				$("#x_type").val('');			
    		}
    		var getrequest = getURL('ref')
    		if (getrequest > 0)
    		{
    			$.getJSON(window.location.origin +'/apcajax2?getrequest='+getrequest,function(data){
    				$('#el_request2__message').append('<span id="error1">'+data+'</span>');
    			});
    		};
});
</script>
