<?php

namespace PHPMaker2024\fibre;

// Page object
$RentalPoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { rental_po: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var frental_posearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frental_posearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["programme_datetime", [ew.Validators.datetime(fields.programme_datetime.clientFormatPattern)], fields.programme_datetime.isInvalid],
            ["programme_end_datetime", [ew.Validators.datetime(fields.programme_end_datetime.clientFormatPattern)], fields.programme_end_datetime.isInvalid],
            ["y_programme_end_datetime", [ew.Validators.between], false],
            ["location", [], fields.location.isInvalid],
            ["contact_person", [], fields.contact_person.isInvalid],
            ["amount", [], fields.amount.isInvalid],
            ["booking_ref", [], fields.booking_ref.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["buyer_instruction", [], fields.buyer_instruction.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["gst", [], fields.gst.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["description_01", [], fields.description_01.isInvalid],
            ["description_02", [], fields.description_02.isInvalid],
            ["description_03", [], fields.description_03.isInvalid],
            ["description_04", [], fields.description_04.isInvalid],
            ["description_05", [], fields.description_05.isInvalid],
            ["description_06", [], fields.description_06.isInvalid],
            ["description_07", [], fields.description_07.isInvalid],
            ["description_08", [], fields.description_08.isInvalid],
            ["description_09", [], fields.description_09.isInvalid],
            ["description_10", [], fields.description_10.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "contact_person": <?= $Page->contact_person->toClientList($Page) ?>,
            "booking_ref": <?= $Page->booking_ref->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "gst": <?= $Page->gst->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "description_01": <?= $Page->description_01->toClientList($Page) ?>,
            "description_02": <?= $Page->description_02->toClientList($Page) ?>,
            "description_03": <?= $Page->description_03->toClientList($Page) ?>,
            "description_04": <?= $Page->description_04->toClientList($Page) ?>,
            "description_05": <?= $Page->description_05->toClientList($Page) ?>,
            "description_06": <?= $Page->description_06->toClientList($Page) ?>,
            "description_07": <?= $Page->description_07->toClientList($Page) ?>,
            "description_08": <?= $Page->description_08->toClientList($Page) ?>,
            "description_09": <?= $Page->description_09->toClientList($Page) ?>,
            "description_10": <?= $Page->description_10->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frental_posearch" id="frental_posearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="rental_po">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="rental_po" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->programme_datetime->Visible) { // programme_datetime ?>
    <div id="r_programme_datetime" class="row"<?= $Page->programme_datetime->rowAttributes() ?>>
        <label for="x_programme_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_programme_datetime"><?= $Page->programme_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_programme_datetime" id="z_programme_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->programme_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_programme_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->programme_datetime->getInputTextType() ?>" name="x_programme_datetime" id="x_programme_datetime" data-table="rental_po" data-field="x_programme_datetime" value="<?= $Page->programme_datetime->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->programme_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->programme_datetime->formatPattern()) ?>"<?= $Page->programme_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->programme_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->programme_datetime->ReadOnly && !$Page->programme_datetime->Disabled && !isset($Page->programme_datetime->EditAttrs["readonly"]) && !isset($Page->programme_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frental_posearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frental_posearch", "x_programme_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->programme_end_datetime->Visible) { // programme_end_datetime ?>
    <div id="r_programme_end_datetime" class="row"<?= $Page->programme_end_datetime->rowAttributes() ?>>
        <label for="x_programme_end_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_programme_end_datetime"><?= $Page->programme_end_datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->programme_end_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_programme_end_datetime" id="z_programme_end_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->programme_end_datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->programme_end_datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_rental_po_programme_end_datetime" class="ew-search-field">
<input type="<?= $Page->programme_end_datetime->getInputTextType() ?>" name="x_programme_end_datetime" id="x_programme_end_datetime" data-table="rental_po" data-field="x_programme_end_datetime" value="<?= $Page->programme_end_datetime->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->programme_end_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->programme_end_datetime->formatPattern()) ?>"<?= $Page->programme_end_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->programme_end_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->programme_end_datetime->ReadOnly && !$Page->programme_end_datetime->Disabled && !isset($Page->programme_end_datetime->EditAttrs["readonly"]) && !isset($Page->programme_end_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frental_posearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frental_posearch", "x_programme_end_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_rental_po_programme_end_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->programme_end_datetime->getInputTextType() ?>" name="y_programme_end_datetime" id="y_programme_end_datetime" data-table="rental_po" data-field="x_programme_end_datetime" value="<?= $Page->programme_end_datetime->EditValue2 ?>" data-page="0" placeholder="<?= HtmlEncode($Page->programme_end_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->programme_end_datetime->formatPattern()) ?>"<?= $Page->programme_end_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->programme_end_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->programme_end_datetime->ReadOnly && !$Page->programme_end_datetime->Disabled && !isset($Page->programme_end_datetime->EditAttrs["readonly"]) && !isset($Page->programme_end_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frental_posearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frental_posearch", "y_programme_end_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_location" id="z_location" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_location" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->location->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_location" class="ew-auto-suggest">
    <input type="<?= $Page->location->getInputTextType() ?>" class="form-control" name="sv_x_location" id="sv_x_location" value="<?= RemoveHtml($Page->location->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_location" data-input="sv_x_location" data-page="0" data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frental_posearch", function() {
    frental_posearch.createAutoSuggest(Object.assign({"id":"x_location","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->location->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.location.autoSuggestOptions));
});
</script>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_location_1" name="v_location" value="AND"<?= ($Page->location->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_location_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_location_2" name="v_location" value="OR"<?= ($Page->location->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_location_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_location" id="w_location" value="=">
</span>
                    <span id="el2_rental_po_location" class="ew-search-field2">
<?php
if (IsRTL()) {
    $Page->location->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_location" class="ew-auto-suggest">
    <input type="<?= $Page->location->getInputTextType() ?>" class="form-control" name="sv_y_location" id="sv_y_location" value="<?= RemoveHtml($Page->location->EditValue2) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_location" data-input="sv_y_location" data-page="0" data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>" name="y_location" id="y_location" value="<?= HtmlEncode($Page->location->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frental_posearch", function() {
    frental_posearch.createAutoSuggest(Object.assign({"id":"y_location","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->location->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.location.autoSuggestOptions));
});
</script>
<?= $Page->location->Lookup->getParamTag($Page, "p_y_location") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->contact_person->Visible) { // contact_person ?>
    <div id="r_contact_person" class="row"<?= $Page->contact_person->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_contact_person"><?= $Page->contact_person->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_contact_person" id="z_contact_person" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->contact_person->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_contact_person" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->contact_person->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_contact_person" class="ew-auto-suggest">
    <input type="<?= $Page->contact_person->getInputTextType() ?>" class="form-control" name="sv_x_contact_person" id="sv_x_contact_person" value="<?= RemoveHtml($Page->contact_person->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->contact_person->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->contact_person->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->contact_person->formatPattern()) ?>"<?= $Page->contact_person->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_contact_person" data-input="sv_x_contact_person" data-page="0" data-value-separator="<?= $Page->contact_person->displayValueSeparatorAttribute() ?>" name="x_contact_person" id="x_contact_person" value="<?= HtmlEncode($Page->contact_person->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->contact_person->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frental_posearch", function() {
    frental_posearch.createAutoSuggest(Object.assign({"id":"x_contact_person","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->contact_person->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.contact_person.autoSuggestOptions));
});
</script>
<?= $Page->contact_person->Lookup->getParamTag($Page, "p_x_contact_person") ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_contact_person_1" name="v_contact_person" value="AND"<?= ($Page->contact_person->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_contact_person_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_contact_person_2" name="v_contact_person" value="OR"<?= ($Page->contact_person->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_contact_person_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_contact_person" id="w_contact_person" value="=">
</span>
                    <span id="el2_rental_po_contact_person" class="ew-search-field2">
<?php
if (IsRTL()) {
    $Page->contact_person->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_contact_person" class="ew-auto-suggest">
    <input type="<?= $Page->contact_person->getInputTextType() ?>" class="form-control" name="sv_y_contact_person" id="sv_y_contact_person" value="<?= RemoveHtml($Page->contact_person->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->contact_person->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->contact_person->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->contact_person->formatPattern()) ?>"<?= $Page->contact_person->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_contact_person" data-input="sv_y_contact_person" data-page="0" data-value-separator="<?= $Page->contact_person->displayValueSeparatorAttribute() ?>" name="y_contact_person" id="y_contact_person" value="<?= HtmlEncode($Page->contact_person->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->contact_person->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frental_posearch", function() {
    frental_posearch.createAutoSuggest(Object.assign({"id":"y_contact_person","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->contact_person->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.contact_person.autoSuggestOptions));
});
</script>
<?= $Page->contact_person->Lookup->getParamTag($Page, "p_y_contact_person") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="rental_po" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="0" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_ref->Visible) { // booking_ref ?>
    <div id="r_booking_ref" class="row"<?= $Page->booking_ref->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_booking_ref"><?= $Page->booking_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_booking_ref" id="z_booking_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_booking_ref" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->booking_ref->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_booking_ref" class="ew-auto-suggest">
    <input type="<?= $Page->booking_ref->getInputTextType() ?>" class="form-control" name="sv_x_booking_ref" id="sv_x_booking_ref" value="<?= RemoveHtml($Page->booking_ref->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_ref->formatPattern()) ?>"<?= $Page->booking_ref->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_booking_ref" data-input="sv_x_booking_ref" data-page="0" data-value-separator="<?= $Page->booking_ref->displayValueSeparatorAttribute() ?>" name="x_booking_ref" id="x_booking_ref" value="<?= HtmlEncode($Page->booking_ref->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->booking_ref->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frental_posearch", function() {
    frental_posearch.createAutoSuggest(Object.assign({"id":"x_booking_ref","forceSelect":false,"minWidth":"640px","maxHeight":"640px"}, { lookupAllDisplayFields: <?= $Page->booking_ref->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.booking_ref.autoSuggestOptions));
});
</script>
<?= $Page->booking_ref->Lookup->getParamTag($Page, "p_x_booking_ref") ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_booking_ref_1" name="v_booking_ref" value="AND"<?= ($Page->booking_ref->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_booking_ref_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_booking_ref_2" name="v_booking_ref" value="OR"<?= ($Page->booking_ref->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_booking_ref_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_booking_ref" id="w_booking_ref" value="=">
</span>
                    <span id="el2_rental_po_booking_ref" class="ew-search-field2">
<?php
if (IsRTL()) {
    $Page->booking_ref->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_booking_ref" class="ew-auto-suggest">
    <input type="<?= $Page->booking_ref->getInputTextType() ?>" class="form-control" name="sv_y_booking_ref" id="sv_y_booking_ref" value="<?= RemoveHtml($Page->booking_ref->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_ref->formatPattern()) ?>"<?= $Page->booking_ref->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_booking_ref" data-input="sv_y_booking_ref" data-page="0" data-value-separator="<?= $Page->booking_ref->displayValueSeparatorAttribute() ?>" name="y_booking_ref" id="y_booking_ref" value="<?= HtmlEncode($Page->booking_ref->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->booking_ref->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frental_posearch", function() {
    frental_posearch.createAutoSuggest(Object.assign({"id":"y_booking_ref","forceSelect":false,"minWidth":"640px","maxHeight":"640px"}, { lookupAllDisplayFields: <?= $Page->booking_ref->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.booking_ref.autoSuggestOptions));
});
</script>
<?= $Page->booking_ref->Lookup->getParamTag($Page, "p_y_booking_ref") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="frental_posearch_x_company_id"
        data-table="rental_po"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("frental_posearch", function() {
    var options = { name: "x_company_id", selectId: "frental_posearch_x_company_id" };
    if (frental_posearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "frental_posearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "frental_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.rental_po.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="frental_posearch_x_type"
        <?php } ?>
        data-table="rental_po"
        data-field="x_type"
        data-page="0"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("frental_posearch", function() {
    var options = { name: "x_type", selectId: "frental_posearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frental_posearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "frental_posearch" };
    } else {
        options.ajax = { id: "x_type", form: "frental_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.rental_po.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="frental_posearch_x_reports_to"
        <?php } ?>
        data-table="rental_po"
        data-field="x_reports_to"
        data-page="0"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("frental_posearch", function() {
    var options = { name: "x_reports_to", selectId: "frental_posearch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frental_posearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "frental_posearch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "frental_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.rental_po.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_RentalPoSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_rental_po1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_rental_po1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->description_01->Visible) { // description_01 ?>
    <div id="r_description_01" class="row"<?= $Page->description_01->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_01"><?= $Page->description_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_01" id="z_description_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_01" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_01">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_01" name="x_description_01" id="x_description_01"<?= $Page->description_01->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_01" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_01[]"
    name="x_description_01[]"
    value="<?= HtmlEncode($Page->description_01->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_01"
    data-target="dsl_x_description_01"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_01->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_01"
    data-page="1"
    data-value-separator="<?= $Page->description_01->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_01->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_01->getErrorMessage(false) ?></div>
<?= $Page->description_01->Lookup->getParamTag($Page, "p_x_description_01") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_02->Visible) { // description_02 ?>
    <div id="r_description_02" class="row"<?= $Page->description_02->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_02"><?= $Page->description_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_02" id="z_description_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_02" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_02">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_02" name="x_description_02" id="x_description_02"<?= $Page->description_02->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_02" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_02[]"
    name="x_description_02[]"
    value="<?= HtmlEncode($Page->description_02->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_02"
    data-target="dsl_x_description_02"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_02->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_02"
    data-page="1"
    data-value-separator="<?= $Page->description_02->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_02->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_02->getErrorMessage(false) ?></div>
<?= $Page->description_02->Lookup->getParamTag($Page, "p_x_description_02") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_03->Visible) { // description_03 ?>
    <div id="r_description_03" class="row"<?= $Page->description_03->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_03"><?= $Page->description_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_03" id="z_description_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_03" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_03">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_03" name="x_description_03" id="x_description_03"<?= $Page->description_03->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_03" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_03[]"
    name="x_description_03[]"
    value="<?= HtmlEncode($Page->description_03->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_03"
    data-target="dsl_x_description_03"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_03->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_03"
    data-page="1"
    data-value-separator="<?= $Page->description_03->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_03->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_03->getErrorMessage(false) ?></div>
<?= $Page->description_03->Lookup->getParamTag($Page, "p_x_description_03") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_04->Visible) { // description_04 ?>
    <div id="r_description_04" class="row"<?= $Page->description_04->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_04"><?= $Page->description_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_04" id="z_description_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_04" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_04">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_04" name="x_description_04" id="x_description_04"<?= $Page->description_04->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_04" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_04[]"
    name="x_description_04[]"
    value="<?= HtmlEncode($Page->description_04->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_04"
    data-target="dsl_x_description_04"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_04->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_04"
    data-page="1"
    data-value-separator="<?= $Page->description_04->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_04->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_04->getErrorMessage(false) ?></div>
<?= $Page->description_04->Lookup->getParamTag($Page, "p_x_description_04") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_05->Visible) { // description_05 ?>
    <div id="r_description_05" class="row"<?= $Page->description_05->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_05"><?= $Page->description_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_05" id="z_description_05" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_05" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_05">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_05" name="x_description_05" id="x_description_05"<?= $Page->description_05->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_05" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_05[]"
    name="x_description_05[]"
    value="<?= HtmlEncode($Page->description_05->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_05"
    data-target="dsl_x_description_05"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_05->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_05"
    data-page="1"
    data-value-separator="<?= $Page->description_05->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_05->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_05->getErrorMessage(false) ?></div>
<?= $Page->description_05->Lookup->getParamTag($Page, "p_x_description_05") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_06->Visible) { // description_06 ?>
    <div id="r_description_06" class="row"<?= $Page->description_06->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_06"><?= $Page->description_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_06" id="z_description_06" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_06" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_06">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_06" name="x_description_06" id="x_description_06"<?= $Page->description_06->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_06" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_06[]"
    name="x_description_06[]"
    value="<?= HtmlEncode($Page->description_06->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_06"
    data-target="dsl_x_description_06"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_06->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_06"
    data-page="1"
    data-value-separator="<?= $Page->description_06->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_06->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_06->getErrorMessage(false) ?></div>
<?= $Page->description_06->Lookup->getParamTag($Page, "p_x_description_06") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_07->Visible) { // description_07 ?>
    <div id="r_description_07" class="row"<?= $Page->description_07->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_07"><?= $Page->description_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_07" id="z_description_07" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_07" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_07">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_07" name="x_description_07" id="x_description_07"<?= $Page->description_07->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_07" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_07[]"
    name="x_description_07[]"
    value="<?= HtmlEncode($Page->description_07->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_07"
    data-target="dsl_x_description_07"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_07->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_07"
    data-page="1"
    data-value-separator="<?= $Page->description_07->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_07->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_07->getErrorMessage(false) ?></div>
<?= $Page->description_07->Lookup->getParamTag($Page, "p_x_description_07") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_08->Visible) { // description_08 ?>
    <div id="r_description_08" class="row"<?= $Page->description_08->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_08"><?= $Page->description_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_08" id="z_description_08" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_08" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_08">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_08" name="x_description_08" id="x_description_08"<?= $Page->description_08->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_08" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_08[]"
    name="x_description_08[]"
    value="<?= HtmlEncode($Page->description_08->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_08"
    data-target="dsl_x_description_08"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_08->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_08"
    data-page="1"
    data-value-separator="<?= $Page->description_08->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_08->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_08->getErrorMessage(false) ?></div>
<?= $Page->description_08->Lookup->getParamTag($Page, "p_x_description_08") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_09->Visible) { // description_09 ?>
    <div id="r_description_09" class="row"<?= $Page->description_09->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_09"><?= $Page->description_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_09" id="z_description_09" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_09" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_09">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_09" name="x_description_09" id="x_description_09"<?= $Page->description_09->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_09" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_09[]"
    name="x_description_09[]"
    value="<?= HtmlEncode($Page->description_09->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_09"
    data-target="dsl_x_description_09"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_09->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_09"
    data-page="1"
    data-value-separator="<?= $Page->description_09->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_09->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_09->getErrorMessage(false) ?></div>
<?= $Page->description_09->Lookup->getParamTag($Page, "p_x_description_09") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->description_10->Visible) { // description_10 ?>
    <div id="r_description_10" class="row"<?= $Page->description_10->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_description_10"><?= $Page->description_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_description_10" id="z_description_10" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->description_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_description_10" class="ew-search-field ew-search-field-single">
<template id="tp_x_description_10">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_10" name="x_description_10" id="x_description_10"<?= $Page->description_10->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_10" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_10[]"
    name="x_description_10[]"
    value="<?= HtmlEncode($Page->description_10->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_10"
    data-target="dsl_x_description_10"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_10->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_10"
    data-page="1"
    data-value-separator="<?= $Page->description_10->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_10->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->description_10->getErrorMessage(false) ?></div>
<?= $Page->description_10->Lookup->getParamTag($Page, "p_x_description_10") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_rental_po2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_rental_po2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->buyer_instruction->Visible) { // buyer_instruction ?>
    <div id="r_buyer_instruction" class="row"<?= $Page->buyer_instruction->rowAttributes() ?>>
        <label for="x_buyer_instruction" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_buyer_instruction"><?= $Page->buyer_instruction->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_instruction" id="z_buyer_instruction" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_instruction->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_buyer_instruction" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_instruction->getInputTextType() ?>" name="x_buyer_instruction" id="x_buyer_instruction" data-table="rental_po" data-field="x_buyer_instruction" value="<?= $Page->buyer_instruction->EditValue ?>" data-page="2" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->buyer_instruction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_instruction->formatPattern()) ?>"<?= $Page->buyer_instruction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_instruction->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="rental_po" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" data-page="2" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst" class="row"<?= $Page->gst->rowAttributes() ?>>
        <label for="x_gst" class="<?= $Page->LeftColumnClass ?>"><span id="elh_rental_po_gst"><?= $Page->gst->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gst" id="z_gst" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gst->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_rental_po_gst" class="ew-search-field ew-search-field-single">
    <select
        id="x_gst"
        name="x_gst"
        class="form-select ew-select<?= $Page->gst->isInvalidClass() ?>"
        <?php if (!$Page->gst->IsNativeSelect) { ?>
        data-select2-id="frental_posearch_x_gst"
        <?php } ?>
        data-table="rental_po"
        data-field="x_gst"
        data-page="2"
        data-value-separator="<?= $Page->gst->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>"
        <?= $Page->gst->editAttributes() ?>>
        <?= $Page->gst->selectOptionListHtml("x_gst") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gst->getErrorMessage(false) ?></div>
<?= $Page->gst->Lookup->getParamTag($Page, "p_x_gst") ?>
<?php if (!$Page->gst->IsNativeSelect) { ?>
<script>
loadjs.ready("frental_posearch", function() {
    var options = { name: "x_gst", selectId: "frental_posearch_x_gst" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frental_posearch.lists.gst?.lookupOptions.length) {
        options.data = { id: "x_gst", form: "frental_posearch" };
    } else {
        options.ajax = { id: "x_gst", form: "frental_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.rental_po.fields.gst.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frental_posearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frental_posearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="frental_posearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("rental_po");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
