<?php

namespace PHPMaker2024\fibre;

// Page object
$RentalPoAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { rental_po: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var frental_poadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("frental_poadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["programme_datetime", [fields.programme_datetime.visible && fields.programme_datetime.required ? ew.Validators.required(fields.programme_datetime.caption) : null, ew.Validators.datetime(fields.programme_datetime.clientFormatPattern)], fields.programme_datetime.isInvalid],
            ["programme_end_datetime", [fields.programme_end_datetime.visible && fields.programme_end_datetime.required ? ew.Validators.required(fields.programme_end_datetime.caption) : null, ew.Validators.datetime(fields.programme_end_datetime.clientFormatPattern)], fields.programme_end_datetime.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["item", [fields.item.visible && fields.item.required ? ew.Validators.required(fields.item.caption) : null], fields.item.isInvalid],
            ["contact_person", [fields.contact_person.visible && fields.contact_person.required ? ew.Validators.required(fields.contact_person.caption) : null], fields.contact_person.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null], fields.amount.isInvalid],
            ["booking_ref", [fields.booking_ref.visible && fields.booking_ref.required ? ew.Validators.required(fields.booking_ref.caption) : null], fields.booking_ref.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["payment_terms", [fields.payment_terms.visible && fields.payment_terms.required ? ew.Validators.required(fields.payment_terms.caption) : null], fields.payment_terms.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["buyer_instruction", [fields.buyer_instruction.visible && fields.buyer_instruction.required ? ew.Validators.required(fields.buyer_instruction.caption) : null], fields.buyer_instruction.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["eastimated_amount", [fields.eastimated_amount.visible && fields.eastimated_amount.required ? ew.Validators.required(fields.eastimated_amount.caption) : null], fields.eastimated_amount.isInvalid],
            ["gst", [fields.gst.visible && fields.gst.required ? ew.Validators.required(fields.gst.caption) : null], fields.gst.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["description_01", [fields.description_01.visible && fields.description_01.required ? ew.Validators.required(fields.description_01.caption) : null], fields.description_01.isInvalid],
            ["description_02", [fields.description_02.visible && fields.description_02.required ? ew.Validators.required(fields.description_02.caption) : null], fields.description_02.isInvalid],
            ["description_03", [fields.description_03.visible && fields.description_03.required ? ew.Validators.required(fields.description_03.caption) : null], fields.description_03.isInvalid],
            ["description_04", [fields.description_04.visible && fields.description_04.required ? ew.Validators.required(fields.description_04.caption) : null], fields.description_04.isInvalid],
            ["description_05", [fields.description_05.visible && fields.description_05.required ? ew.Validators.required(fields.description_05.caption) : null], fields.description_05.isInvalid],
            ["description_06", [fields.description_06.visible && fields.description_06.required ? ew.Validators.required(fields.description_06.caption) : null], fields.description_06.isInvalid],
            ["description_07", [fields.description_07.visible && fields.description_07.required ? ew.Validators.required(fields.description_07.caption) : null], fields.description_07.isInvalid],
            ["description_08", [fields.description_08.visible && fields.description_08.required ? ew.Validators.required(fields.description_08.caption) : null], fields.description_08.isInvalid],
            ["description_09", [fields.description_09.visible && fields.description_09.required ? ew.Validators.required(fields.description_09.caption) : null], fields.description_09.isInvalid],
            ["description_10", [fields.description_10.visible && fields.description_10.required ? ew.Validators.required(fields.description_10.caption) : null], fields.description_10.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Multi-Page
        .setMultiPage(true)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "item": <?= $Page->item->toClientList($Page) ?>,
            "contact_person": <?= $Page->contact_person->toClientList($Page) ?>,
            "booking_ref": <?= $Page->booking_ref->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "payment_terms": <?= $Page->payment_terms->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "gst": <?= $Page->gst->toClientList($Page) ?>,
            "description_01": <?= $Page->description_01->toClientList($Page) ?>,
            "description_02": <?= $Page->description_02->toClientList($Page) ?>,
            "description_03": <?= $Page->description_03->toClientList($Page) ?>,
            "description_04": <?= $Page->description_04->toClientList($Page) ?>,
            "description_05": <?= $Page->description_05->toClientList($Page) ?>,
            "description_06": <?= $Page->description_06->toClientList($Page) ?>,
            "description_07": <?= $Page->description_07->toClientList($Page) ?>,
            "description_08": <?= $Page->description_08->toClientList($Page) ?>,
            "description_09": <?= $Page->description_09->toClientList($Page) ?>,
            "description_10": <?= $Page->description_10->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frental_poadd" id="frental_poadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="rental_po">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($Page->programme_datetime->Visible) { // programme_datetime ?>
    <div id="r_programme_datetime"<?= $Page->programme_datetime->rowAttributes() ?>>
        <label id="elh_rental_po_programme_datetime" for="x_programme_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->programme_datetime->caption() ?><?= $Page->programme_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->programme_datetime->cellAttributes() ?>>
<span id="el_rental_po_programme_datetime">
<input type="<?= $Page->programme_datetime->getInputTextType() ?>" name="x_programme_datetime" id="x_programme_datetime" data-table="rental_po" data-field="x_programme_datetime" value="<?= $Page->programme_datetime->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->programme_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->programme_datetime->formatPattern()) ?>"<?= $Page->programme_datetime->editAttributes() ?> aria-describedby="x_programme_datetime_help">
<?= $Page->programme_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->programme_datetime->getErrorMessage() ?></div>
<?php if (!$Page->programme_datetime->ReadOnly && !$Page->programme_datetime->Disabled && !isset($Page->programme_datetime->EditAttrs["readonly"]) && !isset($Page->programme_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frental_poadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frental_poadd", "x_programme_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->programme_end_datetime->Visible) { // programme_end_datetime ?>
    <div id="r_programme_end_datetime"<?= $Page->programme_end_datetime->rowAttributes() ?>>
        <label id="elh_rental_po_programme_end_datetime" for="x_programme_end_datetime" class="<?= $Page->LeftColumnClass ?>"><?= $Page->programme_end_datetime->caption() ?><?= $Page->programme_end_datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->programme_end_datetime->cellAttributes() ?>>
<span id="el_rental_po_programme_end_datetime">
<input type="<?= $Page->programme_end_datetime->getInputTextType() ?>" name="x_programme_end_datetime" id="x_programme_end_datetime" data-table="rental_po" data-field="x_programme_end_datetime" value="<?= $Page->programme_end_datetime->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->programme_end_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->programme_end_datetime->formatPattern()) ?>"<?= $Page->programme_end_datetime->editAttributes() ?> aria-describedby="x_programme_end_datetime_help">
<?= $Page->programme_end_datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->programme_end_datetime->getErrorMessage() ?></div>
<?php if (!$Page->programme_end_datetime->ReadOnly && !$Page->programme_end_datetime->Disabled && !isset($Page->programme_end_datetime->EditAttrs["readonly"]) && !isset($Page->programme_end_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["frental_poadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("frental_poadd", "x_programme_end_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_rental_po_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_rental_po_location">
<?php
if (IsRTL()) {
    $Page->location->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_location" class="ew-auto-suggest">
    <input type="<?= $Page->location->getInputTextType() ?>" class="form-control" name="sv_x_location" id="sv_x_location" value="<?= RemoveHtml($Page->location->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->location->formatPattern()) ?>"<?= $Page->location->editAttributes() ?> aria-describedby="x_location_help">
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_location" data-input="sv_x_location" data-page="0" data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>" name="x_location" id="x_location" value="<?= HtmlEncode($Page->location->CurrentValue) ?>"></selection-list>
<?= $Page->location->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<script>
loadjs.ready("frental_poadd", function() {
    frental_poadd.createAutoSuggest(Object.assign({"id":"x_location","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->location->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.location.autoSuggestOptions));
});
</script>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item"<?= $Page->item->rowAttributes() ?>>
        <label id="elh_rental_po_item" class="<?= $Page->LeftColumnClass ?>"><?= $Page->item->caption() ?><?= $Page->item->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->item->cellAttributes() ?>>
<span id="el_rental_po_item">
<?php
if (IsRTL()) {
    $Page->item->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_item" class="ew-auto-suggest">
    <input type="<?= $Page->item->getInputTextType() ?>" class="form-control" name="sv_x_item" id="sv_x_item" value="<?= RemoveHtml($Page->item->EditValue) ?>" autocomplete="off" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?> aria-describedby="x_item_help">
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_item" data-input="sv_x_item" data-page="0" data-value-separator="<?= $Page->item->displayValueSeparatorAttribute() ?>" name="x_item" id="x_item" value="<?= HtmlEncode($Page->item->CurrentValue) ?>"></selection-list>
<?= $Page->item->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage() ?></div>
<script>
loadjs.ready("frental_poadd", function() {
    frental_poadd.createAutoSuggest(Object.assign({"id":"x_item","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->item->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.item.autoSuggestOptions));
});
</script>
<?= $Page->item->Lookup->getParamTag($Page, "p_x_item") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->contact_person->Visible) { // contact_person ?>
    <div id="r_contact_person"<?= $Page->contact_person->rowAttributes() ?>>
        <label id="elh_rental_po_contact_person" class="<?= $Page->LeftColumnClass ?>"><?= $Page->contact_person->caption() ?><?= $Page->contact_person->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->contact_person->cellAttributes() ?>>
<span id="el_rental_po_contact_person">
<?php
if (IsRTL()) {
    $Page->contact_person->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_contact_person" class="ew-auto-suggest">
    <input type="<?= $Page->contact_person->getInputTextType() ?>" class="form-control" name="sv_x_contact_person" id="sv_x_contact_person" value="<?= RemoveHtml($Page->contact_person->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->contact_person->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->contact_person->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->contact_person->formatPattern()) ?>"<?= $Page->contact_person->editAttributes() ?> aria-describedby="x_contact_person_help">
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_contact_person" data-input="sv_x_contact_person" data-page="0" data-value-separator="<?= $Page->contact_person->displayValueSeparatorAttribute() ?>" name="x_contact_person" id="x_contact_person" value="<?= HtmlEncode($Page->contact_person->CurrentValue) ?>"></selection-list>
<?= $Page->contact_person->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->contact_person->getErrorMessage() ?></div>
<script>
loadjs.ready("frental_poadd", function() {
    frental_poadd.createAutoSuggest(Object.assign({"id":"x_contact_person","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->contact_person->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.contact_person.autoSuggestOptions));
});
</script>
<?= $Page->contact_person->Lookup->getParamTag($Page, "p_x_contact_person") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_rental_po_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_rental_po_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="rental_po" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" data-page="0" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_ref->Visible) { // booking_ref ?>
    <div id="r_booking_ref"<?= $Page->booking_ref->rowAttributes() ?>>
        <label id="elh_rental_po_booking_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_ref->caption() ?><?= $Page->booking_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_ref->cellAttributes() ?>>
<span id="el_rental_po_booking_ref">
<?php
if (IsRTL()) {
    $Page->booking_ref->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_booking_ref" class="ew-auto-suggest">
    <input type="<?= $Page->booking_ref->getInputTextType() ?>" class="form-control" name="sv_x_booking_ref" id="sv_x_booking_ref" value="<?= RemoveHtml($Page->booking_ref->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->booking_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->booking_ref->formatPattern()) ?>"<?= $Page->booking_ref->editAttributes() ?> aria-describedby="x_booking_ref_help">
</span>
<selection-list hidden class="form-control" data-table="rental_po" data-field="x_booking_ref" data-input="sv_x_booking_ref" data-page="0" data-value-separator="<?= $Page->booking_ref->displayValueSeparatorAttribute() ?>" name="x_booking_ref" id="x_booking_ref" value="<?= HtmlEncode($Page->booking_ref->CurrentValue) ?>"></selection-list>
<?= $Page->booking_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->booking_ref->getErrorMessage() ?></div>
<script>
loadjs.ready("frental_poadd", function() {
    frental_poadd.createAutoSuggest(Object.assign({"id":"x_booking_ref","forceSelect":false,"minWidth":"640px","maxHeight":"640px"}, { lookupAllDisplayFields: <?= $Page->booking_ref->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.rental_po.fields.booking_ref.autoSuggestOptions));
});
</script>
<?= $Page->booking_ref->Lookup->getParamTag($Page, "p_x_booking_ref") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_rental_po_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_rental_po_company_id">
<div class="input-group flex-nowrap">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="frental_poadd_x_company_id"
        data-table="rental_po"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-page="0"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Page->company_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_company_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->company_id->caption() ?>" data-title="<?= $Page->company_id->caption() ?>" data-ew-action="add-option" data-el="x_company_id" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->company_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("frental_poadd", function() {
    var options = { name: "x_company_id", selectId: "frental_poadd_x_company_id" };
    if (frental_poadd.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "frental_poadd" };
    } else {
        options.ajax = { id: "x_company_id", form: "frental_poadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.rental_po.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms"<?= $Page->payment_terms->rowAttributes() ?>>
        <label id="elh_rental_po_payment_terms" for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->payment_terms->caption() ?><?= $Page->payment_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el_rental_po_payment_terms">
<div class="input-group flex-nowrap">
    <select
        id="x_payment_terms"
        name="x_payment_terms"
        class="form-select ew-select<?= $Page->payment_terms->isInvalidClass() ?>"
        <?php if (!$Page->payment_terms->IsNativeSelect) { ?>
        data-select2-id="frental_poadd_x_payment_terms"
        <?php } ?>
        data-table="rental_po"
        data-field="x_payment_terms"
        data-page="0"
        data-value-separator="<?= $Page->payment_terms->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>"
        <?= $Page->payment_terms->editAttributes() ?>>
        <?= $Page->payment_terms->selectOptionListHtml("x_payment_terms") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "misc") && !$Page->payment_terms->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_payment_terms" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->payment_terms->caption() ?>" data-title="<?= $Page->payment_terms->caption() ?>" data-ew-action="add-option" data-el="x_payment_terms" data-url="<?= GetUrl("miscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->payment_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage() ?></div>
<?= $Page->payment_terms->Lookup->getParamTag($Page, "p_x_payment_terms") ?>
<?php if (!$Page->payment_terms->IsNativeSelect) { ?>
<script>
loadjs.ready("frental_poadd", function() {
    var options = { name: "x_payment_terms", selectId: "frental_poadd_x_payment_terms" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frental_poadd.lists.payment_terms?.lookupOptions.length) {
        options.data = { id: "x_payment_terms", form: "frental_poadd" };
    } else {
        options.ajax = { id: "x_payment_terms", form: "frental_poadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.rental_po.fields.payment_terms.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_rental_po_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_rental_po_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="frental_poadd_x_type"
        <?php } ?>
        data-table="rental_po"
        data-field="x_type"
        data-page="0"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("frental_poadd", function() {
    var options = { name: "x_type", selectId: "frental_poadd_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frental_poadd.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "frental_poadd" };
    } else {
        options.ajax = { id: "x_type", form: "frental_poadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.rental_po.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_RentalPoAdd"><!-- multi-page accordion -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_rental_po1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_rental_po1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->description_01->Visible) { // description_01 ?>
    <div id="r_description_01"<?= $Page->description_01->rowAttributes() ?>>
        <label id="elh_rental_po_description_01" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_01->caption() ?><?= $Page->description_01->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_01->cellAttributes() ?>>
<span id="el_rental_po_description_01">
<template id="tp_x_description_01">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_01" name="x_description_01" id="x_description_01"<?= $Page->description_01->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_01" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_01[]"
    name="x_description_01[]"
    value="<?= HtmlEncode($Page->description_01->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_01"
    data-target="dsl_x_description_01"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_01->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_01"
    data-page="1"
    data-value-separator="<?= $Page->description_01->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_01->editAttributes() ?>></selection-list>
<?= $Page->description_01->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_01->getErrorMessage() ?></div>
<?= $Page->description_01->Lookup->getParamTag($Page, "p_x_description_01") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_02->Visible) { // description_02 ?>
    <div id="r_description_02"<?= $Page->description_02->rowAttributes() ?>>
        <label id="elh_rental_po_description_02" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_02->caption() ?><?= $Page->description_02->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_02->cellAttributes() ?>>
<span id="el_rental_po_description_02">
<template id="tp_x_description_02">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_02" name="x_description_02" id="x_description_02"<?= $Page->description_02->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_02" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_02[]"
    name="x_description_02[]"
    value="<?= HtmlEncode($Page->description_02->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_02"
    data-target="dsl_x_description_02"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_02->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_02"
    data-page="1"
    data-value-separator="<?= $Page->description_02->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_02->editAttributes() ?>></selection-list>
<?= $Page->description_02->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_02->getErrorMessage() ?></div>
<?= $Page->description_02->Lookup->getParamTag($Page, "p_x_description_02") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_03->Visible) { // description_03 ?>
    <div id="r_description_03"<?= $Page->description_03->rowAttributes() ?>>
        <label id="elh_rental_po_description_03" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_03->caption() ?><?= $Page->description_03->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_03->cellAttributes() ?>>
<span id="el_rental_po_description_03">
<template id="tp_x_description_03">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_03" name="x_description_03" id="x_description_03"<?= $Page->description_03->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_03" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_03[]"
    name="x_description_03[]"
    value="<?= HtmlEncode($Page->description_03->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_03"
    data-target="dsl_x_description_03"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_03->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_03"
    data-page="1"
    data-value-separator="<?= $Page->description_03->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_03->editAttributes() ?>></selection-list>
<?= $Page->description_03->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_03->getErrorMessage() ?></div>
<?= $Page->description_03->Lookup->getParamTag($Page, "p_x_description_03") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_04->Visible) { // description_04 ?>
    <div id="r_description_04"<?= $Page->description_04->rowAttributes() ?>>
        <label id="elh_rental_po_description_04" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_04->caption() ?><?= $Page->description_04->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_04->cellAttributes() ?>>
<span id="el_rental_po_description_04">
<template id="tp_x_description_04">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_04" name="x_description_04" id="x_description_04"<?= $Page->description_04->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_04" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_04[]"
    name="x_description_04[]"
    value="<?= HtmlEncode($Page->description_04->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_04"
    data-target="dsl_x_description_04"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_04->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_04"
    data-page="1"
    data-value-separator="<?= $Page->description_04->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_04->editAttributes() ?>></selection-list>
<?= $Page->description_04->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_04->getErrorMessage() ?></div>
<?= $Page->description_04->Lookup->getParamTag($Page, "p_x_description_04") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_05->Visible) { // description_05 ?>
    <div id="r_description_05"<?= $Page->description_05->rowAttributes() ?>>
        <label id="elh_rental_po_description_05" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_05->caption() ?><?= $Page->description_05->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_05->cellAttributes() ?>>
<span id="el_rental_po_description_05">
<template id="tp_x_description_05">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_05" name="x_description_05" id="x_description_05"<?= $Page->description_05->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_05" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_05[]"
    name="x_description_05[]"
    value="<?= HtmlEncode($Page->description_05->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_05"
    data-target="dsl_x_description_05"
    data-repeatcolumn="1"
    class="form-control<?= $Page->description_05->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_05"
    data-page="1"
    data-value-separator="<?= $Page->description_05->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_05->editAttributes() ?>></selection-list>
<?= $Page->description_05->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_05->getErrorMessage() ?></div>
<?= $Page->description_05->Lookup->getParamTag($Page, "p_x_description_05") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_06->Visible) { // description_06 ?>
    <div id="r_description_06"<?= $Page->description_06->rowAttributes() ?>>
        <label id="elh_rental_po_description_06" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_06->caption() ?><?= $Page->description_06->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_06->cellAttributes() ?>>
<span id="el_rental_po_description_06">
<template id="tp_x_description_06">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_06" name="x_description_06" id="x_description_06"<?= $Page->description_06->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_06" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_06[]"
    name="x_description_06[]"
    value="<?= HtmlEncode($Page->description_06->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_06"
    data-target="dsl_x_description_06"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_06->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_06"
    data-page="1"
    data-value-separator="<?= $Page->description_06->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_06->editAttributes() ?>></selection-list>
<?= $Page->description_06->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_06->getErrorMessage() ?></div>
<?= $Page->description_06->Lookup->getParamTag($Page, "p_x_description_06") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_07->Visible) { // description_07 ?>
    <div id="r_description_07"<?= $Page->description_07->rowAttributes() ?>>
        <label id="elh_rental_po_description_07" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_07->caption() ?><?= $Page->description_07->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_07->cellAttributes() ?>>
<span id="el_rental_po_description_07">
<template id="tp_x_description_07">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_07" name="x_description_07" id="x_description_07"<?= $Page->description_07->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_07" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_07[]"
    name="x_description_07[]"
    value="<?= HtmlEncode($Page->description_07->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_07"
    data-target="dsl_x_description_07"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_07->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_07"
    data-page="1"
    data-value-separator="<?= $Page->description_07->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_07->editAttributes() ?>></selection-list>
<?= $Page->description_07->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_07->getErrorMessage() ?></div>
<?= $Page->description_07->Lookup->getParamTag($Page, "p_x_description_07") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_08->Visible) { // description_08 ?>
    <div id="r_description_08"<?= $Page->description_08->rowAttributes() ?>>
        <label id="elh_rental_po_description_08" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_08->caption() ?><?= $Page->description_08->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_08->cellAttributes() ?>>
<span id="el_rental_po_description_08">
<template id="tp_x_description_08">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_08" name="x_description_08" id="x_description_08"<?= $Page->description_08->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_08" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_08[]"
    name="x_description_08[]"
    value="<?= HtmlEncode($Page->description_08->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_08"
    data-target="dsl_x_description_08"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_08->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_08"
    data-page="1"
    data-value-separator="<?= $Page->description_08->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_08->editAttributes() ?>></selection-list>
<?= $Page->description_08->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_08->getErrorMessage() ?></div>
<?= $Page->description_08->Lookup->getParamTag($Page, "p_x_description_08") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_09->Visible) { // description_09 ?>
    <div id="r_description_09"<?= $Page->description_09->rowAttributes() ?>>
        <label id="elh_rental_po_description_09" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_09->caption() ?><?= $Page->description_09->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_09->cellAttributes() ?>>
<span id="el_rental_po_description_09">
<template id="tp_x_description_09">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_09" name="x_description_09" id="x_description_09"<?= $Page->description_09->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_09" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_09[]"
    name="x_description_09[]"
    value="<?= HtmlEncode($Page->description_09->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_09"
    data-target="dsl_x_description_09"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_09->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_09"
    data-page="1"
    data-value-separator="<?= $Page->description_09->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_09->editAttributes() ?>></selection-list>
<?= $Page->description_09->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_09->getErrorMessage() ?></div>
<?= $Page->description_09->Lookup->getParamTag($Page, "p_x_description_09") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description_10->Visible) { // description_10 ?>
    <div id="r_description_10"<?= $Page->description_10->rowAttributes() ?>>
        <label id="elh_rental_po_description_10" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description_10->caption() ?><?= $Page->description_10->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description_10->cellAttributes() ?>>
<span id="el_rental_po_description_10">
<template id="tp_x_description_10">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="rental_po" data-field="x_description_10" name="x_description_10" id="x_description_10"<?= $Page->description_10->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_description_10" class="ew-item-list"></div>
<selection-list hidden
    id="x_description_10[]"
    name="x_description_10[]"
    value="<?= HtmlEncode($Page->description_10->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_description_10"
    data-target="dsl_x_description_10"
    data-repeatcolumn="5"
    class="form-control<?= $Page->description_10->isInvalidClass() ?>"
    data-table="rental_po"
    data-field="x_description_10"
    data-page="1"
    data-value-separator="<?= $Page->description_10->displayValueSeparatorAttribute() ?>"
    <?= $Page->description_10->editAttributes() ?>></selection-list>
<?= $Page->description_10->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->description_10->getErrorMessage() ?></div>
<?= $Page->description_10->Lookup->getParamTag($Page, "p_x_description_10") ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_rental_po2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_rental_po2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->buyer_instruction->Visible) { // buyer_instruction ?>
    <div id="r_buyer_instruction"<?= $Page->buyer_instruction->rowAttributes() ?>>
        <label id="elh_rental_po_buyer_instruction" for="x_buyer_instruction" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_instruction->caption() ?><?= $Page->buyer_instruction->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_instruction->cellAttributes() ?>>
<span id="el_rental_po_buyer_instruction">
<textarea data-table="rental_po" data-field="x_buyer_instruction" data-page="2" name="x_buyer_instruction" id="x_buyer_instruction" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->buyer_instruction->getPlaceHolder()) ?>"<?= $Page->buyer_instruction->editAttributes() ?> aria-describedby="x_buyer_instruction_help"><?= $Page->buyer_instruction->EditValue ?></textarea>
<?= $Page->buyer_instruction->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_instruction->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_rental_po_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_rental_po_remarks">
<textarea data-table="rental_po" data-field="x_remarks" data-page="2" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->eastimated_amount->Visible) { // eastimated_amount ?>
    <div id="r_eastimated_amount"<?= $Page->eastimated_amount->rowAttributes() ?>>
        <label id="elh_rental_po_eastimated_amount" for="x_eastimated_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->eastimated_amount->caption() ?><?= $Page->eastimated_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->eastimated_amount->cellAttributes() ?>>
<span id="el_rental_po_eastimated_amount">
<input type="<?= $Page->eastimated_amount->getInputTextType() ?>" name="x_eastimated_amount" id="x_eastimated_amount" data-table="rental_po" data-field="x_eastimated_amount" value="<?= $Page->eastimated_amount->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->eastimated_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->eastimated_amount->formatPattern()) ?>"<?= $Page->eastimated_amount->editAttributes() ?> aria-describedby="x_eastimated_amount_help">
<?= $Page->eastimated_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->eastimated_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gst->Visible) { // gst ?>
    <div id="r_gst"<?= $Page->gst->rowAttributes() ?>>
        <label id="elh_rental_po_gst" for="x_gst" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gst->caption() ?><?= $Page->gst->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gst->cellAttributes() ?>>
<span id="el_rental_po_gst">
    <select
        id="x_gst"
        name="x_gst"
        class="form-select ew-select<?= $Page->gst->isInvalidClass() ?>"
        <?php if (!$Page->gst->IsNativeSelect) { ?>
        data-select2-id="frental_poadd_x_gst"
        <?php } ?>
        data-table="rental_po"
        data-field="x_gst"
        data-page="2"
        data-value-separator="<?= $Page->gst->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gst->getPlaceHolder()) ?>"
        <?= $Page->gst->editAttributes() ?>>
        <?= $Page->gst->selectOptionListHtml("x_gst") ?>
    </select>
    <?= $Page->gst->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->gst->getErrorMessage() ?></div>
<?= $Page->gst->Lookup->getParamTag($Page, "p_x_gst") ?>
<?php if (!$Page->gst->IsNativeSelect) { ?>
<script>
loadjs.ready("frental_poadd", function() {
    var options = { name: "x_gst", selectId: "frental_poadd_x_gst" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frental_poadd.lists.gst?.lookupOptions.length) {
        options.data = { id: "x_gst", form: "frental_poadd" };
    } else {
        options.ajax = { id: "x_gst", form: "frental_poadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.rental_po.fields.gst.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_rental_po_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_rental_po_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="rental_po"
        data-field="x_uploads"
        data-size="500"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        data-page="2"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frental_poadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frental_poadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("rental_po");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#elh_rental_po_description_01").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Projector" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=17&O=" data-btn="SaveBtn" data-bs-original-title="Add Projector"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_02").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Sound System" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=18&O=" data-btn="SaveBtn" data-bs-original-title="Add Sound System"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_03").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add LED Wall" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=19&O=" data-btn="SaveBtn" data-bs-original-title="Add LED Wall"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_04").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Screen" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=20&O=" data-btn="SaveBtn" data-bs-original-title="Add Screen"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_05").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Mike / Mixer" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=21&O=" data-btn="SaveBtn" data-bs-original-title="Add Mike / Mixer"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_06").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add LED Display / TV" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=22&O=" data-btn="SaveBtn" data-bs-original-title="Add LED Display / TV"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_07").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Accessories" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=23&O=" data-btn="SaveBtn" data-bs-original-title="Add Accessories"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_08").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Wirings" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=24&O=" data-btn="SaveBtn" data-bs-original-title="Add Wirings"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_09").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Stands" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=25&O=" data-btn="SaveBtn" data-bs-original-title="Add Stands"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_rental_po_description_10").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="rental_cart" data-caption="Add Others" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/rentalcartadd?P=17,18,19,20,21,22,23,24,25&O=NOT" data-btn="SaveBtn" data-bs-original-title="Add Others"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
});
</script>
