<?php

namespace PHPMaker2024\fibre;

// Page object
$RefView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="frefview" id="frefview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var frefview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("frefview")
        .setPageId("view")

        // Multi-Page
        .setMultiPage(true)
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_ref_id" data-page="0">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <tr id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_company_id"><?= $Page->company_id->caption() ?></span></td>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el_ref_company_id" data-page="0">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <tr id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_grp"><?= $Page->grp->caption() ?></span></td>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el_ref_grp" data-page="0">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <tr id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_s_grp"><?= $Page->s_grp->caption() ?></span></td>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_ref_s_grp" data-page="0">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <tr id="r_product"<?= $Page->product->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_product"><?= $Page->product->caption() ?></span></td>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el_ref_product" data-page="0">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <tr id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_product_type"><?= $Page->product_type->caption() ?></span></td>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el_ref_product_type" data-page="0">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <tr id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_packing_type"><?= $Page->packing_type->caption() ?></span></td>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_ref_packing_type" data-page="0">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_n->Visible) { // product_n ?>
    <tr id="r_product_n"<?= $Page->product_n->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_product_n"><?= $Page->product_n->caption() ?></span></td>
        <td data-name="product_n"<?= $Page->product_n->cellAttributes() ?>>
<span id="el_ref_product_n" data-page="0">
<span<?= $Page->product_n->viewAttributes() ?>>
<?= $Page->product_n->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <tr id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref__barcode"><?= $Page->_barcode->caption() ?></span></td>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_ref__barcode" data-page="0">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_code_type->Visible) { // product_code_type ?>
    <tr id="r_product_code_type"<?= $Page->product_code_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_product_code_type"><?= $Page->product_code_type->caption() ?></span></td>
        <td data-name="product_code_type"<?= $Page->product_code_type->cellAttributes() ?>>
<span id="el_ref_product_code_type" data-page="0">
<span<?= $Page->product_code_type->viewAttributes() ?>>
<?= $Page->product_code_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <tr id="r_product_code"<?= $Page->product_code->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_product_code"><?= $Page->product_code->caption() ?></span></td>
        <td data-name="product_code"<?= $Page->product_code->cellAttributes() ?>>
<span id="el_ref_product_code" data-page="0">
<span<?= $Page->product_code->viewAttributes() ?>>
<?= $Page->product_code->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_RefView"><!-- multi-page accordion -->
<?php } ?>
<?php if (!$Page->isExport()) { ?>
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref1">
            <div class="card-body"><!-- multi-page .accordion-body -->
<?php } ?>
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->set_ref->Visible) { // set_ref ?>
    <tr id="r_set_ref"<?= $Page->set_ref->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_set_ref"><?= $Page->set_ref->caption() ?></span></td>
        <td data-name="set_ref"<?= $Page->set_ref->cellAttributes() ?>>
<span id="el_ref_set_ref" data-page="1">
<span<?= $Page->set_ref->viewAttributes() ?>>
<?= $Page->set_ref->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_00->Visible) { // v_00 ?>
    <tr id="r_v_00"<?= $Page->v_00->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_00"><?= $Page->v_00->caption() ?></span></td>
        <td data-name="v_00"<?= $Page->v_00->cellAttributes() ?>>
<span id="el_ref_v_00" data-page="1">
<span<?= $Page->v_00->viewAttributes() ?>>
<?= $Page->v_00->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
    <tr id="r_v_01"<?= $Page->v_01->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_01"><?= $Page->v_01->caption() ?></span></td>
        <td data-name="v_01"<?= $Page->v_01->cellAttributes() ?>>
<span id="el_ref_v_01" data-page="1">
<span<?= $Page->v_01->viewAttributes() ?>>
<?= $Page->v_01->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
    <tr id="r_v_02"<?= $Page->v_02->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_02"><?= $Page->v_02->caption() ?></span></td>
        <td data-name="v_02"<?= $Page->v_02->cellAttributes() ?>>
<span id="el_ref_v_02" data-page="1">
<span<?= $Page->v_02->viewAttributes() ?>>
<?= $Page->v_02->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
    <tr id="r_v_03"<?= $Page->v_03->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_03"><?= $Page->v_03->caption() ?></span></td>
        <td data-name="v_03"<?= $Page->v_03->cellAttributes() ?>>
<span id="el_ref_v_03" data-page="1">
<span<?= $Page->v_03->viewAttributes() ?>>
<?= $Page->v_03->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
    <tr id="r_v_04"<?= $Page->v_04->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_04"><?= $Page->v_04->caption() ?></span></td>
        <td data-name="v_04"<?= $Page->v_04->cellAttributes() ?>>
<span id="el_ref_v_04" data-page="1">
<span<?= $Page->v_04->viewAttributes() ?>>
<?= $Page->v_04->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
    <tr id="r_v_05"<?= $Page->v_05->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_05"><?= $Page->v_05->caption() ?></span></td>
        <td data-name="v_05"<?= $Page->v_05->cellAttributes() ?>>
<span id="el_ref_v_05" data-page="1">
<span<?= $Page->v_05->viewAttributes() ?>>
<?= $Page->v_05->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_06->Visible) { // v_06 ?>
    <tr id="r_v_06"<?= $Page->v_06->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_06"><?= $Page->v_06->caption() ?></span></td>
        <td data-name="v_06"<?= $Page->v_06->cellAttributes() ?>>
<span id="el_ref_v_06" data-page="1">
<span<?= $Page->v_06->viewAttributes() ?>>
<?= $Page->v_06->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_07->Visible) { // v_07 ?>
    <tr id="r_v_07"<?= $Page->v_07->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_07"><?= $Page->v_07->caption() ?></span></td>
        <td data-name="v_07"<?= $Page->v_07->cellAttributes() ?>>
<span id="el_ref_v_07" data-page="1">
<span<?= $Page->v_07->viewAttributes() ?>>
<?= $Page->v_07->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_08->Visible) { // v_08 ?>
    <tr id="r_v_08"<?= $Page->v_08->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_08"><?= $Page->v_08->caption() ?></span></td>
        <td data-name="v_08"<?= $Page->v_08->cellAttributes() ?>>
<span id="el_ref_v_08" data-page="1">
<span<?= $Page->v_08->viewAttributes() ?>>
<?= $Page->v_08->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_09->Visible) { // v_09 ?>
    <tr id="r_v_09"<?= $Page->v_09->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_09"><?= $Page->v_09->caption() ?></span></td>
        <td data-name="v_09"<?= $Page->v_09->cellAttributes() ?>>
<span id="el_ref_v_09" data-page="1">
<span<?= $Page->v_09->viewAttributes() ?>>
<?= $Page->v_09->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->v_10->Visible) { // v_10 ?>
    <tr id="r_v_10"<?= $Page->v_10->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_v_10"><?= $Page->v_10->caption() ?></span></td>
        <td data-name="v_10"<?= $Page->v_10->cellAttributes() ?>>
<span id="el_ref_v_10" data-page="1">
<span<?= $Page->v_10->viewAttributes() ?>>
<?= $Page->v_10->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
    <tr id="r_q_sku"<?= $Page->q_sku->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_q_sku"><?= $Page->q_sku->caption() ?></span></td>
        <td data-name="q_sku"<?= $Page->q_sku->cellAttributes() ?>>
<span id="el_ref_q_sku" data-page="1">
<span<?= $Page->q_sku->viewAttributes() ?>>
<?= $Page->q_sku->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php if (!$Page->isExport()) { ?>
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<?php } ?>
<?php if (!$Page->isExport()) { ?>
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref2">
            <div class="card-body"><!-- multi-page .accordion-body -->
<?php } ?>
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->cbm->Visible) { // cbm ?>
    <tr id="r_cbm"<?= $Page->cbm->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_cbm"><?= $Page->cbm->caption() ?></span></td>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el_ref_cbm" data-page="2">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <tr id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_sqm"><?= $Page->sqm->caption() ?></span></td>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el_ref_sqm" data-page="2">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
    <tr id="r_shape"<?= $Page->shape->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_shape"><?= $Page->shape->caption() ?></span></td>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el_ref_shape" data-page="2">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_01->Visible) { // b_01 ?>
    <tr id="r_b_01"<?= $Page->b_01->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_01"><?= $Page->b_01->caption() ?></span></td>
        <td data-name="b_01"<?= $Page->b_01->cellAttributes() ?>>
<span id="el_ref_b_01" data-page="2">
<span<?= $Page->b_01->viewAttributes() ?>>
<?= $Page->b_01->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_02->Visible) { // b_02 ?>
    <tr id="r_b_02"<?= $Page->b_02->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_02"><?= $Page->b_02->caption() ?></span></td>
        <td data-name="b_02"<?= $Page->b_02->cellAttributes() ?>>
<span id="el_ref_b_02" data-page="2">
<span<?= $Page->b_02->viewAttributes() ?>>
<?= $Page->b_02->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_03->Visible) { // b_03 ?>
    <tr id="r_b_03"<?= $Page->b_03->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_03"><?= $Page->b_03->caption() ?></span></td>
        <td data-name="b_03"<?= $Page->b_03->cellAttributes() ?>>
<span id="el_ref_b_03" data-page="2">
<span<?= $Page->b_03->viewAttributes() ?>>
<?= $Page->b_03->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_04->Visible) { // b_04 ?>
    <tr id="r_b_04"<?= $Page->b_04->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_04"><?= $Page->b_04->caption() ?></span></td>
        <td data-name="b_04"<?= $Page->b_04->cellAttributes() ?>>
<span id="el_ref_b_04" data-page="2">
<span<?= $Page->b_04->viewAttributes() ?>>
<?= $Page->b_04->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_05->Visible) { // b_05 ?>
    <tr id="r_b_05"<?= $Page->b_05->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_05"><?= $Page->b_05->caption() ?></span></td>
        <td data-name="b_05"<?= $Page->b_05->cellAttributes() ?>>
<span id="el_ref_b_05" data-page="2">
<span<?= $Page->b_05->viewAttributes() ?>>
<?= $Page->b_05->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_06->Visible) { // b_06 ?>
    <tr id="r_b_06"<?= $Page->b_06->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_06"><?= $Page->b_06->caption() ?></span></td>
        <td data-name="b_06"<?= $Page->b_06->cellAttributes() ?>>
<span id="el_ref_b_06" data-page="2">
<span<?= $Page->b_06->viewAttributes() ?>>
<?= $Page->b_06->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_07->Visible) { // b_07 ?>
    <tr id="r_b_07"<?= $Page->b_07->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_07"><?= $Page->b_07->caption() ?></span></td>
        <td data-name="b_07"<?= $Page->b_07->cellAttributes() ?>>
<span id="el_ref_b_07" data-page="2">
<span<?= $Page->b_07->viewAttributes() ?>>
<?= $Page->b_07->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_08->Visible) { // b_08 ?>
    <tr id="r_b_08"<?= $Page->b_08->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_08"><?= $Page->b_08->caption() ?></span></td>
        <td data-name="b_08"<?= $Page->b_08->cellAttributes() ?>>
<span id="el_ref_b_08" data-page="2">
<span<?= $Page->b_08->viewAttributes() ?>>
<?= $Page->b_08->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_09->Visible) { // b_09 ?>
    <tr id="r_b_09"<?= $Page->b_09->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_09"><?= $Page->b_09->caption() ?></span></td>
        <td data-name="b_09"<?= $Page->b_09->cellAttributes() ?>>
<span id="el_ref_b_09" data-page="2">
<span<?= $Page->b_09->viewAttributes() ?>>
<?= $Page->b_09->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_10->Visible) { // b_10 ?>
    <tr id="r_b_10"<?= $Page->b_10->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_10"><?= $Page->b_10->caption() ?></span></td>
        <td data-name="b_10"<?= $Page->b_10->cellAttributes() ?>>
<span id="el_ref_b_10" data-page="2">
<span<?= $Page->b_10->viewAttributes() ?>>
<?= $Page->b_10->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_11->Visible) { // b_11 ?>
    <tr id="r_b_11"<?= $Page->b_11->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_11"><?= $Page->b_11->caption() ?></span></td>
        <td data-name="b_11"<?= $Page->b_11->cellAttributes() ?>>
<span id="el_ref_b_11" data-page="2">
<span<?= $Page->b_11->viewAttributes() ?>>
<?= $Page->b_11->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_12->Visible) { // b_12 ?>
    <tr id="r_b_12"<?= $Page->b_12->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_12"><?= $Page->b_12->caption() ?></span></td>
        <td data-name="b_12"<?= $Page->b_12->cellAttributes() ?>>
<span id="el_ref_b_12" data-page="2">
<span<?= $Page->b_12->viewAttributes() ?>>
<?= $Page->b_12->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_13->Visible) { // b_13 ?>
    <tr id="r_b_13"<?= $Page->b_13->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_13"><?= $Page->b_13->caption() ?></span></td>
        <td data-name="b_13"<?= $Page->b_13->cellAttributes() ?>>
<span id="el_ref_b_13" data-page="2">
<span<?= $Page->b_13->viewAttributes() ?>>
<?= $Page->b_13->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_14->Visible) { // b_14 ?>
    <tr id="r_b_14"<?= $Page->b_14->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_14"><?= $Page->b_14->caption() ?></span></td>
        <td data-name="b_14"<?= $Page->b_14->cellAttributes() ?>>
<span id="el_ref_b_14" data-page="2">
<span<?= $Page->b_14->viewAttributes() ?>>
<?= $Page->b_14->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->b_15->Visible) { // b_15 ?>
    <tr id="r_b_15"<?= $Page->b_15->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_b_15"><?= $Page->b_15->caption() ?></span></td>
        <td data-name="b_15"<?= $Page->b_15->cellAttributes() ?>>
<span id="el_ref_b_15" data-page="2">
<span<?= $Page->b_15->viewAttributes() ?>>
<?= $Page->b_15->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php if (!$Page->isExport()) { ?>
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<?php } ?>
<?php if (!$Page->isExport()) { ?>
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref3">
            <div class="card-body"><!-- multi-page .accordion-body -->
<?php } ?>
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->t_01->Visible) { // t_01 ?>
    <tr id="r_t_01"<?= $Page->t_01->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_01"><?= $Page->t_01->caption() ?></span></td>
        <td data-name="t_01"<?= $Page->t_01->cellAttributes() ?>>
<span id="el_ref_t_01" data-page="3">
<span<?= $Page->t_01->viewAttributes() ?>>
<?= $Page->t_01->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_02->Visible) { // t_02 ?>
    <tr id="r_t_02"<?= $Page->t_02->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_02"><?= $Page->t_02->caption() ?></span></td>
        <td data-name="t_02"<?= $Page->t_02->cellAttributes() ?>>
<span id="el_ref_t_02" data-page="3">
<span<?= $Page->t_02->viewAttributes() ?>>
<?= $Page->t_02->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_03->Visible) { // t_03 ?>
    <tr id="r_t_03"<?= $Page->t_03->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_03"><?= $Page->t_03->caption() ?></span></td>
        <td data-name="t_03"<?= $Page->t_03->cellAttributes() ?>>
<span id="el_ref_t_03" data-page="3">
<span<?= $Page->t_03->viewAttributes() ?>>
<?= $Page->t_03->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_04->Visible) { // t_04 ?>
    <tr id="r_t_04"<?= $Page->t_04->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_04"><?= $Page->t_04->caption() ?></span></td>
        <td data-name="t_04"<?= $Page->t_04->cellAttributes() ?>>
<span id="el_ref_t_04" data-page="3">
<span<?= $Page->t_04->viewAttributes() ?>>
<?= $Page->t_04->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_05->Visible) { // t_05 ?>
    <tr id="r_t_05"<?= $Page->t_05->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_05"><?= $Page->t_05->caption() ?></span></td>
        <td data-name="t_05"<?= $Page->t_05->cellAttributes() ?>>
<span id="el_ref_t_05" data-page="3">
<span<?= $Page->t_05->viewAttributes() ?>>
<?= $Page->t_05->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_06->Visible) { // t_06 ?>
    <tr id="r_t_06"<?= $Page->t_06->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_06"><?= $Page->t_06->caption() ?></span></td>
        <td data-name="t_06"<?= $Page->t_06->cellAttributes() ?>>
<span id="el_ref_t_06" data-page="3">
<span<?= $Page->t_06->viewAttributes() ?>>
<?= $Page->t_06->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_07->Visible) { // t_07 ?>
    <tr id="r_t_07"<?= $Page->t_07->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_07"><?= $Page->t_07->caption() ?></span></td>
        <td data-name="t_07"<?= $Page->t_07->cellAttributes() ?>>
<span id="el_ref_t_07" data-page="3">
<span<?= $Page->t_07->viewAttributes() ?>>
<?= $Page->t_07->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_08->Visible) { // t_08 ?>
    <tr id="r_t_08"<?= $Page->t_08->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_08"><?= $Page->t_08->caption() ?></span></td>
        <td data-name="t_08"<?= $Page->t_08->cellAttributes() ?>>
<span id="el_ref_t_08" data-page="3">
<span<?= $Page->t_08->viewAttributes() ?>>
<?= $Page->t_08->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_09->Visible) { // t_09 ?>
    <tr id="r_t_09"<?= $Page->t_09->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_09"><?= $Page->t_09->caption() ?></span></td>
        <td data-name="t_09"<?= $Page->t_09->cellAttributes() ?>>
<span id="el_ref_t_09" data-page="3">
<span<?= $Page->t_09->viewAttributes() ?>>
<?= $Page->t_09->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_10->Visible) { // t_10 ?>
    <tr id="r_t_10"<?= $Page->t_10->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_10"><?= $Page->t_10->caption() ?></span></td>
        <td data-name="t_10"<?= $Page->t_10->cellAttributes() ?>>
<span id="el_ref_t_10" data-page="3">
<span<?= $Page->t_10->viewAttributes() ?>>
<?= $Page->t_10->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_11->Visible) { // t_11 ?>
    <tr id="r_t_11"<?= $Page->t_11->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_11"><?= $Page->t_11->caption() ?></span></td>
        <td data-name="t_11"<?= $Page->t_11->cellAttributes() ?>>
<span id="el_ref_t_11" data-page="3">
<span<?= $Page->t_11->viewAttributes() ?>>
<?= $Page->t_11->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_12->Visible) { // t_12 ?>
    <tr id="r_t_12"<?= $Page->t_12->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_12"><?= $Page->t_12->caption() ?></span></td>
        <td data-name="t_12"<?= $Page->t_12->cellAttributes() ?>>
<span id="el_ref_t_12" data-page="3">
<span<?= $Page->t_12->viewAttributes() ?>>
<?= $Page->t_12->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_13->Visible) { // t_13 ?>
    <tr id="r_t_13"<?= $Page->t_13->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_13"><?= $Page->t_13->caption() ?></span></td>
        <td data-name="t_13"<?= $Page->t_13->cellAttributes() ?>>
<span id="el_ref_t_13" data-page="3">
<span<?= $Page->t_13->viewAttributes() ?>>
<?= $Page->t_13->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_14->Visible) { // t_14 ?>
    <tr id="r_t_14"<?= $Page->t_14->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_14"><?= $Page->t_14->caption() ?></span></td>
        <td data-name="t_14"<?= $Page->t_14->cellAttributes() ?>>
<span id="el_ref_t_14" data-page="3">
<span<?= $Page->t_14->viewAttributes() ?>>
<?= $Page->t_14->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->t_15->Visible) { // t_15 ?>
    <tr id="r_t_15"<?= $Page->t_15->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_t_15"><?= $Page->t_15->caption() ?></span></td>
        <td data-name="t_15"<?= $Page->t_15->cellAttributes() ?>>
<span id="el_ref_t_15" data-page="3">
<span<?= $Page->t_15->viewAttributes() ?>>
<?= $Page->t_15->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php if (!$Page->isExport()) { ?>
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<?php } ?>
<?php if (!$Page->isExport()) { ?>
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref4">
            <div class="card-body"><!-- multi-page .accordion-body -->
<?php } ?>
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->last_price->Visible) { // last_price ?>
    <tr id="r_last_price"<?= $Page->last_price->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_last_price"><?= $Page->last_price->caption() ?></span></td>
        <td data-name="last_price"<?= $Page->last_price->cellAttributes() ?>>
<span id="el_ref_last_price" data-page="4">
<span<?= $Page->last_price->viewAttributes() ?>>
<?= $Page->last_price->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <tr id="r_currency"<?= $Page->currency->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_currency"><?= $Page->currency->caption() ?></span></td>
        <td data-name="currency"<?= $Page->currency->cellAttributes() ?>>
<span id="el_ref_currency" data-page="4">
<span<?= $Page->currency->viewAttributes() ?>>
<?= $Page->currency->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->hsn->Visible) { // hsn ?>
    <tr id="r_hsn"<?= $Page->hsn->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_hsn"><?= $Page->hsn->caption() ?></span></td>
        <td data-name="hsn"<?= $Page->hsn->cellAttributes() ?>>
<span id="el_ref_hsn" data-page="4">
<span<?= $Page->hsn->viewAttributes() ?>>
<?= $Page->hsn->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
    <tr id="r_composition"<?= $Page->composition->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_composition"><?= $Page->composition->caption() ?></span></td>
        <td data-name="composition"<?= $Page->composition->cellAttributes() ?>>
<span id="el_ref_composition" data-page="4">
<span<?= $Page->composition->viewAttributes() ?>>
<?= $Page->composition->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <tr id="r_category"<?= $Page->category->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_category"><?= $Page->category->caption() ?></span></td>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el_ref_category" data-page="4">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->moq->Visible) { // moq ?>
    <tr id="r_moq"<?= $Page->moq->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_moq"><?= $Page->moq->caption() ?></span></td>
        <td data-name="moq"<?= $Page->moq->cellAttributes() ?>>
<span id="el_ref_moq" data-page="4">
<span<?= $Page->moq->viewAttributes() ?>>
<?= $Page->moq->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <tr id="r_status"<?= $Page->status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_status"><?= $Page->status->caption() ?></span></td>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el_ref_status" data-page="4">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php if (!$Page->isExport()) { ?>
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<?php } ?>
<?php if (!$Page->isExport()) { ?>
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(5)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref5"><?= $Page->pageCaption(5) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(5)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref5">
            <div class="card-body"><!-- multi-page .accordion-body -->
<?php } ?>
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->d_head_01->Visible) { // d_head_01 ?>
    <tr id="r_d_head_01"<?= $Page->d_head_01->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_d_head_01"><?= $Page->d_head_01->caption() ?></span></td>
        <td data-name="d_head_01"<?= $Page->d_head_01->cellAttributes() ?>>
<span id="el_ref_d_head_01" data-page="5">
<span<?= $Page->d_head_01->viewAttributes() ?>>
<?= $Page->d_head_01->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->d_description_01->Visible) { // d_description_01 ?>
    <tr id="r_d_description_01"<?= $Page->d_description_01->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_d_description_01"><?= $Page->d_description_01->caption() ?></span></td>
        <td data-name="d_description_01"<?= $Page->d_description_01->cellAttributes() ?>>
<span id="el_ref_d_description_01" data-page="5">
<span<?= $Page->d_description_01->viewAttributes() ?>>
<?= $Page->d_description_01->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->d_head_02->Visible) { // d_head_02 ?>
    <tr id="r_d_head_02"<?= $Page->d_head_02->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_d_head_02"><?= $Page->d_head_02->caption() ?></span></td>
        <td data-name="d_head_02"<?= $Page->d_head_02->cellAttributes() ?>>
<span id="el_ref_d_head_02" data-page="5">
<span<?= $Page->d_head_02->viewAttributes() ?>>
<?= $Page->d_head_02->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->d_description_02->Visible) { // d_description_02 ?>
    <tr id="r_d_description_02"<?= $Page->d_description_02->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_d_description_02"><?= $Page->d_description_02->caption() ?></span></td>
        <td data-name="d_description_02"<?= $Page->d_description_02->cellAttributes() ?>>
<span id="el_ref_d_description_02" data-page="5">
<span<?= $Page->d_description_02->viewAttributes() ?>>
<?= $Page->d_description_02->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->publish->Visible) { // publish ?>
    <tr id="r_publish"<?= $Page->publish->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_publish"><?= $Page->publish->caption() ?></span></td>
        <td data-name="publish"<?= $Page->publish->cellAttributes() ?>>
<span id="el_ref_publish" data-page="5">
<span<?= $Page->publish->viewAttributes() ?>>
<?= $Page->publish->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->keywords->Visible) { // keywords ?>
    <tr id="r_keywords"<?= $Page->keywords->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_keywords"><?= $Page->keywords->caption() ?></span></td>
        <td data-name="keywords"<?= $Page->keywords->cellAttributes() ?>>
<span id="el_ref_keywords" data-page="5">
<span<?= $Page->keywords->viewAttributes() ?>>
<?= $Page->keywords->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_ref_operator" data-page="5">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_ref_datetime" data-page="5">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
<?php if (!$Page->isExport()) { ?>
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
<?php } ?>
<?php if (!$Page->isExport()) { ?>
</div>
</div>
<?php } ?>
<?php
    if (in_array("multiple_price", explode(",", $Page->getCurrentDetailTable())) && $multiple_price->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("multiple_price", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "MultiplePriceGrid.php" ?>
<?php } ?>
<?php
    if (in_array("partner_product_ref", explode(",", $Page->getCurrentDetailTable())) && $partner_product_ref->DetailView) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("partner_product_ref", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "PartnerProductRefGrid.php" ?>
<?php } ?>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var SGrp = $("#x_s_grp").val();
    		var product_type = $("#x_product_type").val();
    		if (product_type == 8)
    		{
    		$("#r_set_ref").show();
    		$("#r_v_00").hide();		
    		$("#r_v_01").hide();
    		$("#r_v_02").hide();
    		$("#r_v_03").hide();
    		$("#r_v_04").hide();
    		$("#r_v_05").hide();
    		$("#r_v_06").hide();
    		$("#r_v_07").hide();
    		$("#r_v_08").hide();
    		$("#r_v_09").hide();
    		$("#r_v_10").hide();
    		} else {
    		$("#r_set_ref").hide();
    		}
    		if (SGrp.length > 0)
    		{
    		$.getJSON(window.location.origin +"/apcajax?getHead="+SGrp,function(data){
    			 		if (data.cbm == '--NA--') {
    					$("#r_cbm").hide(); } else {
    					$("#r_cbm").show();						
    					$("#elh_ref_cbm").html(data.cbm);}
    					if (data.sqm == '--NA--') {
    					$("#r_sqm").hide(); } else {
    					$("#r_sqm").show()					
    					$("#elh_ref_sqm").html(data.sqm);}
    					if (data.shape == '--NA--') {
    					$("#r_shape").hide(); } else {
    					$("#r_shape").show()					
    					$("#elh_ref_shape").html(data.shape);}
    					if (data.v_00 == '--NA--') {
    					$("#r_v_00").hide(); } else {
    					$("#r_v_00").show();					
    					$("#elh_ref_v_00").html(data.v_00);}
    					if (data.v_01 == '--NA--') {
    					$("#sv_x_v_01").val('');
    					$("#r_v_01").hide(); } else {
    					$("#r_v_01").show();					
    					$("#elh_ref_v_01").html(data.v_01);}
    					if (data.v_02 == '--NA--') {
    					$("#sv_x_v_02").val('');
    					$("#r_v_02").hide(); } else {
    					$("#r_v_02").show()					
    					$("#elh_ref_v_02").html(data.v_02);}
    					if (data.v_03 == '--NA--') {
    					$("#sv_x_v_03").val('');
    					$("#r_v_03").hide(); } else {
    					$("#r_v_03").show()					
    					$("#elh_ref_v_03").html(data.v_03);}
    					if (data.v_04 == '--NA--') {
    					$("#sv_x_v_04").val('');
    					$("#r_v_04").hide(); } else {
    					$("#r_v_04").show()		
    					$("#elh_ref_v_04").html(data.v_04);}
    					if (data.v_05 == '--NA--') {
    					$("#sv_x_v_05").val('');
    					$("#r_v_05").hide(); } else {
    					$("#r_v_05").show();					
    					$("#elh_ref_v_05").html(data.v_05);}
    					if (data.v_06 == '--NA--') {
    					$("#sv_x_v_06").val('');
    					$("#r_v_06").hide(); } else {
    					$("#r_v_06").show()		
    					$("#elh_ref_v_06").html(data.v_06);}
    					if (data.v_07 == '--NA--') {
    					$("#sv_x_v_07").val('');
    					$("#r_v_07").hide(); } else {						
    					$("#r_v_07").show();
    					$("#elh_ref_v_07").html(data.v_07);}
    					if (data.v_08 == '--NA--') {
    					$("#sv_x_v_08").val('');
    					$("#r_v_08").hide(); } else {						
    					$("#r_v_08").show();
    					$("#elh_ref_v_08").html(data.v_08);}
    					if (data.v_09 == '--NA--') {
    					$("#sv_x_v_09").val('');
    					$("#r_v_09").hide(); } else {						
    					$("#r_v_09").show();
    					$("#elh_ref_v_09").html(data.v_09);}
    					if (data.v_10 == '--NA--') {
    					$("#sv_x_v_10").val('');
    					$("#r_v_10").hide(); } else {						
    					$("#r_v_10").show();
    					$("#elh_ref_v_10").html(data.v_10);}
    					if (data.b_01_head == '--NA--') {
    					$("#r_b_01").hide(); } else {
    					$("#r_b_01").show();
    					$("#elh_ref_b_01").html(data.b_01_head);}
    					if (data.b_02_head == '--NA--') {
    					$("#r_b_02").hide(); } else {
    					$("#r_b_02").show();
    					$("#elh_ref_b_02").html(data.b_02_head);}
    					if (data.b_03_head == '--NA--') {
    					$("#r_b_03").hide(); } else {
    					$("#r_b_03").show();
    					$("#elh_ref_b_03").html(data.b_03_head);}
    					if (data.b_04_head == '--NA--') {
    					$("#r_b_04").hide(); } else {
    					$("#r_b_04").show();
    					$("#elh_ref_b_04").html(data.b_04_head);}
    					if (data.b_05_head == '--NA--') {
    					$("#r_b_05").hide(); } else {
    					$("#r_b_05").show();
    					$("#elh_ref_b_05").html(data.b_05_head);}
    					if (data.b_06_head == '--NA--') {
    					$("#r_b_06").hide(); } else {
    					$("#r_b_06").show();
    					$("#elh_ref_b_06").html(data.b_06_head);}
    					if (data.b_07_head == '--NA--') {
    					$("#r_b_07").hide(); } else {
    					$("#r_b_07").show();
    					$("#elh_ref_b_07").html(data.b_07_head);}
    					if (data.b_08_head == '--NA--') {
    					$("#r_b_08").hide(); } else {
    					$("#r_b_08").show();
    					$("#elh_ref_b_08").html(data.b_08_head);}
    					if (data.b_09_head == '--NA--') {
    					$("#r_b_09").hide(); } else {
    					$("#r_b_09").show();
    					$("#elh_ref_b_09").html(data.b_09_head);}
    					if (data.b_10_head == '--NA--') {
    					$("#r_b_10").hide(); } else {
    					$("#r_b_10").show();
    					$("#elh_ref_b_10").html(data.b_10_head);}
    					if (data.b_11_head == '--NA--') {
    					$("#r_b_11").hide(); } else {
    					$("#r_b_11").show();
    					$("#elh_ref_b_11").html(data.b_11_head);}
    					if (data.b_12_head == '--NA--') {
    					$("#r_b_12").hide(); } else {
    					$("#r_b_12").show();
    					$("#elh_ref_b_12").html(data.b_12_head);}
    					if (data.b_13_head == '--NA--') {
    					$("#r_b_13").hide(); } else {
    					$("#r_b_13").show();
    					$("#elh_ref_b_13").html(data.b_13_head);}
    					if (data.b_14_head == '--NA--') {
    					$("#r_b_14").hide(); } else {
    					$("#r_b_14").show();	
    					$("#elh_ref_b_14").html(data.b_14_head);}
    					if (data.b_15_head == '--NA--') {
    					$("#r_b_15").hide(); } else {
    					$("#r_b_15").show();
    					$("#elh_ref_b_15").html(data.b_15_head);}
    					if (data.q_sku == '--NA--') {
    					$("#r_q_sku").hide(); } else {
    					$("#r_q_sku").show();
    					$("#elh_ref_q_sku").html(data.q_sku);}
    					if (data.t_01_head == '--NA--') {
    					$("#r_t_01").hide(); } else {
    					$("#r_t_01").show();
    					$("#elh_ref_t_01").html(data.t_01_head);}
    					if (data.t_02_head == '--NA--') {
    					$("#r_t_02").hide(); } else {
    					$("#r_t_02").show();
    					$("#elh_ref_t_02").html(data.t_02_head);}
    					if (data.t_03_head == '--NA--') {
    					$("#r_t_03").hide(); } else {
    					$("#r_t_03").show();
    					$("#elh_ref_t_03").html(data.t_03_head);}
    					if (data.t_04_head == '--NA--') {
    					$("#r_t_04").hide(); } else {
    					$("#r_t_04").show();
    					$("#elh_ref_t_04").html(data.t_04_head);}
    					if (data.t_05_head == '--NA--') {
    					$("#r_t_05").hide(); } else {
    					$("#r_t_05").show();
    					$("#elh_ref_t_05").html(data.t_05_head);}
    					if (data.t_06_head == '--NA--') {
    					$("#r_t_06").hide(); } else {
    					$("#r_t_06").show();
    					$("#elh_ref_t_06").html(data.t_06_head);}
    					if (data.t_07_head == '--NA--') {
    					$("#r_t_07").hide(); } else {
    					$("#r_t_07").show();
    					$("#elh_ref_t_07").html(data.t_07_head);}
    					if (data.t_08_head == '--NA--') {
    					$("#r_t_08").hide(); } else {
    					$("#r_t_08").show();
    					$("#elh_ref_t_08").html(data.t_08_head);}
    					if (data.t_09_head == '--NA--') {
    					$("#r_t_09").hide(); } else {
    					$("#r_t_09").show();
    					$("#elh_ref_t_09").html(data.t_09_head);}
    					if (data.t_10_head == '--NA--') {
    					$("#r_t_10").hide(); } else {
    					$("#r_t_10").show();
    					$("#elh_ref_t_10").html(data.t_10_head);}
    					if (data.t_11_head == '--NA--') {
    					$("#r_t_11").hide(); } else {
    					$("#r_t_11").show();
    					$("#elh_ref_t_11").html(data.t_11_head);}
    					if (data.t_12_head == '--NA--') {
    					$("#r_t_12").hide(); } else {
    					$("#r_t_12").show();
    					$("#elh_ref_t_12").html(data.t_12_head);}
    					if (data.t_13_head == '--NA--') {
    					$("#r_t_13").hide(); } else {
    					$("#r_t_13").show();
    					$("#elh_ref_t_13").html(data.t_13_head);}
    					if (data.t_14_head == '--NA--') {
    					$("#r_t_14").hide(); } else {
    					$("#r_t_14").show();
    					$("#elh_ref_t_14").html(data.t_14_head);}
    					if (data.t_15_head == '--NA--') {
    					$("#r_t_15").hide(); } else {
    					$("#r_t_15").show();
    					$("#elh_ref_t_15").html(data.t_15_head);}
    					if (data.calculation_method == 1) {
    					var lastprice = 'Current Price / SQM';
    					} else if (data.calculation_method == 2) {
    					var lastprice = 'Current Price / SKU';
    					}
    					$("#elh_ref_last_price").html(lastprice);
    		});
    		}
});
</script>
<?php } ?>
