<?php

namespace PHPMaker2024\fibre;

// Page object
$RefSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var frefsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frefsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["product_n", [], fields.product_n.isInvalid],
            ["product_code_type", [], fields.product_code_type.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["v_00", [], fields.v_00.isInvalid],
            ["v_01", [], fields.v_01.isInvalid],
            ["v_02", [], fields.v_02.isInvalid],
            ["v_03", [], fields.v_03.isInvalid],
            ["v_04", [], fields.v_04.isInvalid],
            ["v_05", [], fields.v_05.isInvalid],
            ["v_06", [], fields.v_06.isInvalid],
            ["v_07", [], fields.v_07.isInvalid],
            ["v_08", [], fields.v_08.isInvalid],
            ["v_09", [], fields.v_09.isInvalid],
            ["v_10", [], fields.v_10.isInvalid],
            ["q_sku", [ew.Validators.float], fields.q_sku.isInvalid],
            ["b_01", [], fields.b_01.isInvalid],
            ["b_02", [], fields.b_02.isInvalid],
            ["b_03", [], fields.b_03.isInvalid],
            ["b_04", [], fields.b_04.isInvalid],
            ["b_05", [], fields.b_05.isInvalid],
            ["b_06", [], fields.b_06.isInvalid],
            ["b_07", [], fields.b_07.isInvalid],
            ["b_08", [], fields.b_08.isInvalid],
            ["b_09", [], fields.b_09.isInvalid],
            ["b_10", [], fields.b_10.isInvalid],
            ["b_11", [], fields.b_11.isInvalid],
            ["b_12", [], fields.b_12.isInvalid],
            ["b_13", [], fields.b_13.isInvalid],
            ["b_14", [], fields.b_14.isInvalid],
            ["b_15", [], fields.b_15.isInvalid],
            ["t_01", [], fields.t_01.isInvalid],
            ["t_02", [], fields.t_02.isInvalid],
            ["t_03", [], fields.t_03.isInvalid],
            ["t_04", [], fields.t_04.isInvalid],
            ["t_05", [], fields.t_05.isInvalid],
            ["t_06", [], fields.t_06.isInvalid],
            ["t_07", [], fields.t_07.isInvalid],
            ["t_08", [], fields.t_08.isInvalid],
            ["t_09", [], fields.t_09.isInvalid],
            ["t_10", [], fields.t_10.isInvalid],
            ["t_11", [], fields.t_11.isInvalid],
            ["t_12", [], fields.t_12.isInvalid],
            ["t_13", [], fields.t_13.isInvalid],
            ["t_14", [], fields.t_14.isInvalid],
            ["t_15", [], fields.t_15.isInvalid],
            ["last_price", [ew.Validators.float], fields.last_price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["hsn", [], fields.hsn.isInvalid],
            ["composition", [], fields.composition.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["moq", [ew.Validators.float], fields.moq.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["d_head_01", [], fields.d_head_01.isInvalid],
            ["d_description_01", [], fields.d_description_01.isInvalid],
            ["d_head_02", [], fields.d_head_02.isInvalid],
            ["d_description_02", [], fields.d_description_02.isInvalid],
            ["publish", [], fields.publish.isInvalid],
            ["keywords", [], fields.keywords.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "product_code_type": <?= $Page->product_code_type->toClientList($Page) ?>,
            "v_01": <?= $Page->v_01->toClientList($Page) ?>,
            "v_02": <?= $Page->v_02->toClientList($Page) ?>,
            "v_03": <?= $Page->v_03->toClientList($Page) ?>,
            "v_04": <?= $Page->v_04->toClientList($Page) ?>,
            "v_05": <?= $Page->v_05->toClientList($Page) ?>,
            "v_06": <?= $Page->v_06->toClientList($Page) ?>,
            "v_07": <?= $Page->v_07->toClientList($Page) ?>,
            "v_08": <?= $Page->v_08->toClientList($Page) ?>,
            "v_09": <?= $Page->v_09->toClientList($Page) ?>,
            "v_10": <?= $Page->v_10->toClientList($Page) ?>,
            "b_03": <?= $Page->b_03->toClientList($Page) ?>,
            "b_04": <?= $Page->b_04->toClientList($Page) ?>,
            "b_05": <?= $Page->b_05->toClientList($Page) ?>,
            "b_06": <?= $Page->b_06->toClientList($Page) ?>,
            "b_07": <?= $Page->b_07->toClientList($Page) ?>,
            "b_08": <?= $Page->b_08->toClientList($Page) ?>,
            "b_09": <?= $Page->b_09->toClientList($Page) ?>,
            "b_10": <?= $Page->b_10->toClientList($Page) ?>,
            "t_03": <?= $Page->t_03->toClientList($Page) ?>,
            "t_04": <?= $Page->t_04->toClientList($Page) ?>,
            "t_05": <?= $Page->t_05->toClientList($Page) ?>,
            "t_06": <?= $Page->t_06->toClientList($Page) ?>,
            "t_07": <?= $Page->t_07->toClientList($Page) ?>,
            "t_08": <?= $Page->t_08->toClientList($Page) ?>,
            "t_09": <?= $Page->t_09->toClientList($Page) ?>,
            "t_10": <?= $Page->t_10->toClientList($Page) ?>,
            "t_11": <?= $Page->t_11->toClientList($Page) ?>,
            "t_12": <?= $Page->t_12->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "hsn": <?= $Page->hsn->toClientList($Page) ?>,
            "composition": <?= $Page->composition->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "publish": <?= $Page->publish->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frefsearch" id="frefsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="ref" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id[]"
        name="x_company_id[]"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="frefsearch_x_company_id[]"
        data-table="ref"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-page="0"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_company_id[]", selectId: "frefsearch_x_company_id[]" };
    options.multiple = true;
    if (frefsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id[]", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_company_id[]", form: "frefsearch", limit: 10 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.ref.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_grp"
        <?php } ?>
        data-table="ref"
        data-field="x_grp"
        data-page="0"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_grp", selectId: "frefsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_s_grp"
        <?php } ?>
        data-table="ref"
        data-field="x_s_grp"
        data-page="0"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_s_grp", selectId: "frefsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_product"
        <?php } ?>
        data-table="ref"
        data-field="x_product"
        data-page="0"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_product", selectId: "frefsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_product", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_product_type"
        <?php } ?>
        data-table="ref"
        data-field="x_product_type"
        data-page="0"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_product_type", selectId: "frefsearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_packing_type"
        <?php } ?>
        data-table="ref"
        data-field="x_packing_type"
        data-page="0"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_packing_type", selectId: "frefsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_n->Visible) { // product_n ?>
    <div id="r_product_n" class="row"<?= $Page->product_n->rowAttributes() ?>>
        <label for="x_product_n" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_product_n"><?= $Page->product_n->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_n" id="z_product_n" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_n->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_product_n" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_n->getInputTextType() ?>" name="x_product_n" id="x_product_n" data-table="ref" data-field="x_product_n" value="<?= $Page->product_n->EditValue ?>" data-page="0" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_n->formatPattern()) ?>"<?= $Page->product_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_n->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code_type->Visible) { // product_code_type ?>
    <div id="r_product_code_type" class="row"<?= $Page->product_code_type->rowAttributes() ?>>
        <label for="x_product_code_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_product_code_type"><?= $Page->product_code_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_code_type" id="z_product_code_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_product_code_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_code_type"
        name="x_product_code_type"
        class="form-select ew-select<?= $Page->product_code_type->isInvalidClass() ?>"
        <?php if (!$Page->product_code_type->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_product_code_type"
        <?php } ?>
        data-table="ref"
        data-field="x_product_code_type"
        data-page="0"
        data-value-separator="<?= $Page->product_code_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_code_type->getPlaceHolder()) ?>"
        <?= $Page->product_code_type->editAttributes() ?>>
        <?= $Page->product_code_type->selectOptionListHtml("x_product_code_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_code_type->getErrorMessage(false) ?></div>
<?php if (!$Page->product_code_type->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_product_code_type", selectId: "frefsearch_x_product_code_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.product_code_type?.lookupOptions.length) {
        options.data = { id: "x_product_code_type", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_product_code_type", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.product_code_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="ref" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" data-page="0" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_RefSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->v_00->Visible) { // v_00 ?>
    <div id="r_v_00" class="row"<?= $Page->v_00->rowAttributes() ?>>
        <label for="x_v_00" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_00"><?= $Page->v_00->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_00" id="z_v_00" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_00->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_00" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->v_00->getInputTextType() ?>" name="x_v_00" id="x_v_00" data-table="ref" data-field="x_v_00" value="<?= $Page->v_00->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->v_00->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->v_00->formatPattern()) ?>"<?= $Page->v_00->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->v_00->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
    <div id="r_v_01" class="row"<?= $Page->v_01->rowAttributes() ?>>
        <label for="x_v_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_01"><?= $Page->v_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_01" id="z_v_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_01"
        name="x_v_01"
        class="form-select ew-select<?= $Page->v_01->isInvalidClass() ?>"
        <?php if (!$Page->v_01->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_01"
        <?php } ?>
        data-table="ref"
        data-field="x_v_01"
        data-page="1"
        data-value-separator="<?= $Page->v_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_01->getPlaceHolder()) ?>"
        <?= $Page->v_01->editAttributes() ?>>
        <?= $Page->v_01->selectOptionListHtml("x_v_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_01->getErrorMessage(false) ?></div>
<?= $Page->v_01->Lookup->getParamTag($Page, "p_x_v_01") ?>
<?php if (!$Page->v_01->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_01", selectId: "frefsearch_x_v_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_01?.lookupOptions.length) {
        options.data = { id: "x_v_01", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_01", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
    <div id="r_v_02" class="row"<?= $Page->v_02->rowAttributes() ?>>
        <label for="x_v_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_02"><?= $Page->v_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_02" id="z_v_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_02"
        name="x_v_02"
        class="form-select ew-select<?= $Page->v_02->isInvalidClass() ?>"
        <?php if (!$Page->v_02->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_02"
        <?php } ?>
        data-table="ref"
        data-field="x_v_02"
        data-page="1"
        data-value-separator="<?= $Page->v_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_02->getPlaceHolder()) ?>"
        <?= $Page->v_02->editAttributes() ?>>
        <?= $Page->v_02->selectOptionListHtml("x_v_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_02->getErrorMessage(false) ?></div>
<?= $Page->v_02->Lookup->getParamTag($Page, "p_x_v_02") ?>
<?php if (!$Page->v_02->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_02", selectId: "frefsearch_x_v_02" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_02?.lookupOptions.length) {
        options.data = { id: "x_v_02", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_02", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
    <div id="r_v_03" class="row"<?= $Page->v_03->rowAttributes() ?>>
        <label for="x_v_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_03"><?= $Page->v_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_03" id="z_v_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_03"
        name="x_v_03"
        class="form-select ew-select<?= $Page->v_03->isInvalidClass() ?>"
        <?php if (!$Page->v_03->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_03"
        <?php } ?>
        data-table="ref"
        data-field="x_v_03"
        data-page="1"
        data-value-separator="<?= $Page->v_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_03->getPlaceHolder()) ?>"
        <?= $Page->v_03->editAttributes() ?>>
        <?= $Page->v_03->selectOptionListHtml("x_v_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_03->getErrorMessage(false) ?></div>
<?= $Page->v_03->Lookup->getParamTag($Page, "p_x_v_03") ?>
<?php if (!$Page->v_03->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_03", selectId: "frefsearch_x_v_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_03?.lookupOptions.length) {
        options.data = { id: "x_v_03", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_03", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
    <div id="r_v_04" class="row"<?= $Page->v_04->rowAttributes() ?>>
        <label for="x_v_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_04"><?= $Page->v_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_04" id="z_v_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_04" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_04"
        name="x_v_04"
        class="form-select ew-select<?= $Page->v_04->isInvalidClass() ?>"
        <?php if (!$Page->v_04->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_04"
        <?php } ?>
        data-table="ref"
        data-field="x_v_04"
        data-page="1"
        data-value-separator="<?= $Page->v_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_04->getPlaceHolder()) ?>"
        <?= $Page->v_04->editAttributes() ?>>
        <?= $Page->v_04->selectOptionListHtml("x_v_04") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_04->getErrorMessage(false) ?></div>
<?= $Page->v_04->Lookup->getParamTag($Page, "p_x_v_04") ?>
<?php if (!$Page->v_04->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_04", selectId: "frefsearch_x_v_04" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_04?.lookupOptions.length) {
        options.data = { id: "x_v_04", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_04", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_04.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
    <div id="r_v_05" class="row"<?= $Page->v_05->rowAttributes() ?>>
        <label for="x_v_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_05"><?= $Page->v_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_05" id="z_v_05" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_05" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_05"
        name="x_v_05"
        class="form-select ew-select<?= $Page->v_05->isInvalidClass() ?>"
        <?php if (!$Page->v_05->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_05"
        <?php } ?>
        data-table="ref"
        data-field="x_v_05"
        data-page="1"
        data-value-separator="<?= $Page->v_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_05->getPlaceHolder()) ?>"
        <?= $Page->v_05->editAttributes() ?>>
        <?= $Page->v_05->selectOptionListHtml("x_v_05") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_05->getErrorMessage(false) ?></div>
<?= $Page->v_05->Lookup->getParamTag($Page, "p_x_v_05") ?>
<?php if (!$Page->v_05->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_05", selectId: "frefsearch_x_v_05" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_05?.lookupOptions.length) {
        options.data = { id: "x_v_05", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_05", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_05.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_06->Visible) { // v_06 ?>
    <div id="r_v_06" class="row"<?= $Page->v_06->rowAttributes() ?>>
        <label for="x_v_06" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_06"><?= $Page->v_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_06" id="z_v_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_06" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_06"
        name="x_v_06"
        class="form-select ew-select<?= $Page->v_06->isInvalidClass() ?>"
        <?php if (!$Page->v_06->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_06"
        <?php } ?>
        data-table="ref"
        data-field="x_v_06"
        data-page="1"
        data-value-separator="<?= $Page->v_06->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_06->getPlaceHolder()) ?>"
        <?= $Page->v_06->editAttributes() ?>>
        <?= $Page->v_06->selectOptionListHtml("x_v_06") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_06->getErrorMessage(false) ?></div>
<?= $Page->v_06->Lookup->getParamTag($Page, "p_x_v_06") ?>
<?php if (!$Page->v_06->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_06", selectId: "frefsearch_x_v_06" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_06?.lookupOptions.length) {
        options.data = { id: "x_v_06", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_06", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_06.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_07->Visible) { // v_07 ?>
    <div id="r_v_07" class="row"<?= $Page->v_07->rowAttributes() ?>>
        <label for="x_v_07" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_07"><?= $Page->v_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_07" id="z_v_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_07" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_07"
        name="x_v_07"
        class="form-select ew-select<?= $Page->v_07->isInvalidClass() ?>"
        <?php if (!$Page->v_07->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_07"
        <?php } ?>
        data-table="ref"
        data-field="x_v_07"
        data-page="1"
        data-value-separator="<?= $Page->v_07->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_07->getPlaceHolder()) ?>"
        <?= $Page->v_07->editAttributes() ?>>
        <?= $Page->v_07->selectOptionListHtml("x_v_07") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_07->getErrorMessage(false) ?></div>
<?= $Page->v_07->Lookup->getParamTag($Page, "p_x_v_07") ?>
<?php if (!$Page->v_07->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_07", selectId: "frefsearch_x_v_07" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_07?.lookupOptions.length) {
        options.data = { id: "x_v_07", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_07", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_07.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_08->Visible) { // v_08 ?>
    <div id="r_v_08" class="row"<?= $Page->v_08->rowAttributes() ?>>
        <label for="x_v_08" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_08"><?= $Page->v_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_08" id="z_v_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_08" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_08"
        name="x_v_08"
        class="form-select ew-select<?= $Page->v_08->isInvalidClass() ?>"
        <?php if (!$Page->v_08->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_08"
        <?php } ?>
        data-table="ref"
        data-field="x_v_08"
        data-page="1"
        data-value-separator="<?= $Page->v_08->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_08->getPlaceHolder()) ?>"
        <?= $Page->v_08->editAttributes() ?>>
        <?= $Page->v_08->selectOptionListHtml("x_v_08") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_08->getErrorMessage(false) ?></div>
<?= $Page->v_08->Lookup->getParamTag($Page, "p_x_v_08") ?>
<?php if (!$Page->v_08->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_08", selectId: "frefsearch_x_v_08" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_08?.lookupOptions.length) {
        options.data = { id: "x_v_08", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_08", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_08.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_09->Visible) { // v_09 ?>
    <div id="r_v_09" class="row"<?= $Page->v_09->rowAttributes() ?>>
        <label for="x_v_09" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_09"><?= $Page->v_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_09" id="z_v_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_09" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_09"
        name="x_v_09"
        class="form-select ew-select<?= $Page->v_09->isInvalidClass() ?>"
        <?php if (!$Page->v_09->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_09"
        <?php } ?>
        data-table="ref"
        data-field="x_v_09"
        data-page="1"
        data-value-separator="<?= $Page->v_09->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_09->getPlaceHolder()) ?>"
        <?= $Page->v_09->editAttributes() ?>>
        <?= $Page->v_09->selectOptionListHtml("x_v_09") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_09->getErrorMessage(false) ?></div>
<?= $Page->v_09->Lookup->getParamTag($Page, "p_x_v_09") ?>
<?php if (!$Page->v_09->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_09", selectId: "frefsearch_x_v_09" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_09?.lookupOptions.length) {
        options.data = { id: "x_v_09", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_09", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_09.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_10->Visible) { // v_10 ?>
    <div id="r_v_10" class="row"<?= $Page->v_10->rowAttributes() ?>>
        <label for="x_v_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_v_10"><?= $Page->v_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_10" id="z_v_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_v_10" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_10"
        name="x_v_10"
        class="form-select ew-select<?= $Page->v_10->isInvalidClass() ?>"
        <?php if (!$Page->v_10->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_v_10"
        <?php } ?>
        data-table="ref"
        data-field="x_v_10"
        data-page="1"
        data-value-separator="<?= $Page->v_10->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_10->getPlaceHolder()) ?>"
        <?= $Page->v_10->editAttributes() ?>>
        <?= $Page->v_10->selectOptionListHtml("x_v_10") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_10->getErrorMessage(false) ?></div>
<?= $Page->v_10->Lookup->getParamTag($Page, "p_x_v_10") ?>
<?php if (!$Page->v_10->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_v_10", selectId: "frefsearch_x_v_10" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.v_10?.lookupOptions.length) {
        options.data = { id: "x_v_10", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_v_10", form: "frefsearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.v_10.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
    <div id="r_q_sku" class="row"<?= $Page->q_sku->rowAttributes() ?>>
        <label for="x_q_sku" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_q_sku"><?= $Page->q_sku->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_q_sku" id="z_q_sku" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->q_sku->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_q_sku" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->q_sku->getInputTextType() ?>" name="x_q_sku" id="x_q_sku" data-table="ref" data-field="x_q_sku" value="<?= $Page->q_sku->EditValue ?>" data-page="1" size="30" placeholder="<?= HtmlEncode($Page->q_sku->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->q_sku->formatPattern()) ?>"<?= $Page->q_sku->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->q_sku->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->b_01->Visible) { // b_01 ?>
    <div id="r_b_01" class="row"<?= $Page->b_01->rowAttributes() ?>>
        <label for="x_b_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_01"><?= $Page->b_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_01" id="z_b_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_01->getInputTextType() ?>" name="x_b_01" id="x_b_01" data-table="ref" data-field="x_b_01" value="<?= $Page->b_01->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_01->formatPattern()) ?>"<?= $Page->b_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_02->Visible) { // b_02 ?>
    <div id="r_b_02" class="row"<?= $Page->b_02->rowAttributes() ?>>
        <label for="x_b_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_02"><?= $Page->b_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_02" id="z_b_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_02->getInputTextType() ?>" name="x_b_02" id="x_b_02" data-table="ref" data-field="x_b_02" value="<?= $Page->b_02->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_02->formatPattern()) ?>"<?= $Page->b_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_03->Visible) { // b_03 ?>
    <div id="r_b_03" class="row"<?= $Page->b_03->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_03"><?= $Page->b_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_03" id="z_b_03" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_03" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_03">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_03" name="x_b_03" id="x_b_03"<?= $Page->b_03->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_03" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_03[]"
    name="x_b_03[]"
    value="<?= HtmlEncode($Page->b_03->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_03"
    data-target="dsl_x_b_03"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_03->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_03"
    data-page="2"
    data-value-separator="<?= $Page->b_03->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_03->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_03->getErrorMessage(false) ?></div>
<?= $Page->b_03->Lookup->getParamTag($Page, "p_x_b_03") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_04->Visible) { // b_04 ?>
    <div id="r_b_04" class="row"<?= $Page->b_04->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_04"><?= $Page->b_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_04" id="z_b_04" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_04" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_04">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_04" name="x_b_04" id="x_b_04"<?= $Page->b_04->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_04" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_04[]"
    name="x_b_04[]"
    value="<?= HtmlEncode($Page->b_04->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_04"
    data-target="dsl_x_b_04"
    data-repeatcolumn="3"
    class="form-control<?= $Page->b_04->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_04"
    data-page="2"
    data-value-separator="<?= $Page->b_04->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_04->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_04->getErrorMessage(false) ?></div>
<?= $Page->b_04->Lookup->getParamTag($Page, "p_x_b_04") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_05->Visible) { // b_05 ?>
    <div id="r_b_05" class="row"<?= $Page->b_05->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_05"><?= $Page->b_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_05" id="z_b_05" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_05" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_05">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_05" name="x_b_05" id="x_b_05"<?= $Page->b_05->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_05" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_05[]"
    name="x_b_05[]"
    value="<?= HtmlEncode($Page->b_05->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_05"
    data-target="dsl_x_b_05"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_05->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_05"
    data-page="2"
    data-value-separator="<?= $Page->b_05->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_05->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_05->getErrorMessage(false) ?></div>
<?= $Page->b_05->Lookup->getParamTag($Page, "p_x_b_05") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_06->Visible) { // b_06 ?>
    <div id="r_b_06" class="row"<?= $Page->b_06->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_06"><?= $Page->b_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_06" id="z_b_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_06" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_06">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_06" name="x_b_06" id="x_b_06"<?= $Page->b_06->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_06" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_06[]"
    name="x_b_06[]"
    value="<?= HtmlEncode($Page->b_06->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_06"
    data-target="dsl_x_b_06"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_06->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_06"
    data-page="2"
    data-value-separator="<?= $Page->b_06->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_06->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_06->getErrorMessage(false) ?></div>
<?= $Page->b_06->Lookup->getParamTag($Page, "p_x_b_06") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_07->Visible) { // b_07 ?>
    <div id="r_b_07" class="row"<?= $Page->b_07->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_07"><?= $Page->b_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_07" id="z_b_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_07" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_07">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_07" name="x_b_07" id="x_b_07"<?= $Page->b_07->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_07" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_07[]"
    name="x_b_07[]"
    value="<?= HtmlEncode($Page->b_07->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_07"
    data-target="dsl_x_b_07"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_07->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_07"
    data-page="2"
    data-value-separator="<?= $Page->b_07->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_07->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_07->getErrorMessage(false) ?></div>
<?= $Page->b_07->Lookup->getParamTag($Page, "p_x_b_07") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_08->Visible) { // b_08 ?>
    <div id="r_b_08" class="row"<?= $Page->b_08->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_08"><?= $Page->b_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_08" id="z_b_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_08" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_08">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_08" name="x_b_08" id="x_b_08"<?= $Page->b_08->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_08" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_08[]"
    name="x_b_08[]"
    value="<?= HtmlEncode($Page->b_08->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_08"
    data-target="dsl_x_b_08"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_08->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_08"
    data-page="2"
    data-value-separator="<?= $Page->b_08->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_08->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_08->getErrorMessage(false) ?></div>
<?= $Page->b_08->Lookup->getParamTag($Page, "p_x_b_08") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_09->Visible) { // b_09 ?>
    <div id="r_b_09" class="row"<?= $Page->b_09->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_09"><?= $Page->b_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_09" id="z_b_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_09" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_09">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_09" name="x_b_09" id="x_b_09"<?= $Page->b_09->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_09" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_09[]"
    name="x_b_09[]"
    value="<?= HtmlEncode($Page->b_09->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_09"
    data-target="dsl_x_b_09"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_09->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_09"
    data-page="2"
    data-value-separator="<?= $Page->b_09->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_09->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_09->getErrorMessage(false) ?></div>
<?= $Page->b_09->Lookup->getParamTag($Page, "p_x_b_09") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_10->Visible) { // b_10 ?>
    <div id="r_b_10" class="row"<?= $Page->b_10->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_10"><?= $Page->b_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_10" id="z_b_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_10" class="ew-search-field ew-search-field-single">
<template id="tp_x_b_10">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_b_10" name="x_b_10" id="x_b_10"<?= $Page->b_10->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_b_10" class="ew-item-list"></div>
<selection-list hidden
    id="x_b_10[]"
    name="x_b_10[]"
    value="<?= HtmlEncode($Page->b_10->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_b_10"
    data-target="dsl_x_b_10"
    data-repeatcolumn="5"
    class="form-control<?= $Page->b_10->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_b_10"
    data-page="2"
    data-value-separator="<?= $Page->b_10->displayValueSeparatorAttribute() ?>"
    <?= $Page->b_10->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->b_10->getErrorMessage(false) ?></div>
<?= $Page->b_10->Lookup->getParamTag($Page, "p_x_b_10") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_11->Visible) { // b_11 ?>
    <div id="r_b_11" class="row"<?= $Page->b_11->rowAttributes() ?>>
        <label for="x_b_11" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_11"><?= $Page->b_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_11" id="z_b_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_11" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_11->getInputTextType() ?>" name="x_b_11" id="x_b_11" data-table="ref" data-field="x_b_11" value="<?= $Page->b_11->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_11->formatPattern()) ?>"<?= $Page->b_11->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_11->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_12->Visible) { // b_12 ?>
    <div id="r_b_12" class="row"<?= $Page->b_12->rowAttributes() ?>>
        <label for="x_b_12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_12"><?= $Page->b_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_12" id="z_b_12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_12->getInputTextType() ?>" name="x_b_12" id="x_b_12" data-table="ref" data-field="x_b_12" value="<?= $Page->b_12->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_12->formatPattern()) ?>"<?= $Page->b_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_13->Visible) { // b_13 ?>
    <div id="r_b_13" class="row"<?= $Page->b_13->rowAttributes() ?>>
        <label for="x_b_13" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_13"><?= $Page->b_13->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_13" id="z_b_13" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_13->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_13" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_13->getInputTextType() ?>" name="x_b_13" id="x_b_13" data-table="ref" data-field="x_b_13" value="<?= $Page->b_13->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_13->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_13->formatPattern()) ?>"<?= $Page->b_13->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_13->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_14->Visible) { // b_14 ?>
    <div id="r_b_14" class="row"<?= $Page->b_14->rowAttributes() ?>>
        <label for="x_b_14" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_14"><?= $Page->b_14->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_14" id="z_b_14" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_14->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_14" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_14->getInputTextType() ?>" name="x_b_14" id="x_b_14" data-table="ref" data-field="x_b_14" value="<?= $Page->b_14->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_14->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_14->formatPattern()) ?>"<?= $Page->b_14->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_14->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_15->Visible) { // b_15 ?>
    <div id="r_b_15" class="row"<?= $Page->b_15->rowAttributes() ?>>
        <label for="x_b_15" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_b_15"><?= $Page->b_15->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_15" id="z_b_15" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_15->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_b_15" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_15->getInputTextType() ?>" name="x_b_15" id="x_b_15" data-table="ref" data-field="x_b_15" value="<?= $Page->b_15->EditValue ?>" data-page="2" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_15->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_15->formatPattern()) ?>"<?= $Page->b_15->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_15->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->t_01->Visible) { // t_01 ?>
    <div id="r_t_01" class="row"<?= $Page->t_01->rowAttributes() ?>>
        <label for="x_t_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_01"><?= $Page->t_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_01" id="z_t_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_01->getInputTextType() ?>" name="x_t_01" id="x_t_01" data-table="ref" data-field="x_t_01" value="<?= $Page->t_01->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_01->formatPattern()) ?>"<?= $Page->t_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_02->Visible) { // t_02 ?>
    <div id="r_t_02" class="row"<?= $Page->t_02->rowAttributes() ?>>
        <label for="x_t_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_02"><?= $Page->t_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_02" id="z_t_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_02->getInputTextType() ?>" name="x_t_02" id="x_t_02" data-table="ref" data-field="x_t_02" value="<?= $Page->t_02->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_02->formatPattern()) ?>"<?= $Page->t_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_03->Visible) { // t_03 ?>
    <div id="r_t_03" class="row"<?= $Page->t_03->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_03"><?= $Page->t_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_03" id="z_t_03" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_03" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_03">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_03" name="x_t_03" id="x_t_03"<?= $Page->t_03->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_03" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_03[]"
    name="x_t_03[]"
    value="<?= HtmlEncode($Page->t_03->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_03"
    data-target="dsl_x_t_03"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_03->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_03"
    data-page="3"
    data-value-separator="<?= $Page->t_03->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_03->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_03->getErrorMessage(false) ?></div>
<?= $Page->t_03->Lookup->getParamTag($Page, "p_x_t_03") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_04->Visible) { // t_04 ?>
    <div id="r_t_04" class="row"<?= $Page->t_04->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_04"><?= $Page->t_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_04" id="z_t_04" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_04" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_04">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_04" name="x_t_04" id="x_t_04"<?= $Page->t_04->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_04" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_04[]"
    name="x_t_04[]"
    value="<?= HtmlEncode($Page->t_04->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_04"
    data-target="dsl_x_t_04"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_04->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_04"
    data-page="3"
    data-value-separator="<?= $Page->t_04->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_04->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_04->getErrorMessage(false) ?></div>
<?= $Page->t_04->Lookup->getParamTag($Page, "p_x_t_04") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_05->Visible) { // t_05 ?>
    <div id="r_t_05" class="row"<?= $Page->t_05->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_05"><?= $Page->t_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_05" id="z_t_05" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_05" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_05">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_05" name="x_t_05" id="x_t_05"<?= $Page->t_05->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_05" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_05[]"
    name="x_t_05[]"
    value="<?= HtmlEncode($Page->t_05->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_05"
    data-target="dsl_x_t_05"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_05->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_05"
    data-page="3"
    data-value-separator="<?= $Page->t_05->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_05->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_05->getErrorMessage(false) ?></div>
<?= $Page->t_05->Lookup->getParamTag($Page, "p_x_t_05") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_06->Visible) { // t_06 ?>
    <div id="r_t_06" class="row"<?= $Page->t_06->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_06"><?= $Page->t_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_06" id="z_t_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_06" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_06">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_06" name="x_t_06" id="x_t_06"<?= $Page->t_06->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_06" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_06[]"
    name="x_t_06[]"
    value="<?= HtmlEncode($Page->t_06->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_06"
    data-target="dsl_x_t_06"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_06->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_06"
    data-page="3"
    data-value-separator="<?= $Page->t_06->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_06->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_06->getErrorMessage(false) ?></div>
<?= $Page->t_06->Lookup->getParamTag($Page, "p_x_t_06") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_07->Visible) { // t_07 ?>
    <div id="r_t_07" class="row"<?= $Page->t_07->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_07"><?= $Page->t_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_07" id="z_t_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_07" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_07">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_07" name="x_t_07" id="x_t_07"<?= $Page->t_07->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_07" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_07[]"
    name="x_t_07[]"
    value="<?= HtmlEncode($Page->t_07->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_07"
    data-target="dsl_x_t_07"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_07->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_07"
    data-page="3"
    data-value-separator="<?= $Page->t_07->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_07->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_07->getErrorMessage(false) ?></div>
<?= $Page->t_07->Lookup->getParamTag($Page, "p_x_t_07") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_08->Visible) { // t_08 ?>
    <div id="r_t_08" class="row"<?= $Page->t_08->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_08"><?= $Page->t_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_08" id="z_t_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_08" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_08">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_08" name="x_t_08" id="x_t_08"<?= $Page->t_08->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_08" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_08[]"
    name="x_t_08[]"
    value="<?= HtmlEncode($Page->t_08->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_08"
    data-target="dsl_x_t_08"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_08->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_08"
    data-page="3"
    data-value-separator="<?= $Page->t_08->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_08->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_08->getErrorMessage(false) ?></div>
<?= $Page->t_08->Lookup->getParamTag($Page, "p_x_t_08") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_09->Visible) { // t_09 ?>
    <div id="r_t_09" class="row"<?= $Page->t_09->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_09"><?= $Page->t_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_09" id="z_t_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_09" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_09">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_09" name="x_t_09" id="x_t_09"<?= $Page->t_09->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_09" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_09[]"
    name="x_t_09[]"
    value="<?= HtmlEncode($Page->t_09->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_09"
    data-target="dsl_x_t_09"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_09->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_09"
    data-page="3"
    data-value-separator="<?= $Page->t_09->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_09->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_09->getErrorMessage(false) ?></div>
<?= $Page->t_09->Lookup->getParamTag($Page, "p_x_t_09") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_10->Visible) { // t_10 ?>
    <div id="r_t_10" class="row"<?= $Page->t_10->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_10"><?= $Page->t_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_10" id="z_t_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_10" class="ew-search-field ew-search-field-single">
<template id="tp_x_t_10">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="ref" data-field="x_t_10" name="x_t_10" id="x_t_10"<?= $Page->t_10->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_t_10" class="ew-item-list"></div>
<selection-list hidden
    id="x_t_10[]"
    name="x_t_10[]"
    value="<?= HtmlEncode($Page->t_10->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_t_10"
    data-target="dsl_x_t_10"
    data-repeatcolumn="5"
    class="form-control<?= $Page->t_10->isInvalidClass() ?>"
    data-table="ref"
    data-field="x_t_10"
    data-page="3"
    data-value-separator="<?= $Page->t_10->displayValueSeparatorAttribute() ?>"
    <?= $Page->t_10->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->t_10->getErrorMessage(false) ?></div>
<?= $Page->t_10->Lookup->getParamTag($Page, "p_x_t_10") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_11->Visible) { // t_11 ?>
    <div id="r_t_11" class="row"<?= $Page->t_11->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_11"><?= $Page->t_11->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_11" id="z_t_11" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_11->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_11" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->t_11->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_t_11" class="ew-auto-suggest">
    <input type="<?= $Page->t_11->getInputTextType() ?>" class="form-control" name="sv_x_t_11" id="sv_x_t_11" value="<?= RemoveHtml($Page->t_11->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_11->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->t_11->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_11->formatPattern()) ?>"<?= $Page->t_11->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="ref" data-field="x_t_11" data-input="sv_x_t_11" data-page="3" data-value-separator="<?= $Page->t_11->displayValueSeparatorAttribute() ?>" name="x_t_11" id="x_t_11" value="<?= HtmlEncode($Page->t_11->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->t_11->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frefsearch", function() {
    frefsearch.createAutoSuggest(Object.assign({"id":"x_t_11","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->t_11->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.ref.fields.t_11.autoSuggestOptions));
});
</script>
<?= $Page->t_11->Lookup->getParamTag($Page, "p_x_t_11") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_12->Visible) { // t_12 ?>
    <div id="r_t_12" class="row"<?= $Page->t_12->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_12"><?= $Page->t_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_12" id="z_t_12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_12" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->t_12->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_t_12" class="ew-auto-suggest">
    <input type="<?= $Page->t_12->getInputTextType() ?>" class="form-control" name="sv_x_t_12" id="sv_x_t_12" value="<?= RemoveHtml($Page->t_12->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_12->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->t_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_12->formatPattern()) ?>"<?= $Page->t_12->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="ref" data-field="x_t_12" data-input="sv_x_t_12" data-page="3" data-value-separator="<?= $Page->t_12->displayValueSeparatorAttribute() ?>" name="x_t_12" id="x_t_12" value="<?= HtmlEncode($Page->t_12->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->t_12->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frefsearch", function() {
    frefsearch.createAutoSuggest(Object.assign({"id":"x_t_12","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->t_12->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.ref.fields.t_12.autoSuggestOptions));
});
</script>
<?= $Page->t_12->Lookup->getParamTag($Page, "p_x_t_12") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_13->Visible) { // t_13 ?>
    <div id="r_t_13" class="row"<?= $Page->t_13->rowAttributes() ?>>
        <label for="x_t_13" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_13"><?= $Page->t_13->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_13" id="z_t_13" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_13->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_13" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_13->getInputTextType() ?>" name="x_t_13" id="x_t_13" data-table="ref" data-field="x_t_13" value="<?= $Page->t_13->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_13->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_13->formatPattern()) ?>"<?= $Page->t_13->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_13->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_14->Visible) { // t_14 ?>
    <div id="r_t_14" class="row"<?= $Page->t_14->rowAttributes() ?>>
        <label for="x_t_14" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_14"><?= $Page->t_14->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_14" id="z_t_14" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_14->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_14" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_14->getInputTextType() ?>" name="x_t_14" id="x_t_14" data-table="ref" data-field="x_t_14" value="<?= $Page->t_14->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_14->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_14->formatPattern()) ?>"<?= $Page->t_14->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_14->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->t_15->Visible) { // t_15 ?>
    <div id="r_t_15" class="row"<?= $Page->t_15->rowAttributes() ?>>
        <label for="x_t_15" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_t_15"><?= $Page->t_15->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_t_15" id="z_t_15" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->t_15->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_t_15" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->t_15->getInputTextType() ?>" name="x_t_15" id="x_t_15" data-table="ref" data-field="x_t_15" value="<?= $Page->t_15->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->t_15->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->t_15->formatPattern()) ?>"<?= $Page->t_15->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->t_15->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->last_price->Visible) { // last_price ?>
    <div id="r_last_price" class="row"<?= $Page->last_price->rowAttributes() ?>>
        <label for="x_last_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_last_price"><?= $Page->last_price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_price" id="z_last_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_last_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_price->getInputTextType() ?>" name="x_last_price" id="x_last_price" data-table="ref" data-field="x_last_price" value="<?= $Page->last_price->EditValue ?>" data-page="4" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->last_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_price->formatPattern()) ?>"<?= $Page->last_price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_currency"
        <?php } ?>
        data-table="ref"
        data-field="x_currency"
        data-page="4"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_currency", selectId: "frefsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->hsn->Visible) { // hsn ?>
    <div id="r_hsn" class="row"<?= $Page->hsn->rowAttributes() ?>>
        <label for="x_hsn" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_hsn"><?= $Page->hsn->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_hsn" id="z_hsn" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->hsn->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_hsn" class="ew-search-field ew-search-field-single">
    <select
        id="x_hsn"
        name="x_hsn"
        class="form-select ew-select<?= $Page->hsn->isInvalidClass() ?>"
        <?php if (!$Page->hsn->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_hsn"
        <?php } ?>
        data-table="ref"
        data-field="x_hsn"
        data-page="4"
        data-value-separator="<?= $Page->hsn->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->hsn->getPlaceHolder()) ?>"
        <?= $Page->hsn->editAttributes() ?>>
        <?= $Page->hsn->selectOptionListHtml("x_hsn") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->hsn->getErrorMessage(false) ?></div>
<?= $Page->hsn->Lookup->getParamTag($Page, "p_x_hsn") ?>
<?php if (!$Page->hsn->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_hsn", selectId: "frefsearch_x_hsn" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.hsn?.lookupOptions.length) {
        options.data = { id: "x_hsn", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_hsn", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.hsn.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
    <div id="r_composition" class="row"<?= $Page->composition->rowAttributes() ?>>
        <label for="x_composition" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_composition"><?= $Page->composition->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_composition" id="z_composition" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->composition->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_composition" class="ew-search-field ew-search-field-single">
    <select
        id="x_composition"
        name="x_composition"
        class="form-select ew-select<?= $Page->composition->isInvalidClass() ?>"
        <?php if (!$Page->composition->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_composition"
        <?php } ?>
        data-table="ref"
        data-field="x_composition"
        data-page="4"
        data-value-separator="<?= $Page->composition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->composition->getPlaceHolder()) ?>"
        <?= $Page->composition->editAttributes() ?>>
        <?= $Page->composition->selectOptionListHtml("x_composition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->composition->getErrorMessage(false) ?></div>
<?= $Page->composition->Lookup->getParamTag($Page, "p_x_composition") ?>
<?php if (!$Page->composition->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_composition", selectId: "frefsearch_x_composition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.composition?.lookupOptions.length) {
        options.data = { id: "x_composition", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_composition", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.composition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_category"
        <?php } ?>
        data-table="ref"
        data-field="x_category"
        data-page="4"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_category", selectId: "frefsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_category", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->moq->Visible) { // moq ?>
    <div id="r_moq" class="row"<?= $Page->moq->rowAttributes() ?>>
        <label for="x_moq" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_moq"><?= $Page->moq->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_moq" id="z_moq" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->moq->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_moq" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->moq->getInputTextType() ?>" name="x_moq" id="x_moq" data-table="ref" data-field="x_moq" value="<?= $Page->moq->EditValue ?>" data-page="4" size="30" placeholder="<?= HtmlEncode($Page->moq->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->moq->formatPattern()) ?>"<?= $Page->moq->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->moq->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_status"
        <?php } ?>
        data-table="ref"
        data-field="x_status"
        data-page="4"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_status", selectId: "frefsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_status", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(5)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref5"><?= $Page->pageCaption(5) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(5)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref5"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->d_head_01->Visible) { // d_head_01 ?>
    <div id="r_d_head_01" class="row"<?= $Page->d_head_01->rowAttributes() ?>>
        <label for="x_d_head_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_d_head_01"><?= $Page->d_head_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_head_01" id="z_d_head_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_head_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_d_head_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_head_01->getInputTextType() ?>" name="x_d_head_01" id="x_d_head_01" data-table="ref" data-field="x_d_head_01" value="<?= $Page->d_head_01->EditValue ?>" data-page="5" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->d_head_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_head_01->formatPattern()) ?>"<?= $Page->d_head_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_head_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_description_01->Visible) { // d_description_01 ?>
    <div id="r_d_description_01" class="row"<?= $Page->d_description_01->rowAttributes() ?>>
        <label for="x_d_description_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_d_description_01"><?= $Page->d_description_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_description_01" id="z_d_description_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_description_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_d_description_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_description_01->getInputTextType() ?>" name="x_d_description_01" id="x_d_description_01" data-table="ref" data-field="x_d_description_01" value="<?= $Page->d_description_01->EditValue ?>" data-page="5" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->d_description_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_description_01->formatPattern()) ?>"<?= $Page->d_description_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_description_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_head_02->Visible) { // d_head_02 ?>
    <div id="r_d_head_02" class="row"<?= $Page->d_head_02->rowAttributes() ?>>
        <label for="x_d_head_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_d_head_02"><?= $Page->d_head_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_head_02" id="z_d_head_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_head_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_d_head_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_head_02->getInputTextType() ?>" name="x_d_head_02" id="x_d_head_02" data-table="ref" data-field="x_d_head_02" value="<?= $Page->d_head_02->EditValue ?>" data-page="5" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->d_head_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_head_02->formatPattern()) ?>"<?= $Page->d_head_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_head_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_description_02->Visible) { // d_description_02 ?>
    <div id="r_d_description_02" class="row"<?= $Page->d_description_02->rowAttributes() ?>>
        <label for="x_d_description_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_d_description_02"><?= $Page->d_description_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_d_description_02" id="z_d_description_02" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_description_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_d_description_02" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_description_02->getInputTextType() ?>" name="x_d_description_02" id="x_d_description_02" data-table="ref" data-field="x_d_description_02" value="<?= $Page->d_description_02->EditValue ?>" data-page="5" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->d_description_02->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_description_02->formatPattern()) ?>"<?= $Page->d_description_02->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_description_02->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->publish->Visible) { // publish ?>
    <div id="r_publish" class="row"<?= $Page->publish->rowAttributes() ?>>
        <label for="x_publish" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_publish"><?= $Page->publish->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_publish" id="z_publish" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->publish->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_publish" class="ew-search-field ew-search-field-single">
    <select
        id="x_publish"
        name="x_publish"
        class="form-select ew-select<?= $Page->publish->isInvalidClass() ?>"
        <?php if (!$Page->publish->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_publish"
        <?php } ?>
        data-table="ref"
        data-field="x_publish"
        data-page="5"
        data-value-separator="<?= $Page->publish->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->publish->getPlaceHolder()) ?>"
        <?= $Page->publish->editAttributes() ?>>
        <?= $Page->publish->selectOptionListHtml("x_publish") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->publish->getErrorMessage(false) ?></div>
<?php if (!$Page->publish->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_publish", selectId: "frefsearch_x_publish" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.publish?.lookupOptions.length) {
        options.data = { id: "x_publish", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_publish", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.publish.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->keywords->Visible) { // keywords ?>
    <div id="r_keywords" class="row"<?= $Page->keywords->rowAttributes() ?>>
        <label for="x_keywords" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_keywords"><?= $Page->keywords->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_keywords" id="z_keywords" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->keywords->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_keywords" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->keywords->getInputTextType() ?>" name="x_keywords" id="x_keywords" data-table="ref" data-field="x_keywords" value="<?= $Page->keywords->EditValue ?>" data-page="5" maxlength="250" placeholder="<?= HtmlEncode($Page->keywords->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->keywords->formatPattern()) ?>"<?= $Page->keywords->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->keywords->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="frefsearch_x_operator"
        <?php } ?>
        data-table="ref"
        data-field="x_operator"
        data-page="5"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsearch", function() {
    var options = { name: "x_operator", selectId: "frefsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "frefsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "frefsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_ref_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="ref" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="5" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_ref_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="ref" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" data-page="5" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frefsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frefsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="frefsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
