<?php

namespace PHPMaker2024\fibre;

// Page object
$RefList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="frefsrch" id="frefsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="frefsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref: currentTable } });
var currentForm;
var frefsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frefsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_n", [], fields.product_n.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->id->Visible) { // id ?>
<?php
if (!$Page->id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_id" class="ew-search-caption ew-label"><?= $Page->id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</div>
        </div>
        <div id="el_ref_id" class="ew-search-field">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="ref" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_grp" class="ew-search-caption ew-label"><?= $Page->grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</div>
        </div>
        <div id="el_ref_grp" class="ew-search-field">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="frefsrch_x_grp"
        <?php } ?>
        data-table="ref"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsrch", function() {
    var options = { name: "x_grp", selectId: "frefsrch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsrch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "frefsrch" };
    } else {
        options.ajax = { id: "x_grp", form: "frefsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
<?php
if (!$Page->s_grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_s_grp" class="ew-search-caption ew-label"><?= $Page->s_grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</div>
        </div>
        <div id="el_ref_s_grp" class="ew-search-field">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="frefsrch_x_s_grp"
        <?php } ?>
        data-table="ref"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsrch", function() {
    var options = { name: "x_s_grp", selectId: "frefsrch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsrch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "frefsrch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "frefsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
<?php
if (!$Page->product->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product" class="ew-search-caption ew-label"><?= $Page->product->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</div>
        </div>
        <div id="el_ref_product" class="ew-search-field">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="frefsrch_x_product"
        <?php } ?>
        data-table="ref"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsrch", function() {
    var options = { name: "x_product", selectId: "frefsrch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsrch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "frefsrch" };
    } else {
        options.ajax = { id: "x_product", form: "frefsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_n->Visible) { // product_n ?>
<?php
if (!$Page->product_n->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_n" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_n->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product_n" class="ew-search-caption ew-label"><?= $Page->product_n->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_n" id="z_product_n" value="LIKE">
</div>
        </div>
        <div id="el_ref_product_n" class="ew-search-field">
<input type="<?= $Page->product_n->getInputTextType() ?>" name="x_product_n" id="x_product_n" data-table="ref" data-field="x_product_n" value="<?= $Page->product_n->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_n->formatPattern()) ?>"<?= $Page->product_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_n->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
<?php
if (!$Page->product_code->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_code" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_code->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product_code" class="ew-search-caption ew-label"><?= $Page->product_code->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</div>
        </div>
        <div id="el_ref_product_code" class="ew-search-field">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="ref" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_ref_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="frefsrch_x_status"
        <?php } ?>
        data-table="ref"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("frefsrch", function() {
    var options = { name: "x_status", selectId: "frefsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frefsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "frefsrch" };
    } else {
        options.ajax = { id: "x_status", form: "frefsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="frefsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="frefsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="frefsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="frefsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="frefsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="frefsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="frefsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_ref" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_reflist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_ref_id" class="ref_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_ref_grp" class="ref_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_ref_s_grp" class="ref_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_ref_product" class="ref_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_ref_packing_type" class="ref_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->product_n->Visible) { // product_n ?>
        <th data-name="product_n" class="<?= $Page->product_n->headerCellClass() ?>"><div id="elh_ref_product_n" class="ref_product_n"><?= $Page->renderFieldHeader($Page->product_n) ?></div></th>
<?php } ?>
<?php if ($Page->product_code_type->Visible) { // product_code_type ?>
        <th data-name="product_code_type" class="<?= $Page->product_code_type->headerCellClass() ?>"><div id="elh_ref_product_code_type" class="ref_product_code_type"><?= $Page->renderFieldHeader($Page->product_code_type) ?></div></th>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
        <th data-name="product_code" class="<?= $Page->product_code->headerCellClass() ?>"><div id="elh_ref_product_code" class="ref_product_code"><?= $Page->renderFieldHeader($Page->product_code) ?></div></th>
<?php } ?>
<?php if ($Page->v_00->Visible) { // v_00 ?>
        <th data-name="v_00" class="<?= $Page->v_00->headerCellClass() ?>"><div id="elh_ref_v_00" class="ref_v_00"><?= $Page->renderFieldHeader($Page->v_00) ?></div></th>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
        <th data-name="q_sku" class="<?= $Page->q_sku->headerCellClass() ?>"><div id="elh_ref_q_sku" class="ref_q_sku"><?= $Page->renderFieldHeader($Page->q_sku) ?></div></th>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
        <th data-name="composition" class="<?= $Page->composition->headerCellClass() ?>"><div id="elh_ref_composition" class="ref_composition"><?= $Page->renderFieldHeader($Page->composition) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_ref_category" class="ref_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_ref_status" class="ref_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_id" class="el_ref_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_grp" class="el_ref_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_s_grp" class="el_ref_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_product" class="el_ref_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_packing_type" class="el_ref_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_n->Visible) { // product_n ?>
        <td data-name="product_n"<?= $Page->product_n->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_product_n" class="el_ref_product_n">
<span<?= $Page->product_n->viewAttributes() ?>>
<?= $Page->product_n->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_code_type->Visible) { // product_code_type ?>
        <td data-name="product_code_type"<?= $Page->product_code_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_product_code_type" class="el_ref_product_code_type">
<span<?= $Page->product_code_type->viewAttributes() ?>>
<?= $Page->product_code_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code"<?= $Page->product_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_product_code" class="el_ref_product_code">
<span<?= $Page->product_code->viewAttributes() ?>>
<?= $Page->product_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_00->Visible) { // v_00 ?>
        <td data-name="v_00"<?= $Page->v_00->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_v_00" class="el_ref_v_00">
<span<?= $Page->v_00->viewAttributes() ?>>
<?= $Page->v_00->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->q_sku->Visible) { // q_sku ?>
        <td data-name="q_sku"<?= $Page->q_sku->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_q_sku" class="el_ref_q_sku">
<span<?= $Page->q_sku->viewAttributes() ?>>
<?= $Page->q_sku->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->composition->Visible) { // composition ?>
        <td data-name="composition"<?= $Page->composition->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_composition" class="el_ref_composition">
<span<?= $Page->composition->viewAttributes() ?>>
<?= $Page->composition->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_category" class="el_ref_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_ref_status" class="el_ref_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
