<?php

namespace PHPMaker2024\fibre;

// Page object
$RefImageView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fref_imageview" id="fref_imageview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref_image: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fref_imageview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fref_imageview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_ref_image_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <tr id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_grp"><?= $Page->grp->caption() ?></span></td>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el_ref_image_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->getViewValue()) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><?= $Page->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <tr id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_s_grp"><?= $Page->s_grp->caption() ?></span></td>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_ref_image_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <tr id="r_product"<?= $Page->product->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_product"><?= $Page->product->caption() ?></span></td>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el_ref_image_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <tr id="r_product_code"<?= $Page->product_code->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_product_code"><?= $Page->product_code->caption() ?></span></td>
        <td data-name="product_code"<?= $Page->product_code->cellAttributes() ?>>
<span id="el_ref_image_product_code">
<span<?= $Page->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_code->getViewValue()) && $Page->product_code->linkAttributes() != "") { ?>
<a<?= $Page->product_code->linkAttributes() ?>><?= $Page->product_code->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->main_image->Visible) { // main_image ?>
    <tr id="r_main_image"<?= $Page->main_image->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_main_image"><?= $Page->main_image->caption() ?></span></td>
        <td data-name="main_image"<?= $Page->main_image->cellAttributes() ?>>
<span id="el_ref_image_main_image">
<span>
<?= GetFileViewTag($Page->main_image, $Page->main_image->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->top_view->Visible) { // top_view ?>
    <tr id="r_top_view"<?= $Page->top_view->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_top_view"><?= $Page->top_view->caption() ?></span></td>
        <td data-name="top_view"<?= $Page->top_view->cellAttributes() ?>>
<span id="el_ref_image_top_view">
<span>
<?= GetFileViewTag($Page->top_view, $Page->top_view->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->front_view->Visible) { // front_view ?>
    <tr id="r_front_view"<?= $Page->front_view->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_front_view"><?= $Page->front_view->caption() ?></span></td>
        <td data-name="front_view"<?= $Page->front_view->cellAttributes() ?>>
<span id="el_ref_image_front_view">
<span>
<?= GetFileViewTag($Page->front_view, $Page->front_view->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->corner_view->Visible) { // corner_view ?>
    <tr id="r_corner_view"<?= $Page->corner_view->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_corner_view"><?= $Page->corner_view->caption() ?></span></td>
        <td data-name="corner_view"<?= $Page->corner_view->cellAttributes() ?>>
<span id="el_ref_image_corner_view">
<span>
<?= GetFileViewTag($Page->corner_view, $Page->corner_view->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->back_view->Visible) { // back_view ?>
    <tr id="r_back_view"<?= $Page->back_view->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_back_view"><?= $Page->back_view->caption() ?></span></td>
        <td data-name="back_view"<?= $Page->back_view->cellAttributes() ?>>
<span id="el_ref_image_back_view">
<span>
<?= GetFileViewTag($Page->back_view, $Page->back_view->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->color_options->Visible) { // color_options ?>
    <tr id="r_color_options"<?= $Page->color_options->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_color_options"><?= $Page->color_options->caption() ?></span></td>
        <td data-name="color_options"<?= $Page->color_options->cellAttributes() ?>>
<span id="el_ref_image_color_options">
<span>
<?= GetFileViewTag($Page->color_options, $Page->color_options->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->other_options->Visible) { // other_options ?>
    <tr id="r_other_options"<?= $Page->other_options->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_other_options"><?= $Page->other_options->caption() ?></span></td>
        <td data-name="other_options"<?= $Page->other_options->cellAttributes() ?>>
<span id="el_ref_image_other_options">
<span>
<?= GetFileViewTag($Page->other_options, $Page->other_options->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->video_url->Visible) { // video_url ?>
    <tr id="r_video_url"<?= $Page->video_url->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_video_url"><?= $Page->video_url->caption() ?></span></td>
        <td data-name="video_url"<?= $Page->video_url->cellAttributes() ?>>
<span id="el_ref_image_video_url">
<span<?= $Page->video_url->viewAttributes() ?>>
<?= $Page->video_url->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->group_image->Visible) { // group_image ?>
    <tr id="r_group_image"<?= $Page->group_image->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_group_image"><?= $Page->group_image->caption() ?></span></td>
        <td data-name="group_image"<?= $Page->group_image->cellAttributes() ?>>
<span id="el_ref_image_group_image">
<span<?= $Page->group_image->viewAttributes() ?>>
<?= GetFileViewTag($Page->group_image, $Page->group_image->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <tr id="r_status"<?= $Page->status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_status"><?= $Page->status->caption() ?></span></td>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el_ref_image_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <tr id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_company_id"><?= $Page->company_id->caption() ?></span></td>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el_ref_image_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->company_id->getViewValue()) && $Page->company_id->linkAttributes() != "") { ?>
<a<?= $Page->company_id->linkAttributes() ?>><?= $Page->company_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->company_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <tr id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_product_type"><?= $Page->product_type->caption() ?></span></td>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el_ref_image_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_ref_image_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?php if (!EmptyString($Page->operator->getViewValue()) && $Page->operator->linkAttributes() != "") { ?>
<a<?= $Page->operator->linkAttributes() ?>><?= $Page->operator->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->operator->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_ref_image_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_ref_image_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
