<?php

namespace PHPMaker2024\fibre;

// Page object
$RefImageSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref_image: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fref_imagesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fref_imagesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["main_image", [], fields.main_image.isInvalid],
            ["top_view", [], fields.top_view.isInvalid],
            ["front_view", [], fields.front_view.isInvalid],
            ["corner_view", [], fields.corner_view.isInvalid],
            ["back_view", [], fields.back_view.isInvalid],
            ["color_options", [], fields.color_options.isInvalid],
            ["other_options", [], fields.other_options.isInvalid],
            ["video_url", [], fields.video_url.isInvalid],
            ["group_image", [], fields.group_image.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fref_imagesearch" id="fref_imagesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="ref_image" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_grp"
        <?php } ?>
        data-table="ref_image"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_grp", selectId: "fref_imagesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_s_grp"
        <?php } ?>
        data-table="ref_image"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_s_grp", selectId: "fref_imagesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_product"
        <?php } ?>
        data-table="ref_image"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_product", selectId: "fref_imagesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="ref_image" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->main_image->Visible) { // main_image ?>
    <div id="r_main_image" class="row"<?= $Page->main_image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_main_image"><?= $Page->main_image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_main_image" id="z_main_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->main_image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_main_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->main_image->getInputTextType() ?>" name="x_main_image" id="x_main_image" data-table="ref_image" data-field="x_main_image" value="<?= $Page->main_image->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->main_image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->main_image->formatPattern()) ?>"<?= $Page->main_image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->main_image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->top_view->Visible) { // top_view ?>
    <div id="r_top_view" class="row"<?= $Page->top_view->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_top_view"><?= $Page->top_view->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_top_view" id="z_top_view" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->top_view->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_top_view" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->top_view->getInputTextType() ?>" name="x_top_view" id="x_top_view" data-table="ref_image" data-field="x_top_view" value="<?= $Page->top_view->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->top_view->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->top_view->formatPattern()) ?>"<?= $Page->top_view->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->top_view->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->front_view->Visible) { // front_view ?>
    <div id="r_front_view" class="row"<?= $Page->front_view->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_front_view"><?= $Page->front_view->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_front_view" id="z_front_view" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->front_view->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_front_view" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->front_view->getInputTextType() ?>" name="x_front_view" id="x_front_view" data-table="ref_image" data-field="x_front_view" value="<?= $Page->front_view->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->front_view->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->front_view->formatPattern()) ?>"<?= $Page->front_view->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->front_view->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->corner_view->Visible) { // corner_view ?>
    <div id="r_corner_view" class="row"<?= $Page->corner_view->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_corner_view"><?= $Page->corner_view->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_corner_view" id="z_corner_view" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->corner_view->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_corner_view" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->corner_view->getInputTextType() ?>" name="x_corner_view" id="x_corner_view" data-table="ref_image" data-field="x_corner_view" value="<?= $Page->corner_view->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->corner_view->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->corner_view->formatPattern()) ?>"<?= $Page->corner_view->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->corner_view->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->back_view->Visible) { // back_view ?>
    <div id="r_back_view" class="row"<?= $Page->back_view->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_back_view"><?= $Page->back_view->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_back_view" id="z_back_view" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->back_view->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_back_view" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->back_view->getInputTextType() ?>" name="x_back_view" id="x_back_view" data-table="ref_image" data-field="x_back_view" value="<?= $Page->back_view->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->back_view->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->back_view->formatPattern()) ?>"<?= $Page->back_view->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->back_view->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->color_options->Visible) { // color_options ?>
    <div id="r_color_options" class="row"<?= $Page->color_options->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_color_options"><?= $Page->color_options->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_color_options" id="z_color_options" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->color_options->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_color_options" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->color_options->getInputTextType() ?>" name="x_color_options" id="x_color_options" data-table="ref_image" data-field="x_color_options" value="<?= $Page->color_options->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->color_options->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->color_options->formatPattern()) ?>"<?= $Page->color_options->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->color_options->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_options->Visible) { // other_options ?>
    <div id="r_other_options" class="row"<?= $Page->other_options->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_other_options"><?= $Page->other_options->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other_options" id="z_other_options" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_options->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_other_options" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_options->getInputTextType() ?>" name="x_other_options" id="x_other_options" data-table="ref_image" data-field="x_other_options" value="<?= $Page->other_options->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->other_options->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_options->formatPattern()) ?>"<?= $Page->other_options->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_options->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->video_url->Visible) { // video_url ?>
    <div id="r_video_url" class="row"<?= $Page->video_url->rowAttributes() ?>>
        <label for="x_video_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_video_url"><?= $Page->video_url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_video_url" id="z_video_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->video_url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_video_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->video_url->getInputTextType() ?>" name="x_video_url" id="x_video_url" data-table="ref_image" data-field="x_video_url" value="<?= $Page->video_url->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->video_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->video_url->formatPattern()) ?>"<?= $Page->video_url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->video_url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->group_image->Visible) { // group_image ?>
    <div id="r_group_image" class="row"<?= $Page->group_image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_group_image"><?= $Page->group_image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_group_image" id="z_group_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->group_image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_group_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->group_image->getInputTextType() ?>" name="x_group_image" id="x_group_image" data-table="ref_image" data-field="x_group_image" value="<?= $Page->group_image->EditValue ?>" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->group_image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->group_image->formatPattern()) ?>"<?= $Page->group_image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->group_image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_status"
        <?php } ?>
        data-table="ref_image"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_status", selectId: "fref_imagesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_company_id"
        <?php } ?>
        data-table="ref_image"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_company_id", selectId: "fref_imagesearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_product_type"
        <?php } ?>
        data-table="ref_image"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_product_type", selectId: "fref_imagesearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_image_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fref_imagesearch_x_operator"
        <?php } ?>
        data-table="ref_image"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_imagesearch", function() {
    var options = { name: "x_operator", selectId: "fref_imagesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_imagesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fref_imagesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fref_imagesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_image.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_image_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_ref_image_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="ref_image" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_ref_image_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="ref_image" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fref_imagesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fref_imagesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fref_imagesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("ref_image");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
