<?php

namespace PHPMaker2024\fibre;

// Page object
$RefImageEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fref_imageedit" id="fref_imageedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref_image: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fref_imageedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fref_imageedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_code", [fields.product_code.visible && fields.product_code.required ? ew.Validators.required(fields.product_code.caption) : null], fields.product_code.isInvalid],
            ["main_image", [fields.main_image.visible && fields.main_image.required ? ew.Validators.fileRequired(fields.main_image.caption) : null], fields.main_image.isInvalid],
            ["top_view", [fields.top_view.visible && fields.top_view.required ? ew.Validators.fileRequired(fields.top_view.caption) : null], fields.top_view.isInvalid],
            ["front_view", [fields.front_view.visible && fields.front_view.required ? ew.Validators.fileRequired(fields.front_view.caption) : null], fields.front_view.isInvalid],
            ["corner_view", [fields.corner_view.visible && fields.corner_view.required ? ew.Validators.fileRequired(fields.corner_view.caption) : null], fields.corner_view.isInvalid],
            ["back_view", [fields.back_view.visible && fields.back_view.required ? ew.Validators.fileRequired(fields.back_view.caption) : null], fields.back_view.isInvalid],
            ["color_options", [fields.color_options.visible && fields.color_options.required ? ew.Validators.fileRequired(fields.color_options.caption) : null], fields.color_options.isInvalid],
            ["other_options", [fields.other_options.visible && fields.other_options.required ? ew.Validators.fileRequired(fields.other_options.caption) : null], fields.other_options.isInvalid],
            ["video_url", [fields.video_url.visible && fields.video_url.required ? ew.Validators.required(fields.video_url.caption) : null], fields.video_url.isInvalid],
            ["group_image", [fields.group_image.visible && fields.group_image.required ? ew.Validators.fileRequired(fields.group_image.caption) : null], fields.group_image.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref_image">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_ref_image_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_ref_image_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="ref_image" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_ref_image_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_ref_image_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->EditValue) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->grp->getDisplayValue($Page->grp->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="ref_image" data-field="x_grp" data-hidden="1" name="x_grp" id="x_grp" value="<?= HtmlEncode($Page->grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_ref_image_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_ref_image_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->EditValue) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->s_grp->getDisplayValue($Page->s_grp->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->s_grp->getDisplayValue($Page->s_grp->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="ref_image" data-field="x_s_grp" data-hidden="1" name="x_s_grp" id="x_s_grp" value="<?= HtmlEncode($Page->s_grp->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_ref_image_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_ref_image_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->EditValue) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->product->getDisplayValue($Page->product->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->product->getDisplayValue($Page->product->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="ref_image" data-field="x_product" data-hidden="1" name="x_product" id="x_product" value="<?= HtmlEncode($Page->product->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code"<?= $Page->product_code->rowAttributes() ?>>
        <label id="elh_ref_image_product_code" for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_code->caption() ?><?= $Page->product_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_code->cellAttributes() ?>>
<span id="el_ref_image_product_code">
<span<?= $Page->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_code->EditValue) && $Page->product_code->linkAttributes() != "") { ?>
<a<?= $Page->product_code->linkAttributes() ?>><input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->product_code->getDisplayValue($Page->product_code->EditValue))) ?>"></a>
<?php } else { ?>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->product_code->getDisplayValue($Page->product_code->EditValue))) ?>">
<?php } ?>
</span>
<input type="hidden" data-table="ref_image" data-field="x_product_code" data-hidden="1" name="x_product_code" id="x_product_code" value="<?= HtmlEncode($Page->product_code->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->main_image->Visible) { // main_image ?>
    <div id="r_main_image"<?= $Page->main_image->rowAttributes() ?>>
        <label id="elh_ref_image_main_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->main_image->caption() ?><?= $Page->main_image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->main_image->cellAttributes() ?>>
<span id="el_ref_image_main_image">
<div id="fd_x_main_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_main_image"
        name="x_main_image"
        class="form-control ew-file-input"
        title="<?= $Page->main_image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_main_image"
        data-size="255"
        data-accept-file-types="<?= $Page->main_image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->main_image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->main_image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_main_image_help"
        <?= ($Page->main_image->ReadOnly || $Page->main_image->Disabled) ? " disabled" : "" ?>
        <?= $Page->main_image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->main_image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->main_image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_main_image" id= "fn_x_main_image" value="<?= $Page->main_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_main_image" id= "fa_x_main_image" value="<?= (Post("fa_x_main_image") == "0") ? "0" : "1" ?>">
<table id="ft_x_main_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->top_view->Visible) { // top_view ?>
    <div id="r_top_view"<?= $Page->top_view->rowAttributes() ?>>
        <label id="elh_ref_image_top_view" class="<?= $Page->LeftColumnClass ?>"><?= $Page->top_view->caption() ?><?= $Page->top_view->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->top_view->cellAttributes() ?>>
<span id="el_ref_image_top_view">
<div id="fd_x_top_view" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_top_view"
        name="x_top_view"
        class="form-control ew-file-input"
        title="<?= $Page->top_view->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_top_view"
        data-size="255"
        data-accept-file-types="<?= $Page->top_view->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->top_view->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->top_view->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->top_view->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_top_view_help"
        <?= ($Page->top_view->ReadOnly || $Page->top_view->Disabled) ? " disabled" : "" ?>
        <?= $Page->top_view->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->top_view->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->top_view->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_top_view" id= "fn_x_top_view" value="<?= $Page->top_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_top_view" id= "fa_x_top_view" value="<?= (Post("fa_x_top_view") == "0") ? "0" : "1" ?>">
<table id="ft_x_top_view" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->front_view->Visible) { // front_view ?>
    <div id="r_front_view"<?= $Page->front_view->rowAttributes() ?>>
        <label id="elh_ref_image_front_view" class="<?= $Page->LeftColumnClass ?>"><?= $Page->front_view->caption() ?><?= $Page->front_view->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->front_view->cellAttributes() ?>>
<span id="el_ref_image_front_view">
<div id="fd_x_front_view" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_front_view"
        name="x_front_view"
        class="form-control ew-file-input"
        title="<?= $Page->front_view->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_front_view"
        data-size="255"
        data-accept-file-types="<?= $Page->front_view->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->front_view->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->front_view->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->front_view->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_front_view_help"
        <?= ($Page->front_view->ReadOnly || $Page->front_view->Disabled) ? " disabled" : "" ?>
        <?= $Page->front_view->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->front_view->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->front_view->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_front_view" id= "fn_x_front_view" value="<?= $Page->front_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_front_view" id= "fa_x_front_view" value="<?= (Post("fa_x_front_view") == "0") ? "0" : "1" ?>">
<table id="ft_x_front_view" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->corner_view->Visible) { // corner_view ?>
    <div id="r_corner_view"<?= $Page->corner_view->rowAttributes() ?>>
        <label id="elh_ref_image_corner_view" class="<?= $Page->LeftColumnClass ?>"><?= $Page->corner_view->caption() ?><?= $Page->corner_view->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->corner_view->cellAttributes() ?>>
<span id="el_ref_image_corner_view">
<div id="fd_x_corner_view" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_corner_view"
        name="x_corner_view"
        class="form-control ew-file-input"
        title="<?= $Page->corner_view->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_corner_view"
        data-size="255"
        data-accept-file-types="<?= $Page->corner_view->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->corner_view->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->corner_view->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->corner_view->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_corner_view_help"
        <?= ($Page->corner_view->ReadOnly || $Page->corner_view->Disabled) ? " disabled" : "" ?>
        <?= $Page->corner_view->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->corner_view->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->corner_view->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_corner_view" id= "fn_x_corner_view" value="<?= $Page->corner_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_corner_view" id= "fa_x_corner_view" value="<?= (Post("fa_x_corner_view") == "0") ? "0" : "1" ?>">
<table id="ft_x_corner_view" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->back_view->Visible) { // back_view ?>
    <div id="r_back_view"<?= $Page->back_view->rowAttributes() ?>>
        <label id="elh_ref_image_back_view" class="<?= $Page->LeftColumnClass ?>"><?= $Page->back_view->caption() ?><?= $Page->back_view->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->back_view->cellAttributes() ?>>
<span id="el_ref_image_back_view">
<div id="fd_x_back_view" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_back_view"
        name="x_back_view"
        class="form-control ew-file-input"
        title="<?= $Page->back_view->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_back_view"
        data-size="255"
        data-accept-file-types="<?= $Page->back_view->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->back_view->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->back_view->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->back_view->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_back_view_help"
        <?= ($Page->back_view->ReadOnly || $Page->back_view->Disabled) ? " disabled" : "" ?>
        <?= $Page->back_view->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->back_view->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->back_view->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_back_view" id= "fn_x_back_view" value="<?= $Page->back_view->Upload->FileName ?>">
<input type="hidden" name="fa_x_back_view" id= "fa_x_back_view" value="<?= (Post("fa_x_back_view") == "0") ? "0" : "1" ?>">
<table id="ft_x_back_view" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->color_options->Visible) { // color_options ?>
    <div id="r_color_options"<?= $Page->color_options->rowAttributes() ?>>
        <label id="elh_ref_image_color_options" class="<?= $Page->LeftColumnClass ?>"><?= $Page->color_options->caption() ?><?= $Page->color_options->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->color_options->cellAttributes() ?>>
<span id="el_ref_image_color_options">
<div id="fd_x_color_options" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_color_options"
        name="x_color_options"
        class="form-control ew-file-input"
        title="<?= $Page->color_options->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_color_options"
        data-size="255"
        data-accept-file-types="<?= $Page->color_options->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->color_options->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->color_options->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->color_options->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_color_options_help"
        <?= ($Page->color_options->ReadOnly || $Page->color_options->Disabled) ? " disabled" : "" ?>
        <?= $Page->color_options->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->color_options->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->color_options->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_color_options" id= "fn_x_color_options" value="<?= $Page->color_options->Upload->FileName ?>">
<input type="hidden" name="fa_x_color_options" id= "fa_x_color_options" value="<?= (Post("fa_x_color_options") == "0") ? "0" : "1" ?>">
<table id="ft_x_color_options" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_options->Visible) { // other_options ?>
    <div id="r_other_options"<?= $Page->other_options->rowAttributes() ?>>
        <label id="elh_ref_image_other_options" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_options->caption() ?><?= $Page->other_options->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_options->cellAttributes() ?>>
<span id="el_ref_image_other_options">
<div id="fd_x_other_options" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_other_options"
        name="x_other_options"
        class="form-control ew-file-input"
        title="<?= $Page->other_options->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_other_options"
        data-size="255"
        data-accept-file-types="<?= $Page->other_options->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->other_options->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->other_options->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->other_options->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_other_options_help"
        <?= ($Page->other_options->ReadOnly || $Page->other_options->Disabled) ? " disabled" : "" ?>
        <?= $Page->other_options->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->other_options->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->other_options->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_other_options" id= "fn_x_other_options" value="<?= $Page->other_options->Upload->FileName ?>">
<input type="hidden" name="fa_x_other_options" id= "fa_x_other_options" value="<?= (Post("fa_x_other_options") == "0") ? "0" : "1" ?>">
<table id="ft_x_other_options" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->video_url->Visible) { // video_url ?>
    <div id="r_video_url"<?= $Page->video_url->rowAttributes() ?>>
        <label id="elh_ref_image_video_url" for="x_video_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->video_url->caption() ?><?= $Page->video_url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->video_url->cellAttributes() ?>>
<span id="el_ref_image_video_url">
<input type="<?= $Page->video_url->getInputTextType() ?>" name="x_video_url" id="x_video_url" data-table="ref_image" data-field="x_video_url" value="<?= $Page->video_url->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->video_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->video_url->formatPattern()) ?>"<?= $Page->video_url->editAttributes() ?> aria-describedby="x_video_url_help">
<?= $Page->video_url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->video_url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->group_image->Visible) { // group_image ?>
    <div id="r_group_image"<?= $Page->group_image->rowAttributes() ?>>
        <label id="elh_ref_image_group_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->group_image->caption() ?><?= $Page->group_image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->group_image->cellAttributes() ?>>
<span id="el_ref_image_group_image">
<div id="fd_x_group_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_group_image"
        name="x_group_image"
        class="form-control ew-file-input"
        title="<?= $Page->group_image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="ref_image"
        data-field="x_group_image"
        data-size="196"
        data-accept-file-types="<?= $Page->group_image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->group_image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->group_image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_group_image_help"
        <?= ($Page->group_image->ReadOnly || $Page->group_image->Disabled) ? " disabled" : "" ?>
        <?= $Page->group_image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->group_image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->group_image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_group_image" id= "fn_x_group_image" value="<?= $Page->group_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_group_image" id= "fa_x_group_image" value="<?= (Post("fa_x_group_image") == "0") ? "0" : "1" ?>">
<table id="ft_x_group_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_ref_image_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_ref_image_status">
<span<?= $Page->status->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->status->getDisplayValue($Page->status->EditValue) ?></span></span>
<input type="hidden" data-table="ref_image" data-field="x_status" data-hidden="1" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_ref_image_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_ref_image_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->company_id->EditValue) && $Page->company_id->linkAttributes() != "") { ?>
<a<?= $Page->company_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->company_id->getDisplayValue($Page->company_id->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->company_id->getDisplayValue($Page->company_id->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="ref_image" data-field="x_company_id" data-hidden="1" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type"<?= $Page->product_type->rowAttributes() ?>>
        <label id="elh_ref_image_product_type" for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_type->caption() ?><?= $Page->product_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_type->cellAttributes() ?>>
<span id="el_ref_image_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->product_type->getDisplayValue($Page->product_type->EditValue) ?></span></span>
<input type="hidden" data-table="ref_image" data-field="x_product_type" data-hidden="1" name="x_product_type" id="x_product_type" value="<?= HtmlEncode($Page->product_type->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fref_imageedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fref_imageedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("ref_image");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
