<?php

namespace PHPMaker2024\fibre;

// Page object
$RefCodeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { ref_code: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fref_codesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fref_codesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["product_code_type", [], fields.product_code_type.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["v_00", [], fields.v_00.isInvalid],
            ["v_01", [], fields.v_01.isInvalid],
            ["v_02", [], fields.v_02.isInvalid],
            ["v_03", [], fields.v_03.isInvalid],
            ["v_04", [], fields.v_04.isInvalid],
            ["v_05", [], fields.v_05.isInvalid],
            ["v_06", [], fields.v_06.isInvalid],
            ["v_07", [], fields.v_07.isInvalid],
            ["v_08", [], fields.v_08.isInvalid],
            ["v_09", [], fields.v_09.isInvalid],
            ["v_10", [], fields.v_10.isInvalid],
            ["last_price", [ew.Validators.float], fields.last_price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["composition", [], fields.composition.isInvalid],
            ["moq", [ew.Validators.float], fields.moq.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "product_code_type": <?= $Page->product_code_type->toClientList($Page) ?>,
            "v_01": <?= $Page->v_01->toClientList($Page) ?>,
            "v_02": <?= $Page->v_02->toClientList($Page) ?>,
            "v_03": <?= $Page->v_03->toClientList($Page) ?>,
            "v_04": <?= $Page->v_04->toClientList($Page) ?>,
            "v_05": <?= $Page->v_05->toClientList($Page) ?>,
            "v_06": <?= $Page->v_06->toClientList($Page) ?>,
            "v_07": <?= $Page->v_07->toClientList($Page) ?>,
            "v_08": <?= $Page->v_08->toClientList($Page) ?>,
            "v_09": <?= $Page->v_09->toClientList($Page) ?>,
            "v_10": <?= $Page->v_10->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "composition": <?= $Page->composition->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fref_codesearch" id="fref_codesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="ref_code">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="ref_code" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_grp"
        <?php } ?>
        data-table="ref_code"
        data-field="x_grp"
        data-page="0"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_grp", selectId: "fref_codesearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_s_grp"
        <?php } ?>
        data-table="ref_code"
        data-field="x_s_grp"
        data-page="0"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_s_grp", selectId: "fref_codesearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_product"
        <?php } ?>
        data-table="ref_code"
        data-field="x_product"
        data-page="0"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_product", selectId: "fref_codesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_product_type"
        <?php } ?>
        data-table="ref_code"
        data-field="x_product_type"
        data-page="0"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_product_type", selectId: "fref_codesearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_packing_type"
        <?php } ?>
        data-table="ref_code"
        data-field="x_packing_type"
        data-page="0"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_packing_type", selectId: "fref_codesearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code_type->Visible) { // product_code_type ?>
    <div id="r_product_code_type" class="row"<?= $Page->product_code_type->rowAttributes() ?>>
        <label for="x_product_code_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_product_code_type"><?= $Page->product_code_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_code_type" id="z_product_code_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_product_code_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_code_type"
        name="x_product_code_type"
        class="form-select ew-select<?= $Page->product_code_type->isInvalidClass() ?>"
        <?php if (!$Page->product_code_type->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_product_code_type"
        <?php } ?>
        data-table="ref_code"
        data-field="x_product_code_type"
        data-page="0"
        data-value-separator="<?= $Page->product_code_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_code_type->getPlaceHolder()) ?>"
        <?= $Page->product_code_type->editAttributes() ?>>
        <?= $Page->product_code_type->selectOptionListHtml("x_product_code_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_code_type->getErrorMessage(false) ?></div>
<?php if (!$Page->product_code_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_product_code_type", selectId: "fref_codesearch_x_product_code_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.product_code_type?.lookupOptions.length) {
        options.data = { id: "x_product_code_type", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_product_code_type", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.product_code_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="ref_code" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" data-page="0" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_RefCodeSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref_code1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref_code1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->v_00->Visible) { // v_00 ?>
    <div id="r_v_00" class="row"<?= $Page->v_00->rowAttributes() ?>>
        <label for="x_v_00" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_00"><?= $Page->v_00->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_00" id="z_v_00" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_00->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_00" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->v_00->getInputTextType() ?>" name="x_v_00" id="x_v_00" data-table="ref_code" data-field="x_v_00" value="<?= $Page->v_00->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->v_00->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->v_00->formatPattern()) ?>"<?= $Page->v_00->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->v_00->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
    <div id="r_v_01" class="row"<?= $Page->v_01->rowAttributes() ?>>
        <label for="x_v_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_01"><?= $Page->v_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_01" id="z_v_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_01"
        name="x_v_01"
        class="form-select ew-select<?= $Page->v_01->isInvalidClass() ?>"
        <?php if (!$Page->v_01->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_01"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_01"
        data-page="1"
        data-value-separator="<?= $Page->v_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_01->getPlaceHolder()) ?>"
        <?= $Page->v_01->editAttributes() ?>>
        <?= $Page->v_01->selectOptionListHtml("x_v_01") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_01->getErrorMessage(false) ?></div>
<?= $Page->v_01->Lookup->getParamTag($Page, "p_x_v_01") ?>
<?php if (!$Page->v_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_01", selectId: "fref_codesearch_x_v_01" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_01?.lookupOptions.length) {
        options.data = { id: "x_v_01", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_01", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
    <div id="r_v_02" class="row"<?= $Page->v_02->rowAttributes() ?>>
        <label for="x_v_02" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_02"><?= $Page->v_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_02" id="z_v_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_02"
        name="x_v_02"
        class="form-select ew-select<?= $Page->v_02->isInvalidClass() ?>"
        <?php if (!$Page->v_02->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_02"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_02"
        data-page="1"
        data-value-separator="<?= $Page->v_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_02->getPlaceHolder()) ?>"
        <?= $Page->v_02->editAttributes() ?>>
        <?= $Page->v_02->selectOptionListHtml("x_v_02") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_02->getErrorMessage(false) ?></div>
<?= $Page->v_02->Lookup->getParamTag($Page, "p_x_v_02") ?>
<?php if (!$Page->v_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_02", selectId: "fref_codesearch_x_v_02" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_02?.lookupOptions.length) {
        options.data = { id: "x_v_02", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_02", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
    <div id="r_v_03" class="row"<?= $Page->v_03->rowAttributes() ?>>
        <label for="x_v_03" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_03"><?= $Page->v_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_03" id="z_v_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_03"
        name="x_v_03"
        class="form-select ew-select<?= $Page->v_03->isInvalidClass() ?>"
        <?php if (!$Page->v_03->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_03"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_03"
        data-page="1"
        data-value-separator="<?= $Page->v_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_03->getPlaceHolder()) ?>"
        <?= $Page->v_03->editAttributes() ?>>
        <?= $Page->v_03->selectOptionListHtml("x_v_03") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_03->getErrorMessage(false) ?></div>
<?= $Page->v_03->Lookup->getParamTag($Page, "p_x_v_03") ?>
<?php if (!$Page->v_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_03", selectId: "fref_codesearch_x_v_03" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_03?.lookupOptions.length) {
        options.data = { id: "x_v_03", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_03", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
    <div id="r_v_04" class="row"<?= $Page->v_04->rowAttributes() ?>>
        <label for="x_v_04" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_04"><?= $Page->v_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_04" id="z_v_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_04" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_04"
        name="x_v_04"
        class="form-select ew-select<?= $Page->v_04->isInvalidClass() ?>"
        <?php if (!$Page->v_04->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_04"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_04"
        data-page="1"
        data-value-separator="<?= $Page->v_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_04->getPlaceHolder()) ?>"
        <?= $Page->v_04->editAttributes() ?>>
        <?= $Page->v_04->selectOptionListHtml("x_v_04") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_04->getErrorMessage(false) ?></div>
<?= $Page->v_04->Lookup->getParamTag($Page, "p_x_v_04") ?>
<?php if (!$Page->v_04->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_04", selectId: "fref_codesearch_x_v_04" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_04?.lookupOptions.length) {
        options.data = { id: "x_v_04", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_04", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_04.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
    <div id="r_v_05" class="row"<?= $Page->v_05->rowAttributes() ?>>
        <label for="x_v_05" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_05"><?= $Page->v_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_05" id="z_v_05" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_05" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_05"
        name="x_v_05"
        class="form-select ew-select<?= $Page->v_05->isInvalidClass() ?>"
        <?php if (!$Page->v_05->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_05"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_05"
        data-page="1"
        data-value-separator="<?= $Page->v_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_05->getPlaceHolder()) ?>"
        <?= $Page->v_05->editAttributes() ?>>
        <?= $Page->v_05->selectOptionListHtml("x_v_05") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_05->getErrorMessage(false) ?></div>
<?= $Page->v_05->Lookup->getParamTag($Page, "p_x_v_05") ?>
<?php if (!$Page->v_05->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_05", selectId: "fref_codesearch_x_v_05" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_05?.lookupOptions.length) {
        options.data = { id: "x_v_05", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_05", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_05.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_06->Visible) { // v_06 ?>
    <div id="r_v_06" class="row"<?= $Page->v_06->rowAttributes() ?>>
        <label for="x_v_06" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_06"><?= $Page->v_06->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_06" id="z_v_06" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_06->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_06" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_06"
        name="x_v_06"
        class="form-select ew-select<?= $Page->v_06->isInvalidClass() ?>"
        <?php if (!$Page->v_06->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_06"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_06"
        data-page="1"
        data-value-separator="<?= $Page->v_06->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_06->getPlaceHolder()) ?>"
        <?= $Page->v_06->editAttributes() ?>>
        <?= $Page->v_06->selectOptionListHtml("x_v_06") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_06->getErrorMessage(false) ?></div>
<?= $Page->v_06->Lookup->getParamTag($Page, "p_x_v_06") ?>
<?php if (!$Page->v_06->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_06", selectId: "fref_codesearch_x_v_06" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_06?.lookupOptions.length) {
        options.data = { id: "x_v_06", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_06", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_06.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_07->Visible) { // v_07 ?>
    <div id="r_v_07" class="row"<?= $Page->v_07->rowAttributes() ?>>
        <label for="x_v_07" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_07"><?= $Page->v_07->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_07" id="z_v_07" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_07->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_07" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_07"
        name="x_v_07"
        class="form-select ew-select<?= $Page->v_07->isInvalidClass() ?>"
        <?php if (!$Page->v_07->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_07"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_07"
        data-page="1"
        data-value-separator="<?= $Page->v_07->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_07->getPlaceHolder()) ?>"
        <?= $Page->v_07->editAttributes() ?>>
        <?= $Page->v_07->selectOptionListHtml("x_v_07") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_07->getErrorMessage(false) ?></div>
<?= $Page->v_07->Lookup->getParamTag($Page, "p_x_v_07") ?>
<?php if (!$Page->v_07->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_07", selectId: "fref_codesearch_x_v_07" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_07?.lookupOptions.length) {
        options.data = { id: "x_v_07", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_07", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_07.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_08->Visible) { // v_08 ?>
    <div id="r_v_08" class="row"<?= $Page->v_08->rowAttributes() ?>>
        <label for="x_v_08" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_08"><?= $Page->v_08->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_08" id="z_v_08" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_08->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_08" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_08"
        name="x_v_08"
        class="form-select ew-select<?= $Page->v_08->isInvalidClass() ?>"
        <?php if (!$Page->v_08->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_08"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_08"
        data-page="1"
        data-value-separator="<?= $Page->v_08->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_08->getPlaceHolder()) ?>"
        <?= $Page->v_08->editAttributes() ?>>
        <?= $Page->v_08->selectOptionListHtml("x_v_08") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_08->getErrorMessage(false) ?></div>
<?= $Page->v_08->Lookup->getParamTag($Page, "p_x_v_08") ?>
<?php if (!$Page->v_08->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_08", selectId: "fref_codesearch_x_v_08" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_08?.lookupOptions.length) {
        options.data = { id: "x_v_08", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_08", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_08.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_09->Visible) { // v_09 ?>
    <div id="r_v_09" class="row"<?= $Page->v_09->rowAttributes() ?>>
        <label for="x_v_09" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_09"><?= $Page->v_09->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_09" id="z_v_09" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_09->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_09" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_09"
        name="x_v_09"
        class="form-select ew-select<?= $Page->v_09->isInvalidClass() ?>"
        <?php if (!$Page->v_09->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_09"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_09"
        data-page="1"
        data-value-separator="<?= $Page->v_09->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_09->getPlaceHolder()) ?>"
        <?= $Page->v_09->editAttributes() ?>>
        <?= $Page->v_09->selectOptionListHtml("x_v_09") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_09->getErrorMessage(false) ?></div>
<?= $Page->v_09->Lookup->getParamTag($Page, "p_x_v_09") ?>
<?php if (!$Page->v_09->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_09", selectId: "fref_codesearch_x_v_09" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_09?.lookupOptions.length) {
        options.data = { id: "x_v_09", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_09", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_09.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_10->Visible) { // v_10 ?>
    <div id="r_v_10" class="row"<?= $Page->v_10->rowAttributes() ?>>
        <label for="x_v_10" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_v_10"><?= $Page->v_10->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_v_10" id="z_v_10" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_10->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_v_10" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_10"
        name="x_v_10"
        class="form-select ew-select<?= $Page->v_10->isInvalidClass() ?>"
        <?php if (!$Page->v_10->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_v_10"
        <?php } ?>
        data-table="ref_code"
        data-field="x_v_10"
        data-page="1"
        data-value-separator="<?= $Page->v_10->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_10->getPlaceHolder()) ?>"
        <?= $Page->v_10->editAttributes() ?>>
        <?= $Page->v_10->selectOptionListHtml("x_v_10") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_10->getErrorMessage(false) ?></div>
<?= $Page->v_10->Lookup->getParamTag($Page, "p_x_v_10") ?>
<?php if (!$Page->v_10->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_v_10", selectId: "fref_codesearch_x_v_10" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.v_10?.lookupOptions.length) {
        options.data = { id: "x_v_10", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_v_10", form: "fref_codesearch", limit: 20 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.v_10.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_ref_code2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_ref_code2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->last_price->Visible) { // last_price ?>
    <div id="r_last_price" class="row"<?= $Page->last_price->rowAttributes() ?>>
        <label for="x_last_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_last_price"><?= $Page->last_price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_price" id="z_last_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_last_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_price->getInputTextType() ?>" name="x_last_price" id="x_last_price" data-table="ref_code" data-field="x_last_price" value="<?= $Page->last_price->EditValue ?>" data-page="2" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->last_price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_price->formatPattern()) ?>"<?= $Page->last_price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_currency"
        <?php } ?>
        data-table="ref_code"
        data-field="x_currency"
        data-page="2"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_currency", selectId: "fref_codesearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->composition->Visible) { // composition ?>
    <div id="r_composition" class="row"<?= $Page->composition->rowAttributes() ?>>
        <label for="x_composition" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_composition"><?= $Page->composition->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_composition" id="z_composition" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->composition->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_composition" class="ew-search-field ew-search-field-single">
    <select
        id="x_composition"
        name="x_composition"
        class="form-select ew-select<?= $Page->composition->isInvalidClass() ?>"
        <?php if (!$Page->composition->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_composition"
        <?php } ?>
        data-table="ref_code"
        data-field="x_composition"
        data-page="2"
        data-value-separator="<?= $Page->composition->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->composition->getPlaceHolder()) ?>"
        <?= $Page->composition->editAttributes() ?>>
        <?= $Page->composition->selectOptionListHtml("x_composition") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->composition->getErrorMessage(false) ?></div>
<?= $Page->composition->Lookup->getParamTag($Page, "p_x_composition") ?>
<?php if (!$Page->composition->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_composition", selectId: "fref_codesearch_x_composition" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.composition?.lookupOptions.length) {
        options.data = { id: "x_composition", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_composition", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.composition.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->moq->Visible) { // moq ?>
    <div id="r_moq" class="row"<?= $Page->moq->rowAttributes() ?>>
        <label for="x_moq" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_moq"><?= $Page->moq->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_moq" id="z_moq" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->moq->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_moq" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->moq->getInputTextType() ?>" name="x_moq" id="x_moq" data-table="ref_code" data-field="x_moq" value="<?= $Page->moq->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->moq->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->moq->formatPattern()) ?>"<?= $Page->moq->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->moq->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_status"
        <?php } ?>
        data-table="ref_code"
        data-field="x_status"
        data-page="2"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_status", selectId: "fref_codesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_ref_code_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fref_codesearch_x_operator"
        <?php } ?>
        data-table="ref_code"
        data-field="x_operator"
        data-page="2"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fref_codesearch", function() {
    var options = { name: "x_operator", selectId: "fref_codesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fref_codesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fref_codesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fref_codesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.ref_code.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_ref_code_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_ref_code_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="ref_code" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_ref_code_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="ref_code" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" data-page="2" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fref_codesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fref_codesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fref_codesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("ref_code");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
