<?php

namespace PHPMaker2024\fibre;

// Page object
$ReceiptBAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { receipt_b: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var freceipt_badd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("freceipt_badd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["from_account", [fields.from_account.visible && fields.from_account.required ? ew.Validators.required(fields.from_account.caption) : null, ew.Validators.integer], fields.from_account.isInvalid],
            ["to_account", [fields.to_account.visible && fields.to_account.required ? ew.Validators.required(fields.to_account.caption) : null, ew.Validators.integer], fields.to_account.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "from_account": <?= $Page->from_account->toClientList($Page) ?>,
            "to_account": <?= $Page->to_account->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="freceipt_badd" id="freceipt_badd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="receipt_b">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_receipt_b_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_receipt_b_location">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="freceipt_badd_x_location"
        <?php } ?>
        data-table="receipt_b"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("freceipt_badd", function() {
    var options = { name: "x_location", selectId: "freceipt_badd_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (freceipt_badd.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "freceipt_badd" };
    } else {
        options.ajax = { id: "x_location", form: "freceipt_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.receipt_b.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->from_account->Visible) { // from_account ?>
    <div id="r_from_account"<?= $Page->from_account->rowAttributes() ?>>
        <label id="elh_receipt_b_from_account" class="<?= $Page->LeftColumnClass ?>"><?= $Page->from_account->caption() ?><?= $Page->from_account->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->from_account->cellAttributes() ?>>
<span id="el_receipt_b_from_account">
    <select
        id="x_from_account"
        name="x_from_account"
        class="form-control ew-select<?= $Page->from_account->isInvalidClass() ?>"
        data-select2-id="freceipt_badd_x_from_account"
        data-table="receipt_b"
        data-field="x_from_account"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->from_account->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->from_account->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->from_account->getPlaceHolder()) ?>"
        <?= $Page->from_account->editAttributes() ?>>
        <?= $Page->from_account->selectOptionListHtml("x_from_account") ?>
    </select>
    <?= $Page->from_account->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->from_account->getErrorMessage() ?></div>
<?= $Page->from_account->Lookup->getParamTag($Page, "p_x_from_account") ?>
<script>
loadjs.ready("freceipt_badd", function() {
    var options = { name: "x_from_account", selectId: "freceipt_badd_x_from_account" };
    if (freceipt_badd.lists.from_account?.lookupOptions.length) {
        options.data = { id: "x_from_account", form: "freceipt_badd" };
    } else {
        options.ajax = { id: "x_from_account", form: "freceipt_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.receipt_b.fields.from_account.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->to_account->Visible) { // to_account ?>
    <div id="r_to_account"<?= $Page->to_account->rowAttributes() ?>>
        <label id="elh_receipt_b_to_account" class="<?= $Page->LeftColumnClass ?>"><?= $Page->to_account->caption() ?><?= $Page->to_account->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->to_account->cellAttributes() ?>>
<span id="el_receipt_b_to_account">
    <select
        id="x_to_account"
        name="x_to_account"
        class="form-control ew-select<?= $Page->to_account->isInvalidClass() ?>"
        data-select2-id="freceipt_badd_x_to_account"
        data-table="receipt_b"
        data-field="x_to_account"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->to_account->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->to_account->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->to_account->getPlaceHolder()) ?>"
        <?= $Page->to_account->editAttributes() ?>>
        <?= $Page->to_account->selectOptionListHtml("x_to_account") ?>
    </select>
    <?= $Page->to_account->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->to_account->getErrorMessage() ?></div>
<?= $Page->to_account->Lookup->getParamTag($Page, "p_x_to_account") ?>
<script>
loadjs.ready("freceipt_badd", function() {
    var options = { name: "x_to_account", selectId: "freceipt_badd_x_to_account" };
    if (freceipt_badd.lists.to_account?.lookupOptions.length) {
        options.data = { id: "x_to_account", form: "freceipt_badd" };
    } else {
        options.ajax = { id: "x_to_account", form: "freceipt_badd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.receipt_b.fields.to_account.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference"<?= $Page->reference->rowAttributes() ?>>
        <label id="elh_receipt_b_reference" for="x_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference->caption() ?><?= $Page->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference->cellAttributes() ?>>
<span id="el_receipt_b_reference">
<input type="<?= $Page->reference->getInputTextType() ?>" name="x_reference" id="x_reference" data-table="receipt_b" data-field="x_reference" value="<?= $Page->reference->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->reference->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference->formatPattern()) ?>"<?= $Page->reference->editAttributes() ?> aria-describedby="x_reference_help">
<?= $Page->reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_receipt_b_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_receipt_b_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="receipt_b" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["freceipt_badd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("freceipt_badd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_receipt_b_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_receipt_b_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="receipt_b" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_receipt_b_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_receipt_b_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="receipt_b" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="freceipt_badd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="freceipt_badd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("receipt_b");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
