<?php

namespace PHPMaker2024\fibre;

// Page object
$ReceiptAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { receipt: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var freceiptadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("freceiptadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["from_account", [fields.from_account.visible && fields.from_account.required ? ew.Validators.required(fields.from_account.caption) : null, ew.Validators.integer], fields.from_account.isInvalid],
            ["reference", [fields.reference.visible && fields.reference.required ? ew.Validators.required(fields.reference.caption) : null], fields.reference.isInvalid],
            ["total_amount", [fields.total_amount.visible && fields.total_amount.required ? ew.Validators.required(fields.total_amount.caption) : null, ew.Validators.float], fields.total_amount.isInvalid],
            ["panel_amount", [fields.panel_amount.visible && fields.panel_amount.required ? ew.Validators.required(fields.panel_amount.caption) : null, ew.Validators.float], fields.panel_amount.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["balance", [fields.balance.visible && fields.balance.required ? ew.Validators.required(fields.balance.caption) : null, ew.Validators.float], fields.balance.isInvalid],
            ["to_account", [fields.to_account.visible && fields.to_account.required ? ew.Validators.required(fields.to_account.caption) : null], fields.to_account.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "from_account": <?= $Page->from_account->toClientList($Page) ?>,
            "reference": <?= $Page->reference->toClientList($Page) ?>,
            "to_account": <?= $Page->to_account->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="freceiptadd" id="freceiptadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="receipt">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_receipt_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_receipt_location">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="freceiptadd_x_location"
        <?php } ?>
        data-table="receipt"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("freceiptadd", function() {
    var options = { name: "x_location", selectId: "freceiptadd_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (freceiptadd.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "freceiptadd" };
    } else {
        options.ajax = { id: "x_location", form: "freceiptadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.receipt.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_receipt_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_receipt_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="receipt" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["freceiptadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("freceiptadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->from_account->Visible) { // from_account ?>
    <div id="r_from_account"<?= $Page->from_account->rowAttributes() ?>>
        <label id="elh_receipt_from_account" class="<?= $Page->LeftColumnClass ?>"><?= $Page->from_account->caption() ?><?= $Page->from_account->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->from_account->cellAttributes() ?>>
<span id="el_receipt_from_account">
<?php
if (IsRTL()) {
    $Page->from_account->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_from_account" class="ew-auto-suggest">
    <input type="<?= $Page->from_account->getInputTextType() ?>" class="form-control" name="sv_x_from_account" id="sv_x_from_account" value="<?= RemoveHtml($Page->from_account->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->from_account->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->from_account->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->from_account->formatPattern()) ?>"<?= $Page->from_account->editAttributes() ?> aria-describedby="x_from_account_help">
</span>
<selection-list hidden class="form-control" data-table="receipt" data-field="x_from_account" data-input="sv_x_from_account" data-value-separator="<?= $Page->from_account->displayValueSeparatorAttribute() ?>" name="x_from_account" id="x_from_account" value="<?= HtmlEncode($Page->from_account->CurrentValue) ?>" data-ew-action="update-options"></selection-list>
<?= $Page->from_account->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->from_account->getErrorMessage() ?></div>
<script>
loadjs.ready("freceiptadd", function() {
    freceiptadd.createAutoSuggest(Object.assign({"id":"x_from_account","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->from_account->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.receipt.fields.from_account.autoSuggestOptions));
});
</script>
<?= $Page->from_account->Lookup->getParamTag($Page, "p_x_from_account") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference->Visible) { // reference ?>
    <div id="r_reference"<?= $Page->reference->rowAttributes() ?>>
        <label id="elh_receipt_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference->caption() ?><?= $Page->reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference->cellAttributes() ?>>
<span id="el_receipt_reference">
<template id="tp_x_reference">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="receipt" data-field="x_reference" name="x_reference" id="x_reference"<?= $Page->reference->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_reference" class="ew-item-list"></div>
<selection-list hidden
    id="x_reference"
    name="x_reference"
    value="<?= HtmlEncode($Page->reference->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_reference"
    data-target="dsl_x_reference"
    data-repeatcolumn="5"
    class="form-control<?= $Page->reference->isInvalidClass() ?>"
    data-table="receipt"
    data-field="x_reference"
    data-value-separator="<?= $Page->reference->displayValueSeparatorAttribute() ?>"
    data-ew-action="autofill"
    <?= $Page->reference->editAttributes() ?>></selection-list>
<?= $Page->reference->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference->getErrorMessage() ?></div>
<?= $Page->reference->Lookup->getParamTag($Page, "p_x_reference") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->total_amount->Visible) { // total_amount ?>
    <div id="r_total_amount"<?= $Page->total_amount->rowAttributes() ?>>
        <label id="elh_receipt_total_amount" for="x_total_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->total_amount->caption() ?><?= $Page->total_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->total_amount->cellAttributes() ?>>
<span id="el_receipt_total_amount">
<input type="<?= $Page->total_amount->getInputTextType() ?>" name="x_total_amount" id="x_total_amount" data-table="receipt" data-field="x_total_amount" value="<?= $Page->total_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->total_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_amount->formatPattern()) ?>"<?= $Page->total_amount->editAttributes() ?> aria-describedby="x_total_amount_help">
<?= $Page->total_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->total_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->panel_amount->Visible) { // panel_amount ?>
    <div id="r_panel_amount"<?= $Page->panel_amount->rowAttributes() ?>>
        <label id="elh_receipt_panel_amount" for="x_panel_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->panel_amount->caption() ?><?= $Page->panel_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->panel_amount->cellAttributes() ?>>
<span id="el_receipt_panel_amount">
<input type="<?= $Page->panel_amount->getInputTextType() ?>" name="x_panel_amount" id="x_panel_amount" data-table="receipt" data-field="x_panel_amount" value="<?= $Page->panel_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->panel_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->panel_amount->formatPattern()) ?>"<?= $Page->panel_amount->editAttributes() ?> aria-describedby="x_panel_amount_help">
<?= $Page->panel_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->panel_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_receipt_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_receipt_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="receipt" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->balance->Visible) { // balance ?>
    <div id="r_balance"<?= $Page->balance->rowAttributes() ?>>
        <label id="elh_receipt_balance" for="x_balance" class="<?= $Page->LeftColumnClass ?>"><?= $Page->balance->caption() ?><?= $Page->balance->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->balance->cellAttributes() ?>>
<span id="el_receipt_balance">
<input type="<?= $Page->balance->getInputTextType() ?>" name="x_balance" id="x_balance" data-table="receipt" data-field="x_balance" value="<?= $Page->balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->balance->formatPattern()) ?>"<?= $Page->balance->editAttributes() ?> aria-describedby="x_balance_help">
<?= $Page->balance->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->balance->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->to_account->Visible) { // to_account ?>
    <div id="r_to_account"<?= $Page->to_account->rowAttributes() ?>>
        <label id="elh_receipt_to_account" for="x_to_account" class="<?= $Page->LeftColumnClass ?>"><?= $Page->to_account->caption() ?><?= $Page->to_account->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->to_account->cellAttributes() ?>>
<span id="el_receipt_to_account">
    <select
        id="x_to_account"
        name="x_to_account"
        class="form-select ew-select<?= $Page->to_account->isInvalidClass() ?>"
        <?php if (!$Page->to_account->IsNativeSelect) { ?>
        data-select2-id="freceiptadd_x_to_account"
        <?php } ?>
        data-table="receipt"
        data-field="x_to_account"
        data-value-separator="<?= $Page->to_account->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->to_account->getPlaceHolder()) ?>"
        <?= $Page->to_account->editAttributes() ?>>
        <?= $Page->to_account->selectOptionListHtml("x_to_account") ?>
    </select>
    <?= $Page->to_account->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->to_account->getErrorMessage() ?></div>
<?= $Page->to_account->Lookup->getParamTag($Page, "p_x_to_account") ?>
<?php if (!$Page->to_account->IsNativeSelect) { ?>
<script>
loadjs.ready("freceiptadd", function() {
    var options = { name: "x_to_account", selectId: "freceiptadd_x_to_account" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (freceiptadd.lists.to_account?.lookupOptions.length) {
        options.data = { id: "x_to_account", form: "freceiptadd" };
    } else {
        options.ajax = { id: "x_to_account", form: "freceiptadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.receipt.fields.to_account.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_receipt_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_receipt_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="receipt" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="freceiptadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="freceiptadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("receipt");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    			$("#r_i_no").hide();
    			$("#r_i_date").hide();
    			$("#r_ref").hide();
});
</script>
