<?php

namespace PHPMaker2024\fibre;

// Page object
$Re = &$Page;
?>
<?php
$Page->showMessage();
?>
<?php
if (count($_GET) == 0)
	$_GET['ALL'] = "ALL"; 
echo '
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<title>Makaan - Real Estate Company</title>
	<meta content="width=device-width, initial-scale=1.0" name="viewport">
	<meta content="" name="keywords">
	<meta content="" name="description">
	<!-- Favicon -->
	<link href="rs/img/favicon.ico" rel="icon">
	<!-- Google Web Fonts 
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin> -->
	<link href="https://fonts.googleapis.com/css2?family=Heebo:wght@400;500;600&family=Inter:wght@700;800&display=swap" rel="stylesheet">
	<!-- Icon Font Stylesheet -->
	<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.0/css/all.min.css" rel="stylesheet">
	<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">
	<!-- Libraries Stylesheet -->
	<link href="rs/lib/animate/animate.min.css" rel="stylesheet">
	<link href="rs/lib/owlcarousel/assets/owl.carousel.min.css" rel="stylesheet">
	<!-- Customized Bootstrap Stylesheet -->
	<link href="rs/css/bootstrap.min.css" rel="stylesheet">
	<!-- Template Stylesheet -->
	<link href="rs/css/style.css" rel="stylesheet">
</head>
<body>
	<div class="container-xxl bg-white p-0">
		<!-- Spinner Start -->
		<div id="spinner" class="show bg-white position-fixed translate-middle w-100 vh-100 top-50 start-50 d-flex align-items-center justify-content-center">
			<div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status">
				<span class="sr-only">Loading...</span>
			</div>
		</div>
		<!-- Spinner End -->
		<!-- Navbar Start -->
		<div class="container-fluid nav-bar bg-transparent">
			<nav class="navbar navbar-expand-lg bg-white navbar-light py-0 px-4">
				<a href="re" class="navbar-brand d-flex align-items-center text-center">
					<div class="icon p-2 me-2">
						<img class="img-fluid" src="rs/img/icon-deal.png" alt="Icon" style="width: 30px; height: 30px;">
					</div>
					<h1 class="m-0 text-primary">Makaan</h1>
				</a>
				<button type="button" class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
					<span class="navbar-toggler-icon"></span>
				</button>
				<div class="collapse navbar-collapse" id="navbarCollapse">
					<div class="navbar-nav ms-auto">
						<a href="re" class="nav-item nav-link active">Home</a>
						<a href="re?about" class="nav-item nav-link">About</a>
						<div class="nav-item dropdown">
							<a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Property</a>
							<div class="dropdown-menu rounded-0 m-0">
								<a href="re?property-list" class="dropdown-item">Property List</a>
								<a href="re?property-type" class="dropdown-item">Property Type</a>
								<a href="re?property-agent" class="dropdown-item">Property Agent</a>
							</div>
						</div>
						<div class="nav-item dropdown">
							<a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown">Pages</a>
							<div class="dropdown-menu rounded-0 m-0">
								<a href="re?testimonial" class="dropdown-item">Testimonial</a>
								<a href="404.html" class="dropdown-item">404 Error</a>
							</div>
						</div>
						<a href="contact.html" class="nav-item nav-link">Contact</a>
					</div>
					<a href="" class="btn btn-primary px-3 d-none d-lg-flex">Add Property</a>
				</div>
			</nav>
		</div>
		<!-- Navbar End -->';
	if ( (isset($_GET['header'])) ||  (isset($_GET['ALL'])) )
	{
	echo '
		<!-- Header Start -->
		<div class="container-fluid header bg-white p-0">
			<div class="row g-0 align-items-center flex-column-reverse flex-md-row">
				<div class="col-md-6 p-5 mt-lg-5">
					<h1 class="display-5 animated fadeIn mb-4">Find A <span class="text-primary">Perfect Home</span> To Live With Your Family</h1>
					<p class="animated fadeIn mb-4 pb-2">Vero elitr justo clita lorem. Ipsum dolor at sed stet
						sit diam no. Kasd rebum ipsum et diam justo clita et kasd rebum sea elitr.</p>
					<a href="" class="btn btn-primary py-3 px-5 me-3 animated fadeIn">Get Started</a>
				</div>
				<div class="col-md-6 animated fadeIn">
					<div class="owl-carousel header-carousel">
						<div class="owl-carousel-item">
							<img class="img-fluid" src="rs/img/carousel-1.jpg" alt="">
						</div>
						<div class="owl-carousel-item">
							<img class="img-fluid" src="rs/img/carousel-2.jpg" alt="">
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Header End -->';
	}
	if ( (isset($_GET['search'])) || (isset($_GET['ALL'])) )	
	{
	echo '
		<!-- Search Start 
		<div class="container-fluid bg-primary mb-5 wow fadeIn" data-wow-delay="0.1s" style="padding: 35px;">
			<div class="container">
				<div class="row g-2">
					<div class="col-md-10">
						<div class="row g-2">
							<div class="col-md-4">
								<input type="text" class="form-control border-0 py-3" placeholder="Search Keyword">
							</div>
							<div class="col-md-4">
								<select class="form-select border-0 py-3">
									<option selected>Property Type</option>
									<option value="1">Property Type 1</option>
									<option value="2">Property Type 2</option>
									<option value="3">Property Type 3</option>
								</select>
							</div>
							<div class="col-md-4">
								<select class="form-select border-0 py-3">
									<option selected>Location</option>
									<option value="1">Location 1</option>
									<option value="2">Location 2</option>
									<option value="3">Location 3</option>
								</select>
							</div>
						</div>
					</div>
					<div class="col-md-2">
						<button class="btn btn-dark border-0 w-100 py-3">Search</button>
					</div>
				</div>
			</div>
		</div>
		 Search End -->';
	}	 
	if ( (isset($_GET['category'])) || (isset($_GET['ALL'])) )	
	{	
	echo '
		<!-- Category Start -->
		<div class="container-xxl py-5">
			<div class="container">
				<div class="text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
					<h1 class="mb-3">Property Types</h1>
					<p>Eirmod sed ipsum dolor sit rebum labore magna erat. Tempor ut dolore lorem kasd vero ipsum sit eirmod sit. Ipsum diam justo sed rebum vero dolor duo.</p>
				</div>
				<div class="row g-4">
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.1s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-apartment.png" alt="Icon">
								</div>
								<h6>Apartment</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.3s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-villa.png" alt="Icon">
								</div>
								<h6>Villa</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.5s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-house.png" alt="Icon">
								</div>
								<h6>Home</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.7s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-housing.png" alt="Icon">
								</div>
								<h6>Office</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.1s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-building.png" alt="Icon">
								</div>
								<h6>Building</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.3s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-neighborhood.png" alt="Icon">
								</div>
								<h6>Townhouse</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.5s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-condominium.png" alt="Icon">
								</div>
								<h6>Shop</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
					<div class="col-lg-3 col-sm-6 wow fadeInUp" data-wow-delay="0.7s">
						<a class="cat-item d-block bg-light text-center rounded p-3" href="">
							<div class="rounded p-4">
								<div class="icon mb-3">
									<img class="img-fluid" src="rs/img/icon-luxury.png" alt="Icon">
								</div>
								<h6>Garage</h6>
								<span>123 Properties</span>
							</div>
						</a>
					</div>
				</div>
			</div>
		</div>
		<!-- Category End -->';
	}	
	if ( (isset($_GET['about'])) || (isset($_GET['ALL'])) )	
	{	
	echo '	
		<!-- About Start -->
		<div class="container-xxl py-5">
			<div class="container">
				<div class="row g-5 align-items-center">
					<div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s">
						<div class="about-img position-relative overflow-hidden p-5 pe-0">
							<img class="img-fluid w-100" src="rs/img/about.jpg">
						</div>
					</div>
					<div class="col-lg-6 wow fadeIn" data-wow-delay="0.5s">
						<h1 class="mb-4">#1 Place To Find The Perfect Property</h1>
						<p class="mb-4">Tempor erat elitr rebum at clita. Diam dolor diam ipsum sit. Aliqu diam amet diam et eos. Clita erat ipsum et lorem et sit, sed stet lorem sit clita duo justo magna dolore erat amet</p>
						<p><i class="fa fa-check text-primary me-3"></i>Tempor erat elitr rebum at clita</p>
						<p><i class="fa fa-check text-primary me-3"></i>Aliqu diam amet diam et eos</p>
						<p><i class="fa fa-check text-primary me-3"></i>Clita duo justo magna dolore erat amet</p>
						<a class="btn btn-primary py-3 px-5 mt-3" href="">Read More</a>
					</div>
				</div>
			</div>
		</div>
		<!-- About End -->';
	}
	if ( (isset($_GET['property-list'])) || (isset($_GET['ALL'])) )	
	{	
	echo '		
		<!-- Property List Start -->
		<div class="container-xxl py-5">
			<div class="container">
				<div class="row g-0 gx-5 align-items-end">
					<div class="col-lg-6">
						<div class="text-start mx-auto mb-5 wow slideInLeft" data-wow-delay="0.1s">
							<h1 class="mb-3">Property Maps</h1>
							<p>Maps</p>
						</div>
					</div>
					<div class="col-lg-6 text-start text-lg-end wow slideInRight" data-wow-delay="0.1s">
						<ul class="nav nav-pills d-inline-flex justify-content-end mb-5">
							<li class="nav-item me-2">
								<a class="btn btn-outline-primary active" data-bs-toggle="pill" href="#tab-1">Featured</a>
							</li>
							<li class="nav-item me-2">
								<a class="btn btn-outline-primary" data-bs-toggle="pill" href="#tab-2">For Sell</a>
							</li>
							<li class="nav-item me-0">
								<a class="btn btn-outline-primary" data-bs-toggle="pill" href="#tab-3">For Rent</a>
							</li>
						</ul>
					</div>
				</div>
				<div class="tab-content">
					<div id="tab-1" class="tab-pane fade show p-0 active">
						<div class="row g-4">
							<div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/1.jpg" alt="" style="padding:20px"></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">Lower Ground Floor</div>
										<!--
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Appartment</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
										-->
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href="uppergroundfloor.php"><img class="img-fluid" src="rs/img/2.jpg" alt="" style="padding:20px"></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">Upper Ground Floor</div>
										<!--
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Villa</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
										-->
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href="re?action=3"><img class="img-fluid" src="rs/img/3.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">First Floor</div>
										<!--
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Office</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>\
										-->
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/4.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">Second Floor</div>
										<!--
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Building</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
										-->
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/5.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">Third Floor</div>
										<!--
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Home</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
										-->
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/6.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">Fourth Floor</div>
										<!--
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Shop</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
										-->
									</div>
								</div>
							</div>
							<div class="col-12 text-center wow fadeInUp" data-wow-delay="0.1s">
								<a class="btn btn-primary py-3 px-5" href="">Browse More Property</a>
							</div>
						</div>
					</div>
					<div id="tab-2" class="tab-pane fade show p-0">
						<div class="row g-4">
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-1.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Sell</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Appartment</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-2.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Rent</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Villa</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-3.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Sell</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Office</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-4.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Rent</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Building</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-5.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Sell</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Home</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-6.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Rent</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Shop</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-12 text-center">
								<a class="btn btn-primary py-3 px-5" href="">Browse More Property</a>
							</div>
						</div>
					</div>
					<div id="tab-3" class="tab-pane fade show p-0">
						<div class="row g-4">
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-1.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Sell</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Appartment</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-2.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Rent</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Villa</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-3.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Sell</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Office</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-4.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Rent</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Building</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-5.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Sell</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Home</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-lg-4 col-md-6">
								<div class="property-item rounded overflow-hidden">
									<div class="position-relative overflow-hidden">
										<a href=""><img class="img-fluid" src="rs/img/property-6.jpg" alt=""></a>
										<div class="bg-primary rounded text-white position-absolute start-0 top-0 m-4 py-1 px-3">For Rent</div>
										<div class="bg-white rounded-top text-primary position-absolute start-0 bottom-0 mx-4 pt-1 px-3">Shop</div>
									</div>
									<div class="p-4 pb-0">
										<h5 class="text-primary mb-3">$12,345</h5>
										<a class="d-block h5 mb-2" href="">Golden Urban House For Sell</a>
										<p><i class="fa fa-map-marker-alt text-primary me-2"></i>123 Street, New York, USA</p>
									</div>
									<div class="d-flex border-top">
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-ruler-combined text-primary me-2"></i>1000 Sqft</small>
										<small class="flex-fill text-center border-end py-2"><i class="fa fa-bed text-primary me-2"></i>3 Bed</small>
										<small class="flex-fill text-center py-2"><i class="fa fa-bath text-primary me-2"></i>2 Bath</small>
									</div>
								</div>
							</div>
							<div class="col-12 text-center">
								<a class="btn btn-primary py-3 px-5" href="">Browse More Property</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Property List End -->';
	}		
	if ( (isset($_GET['property-agents'])) || (isset($_GET['ALL'])) )	
	{
	echo '		
		<!-- Call to Action Start -->
		<div class="container-xxl py-5">
			<div class="container">
				<div class="bg-light rounded p-3">
					<div class="bg-white rounded p-4" style="border: 1px dashed rgba(0, 185, 142, .3)">
						<div class="row g-5 align-items-center">
							<div class="col-lg-6 wow fadeIn" data-wow-delay="0.1s">
								<img class="img-fluid rounded w-100" src="rs/img/call-to-action.jpg" alt="">
							</div>
							<div class="col-lg-6 wow fadeIn" data-wow-delay="0.5s">
								<div class="mb-4">
									<h1 class="mb-3">Contact With Our Certified Agent</h1>
									<p>Eirmod sed ipsum dolor sit rebum magna erat. Tempor lorem kasd vero ipsum sit sit diam justo sed vero dolor duo.</p>
								</div>
								<a href="" class="btn btn-primary py-3 px-4 me-2"><i class="fa fa-phone-alt me-2"></i>Make A Call</a>
								<a href="" class="btn btn-dark py-3 px-4"><i class="fa fa-calendar-alt me-2"></i>Get Appoinment</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Call to Action End -->';
	}	
	if ( (isset($_GET['property-agents'])) || (isset($_GET['ALL'])) )	
	{
	echo '		
		<!-- Team Start -->
		<div class="container-xxl py-5">
			<div class="container">
				<div class="text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
					<h1 class="mb-3">Property Agents</h1>
					<p>Eirmod sed ipsum dolor sit rebum labore magna erat. Tempor ut dolore lorem kasd vero ipsum sit eirmod sit. Ipsum diam justo sed rebum vero dolor duo.</p>
				</div>
				<div class="row g-4">
					<div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.1s">
						<div class="team-item rounded overflow-hidden">
							<div class="position-relative">
								<img class="img-fluid" src="rs/img/team-1.jpg" alt="">
								<div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
									<a class="btn btn-square mx-1" href=""><i class="fab fa-facebook-f"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-twitter"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-instagram"></i></a>
								</div>
							</div>
							<div class="text-center p-4 mt-3">
								<h5 class="fw-bold mb-0">Full Name</h5>
								<small>Designation</small>
							</div>
						</div>
					</div>
					<div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.3s">
						<div class="team-item rounded overflow-hidden">
							<div class="position-relative">
								<img class="img-fluid" src="rs/img/team-2.jpg" alt="">
								<div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
									<a class="btn btn-square mx-1" href=""><i class="fab fa-facebook-f"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-twitter"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-instagram"></i></a>
								</div>
							</div>
							<div class="text-center p-4 mt-3">
								<h5 class="fw-bold mb-0">Full Name</h5>
								<small>Designation</small>
							</div>
						</div>
					</div>
					<div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.5s">
						<div class="team-item rounded overflow-hidden">
							<div class="position-relative">
								<img class="img-fluid" src="rs/img/team-3.jpg" alt="">
								<div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
									<a class="btn btn-square mx-1" href=""><i class="fab fa-facebook-f"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-twitter"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-instagram"></i></a>
								</div>
							</div>
							<div class="text-center p-4 mt-3">
								<h5 class="fw-bold mb-0">Full Name</h5>
								<small>Designation</small>
							</div>
						</div>
					</div>
					<div class="col-lg-3 col-md-6 wow fadeInUp" data-wow-delay="0.7s">
						<div class="team-item rounded overflow-hidden">
							<div class="position-relative">
								<img class="img-fluid" src="rs/img/team-4.jpg" alt="">
								<div class="position-absolute start-50 top-100 translate-middle d-flex align-items-center">
									<a class="btn btn-square mx-1" href=""><i class="fab fa-facebook-f"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-twitter"></i></a>
									<a class="btn btn-square mx-1" href=""><i class="fab fa-instagram"></i></a>
								</div>
							</div>
							<div class="text-center p-4 mt-3">
								<h5 class="fw-bold mb-0">Full Name</h5>
								<small>Designation</small>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Team End -->';
	}
	if ( (isset($_GET['testimonial'])) || (isset($_GET['ALL'])) )	
	{
	echo '
		<!-- Testimonial Start -->
		<div class="container-xxl py-5">
			<div class="container">
				<div class="text-center mx-auto mb-5 wow fadeInUp" data-wow-delay="0.1s" style="max-width: 600px;">
					<h1 class="mb-3">Our Clients Say!</h1>
					<p>Eirmod sed ipsum dolor sit rebum labore magna erat. Tempor ut dolore lorem kasd vero ipsum sit eirmod sit. Ipsum diam justo sed rebum vero dolor duo.</p>
				</div>
				<div class="owl-carousel testimonial-carousel wow fadeInUp" data-wow-delay="0.1s">
					<div class="testimonial-item bg-light rounded p-3">
						<div class="bg-white border rounded p-4">
							<p>Tempor stet labore dolor clita stet diam amet ipsum dolor duo ipsum rebum stet dolor amet diam stet. Est stet ea lorem amet est kasd kasd erat eos</p>
							<div class="d-flex align-items-center">
								<img class="img-fluid flex-shrink-0 rounded" src="rs/img/testimonial-1.jpg" style="width: 45px; height: 45px;">
								<div class="ps-3">
									<h6 class="fw-bold mb-1">Client Name</h6>
									<small>Profession</small>
								</div>
							</div>
						</div>
					</div>
					<div class="testimonial-item bg-light rounded p-3">
						<div class="bg-white border rounded p-4">
							<p>Tempor stet labore dolor clita stet diam amet ipsum dolor duo ipsum rebum stet dolor amet diam stet. Est stet ea lorem amet est kasd kasd erat eos</p>
							<div class="d-flex align-items-center">
								<img class="img-fluid flex-shrink-0 rounded" src="rs/img/testimonial-2.jpg" style="width: 45px; height: 45px;">
								<div class="ps-3">
									<h6 class="fw-bold mb-1">Client Name</h6>
									<small>Profession</small>
								</div>
							</div>
						</div>
					</div>
					<div class="testimonial-item bg-light rounded p-3">
						<div class="bg-white border rounded p-4">
							<p>Tempor stet labore dolor clita stet diam amet ipsum dolor duo ipsum rebum stet dolor amet diam stet. Est stet ea lorem amet est kasd kasd erat eos</p>
							<div class="d-flex align-items-center">
								<img class="img-fluid flex-shrink-0 rounded" src="rs/img/testimonial-3.jpg" style="width: 45px; height: 45px;">
								<div class="ps-3">
									<h6 class="fw-bold mb-1">Client Name</h6>
									<small>Profession</small>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Testimonial End -->';
	}	
	if (isset($_GET['action']))
	{
		if (!isset($_COOKIE['swidth']))
		{
echo '		<script type="text/javascript">document.cookie = "swidth="+screen.width+";path=/";</script>';
		}
		$row = ExecuteRows("SELECT `id`, `image`, `floor`, `no`, `length`, `width`, `type`, `coords`, `operator`, `datetime`, `area`, `sa_area` FROM `property_details` WHERE floor = ".  $_GET['action']);
		$swidth = $_COOKIE['swidth'];
		if (($swidth > 1400) && ($swidth < 3000))
			$wl = 600;
		if (($swidth > 300) && ($swidth < 600))
			$wl = 0;
		$width = ($swidth - $wl);
		$img_size_array = getimagesize('rs/img/'.$row[0]['image']);
		$s = ($img_size_array[0] / $width);
echo ' 
		<br>
		<div style="overflow:auto; width=100%">
			<img src="rs/img/3.jpg" usemap="#image-map" width="'. $width .'">
			<map name="image-map">';
		foreach ($row as $rw)
		{
			$coords = explode(',', $rw['coords']);
			$count = count($coords);
			$coord = [];
			for ($i=0; $i < $count; $i++)
			{
				array_push($coord, round($coords[$i]/$s)); 
			}
			$coordvalue = implode(',', $coord);

			//print_r($coord);
		echo '	
				<area target="" alt="ST103" title="Shop No. '.$rw['no'].'" coords="'. $coordvalue .'" shape="rect" onclick="javascript:redetails('.$rw['id'].')">';
		}
echo ' 
			</map>
		</div>';
	}

//footer
echo '
		<!-- Footer Start -->
		<div class="container-fluid bg-dark text-white-50 footer pt-5 mt-5 wow fadeIn" data-wow-delay="0.1s">
			<div class="container py-5">
				<div class="row g-5">
					<div class="col-lg-3 col-md-6">
						<h5 class="text-white mb-4">Get In Touch</h5>
						<p class="mb-2"><i class="fa fa-map-marker-alt me-3"></i>123 Street, New York, USA</p>
						<p class="mb-2"><i class="fa fa-phone-alt me-3"></i>+012 345 67890</p>
						<p class="mb-2"><i class="fa fa-envelope me-3"></i>info@example.com</p>
						<div class="d-flex pt-2">
							<a class="btn btn-outline-light btn-social" href=""><i class="fab fa-twitter"></i></a>
							<a class="btn btn-outline-light btn-social" href=""><i class="fab fa-facebook-f"></i></a>
							<a class="btn btn-outline-light btn-social" href=""><i class="fab fa-youtube"></i></a>
							<a class="btn btn-outline-light btn-social" href=""><i class="fab fa-linkedin-in"></i></a>
						</div>
					</div>
					<div class="col-lg-3 col-md-6">
						<h5 class="text-white mb-4">Quick Links</h5>
						<a class="btn btn-link text-white-50" href="">About Us</a>
						<a class="btn btn-link text-white-50" href="">Contact Us</a>
						<a class="btn btn-link text-white-50" href="">Our Services</a>
						<a class="btn btn-link text-white-50" href="">Privacy Policy</a>
						<a class="btn btn-link text-white-50" href="">Terms & Condition</a>
					</div>
					<div class="col-lg-3 col-md-6">
						<h5 class="text-white mb-4">Photo Gallery</h5>
						<div class="row g-2 pt-2">
							<div class="col-4">
								<img class="img-fluid rounded bg-light p-1" src="rs/img/property-1.jpg" alt="">
							</div>
							<div class="col-4">
								<img class="img-fluid rounded bg-light p-1" src="rs/img/property-2.jpg" alt="">
							</div>
							<div class="col-4">
								<img class="img-fluid rounded bg-light p-1" src="rs/img/property-3.jpg" alt="">
							</div>
							<div class="col-4">
								<img class="img-fluid rounded bg-light p-1" src="rs/img/property-4.jpg" alt="">
							</div>
							<div class="col-4">
								<img class="img-fluid rounded bg-light p-1" src="rs/img/property-5.jpg" alt="">
							</div>
							<div class="col-4">
								<img class="img-fluid rounded bg-light p-1" src="rs/img/property-6.jpg" alt="">
							</div>
						</div>
					</div>
					<div class="col-lg-3 col-md-6">
						<h5 class="text-white mb-4">Newsletter</h5>
						<p>Dolor amet sit justo amet elitr clita ipsum elitr est.</p>
						<div class="position-relative mx-auto" style="max-width: 400px;">
							<input class="form-control bg-transparent w-100 py-3 ps-4 pe-5" type="text" placeholder="Your email">
							<button type="button" class="btn btn-primary py-2 position-absolute top-0 end-0 mt-2 me-2">SignUp</button>
						</div>
					</div>
				</div>
			</div>
			<div class="container">
				<div class="copyright">
					<div class="row">
						<div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
							&copy; <a class="border-bottom" href="#">Integer Systems. All rights reserved. Helpline +91 9829221171</a> 
						</div>
						<div class="col-md-6 text-center text-md-end">
							<div class="footer-menu">
								<a href="">Home</a>
								<a href="">Cookies</a>
								<a href="">Help</a>
								<a href="">FQAs</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- Footer End -->
		
		<!-- Back to Top -->
		<a href="#" class="btn btn-lg btn-primary btn-lg-square back-to-top"><i class="bi bi-arrow-up"></i></a>
	</div>
	<!-- JavaScript Libraries -->
	<script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
	<script src="rs/lib/wow/wow.min.js"></script>
	<script src="rs/lib/easing/easing.min.js"></script>
	<script src="rs/lib/waypoints/waypoints.min.js"></script>
	<script src="rs/lib/owlcarousel/owl.carousel.min.js"></script>
	<!-- Template Javascript -->
	<script src="rs/js/main.js"></script>
</body>
</html>';
?>
<script>
function redetails(id)
{
	$.getJSON(window.location.origin +"/apcajax2?redetails="+id,function(data)
	{
	if (data.Count > 0)
		{
		Obj='<div class="modal" id="myModal"><div class="modal-dialog modal-dialog-scrollable modal-lg"><div class="modal-content"><!-- Modal Header --><div class="modal-header"><h1 class="modal-title">Shop No. '+data.no+'</h1><button type="button" class="close" data-bs-dismiss="modal">×</button></div><!-- Modal body --><div class="modal-body"><h5>Size : '+data.length+' - '+data.width+'<br>SA: '+data.sa_area+'</h5>'+'</div><div class="modal-footer"><button type="button" class="btn btn-danger" data-bs-dismiss="modal">Close</button></div></div></div>';
			$("body").prepend(Obj);
			$("#myModal").modal("show")
		}
	});
}
</script>

<?= GetDebugMessage() ?>
