<?php

namespace PHPMaker2024\fibre;

// Page object
$QuotationSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { quotation: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fquotationsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquotationsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["main_image", [], fields.main_image.isInvalid],
            ["godown_id", [], fields.godown_id.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["price_kg", [ew.Validators.float], fields.price_kg.isInvalid],
            ["price_unit", [ew.Validators.float], fields.price_unit.isInvalid],
            ["b_12", [], fields.b_12.isInvalid],
            ["b_01", [], fields.b_01.isInvalid],
            ["v_01", [], fields.v_01.isInvalid],
            ["v_02", [], fields.v_02.isInvalid],
            ["v_03", [], fields.v_03.isInvalid],
            ["v_04", [], fields.v_04.isInvalid],
            ["v_05", [], fields.v_05.isInvalid],
            ["Amount", [ew.Validators.float], fields.Amount.isInvalid],
            ["packing_type", [ew.Validators.float], fields.packing_type.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "godown_id": <?= $Page->godown_id->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "v_01": <?= $Page->v_01->toClientList($Page) ?>,
            "v_02": <?= $Page->v_02->toClientList($Page) ?>,
            "v_03": <?= $Page->v_03->toClientList($Page) ?>,
            "v_04": <?= $Page->v_04->toClientList($Page) ?>,
            "v_05": <?= $Page->v_05->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fquotationsearch" id="fquotationsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="quotation">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="quotation" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->main_image->Visible) { // main_image ?>
    <div id="r_main_image" class="row"<?= $Page->main_image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_main_image"><?= $Page->main_image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_main_image" id="z_main_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->main_image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_main_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->main_image->getInputTextType() ?>" name="x_main_image" id="x_main_image" data-table="quotation" data-field="x_main_image" value="<?= $Page->main_image->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->main_image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->main_image->formatPattern()) ?>"<?= $Page->main_image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->main_image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown_id->Visible) { // godown_id ?>
    <div id="r_godown_id" class="row"<?= $Page->godown_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_godown_id"><?= $Page->godown_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown_id" id="z_godown_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_godown_id" class="ew-search-field ew-search-field-single">
<template id="tp_x_godown_id">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_godown_id" name="x_godown_id" id="x_godown_id"<?= $Page->godown_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown_id[]"
    name="x_godown_id[]"
    value="<?= HtmlEncode($Page->godown_id->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_godown_id"
    data-target="dsl_x_godown_id"
    data-repeatcolumn="5"
    class="form-control<?= $Page->godown_id->isInvalidClass() ?>"
    data-table="quotation"
    data-field="x_godown_id"
    data-value-separator="<?= $Page->godown_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->godown_id->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->godown_id->getErrorMessage(false) ?></div>
<?= $Page->godown_id->Lookup->getParamTag($Page, "p_x_godown_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fquotationsearch_x_product"
        <?php } ?>
        data-table="quotation"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsearch", function() {
    var options = { name: "x_product", selectId: "fquotationsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fquotationsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fquotationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="quotation" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_Balance"><?= $Page->Balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Balance" id="z_Balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_Balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="quotation" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" maxlength="85" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="quotation" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_kg->Visible) { // price_kg ?>
    <div id="r_price_kg" class="row"<?= $Page->price_kg->rowAttributes() ?>>
        <label for="x_price_kg" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_price_kg"><?= $Page->price_kg->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_kg" id="z_price_kg" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_kg->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_price_kg" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_kg->getInputTextType() ?>" name="x_price_kg" id="x_price_kg" data-table="quotation" data-field="x_price_kg" value="<?= $Page->price_kg->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_kg->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_kg->formatPattern()) ?>"<?= $Page->price_kg->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_kg->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price_unit->Visible) { // price_unit ?>
    <div id="r_price_unit" class="row"<?= $Page->price_unit->rowAttributes() ?>>
        <label for="x_price_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_price_unit"><?= $Page->price_unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price_unit" id="z_price_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price_unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_price_unit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price_unit->getInputTextType() ?>" name="x_price_unit" id="x_price_unit" data-table="quotation" data-field="x_price_unit" value="<?= $Page->price_unit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price_unit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price_unit->formatPattern()) ?>"<?= $Page->price_unit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price_unit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_12->Visible) { // b_12 ?>
    <div id="r_b_12" class="row"<?= $Page->b_12->rowAttributes() ?>>
        <label for="x_b_12" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_b_12"><?= $Page->b_12->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_12" id="z_b_12" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_12->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_b_12" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_12->getInputTextType() ?>" name="x_b_12" id="x_b_12" data-table="quotation" data-field="x_b_12" value="<?= $Page->b_12->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_12->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_12->formatPattern()) ?>"<?= $Page->b_12->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_12->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->b_01->Visible) { // b_01 ?>
    <div id="r_b_01" class="row"<?= $Page->b_01->rowAttributes() ?>>
        <label for="x_b_01" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_b_01"><?= $Page->b_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_b_01" id="z_b_01" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->b_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_b_01" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->b_01->getInputTextType() ?>" name="x_b_01" id="x_b_01" data-table="quotation" data-field="x_b_01" value="<?= $Page->b_01->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->b_01->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->b_01->formatPattern()) ?>"<?= $Page->b_01->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->b_01->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
    <div id="r_v_01" class="row"<?= $Page->v_01->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_v_01"><?= $Page->v_01->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_01" id="z_v_01" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_01->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_v_01" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_01[]"
        name="x_v_01[]"
        class="form-select ew-select<?= $Page->v_01->isInvalidClass() ?>"
        <?php if (!$Page->v_01->IsNativeSelect) { ?>
        data-select2-id="fquotationsearch_x_v_01[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_01"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_01->getPlaceHolder()) ?>"
        <?= $Page->v_01->editAttributes() ?>>
        <?= $Page->v_01->selectOptionListHtml("x_v_01[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_01->getErrorMessage(false) ?></div>
<?= $Page->v_01->Lookup->getParamTag($Page, "p_x_v_01") ?>
<?php if (!$Page->v_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsearch", function() {
    var options = { name: "x_v_01[]", selectId: "fquotationsearch_x_v_01[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_01-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsearch.lists.v_01?.lookupOptions.length) {
        options.data = { id: "x_v_01[]", form: "fquotationsearch" };
    } else {
        options.ajax = { id: "x_v_01[]", form: "fquotationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
    <div id="r_v_02" class="row"<?= $Page->v_02->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_v_02"><?= $Page->v_02->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_02" id="z_v_02" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_02->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_v_02" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_02[]"
        name="x_v_02[]"
        class="form-select ew-select<?= $Page->v_02->isInvalidClass() ?>"
        <?php if (!$Page->v_02->IsNativeSelect) { ?>
        data-select2-id="fquotationsearch_x_v_02[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_02"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_02->getPlaceHolder()) ?>"
        <?= $Page->v_02->editAttributes() ?>>
        <?= $Page->v_02->selectOptionListHtml("x_v_02[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_02->getErrorMessage(false) ?></div>
<?= $Page->v_02->Lookup->getParamTag($Page, "p_x_v_02") ?>
<?php if (!$Page->v_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsearch", function() {
    var options = { name: "x_v_02[]", selectId: "fquotationsearch_x_v_02[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_02-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsearch.lists.v_02?.lookupOptions.length) {
        options.data = { id: "x_v_02[]", form: "fquotationsearch" };
    } else {
        options.ajax = { id: "x_v_02[]", form: "fquotationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
    <div id="r_v_03" class="row"<?= $Page->v_03->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_v_03"><?= $Page->v_03->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_03" id="z_v_03" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_03->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_v_03" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_03[]"
        name="x_v_03[]"
        class="form-select ew-select<?= $Page->v_03->isInvalidClass() ?>"
        <?php if (!$Page->v_03->IsNativeSelect) { ?>
        data-select2-id="fquotationsearch_x_v_03[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_03"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_03->getPlaceHolder()) ?>"
        <?= $Page->v_03->editAttributes() ?>>
        <?= $Page->v_03->selectOptionListHtml("x_v_03[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_03->getErrorMessage(false) ?></div>
<?= $Page->v_03->Lookup->getParamTag($Page, "p_x_v_03") ?>
<?php if (!$Page->v_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsearch", function() {
    var options = { name: "x_v_03[]", selectId: "fquotationsearch_x_v_03[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_03-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsearch.lists.v_03?.lookupOptions.length) {
        options.data = { id: "x_v_03[]", form: "fquotationsearch" };
    } else {
        options.ajax = { id: "x_v_03[]", form: "fquotationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
    <div id="r_v_04" class="row"<?= $Page->v_04->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_v_04"><?= $Page->v_04->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_04" id="z_v_04" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_04->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_v_04" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_04[]"
        name="x_v_04[]"
        class="form-select ew-select<?= $Page->v_04->isInvalidClass() ?>"
        <?php if (!$Page->v_04->IsNativeSelect) { ?>
        data-select2-id="fquotationsearch_x_v_04[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_04"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_04->getPlaceHolder()) ?>"
        <?= $Page->v_04->editAttributes() ?>>
        <?= $Page->v_04->selectOptionListHtml("x_v_04[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_04->getErrorMessage(false) ?></div>
<?= $Page->v_04->Lookup->getParamTag($Page, "p_x_v_04") ?>
<?php if (!$Page->v_04->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsearch", function() {
    var options = { name: "x_v_04[]", selectId: "fquotationsearch_x_v_04[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_04-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsearch.lists.v_04?.lookupOptions.length) {
        options.data = { id: "x_v_04[]", form: "fquotationsearch" };
    } else {
        options.ajax = { id: "x_v_04[]", form: "fquotationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_04.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
    <div id="r_v_05" class="row"<?= $Page->v_05->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_v_05"><?= $Page->v_05->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_05" id="z_v_05" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->v_05->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_v_05" class="ew-search-field ew-search-field-single">
    <select
        id="x_v_05[]"
        name="x_v_05[]"
        class="form-select ew-select<?= $Page->v_05->isInvalidClass() ?>"
        <?php if (!$Page->v_05->IsNativeSelect) { ?>
        data-select2-id="fquotationsearch_x_v_05[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_05"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_05->getPlaceHolder()) ?>"
        <?= $Page->v_05->editAttributes() ?>>
        <?= $Page->v_05->selectOptionListHtml("x_v_05[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_05->getErrorMessage(false) ?></div>
<?= $Page->v_05->Lookup->getParamTag($Page, "p_x_v_05") ?>
<?php if (!$Page->v_05->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsearch", function() {
    var options = { name: "x_v_05[]", selectId: "fquotationsearch_x_v_05[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_05-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsearch.lists.v_05?.lookupOptions.length) {
        options.data = { id: "x_v_05[]", form: "fquotationsearch" };
    } else {
        options.ajax = { id: "x_v_05[]", form: "fquotationsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_05.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Amount->Visible) { // Amount ?>
    <div id="r_Amount" class="row"<?= $Page->Amount->rowAttributes() ?>>
        <label for="x_Amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_Amount"><?= $Page->Amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Amount" id="z_Amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_Amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Amount->getInputTextType() ?>" name="x_Amount" id="x_Amount" data-table="quotation" data-field="x_Amount" value="<?= $Page->Amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Amount->formatPattern()) ?>"<?= $Page->Amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_quotation_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_quotation_packing_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="quotation" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fquotationsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fquotationsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fquotationsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("quotation");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
