<?php

namespace PHPMaker2024\fibre;

// Page object
$QuotationList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { quotation: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fquotationsrch" id="fquotationsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fquotationsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { quotation: currentTable } });
var currentForm;
var fquotationsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquotationsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["godown_id", [], fields.godown_id.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["v_01", [], fields.v_01.isInvalid],
            ["v_02", [], fields.v_02.isInvalid],
            ["v_03", [], fields.v_03.isInvalid],
            ["v_04", [], fields.v_04.isInvalid],
            ["v_05", [], fields.v_05.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "godown_id": <?= $Page->godown_id->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "v_01": <?= $Page->v_01->toClientList($Page) ?>,
            "v_02": <?= $Page->v_02->toClientList($Page) ?>,
            "v_03": <?= $Page->v_03->toClientList($Page) ?>,
            "v_04": <?= $Page->v_04->toClientList($Page) ?>,
            "v_05": <?= $Page->v_05->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->godown_id->Visible) { // godown_id ?>
<?php
if (!$Page->godown_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_godown_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->godown_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->godown_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown_id" id="z_godown_id" value="=">
</div>
        </div>
        <div id="el_quotation_godown_id" class="ew-search-field">
<template id="tp_x_godown_id">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="quotation" data-field="x_godown_id" name="x_godown_id" id="x_godown_id"<?= $Page->godown_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_godown_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_godown_id[]"
    name="x_godown_id[]"
    value="<?= HtmlEncode($Page->godown_id->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_godown_id"
    data-target="dsl_x_godown_id"
    data-repeatcolumn="5"
    class="form-control<?= $Page->godown_id->isInvalidClass() ?>"
    data-table="quotation"
    data-field="x_godown_id"
    data-value-separator="<?= $Page->godown_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->godown_id->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->godown_id->getErrorMessage(false) ?></div>
<?= $Page->godown_id->Lookup->getParamTag($Page, "p_x_godown_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
<?php
if (!$Page->product->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product" class="ew-search-caption ew-label"><?= $Page->product->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</div>
        </div>
        <div id="el_quotation_product" class="ew-search-field">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fquotationsrch_x_product"
        <?php } ?>
        data-table="quotation"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsrch", function() {
    var options = { name: "x_product", selectId: "fquotationsrch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsrch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fquotationsrch" };
    } else {
        options.ajax = { id: "x_product", form: "fquotationsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
<?php
if (!$Page->product_code->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_code" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_code->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product_code" class="ew-search-caption ew-label"><?= $Page->product_code->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</div>
        </div>
        <div id="el_quotation_product_code" class="ew-search-field">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="quotation" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="300" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
<?php
if (!$Page->v_01->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_v_01" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->v_01->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->v_01->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_01" id="z_v_01" value="=">
</div>
        </div>
        <div id="el_quotation_v_01" class="ew-search-field">
    <select
        id="x_v_01[]"
        name="x_v_01[]"
        class="form-select ew-select<?= $Page->v_01->isInvalidClass() ?>"
        <?php if (!$Page->v_01->IsNativeSelect) { ?>
        data-select2-id="fquotationsrch_x_v_01[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_01"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_01->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_01->getPlaceHolder()) ?>"
        <?= $Page->v_01->editAttributes() ?>>
        <?= $Page->v_01->selectOptionListHtml("x_v_01[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_01->getErrorMessage(false) ?></div>
<?= $Page->v_01->Lookup->getParamTag($Page, "p_x_v_01") ?>
<?php if (!$Page->v_01->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsrch", function() {
    var options = { name: "x_v_01[]", selectId: "fquotationsrch_x_v_01[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_01-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsrch.lists.v_01?.lookupOptions.length) {
        options.data = { id: "x_v_01[]", form: "fquotationsrch" };
    } else {
        options.ajax = { id: "x_v_01[]", form: "fquotationsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_01.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
<?php
if (!$Page->v_02->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_v_02" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->v_02->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->v_02->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_02" id="z_v_02" value="=">
</div>
        </div>
        <div id="el_quotation_v_02" class="ew-search-field">
    <select
        id="x_v_02[]"
        name="x_v_02[]"
        class="form-select ew-select<?= $Page->v_02->isInvalidClass() ?>"
        <?php if (!$Page->v_02->IsNativeSelect) { ?>
        data-select2-id="fquotationsrch_x_v_02[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_02"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_02->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_02->getPlaceHolder()) ?>"
        <?= $Page->v_02->editAttributes() ?>>
        <?= $Page->v_02->selectOptionListHtml("x_v_02[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_02->getErrorMessage(false) ?></div>
<?= $Page->v_02->Lookup->getParamTag($Page, "p_x_v_02") ?>
<?php if (!$Page->v_02->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsrch", function() {
    var options = { name: "x_v_02[]", selectId: "fquotationsrch_x_v_02[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_02-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsrch.lists.v_02?.lookupOptions.length) {
        options.data = { id: "x_v_02[]", form: "fquotationsrch" };
    } else {
        options.ajax = { id: "x_v_02[]", form: "fquotationsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_02.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
<?php
if (!$Page->v_03->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_v_03" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->v_03->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->v_03->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_03" id="z_v_03" value="=">
</div>
        </div>
        <div id="el_quotation_v_03" class="ew-search-field">
    <select
        id="x_v_03[]"
        name="x_v_03[]"
        class="form-select ew-select<?= $Page->v_03->isInvalidClass() ?>"
        <?php if (!$Page->v_03->IsNativeSelect) { ?>
        data-select2-id="fquotationsrch_x_v_03[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_03"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_03->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_03->getPlaceHolder()) ?>"
        <?= $Page->v_03->editAttributes() ?>>
        <?= $Page->v_03->selectOptionListHtml("x_v_03[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_03->getErrorMessage(false) ?></div>
<?= $Page->v_03->Lookup->getParamTag($Page, "p_x_v_03") ?>
<?php if (!$Page->v_03->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsrch", function() {
    var options = { name: "x_v_03[]", selectId: "fquotationsrch_x_v_03[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_03-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsrch.lists.v_03?.lookupOptions.length) {
        options.data = { id: "x_v_03[]", form: "fquotationsrch" };
    } else {
        options.ajax = { id: "x_v_03[]", form: "fquotationsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_03.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
<?php
if (!$Page->v_04->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_v_04" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->v_04->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->v_04->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_04" id="z_v_04" value="=">
</div>
        </div>
        <div id="el_quotation_v_04" class="ew-search-field">
    <select
        id="x_v_04[]"
        name="x_v_04[]"
        class="form-select ew-select<?= $Page->v_04->isInvalidClass() ?>"
        <?php if (!$Page->v_04->IsNativeSelect) { ?>
        data-select2-id="fquotationsrch_x_v_04[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_04"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_04->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_04->getPlaceHolder()) ?>"
        <?= $Page->v_04->editAttributes() ?>>
        <?= $Page->v_04->selectOptionListHtml("x_v_04[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_04->getErrorMessage(false) ?></div>
<?= $Page->v_04->Lookup->getParamTag($Page, "p_x_v_04") ?>
<?php if (!$Page->v_04->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsrch", function() {
    var options = { name: "x_v_04[]", selectId: "fquotationsrch_x_v_04[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_04-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsrch.lists.v_04?.lookupOptions.length) {
        options.data = { id: "x_v_04[]", form: "fquotationsrch" };
    } else {
        options.ajax = { id: "x_v_04[]", form: "fquotationsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_04.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
<?php
if (!$Page->v_05->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_v_05" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->v_05->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->v_05->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_v_05" id="z_v_05" value="=">
</div>
        </div>
        <div id="el_quotation_v_05" class="ew-search-field">
    <select
        id="x_v_05[]"
        name="x_v_05[]"
        class="form-select ew-select<?= $Page->v_05->isInvalidClass() ?>"
        <?php if (!$Page->v_05->IsNativeSelect) { ?>
        data-select2-id="fquotationsrch_x_v_05[]"
        <?php } ?>
        data-table="quotation"
        data-field="x_v_05"
        data-dropdown
        multiple
        size="1"
        data-value-separator="<?= $Page->v_05->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->v_05->getPlaceHolder()) ?>"
        <?= $Page->v_05->editAttributes() ?>>
        <?= $Page->v_05->selectOptionListHtml("x_v_05[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->v_05->getErrorMessage(false) ?></div>
<?= $Page->v_05->Lookup->getParamTag($Page, "p_x_v_05") ?>
<?php if (!$Page->v_05->IsNativeSelect) { ?>
<script>
loadjs.ready("fquotationsrch", function() {
    var options = { name: "x_v_05[]", selectId: "fquotationsrch_x_v_05[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.columns = el.dataset.repeatcolumn || 3;
    options.dropdown = !ew.IS_MOBILE && options.columns > 0; // Use custom dropdown
    el.dataset.dropdown = options.dropdown;
    if (options.dropdown) {
        options.dropdownAutoWidth = true;
        options.dropdownCssClass = "ew-select-dropdown quotation-x_v_05-dropdown ew-select-" + (options.multiple ? "multiple" : "one");
        if (options.columns > 1)
            options.dropdownCssClass += " ew-repeat-column";
    }
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquotationsrch.lists.v_05?.lookupOptions.length) {
        options.data = { id: "x_v_05[]", form: "fquotationsrch" };
    } else {
        options.ajax = { id: "x_v_05[]", form: "fquotationsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.quotation.fields.v_05.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fquotationsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fquotationsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fquotationsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fquotationsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fquotationsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fquotationsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fquotationsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="quotation">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_quotation" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_quotationlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_quotation_id" class="quotation_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->main_image->Visible) { // main_image ?>
        <th data-name="main_image" class="<?= $Page->main_image->headerCellClass() ?>"><div id="elh_quotation_main_image" class="quotation_main_image"><?= $Page->renderFieldHeader($Page->main_image) ?></div></th>
<?php } ?>
<?php if ($Page->godown_id->Visible) { // godown_id ?>
        <th data-name="godown_id" class="<?= $Page->godown_id->headerCellClass() ?>"><div id="elh_quotation_godown_id" class="quotation_godown_id"><?= $Page->renderFieldHeader($Page->godown_id) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_quotation_product" class="quotation_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
        <th data-name="product_code" class="<?= $Page->product_code->headerCellClass() ?>"><div id="elh_quotation_product_code" class="quotation_product_code"><?= $Page->renderFieldHeader($Page->product_code) ?></div></th>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
        <th data-name="Balance" class="<?= $Page->Balance->headerCellClass() ?>"><div id="elh_quotation_Balance" class="quotation_Balance"><?= $Page->renderFieldHeader($Page->Balance) ?></div></th>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Page->price->headerCellClass() ?>"><div id="elh_quotation_price" class="quotation_price"><?= $Page->renderFieldHeader($Page->price) ?></div></th>
<?php } ?>
<?php if ($Page->price_kg->Visible) { // price_kg ?>
        <th data-name="price_kg" class="<?= $Page->price_kg->headerCellClass() ?>"><div id="elh_quotation_price_kg" class="quotation_price_kg"><?= $Page->renderFieldHeader($Page->price_kg) ?></div></th>
<?php } ?>
<?php if ($Page->price_unit->Visible) { // price_unit ?>
        <th data-name="price_unit" class="<?= $Page->price_unit->headerCellClass() ?>"><div id="elh_quotation_price_unit" class="quotation_price_unit"><?= $Page->renderFieldHeader($Page->price_unit) ?></div></th>
<?php } ?>
<?php if ($Page->b_12->Visible) { // b_12 ?>
        <th data-name="b_12" class="<?= $Page->b_12->headerCellClass() ?>"><div id="elh_quotation_b_12" class="quotation_b_12"><?= $Page->renderFieldHeader($Page->b_12) ?></div></th>
<?php } ?>
<?php if ($Page->b_01->Visible) { // b_01 ?>
        <th data-name="b_01" class="<?= $Page->b_01->headerCellClass() ?>"><div id="elh_quotation_b_01" class="quotation_b_01"><?= $Page->renderFieldHeader($Page->b_01) ?></div></th>
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
        <th data-name="v_01" class="<?= $Page->v_01->headerCellClass() ?>"><div id="elh_quotation_v_01" class="quotation_v_01"><?= $Page->renderFieldHeader($Page->v_01) ?></div></th>
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
        <th data-name="v_02" class="<?= $Page->v_02->headerCellClass() ?>"><div id="elh_quotation_v_02" class="quotation_v_02"><?= $Page->renderFieldHeader($Page->v_02) ?></div></th>
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
        <th data-name="v_03" class="<?= $Page->v_03->headerCellClass() ?>"><div id="elh_quotation_v_03" class="quotation_v_03"><?= $Page->renderFieldHeader($Page->v_03) ?></div></th>
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
        <th data-name="v_04" class="<?= $Page->v_04->headerCellClass() ?>"><div id="elh_quotation_v_04" class="quotation_v_04"><?= $Page->renderFieldHeader($Page->v_04) ?></div></th>
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
        <th data-name="v_05" class="<?= $Page->v_05->headerCellClass() ?>"><div id="elh_quotation_v_05" class="quotation_v_05"><?= $Page->renderFieldHeader($Page->v_05) ?></div></th>
<?php } ?>
<?php if ($Page->Amount->Visible) { // Amount ?>
        <th data-name="Amount" class="<?= $Page->Amount->headerCellClass() ?>"><div id="elh_quotation_Amount" class="quotation_Amount"><?= $Page->renderFieldHeader($Page->Amount) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_quotation_packing_type" class="quotation_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_id" class="el_quotation_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->main_image->Visible) { // main_image ?>
        <td data-name="main_image"<?= $Page->main_image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_main_image" class="el_quotation_main_image">
<span>
<?= GetFileViewTag($Page->main_image, $Page->main_image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown_id->Visible) { // godown_id ?>
        <td data-name="godown_id"<?= $Page->godown_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_godown_id" class="el_quotation_godown_id">
<span<?= $Page->godown_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->godown_id->getViewValue()) && $Page->godown_id->linkAttributes() != "") { ?>
<a<?= $Page->godown_id->linkAttributes() ?>><?= $Page->godown_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->godown_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_product" class="el_quotation_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code"<?= $Page->product_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_product_code" class="el_quotation_product_code">
<span<?= $Page->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_code->getViewValue()) && $Page->product_code->linkAttributes() != "") { ?>
<a<?= $Page->product_code->linkAttributes() ?>><?= $Page->product_code->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Balance->Visible) { // Balance ?>
        <td data-name="Balance"<?= $Page->Balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_Balance" class="el_quotation_Balance">
<span<?= $Page->Balance->viewAttributes() ?>>
<?= $Page->Balance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price"<?= $Page->price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_price" class="el_quotation_price">
<span<?= $Page->price->viewAttributes() ?>>
<?= $Page->price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price_kg->Visible) { // price_kg ?>
        <td data-name="price_kg"<?= $Page->price_kg->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_price_kg" class="el_quotation_price_kg">
<span<?= $Page->price_kg->viewAttributes() ?>>
<?= $Page->price_kg->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price_unit->Visible) { // price_unit ?>
        <td data-name="price_unit"<?= $Page->price_unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_price_unit" class="el_quotation_price_unit">
<span<?= $Page->price_unit->viewAttributes() ?>>
<?= $Page->price_unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_12->Visible) { // b_12 ?>
        <td data-name="b_12"<?= $Page->b_12->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_b_12" class="el_quotation_b_12">
<span<?= $Page->b_12->viewAttributes() ?>>
<?= $Page->b_12->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_01->Visible) { // b_01 ?>
        <td data-name="b_01"<?= $Page->b_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_b_01" class="el_quotation_b_01">
<span<?= $Page->b_01->viewAttributes() ?>>
<?= $Page->b_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_01->Visible) { // v_01 ?>
        <td data-name="v_01"<?= $Page->v_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_v_01" class="el_quotation_v_01">
<span<?= $Page->v_01->viewAttributes() ?>>
<?php if (!EmptyString($Page->v_01->getViewValue()) && $Page->v_01->linkAttributes() != "") { ?>
<a<?= $Page->v_01->linkAttributes() ?>><?= $Page->v_01->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->v_01->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_02->Visible) { // v_02 ?>
        <td data-name="v_02"<?= $Page->v_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_v_02" class="el_quotation_v_02">
<span<?= $Page->v_02->viewAttributes() ?>>
<?php if (!EmptyString($Page->v_02->getViewValue()) && $Page->v_02->linkAttributes() != "") { ?>
<a<?= $Page->v_02->linkAttributes() ?>><?= $Page->v_02->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->v_02->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_03->Visible) { // v_03 ?>
        <td data-name="v_03"<?= $Page->v_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_v_03" class="el_quotation_v_03">
<span<?= $Page->v_03->viewAttributes() ?>>
<?php if (!EmptyString($Page->v_03->getViewValue()) && $Page->v_03->linkAttributes() != "") { ?>
<a<?= $Page->v_03->linkAttributes() ?>><?= $Page->v_03->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->v_03->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_04->Visible) { // v_04 ?>
        <td data-name="v_04"<?= $Page->v_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_v_04" class="el_quotation_v_04">
<span<?= $Page->v_04->viewAttributes() ?>>
<?php if (!EmptyString($Page->v_04->getViewValue()) && $Page->v_04->linkAttributes() != "") { ?>
<a<?= $Page->v_04->linkAttributes() ?>><?= $Page->v_04->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->v_04->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_05->Visible) { // v_05 ?>
        <td data-name="v_05"<?= $Page->v_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_v_05" class="el_quotation_v_05">
<span<?= $Page->v_05->viewAttributes() ?>>
<?php if (!EmptyString($Page->v_05->getViewValue()) && $Page->v_05->linkAttributes() != "") { ?>
<a<?= $Page->v_05->linkAttributes() ?>><?= $Page->v_05->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->v_05->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Amount->Visible) { // Amount ?>
        <td data-name="Amount"<?= $Page->Amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_Amount" class="el_quotation_Amount">
<span<?= $Page->Amount->viewAttributes() ?>>
<?= $Page->Amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_quotation_packing_type" class="el_quotation_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_quotation_id" class="quotation_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->main_image->Visible) { // main_image ?>
        <td data-name="main_image" class="<?= $Page->main_image->footerCellClass() ?>"><span id="elf_quotation_main_image" class="quotation_main_image">
        </span></td>
    <?php } ?>
    <?php if ($Page->godown_id->Visible) { // godown_id ?>
        <td data-name="godown_id" class="<?= $Page->godown_id->footerCellClass() ?>"><span id="elf_quotation_godown_id" class="quotation_godown_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_quotation_product" class="quotation_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code" class="<?= $Page->product_code->footerCellClass() ?>"><span id="elf_quotation_product_code" class="quotation_product_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->Balance->Visible) { // Balance ?>
        <td data-name="Balance" class="<?= $Page->Balance->footerCellClass() ?>"><span id="elf_quotation_Balance" class="quotation_Balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->Balance->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price" class="<?= $Page->price->footerCellClass() ?>"><span id="elf_quotation_price" class="quotation_price">
        </span></td>
    <?php } ?>
    <?php if ($Page->price_kg->Visible) { // price_kg ?>
        <td data-name="price_kg" class="<?= $Page->price_kg->footerCellClass() ?>"><span id="elf_quotation_price_kg" class="quotation_price_kg">
        <span class="ew-aggregate"><?= $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
        <?= $Page->price_kg->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->price_unit->Visible) { // price_unit ?>
        <td data-name="price_unit" class="<?= $Page->price_unit->footerCellClass() ?>"><span id="elf_quotation_price_unit" class="quotation_price_unit">
        </span></td>
    <?php } ?>
    <?php if ($Page->b_12->Visible) { // b_12 ?>
        <td data-name="b_12" class="<?= $Page->b_12->footerCellClass() ?>"><span id="elf_quotation_b_12" class="quotation_b_12">
        </span></td>
    <?php } ?>
    <?php if ($Page->b_01->Visible) { // b_01 ?>
        <td data-name="b_01" class="<?= $Page->b_01->footerCellClass() ?>"><span id="elf_quotation_b_01" class="quotation_b_01">
        </span></td>
    <?php } ?>
    <?php if ($Page->v_01->Visible) { // v_01 ?>
        <td data-name="v_01" class="<?= $Page->v_01->footerCellClass() ?>"><span id="elf_quotation_v_01" class="quotation_v_01">
        </span></td>
    <?php } ?>
    <?php if ($Page->v_02->Visible) { // v_02 ?>
        <td data-name="v_02" class="<?= $Page->v_02->footerCellClass() ?>"><span id="elf_quotation_v_02" class="quotation_v_02">
        </span></td>
    <?php } ?>
    <?php if ($Page->v_03->Visible) { // v_03 ?>
        <td data-name="v_03" class="<?= $Page->v_03->footerCellClass() ?>"><span id="elf_quotation_v_03" class="quotation_v_03">
        </span></td>
    <?php } ?>
    <?php if ($Page->v_04->Visible) { // v_04 ?>
        <td data-name="v_04" class="<?= $Page->v_04->footerCellClass() ?>"><span id="elf_quotation_v_04" class="quotation_v_04">
        </span></td>
    <?php } ?>
    <?php if ($Page->v_05->Visible) { // v_05 ?>
        <td data-name="v_05" class="<?= $Page->v_05->footerCellClass() ?>"><span id="elf_quotation_v_05" class="quotation_v_05">
        </span></td>
    <?php } ?>
    <?php if ($Page->Amount->Visible) { // Amount ?>
        <td data-name="Amount" class="<?= $Page->Amount->footerCellClass() ?>"><span id="elf_quotation_Amount" class="quotation_Amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->Amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_quotation_packing_type" class="quotation_packing_type">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("quotation");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
