<?php

namespace PHPMaker2024\fibre;

// Page object
$QueryProductionTableSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_production_table: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fquery_production_tablesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquery_production_tablesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyer", [], fields.buyer.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["Weaving", [], fields.Weaving.isInvalid],
            ["y_Weaving", [ew.Validators.between], false],
            ["Packing", [], fields.Packing.isInvalid],
            ["y_Packing", [ew.Validators.between], false],
            ["order_quantity", [ew.Validators.integer], fields.order_quantity.isInvalid],
            ["count", [ew.Validators.integer], fields.count.isInvalid],
            ["y_count", [ew.Validators.between], false],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["y_sqm", [ew.Validators.between], false],
            ["sqm_a", [ew.Validators.float], fields.sqm_a.isInvalid],
            ["y_sqm_a", [ew.Validators.between], false],
            ["process_c", [], fields.process_c.isInvalid],
            ["process_d", [], fields.process_d.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["dispatch_week_p", [], fields.dispatch_week_p.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["URL_DSP", [], fields.URL_DSP.isInvalid],
            ["buyer_barcode", [], fields.buyer_barcode.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "Weaving": <?= $Page->Weaving->toClientList($Page) ?>,
            "Packing": <?= $Page->Packing->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "dispatch_week_p": <?= $Page->dispatch_week_p->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fquery_production_tablesearch" id="fquery_production_tablesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="query_production_table">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->buyer->Visible) { // buyer ?>
    <div id="r_buyer" class="row"<?= $Page->buyer->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_buyer"><?= $Page->buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_buyer" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->buyer->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer" class="ew-auto-suggest">
    <input type="<?= $Page->buyer->getInputTextType() ?>" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?= RemoveHtml($Page->buyer->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer->formatPattern()) ?>"<?= $Page->buyer->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="query_production_table" data-field="x_buyer" data-input="sv_x_buyer" data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?= HtmlEncode($Page->buyer->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    fquery_production_tablesearch.createAutoSuggest(Object.assign({"id":"x_buyer","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.query_production_table.fields.buyer.autoSuggestOptions));
});
</script>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po" id="z_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="query_production_table" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="query_production_table" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_design_id"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_design_id", selectId: "fquery_production_tablesearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="query_production_table" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Weaving->Visible) { // Weaving ?>
    <div id="r_Weaving" class="row"<?= $Page->Weaving->rowAttributes() ?>>
        <label for="x_Weaving" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_Weaving"><?= $Page->Weaving->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Weaving->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Weaving" id="z_Weaving" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Weaving->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Weaving->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_query_production_table_Weaving" class="ew-search-field">
    <select
        id="x_Weaving"
        name="x_Weaving"
        class="form-select ew-select<?= $Page->Weaving->isInvalidClass() ?>"
        <?php if (!$Page->Weaving->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_Weaving"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_Weaving"
        data-value-separator="<?= $Page->Weaving->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Weaving->getPlaceHolder()) ?>"
        <?= $Page->Weaving->editAttributes() ?>>
        <?= $Page->Weaving->selectOptionListHtml("x_Weaving") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Weaving->getErrorMessage(false) ?></div>
<?php if (!$Page->Weaving->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_Weaving", selectId: "fquery_production_tablesearch_x_Weaving" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.Weaving?.lookupOptions.length) {
        options.data = { id: "x_Weaving", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_Weaving", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.Weaving.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_query_production_table_Weaving" class="ew-search-field2 d-none">
    <select
        id="y_Weaving"
        name="y_Weaving"
        class="form-select ew-select<?= $Page->Weaving->isInvalidClass() ?>"
        <?php if (!$Page->Weaving->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_y_Weaving"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_Weaving"
        data-value-separator="<?= $Page->Weaving->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Weaving->getPlaceHolder()) ?>"
        <?= $Page->Weaving->editAttributes() ?>>
        <?= $Page->Weaving->selectOptionListHtml("y_Weaving") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Weaving->getErrorMessage(false) ?></div>
<?php if (!$Page->Weaving->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "y_Weaving", selectId: "fquery_production_tablesearch_y_Weaving" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.Weaving?.lookupOptions.length) {
        options.data = { id: "y_Weaving", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "y_Weaving", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.Weaving.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Packing->Visible) { // Packing ?>
    <div id="r_Packing" class="row"<?= $Page->Packing->rowAttributes() ?>>
        <label for="x_Packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_Packing"><?= $Page->Packing->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Packing" id="z_Packing" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Packing->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Packing->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_query_production_table_Packing" class="ew-search-field">
    <select
        id="x_Packing"
        name="x_Packing"
        class="form-select ew-select<?= $Page->Packing->isInvalidClass() ?>"
        <?php if (!$Page->Packing->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_Packing"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_Packing"
        data-value-separator="<?= $Page->Packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Packing->getPlaceHolder()) ?>"
        <?= $Page->Packing->editAttributes() ?>>
        <?= $Page->Packing->selectOptionListHtml("x_Packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Packing->getErrorMessage(false) ?></div>
<?php if (!$Page->Packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_Packing", selectId: "fquery_production_tablesearch_x_Packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.Packing?.lookupOptions.length) {
        options.data = { id: "x_Packing", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_Packing", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.Packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_query_production_table_Packing" class="ew-search-field2 d-none">
    <select
        id="y_Packing"
        name="y_Packing"
        class="form-select ew-select<?= $Page->Packing->isInvalidClass() ?>"
        <?php if (!$Page->Packing->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_y_Packing"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_Packing"
        data-value-separator="<?= $Page->Packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Packing->getPlaceHolder()) ?>"
        <?= $Page->Packing->editAttributes() ?>>
        <?= $Page->Packing->selectOptionListHtml("y_Packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Packing->getErrorMessage(false) ?></div>
<?php if (!$Page->Packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "y_Packing", selectId: "fquery_production_tablesearch_y_Packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.Packing?.lookupOptions.length) {
        options.data = { id: "y_Packing", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "y_Packing", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.Packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_quantity->Visible) { // order_quantity ?>
    <div id="r_order_quantity" class="row"<?= $Page->order_quantity->rowAttributes() ?>>
        <label for="x_order_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_order_quantity"><?= $Page->order_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_quantity" id="z_order_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_order_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_quantity->getInputTextType() ?>" name="x_order_quantity" id="x_order_quantity" data-table="query_production_table" data-field="x_order_quantity" value="<?= $Page->order_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->order_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_quantity->formatPattern()) ?>"<?= $Page->order_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->count->Visible) { // count ?>
    <div id="r_count" class="row"<?= $Page->count->rowAttributes() ?>>
        <label for="x_count" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_count"><?= $Page->count->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->count->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_count" id="z_count" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->count->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->count->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_query_production_table_count" class="ew-search-field">
<input type="<?= $Page->count->getInputTextType() ?>" name="x_count" id="x_count" data-table="query_production_table" data-field="x_count" value="<?= $Page->count->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->count->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count->formatPattern()) ?>"<?= $Page->count->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_query_production_table_count" class="ew-search-field2 d-none">
<input type="<?= $Page->count->getInputTextType() ?>" name="y_count" id="y_count" data-table="query_production_table" data-field="x_count" value="<?= $Page->count->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->count->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->count->formatPattern()) ?>"<?= $Page->count->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->count->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_sqm"><?= $Page->sqm->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_sqm" id="z_sqm" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->sqm->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->sqm->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_query_production_table_sqm" class="ew-search-field">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="query_production_table" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_query_production_table_sqm" class="ew-search-field2 d-none">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="y_sqm" id="y_sqm" data-table="query_production_table" data-field="x_sqm" value="<?= $Page->sqm->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
    <div id="r_sqm_a" class="row"<?= $Page->sqm_a->rowAttributes() ?>>
        <label for="x_sqm_a" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_sqm_a"><?= $Page->sqm_a->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm_a->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_sqm_a" id="z_sqm_a" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->sqm_a->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->sqm_a->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_query_production_table_sqm_a" class="ew-search-field">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="x_sqm_a" id="x_sqm_a" data-table="query_production_table" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_query_production_table_sqm_a" class="ew-search-field2 d-none">
<input type="<?= $Page->sqm_a->getInputTextType() ?>" name="y_sqm_a" id="y_sqm_a" data-table="query_production_table" data-field="x_sqm_a" value="<?= $Page->sqm_a->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm_a->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm_a->formatPattern()) ?>"<?= $Page->sqm_a->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm_a->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="query_production_table" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_status"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_status", selectId: "fquery_production_tablesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
    <div id="r_dispatch_week_p" class="row"<?= $Page->dispatch_week_p->rowAttributes() ?>>
        <label for="x_dispatch_week_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_dispatch_week_p"><?= $Page->dispatch_week_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dispatch_week_p" id="z_dispatch_week_p" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dispatch_week_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_dispatch_week_p" class="ew-search-field ew-search-field-single">
    <select
        id="x_dispatch_week_p"
        name="x_dispatch_week_p"
        class="form-select ew-select<?= $Page->dispatch_week_p->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_dispatch_week_p"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_dispatch_week_p"
        data-value-separator="<?= $Page->dispatch_week_p->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_week_p->getPlaceHolder()) ?>"
        <?= $Page->dispatch_week_p->editAttributes() ?>>
        <?= $Page->dispatch_week_p->selectOptionListHtml("x_dispatch_week_p") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_week_p->getErrorMessage(false) ?></div>
<?= $Page->dispatch_week_p->Lookup->getParamTag($Page, "p_x_dispatch_week_p") ?>
<?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_dispatch_week_p", selectId: "fquery_production_tablesearch_x_dispatch_week_p" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.dispatch_week_p?.lookupOptions.length) {
        options.data = { id: "x_dispatch_week_p", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_dispatch_week_p", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.dispatch_week_p.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works" class="row"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_current_works"><?= $Page->current_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_current_works"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_current_works", selectId: "fquery_production_tablesearch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="fquery_production_tablesearch_x_batch_no"
        <?php } ?>
        data-table="query_production_table"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_production_tablesearch", function() {
    var options = { name: "x_batch_no", selectId: "fquery_production_tablesearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_production_tablesearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fquery_production_tablesearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fquery_production_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production_table.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->URL_DSP->Visible) { // URL_DSP ?>
    <div id="r_URL_DSP" class="row"<?= $Page->URL_DSP->rowAttributes() ?>>
        <label for="x_URL_DSP" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_URL_DSP"><?= $Page->URL_DSP->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_URL_DSP" id="z_URL_DSP" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->URL_DSP->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_URL_DSP" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->URL_DSP->getInputTextType() ?>" name="x_URL_DSP" id="x_URL_DSP" data-table="query_production_table" data-field="x_URL_DSP" value="<?= $Page->URL_DSP->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->URL_DSP->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->URL_DSP->formatPattern()) ?>"<?= $Page->URL_DSP->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->URL_DSP->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
    <div id="r_buyer_barcode" class="row"<?= $Page->buyer_barcode->rowAttributes() ?>>
        <label for="x_buyer_barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_production_table_buyer_barcode"><?= $Page->buyer_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_barcode" id="z_buyer_barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_production_table_buyer_barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_barcode->getInputTextType() ?>" name="x_buyer_barcode" id="x_buyer_barcode" data-table="query_production_table" data-field="x_buyer_barcode" value="<?= $Page->buyer_barcode->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->buyer_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_barcode->formatPattern()) ?>"<?= $Page->buyer_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fquery_production_tablesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fquery_production_tablesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fquery_production_tablesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("query_production_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
