<?php

namespace PHPMaker2024\fibre;

// Page object
$QueryProductionList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_production: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fquery_productionsrch" id="fquery_productionsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fquery_productionsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_production: currentTable } });
var currentForm;
var fquery_productionsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquery_productionsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyer", [], fields.buyer.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["Weaving", [], fields.Weaving.isInvalid],
            ["y_Weaving", [ew.Validators.between], false],
            ["Packing", [], fields.Packing.isInvalid],
            ["y_Packing", [ew.Validators.between], false],
            ["process_c", [], fields.process_c.isInvalid],
            ["process_d", [], fields.process_d.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["dispatch_week_p", [], fields.dispatch_week_p.isInvalid],
            ["y_dispatch_week_p", [ew.Validators.between], false],
            ["current_works", [], fields.current_works.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer": <?= $Page->buyer->toClientList($Page) ?>,
            "po": <?= $Page->po->toClientList($Page) ?>,
            "Weaving": <?= $Page->Weaving->toClientList($Page) ?>,
            "Packing": <?= $Page->Packing->toClientList($Page) ?>,
            "dispatch_week_p": <?= $Page->dispatch_week_p->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->buyer->Visible) { // buyer ?>
<?php
if (!$Page->buyer->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->buyer->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer" id="z_buyer" value="=">
</div>
        </div>
        <div id="el_query_production_buyer" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->buyer->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_buyer" class="ew-auto-suggest">
    <input type="<?= $Page->buyer->getInputTextType() ?>" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?= RemoveHtml($Page->buyer->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer->formatPattern()) ?>"<?= $Page->buyer->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="query_production" data-field="x_buyer" data-input="sv_x_buyer" data-value-separator="<?= $Page->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?= HtmlEncode($Page->buyer->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->buyer->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fquery_productionsrch", function() {
    fquery_productionsrch.createAutoSuggest(Object.assign({"id":"x_buyer","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->buyer->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.query_production.fields.buyer.autoSuggestOptions));
});
</script>
<?= $Page->buyer->Lookup->getParamTag($Page, "p_x_buyer") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_query_production_po" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->po->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po" class="ew-auto-suggest">
    <input type="<?= $Page->po->getInputTextType() ?>" class="form-control" name="sv_x_po" id="sv_x_po" value="<?= RemoveHtml($Page->po->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="query_production" data-field="x_po" data-input="sv_x_po" data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>" name="x_po" id="x_po" value="<?= HtmlEncode($Page->po->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fquery_productionsrch", function() {
    fquery_productionsrch.createAutoSuggest(Object.assign({"id":"x_po","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.query_production.fields.po.autoSuggestOptions));
});
</script>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_query_production_po" class="ew-search-field2 d-none">
<?php
if (IsRTL()) {
    $Page->po->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_y_po" class="ew-auto-suggest">
    <input type="<?= $Page->po->getInputTextType() ?>" class="form-control" name="sv_y_po" id="sv_y_po" value="<?= RemoveHtml($Page->po->EditValue2) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="query_production" data-field="x_po" data-input="sv_y_po" data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>" name="y_po" id="y_po" value="<?= HtmlEncode($Page->po->AdvancedSearch->SearchValue2) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fquery_productionsrch", function() {
    fquery_productionsrch.createAutoSuggest(Object.assign({"id":"y_po","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.query_production.fields.po.autoSuggestOptions));
});
</script>
<?= $Page->po->Lookup->getParamTag($Page, "p_y_po") ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
<?php
if (!$Page->buyer_ref->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_ref" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_ref->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_ref" class="ew-search-caption ew-label"><?= $Page->buyer_ref->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</div>
        </div>
        <div id="el_query_production_buyer_ref" class="ew-search-field">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="query_production" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
<?php
if (!$Page->size_cm->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_size_cm" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->size_cm->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_size_cm" class="ew-search-caption ew-label"><?= $Page->size_cm->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</div>
        </div>
        <div id="el_query_production_size_cm" class="ew-search-field">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="query_production" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="245" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Weaving->Visible) { // Weaving ?>
<?php
if (!$Page->Weaving->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Weaving" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Weaving->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Weaving" class="ew-search-caption ew-label"><?= $Page->Weaving->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_Weaving" id="z_Weaving" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Weaving->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Weaving->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_query_production_Weaving" class="ew-search-field">
    <select
        id="x_Weaving"
        name="x_Weaving"
        class="form-select ew-select<?= $Page->Weaving->isInvalidClass() ?>"
        <?php if (!$Page->Weaving->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_x_Weaving"
        <?php } ?>
        data-table="query_production"
        data-field="x_Weaving"
        data-value-separator="<?= $Page->Weaving->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Weaving->getPlaceHolder()) ?>"
        <?= $Page->Weaving->editAttributes() ?>>
        <?= $Page->Weaving->selectOptionListHtml("x_Weaving") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Weaving->getErrorMessage(false) ?></div>
<?php if (!$Page->Weaving->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "x_Weaving", selectId: "fquery_productionsrch_x_Weaving" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.Weaving?.lookupOptions.length) {
        options.data = { id: "x_Weaving", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "x_Weaving", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.Weaving.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_query_production_Weaving" class="ew-search-field2 d-none">
    <select
        id="y_Weaving"
        name="y_Weaving"
        class="form-select ew-select<?= $Page->Weaving->isInvalidClass() ?>"
        <?php if (!$Page->Weaving->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_y_Weaving"
        <?php } ?>
        data-table="query_production"
        data-field="x_Weaving"
        data-value-separator="<?= $Page->Weaving->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Weaving->getPlaceHolder()) ?>"
        <?= $Page->Weaving->editAttributes() ?>>
        <?= $Page->Weaving->selectOptionListHtml("y_Weaving") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Weaving->getErrorMessage(false) ?></div>
<?php if (!$Page->Weaving->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "y_Weaving", selectId: "fquery_productionsrch_y_Weaving" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.Weaving?.lookupOptions.length) {
        options.data = { id: "y_Weaving", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "y_Weaving", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.Weaving.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->Packing->Visible) { // Packing ?>
<?php
if (!$Page->Packing->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_Packing" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->Packing->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_Packing" class="ew-search-caption ew-label"><?= $Page->Packing->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_Packing" id="z_Packing" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Packing->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Packing->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_query_production_Packing" class="ew-search-field">
    <select
        id="x_Packing"
        name="x_Packing"
        class="form-select ew-select<?= $Page->Packing->isInvalidClass() ?>"
        <?php if (!$Page->Packing->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_x_Packing"
        <?php } ?>
        data-table="query_production"
        data-field="x_Packing"
        data-value-separator="<?= $Page->Packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Packing->getPlaceHolder()) ?>"
        <?= $Page->Packing->editAttributes() ?>>
        <?= $Page->Packing->selectOptionListHtml("x_Packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Packing->getErrorMessage(false) ?></div>
<?php if (!$Page->Packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "x_Packing", selectId: "fquery_productionsrch_x_Packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.Packing?.lookupOptions.length) {
        options.data = { id: "x_Packing", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "x_Packing", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.Packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_query_production_Packing" class="ew-search-field2 d-none">
    <select
        id="y_Packing"
        name="y_Packing"
        class="form-select ew-select<?= $Page->Packing->isInvalidClass() ?>"
        <?php if (!$Page->Packing->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_y_Packing"
        <?php } ?>
        data-table="query_production"
        data-field="x_Packing"
        data-value-separator="<?= $Page->Packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->Packing->getPlaceHolder()) ?>"
        <?= $Page->Packing->editAttributes() ?>>
        <?= $Page->Packing->selectOptionListHtml("y_Packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->Packing->getErrorMessage(false) ?></div>
<?php if (!$Page->Packing->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "y_Packing", selectId: "fquery_productionsrch_y_Packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.Packing?.lookupOptions.length) {
        options.data = { id: "y_Packing", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "y_Packing", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.Packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
<?php
if (!$Page->process_c->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_c" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_c->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_c" class="ew-search-caption ew-label"><?= $Page->process_c->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_c" id="z_process_c" value="LIKE">
</div>
        </div>
        <div id="el_query_production_process_c" class="ew-search-field">
<input type="<?= $Page->process_c->getInputTextType() ?>" name="x_process_c" id="x_process_c" data-table="query_production" data-field="x_process_c" value="<?= $Page->process_c->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_c->formatPattern()) ?>"<?= $Page->process_c->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
<?php
if (!$Page->process_d->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_d" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_d->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_d" class="ew-search-caption ew-label"><?= $Page->process_d->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process_d" id="z_process_d" value="LIKE">
</div>
        </div>
        <div id="el_query_production_process_d" class="ew-search-field">
<input type="<?= $Page->process_d->getInputTextType() ?>" name="x_process_d" id="x_process_d" data-table="query_production" data-field="x_process_d" value="<?= $Page->process_d->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->process_d->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_d->formatPattern()) ?>"<?= $Page->process_d->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_d->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_query_production__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="query_production" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_query_production__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="query_production" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
<?php
if (!$Page->dispatch_week_p->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_dispatch_week_p" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->dispatch_week_p->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_dispatch_week_p" class="ew-search-caption ew-label"><?= $Page->dispatch_week_p->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_dispatch_week_p" id="z_dispatch_week_p" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dispatch_week_p->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dispatch_week_p->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_query_production_dispatch_week_p" class="ew-search-field">
    <select
        id="x_dispatch_week_p"
        name="x_dispatch_week_p"
        class="form-select ew-select<?= $Page->dispatch_week_p->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_x_dispatch_week_p"
        <?php } ?>
        data-table="query_production"
        data-field="x_dispatch_week_p"
        data-value-separator="<?= $Page->dispatch_week_p->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_week_p->getPlaceHolder()) ?>"
        <?= $Page->dispatch_week_p->editAttributes() ?>>
        <?= $Page->dispatch_week_p->selectOptionListHtml("x_dispatch_week_p") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_week_p->getErrorMessage(false) ?></div>
<?= $Page->dispatch_week_p->Lookup->getParamTag($Page, "p_x_dispatch_week_p") ?>
<?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "x_dispatch_week_p", selectId: "fquery_productionsrch_x_dispatch_week_p" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.dispatch_week_p?.lookupOptions.length) {
        options.data = { id: "x_dispatch_week_p", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "x_dispatch_week_p", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.dispatch_week_p.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_query_production_dispatch_week_p" class="ew-search-field2 d-none">
    <select
        id="y_dispatch_week_p"
        name="y_dispatch_week_p"
        class="form-select ew-select<?= $Page->dispatch_week_p->isInvalidClass() ?>"
        <?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_y_dispatch_week_p"
        <?php } ?>
        data-table="query_production"
        data-field="x_dispatch_week_p"
        data-value-separator="<?= $Page->dispatch_week_p->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->dispatch_week_p->getPlaceHolder()) ?>"
        <?= $Page->dispatch_week_p->editAttributes() ?>>
        <?= $Page->dispatch_week_p->selectOptionListHtml("y_dispatch_week_p") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->dispatch_week_p->getErrorMessage(false) ?></div>
<?= $Page->dispatch_week_p->Lookup->getParamTag($Page, "p_y_dispatch_week_p") ?>
<?php if (!$Page->dispatch_week_p->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "y_dispatch_week_p", selectId: "fquery_productionsrch_y_dispatch_week_p" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.dispatch_week_p?.lookupOptions.length) {
        options.data = { id: "y_dispatch_week_p", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "y_dispatch_week_p", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.dispatch_week_p.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
<?php
if (!$Page->current_works->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_current_works" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->current_works->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_current_works" class="ew-search-caption ew-label"><?= $Page->current_works->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</div>
        </div>
        <div id="el_query_production_current_works" class="ew-search-field">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fquery_productionsrch_x_current_works"
        <?php } ?>
        data-table="query_production"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_productionsrch", function() {
    var options = { name: "x_current_works", selectId: "fquery_productionsrch_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_productionsrch.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fquery_productionsrch" };
    } else {
        options.ajax = { id: "x_current_works", form: "fquery_productionsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_production.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fquery_productionsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fquery_productionsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fquery_productionsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fquery_productionsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fquery_productionsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fquery_productionsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fquery_productionsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="query_production">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_query_production" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_query_productionlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->buyer->Visible) { // buyer ?>
        <th data-name="buyer" class="<?= $Page->buyer->headerCellClass() ?>"><div id="elh_query_production_buyer" class="query_production_buyer"><?= $Page->renderFieldHeader($Page->buyer) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_query_production_po" class="query_production_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_query_production_buyer_ref" class="query_production_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_query_production_size_cm" class="query_production_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->Weaving->Visible) { // Weaving ?>
        <th data-name="Weaving" class="<?= $Page->Weaving->headerCellClass() ?>"><div id="elh_query_production_Weaving" class="query_production_Weaving"><?= $Page->renderFieldHeader($Page->Weaving) ?></div></th>
<?php } ?>
<?php if ($Page->Packing->Visible) { // Packing ?>
        <th data-name="Packing" class="<?= $Page->Packing->headerCellClass() ?>"><div id="elh_query_production_Packing" class="query_production_Packing"><?= $Page->renderFieldHeader($Page->Packing) ?></div></th>
<?php } ?>
<?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <th data-name="order_quantity" class="<?= $Page->order_quantity->headerCellClass() ?>"><div id="elh_query_production_order_quantity" class="query_production_order_quantity"><?= $Page->renderFieldHeader($Page->order_quantity) ?></div></th>
<?php } ?>
<?php if ($Page->count->Visible) { // count ?>
        <th data-name="count" class="<?= $Page->count->headerCellClass() ?>"><div id="elh_query_production_count" class="query_production_count"><?= $Page->renderFieldHeader($Page->count) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_query_production_sqm" class="query_production_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <th data-name="sqm_a" class="<?= $Page->sqm_a->headerCellClass() ?>"><div id="elh_query_production_sqm_a" class="query_production_sqm_a"><?= $Page->renderFieldHeader($Page->sqm_a) ?></div></th>
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
        <th data-name="process_c" class="<?= $Page->process_c->headerCellClass() ?>"><div id="elh_query_production_process_c" class="query_production_process_c"><?= $Page->renderFieldHeader($Page->process_c) ?></div></th>
<?php } ?>
<?php if ($Page->process_d->Visible) { // process_d ?>
        <th data-name="process_d" class="<?= $Page->process_d->headerCellClass() ?>"><div id="elh_query_production_process_d" class="query_production_process_d"><?= $Page->renderFieldHeader($Page->process_d) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_query_production_status" class="query_production_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>" style="min-width: 300px;"><div id="elh_query_production__barcode" class="query_production__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
        <th data-name="dispatch_week_p" class="<?= $Page->dispatch_week_p->headerCellClass() ?>"><div id="elh_query_production_dispatch_week_p" class="query_production_dispatch_week_p"><?= $Page->renderFieldHeader($Page->dispatch_week_p) ?></div></th>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
        <th data-name="current_works" class="<?= $Page->current_works->headerCellClass() ?>"><div id="elh_query_production_current_works" class="query_production_current_works"><?= $Page->renderFieldHeader($Page->current_works) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_type->Visible) { // shipping_type ?>
        <th data-name="shipping_type" class="<?= $Page->shipping_type->headerCellClass() ?>"><div id="elh_query_production_shipping_type" class="query_production_shipping_type"><?= $Page->renderFieldHeader($Page->shipping_type) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_query_production_batch_no" class="query_production_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <th data-name="buyer_barcode" class="<?= $Page->buyer_barcode->headerCellClass() ?>"><div id="elh_query_production_buyer_barcode" class="query_production_buyer_barcode"><?= $Page->renderFieldHeader($Page->buyer_barcode) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->buyer->Visible) { // buyer ?>
        <td data-name="buyer"<?= $Page->buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_buyer" class="el_query_production_buyer">
<span<?= $Page->buyer->viewAttributes() ?>>
<?php if (!EmptyString($Page->buyer->getViewValue()) && $Page->buyer->linkAttributes() != "") { ?>
<a<?= $Page->buyer->linkAttributes() ?>><?= $Page->buyer->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->buyer->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_po" class="el_query_production_po">
<span<?= $Page->po->viewAttributes() ?>>
<?php if (!EmptyString($Page->po->getViewValue()) && $Page->po->linkAttributes() != "") { ?>
<a<?= $Page->po->linkAttributes() ?>><?= $Page->po->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->po->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_buyer_ref" class="el_query_production_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?= $Page->buyer_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_size_cm" class="el_query_production_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?php if (!EmptyString($Page->size_cm->getViewValue()) && $Page->size_cm->linkAttributes() != "") { ?>
<a<?= $Page->size_cm->linkAttributes() ?>><?= $Page->size_cm->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->size_cm->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Weaving->Visible) { // Weaving ?>
        <td data-name="Weaving"<?= $Page->Weaving->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_Weaving" class="el_query_production_Weaving">
<span<?= $Page->Weaving->viewAttributes() ?>>
<?php if (!EmptyString($Page->Weaving->getViewValue()) && $Page->Weaving->linkAttributes() != "") { ?>
<a<?= $Page->Weaving->linkAttributes() ?>><?= $Page->Weaving->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->Weaving->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Packing->Visible) { // Packing ?>
        <td data-name="Packing"<?= $Page->Packing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_Packing" class="el_query_production_Packing">
<span<?= $Page->Packing->viewAttributes() ?>>
<?php if (!EmptyString($Page->Packing->getViewValue()) && $Page->Packing->linkAttributes() != "") { ?>
<a<?= $Page->Packing->linkAttributes() ?>><?= $Page->Packing->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->Packing->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <td data-name="order_quantity"<?= $Page->order_quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_order_quantity" class="el_query_production_order_quantity">
<span<?= $Page->order_quantity->viewAttributes() ?>>
<?php if (!EmptyString($Page->order_quantity->getViewValue()) && $Page->order_quantity->linkAttributes() != "") { ?>
<a<?= $Page->order_quantity->linkAttributes() ?>><?= $Page->order_quantity->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->order_quantity->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->count->Visible) { // count ?>
        <td data-name="count"<?= $Page->count->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_count" class="el_query_production_count">
<span<?= $Page->count->viewAttributes() ?>>
<?= $Page->count->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_sqm" class="el_query_production_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a"<?= $Page->sqm_a->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_sqm_a" class="el_query_production_sqm_a">
<span<?= $Page->sqm_a->viewAttributes() ?>>
<?= $Page->sqm_a->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_c->Visible) { // process_c ?>
        <td data-name="process_c"<?= $Page->process_c->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_process_c" class="el_query_production_process_c">
<span<?= $Page->process_c->viewAttributes() ?>>
<?= $Page->process_c->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_d->Visible) { // process_d ?>
        <td data-name="process_d"<?= $Page->process_d->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_process_d" class="el_query_production_process_d">
<span<?= $Page->process_d->viewAttributes() ?>>
<?= $Page->process_d->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_status" class="el_query_production_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production__barcode" class="el_query_production__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?php if (!EmptyString($Page->_barcode->getViewValue()) && $Page->_barcode->linkAttributes() != "") { ?>
<a<?= $Page->_barcode->linkAttributes() ?>><?= $Page->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
        <td data-name="dispatch_week_p"<?= $Page->dispatch_week_p->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_dispatch_week_p" class="el_query_production_dispatch_week_p">
<span<?= $Page->dispatch_week_p->viewAttributes() ?>>
<?= $Page->dispatch_week_p->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works"<?= $Page->current_works->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_current_works" class="el_query_production_current_works">
<span<?= $Page->current_works->viewAttributes() ?>>
<?= $Page->current_works->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_type->Visible) { // shipping_type ?>
        <td data-name="shipping_type"<?= $Page->shipping_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_shipping_type" class="el_query_production_shipping_type">
<span<?= $Page->shipping_type->viewAttributes() ?>>
<?= $Page->shipping_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_batch_no" class="el_query_production_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <td data-name="buyer_barcode"<?= $Page->buyer_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_production_buyer_barcode" class="el_query_production_buyer_barcode">
<span<?= $Page->buyer_barcode->viewAttributes() ?>>
<?= $Page->buyer_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->buyer->Visible) { // buyer ?>
        <td data-name="buyer" class="<?= $Page->buyer->footerCellClass() ?>"><span id="elf_query_production_buyer" class="query_production_buyer">
        </span></td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po" class="<?= $Page->po->footerCellClass() ?>"><span id="elf_query_production_po" class="query_production_po">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref" class="<?= $Page->buyer_ref->footerCellClass() ?>"><span id="elf_query_production_buyer_ref" class="query_production_buyer_ref">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm" class="<?= $Page->size_cm->footerCellClass() ?>"><span id="elf_query_production_size_cm" class="query_production_size_cm">
        </span></td>
    <?php } ?>
    <?php if ($Page->Weaving->Visible) { // Weaving ?>
        <td data-name="Weaving" class="<?= $Page->Weaving->footerCellClass() ?>"><span id="elf_query_production_Weaving" class="query_production_Weaving">
        </span></td>
    <?php } ?>
    <?php if ($Page->Packing->Visible) { // Packing ?>
        <td data-name="Packing" class="<?= $Page->Packing->footerCellClass() ?>"><span id="elf_query_production_Packing" class="query_production_Packing">
        </span></td>
    <?php } ?>
    <?php if ($Page->order_quantity->Visible) { // order_quantity ?>
        <td data-name="order_quantity" class="<?= $Page->order_quantity->footerCellClass() ?>"><span id="elf_query_production_order_quantity" class="query_production_order_quantity">
        </span></td>
    <?php } ?>
    <?php if ($Page->count->Visible) { // count ?>
        <td data-name="count" class="<?= $Page->count->footerCellClass() ?>"><span id="elf_query_production_count" class="query_production_count">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->count->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm" class="<?= $Page->sqm->footerCellClass() ?>"><span id="elf_query_production_sqm" class="query_production_sqm">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->sqm_a->Visible) { // sqm_a ?>
        <td data-name="sqm_a" class="<?= $Page->sqm_a->footerCellClass() ?>"><span id="elf_query_production_sqm_a" class="query_production_sqm_a">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->sqm_a->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->process_c->Visible) { // process_c ?>
        <td data-name="process_c" class="<?= $Page->process_c->footerCellClass() ?>"><span id="elf_query_production_process_c" class="query_production_process_c">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_d->Visible) { // process_d ?>
        <td data-name="process_d" class="<?= $Page->process_d->footerCellClass() ?>"><span id="elf_query_production_process_d" class="query_production_process_d">
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_query_production_status" class="query_production_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_query_production__barcode" class="query_production__barcode">
        </span></td>
    <?php } ?>
    <?php if ($Page->dispatch_week_p->Visible) { // dispatch_week_p ?>
        <td data-name="dispatch_week_p" class="<?= $Page->dispatch_week_p->footerCellClass() ?>"><span id="elf_query_production_dispatch_week_p" class="query_production_dispatch_week_p">
        </span></td>
    <?php } ?>
    <?php if ($Page->current_works->Visible) { // current_works ?>
        <td data-name="current_works" class="<?= $Page->current_works->footerCellClass() ?>"><span id="elf_query_production_current_works" class="query_production_current_works">
        </span></td>
    <?php } ?>
    <?php if ($Page->shipping_type->Visible) { // shipping_type ?>
        <td data-name="shipping_type" class="<?= $Page->shipping_type->footerCellClass() ?>"><span id="elf_query_production_shipping_type" class="query_production_shipping_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_query_production_batch_no" class="query_production_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->buyer_barcode->Visible) { // buyer_barcode ?>
        <td data-name="buyer_barcode" class="<?= $Page->buyer_barcode->footerCellClass() ?>"><span id="elf_query_production_buyer_barcode" class="query_production_buyer_barcode">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("query_production");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
