<?php

namespace PHPMaker2024\fibre;

// Page object
$QueryPppoPendingSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_pppo_pending: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fquery_pppo_pendingsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquery_pppo_pendingsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["design_id", [], fields.design_id.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["despatch_week", [], fields.despatch_week.isInvalid],
            ["Order", [ew.Validators.integer], fields.Order.isInvalid],
            ["Received", [ew.Validators.integer], fields.Received.isInvalid],
            ["Pending", [ew.Validators.integer], fields.Pending.isInvalid],
            ["ReceivedBC", [], fields.ReceivedBC.isInvalid],
            ["PendingBC", [], fields.PendingBC.isInvalid],
            ["size_buyer", [], fields.size_buyer.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["pp_id", [], fields.pp_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "despatch_week": <?= $Page->despatch_week->toClientList($Page) ?>,
            "buyer_ref": <?= $Page->buyer_ref->toClientList($Page) ?>,
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "pp_id": <?= $Page->pp_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fquery_pppo_pendingsearch" id="fquery_pppo_pendingsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="query_pppo_pending">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po" id="z_po" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_po" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="query_pppo_pending" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fquery_pppo_pendingsearch_x_design_id"
        <?php } ?>
        data-table="query_pppo_pending"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_pppo_pendingsearch", function() {
    var options = { name: "x_design_id", selectId: "fquery_pppo_pendingsearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_pppo_pendingsearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fquery_pppo_pendingsearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fquery_pppo_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_pppo_pending.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="query_pppo_pending" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->despatch_week->Visible) { // despatch_week ?>
    <div id="r_despatch_week" class="row"<?= $Page->despatch_week->rowAttributes() ?>>
        <label for="x_despatch_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_despatch_week"><?= $Page->despatch_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_despatch_week" id="z_despatch_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->despatch_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_despatch_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_despatch_week"
        name="x_despatch_week"
        class="form-select ew-select<?= $Page->despatch_week->isInvalidClass() ?>"
        <?php if (!$Page->despatch_week->IsNativeSelect) { ?>
        data-select2-id="fquery_pppo_pendingsearch_x_despatch_week"
        <?php } ?>
        data-table="query_pppo_pending"
        data-field="x_despatch_week"
        data-value-separator="<?= $Page->despatch_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->despatch_week->getPlaceHolder()) ?>"
        <?= $Page->despatch_week->editAttributes() ?>>
        <?= $Page->despatch_week->selectOptionListHtml("x_despatch_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->despatch_week->getErrorMessage(false) ?></div>
<?= $Page->despatch_week->Lookup->getParamTag($Page, "p_x_despatch_week") ?>
<?php if (!$Page->despatch_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_pppo_pendingsearch", function() {
    var options = { name: "x_despatch_week", selectId: "fquery_pppo_pendingsearch_x_despatch_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_pppo_pendingsearch.lists.despatch_week?.lookupOptions.length) {
        options.data = { id: "x_despatch_week", form: "fquery_pppo_pendingsearch" };
    } else {
        options.ajax = { id: "x_despatch_week", form: "fquery_pppo_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_pppo_pending.fields.despatch_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Order->Visible) { // Order ?>
    <div id="r_Order" class="row"<?= $Page->Order->rowAttributes() ?>>
        <label for="x_Order" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_Order"><?= $Page->Order->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Order" id="z_Order" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Order->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_Order" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Order->getInputTextType() ?>" name="x_Order" id="x_Order" data-table="query_pppo_pending" data-field="x_Order" value="<?= $Page->Order->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Order->formatPattern()) ?>"<?= $Page->Order->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Order->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Received->Visible) { // Received ?>
    <div id="r_Received" class="row"<?= $Page->Received->rowAttributes() ?>>
        <label for="x_Received" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_Received"><?= $Page->Received->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Received" id="z_Received" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Received->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_Received" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Received->getInputTextType() ?>" name="x_Received" id="x_Received" data-table="query_pppo_pending" data-field="x_Received" value="<?= $Page->Received->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Received->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Received->formatPattern()) ?>"<?= $Page->Received->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Received->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Pending->Visible) { // Pending ?>
    <div id="r_Pending" class="row"<?= $Page->Pending->rowAttributes() ?>>
        <label for="x_Pending" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_Pending"><?= $Page->Pending->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Pending" id="z_Pending" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Pending->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_Pending" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Pending->getInputTextType() ?>" name="x_Pending" id="x_Pending" data-table="query_pppo_pending" data-field="x_Pending" value="<?= $Page->Pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Pending->formatPattern()) ?>"<?= $Page->Pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Pending->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ReceivedBC->Visible) { // Received BC ?>
    <div id="r_ReceivedBC" class="row"<?= $Page->ReceivedBC->rowAttributes() ?>>
        <label for="x_ReceivedBC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_ReceivedBC"><?= $Page->ReceivedBC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ReceivedBC" id="z_ReceivedBC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ReceivedBC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_ReceivedBC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ReceivedBC->getInputTextType() ?>" name="x_ReceivedBC" id="x_ReceivedBC" data-table="query_pppo_pending" data-field="x_ReceivedBC" value="<?= $Page->ReceivedBC->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->ReceivedBC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ReceivedBC->formatPattern()) ?>"<?= $Page->ReceivedBC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ReceivedBC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->PendingBC->Visible) { // Pending BC ?>
    <div id="r_PendingBC" class="row"<?= $Page->PendingBC->rowAttributes() ?>>
        <label for="x_PendingBC" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_PendingBC"><?= $Page->PendingBC->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PendingBC" id="z_PendingBC" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->PendingBC->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_PendingBC" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->PendingBC->getInputTextType() ?>" name="x_PendingBC" id="x_PendingBC" data-table="query_pppo_pending" data-field="x_PendingBC" value="<?= $Page->PendingBC->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->PendingBC->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->PendingBC->formatPattern()) ?>"<?= $Page->PendingBC->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->PendingBC->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer" class="row"<?= $Page->size_buyer->rowAttributes() ?>>
        <label for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_size_buyer"><?= $Page->size_buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_size_buyer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="query_pppo_pending" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_buyer_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_ref"
        name="x_buyer_ref"
        class="form-select ew-select<?= $Page->buyer_ref->isInvalidClass() ?>"
        <?php if (!$Page->buyer_ref->IsNativeSelect) { ?>
        data-select2-id="fquery_pppo_pendingsearch_x_buyer_ref"
        <?php } ?>
        data-table="query_pppo_pending"
        data-field="x_buyer_ref"
        data-value-separator="<?= $Page->buyer_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>"
        <?= $Page->buyer_ref->editAttributes() ?>>
        <?= $Page->buyer_ref->selectOptionListHtml("x_buyer_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
<?= $Page->buyer_ref->Lookup->getParamTag($Page, "p_x_buyer_ref") ?>
<?php if (!$Page->buyer_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_pppo_pendingsearch", function() {
    var options = { name: "x_buyer_ref", selectId: "fquery_pppo_pendingsearch_x_buyer_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_pppo_pendingsearch.lists.buyer_ref?.lookupOptions.length) {
        options.data = { id: "x_buyer_ref", form: "fquery_pppo_pendingsearch" };
    } else {
        options.ajax = { id: "x_buyer_ref", form: "fquery_pppo_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_pppo_pending.fields.buyer_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fquery_pppo_pendingsearch_x_buyers_id"
        <?php } ?>
        data-table="query_pppo_pending"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_pppo_pendingsearch", function() {
    var options = { name: "x_buyers_id", selectId: "fquery_pppo_pendingsearch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_pppo_pendingsearch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fquery_pppo_pendingsearch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fquery_pppo_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_pppo_pending.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id" class="row"<?= $Page->pp_id->rowAttributes() ?>>
        <label for="x_pp_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_pppo_pending_pp_id"><?= $Page->pp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_id" id="z_pp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_pppo_pending_pp_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_pp_id"
        name="x_pp_id"
        class="form-select ew-select<?= $Page->pp_id->isInvalidClass() ?>"
        <?php if (!$Page->pp_id->IsNativeSelect) { ?>
        data-select2-id="fquery_pppo_pendingsearch_x_pp_id"
        <?php } ?>
        data-table="query_pppo_pending"
        data-field="x_pp_id"
        data-value-separator="<?= $Page->pp_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>"
        <?= $Page->pp_id->editAttributes() ?>>
        <?= $Page->pp_id->selectOptionListHtml("x_pp_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage(false) ?></div>
<?= $Page->pp_id->Lookup->getParamTag($Page, "p_x_pp_id") ?>
<?php if (!$Page->pp_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_pppo_pendingsearch", function() {
    var options = { name: "x_pp_id", selectId: "fquery_pppo_pendingsearch_x_pp_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_pppo_pendingsearch.lists.pp_id?.lookupOptions.length) {
        options.data = { id: "x_pp_id", form: "fquery_pppo_pendingsearch" };
    } else {
        options.ajax = { id: "x_pp_id", form: "fquery_pppo_pendingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_pppo_pending.fields.pp_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fquery_pppo_pendingsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fquery_pppo_pendingsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fquery_pppo_pendingsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("query_pppo_pending");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
