<?php

namespace PHPMaker2024\fibre;

// Page object
$QueryOmsList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_oms: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fquery_omssrch" id="fquery_omssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fquery_omssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_oms: currentTable } });
var currentForm;
var fquery_omssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquery_omssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["buyer_order", [], fields.buyer_order.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["design", [], fields.design.isInvalid],
            ["width", [ew.Validators.integer], fields.width.isInvalid],
            ["length", [ew.Validators.integer], fields.length.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
<?php
if (!$Page->buyers_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyers_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyers_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyers_id" class="ew-search-caption ew-label"><?= $Page->buyers_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</div>
        </div>
        <div id="el_query_oms_buyers_id" class="ew-search-field">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fquery_omssrch_x_buyers_id"
        <?php } ?>
        data-table="query_oms"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_omssrch", function() {
    var options = { name: "x_buyers_id", selectId: "fquery_omssrch_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_omssrch.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fquery_omssrch" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fquery_omssrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->buyer_order->Visible) { // buyer_order ?>
<?php
if (!$Page->buyer_order->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_buyer_order" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->buyer_order->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_buyer_order" class="ew-search-caption ew-label"><?= $Page->buyer_order->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE">
</div>
        </div>
        <div id="el_query_oms_buyer_order" class="ew-search-field">
<input type="<?= $Page->buyer_order->getInputTextType() ?>" name="x_buyer_order" id="x_buyer_order" data-table="query_oms" data-field="x_buyer_order" value="<?= $Page->buyer_order->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order->formatPattern()) ?>"<?= $Page->buyer_order->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_order->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
<?php
if (!$Page->po->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_po" class="ew-search-caption ew-label"><?= $Page->po->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_query_oms_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="query_oms" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_query_oms_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="query_oms" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
<?php
if (!$Page->design->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_design" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->design->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_design" class="ew-search-caption ew-label"><?= $Page->design->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</div>
        </div>
        <div id="el_query_oms_design" class="ew-search-field">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="query_oms" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->width->Visible) { // width ?>
<?php
if (!$Page->width->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_width" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->width->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_width" class="ew-search-caption ew-label"><?= $Page->width->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_width" id="z_width" value="=">
</div>
        </div>
        <div id="el_query_oms_width" class="ew-search-field">
<input type="<?= $Page->width->getInputTextType() ?>" name="x_width" id="x_width" data-table="query_oms" data-field="x_width" value="<?= $Page->width->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->width->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->width->formatPattern()) ?>"<?= $Page->width->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->width->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->length->Visible) { // length ?>
<?php
if (!$Page->length->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_length" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->length->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_length" class="ew-search-caption ew-label"><?= $Page->length->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_length" id="z_length" value="=">
</div>
        </div>
        <div id="el_query_oms_length" class="ew-search-field">
<input type="<?= $Page->length->getInputTextType() ?>" name="x_length" id="x_length" data-table="query_oms" data-field="x_length" value="<?= $Page->length->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->length->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->length->formatPattern()) ?>"<?= $Page->length->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->length->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fquery_omssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fquery_omssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fquery_omssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fquery_omssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fquery_omssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fquery_omssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fquery_omssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="query_oms">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_query_oms" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_query_omslist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_query_oms_id" class="query_oms_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <th data-name="buyers_id" class="<?= $Page->buyers_id->headerCellClass() ?>"><div id="elh_query_oms_buyers_id" class="query_oms_buyers_id"><?= $Page->renderFieldHeader($Page->buyers_id) ?></div></th>
<?php } ?>
<?php if ($Page->order_week->Visible) { // order_week ?>
        <th data-name="order_week" class="<?= $Page->order_week->headerCellClass() ?>"><div id="elh_query_oms_order_week" class="query_oms_order_week"><?= $Page->renderFieldHeader($Page->order_week) ?></div></th>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
        <th data-name="order_date" class="<?= $Page->order_date->headerCellClass() ?>"><div id="elh_query_oms_order_date" class="query_oms_order_date"><?= $Page->renderFieldHeader($Page->order_date) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_order->Visible) { // buyer_order ?>
        <th data-name="buyer_order" class="<?= $Page->buyer_order->headerCellClass() ?>"><div id="elh_query_oms_buyer_order" class="query_oms_buyer_order"><?= $Page->renderFieldHeader($Page->buyer_order) ?></div></th>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
        <th data-name="po" class="<?= $Page->po->headerCellClass() ?>"><div id="elh_query_oms_po" class="query_oms_po"><?= $Page->renderFieldHeader($Page->po) ?></div></th>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
        <th data-name="item" class="<?= $Page->item->headerCellClass() ?>"><div id="elh_query_oms_item" class="query_oms_item"><?= $Page->renderFieldHeader($Page->item) ?></div></th>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <th data-name="buyer_ref" class="<?= $Page->buyer_ref->headerCellClass() ?>"><div id="elh_query_oms_buyer_ref" class="query_oms_buyer_ref"><?= $Page->renderFieldHeader($Page->buyer_ref) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>"><div id="elh_query_oms_design" class="query_oms_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
        <th data-name="size_buyer" class="<?= $Page->size_buyer->headerCellClass() ?>"><div id="elh_query_oms_size_buyer" class="query_oms_size_buyer"><?= $Page->renderFieldHeader($Page->size_buyer) ?></div></th>
<?php } ?>
<?php if ($Page->width->Visible) { // width ?>
        <th data-name="width" class="<?= $Page->width->headerCellClass() ?>"><div id="elh_query_oms_width" class="query_oms_width"><?= $Page->renderFieldHeader($Page->width) ?></div></th>
<?php } ?>
<?php if ($Page->length->Visible) { // length ?>
        <th data-name="length" class="<?= $Page->length->headerCellClass() ?>"><div id="elh_query_oms_length" class="query_oms_length"><?= $Page->renderFieldHeader($Page->length) ?></div></th>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
        <th data-name="qty" class="<?= $Page->qty->headerCellClass() ?>"><div id="elh_query_oms_qty" class="query_oms_qty"><?= $Page->renderFieldHeader($Page->qty) ?></div></th>
<?php } ?>
<?php if ($Page->revised_qty->Visible) { // revised_qty ?>
        <th data-name="revised_qty" class="<?= $Page->revised_qty->headerCellClass() ?>"><div id="elh_query_oms_revised_qty" class="query_oms_revised_qty"><?= $Page->renderFieldHeader($Page->revised_qty) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_query_oms_sqm" class="query_oms_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->ex_factory->Visible) { // ex_factory ?>
        <th data-name="ex_factory" class="<?= $Page->ex_factory->headerCellClass() ?>"><div id="elh_query_oms_ex_factory" class="query_oms_ex_factory"><?= $Page->renderFieldHeader($Page->ex_factory) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
        <th data-name="shipping_mode" class="<?= $Page->shipping_mode->headerCellClass() ?>"><div id="elh_query_oms_shipping_mode" class="query_oms_shipping_mode"><?= $Page->renderFieldHeader($Page->shipping_mode) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_query_oms_remarks" class="query_oms_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->d_qty->Visible) { // d_qty ?>
        <th data-name="d_qty" class="<?= $Page->d_qty->headerCellClass() ?>"><div id="elh_query_oms_d_qty" class="query_oms_d_qty"><?= $Page->renderFieldHeader($Page->d_qty) ?></div></th>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
        <th data-name="pl_no" class="<?= $Page->pl_no->headerCellClass() ?>"><div id="elh_query_oms_pl_no" class="query_oms_pl_no"><?= $Page->renderFieldHeader($Page->pl_no) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <th data-name="invoice_date" class="<?= $Page->invoice_date->headerCellClass() ?>"><div id="elh_query_oms_invoice_date" class="query_oms_invoice_date"><?= $Page->renderFieldHeader($Page->invoice_date) ?></div></th>
<?php } ?>
<?php if ($Page->sailing_week->Visible) { // sailing_week ?>
        <th data-name="sailing_week" class="<?= $Page->sailing_week->headerCellClass() ?>"><div id="elh_query_oms_sailing_week" class="query_oms_sailing_week"><?= $Page->renderFieldHeader($Page->sailing_week) ?></div></th>
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
        <th data-name="pending" class="<?= $Page->pending->headerCellClass() ?>"><div id="elh_query_oms_pending" class="query_oms_pending"><?= $Page->renderFieldHeader($Page->pending) ?></div></th>
<?php } ?>
<?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
        <th data-name="pending_sqm" class="<?= $Page->pending_sqm->headerCellClass() ?>"><div id="elh_query_oms_pending_sqm" class="query_oms_pending_sqm"><?= $Page->renderFieldHeader($Page->pending_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_query_oms_cbm" class="query_oms_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->total_cbm->Visible) { // total_cbm ?>
        <th data-name="total_cbm" class="<?= $Page->total_cbm->headerCellClass() ?>"><div id="elh_query_oms_total_cbm" class="query_oms_total_cbm"><?= $Page->renderFieldHeader($Page->total_cbm) ?></div></th>
<?php } ?>
<?php if ($Page->offloom->Visible) { // offloom ?>
        <th data-name="offloom" class="<?= $Page->offloom->headerCellClass() ?>"><div id="elh_query_oms_offloom" class="query_oms_offloom"><?= $Page->renderFieldHeader($Page->offloom) ?></div></th>
<?php } ?>
<?php if ($Page->rejection->Visible) { // rejection ?>
        <th data-name="rejection" class="<?= $Page->rejection->headerCellClass() ?>"><div id="elh_query_oms_rejection" class="query_oms_rejection"><?= $Page->renderFieldHeader($Page->rejection) ?></div></th>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Page->reports_to->headerCellClass() ?>"><div id="elh_query_oms_reports_to" class="query_oms_reports_to"><?= $Page->renderFieldHeader($Page->reports_to) ?></div></th>
<?php } ?>
<?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <th data-name="weight_sqm" class="<?= $Page->weight_sqm->headerCellClass() ?>"><div id="elh_query_oms_weight_sqm" class="query_oms_weight_sqm"><?= $Page->renderFieldHeader($Page->weight_sqm) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_id" class="el_query_oms_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyers_id->Visible) { // buyers_id ?>
        <td data-name="buyers_id"<?= $Page->buyers_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_buyers_id" class="el_query_oms_buyers_id">
<span<?= $Page->buyers_id->viewAttributes() ?>>
<?= $Page->buyers_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_week->Visible) { // order_week ?>
        <td data-name="order_week"<?= $Page->order_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_order_week" class="el_query_oms_order_week">
<span<?= $Page->order_week->viewAttributes() ?>>
<?= $Page->order_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->order_date->Visible) { // order_date ?>
        <td data-name="order_date"<?= $Page->order_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_order_date" class="el_query_oms_order_date">
<span<?= $Page->order_date->viewAttributes() ?>>
<?= $Page->order_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_order->Visible) { // buyer_order ?>
        <td data-name="buyer_order"<?= $Page->buyer_order->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_buyer_order" class="el_query_oms_buyer_order">
<span<?= $Page->buyer_order->viewAttributes() ?>>
<?= $Page->buyer_order->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po->Visible) { // po ?>
        <td data-name="po"<?= $Page->po->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_po" class="el_query_oms_po">
<span<?= $Page->po->viewAttributes() ?>>
<?= $Page->po->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->item->Visible) { // item ?>
        <td data-name="item"<?= $Page->item->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_item" class="el_query_oms_item">
<span<?= $Page->item->viewAttributes() ?>>
<?= $Page->item->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
        <td data-name="buyer_ref"<?= $Page->buyer_ref->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_buyer_ref" class="el_query_oms_buyer_ref">
<span<?= $Page->buyer_ref->viewAttributes() ?>>
<?= $Page->buyer_ref->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_design" class="el_query_oms_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_buyer->Visible) { // size_buyer ?>
        <td data-name="size_buyer"<?= $Page->size_buyer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_size_buyer" class="el_query_oms_size_buyer">
<span<?= $Page->size_buyer->viewAttributes() ?>>
<?= $Page->size_buyer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->width->Visible) { // width ?>
        <td data-name="width"<?= $Page->width->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_width" class="el_query_oms_width">
<span<?= $Page->width->viewAttributes() ?>>
<?= $Page->width->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->length->Visible) { // length ?>
        <td data-name="length"<?= $Page->length->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_length" class="el_query_oms_length">
<span<?= $Page->length->viewAttributes() ?>>
<?= $Page->length->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qty->Visible) { // qty ?>
        <td data-name="qty"<?= $Page->qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_qty" class="el_query_oms_qty">
<span<?= $Page->qty->viewAttributes() ?>>
<?= $Page->qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->revised_qty->Visible) { // revised_qty ?>
        <td data-name="revised_qty"<?= $Page->revised_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_revised_qty" class="el_query_oms_revised_qty">
<span<?= $Page->revised_qty->viewAttributes() ?>>
<?= $Page->revised_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_sqm" class="el_query_oms_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ex_factory->Visible) { // ex_factory ?>
        <td data-name="ex_factory"<?= $Page->ex_factory->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_ex_factory" class="el_query_oms_ex_factory">
<span<?= $Page->ex_factory->viewAttributes() ?>>
<?= $Page->ex_factory->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
        <td data-name="shipping_mode"<?= $Page->shipping_mode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_shipping_mode" class="el_query_oms_shipping_mode">
<span<?= $Page->shipping_mode->viewAttributes() ?>>
<?= $Page->shipping_mode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_remarks" class="el_query_oms_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_qty->Visible) { // d_qty ?>
        <td data-name="d_qty"<?= $Page->d_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_d_qty" class="el_query_oms_d_qty">
<span<?= $Page->d_qty->viewAttributes() ?>>
<?= $Page->d_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no"<?= $Page->pl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_pl_no" class="el_query_oms_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?= $Page->pl_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_date->Visible) { // invoice_date ?>
        <td data-name="invoice_date"<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_invoice_date" class="el_query_oms_invoice_date">
<span<?= $Page->invoice_date->viewAttributes() ?>>
<?= $Page->invoice_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sailing_week->Visible) { // sailing_week ?>
        <td data-name="sailing_week"<?= $Page->sailing_week->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_sailing_week" class="el_query_oms_sailing_week">
<span<?= $Page->sailing_week->viewAttributes() ?>>
<?= $Page->sailing_week->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending->Visible) { // pending ?>
        <td data-name="pending"<?= $Page->pending->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_pending" class="el_query_oms_pending">
<span<?= $Page->pending->viewAttributes() ?>>
<?= $Page->pending->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
        <td data-name="pending_sqm"<?= $Page->pending_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_pending_sqm" class="el_query_oms_pending_sqm">
<span<?= $Page->pending_sqm->viewAttributes() ?>>
<?= $Page->pending_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_cbm" class="el_query_oms_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->total_cbm->Visible) { // total_cbm ?>
        <td data-name="total_cbm"<?= $Page->total_cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_total_cbm" class="el_query_oms_total_cbm">
<span<?= $Page->total_cbm->viewAttributes() ?>>
<?= $Page->total_cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->offloom->Visible) { // offloom ?>
        <td data-name="offloom"<?= $Page->offloom->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_offloom" class="el_query_oms_offloom">
<span<?= $Page->offloom->viewAttributes() ?>>
<?= $Page->offloom->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rejection->Visible) { // rejection ?>
        <td data-name="rejection"<?= $Page->rejection->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_rejection" class="el_query_oms_rejection">
<span<?= $Page->rejection->viewAttributes() ?>>
<?= $Page->rejection->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Page->reports_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_reports_to" class="el_query_oms_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<?= $Page->reports_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
        <td data-name="weight_sqm"<?= $Page->weight_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_query_oms_weight_sqm" class="el_query_oms_weight_sqm">
<span<?= $Page->weight_sqm->viewAttributes() ?>>
<?= $Page->weight_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("query_oms");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
