<?php

namespace PHPMaker2024\fibre;

// Page object
$QueryOms2Search = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { query_oms_2: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fquery_oms_2search, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fquery_oms_2search")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["buyers_id", [], fields.buyers_id.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["order_week", [], fields.order_week.isInvalid],
            ["order_date", [ew.Validators.datetime(fields.order_date.clientFormatPattern)], fields.order_date.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["current_works", [], fields.current_works.isInvalid],
            ["buyer_order", [], fields.buyer_order.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["item", [], fields.item.isInvalid],
            ["buyer_ref", [], fields.buyer_ref.isInvalid],
            ["design", [], fields.design.isInvalid],
            ["size_buyer", [], fields.size_buyer.isInvalid],
            ["width", [ew.Validators.integer], fields.width.isInvalid],
            ["length", [ew.Validators.integer], fields.length.isInvalid],
            ["qty", [ew.Validators.integer], fields.qty.isInvalid],
            ["revised_qty", [ew.Validators.integer], fields.revised_qty.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["ex_factory", [], fields.ex_factory.isInvalid],
            ["ex_factory_p", [], fields.ex_factory_p.isInvalid],
            ["shipping_mode", [], fields.shipping_mode.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["d_qty", [ew.Validators.float], fields.d_qty.isInvalid],
            ["pl_no", [], fields.pl_no.isInvalid],
            ["invoice_date", [], fields.invoice_date.isInvalid],
            ["sailing_week", [], fields.sailing_week.isInvalid],
            ["pending", [ew.Validators.float], fields.pending.isInvalid],
            ["pending_sqm", [ew.Validators.float], fields.pending_sqm.isInvalid],
            ["cbm", [], fields.cbm.isInvalid],
            ["total_cbm", [], fields.total_cbm.isInvalid],
            ["offloom", [ew.Validators.float], fields.offloom.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["rejection", [ew.Validators.integer], fields.rejection.isInvalid],
            ["completed", [], fields.completed.isInvalid],
            ["weaving_works", [ew.Validators.integer], fields.weaving_works.isInvalid],
            ["cs", [ew.Validators.integer], fields.cs.isInvalid],
            ["weight_sqm", [ew.Validators.float], fields.weight_sqm.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyers_id": <?= $Page->buyers_id->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "order_week": <?= $Page->order_week->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "current_works": <?= $Page->current_works->toClientList($Page) ?>,
            "ex_factory": <?= $Page->ex_factory->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "completed": <?= $Page->completed->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fquery_oms_2search" id="fquery_oms_2search" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="query_oms_2">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="query_oms_2" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyers_id->Visible) { // buyers_id ?>
    <div id="r_buyers_id" class="row"<?= $Page->buyers_id->rowAttributes() ?>>
        <label for="x_buyers_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_buyers_id"><?= $Page->buyers_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyers_id" id="z_buyers_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyers_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_buyers_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyers_id"
        name="x_buyers_id"
        class="form-select ew-select<?= $Page->buyers_id->isInvalidClass() ?>"
        <?php if (!$Page->buyers_id->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_buyers_id"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_buyers_id"
        data-value-separator="<?= $Page->buyers_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyers_id->getPlaceHolder()) ?>"
        <?= $Page->buyers_id->editAttributes() ?>>
        <?= $Page->buyers_id->selectOptionListHtml("x_buyers_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyers_id->getErrorMessage(false) ?></div>
<?= $Page->buyers_id->Lookup->getParamTag($Page, "p_x_buyers_id") ?>
<?php if (!$Page->buyers_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_buyers_id", selectId: "fquery_oms_2search_x_buyers_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.buyers_id?.lookupOptions.length) {
        options.data = { id: "x_buyers_id", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_buyers_id", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.buyers_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_reports_to"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_reports_to"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_reports_to", selectId: "fquery_oms_2search_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_week->Visible) { // order_week ?>
    <div id="r_order_week" class="row"<?= $Page->order_week->rowAttributes() ?>>
        <label for="x_order_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_order_week"><?= $Page->order_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_week" id="z_order_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_order_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_order_week"
        name="x_order_week"
        class="form-select ew-select<?= $Page->order_week->isInvalidClass() ?>"
        <?php if (!$Page->order_week->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_order_week"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_order_week"
        data-value-separator="<?= $Page->order_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->order_week->getPlaceHolder()) ?>"
        <?= $Page->order_week->editAttributes() ?>>
        <?= $Page->order_week->selectOptionListHtml("x_order_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->order_week->getErrorMessage(false) ?></div>
<?= $Page->order_week->Lookup->getParamTag($Page, "p_x_order_week") ?>
<?php if (!$Page->order_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_order_week", selectId: "fquery_oms_2search_x_order_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.order_week?.lookupOptions.length) {
        options.data = { id: "x_order_week", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_order_week", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.order_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->order_date->Visible) { // order_date ?>
    <div id="r_order_date" class="row"<?= $Page->order_date->rowAttributes() ?>>
        <label for="x_order_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_order_date"><?= $Page->order_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_order_date" id="z_order_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->order_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_order_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->order_date->getInputTextType() ?>" name="x_order_date" id="x_order_date" data-table="query_oms_2" data-field="x_order_date" value="<?= $Page->order_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->order_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->order_date->formatPattern()) ?>"<?= $Page->order_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->order_date->getErrorMessage(false) ?></div>
<?php if (!$Page->order_date->ReadOnly && !$Page->order_date->Disabled && !isset($Page->order_date->EditAttrs["readonly"]) && !isset($Page->order_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fquery_oms_2search", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fquery_oms_2search", "x_order_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_category" id="z_category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_category"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_category", selectId: "fquery_oms_2search_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_category", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_works->Visible) { // current_works ?>
    <div id="r_current_works" class="row"<?= $Page->current_works->rowAttributes() ?>>
        <label for="x_current_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_current_works"><?= $Page->current_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_works" id="z_current_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_current_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_current_works"
        name="x_current_works"
        class="form-select ew-select<?= $Page->current_works->isInvalidClass() ?>"
        <?php if (!$Page->current_works->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_current_works"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_current_works"
        data-value-separator="<?= $Page->current_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->current_works->getPlaceHolder()) ?>"
        <?= $Page->current_works->editAttributes() ?>>
        <?= $Page->current_works->selectOptionListHtml("x_current_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->current_works->getErrorMessage(false) ?></div>
<?= $Page->current_works->Lookup->getParamTag($Page, "p_x_current_works") ?>
<?php if (!$Page->current_works->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_current_works", selectId: "fquery_oms_2search_x_current_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.current_works?.lookupOptions.length) {
        options.data = { id: "x_current_works", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_current_works", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.current_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_order->Visible) { // buyer_order ?>
    <div id="r_buyer_order" class="row"<?= $Page->buyer_order->rowAttributes() ?>>
        <label for="x_buyer_order" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_buyer_order"><?= $Page->buyer_order->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_order" id="z_buyer_order" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_order->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_buyer_order" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_order->getInputTextType() ?>" name="x_buyer_order" id="x_buyer_order" data-table="query_oms_2" data-field="x_buyer_order" value="<?= $Page->buyer_order->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->buyer_order->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_order->formatPattern()) ?>"<?= $Page->buyer_order->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_order->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_query_oms_2_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="query_oms_2" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_query_oms_2_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="query_oms_2" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->item->Visible) { // item ?>
    <div id="r_item" class="row"<?= $Page->item->rowAttributes() ?>>
        <label for="x_item" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_item"><?= $Page->item->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_item" id="z_item" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->item->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_item" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->item->getInputTextType() ?>" name="x_item" id="x_item" data-table="query_oms_2" data-field="x_item" value="<?= $Page->item->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->item->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->item->formatPattern()) ?>"<?= $Page->item->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->item->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_ref->Visible) { // buyer_ref ?>
    <div id="r_buyer_ref" class="row"<?= $Page->buyer_ref->rowAttributes() ?>>
        <label for="x_buyer_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_buyer_ref"><?= $Page->buyer_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_ref" id="z_buyer_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_buyer_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->buyer_ref->getInputTextType() ?>" name="x_buyer_ref" id="x_buyer_ref" data-table="query_oms_2" data-field="x_buyer_ref" value="<?= $Page->buyer_ref->EditValue ?>" size="30" maxlength="144" placeholder="<?= HtmlEncode($Page->buyer_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->buyer_ref->formatPattern()) ?>"<?= $Page->buyer_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->buyer_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="query_oms_2" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_buyer->Visible) { // size_buyer ?>
    <div id="r_size_buyer" class="row"<?= $Page->size_buyer->rowAttributes() ?>>
        <label for="x_size_buyer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_size_buyer"><?= $Page->size_buyer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_buyer" id="z_size_buyer" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_buyer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_size_buyer" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_buyer->getInputTextType() ?>" name="x_size_buyer" id="x_size_buyer" data-table="query_oms_2" data-field="x_size_buyer" value="<?= $Page->size_buyer->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_buyer->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_buyer->formatPattern()) ?>"<?= $Page->size_buyer->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_buyer->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->width->Visible) { // width ?>
    <div id="r_width" class="row"<?= $Page->width->rowAttributes() ?>>
        <label for="x_width" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_width"><?= $Page->width->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_width" id="z_width" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->width->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_width" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->width->getInputTextType() ?>" name="x_width" id="x_width" data-table="query_oms_2" data-field="x_width" value="<?= $Page->width->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->width->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->width->formatPattern()) ?>"<?= $Page->width->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->width->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->length->Visible) { // length ?>
    <div id="r_length" class="row"<?= $Page->length->rowAttributes() ?>>
        <label for="x_length" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_length"><?= $Page->length->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_length" id="z_length" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->length->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_length" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->length->getInputTextType() ?>" name="x_length" id="x_length" data-table="query_oms_2" data-field="x_length" value="<?= $Page->length->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->length->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->length->formatPattern()) ?>"<?= $Page->length->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->length->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qty->Visible) { // qty ?>
    <div id="r_qty" class="row"<?= $Page->qty->rowAttributes() ?>>
        <label for="x_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_qty"><?= $Page->qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qty" id="z_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qty->getInputTextType() ?>" name="x_qty" id="x_qty" data-table="query_oms_2" data-field="x_qty" value="<?= $Page->qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qty->formatPattern()) ?>"<?= $Page->qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->revised_qty->Visible) { // revised_qty ?>
    <div id="r_revised_qty" class="row"<?= $Page->revised_qty->rowAttributes() ?>>
        <label for="x_revised_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_revised_qty"><?= $Page->revised_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_revised_qty" id="z_revised_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->revised_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_revised_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->revised_qty->getInputTextType() ?>" name="x_revised_qty" id="x_revised_qty" data-table="query_oms_2" data-field="x_revised_qty" value="<?= $Page->revised_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->revised_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->revised_qty->formatPattern()) ?>"<?= $Page->revised_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->revised_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="query_oms_2" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ex_factory->Visible) { // ex_factory ?>
    <div id="r_ex_factory" class="row"<?= $Page->ex_factory->rowAttributes() ?>>
        <label for="x_ex_factory" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_ex_factory"><?= $Page->ex_factory->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ex_factory" id="z_ex_factory" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ex_factory->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_ex_factory" class="ew-search-field ew-search-field-single">
    <select
        id="x_ex_factory"
        name="x_ex_factory"
        class="form-select ew-select<?= $Page->ex_factory->isInvalidClass() ?>"
        <?php if (!$Page->ex_factory->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_ex_factory"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_ex_factory"
        data-value-separator="<?= $Page->ex_factory->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->ex_factory->getPlaceHolder()) ?>"
        <?= $Page->ex_factory->editAttributes() ?>>
        <?= $Page->ex_factory->selectOptionListHtml("x_ex_factory") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->ex_factory->getErrorMessage(false) ?></div>
<?= $Page->ex_factory->Lookup->getParamTag($Page, "p_x_ex_factory") ?>
<?php if (!$Page->ex_factory->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_ex_factory", selectId: "fquery_oms_2search_x_ex_factory" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.ex_factory?.lookupOptions.length) {
        options.data = { id: "x_ex_factory", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_ex_factory", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.ex_factory.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ex_factory_p->Visible) { // ex_factory_p ?>
    <div id="r_ex_factory_p" class="row"<?= $Page->ex_factory_p->rowAttributes() ?>>
        <label for="x_ex_factory_p" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_ex_factory_p"><?= $Page->ex_factory_p->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ex_factory_p" id="z_ex_factory_p" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ex_factory_p->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_ex_factory_p" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ex_factory_p->getInputTextType() ?>" name="x_ex_factory_p" id="x_ex_factory_p" data-table="query_oms_2" data-field="x_ex_factory_p" value="<?= $Page->ex_factory_p->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->ex_factory_p->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ex_factory_p->formatPattern()) ?>"<?= $Page->ex_factory_p->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ex_factory_p->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
    <div id="r_shipping_mode" class="row"<?= $Page->shipping_mode->rowAttributes() ?>>
        <label for="x_shipping_mode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_shipping_mode"><?= $Page->shipping_mode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shipping_mode" id="z_shipping_mode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_mode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_shipping_mode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shipping_mode->getInputTextType() ?>" name="x_shipping_mode" id="x_shipping_mode" data-table="query_oms_2" data-field="x_shipping_mode" value="<?= $Page->shipping_mode->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->shipping_mode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_mode->formatPattern()) ?>"<?= $Page->shipping_mode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipping_mode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="query_oms_2" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_qty->Visible) { // d_qty ?>
    <div id="r_d_qty" class="row"<?= $Page->d_qty->rowAttributes() ?>>
        <label for="x_d_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_d_qty"><?= $Page->d_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_qty" id="z_d_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_d_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_qty->getInputTextType() ?>" name="x_d_qty" id="x_d_qty" data-table="query_oms_2" data-field="x_d_qty" value="<?= $Page->d_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->d_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_qty->formatPattern()) ?>"<?= $Page->d_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no" class="row"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_pl_no"><?= $Page->pl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pl_no" id="z_pl_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="query_oms_2" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date" class="row"<?= $Page->invoice_date->rowAttributes() ?>>
        <label for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_invoice_date"><?= $Page->invoice_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice_date" id="z_invoice_date" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_invoice_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="query_oms_2" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sailing_week->Visible) { // sailing_week ?>
    <div id="r_sailing_week" class="row"<?= $Page->sailing_week->rowAttributes() ?>>
        <label for="x_sailing_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_sailing_week"><?= $Page->sailing_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sailing_week" id="z_sailing_week" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sailing_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_sailing_week" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sailing_week->getInputTextType() ?>" name="x_sailing_week" id="x_sailing_week" data-table="query_oms_2" data-field="x_sailing_week" value="<?= $Page->sailing_week->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->sailing_week->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sailing_week->formatPattern()) ?>"<?= $Page->sailing_week->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sailing_week->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
    <div id="r_pending" class="row"<?= $Page->pending->rowAttributes() ?>>
        <label for="x_pending" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_pending"><?= $Page->pending->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pending" id="z_pending" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_pending" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending->getInputTextType() ?>" name="x_pending" id="x_pending" data-table="query_oms_2" data-field="x_pending" value="<?= $Page->pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending_sqm->Visible) { // pending_sqm ?>
    <div id="r_pending_sqm" class="row"<?= $Page->pending_sqm->rowAttributes() ?>>
        <label for="x_pending_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_pending_sqm"><?= $Page->pending_sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pending_sqm" id="z_pending_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending_sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_pending_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pending_sqm->getInputTextType() ?>" name="x_pending_sqm" id="x_pending_sqm" data-table="query_oms_2" data-field="x_pending_sqm" value="<?= $Page->pending_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_sqm->formatPattern()) ?>"<?= $Page->pending_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="query_oms_2" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->total_cbm->Visible) { // total_cbm ?>
    <div id="r_total_cbm" class="row"<?= $Page->total_cbm->rowAttributes() ?>>
        <label for="x_total_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_total_cbm"><?= $Page->total_cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_total_cbm" id="z_total_cbm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->total_cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_total_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->total_cbm->getInputTextType() ?>" name="x_total_cbm" id="x_total_cbm" data-table="query_oms_2" data-field="x_total_cbm" value="<?= $Page->total_cbm->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->total_cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->total_cbm->formatPattern()) ?>"<?= $Page->total_cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->total_cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->offloom->Visible) { // offloom ?>
    <div id="r_offloom" class="row"<?= $Page->offloom->rowAttributes() ?>>
        <label for="x_offloom" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_offloom"><?= $Page->offloom->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_offloom" id="z_offloom" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->offloom->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_offloom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->offloom->getInputTextType() ?>" name="x_offloom" id="x_offloom" data-table="query_oms_2" data-field="x_offloom" value="<?= $Page->offloom->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->offloom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->offloom->formatPattern()) ?>"<?= $Page->offloom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->offloom->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_status" id="z_status" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status[]"
        name="x_status[]"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fquery_oms_2search_x_status[]"
        <?php } ?>
        data-table="query_oms_2"
        data-field="x_status"
        multiple
        size="1"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fquery_oms_2search", function() {
    var options = { name: "x_status[]", selectId: "fquery_oms_2search_x_status[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fquery_oms_2search.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status[]", form: "fquery_oms_2search" };
    } else {
        options.ajax = { id: "x_status[]", form: "fquery_oms_2search", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.query_oms_2.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rejection->Visible) { // rejection ?>
    <div id="r_rejection" class="row"<?= $Page->rejection->rowAttributes() ?>>
        <label for="x_rejection" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_rejection"><?= $Page->rejection->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rejection" id="z_rejection" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rejection->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_rejection" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rejection->getInputTextType() ?>" name="x_rejection" id="x_rejection" data-table="query_oms_2" data-field="x_rejection" value="<?= $Page->rejection->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->rejection->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rejection->formatPattern()) ?>"<?= $Page->rejection->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rejection->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->completed->Visible) { // completed ?>
    <div id="r_completed" class="row"<?= $Page->completed->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_completed"><?= $Page->completed->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_completed" id="z_completed" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->completed->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_completed" class="ew-search-field ew-search-field-single">
<template id="tp_x_completed">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="query_oms_2" data-field="x_completed" name="x_completed" id="x_completed"<?= $Page->completed->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_completed" class="ew-item-list"></div>
<selection-list hidden
    id="x_completed[]"
    name="x_completed[]"
    value="<?= HtmlEncode($Page->completed->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_completed"
    data-target="dsl_x_completed"
    data-repeatcolumn="5"
    class="form-control<?= $Page->completed->isInvalidClass() ?>"
    data-table="query_oms_2"
    data-field="x_completed"
    data-value-separator="<?= $Page->completed->displayValueSeparatorAttribute() ?>"
    <?= $Page->completed->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->completed->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works" class="row"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_weaving_works"><?= $Page->weaving_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_weaving_works" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weaving_works->getInputTextType() ?>" name="x_weaving_works" id="x_weaving_works" data-table="query_oms_2" data-field="x_weaving_works" value="<?= $Page->weaving_works->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weaving_works->formatPattern()) ?>"<?= $Page->weaving_works->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cs->Visible) { // cs ?>
    <div id="r_cs" class="row"<?= $Page->cs->rowAttributes() ?>>
        <label for="x_cs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_cs"><?= $Page->cs->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cs" id="z_cs" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_cs" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cs->getInputTextType() ?>" name="x_cs" id="x_cs" data-table="query_oms_2" data-field="x_cs" value="<?= $Page->cs->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cs->formatPattern()) ?>"<?= $Page->cs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cs->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weight_sqm->Visible) { // weight_sqm ?>
    <div id="r_weight_sqm" class="row"<?= $Page->weight_sqm->rowAttributes() ?>>
        <label for="x_weight_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_query_oms_2_weight_sqm"><?= $Page->weight_sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weight_sqm" id="z_weight_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weight_sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_query_oms_2_weight_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight_sqm->getInputTextType() ?>" name="x_weight_sqm" id="x_weight_sqm" data-table="query_oms_2" data-field="x_weight_sqm" value="<?= $Page->weight_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_sqm->formatPattern()) ?>"<?= $Page->weight_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight_sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fquery_oms_2search"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fquery_oms_2search"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fquery_oms_2search" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("query_oms_2");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
