<?php

namespace PHPMaker2024\fibre;

// Page object
$QcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fqcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fqcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["qc_stage", [], fields.qc_stage.isInvalid],
            ["_barcode", [ew.Validators.regex(/^([0-9])*$/)], fields._barcode.isInvalid],
            ["lines_in_30cm", [ew.Validators.float], fields.lines_in_30cm.isInvalid],
            ["size_actual", [], fields.size_actual.isInvalid],
            ["weight_actual", [ew.Validators.float], fields.weight_actual.isInvalid],
            ["defect_nature", [], fields.defect_nature.isInvalid],
            ["defect_percentage", [], fields.defect_percentage.isInvalid],
            ["deduction", [ew.Validators.integer], fields.deduction.isInvalid],
            ["y_deduction", [ew.Validators.between], false],
            ["comments", [], fields.comments.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["e_operator", [], fields.e_operator.isInvalid],
            ["e_datetime", [ew.Validators.datetime(fields.e_datetime.clientFormatPattern)], fields.e_datetime.isInvalid],
            ["y_e_datetime", [ew.Validators.between], false],
            ["_action", [ew.Validators.integer], fields._action.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["product_image", [], fields.product_image.isInvalid],
            ["design", [], fields.design.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["y_a_operator", [ew.Validators.between], false],
            ["a_datetime", [ew.Validators.datetime(fields.a_datetime.clientFormatPattern)], fields.a_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "qc_stage": <?= $Page->qc_stage->toClientList($Page) ?>,
            "defect_nature": <?= $Page->defect_nature->toClientList($Page) ?>,
            "defect_percentage": <?= $Page->defect_percentage->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "e_operator": <?= $Page->e_operator->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fqcsearch" id="fqcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="qc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="qc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_location"
        <?php } ?>
        data-table="qc"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_location", selectId: "fqcsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_stage->Visible) { // qc_stage ?>
    <div id="r_qc_stage" class="row"<?= $Page->qc_stage->rowAttributes() ?>>
        <label for="x_qc_stage" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_qc_stage"><?= $Page->qc_stage->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qc_stage" id="z_qc_stage" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_stage->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_qc_stage" class="ew-search-field ew-search-field-single">
    <select
        id="x_qc_stage"
        name="x_qc_stage"
        class="form-select ew-select<?= $Page->qc_stage->isInvalidClass() ?>"
        <?php if (!$Page->qc_stage->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_qc_stage"
        <?php } ?>
        data-table="qc"
        data-field="x_qc_stage"
        data-value-separator="<?= $Page->qc_stage->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->qc_stage->getPlaceHolder()) ?>"
        <?= $Page->qc_stage->editAttributes() ?>>
        <?= $Page->qc_stage->selectOptionListHtml("x_qc_stage") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->qc_stage->getErrorMessage(false) ?></div>
<?= $Page->qc_stage->Lookup->getParamTag($Page, "p_x_qc_stage") ?>
<?php if (!$Page->qc_stage->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_qc_stage", selectId: "fqcsearch_x_qc_stage" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.qc_stage?.lookupOptions.length) {
        options.data = { id: "x_qc_stage", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_qc_stage", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.qc_stage.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="qc" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lines_in_30cm->Visible) { // lines_in_30cm ?>
    <div id="r_lines_in_30cm" class="row"<?= $Page->lines_in_30cm->rowAttributes() ?>>
        <label for="x_lines_in_30cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_lines_in_30cm"><?= $Page->lines_in_30cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lines_in_30cm" id="z_lines_in_30cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lines_in_30cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_lines_in_30cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lines_in_30cm->getInputTextType() ?>" name="x_lines_in_30cm" id="x_lines_in_30cm" data-table="qc" data-field="x_lines_in_30cm" value="<?= $Page->lines_in_30cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->lines_in_30cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lines_in_30cm->formatPattern()) ?>"<?= $Page->lines_in_30cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lines_in_30cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_actual->Visible) { // size_actual ?>
    <div id="r_size_actual" class="row"<?= $Page->size_actual->rowAttributes() ?>>
        <label for="x_size_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_size_actual"><?= $Page->size_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_actual" id="z_size_actual" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_size_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_actual->getInputTextType() ?>" name="x_size_actual" id="x_size_actual" data-table="qc" data-field="x_size_actual" value="<?= $Page->size_actual->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_actual->formatPattern()) ?>"<?= $Page->size_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weight_actual->Visible) { // weight_actual ?>
    <div id="r_weight_actual" class="row"<?= $Page->weight_actual->rowAttributes() ?>>
        <label for="x_weight_actual" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_weight_actual"><?= $Page->weight_actual->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weight_actual" id="z_weight_actual" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weight_actual->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_weight_actual" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->weight_actual->getInputTextType() ?>" name="x_weight_actual" id="x_weight_actual" data-table="qc" data-field="x_weight_actual" value="<?= $Page->weight_actual->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_actual->formatPattern()) ?>"<?= $Page->weight_actual->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->weight_actual->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->defect_nature->Visible) { // defect_nature ?>
    <div id="r_defect_nature" class="row"<?= $Page->defect_nature->rowAttributes() ?>>
        <label for="x_defect_nature" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_defect_nature"><?= $Page->defect_nature->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_defect_nature" id="z_defect_nature" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->defect_nature->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_defect_nature" class="ew-search-field ew-search-field-single">
    <select
        id="x_defect_nature"
        name="x_defect_nature"
        class="form-select ew-select<?= $Page->defect_nature->isInvalidClass() ?>"
        <?php if (!$Page->defect_nature->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_defect_nature"
        <?php } ?>
        data-table="qc"
        data-field="x_defect_nature"
        data-value-separator="<?= $Page->defect_nature->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->defect_nature->getPlaceHolder()) ?>"
        <?= $Page->defect_nature->editAttributes() ?>>
        <?= $Page->defect_nature->selectOptionListHtml("x_defect_nature") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->defect_nature->getErrorMessage(false) ?></div>
<?= $Page->defect_nature->Lookup->getParamTag($Page, "p_x_defect_nature") ?>
<?php if (!$Page->defect_nature->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_defect_nature", selectId: "fqcsearch_x_defect_nature" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.defect_nature?.lookupOptions.length) {
        options.data = { id: "x_defect_nature", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_defect_nature", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.defect_nature.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->defect_percentage->Visible) { // defect_percentage ?>
    <div id="r_defect_percentage" class="row"<?= $Page->defect_percentage->rowAttributes() ?>>
        <label for="x_defect_percentage" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_defect_percentage"><?= $Page->defect_percentage->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_defect_percentage" id="z_defect_percentage" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->defect_percentage->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_defect_percentage" class="ew-search-field ew-search-field-single">
    <select
        id="x_defect_percentage"
        name="x_defect_percentage"
        class="form-select ew-select<?= $Page->defect_percentage->isInvalidClass() ?>"
        <?php if (!$Page->defect_percentage->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_defect_percentage"
        <?php } ?>
        data-table="qc"
        data-field="x_defect_percentage"
        data-value-separator="<?= $Page->defect_percentage->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->defect_percentage->getPlaceHolder()) ?>"
        <?= $Page->defect_percentage->editAttributes() ?>>
        <?= $Page->defect_percentage->selectOptionListHtml("x_defect_percentage") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->defect_percentage->getErrorMessage(false) ?></div>
<?= $Page->defect_percentage->Lookup->getParamTag($Page, "p_x_defect_percentage") ?>
<?php if (!$Page->defect_percentage->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_defect_percentage", selectId: "fqcsearch_x_defect_percentage" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.defect_percentage?.lookupOptions.length) {
        options.data = { id: "x_defect_percentage", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_defect_percentage", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.defect_percentage.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
    <div id="r_deduction" class="row"<?= $Page->deduction->rowAttributes() ?>>
        <label for="x_deduction" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_deduction"><?= $Page->deduction->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->deduction->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_deduction" id="z_deduction" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->deduction->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->deduction->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_deduction" class="ew-search-field">
<input type="<?= $Page->deduction->getInputTextType() ?>" name="x_deduction" id="x_deduction" data-table="qc" data-field="x_deduction" value="<?= $Page->deduction->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->deduction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deduction->formatPattern()) ?>"<?= $Page->deduction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->deduction->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_deduction" class="ew-search-field2 d-none">
<input type="<?= $Page->deduction->getInputTextType() ?>" name="y_deduction" id="y_deduction" data-table="qc" data-field="x_deduction" value="<?= $Page->deduction->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->deduction->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->deduction->formatPattern()) ?>"<?= $Page->deduction->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->deduction->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->comments->Visible) { // comments ?>
    <div id="r_comments" class="row"<?= $Page->comments->rowAttributes() ?>>
        <label for="x_comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_comments"><?= $Page->comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_comments" id="z_comments" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->comments->getInputTextType() ?>" name="x_comments" id="x_comments" data-table="qc" data-field="x_comments" value="<?= $Page->comments->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->comments->formatPattern()) ?>"<?= $Page->comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_status"
        <?php } ?>
        data-table="qc"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_status", selectId: "fqcsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_operator"
        <?php } ?>
        data-table="qc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_operator", selectId: "fqcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="qc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqcsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="qc" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqcsearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->e_operator->Visible) { // e_operator ?>
    <div id="r_e_operator" class="row"<?= $Page->e_operator->rowAttributes() ?>>
        <label for="x_e_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_e_operator"><?= $Page->e_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_e_operator" id="z_e_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->e_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_e_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_e_operator"
        name="x_e_operator"
        class="form-select ew-select<?= $Page->e_operator->isInvalidClass() ?>"
        <?php if (!$Page->e_operator->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_e_operator"
        <?php } ?>
        data-table="qc"
        data-field="x_e_operator"
        data-value-separator="<?= $Page->e_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->e_operator->getPlaceHolder()) ?>"
        <?= $Page->e_operator->editAttributes() ?>>
        <?= $Page->e_operator->selectOptionListHtml("x_e_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->e_operator->getErrorMessage(false) ?></div>
<?= $Page->e_operator->Lookup->getParamTag($Page, "p_x_e_operator") ?>
<?php if (!$Page->e_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_e_operator", selectId: "fqcsearch_x_e_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.e_operator?.lookupOptions.length) {
        options.data = { id: "x_e_operator", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_e_operator", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.e_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->e_datetime->Visible) { // e_datetime ?>
    <div id="r_e_datetime" class="row"<?= $Page->e_datetime->rowAttributes() ?>>
        <label for="x_e_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_e_datetime"><?= $Page->e_datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->e_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_e_datetime" id="z_e_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->e_datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->e_datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_e_datetime" class="ew-search-field">
<input type="<?= $Page->e_datetime->getInputTextType() ?>" name="x_e_datetime" id="x_e_datetime" data-table="qc" data-field="x_e_datetime" value="<?= $Page->e_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_datetime->formatPattern()) ?>"<?= $Page->e_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->e_datetime->ReadOnly && !$Page->e_datetime->Disabled && !isset($Page->e_datetime->EditAttrs["readonly"]) && !isset($Page->e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqcsearch", "x_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_e_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->e_datetime->getInputTextType() ?>" name="y_e_datetime" id="y_e_datetime" data-table="qc" data-field="x_e_datetime" value="<?= $Page->e_datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->e_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->e_datetime->formatPattern()) ?>"<?= $Page->e_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->e_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->e_datetime->ReadOnly && !$Page->e_datetime->Disabled && !isset($Page->e_datetime->EditAttrs["readonly"]) && !isset($Page->e_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqcsearch", "y_e_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_action->Visible) { // action ?>
    <div id="r__action" class="row"<?= $Page->_action->rowAttributes() ?>>
        <label for="x__action" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc__action"><?= $Page->_action->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__action" id="z__action" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_action->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc__action" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_action->getInputTextType() ?>" name="x__action" id="x__action" data-table="qc" data-field="x__action" value="<?= $Page->_action->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_action->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_action->formatPattern()) ?>"<?= $Page->_action->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_action->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="qc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_image->Visible) { // product_image ?>
    <div id="r_product_image" class="row"<?= $Page->product_image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_product_image"><?= $Page->product_image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_image" id="z_product_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_product_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_image->getInputTextType() ?>" name="x_product_image" id="x_product_image" data-table="qc" data-field="x_product_image" value="<?= $Page->product_image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->product_image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_image->formatPattern()) ?>"<?= $Page->product_image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="qc" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="qc" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_a_operator"><?= $Page->a_operator->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_a_operator" id="z_a_operator" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->a_operator->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->a_operator->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_a_operator" class="ew-search-field">
    <select
        id="x_a_operator"
        name="x_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_x_a_operator"
        <?php } ?>
        data-table="qc"
        data-field="x_a_operator"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("x_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "x_a_operator", selectId: "fqcsearch_x_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "x_a_operator", form: "fqcsearch" };
    } else {
        options.ajax = { id: "x_a_operator", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_a_operator" class="ew-search-field2 d-none">
    <select
        id="y_a_operator"
        name="y_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fqcsearch_y_a_operator"
        <?php } ?>
        data-table="qc"
        data-field="x_a_operator"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("y_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_y_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fqcsearch", function() {
    var options = { name: "y_a_operator", selectId: "fqcsearch_y_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqcsearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "y_a_operator", form: "fqcsearch" };
    } else {
        options.ajax = { id: "y_a_operator", form: "fqcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
    <div id="r_a_datetime" class="row"<?= $Page->a_datetime->rowAttributes() ?>>
        <label for="x_a_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_a_datetime"><?= $Page->a_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_datetime" id="z_a_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="qc" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->a_datetime->ReadOnly && !$Page->a_datetime->Disabled && !isset($Page->a_datetime->EditAttrs["readonly"]) && !isset($Page->a_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqcsearch", "x_a_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fqcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fqcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fqcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("qc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
