<?php

namespace PHPMaker2024\fibre;

// Page object
$QcOldEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fqc_oldedit" id="fqc_oldedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc_old: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fqc_oldedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fqc_oldedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["defect_nature", [fields.defect_nature.visible && fields.defect_nature.required ? ew.Validators.required(fields.defect_nature.caption) : null], fields.defect_nature.isInvalid],
            ["qc_stage", [fields.qc_stage.visible && fields.qc_stage.required ? ew.Validators.required(fields.qc_stage.caption) : null], fields.qc_stage.isInvalid],
            ["defect_percentage", [fields.defect_percentage.visible && fields.defect_percentage.required ? ew.Validators.required(fields.defect_percentage.caption) : null], fields.defect_percentage.isInvalid],
            ["deduction", [fields.deduction.visible && fields.deduction.required ? ew.Validators.required(fields.deduction.caption) : null], fields.deduction.isInvalid],
            ["comments", [fields.comments.visible && fields.comments.required ? ew.Validators.required(fields.comments.caption) : null], fields.comments.isInvalid],
            ["e_operator", [fields.e_operator.visible && fields.e_operator.required ? ew.Validators.required(fields.e_operator.caption) : null], fields.e_operator.isInvalid],
            ["e_datetime", [fields.e_datetime.visible && fields.e_datetime.required ? ew.Validators.required(fields.e_datetime.caption) : null], fields.e_datetime.isInvalid],
            ["lines_in_30cm", [fields.lines_in_30cm.visible && fields.lines_in_30cm.required ? ew.Validators.required(fields.lines_in_30cm.caption) : null, ew.Validators.float], fields.lines_in_30cm.isInvalid],
            ["size_actual", [fields.size_actual.visible && fields.size_actual.required ? ew.Validators.required(fields.size_actual.caption) : null], fields.size_actual.isInvalid],
            ["weight_actual", [fields.weight_actual.visible && fields.weight_actual.required ? ew.Validators.required(fields.weight_actual.caption) : null, ew.Validators.float], fields.weight_actual.isInvalid],
            ["bcode_status", [fields.bcode_status.visible && fields.bcode_status.required ? ew.Validators.required(fields.bcode_status.caption) : null, ew.Validators.integer], fields.bcode_status.isInvalid],
            ["product_image", [fields.product_image.visible && fields.product_image.required ? ew.Validators.fileRequired(fields.product_image.caption) : null], fields.product_image.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "defect_nature": <?= $Page->defect_nature->toClientList($Page) ?>,
            "qc_stage": <?= $Page->qc_stage->toClientList($Page) ?>,
            "defect_percentage": <?= $Page->defect_percentage->toClientList($Page) ?>,
            "e_operator": <?= $Page->e_operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="qc_old">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_qc_old_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_qc_old_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="qc_old" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_qc_old_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_qc_old_location">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fqc_oldedit_x_location"
        <?php } ?>
        data-table="qc_old"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_oldedit", function() {
    var options = { name: "x_location", selectId: "fqc_oldedit_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_oldedit.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fqc_oldedit" };
    } else {
        options.ajax = { id: "x_location", form: "fqc_oldedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_old.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_qc_old__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_qc_old__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->_barcode->getDisplayValue($Page->_barcode->EditValue))) ?>"></span>
<input type="hidden" data-table="qc_old" data-field="x__barcode" data-hidden="1" name="x__barcode" id="x__barcode" value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->defect_nature->Visible) { // defect_nature ?>
    <div id="r_defect_nature"<?= $Page->defect_nature->rowAttributes() ?>>
        <label id="elh_qc_old_defect_nature" for="x_defect_nature" class="<?= $Page->LeftColumnClass ?>"><?= $Page->defect_nature->caption() ?><?= $Page->defect_nature->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->defect_nature->cellAttributes() ?>>
<span id="el_qc_old_defect_nature">
    <select
        id="x_defect_nature"
        name="x_defect_nature"
        class="form-select ew-select<?= $Page->defect_nature->isInvalidClass() ?>"
        <?php if (!$Page->defect_nature->IsNativeSelect) { ?>
        data-select2-id="fqc_oldedit_x_defect_nature"
        <?php } ?>
        data-table="qc_old"
        data-field="x_defect_nature"
        data-value-separator="<?= $Page->defect_nature->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->defect_nature->getPlaceHolder()) ?>"
        <?= $Page->defect_nature->editAttributes() ?>>
        <?= $Page->defect_nature->selectOptionListHtml("x_defect_nature") ?>
    </select>
    <?= $Page->defect_nature->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->defect_nature->getErrorMessage() ?></div>
<?= $Page->defect_nature->Lookup->getParamTag($Page, "p_x_defect_nature") ?>
<?php if (!$Page->defect_nature->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_oldedit", function() {
    var options = { name: "x_defect_nature", selectId: "fqc_oldedit_x_defect_nature" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_oldedit.lists.defect_nature?.lookupOptions.length) {
        options.data = { id: "x_defect_nature", form: "fqc_oldedit" };
    } else {
        options.ajax = { id: "x_defect_nature", form: "fqc_oldedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_old.fields.defect_nature.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qc_stage->Visible) { // qc_stage ?>
    <div id="r_qc_stage"<?= $Page->qc_stage->rowAttributes() ?>>
        <label id="elh_qc_old_qc_stage" for="x_qc_stage" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qc_stage->caption() ?><?= $Page->qc_stage->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qc_stage->cellAttributes() ?>>
<span id="el_qc_old_qc_stage">
    <select
        id="x_qc_stage"
        name="x_qc_stage"
        class="form-select ew-select<?= $Page->qc_stage->isInvalidClass() ?>"
        <?php if (!$Page->qc_stage->IsNativeSelect) { ?>
        data-select2-id="fqc_oldedit_x_qc_stage"
        <?php } ?>
        data-table="qc_old"
        data-field="x_qc_stage"
        data-value-separator="<?= $Page->qc_stage->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->qc_stage->getPlaceHolder()) ?>"
        <?= $Page->qc_stage->editAttributes() ?>>
        <?= $Page->qc_stage->selectOptionListHtml("x_qc_stage") ?>
    </select>
    <?= $Page->qc_stage->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->qc_stage->getErrorMessage() ?></div>
<?= $Page->qc_stage->Lookup->getParamTag($Page, "p_x_qc_stage") ?>
<?php if (!$Page->qc_stage->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_oldedit", function() {
    var options = { name: "x_qc_stage", selectId: "fqc_oldedit_x_qc_stage" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_oldedit.lists.qc_stage?.lookupOptions.length) {
        options.data = { id: "x_qc_stage", form: "fqc_oldedit" };
    } else {
        options.ajax = { id: "x_qc_stage", form: "fqc_oldedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_old.fields.qc_stage.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->defect_percentage->Visible) { // defect_percentage ?>
    <div id="r_defect_percentage"<?= $Page->defect_percentage->rowAttributes() ?>>
        <label id="elh_qc_old_defect_percentage" for="x_defect_percentage" class="<?= $Page->LeftColumnClass ?>"><?= $Page->defect_percentage->caption() ?><?= $Page->defect_percentage->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->defect_percentage->cellAttributes() ?>>
<span id="el_qc_old_defect_percentage">
    <select
        id="x_defect_percentage"
        name="x_defect_percentage"
        class="form-select ew-select<?= $Page->defect_percentage->isInvalidClass() ?>"
        <?php if (!$Page->defect_percentage->IsNativeSelect) { ?>
        data-select2-id="fqc_oldedit_x_defect_percentage"
        <?php } ?>
        data-table="qc_old"
        data-field="x_defect_percentage"
        data-value-separator="<?= $Page->defect_percentage->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->defect_percentage->getPlaceHolder()) ?>"
        <?= $Page->defect_percentage->editAttributes() ?>>
        <?= $Page->defect_percentage->selectOptionListHtml("x_defect_percentage") ?>
    </select>
    <?= $Page->defect_percentage->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->defect_percentage->getErrorMessage() ?></div>
<?= $Page->defect_percentage->Lookup->getParamTag($Page, "p_x_defect_percentage") ?>
<?php if (!$Page->defect_percentage->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_oldedit", function() {
    var options = { name: "x_defect_percentage", selectId: "fqc_oldedit_x_defect_percentage" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_oldedit.lists.defect_percentage?.lookupOptions.length) {
        options.data = { id: "x_defect_percentage", form: "fqc_oldedit" };
    } else {
        options.ajax = { id: "x_defect_percentage", form: "fqc_oldedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_old.fields.defect_percentage.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
    <div id="r_deduction"<?= $Page->deduction->rowAttributes() ?>>
        <label id="elh_qc_old_deduction" for="x_deduction" class="<?= $Page->LeftColumnClass ?>"><?= $Page->deduction->caption() ?><?= $Page->deduction->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->deduction->cellAttributes() ?>>
<span id="el_qc_old_deduction">
<span<?= $Page->deduction->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->deduction->getDisplayValue($Page->deduction->EditValue))) ?>"></span>
<input type="hidden" data-table="qc_old" data-field="x_deduction" data-hidden="1" name="x_deduction" id="x_deduction" value="<?= HtmlEncode($Page->deduction->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->comments->Visible) { // comments ?>
    <div id="r_comments"<?= $Page->comments->rowAttributes() ?>>
        <label id="elh_qc_old_comments" for="x_comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->comments->caption() ?><?= $Page->comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->comments->cellAttributes() ?>>
<span id="el_qc_old_comments">
<input type="<?= $Page->comments->getInputTextType() ?>" name="x_comments" id="x_comments" data-table="qc_old" data-field="x_comments" value="<?= $Page->comments->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->comments->formatPattern()) ?>"<?= $Page->comments->editAttributes() ?> aria-describedby="x_comments_help">
<?= $Page->comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lines_in_30cm->Visible) { // lines_in_30cm ?>
    <div id="r_lines_in_30cm"<?= $Page->lines_in_30cm->rowAttributes() ?>>
        <label id="elh_qc_old_lines_in_30cm" for="x_lines_in_30cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lines_in_30cm->caption() ?><?= $Page->lines_in_30cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lines_in_30cm->cellAttributes() ?>>
<span id="el_qc_old_lines_in_30cm">
<input type="<?= $Page->lines_in_30cm->getInputTextType() ?>" name="x_lines_in_30cm" id="x_lines_in_30cm" data-table="qc_old" data-field="x_lines_in_30cm" value="<?= $Page->lines_in_30cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->lines_in_30cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lines_in_30cm->formatPattern()) ?>"<?= $Page->lines_in_30cm->editAttributes() ?> aria-describedby="x_lines_in_30cm_help">
<?= $Page->lines_in_30cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lines_in_30cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size_actual->Visible) { // size_actual ?>
    <div id="r_size_actual"<?= $Page->size_actual->rowAttributes() ?>>
        <label id="elh_qc_old_size_actual" for="x_size_actual" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size_actual->caption() ?><?= $Page->size_actual->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size_actual->cellAttributes() ?>>
<span id="el_qc_old_size_actual">
<input type="<?= $Page->size_actual->getInputTextType() ?>" name="x_size_actual" id="x_size_actual" data-table="qc_old" data-field="x_size_actual" value="<?= $Page->size_actual->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->size_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_actual->formatPattern()) ?>"<?= $Page->size_actual->editAttributes() ?> aria-describedby="x_size_actual_help">
<?= $Page->size_actual->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size_actual->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->weight_actual->Visible) { // weight_actual ?>
    <div id="r_weight_actual"<?= $Page->weight_actual->rowAttributes() ?>>
        <label id="elh_qc_old_weight_actual" for="x_weight_actual" class="<?= $Page->LeftColumnClass ?>"><?= $Page->weight_actual->caption() ?><?= $Page->weight_actual->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->weight_actual->cellAttributes() ?>>
<span id="el_qc_old_weight_actual">
<input type="<?= $Page->weight_actual->getInputTextType() ?>" name="x_weight_actual" id="x_weight_actual" data-table="qc_old" data-field="x_weight_actual" value="<?= $Page->weight_actual->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->weight_actual->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->weight_actual->formatPattern()) ?>"<?= $Page->weight_actual->editAttributes() ?> aria-describedby="x_weight_actual_help">
<?= $Page->weight_actual->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->weight_actual->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bcode_status->Visible) { // bcode_status ?>
    <div id="r_bcode_status"<?= $Page->bcode_status->rowAttributes() ?>>
        <label id="elh_qc_old_bcode_status" for="x_bcode_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bcode_status->caption() ?><?= $Page->bcode_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bcode_status->cellAttributes() ?>>
<span id="el_qc_old_bcode_status">
<input type="<?= $Page->bcode_status->getInputTextType() ?>" name="x_bcode_status" id="x_bcode_status" data-table="qc_old" data-field="x_bcode_status" value="<?= $Page->bcode_status->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bcode_status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bcode_status->formatPattern()) ?>"<?= $Page->bcode_status->editAttributes() ?> aria-describedby="x_bcode_status_help">
<?= $Page->bcode_status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bcode_status->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_image->Visible) { // product_image ?>
    <div id="r_product_image"<?= $Page->product_image->rowAttributes() ?>>
        <label id="elh_qc_old_product_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_image->caption() ?><?= $Page->product_image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_image->cellAttributes() ?>>
<span id="el_qc_old_product_image">
<div id="fd_x_product_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_product_image"
        name="x_product_image"
        class="form-control ew-file-input"
        title="<?= $Page->product_image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="qc_old"
        data-field="x_product_image"
        data-size="250"
        data-accept-file-types="<?= $Page->product_image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->product_image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->product_image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_product_image_help"
        <?= ($Page->product_image->ReadOnly || $Page->product_image->Disabled) ? " disabled" : "" ?>
        <?= $Page->product_image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->product_image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->product_image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_product_image" id= "fn_x_product_image" value="<?= $Page->product_image->Upload->FileName ?>">
<input type="hidden" name="fa_x_product_image" id= "fa_x_product_image" value="<?= (Post("fa_x_product_image") == "0") ? "0" : "1" ?>">
<table id="ft_x_product_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fqc_oldedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fqc_oldedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("qc_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
