<?php

namespace PHPMaker2024\fibre;

// Page object
$QcMissingSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc_missing: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fqc_missingsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fqc_missingsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["pending_days", [ew.Validators.integer], fields.pending_days.isInvalid],
            ["y_pending_days", [ew.Validators.between], false],
            ["design", [], fields.design.isInvalid],
            ["size_cm", [], fields.size_cm.isInvalid],
            ["pl_no", [ew.Validators.float], fields.pl_no.isInvalid],
            ["process_datetime", [ew.Validators.datetime(fields.process_datetime.clientFormatPattern)], fields.process_datetime.isInvalid],
            ["y_process_datetime", [ew.Validators.between], false],
            ["process", [], fields.process.isInvalid],
            ["process_c", [], fields.process_c.isInvalid],
            ["y_process_c", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process": <?= $Page->process->toClientList($Page) ?>,
            "process_c": <?= $Page->process_c->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fqc_missingsearch" id="fqc_missingsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="qc_missing">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_missing__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="qc_missing" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_missing__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="qc_missing" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending_days->Visible) { // pending_days ?>
    <div id="r_pending_days" class="row"<?= $Page->pending_days->rowAttributes() ?>>
        <label for="x_pending_days" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_pending_days"><?= $Page->pending_days->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending_days->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_pending_days" id="z_pending_days" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending_days->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending_days->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_missing_pending_days" class="ew-search-field">
<input type="<?= $Page->pending_days->getInputTextType() ?>" name="x_pending_days" id="x_pending_days" data-table="qc_missing" data-field="x_pending_days" value="<?= $Page->pending_days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_days->formatPattern()) ?>"<?= $Page->pending_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_days->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_missing_pending_days" class="ew-search-field2 d-none">
<input type="<?= $Page->pending_days->getInputTextType() ?>" name="y_pending_days" id="y_pending_days" data-table="qc_missing" data-field="x_pending_days" value="<?= $Page->pending_days->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_days->formatPattern()) ?>"<?= $Page->pending_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_days->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_missing_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="qc_missing" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
    <div id="r_size_cm" class="row"<?= $Page->size_cm->rowAttributes() ?>>
        <label for="x_size_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_size_cm"><?= $Page->size_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size_cm" id="z_size_cm" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_missing_size_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size_cm->getInputTextType() ?>" name="x_size_cm" id="x_size_cm" data-table="qc_missing" data-field="x_size_cm" value="<?= $Page->size_cm->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->size_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size_cm->formatPattern()) ?>"<?= $Page->size_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
    <div id="r_pl_no" class="row"<?= $Page->pl_no->rowAttributes() ?>>
        <label for="x_pl_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_pl_no"><?= $Page->pl_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pl_no" id="z_pl_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pl_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_missing_pl_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pl_no->getInputTextType() ?>" name="x_pl_no" id="x_pl_no" data-table="qc_missing" data-field="x_pl_no" value="<?= $Page->pl_no->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pl_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pl_no->formatPattern()) ?>"<?= $Page->pl_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pl_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_datetime->Visible) { // process_datetime ?>
    <div id="r_process_datetime" class="row"<?= $Page->process_datetime->rowAttributes() ?>>
        <label for="x_process_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_process_datetime"><?= $Page->process_datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_process_datetime" id="z_process_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->process_datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->process_datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_missing_process_datetime" class="ew-search-field">
<input type="<?= $Page->process_datetime->getInputTextType() ?>" name="x_process_datetime" id="x_process_datetime" data-table="qc_missing" data-field="x_process_datetime" value="<?= $Page->process_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->process_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_datetime->formatPattern()) ?>"<?= $Page->process_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->process_datetime->ReadOnly && !$Page->process_datetime->Disabled && !isset($Page->process_datetime->EditAttrs["readonly"]) && !isset($Page->process_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqc_missingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqc_missingsearch", "x_process_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_missing_process_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->process_datetime->getInputTextType() ?>" name="y_process_datetime" id="y_process_datetime" data-table="qc_missing" data-field="x_process_datetime" value="<?= $Page->process_datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->process_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->process_datetime->formatPattern()) ?>"<?= $Page->process_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->process_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->process_datetime->ReadOnly && !$Page->process_datetime->Disabled && !isset($Page->process_datetime->EditAttrs["readonly"]) && !isset($Page->process_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fqc_missingsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fqc_missingsearch", "y_process_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label for="x_process" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_qc_missing_process" class="ew-search-field ew-search-field-single">
    <select
        id="x_process"
        name="x_process"
        class="form-select ew-select<?= $Page->process->isInvalidClass() ?>"
        <?php if (!$Page->process->IsNativeSelect) { ?>
        data-select2-id="fqc_missingsearch_x_process"
        <?php } ?>
        data-table="qc_missing"
        data-field="x_process"
        data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process->getPlaceHolder()) ?>"
        <?= $Page->process->editAttributes() ?>>
        <?= $Page->process->selectOptionListHtml("x_process") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
<?php if (!$Page->process->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_missingsearch", function() {
    var options = { name: "x_process", selectId: "fqc_missingsearch_x_process" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_missingsearch.lists.process?.lookupOptions.length) {
        options.data = { id: "x_process", form: "fqc_missingsearch" };
    } else {
        options.ajax = { id: "x_process", form: "fqc_missingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_missing.fields.process.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
    <div id="r_process_c" class="row"<?= $Page->process_c->rowAttributes() ?>>
        <label for="x_process_c" class="<?= $Page->LeftColumnClass ?>"><span id="elh_qc_missing_process_c"><?= $Page->process_c->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process_c->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_process_c" id="z_process_c" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->process_c->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->process_c->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_qc_missing_process_c" class="ew-search-field">
    <select
        id="x_process_c[]"
        name="x_process_c[]"
        class="form-select ew-select<?= $Page->process_c->isInvalidClass() ?>"
        <?php if (!$Page->process_c->IsNativeSelect) { ?>
        data-select2-id="fqc_missingsearch_x_process_c[]"
        <?php } ?>
        data-table="qc_missing"
        data-field="x_process_c"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("x_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_x_process_c") ?>
<?php if (!$Page->process_c->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_missingsearch", function() {
    var options = { name: "x_process_c[]", selectId: "fqc_missingsearch_x_process_c[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_missingsearch.lists.process_c?.lookupOptions.length) {
        options.data = { id: "x_process_c[]", form: "fqc_missingsearch" };
    } else {
        options.ajax = { id: "x_process_c[]", form: "fqc_missingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_missing.fields.process_c.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_qc_missing_process_c" class="ew-search-field2 d-none">
    <select
        id="y_process_c[]"
        name="y_process_c[]"
        class="form-select ew-select<?= $Page->process_c->isInvalidClass() ?>"
        <?php if (!$Page->process_c->IsNativeSelect) { ?>
        data-select2-id="fqc_missingsearch_y_process_c[]"
        <?php } ?>
        data-table="qc_missing"
        data-field="x_process_c"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("y_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_y_process_c") ?>
<?php if (!$Page->process_c->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_missingsearch", function() {
    var options = { name: "y_process_c[]", selectId: "fqc_missingsearch_y_process_c[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_missingsearch.lists.process_c?.lookupOptions.length) {
        options.data = { id: "y_process_c[]", form: "fqc_missingsearch" };
    } else {
        options.ajax = { id: "y_process_c[]", form: "fqc_missingsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_missing.fields.process_c.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fqc_missingsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fqc_missingsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fqc_missingsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("qc_missing");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
