<?php

namespace PHPMaker2024\fibre;

// Page object
$QcMissingList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc_missing: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fqc_missingsrch" id="fqc_missingsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fqc_missingsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc_missing: currentTable } });
var currentForm;
var fqc_missingsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fqc_missingsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["pending_days", [ew.Validators.integer], fields.pending_days.isInvalid],
            ["y_pending_days", [ew.Validators.between], false],
            ["process_c", [], fields.process_c.isInvalid],
            ["y_process_c", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "process_c": <?= $Page->process_c->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_qc_missing__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="qc_missing" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_qc_missing__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="qc_missing" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->pending_days->Visible) { // pending_days ?>
<?php
if (!$Page->pending_days->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pending_days" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pending_days->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pending_days" class="ew-search-caption ew-label"><?= $Page->pending_days->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_pending_days" id="z_pending_days" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending_days->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending_days->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_qc_missing_pending_days" class="ew-search-field">
<input type="<?= $Page->pending_days->getInputTextType() ?>" name="x_pending_days" id="x_pending_days" data-table="qc_missing" data-field="x_pending_days" value="<?= $Page->pending_days->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_days->formatPattern()) ?>"<?= $Page->pending_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_days->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_qc_missing_pending_days" class="ew-search-field2 d-none">
<input type="<?= $Page->pending_days->getInputTextType() ?>" name="y_pending_days" id="y_pending_days" data-table="qc_missing" data-field="x_pending_days" value="<?= $Page->pending_days->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending_days->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending_days->formatPattern()) ?>"<?= $Page->pending_days->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending_days->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
<?php
if (!$Page->process_c->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_process_c" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->process_c->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_process_c" class="ew-search-caption ew-label"><?= $Page->process_c->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_process_c" id="z_process_c" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->process_c->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->process_c->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_qc_missing_process_c" class="ew-search-field">
    <select
        id="x_process_c[]"
        name="x_process_c[]"
        class="form-select ew-select<?= $Page->process_c->isInvalidClass() ?>"
        <?php if (!$Page->process_c->IsNativeSelect) { ?>
        data-select2-id="fqc_missingsrch_x_process_c[]"
        <?php } ?>
        data-table="qc_missing"
        data-field="x_process_c"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("x_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_x_process_c") ?>
<?php if (!$Page->process_c->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_missingsrch", function() {
    var options = { name: "x_process_c[]", selectId: "fqc_missingsrch_x_process_c[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_missingsrch.lists.process_c?.lookupOptions.length) {
        options.data = { id: "x_process_c[]", form: "fqc_missingsrch" };
    } else {
        options.ajax = { id: "x_process_c[]", form: "fqc_missingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_missing.fields.process_c.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_qc_missing_process_c" class="ew-search-field2 d-none">
    <select
        id="y_process_c[]"
        name="y_process_c[]"
        class="form-select ew-select<?= $Page->process_c->isInvalidClass() ?>"
        <?php if (!$Page->process_c->IsNativeSelect) { ?>
        data-select2-id="fqc_missingsrch_y_process_c[]"
        <?php } ?>
        data-table="qc_missing"
        data-field="x_process_c"
        multiple
        size="1"
        data-value-separator="<?= $Page->process_c->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->process_c->getPlaceHolder()) ?>"
        <?= $Page->process_c->editAttributes() ?>>
        <?= $Page->process_c->selectOptionListHtml("y_process_c[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->process_c->getErrorMessage(false) ?></div>
<?= $Page->process_c->Lookup->getParamTag($Page, "p_y_process_c") ?>
<?php if (!$Page->process_c->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_missingsrch", function() {
    var options = { name: "y_process_c[]", selectId: "fqc_missingsrch_y_process_c[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_missingsrch.lists.process_c?.lookupOptions.length) {
        options.data = { id: "y_process_c[]", form: "fqc_missingsrch" };
    } else {
        options.ajax = { id: "y_process_c[]", form: "fqc_missingsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_missing.fields.process_c.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fqc_missingsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fqc_missingsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fqc_missingsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fqc_missingsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fqc_missingsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fqc_missingsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fqc_missingsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="qc_missing">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_qc_missing" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_qc_missinglist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_qc_missing__barcode" class="qc_missing__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->pending_days->Visible) { // pending_days ?>
        <th data-name="pending_days" class="<?= $Page->pending_days->headerCellClass() ?>"><div id="elh_qc_missing_pending_days" class="qc_missing_pending_days"><?= $Page->renderFieldHeader($Page->pending_days) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>"><div id="elh_qc_missing_design" class="qc_missing_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->size_cm->Visible) { // size_cm ?>
        <th data-name="size_cm" class="<?= $Page->size_cm->headerCellClass() ?>"><div id="elh_qc_missing_size_cm" class="qc_missing_size_cm"><?= $Page->renderFieldHeader($Page->size_cm) ?></div></th>
<?php } ?>
<?php if ($Page->pl_no->Visible) { // pl_no ?>
        <th data-name="pl_no" class="<?= $Page->pl_no->headerCellClass() ?>"><div id="elh_qc_missing_pl_no" class="qc_missing_pl_no"><?= $Page->renderFieldHeader($Page->pl_no) ?></div></th>
<?php } ?>
<?php if ($Page->process_datetime->Visible) { // process_datetime ?>
        <th data-name="process_datetime" class="<?= $Page->process_datetime->headerCellClass() ?>"><div id="elh_qc_missing_process_datetime" class="qc_missing_process_datetime"><?= $Page->renderFieldHeader($Page->process_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_qc_missing_process" class="qc_missing_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->process_c->Visible) { // process_c ?>
        <th data-name="process_c" class="<?= $Page->process_c->headerCellClass() ?>"><div id="elh_qc_missing_process_c" class="qc_missing_process_c"><?= $Page->renderFieldHeader($Page->process_c) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing__barcode" class="el_qc_missing__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?php if (!EmptyString($Page->_barcode->getViewValue()) && $Page->_barcode->linkAttributes() != "") { ?>
<a<?= $Page->_barcode->linkAttributes() ?>><?= $Page->_barcode->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->_barcode->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending_days->Visible) { // pending_days ?>
        <td data-name="pending_days"<?= $Page->pending_days->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_pending_days" class="el_qc_missing_pending_days">
<span<?= $Page->pending_days->viewAttributes() ?>>
<?= $Page->pending_days->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_design" class="el_qc_missing_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm"<?= $Page->size_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_size_cm" class="el_qc_missing_size_cm">
<span<?= $Page->size_cm->viewAttributes() ?>>
<?= $Page->size_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no"<?= $Page->pl_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_pl_no" class="el_qc_missing_pl_no">
<span<?= $Page->pl_no->viewAttributes() ?>>
<?= $Page->pl_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_datetime->Visible) { // process_datetime ?>
        <td data-name="process_datetime"<?= $Page->process_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_process_datetime" class="el_qc_missing_process_datetime">
<span<?= $Page->process_datetime->viewAttributes() ?>>
<?= $Page->process_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_process" class="el_qc_missing_process">
<span<?= $Page->process->viewAttributes() ?>>
<?= $Page->process->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process_c->Visible) { // process_c ?>
        <td data-name="process_c"<?= $Page->process_c->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_missing_process_c" class="el_qc_missing_process_c">
<span<?= $Page->process_c->viewAttributes() ?>>
<?= $Page->process_c->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_qc_missing__barcode" class="qc_missing__barcode">
        <span class="ew-aggregate"><?= $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->_barcode->ViewValue) && $Page->_barcode->linkAttributes() != "") { ?>
        <a<?= $Page->_barcode->linkAttributes() ?>><?= $Page->_barcode->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->_barcode->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->pending_days->Visible) { // pending_days ?>
        <td data-name="pending_days" class="<?= $Page->pending_days->footerCellClass() ?>"><span id="elf_qc_missing_pending_days" class="qc_missing_pending_days">
        </span></td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design" class="<?= $Page->design->footerCellClass() ?>"><span id="elf_qc_missing_design" class="qc_missing_design">
        </span></td>
    <?php } ?>
    <?php if ($Page->size_cm->Visible) { // size_cm ?>
        <td data-name="size_cm" class="<?= $Page->size_cm->footerCellClass() ?>"><span id="elf_qc_missing_size_cm" class="qc_missing_size_cm">
        </span></td>
    <?php } ?>
    <?php if ($Page->pl_no->Visible) { // pl_no ?>
        <td data-name="pl_no" class="<?= $Page->pl_no->footerCellClass() ?>"><span id="elf_qc_missing_pl_no" class="qc_missing_pl_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_datetime->Visible) { // process_datetime ?>
        <td data-name="process_datetime" class="<?= $Page->process_datetime->footerCellClass() ?>"><span id="elf_qc_missing_process_datetime" class="qc_missing_process_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process" class="<?= $Page->process->footerCellClass() ?>"><span id="elf_qc_missing_process" class="qc_missing_process">
        </span></td>
    <?php } ?>
    <?php if ($Page->process_c->Visible) { // process_c ?>
        <td data-name="process_c" class="<?= $Page->process_c->footerCellClass() ?>"><span id="elf_qc_missing_process_c" class="qc_missing_process_c">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("qc_missing");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
