<?php

namespace PHPMaker2024\fibre;

// Page object
$QcAuthorisedList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc_authorised: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fqc_authorisedsrch" id="fqc_authorisedsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fqc_authorisedsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { qc_authorised: currentTable } });
var currentForm;
var fqc_authorisedsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fqc_authorisedsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["location", [], fields.location.isInvalid],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["defect_nature", [], fields.defect_nature.isInvalid],
            ["y_defect_nature", [ew.Validators.between], false],
            ["qc_stage", [], fields.qc_stage.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "defect_nature": <?= $Page->defect_nature->toClientList($Page) ?>,
            "qc_stage": <?= $Page->qc_stage->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->location->Visible) { // location ?>
<?php
if (!$Page->location->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_location" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->location->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_location" class="ew-search-caption ew-label"><?= $Page->location->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</div>
        </div>
        <div id="el_qc_authorised_location" class="ew-search-field">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fqc_authorisedsrch_x_location"
        <?php } ?>
        data-table="qc_authorised"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_authorisedsrch", function() {
    var options = { name: "x_location", selectId: "fqc_authorisedsrch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_authorisedsrch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fqc_authorisedsrch" };
    } else {
        options.ajax = { id: "x_location", form: "fqc_authorisedsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_authorised.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
<?php
if (!$Page->_barcode->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs__barcode" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->_barcode->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x__barcode" class="ew-search-caption ew-label"><?= $Page->_barcode->caption() ?></label>
            <div class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_qc_authorised__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="qc_authorised" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_qc_authorised__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="qc_authorised" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->defect_nature->Visible) { // defect_nature ?>
<?php
if (!$Page->defect_nature->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_defect_nature" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->defect_nature->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_defect_nature" class="ew-search-caption ew-label"><?= $Page->defect_nature->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_defect_nature" id="z_defect_nature" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->defect_nature->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->defect_nature->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_qc_authorised_defect_nature" class="ew-search-field">
    <select
        id="x_defect_nature"
        name="x_defect_nature"
        class="form-select ew-select<?= $Page->defect_nature->isInvalidClass() ?>"
        <?php if (!$Page->defect_nature->IsNativeSelect) { ?>
        data-select2-id="fqc_authorisedsrch_x_defect_nature"
        <?php } ?>
        data-table="qc_authorised"
        data-field="x_defect_nature"
        data-value-separator="<?= $Page->defect_nature->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->defect_nature->getPlaceHolder()) ?>"
        <?= $Page->defect_nature->editAttributes() ?>>
        <?= $Page->defect_nature->selectOptionListHtml("x_defect_nature") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->defect_nature->getErrorMessage(false) ?></div>
<?= $Page->defect_nature->Lookup->getParamTag($Page, "p_x_defect_nature") ?>
<?php if (!$Page->defect_nature->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_authorisedsrch", function() {
    var options = { name: "x_defect_nature", selectId: "fqc_authorisedsrch_x_defect_nature" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_authorisedsrch.lists.defect_nature?.lookupOptions.length) {
        options.data = { id: "x_defect_nature", form: "fqc_authorisedsrch" };
    } else {
        options.ajax = { id: "x_defect_nature", form: "fqc_authorisedsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_authorised.fields.defect_nature.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_qc_authorised_defect_nature" class="ew-search-field2 d-none">
    <select
        id="y_defect_nature"
        name="y_defect_nature"
        class="form-select ew-select<?= $Page->defect_nature->isInvalidClass() ?>"
        <?php if (!$Page->defect_nature->IsNativeSelect) { ?>
        data-select2-id="fqc_authorisedsrch_y_defect_nature"
        <?php } ?>
        data-table="qc_authorised"
        data-field="x_defect_nature"
        data-value-separator="<?= $Page->defect_nature->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->defect_nature->getPlaceHolder()) ?>"
        <?= $Page->defect_nature->editAttributes() ?>>
        <?= $Page->defect_nature->selectOptionListHtml("y_defect_nature") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->defect_nature->getErrorMessage(false) ?></div>
<?= $Page->defect_nature->Lookup->getParamTag($Page, "p_y_defect_nature") ?>
<?php if (!$Page->defect_nature->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_authorisedsrch", function() {
    var options = { name: "y_defect_nature", selectId: "fqc_authorisedsrch_y_defect_nature" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_authorisedsrch.lists.defect_nature?.lookupOptions.length) {
        options.data = { id: "y_defect_nature", form: "fqc_authorisedsrch" };
    } else {
        options.ajax = { id: "y_defect_nature", form: "fqc_authorisedsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_authorised.fields.defect_nature.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->qc_stage->Visible) { // qc_stage ?>
<?php
if (!$Page->qc_stage->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_qc_stage" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->qc_stage->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_qc_stage" class="ew-search-caption ew-label"><?= $Page->qc_stage->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qc_stage" id="z_qc_stage" value="=">
</div>
        </div>
        <div id="el_qc_authorised_qc_stage" class="ew-search-field">
    <select
        id="x_qc_stage"
        name="x_qc_stage"
        class="form-select ew-select<?= $Page->qc_stage->isInvalidClass() ?>"
        <?php if (!$Page->qc_stage->IsNativeSelect) { ?>
        data-select2-id="fqc_authorisedsrch_x_qc_stage"
        <?php } ?>
        data-table="qc_authorised"
        data-field="x_qc_stage"
        data-value-separator="<?= $Page->qc_stage->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->qc_stage->getPlaceHolder()) ?>"
        <?= $Page->qc_stage->editAttributes() ?>>
        <?= $Page->qc_stage->selectOptionListHtml("x_qc_stage") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->qc_stage->getErrorMessage(false) ?></div>
<?= $Page->qc_stage->Lookup->getParamTag($Page, "p_x_qc_stage") ?>
<?php if (!$Page->qc_stage->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_authorisedsrch", function() {
    var options = { name: "x_qc_stage", selectId: "fqc_authorisedsrch_x_qc_stage" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_authorisedsrch.lists.qc_stage?.lookupOptions.length) {
        options.data = { id: "x_qc_stage", form: "fqc_authorisedsrch" };
    } else {
        options.ajax = { id: "x_qc_stage", form: "fqc_authorisedsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_authorised.fields.qc_stage.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_qc_authorised_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fqc_authorisedsrch_x_status"
        <?php } ?>
        data-table="qc_authorised"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fqc_authorisedsrch", function() {
    var options = { name: "x_status", selectId: "fqc_authorisedsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fqc_authorisedsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fqc_authorisedsrch" };
    } else {
        options.ajax = { id: "x_status", form: "fqc_authorisedsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.qc_authorised.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fqc_authorisedsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fqc_authorisedsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fqc_authorisedsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fqc_authorisedsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fqc_authorisedsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fqc_authorisedsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fqc_authorisedsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="qc_authorised">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_qc_authorised" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_qc_authorisedlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_qc_authorised_id" class="qc_authorised_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_qc_authorised_location" class="qc_authorised_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_qc_authorised__barcode" class="qc_authorised__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->defect_nature->Visible) { // defect_nature ?>
        <th data-name="defect_nature" class="<?= $Page->defect_nature->headerCellClass() ?>"><div id="elh_qc_authorised_defect_nature" class="qc_authorised_defect_nature"><?= $Page->renderFieldHeader($Page->defect_nature) ?></div></th>
<?php } ?>
<?php if ($Page->qc_stage->Visible) { // qc_stage ?>
        <th data-name="qc_stage" class="<?= $Page->qc_stage->headerCellClass() ?>"><div id="elh_qc_authorised_qc_stage" class="qc_authorised_qc_stage"><?= $Page->renderFieldHeader($Page->qc_stage) ?></div></th>
<?php } ?>
<?php if ($Page->defect_percentage->Visible) { // defect_percentage ?>
        <th data-name="defect_percentage" class="<?= $Page->defect_percentage->headerCellClass() ?>"><div id="elh_qc_authorised_defect_percentage" class="qc_authorised_defect_percentage"><?= $Page->renderFieldHeader($Page->defect_percentage) ?></div></th>
<?php } ?>
<?php if ($Page->deduction->Visible) { // deduction ?>
        <th data-name="deduction" class="<?= $Page->deduction->headerCellClass() ?>"><div id="elh_qc_authorised_deduction" class="qc_authorised_deduction"><?= $Page->renderFieldHeader($Page->deduction) ?></div></th>
<?php } ?>
<?php if ($Page->comments->Visible) { // comments ?>
        <th data-name="comments" class="<?= $Page->comments->headerCellClass() ?>"><div id="elh_qc_authorised_comments" class="qc_authorised_comments"><?= $Page->renderFieldHeader($Page->comments) ?></div></th>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
        <th data-name="design" class="<?= $Page->design->headerCellClass() ?>"><div id="elh_qc_authorised_design" class="qc_authorised_design"><?= $Page->renderFieldHeader($Page->design) ?></div></th>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
        <th data-name="size" class="<?= $Page->size->headerCellClass() ?>"><div id="elh_qc_authorised_size" class="qc_authorised_size"><?= $Page->renderFieldHeader($Page->size) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_qc_authorised_status" class="qc_authorised_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->_action->Visible) { // action ?>
        <th data-name="_action" class="<?= $Page->_action->headerCellClass() ?>"><div id="elh_qc_authorised__action" class="qc_authorised__action"><?= $Page->renderFieldHeader($Page->_action) ?></div></th>
<?php } ?>
<?php if ($Page->bcode_status->Visible) { // bcode_status ?>
        <th data-name="bcode_status" class="<?= $Page->bcode_status->headerCellClass() ?>"><div id="elh_qc_authorised_bcode_status" class="qc_authorised_bcode_status"><?= $Page->renderFieldHeader($Page->bcode_status) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_qc_authorised_remarks" class="qc_authorised_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_qc_authorised_operator" class="qc_authorised_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_qc_authorised_datetime" class="qc_authorised_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
        <th data-name="a_operator" class="<?= $Page->a_operator->headerCellClass() ?>"><div id="elh_qc_authorised_a_operator" class="qc_authorised_a_operator"><?= $Page->renderFieldHeader($Page->a_operator) ?></div></th>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <th data-name="a_datetime" class="<?= $Page->a_datetime->headerCellClass() ?>"><div id="elh_qc_authorised_a_datetime" class="qc_authorised_a_datetime"><?= $Page->renderFieldHeader($Page->a_datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_id" class="el_qc_authorised_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_location" class="el_qc_authorised_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised__barcode" class="el_qc_authorised__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->defect_nature->Visible) { // defect_nature ?>
        <td data-name="defect_nature"<?= $Page->defect_nature->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_defect_nature" class="el_qc_authorised_defect_nature">
<span<?= $Page->defect_nature->viewAttributes() ?>>
<?= $Page->defect_nature->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qc_stage->Visible) { // qc_stage ?>
        <td data-name="qc_stage"<?= $Page->qc_stage->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_qc_stage" class="el_qc_authorised_qc_stage">
<span<?= $Page->qc_stage->viewAttributes() ?>>
<?= $Page->qc_stage->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->defect_percentage->Visible) { // defect_percentage ?>
        <td data-name="defect_percentage"<?= $Page->defect_percentage->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_defect_percentage" class="el_qc_authorised_defect_percentage">
<span<?= $Page->defect_percentage->viewAttributes() ?>>
<?= $Page->defect_percentage->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->deduction->Visible) { // deduction ?>
        <td data-name="deduction"<?= $Page->deduction->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_deduction" class="el_qc_authorised_deduction">
<span<?= $Page->deduction->viewAttributes() ?>>
<?= $Page->deduction->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->comments->Visible) { // comments ?>
        <td data-name="comments"<?= $Page->comments->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_comments" class="el_qc_authorised_comments">
<span<?= $Page->comments->viewAttributes() ?>>
<?= $Page->comments->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->design->Visible) { // design ?>
        <td data-name="design"<?= $Page->design->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_design" class="el_qc_authorised_design">
<span<?= $Page->design->viewAttributes() ?>>
<?= $Page->design->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->size->Visible) { // size ?>
        <td data-name="size"<?= $Page->size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_size" class="el_qc_authorised_size">
<span<?= $Page->size->viewAttributes() ?>>
<?= $Page->size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_status" class="el_qc_authorised_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_action->Visible) { // action ?>
        <td data-name="_action"<?= $Page->_action->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised__action" class="el_qc_authorised__action">
<span<?= $Page->_action->viewAttributes() ?>>
<?= $Page->_action->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bcode_status->Visible) { // bcode_status ?>
        <td data-name="bcode_status"<?= $Page->bcode_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_bcode_status" class="el_qc_authorised_bcode_status">
<span<?= $Page->bcode_status->viewAttributes() ?>>
<?= $Page->bcode_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_remarks" class="el_qc_authorised_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_operator" class="el_qc_authorised_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_datetime" class="el_qc_authorised_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_operator->Visible) { // a_operator ?>
        <td data-name="a_operator"<?= $Page->a_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_a_operator" class="el_qc_authorised_a_operator">
<span<?= $Page->a_operator->viewAttributes() ?>>
<?= $Page->a_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <td data-name="a_datetime"<?= $Page->a_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_qc_authorised_a_datetime" class="el_qc_authorised_a_datetime">
<span<?= $Page->a_datetime->viewAttributes() ?>>
<?= $Page->a_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("qc_authorised");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
