<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("PurchaseRefGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fpurchase_refgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { purchase_ref: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpurchase_refgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.float], fields.packets.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["_40", [fields._40.visible && fields._40.required ? ew.Validators.required(fields._40.caption) : null, ew.Validators.float], fields._40.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["grp",false],["s_grp",false],["product",false],["rid",false],["packets",false],["quantity",false],["_40",false],["amount",false],["godown",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "s_grp": <?= $Grid->s_grp->toClientList($Grid) ?>,
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "rid": <?= $Grid->rid->toClientList($Grid) ?>,
            "godown": <?= $Grid->godown->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fpurchase_refgrid" class="ew-form ew-list-form">
<div id="gmp_purchase_ref" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_purchase_refgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_purchase_ref_grp" class="purchase_ref_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Grid->s_grp->headerCellClass() ?>"><div id="elh_purchase_ref_s_grp" class="purchase_ref_s_grp"><?= $Grid->renderFieldHeader($Grid->s_grp) ?></div></th>
<?php } ?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_purchase_ref_product" class="purchase_ref_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Grid->rid->headerCellClass() ?>"><div id="elh_purchase_ref_rid" class="purchase_ref_rid"><?= $Grid->renderFieldHeader($Grid->rid) ?></div></th>
<?php } ?>
<?php if ($Grid->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Grid->packets->headerCellClass() ?>"><div id="elh_purchase_ref_packets" class="purchase_ref_packets"><?= $Grid->renderFieldHeader($Grid->packets) ?></div></th>
<?php } ?>
<?php if ($Grid->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Grid->quantity->headerCellClass() ?>"><div id="elh_purchase_ref_quantity" class="purchase_ref_quantity"><?= $Grid->renderFieldHeader($Grid->quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->_40->Visible) { // @ ?>
        <th data-name="_40" class="<?= $Grid->_40->headerCellClass() ?>"><div id="elh_purchase_ref__40" class="purchase_ref__40"><?= $Grid->renderFieldHeader($Grid->_40) ?></div></th>
<?php } ?>
<?php if ($Grid->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Grid->amount->headerCellClass() ?>"><div id="elh_purchase_ref_amount" class="purchase_ref_amount"><?= $Grid->renderFieldHeader($Grid->amount) ?></div></th>
<?php } ?>
<?php if ($Grid->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Grid->godown->headerCellClass() ?>"><div id="elh_purchase_ref_godown" class="purchase_ref_godown"><?= $Grid->renderFieldHeader($Grid->godown) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_grp" class="el_purchase_ref_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_grp" class="el_purchase_ref_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_grp" class="el_purchase_ref_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->getViewValue()) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><?= $Grid->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_grp" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_grp" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_grp" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_grp" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Grid->s_grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_s_grp" class="el_purchase_ref_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_grp" id="o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_s_grp" class="el_purchase_ref_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_s_grp" class="el_purchase_ref_s_grp">
<span<?= $Grid->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->s_grp->getViewValue()) && $Grid->s_grp->linkAttributes() != "") { ?>
<a<?= $Grid->s_grp->linkAttributes() ?>><?= $Grid->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_s_grp" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_s_grp" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_s_grp" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_s_grp" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_product" class="el_purchase_ref_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_product" class="el_purchase_ref_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_product" class="el_purchase_ref_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_product" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_product" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_product" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_product" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Grid->rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->rid->getDisplayValue($Grid->rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_rid" class="el_purchase_ref_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-select ew-select<?= $Grid->rid->isInvalidClass() ?>"
        <?php if (!$Grid->rid->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_rid"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_rid"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<?php if (!$Grid->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="purchase_ref" data-field="x_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rid" id="o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->rid->getDisplayValue($Grid->rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_rid" class="el_purchase_ref_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-select ew-select<?= $Grid->rid->isInvalidClass() ?>"
        <?php if (!$Grid->rid->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_rid"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_rid"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<?php if (!$Grid->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_rid" class="el_purchase_ref_rid">
<span<?= $Grid->rid->viewAttributes() ?>>
<?= $Grid->rid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_rid" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_rid" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_rid" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_rid" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Grid->packets->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_packets" class="el_purchase_ref_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="purchase_ref" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_packets" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packets" id="o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_packets" class="el_purchase_ref_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="purchase_ref" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_packets" class="el_purchase_ref_packets">
<span<?= $Grid->packets->viewAttributes() ?>>
<?= $Grid->packets->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_packets" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_packets" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_packets" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_packets" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Grid->quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_quantity" class="el_purchase_ref_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="purchase_ref" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_quantity" id="o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_quantity" class="el_purchase_ref_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="purchase_ref" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_quantity" class="el_purchase_ref_quantity">
<span<?= $Grid->quantity->viewAttributes() ?>>
<?= $Grid->quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_quantity" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_quantity" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_quantity" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_quantity" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_40->Visible) { // @ ?>
        <td data-name="_40"<?= $Grid->_40->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref__40" class="el_purchase_ref__40">
<input type="<?= $Grid->_40->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__40" id="x<?= $Grid->RowIndex ?>__40" data-table="purchase_ref" data-field="x__40" value="<?= $Grid->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_40->formatPattern()) ?>"<?= $Grid->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_40->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x__40" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__40" id="o<?= $Grid->RowIndex ?>__40" value="<?= HtmlEncode($Grid->_40->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref__40" class="el_purchase_ref__40">
<input type="<?= $Grid->_40->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__40" id="x<?= $Grid->RowIndex ?>__40" data-table="purchase_ref" data-field="x__40" value="<?= $Grid->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_40->formatPattern()) ?>"<?= $Grid->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_40->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref__40" class="el_purchase_ref__40">
<span<?= $Grid->_40->viewAttributes() ?>>
<?= $Grid->_40->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x__40" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>__40" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>__40" value="<?= HtmlEncode($Grid->_40->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x__40" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>__40" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>__40" value="<?= HtmlEncode($Grid->_40->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Grid->amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_amount" class="el_purchase_ref_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="purchase_ref" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_amount" id="o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_amount" class="el_purchase_ref_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="purchase_ref" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_amount" class="el_purchase_ref_amount">
<span<?= $Grid->amount->viewAttributes() ?>>
<?= $Grid->amount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_amount" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_amount" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_amount" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_amount" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Grid->godown->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_godown" class="el_purchase_ref_godown">
    <select
        id="x<?= $Grid->RowIndex ?>_godown"
        name="x<?= $Grid->RowIndex ?>_godown"
        class="form-select ew-select<?= $Grid->godown->isInvalidClass() ?>"
        <?php if (!$Grid->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_godown"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_godown"
        data-value-separator="<?= $Grid->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->godown->getPlaceHolder()) ?>"
        <?= $Grid->godown->editAttributes() ?>>
        <?= $Grid->godown->selectOptionListHtml("x{$Grid->RowIndex}_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->godown->getErrorMessage() ?></div>
<?= $Grid->godown->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_godown") ?>
<?php if (!$Grid->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_godown", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.godown?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_ref" data-field="x_godown" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_godown" id="o<?= $Grid->RowIndex ?>_godown" value="<?= HtmlEncode($Grid->godown->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_godown" class="el_purchase_ref_godown">
    <select
        id="x<?= $Grid->RowIndex ?>_godown"
        name="x<?= $Grid->RowIndex ?>_godown"
        class="form-select ew-select<?= $Grid->godown->isInvalidClass() ?>"
        <?php if (!$Grid->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_refgrid_x<?= $Grid->RowIndex ?>_godown"
        <?php } ?>
        data-table="purchase_ref"
        data-field="x_godown"
        data-value-separator="<?= $Grid->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->godown->getPlaceHolder()) ?>"
        <?= $Grid->godown->editAttributes() ?>>
        <?= $Grid->godown->selectOptionListHtml("x{$Grid->RowIndex}_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->godown->getErrorMessage() ?></div>
<?= $Grid->godown->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_godown") ?>
<?php if (!$Grid->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_refgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_godown", selectId: "fpurchase_refgrid_x<?= $Grid->RowIndex ?>_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_refgrid.lists.godown?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fpurchase_refgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fpurchase_refgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_ref.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_purchase_ref_godown" class="el_purchase_ref_godown">
<span<?= $Grid->godown->viewAttributes() ?>>
<?php if (!EmptyString($Grid->godown->getViewValue()) && $Grid->godown->linkAttributes() != "") { ?>
<a<?= $Grid->godown->linkAttributes() ?>><?= $Grid->godown->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="purchase_ref" data-field="x_godown" data-hidden="1" name="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_godown" id="fpurchase_refgrid$x<?= $Grid->RowIndex ?>_godown" value="<?= HtmlEncode($Grid->godown->FormValue) ?>">
<input type="hidden" data-table="purchase_ref" data-field="x_godown" data-hidden="1" data-old name="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_godown" id="fpurchase_refgrid$o<?= $Grid->RowIndex ?>_godown" value="<?= HtmlEncode($Grid->godown->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fpurchase_refgrid","load"], () => fpurchase_refgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fpurchase_refgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_ref");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
