<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseLQcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l_qc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpurchase_l_qcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_l_qcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["net_weight", [ew.Validators.float], fields.net_weight.isInvalid],
            ["y_net_weight", [ew.Validators.between], false],
            ["qc_status", [], fields.qc_status.isInvalid],
            ["qc_remarks", [], fields.qc_remarks.isInvalid],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["y_packets", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["rack", [], fields.rack.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["goods_inward", [], fields.goods_inward.isInvalid],
            ["invoice_details", [], fields.invoice_details.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["remarks", [], fields.remarks.isInvalid],
            ["audit", [ew.Validators.integer], fields.audit.isInvalid],
            ["a_operator", [ew.Validators.integer], fields.a_operator.isInvalid],
            ["a_datetime", [ew.Validators.integer], fields.a_datetime.isInvalid],
            ["qc_operator", [ew.Validators.integer], fields.qc_operator.isInvalid],
            ["qc_datetime", [ew.Validators.datetime(fields.qc_datetime.clientFormatPattern)], fields.qc_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "po": <?= $Page->po->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "lot_no": <?= $Page->lot_no->toClientList($Page) ?>,
            "qc_status": <?= $Page->qc_status->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpurchase_l_qcsearch" id="fpurchase_l_qcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_l_qc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="purchase_l_qc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_type"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_type", selectId: "fpurchase_l_qcsearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_type", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_po"><?= $Page->po->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po" id="z_po" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_po" class="ew-search-field">
    <select
        id="x_po"
        name="x_po"
        class="form-control ew-select<?= $Page->po->isInvalidClass() ?>"
        data-select2-id="fpurchase_l_qcsearch_x_po"
        data-table="purchase_l_qc"
        data-field="x_po"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->po->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
        <?= $Page->po->editAttributes() ?>>
        <?= $Page->po->selectOptionListHtml("x_po") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_po", selectId: "fpurchase_l_qcsearch_x_po" };
    if (fpurchase_l_qcsearch.lists.po?.lookupOptions.length) {
        options.data = { id: "x_po", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_po", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l_qc.fields.po.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_po_1" name="v_po" value="AND"<?= ($Page->po->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_po_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_po_2" name="v_po" value="OR"<?= ($Page->po->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_po_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_po" id="w_po" value="=">
</span>
                    <span id="el2_purchase_l_qc_po" class="ew-search-field2">
    <select
        id="y_po"
        name="y_po"
        class="form-control ew-select<?= $Page->po->isInvalidClass() ?>"
        data-select2-id="fpurchase_l_qcsearch_y_po"
        data-table="purchase_l_qc"
        data-field="x_po"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->po->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
        <?= $Page->po->editAttributes() ?>>
        <?= $Page->po->selectOptionListHtml("y_po") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<?= $Page->po->Lookup->getParamTag($Page, "p_y_po") ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "y_po", selectId: "fpurchase_l_qcsearch_y_po" };
    if (fpurchase_l_qcsearch.lists.po?.lookupOptions.length) {
        options.data = { id: "y_po", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "y_po", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l_qc.fields.po.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_qc" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    fpurchase_l_qcsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_qc.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_lot_no" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->lot_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_lot_no" class="ew-auto-suggest">
    <input type="<?= $Page->lot_no->getInputTextType() ?>" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?= RemoveHtml($Page->lot_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_qc" data-field="x_lot_no" data-input="sv_x_lot_no" data-value-separator="<?= $Page->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?= HtmlEncode($Page->lot_no->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    fpurchase_l_qcsearch.createAutoSuggest(Object.assign({"id":"x_lot_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->lot_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_qc.fields.lot_no.autoSuggestOptions));
});
</script>
<?= $Page->lot_no->Lookup->getParamTag($Page, "p_x_lot_no") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight" class="row"<?= $Page->net_weight->rowAttributes() ?>>
        <label for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_net_weight"><?= $Page->net_weight->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->net_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_net_weight" id="z_net_weight" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->net_weight->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->net_weight->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_qc_net_weight" class="ew-search-field">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_l_qc" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_qc_net_weight" class="ew-search-field2 d-none">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="y_net_weight" id="y_net_weight" data-table="purchase_l_qc" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_status->Visible) { // qc_status ?>
    <div id="r_qc_status" class="row"<?= $Page->qc_status->rowAttributes() ?>>
        <label for="x_qc_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_qc_status"><?= $Page->qc_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qc_status" id="z_qc_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_qc_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_qc_status"
        name="x_qc_status"
        class="form-select ew-select<?= $Page->qc_status->isInvalidClass() ?>"
        <?php if (!$Page->qc_status->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_qc_status"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_qc_status"
        data-value-separator="<?= $Page->qc_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->qc_status->getPlaceHolder()) ?>"
        <?= $Page->qc_status->editAttributes() ?>>
        <?= $Page->qc_status->selectOptionListHtml("x_qc_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->qc_status->getErrorMessage(false) ?></div>
<?= $Page->qc_status->Lookup->getParamTag($Page, "p_x_qc_status") ?>
<?php if (!$Page->qc_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_qc_status", selectId: "fpurchase_l_qcsearch_x_qc_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.qc_status?.lookupOptions.length) {
        options.data = { id: "x_qc_status", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_qc_status", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.qc_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_remarks->Visible) { // qc_remarks ?>
    <div id="r_qc_remarks" class="row"<?= $Page->qc_remarks->rowAttributes() ?>>
        <label for="x_qc_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_qc_remarks"><?= $Page->qc_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_qc_remarks" id="z_qc_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_qc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_remarks->getInputTextType() ?>" name="x_qc_remarks" id="x_qc_remarks" data-table="purchase_l_qc" data-field="x_qc_remarks" value="<?= $Page->qc_remarks->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->qc_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_remarks->formatPattern()) ?>"<?= $Page->qc_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_packets"><?= $Page->packets->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_packets" id="z_packets" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->packets->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->packets->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_qc_packets" class="ew-search-field">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_l_qc" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_qc_packets" class="ew-search-field2 d-none">
<input type="<?= $Page->packets->getInputTextType() ?>" name="y_packets" id="y_packets" data-table="purchase_l_qc" data-field="x_packets" value="<?= $Page->packets->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_packing_type"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_l_qcsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="purchase_l_qc" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="purchase_l_qc" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_godown"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_godown", selectId: "fpurchase_l_qcsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
    <div id="r_rack" class="row"<?= $Page->rack->rowAttributes() ?>>
        <label for="x_rack" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_rack"><?= $Page->rack->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rack" id="z_rack" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rack->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_rack" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_l_qc" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_qc_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="purchase_l_qc" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_qcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_qcsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_qc_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="purchase_l_qc" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_qcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_qcsearch", "y_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->goods_inward->Visible) { // goods_inward ?>
    <div id="r_goods_inward" class="row"<?= $Page->goods_inward->rowAttributes() ?>>
        <label for="x_goods_inward" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_goods_inward"><?= $Page->goods_inward->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_goods_inward" id="z_goods_inward" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->goods_inward->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_goods_inward" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->goods_inward->getInputTextType() ?>" name="x_goods_inward" id="x_goods_inward" data-table="purchase_l_qc" data-field="x_goods_inward" value="<?= $Page->goods_inward->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->goods_inward->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->goods_inward->formatPattern()) ?>"<?= $Page->goods_inward->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->goods_inward->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
    <div id="r_invoice_details" class="row"<?= $Page->invoice_details->rowAttributes() ?>>
        <label for="x_invoice_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_invoice_details"><?= $Page->invoice_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_invoice_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_l_qc" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_operator"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_operator", selectId: "fpurchase_l_qcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_qc_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="purchase_l_qc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_qc_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="purchase_l_qc" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="purchase_l_qc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->audit->Visible) { // audit ?>
    <div id="r_audit" class="row"<?= $Page->audit->rowAttributes() ?>>
        <label for="x_audit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_audit"><?= $Page->audit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_audit" id="z_audit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->audit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_audit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->audit->getInputTextType() ?>" name="x_audit" id="x_audit" data-table="purchase_l_qc" data-field="x_audit" value="<?= $Page->audit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->audit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->audit->formatPattern()) ?>"<?= $Page->audit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->audit->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_a_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_operator->getInputTextType() ?>" name="x_a_operator" id="x_a_operator" data-table="purchase_l_qc" data-field="x_a_operator" value="<?= $Page->a_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_operator->formatPattern()) ?>"<?= $Page->a_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
    <div id="r_a_datetime" class="row"<?= $Page->a_datetime->rowAttributes() ?>>
        <label for="x_a_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_a_datetime"><?= $Page->a_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_datetime" id="z_a_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="purchase_l_qc" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_operator->Visible) { // qc_operator ?>
    <div id="r_qc_operator" class="row"<?= $Page->qc_operator->rowAttributes() ?>>
        <label for="x_qc_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_qc_operator"><?= $Page->qc_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qc_operator" id="z_qc_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_qc_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_operator->getInputTextType() ?>" name="x_qc_operator" id="x_qc_operator" data-table="purchase_l_qc" data-field="x_qc_operator" value="<?= $Page->qc_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qc_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_operator->formatPattern()) ?>"<?= $Page->qc_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_datetime->Visible) { // qc_datetime ?>
    <div id="r_qc_datetime" class="row"<?= $Page->qc_datetime->rowAttributes() ?>>
        <label for="x_qc_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_qc_qc_datetime"><?= $Page->qc_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_qc_datetime" id="z_qc_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_qc_qc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_datetime->getInputTextType() ?>" name="x_qc_datetime" id="x_qc_datetime" data-table="purchase_l_qc" data-field="x_qc_datetime" value="<?= $Page->qc_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->qc_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_datetime->formatPattern()) ?>"<?= $Page->qc_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->qc_datetime->ReadOnly && !$Page->qc_datetime->Disabled && !isset($Page->qc_datetime->EditAttrs["readonly"]) && !isset($Page->qc_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_qcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_qcsearch", "x_qc_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpurchase_l_qcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_l_qcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpurchase_l_qcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_l_qc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
