<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseLQcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l_qc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpurchase_l_qcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_l_qcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["po", [], fields.po.isInvalid],
            ["rid", [ew.Validators.integer], fields.rid.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["net_weight", [ew.Validators.float], fields.net_weight.isInvalid],
            ["y_net_weight", [ew.Validators.between], false],
            ["qc_status", [], fields.qc_status.isInvalid],
            ["qc_remarks", [], fields.qc_remarks.isInvalid],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["y_packets", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["rack", [], fields.rack.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["goods_inward", [], fields.goods_inward.isInvalid],
            ["invoice_details", [], fields.invoice_details.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["remarks", [], fields.remarks.isInvalid],
            ["audit", [ew.Validators.integer], fields.audit.isInvalid],
            ["a_operator", [ew.Validators.integer], fields.a_operator.isInvalid],
            ["a_datetime", [ew.Validators.integer], fields.a_datetime.isInvalid],
            ["qc_operator", [ew.Validators.integer], fields.qc_operator.isInvalid],
            ["qc_datetime", [ew.Validators.datetime(fields.qc_datetime.clientFormatPattern)], fields.qc_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "po": <?= $Page->po->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "lot_no": <?= $Page->lot_no->toClientList($Page) ?>,
            "qc_status": <?= $Page->qc_status->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpurchase_l_qcsearch" id="fpurchase_l_qcsearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("purchaselqclist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_l_qc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_purchase_l_qc_id" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="purchase_l_qc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_type" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_type"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_type", selectId: "fpurchase_l_qcsearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_type", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_purchase_l_qc_po" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_po" class="ew-search-field ew-search-field-single">
    <select
        id="x_po"
        name="x_po"
        class="form-control ew-select<?= $Page->po->isInvalidClass() ?>"
        data-select2-id="fpurchase_l_qcsearch_x_po"
        data-table="purchase_l_qc"
        data-field="x_po"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->po->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
        <?= $Page->po->editAttributes() ?>>
        <?= $Page->po->selectOptionListHtml("x_po") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_po", selectId: "fpurchase_l_qcsearch_x_po" };
    if (fpurchase_l_qcsearch.lists.po?.lookupOptions.length) {
        options.data = { id: "x_po", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_po", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l_qc.fields.po.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_purchase_l_qc_rid" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_rid" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->rid->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_rid" class="ew-auto-suggest">
    <input type="<?= $Page->rid->getInputTextType() ?>" class="form-control" name="sv_x_rid" id="sv_x_rid" value="<?= RemoveHtml($Page->rid->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rid->formatPattern()) ?>"<?= $Page->rid->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_qc" data-field="x_rid" data-input="sv_x_rid" data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    fpurchase_l_qcsearch.createAutoSuggest(Object.assign({"id":"x_rid","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->rid->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_qc.fields.rid.autoSuggestOptions));
});
</script>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
</span></template>
<template id="tpx_purchase_l_qc_lot_no" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_lot_no" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->lot_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_lot_no" class="ew-auto-suggest">
    <input type="<?= $Page->lot_no->getInputTextType() ?>" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?= RemoveHtml($Page->lot_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_qc" data-field="x_lot_no" data-input="sv_x_lot_no" data-value-separator="<?= $Page->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?= HtmlEncode($Page->lot_no->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    fpurchase_l_qcsearch.createAutoSuggest(Object.assign({"id":"x_lot_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->lot_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_qc.fields.lot_no.autoSuggestOptions));
});
</script>
<?= $Page->lot_no->Lookup->getParamTag($Page, "p_x_lot_no") ?>
</span></template>
<template id="tpx_purchase_l_qc_net_weight" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_net_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_l_qc" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_qc_status" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_qc_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_qc_status"
        name="x_qc_status"
        class="form-select ew-select<?= $Page->qc_status->isInvalidClass() ?>"
        <?php if (!$Page->qc_status->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_qc_status"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_qc_status"
        data-value-separator="<?= $Page->qc_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->qc_status->getPlaceHolder()) ?>"
        <?= $Page->qc_status->editAttributes() ?>>
        <?= $Page->qc_status->selectOptionListHtml("x_qc_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->qc_status->getErrorMessage(false) ?></div>
<?= $Page->qc_status->Lookup->getParamTag($Page, "p_x_qc_status") ?>
<?php if (!$Page->qc_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_qc_status", selectId: "fpurchase_l_qcsearch_x_qc_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.qc_status?.lookupOptions.length) {
        options.data = { id: "x_qc_status", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_qc_status", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.qc_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_purchase_l_qc_qc_remarks" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_qc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_remarks->getInputTextType() ?>" name="x_qc_remarks" id="x_qc_remarks" data-table="purchase_l_qc" data-field="x_qc_remarks" value="<?= $Page->qc_remarks->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->qc_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_remarks->formatPattern()) ?>"<?= $Page->qc_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_packets" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_l_qc" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_packing_type" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_packing_type"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_l_qcsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_purchase_l_qc__40" class="purchase_l_qcsearch"><span id="el_purchase_l_qc__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="purchase_l_qc" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_amount" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="purchase_l_qc" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_godown" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_godown"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_godown", selectId: "fpurchase_l_qcsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_purchase_l_qc_rack" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_rack" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_l_qc" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_dated" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="purchase_l_qc" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_qcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_qcsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_purchase_l_qc_goods_inward" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_goods_inward" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->goods_inward->getInputTextType() ?>" name="x_goods_inward" id="x_goods_inward" data-table="purchase_l_qc" data-field="x_goods_inward" value="<?= $Page->goods_inward->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->goods_inward->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->goods_inward->formatPattern()) ?>"<?= $Page->goods_inward->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->goods_inward->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_invoice_details" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_invoice_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_l_qc" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_operator" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_qcsearch_x_operator"
        <?php } ?>
        data-table="purchase_l_qc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_qcsearch", function() {
    var options = { name: "x_operator", selectId: "fpurchase_l_qcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_qcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpurchase_l_qcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpurchase_l_qcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_qc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_purchase_l_qc_datetime" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="purchase_l_qc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_remarks" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="purchase_l_qc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_audit" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_audit" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->audit->getInputTextType() ?>" name="x_audit" id="x_audit" data-table="purchase_l_qc" data-field="x_audit" value="<?= $Page->audit->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->audit->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->audit->formatPattern()) ?>"<?= $Page->audit->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->audit->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_a_operator" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_a_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_operator->getInputTextType() ?>" name="x_a_operator" id="x_a_operator" data-table="purchase_l_qc" data-field="x_a_operator" value="<?= $Page->a_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_operator->formatPattern()) ?>"<?= $Page->a_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_a_datetime" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="purchase_l_qc" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_qc_operator" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_qc_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_operator->getInputTextType() ?>" name="x_qc_operator" id="x_qc_operator" data-table="purchase_l_qc" data-field="x_qc_operator" value="<?= $Page->qc_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->qc_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_operator->formatPattern()) ?>"<?= $Page->qc_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_purchase_l_qc_qc_datetime" class="purchase_l_qcsearch"><span id="el_purchase_l_qc_qc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_datetime->getInputTextType() ?>" name="x_qc_datetime" id="x_qc_datetime" data-table="purchase_l_qc" data-field="x_qc_datetime" value="<?= $Page->qc_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->qc_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_datetime->formatPattern()) ?>"<?= $Page->qc_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->qc_datetime->ReadOnly && !$Page->qc_datetime->Disabled && !isset($Page->qc_datetime->EditAttrs["readonly"]) && !isset($Page->qc_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_qcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_qcsearch", "x_qc_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<div id="purchase_l_qc_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "type",
                type: "integer",
                label: currentTable.fields.type.caption,
                operators: currentTable.fields.type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.type.validators),
                data: {
                    format: currentTable.fields.type.clientFormatPattern
                }
            },
            {
                id: "po",
                type: "string",
                label: currentTable.fields.po.caption,
                operators: currentTable.fields.po.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.po.validators),
                data: {
                    format: currentTable.fields.po.clientFormatPattern
                }
            },
            {
                id: "rid",
                type: "integer",
                label: currentTable.fields.rid.caption,
                operators: currentTable.fields.rid.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.rid.validators),
                data: {
                    format: currentTable.fields.rid.clientFormatPattern
                }
            },
            {
                id: "lot_no",
                type: "string",
                label: currentTable.fields.lot_no.caption,
                operators: currentTable.fields.lot_no.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.lot_no.validators),
                data: {
                    format: currentTable.fields.lot_no.clientFormatPattern
                }
            },
            {
                id: "net_weight",
                type: "double",
                label: currentTable.fields.net_weight.caption,
                operators: currentTable.fields.net_weight.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.net_weight.validators),
                data: {
                    format: currentTable.fields.net_weight.clientFormatPattern
                }
            },
            {
                id: "qc_status",
                type: "integer",
                label: currentTable.fields.qc_status.caption,
                operators: currentTable.fields.qc_status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.qc_status.validators),
                data: {
                    format: currentTable.fields.qc_status.clientFormatPattern
                }
            },
            {
                id: "qc_remarks",
                type: "string",
                label: currentTable.fields.qc_remarks.caption,
                operators: currentTable.fields.qc_remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.qc_remarks.validators),
                data: {
                    format: currentTable.fields.qc_remarks.clientFormatPattern
                }
            },
            {
                id: "packets",
                type: "double",
                label: currentTable.fields.packets.caption,
                operators: currentTable.fields.packets.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.packets.validators),
                data: {
                    format: currentTable.fields.packets.clientFormatPattern
                }
            },
            {
                id: "packing_type",
                type: "integer",
                label: currentTable.fields.packing_type.caption,
                operators: currentTable.fields.packing_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.packing_type.validators),
                data: {
                    format: currentTable.fields.packing_type.clientFormatPattern
                }
            },
            {
                id: "_40",
                type: "double",
                label: currentTable.fields._40.caption,
                operators: currentTable.fields._40.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields._40.validators),
                data: {
                    format: currentTable.fields._40.clientFormatPattern
                }
            },
            {
                id: "amount",
                type: "double",
                label: currentTable.fields.amount.caption,
                operators: currentTable.fields.amount.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.amount.validators),
                data: {
                    format: currentTable.fields.amount.clientFormatPattern
                }
            },
            {
                id: "godown",
                type: "integer",
                label: currentTable.fields.godown.caption,
                operators: currentTable.fields.godown.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.godown.validators),
                data: {
                    format: currentTable.fields.godown.clientFormatPattern
                }
            },
            {
                id: "rack",
                type: "string",
                label: currentTable.fields.rack.caption,
                operators: currentTable.fields.rack.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.rack.validators),
                data: {
                    format: currentTable.fields.rack.clientFormatPattern
                }
            },
            {
                id: "dated",
                type: "datetime",
                label: currentTable.fields.dated.caption,
                operators: currentTable.fields.dated.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.dated.validators),
                data: {
                    format: currentTable.fields.dated.clientFormatPattern
                }
            },
            {
                id: "goods_inward",
                type: "string",
                label: currentTable.fields.goods_inward.caption,
                operators: currentTable.fields.goods_inward.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.goods_inward.validators),
                data: {
                    format: currentTable.fields.goods_inward.clientFormatPattern
                }
            },
            {
                id: "invoice_details",
                type: "string",
                label: currentTable.fields.invoice_details.caption,
                operators: currentTable.fields.invoice_details.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.invoice_details.validators),
                data: {
                    format: currentTable.fields.invoice_details.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "audit",
                type: "integer",
                label: currentTable.fields.audit.caption,
                operators: currentTable.fields.audit.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.audit.validators),
                data: {
                    format: currentTable.fields.audit.clientFormatPattern
                }
            },
            {
                id: "a_operator",
                type: "integer",
                label: currentTable.fields.a_operator.caption,
                operators: currentTable.fields.a_operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.a_operator.validators),
                data: {
                    format: currentTable.fields.a_operator.clientFormatPattern
                }
            },
            {
                id: "a_datetime",
                type: "integer",
                label: currentTable.fields.a_datetime.caption,
                operators: currentTable.fields.a_datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.a_datetime.validators),
                data: {
                    format: currentTable.fields.a_datetime.clientFormatPattern
                }
            },
            {
                id: "qc_operator",
                type: "integer",
                label: currentTable.fields.qc_operator.caption,
                operators: currentTable.fields.qc_operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.qc_operator.validators),
                data: {
                    format: currentTable.fields.qc_operator.clientFormatPattern
                }
            },
            {
                id: "qc_datetime",
                type: "datetime",
                label: currentTable.fields.qc_datetime.caption,
                operators: currentTable.fields.qc_datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fpurchase_l_qcsearch.fields.qc_datetime.validators),
                data: {
                    format: currentTable.fields.qc_datetime.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#purchase_l_qc_query_builder"),
        args = {},
        rules = ew.parseJson($("#fpurchase_l_qcsearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fpurchase_l_qcsearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fpurchase_l_qcsearch" formaction="<?= HtmlEncode(GetUrl("purchaselqclist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_l_qcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fpurchase_l_qcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_l_qc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
