<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseLEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fpurchase_ledit" id="fpurchase_ledit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fpurchase_ledit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpurchase_ledit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["supplier", [fields.supplier.visible && fields.supplier.required ? ew.Validators.required(fields.supplier.caption) : null], fields.supplier.isInvalid],
            ["po", [fields.po.visible && fields.po.required ? ew.Validators.required(fields.po.caption) : null], fields.po.isInvalid],
            ["po_return", [fields.po_return.visible && fields.po_return.required ? ew.Validators.required(fields.po_return.caption) : null, ew.Validators.integer], fields.po_return.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["rid_return", [fields.rid_return.visible && fields.rid_return.required ? ew.Validators.required(fields.rid_return.caption) : null], fields.rid_return.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null, ew.Validators.integer], fields.rid.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.float], fields.packets.isInvalid],
            ["net_weight", [fields.net_weight.visible && fields.net_weight.required ? ew.Validators.required(fields.net_weight.caption) : null, ew.Validators.float], fields.net_weight.isInvalid],
            ["_40", [fields._40.visible && fields._40.required ? ew.Validators.required(fields._40.caption) : null, ew.Validators.float], fields._40.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["rack", [fields.rack.visible && fields.rack.required ? ew.Validators.required(fields.rack.caption) : null], fields.rack.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["goods_inward", [fields.goods_inward.visible && fields.goods_inward.required ? ew.Validators.required(fields.goods_inward.caption) : null], fields.goods_inward.isInvalid],
            ["invoice_details", [fields.invoice_details.visible && fields.invoice_details.required ? ew.Validators.required(fields.invoice_details.caption) : null], fields.invoice_details.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null], fields._barcode.isInvalid],
            ["return_details", [fields.return_details.visible && fields.return_details.required ? ew.Validators.required(fields.return_details.caption) : null], fields.return_details.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "po": <?= $Page->po->toClientList($Page) ?>,
            "po_return": <?= $Page->po_return->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "lot_no": <?= $Page->lot_no->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_l">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_purchase_l_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_purchase_l_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="purchase_l" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_purchase_l_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_purchase_l_type">
<span<?= $Page->type->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->type->getDisplayValue($Page->type->EditValue) ?></span></span>
<input type="hidden" data-table="purchase_l" data-field="x_type" data-hidden="1" name="x_type" id="x_type" value="<?= HtmlEncode($Page->type->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier"<?= $Page->supplier->rowAttributes() ?>>
        <label id="elh_purchase_l_supplier" class="<?= $Page->LeftColumnClass ?>"><?= $Page->supplier->caption() ?><?= $Page->supplier->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->supplier->cellAttributes() ?>>
<span id="el_purchase_l_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Page->supplier->EditValue) && $Page->supplier->linkAttributes() != "") { ?>
<a<?= $Page->supplier->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->supplier->getDisplayValue($Page->supplier->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->supplier->getDisplayValue($Page->supplier->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_l" data-field="x_supplier" data-hidden="1" name="x_supplier" id="x_supplier" value="<?= HtmlEncode($Page->supplier->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po"<?= $Page->po->rowAttributes() ?>>
        <label id="elh_purchase_l_po" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po->caption() ?><?= $Page->po->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po->cellAttributes() ?>>
<span id="el_purchase_l_po">
    <select
        id="x_po"
        name="x_po"
        class="form-control ew-select<?= $Page->po->isInvalidClass() ?>"
        data-select2-id="fpurchase_ledit_x_po"
        data-table="purchase_l"
        data-field="x_po"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->po->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->po->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->po->editAttributes() ?>>
        <?= $Page->po->selectOptionListHtml("x_po") ?>
    </select>
    <?= $Page->po->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->po->getErrorMessage() ?></div>
<?= $Page->po->Lookup->getParamTag($Page, "p_x_po") ?>
<script>
loadjs.ready("fpurchase_ledit", function() {
    var options = { name: "x_po", selectId: "fpurchase_ledit_x_po" };
    if (fpurchase_ledit.lists.po?.lookupOptions.length) {
        options.data = { id: "x_po", form: "fpurchase_ledit" };
    } else {
        options.ajax = { id: "x_po", form: "fpurchase_ledit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l.fields.po.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->po_return->Visible) { // po_return ?>
    <div id="r_po_return"<?= $Page->po_return->rowAttributes() ?>>
        <label id="elh_purchase_l_po_return" class="<?= $Page->LeftColumnClass ?>"><?= $Page->po_return->caption() ?><?= $Page->po_return->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->po_return->cellAttributes() ?>>
<span id="el_purchase_l_po_return">
<?php
if (IsRTL()) {
    $Page->po_return->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po_return" class="ew-auto-suggest">
    <input type="<?= $Page->po_return->getInputTextType() ?>" class="form-control" name="sv_x_po_return" id="sv_x_po_return" value="<?= RemoveHtml($Page->po_return->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po_return->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po_return->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_return->formatPattern()) ?>"<?= $Page->po_return->editAttributes() ?> aria-describedby="x_po_return_help">
</span>
<selection-list hidden class="form-control" data-table="purchase_l" data-field="x_po_return" data-input="sv_x_po_return" data-value-separator="<?= $Page->po_return->displayValueSeparatorAttribute() ?>" name="x_po_return" id="x_po_return" value="<?= HtmlEncode($Page->po_return->CurrentValue) ?>"></selection-list>
<?= $Page->po_return->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->po_return->getErrorMessage() ?></div>
<script>
loadjs.ready("fpurchase_ledit", function() {
    fpurchase_ledit.createAutoSuggest(Object.assign({"id":"x_po_return","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->po_return->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l.fields.po_return.autoSuggestOptions));
});
</script>
<?= $Page->po_return->Lookup->getParamTag($Page, "p_x_po_return") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label id="elh_purchase_l_company_id" for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->company_id->caption() ?><?= $Page->company_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->company_id->cellAttributes() ?>>
<span id="el_purchase_l_company_id">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fpurchase_ledit_x_company_id"
        <?php } ?>
        data-table="purchase_l"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <?= $Page->company_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_ledit", function() {
    var options = { name: "x_company_id", selectId: "fpurchase_ledit_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_ledit.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fpurchase_ledit" };
    } else {
        options.ajax = { id: "x_company_id", form: "fpurchase_ledit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid_return->Visible) { // rid_return ?>
    <div id="r_rid_return"<?= $Page->rid_return->rowAttributes() ?>>
        <label id="elh_purchase_l_rid_return" for="x_rid_return" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid_return->caption() ?><?= $Page->rid_return->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid_return->cellAttributes() ?>>
<span id="el_purchase_l_rid_return">
<span<?= $Page->rid_return->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->rid_return->getDisplayValue($Page->rid_return->EditValue) ?></span></span>
<input type="hidden" data-table="purchase_l" data-field="x_rid_return" data-hidden="1" name="x_rid_return" id="x_rid_return" value="<?= HtmlEncode($Page->rid_return->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_purchase_l_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_purchase_l_rid">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fpurchase_ledit_x_rid"
        data-table="purchase_l"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <?= $Page->rid->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage() ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fpurchase_ledit", function() {
    var options = { name: "x_rid", selectId: "fpurchase_ledit_x_rid" };
    if (fpurchase_ledit.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fpurchase_ledit" };
    } else {
        options.ajax = { id: "x_rid", form: "fpurchase_ledit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_purchase_l_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_purchase_l_packing_type">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_ledit_x_packing_type"
        <?php } ?>
        data-table="purchase_l"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?= $Page->packing_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_ledit", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_ledit_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_ledit.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_ledit" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_ledit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_purchase_l_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_purchase_l_lot_no">
<?php
if (IsRTL()) {
    $Page->lot_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_lot_no" class="ew-auto-suggest">
    <input type="<?= $Page->lot_no->getInputTextType() ?>" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?= RemoveHtml($Page->lot_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?> aria-describedby="x_lot_no_help">
</span>
<selection-list hidden class="form-control" data-table="purchase_l" data-field="x_lot_no" data-input="sv_x_lot_no" data-value-separator="<?= $Page->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?= HtmlEncode($Page->lot_no->CurrentValue) ?>"></selection-list>
<?= $Page->lot_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage() ?></div>
<script>
loadjs.ready("fpurchase_ledit", function() {
    fpurchase_ledit.createAutoSuggest(Object.assign({"id":"x_lot_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->lot_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l.fields.lot_no.autoSuggestOptions));
});
</script>
<?= $Page->lot_no->Lookup->getParamTag($Page, "p_x_lot_no") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets"<?= $Page->packets->rowAttributes() ?>>
        <label id="elh_purchase_l_packets" for="x_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packets->caption() ?><?= $Page->packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packets->cellAttributes() ?>>
<span id="el_purchase_l_packets">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_l" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?> aria-describedby="x_packets_help">
<?= $Page->packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight"<?= $Page->net_weight->rowAttributes() ?>>
        <label id="elh_purchase_l_net_weight" for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->net_weight->caption() ?><?= $Page->net_weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->net_weight->cellAttributes() ?>>
<span id="el_purchase_l_net_weight">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_l" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?> aria-describedby="x_net_weight_help">
<?= $Page->net_weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40"<?= $Page->_40->rowAttributes() ?>>
        <label id="elh_purchase_l__40" for="x__40" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_40->caption() ?><?= $Page->_40->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_40->cellAttributes() ?>>
<span id="el_purchase_l__40">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="purchase_l" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?> aria-describedby="x__40_help">
<?= $Page->_40->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_purchase_l_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_purchase_l_amount">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="purchase_l" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?> aria-describedby="x_amount_help">
<?= $Page->amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown"<?= $Page->godown->rowAttributes() ?>>
        <label id="elh_purchase_l_godown" for="x_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown->caption() ?><?= $Page->godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown->cellAttributes() ?>>
<span id="el_purchase_l_godown">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_ledit_x_godown"
        <?php } ?>
        data-table="purchase_l"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <?= $Page->godown->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage() ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_ledit", function() {
    var options = { name: "x_godown", selectId: "fpurchase_ledit_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_ledit.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_ledit" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_ledit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_purchase_l_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_purchase_l_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="purchase_l" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_ledit", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_ledit", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
    <div id="r_rack"<?= $Page->rack->rowAttributes() ?>>
        <label id="elh_purchase_l_rack" for="x_rack" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rack->caption() ?><?= $Page->rack->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rack->cellAttributes() ?>>
<span id="el_purchase_l_rack">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_l" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?> aria-describedby="x_rack_help">
<?= $Page->rack->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_purchase_l_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_purchase_l_remarks">
<textarea data-table="purchase_l" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->goods_inward->Visible) { // goods_inward ?>
    <div id="r_goods_inward"<?= $Page->goods_inward->rowAttributes() ?>>
        <label id="elh_purchase_l_goods_inward" for="x_goods_inward" class="<?= $Page->LeftColumnClass ?>"><?= $Page->goods_inward->caption() ?><?= $Page->goods_inward->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->goods_inward->cellAttributes() ?>>
<span id="el_purchase_l_goods_inward">
<input type="<?= $Page->goods_inward->getInputTextType() ?>" name="x_goods_inward" id="x_goods_inward" data-table="purchase_l" data-field="x_goods_inward" value="<?= $Page->goods_inward->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->goods_inward->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->goods_inward->formatPattern()) ?>"<?= $Page->goods_inward->editAttributes() ?> aria-describedby="x_goods_inward_help">
<?= $Page->goods_inward->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->goods_inward->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
    <div id="r_invoice_details"<?= $Page->invoice_details->rowAttributes() ?>>
        <label id="elh_purchase_l_invoice_details" for="x_invoice_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_details->caption() ?><?= $Page->invoice_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_details->cellAttributes() ?>>
<span id="el_purchase_l_invoice_details">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_l" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?> aria-describedby="x_invoice_details_help">
<?= $Page->invoice_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_purchase_l__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_purchase_l__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->EditValue ?></span>
<input type="hidden" data-table="purchase_l" data-field="x__barcode" data-hidden="1" name="x__barcode" id="x__barcode" value="<?= HtmlEncode($Page->_barcode->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->return_details->Visible) { // return_details ?>
    <div id="r_return_details"<?= $Page->return_details->rowAttributes() ?>>
        <label id="elh_purchase_l_return_details" for="x_return_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->return_details->caption() ?><?= $Page->return_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->return_details->cellAttributes() ?>>
<span id="el_purchase_l_return_details">
<textarea data-table="purchase_l" data-field="x_return_details" name="x_return_details" id="x_return_details" cols="35" rows="3" placeholder="<?= HtmlEncode($Page->return_details->getPlaceHolder()) ?>"<?= $Page->return_details->editAttributes() ?> aria-describedby="x_return_details_help"><?= $Page->return_details->EditValue ?></textarea>
<?= $Page->return_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->return_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpurchase_ledit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_ledit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_l");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    	var type = $("#x_type").val();
    				if ( (type == 71) || (type == 75)  || (type == 74) )
    				{
    				$("#r_po").hide();
    				$("#r_po_return").hide();
    				}
    				else
    				{
    				$("#r_po").show();
    				$("#r_po_return").show();				
    				}
    				if (type == 73)
    					{
    				 	//$("#r_return_details").show();
    				 	$("#elh_purchase_l_remarks").html('Remarks / Goods Return Details')
    					$("#x_rid").val('');				 	
    				 	$("#r_rid").hide();
    				 	$("#r_rid_return").show();
    					$("#r_po").hide();				
    				 	//$("input[type=radio][name=x_rid]").prop('checked', false);
    					}
    					else
    					{
    				 	$("#elh_purchase_l_remarks").html('Remarks')
    				 	//$("#r_return_details").hide();
    				 	$("#r_rid_return").hide();				 	
    				 	$("#x_rid_return").val('');				 	
    				 	$("#r_rid").show();
    					$("#r_po_return").hide();				
    				 	//$("input[type=radio][name=x_rid_return]").prop('checked', false);
    					}
});
</script>
