<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseLBcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l_bc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpurchase_l_bcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_l_bcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["supplier", [ew.Validators.integer], fields.supplier.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["net_weight", [ew.Validators.float], fields.net_weight.isInvalid],
            ["y_net_weight", [ew.Validators.between], false],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["y_packets", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["rack", [], fields.rack.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpurchase_l_bcsearch" id="fpurchase_l_bcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_l_bc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="purchase_l_bc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier" class="row"<?= $Page->supplier->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_supplier"><?= $Page->supplier->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->supplier->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_supplier" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->supplier->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_supplier" class="ew-auto-suggest">
    <input type="<?= $Page->supplier->getInputTextType() ?>" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?= RemoveHtml($Page->supplier->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->supplier->formatPattern()) ?>"<?= $Page->supplier->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_bc" data-field="x_supplier" data-input="sv_x_supplier" data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?= HtmlEncode($Page->supplier->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_bcsearch", function() {
    fpurchase_l_bcsearch.createAutoSuggest(Object.assign({"id":"x_supplier","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->supplier->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_bc.fields.supplier.autoSuggestOptions));
});
</script>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_bcsearch_x_godown"
        <?php } ?>
        data-table="purchase_l_bc"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_bcsearch", function() {
    var options = { name: "x_godown", selectId: "fpurchase_l_bcsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_bcsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_l_bcsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_l_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_bc.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight" class="row"<?= $Page->net_weight->rowAttributes() ?>>
        <label for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_net_weight"><?= $Page->net_weight->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->net_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_net_weight" id="z_net_weight" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->net_weight->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->net_weight->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_bc_net_weight" class="ew-search-field">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_l_bc" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_bc_net_weight" class="ew-search-field2 d-none">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="y_net_weight" id="y_net_weight" data-table="purchase_l_bc" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_packets"><?= $Page->packets->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_packets" id="z_packets" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->packets->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->packets->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_bc_packets" class="ew-search-field">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_l_bc" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_bc_packets" class="ew-search-field2 d-none">
<input type="<?= $Page->packets->getInputTextType() ?>" name="y_packets" id="y_packets" data-table="purchase_l_bc" data-field="x_packets" value="<?= $Page->packets->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_bcsearch_x_packing_type"
        <?php } ?>
        data-table="purchase_l_bc"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_bcsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_l_bcsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_bcsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_l_bcsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_l_bcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_bc.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
    <div id="r_rack" class="row"<?= $Page->rack->rowAttributes() ?>>
        <label for="x_rack" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_rack"><?= $Page->rack->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rack" id="z_rack" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rack->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_rack" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_l_bc" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="purchase_l_bc" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="purchase_l_bc" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_bc_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_bc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="purchase_l_bc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_bcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_bcsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpurchase_l_bcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_l_bcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpurchase_l_bcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_l_bc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
