<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseLAuditOldSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l_audit_old: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpurchase_l_audit_oldsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_l_audit_oldsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["supplier", [ew.Validators.integer], fields.supplier.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["rid_return", [], fields.rid_return.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["net_weight", [ew.Validators.float], fields.net_weight.isInvalid],
            ["y_net_weight", [ew.Validators.between], false],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["y_packets", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["_40", [ew.Validators.float], fields._40.isInvalid],
            ["amount", [ew.Validators.float], fields.amount.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["rack", [], fields.rack.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["y_dated", [ew.Validators.between], false],
            ["goods_inward", [], fields.goods_inward.isInvalid],
            ["invoice_details", [], fields.invoice_details.isInvalid],
            ["return_details", [], fields.return_details.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["remarks", [], fields.remarks.isInvalid],
            ["audit", [], fields.audit.isInvalid],
            ["a_operator", [ew.Validators.integer], fields.a_operator.isInvalid],
            ["a_datetime", [ew.Validators.integer], fields.a_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "rid_return": <?= $Page->rid_return->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "lot_no": <?= $Page->lot_no->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "audit": <?= $Page->audit->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpurchase_l_audit_oldsearch" id="fpurchase_l_audit_oldsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_l_audit_old">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="purchase_l_audit_old" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_type"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_type", selectId: "fpurchase_l_audit_oldsearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_type", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fpurchase_l_audit_oldsearch_x_rid"
        data-table="purchase_l_audit_old"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_rid", selectId: "fpurchase_l_audit_oldsearch_x_rid" };
    if (fpurchase_l_audit_oldsearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l_audit_old.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid_return->Visible) { // rid_return ?>
    <div id="r_rid_return" class="row"<?= $Page->rid_return->rowAttributes() ?>>
        <label for="x_rid_return" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_rid_return"><?= $Page->rid_return->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid_return" id="z_rid_return" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid_return->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_rid_return" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid_return"
        name="x_rid_return"
        class="form-control ew-select<?= $Page->rid_return->isInvalidClass() ?>"
        data-select2-id="fpurchase_l_audit_oldsearch_x_rid_return"
        data-table="purchase_l_audit_old"
        data-field="x_rid_return"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid_return->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid_return->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid_return->getPlaceHolder()) ?>"
        <?= $Page->rid_return->editAttributes() ?>>
        <?= $Page->rid_return->selectOptionListHtml("x_rid_return") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid_return->getErrorMessage(false) ?></div>
<?= $Page->rid_return->Lookup->getParamTag($Page, "p_x_rid_return") ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_rid_return", selectId: "fpurchase_l_audit_oldsearch_x_rid_return" };
    if (fpurchase_l_audit_oldsearch.lists.rid_return?.lookupOptions.length) {
        options.data = { id: "x_rid_return", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_rid_return", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.purchase_l_audit_old.fields.rid_return.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_grp"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_grp", selectId: "fpurchase_l_audit_oldsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_s_grp"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_s_grp", selectId: "fpurchase_l_audit_oldsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_product"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_product", selectId: "fpurchase_l_audit_oldsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_lot_no" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->lot_no->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_lot_no" class="ew-auto-suggest">
    <input type="<?= $Page->lot_no->getInputTextType() ?>" class="form-control" name="sv_x_lot_no" id="sv_x_lot_no" value="<?= RemoveHtml($Page->lot_no->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_audit_old" data-field="x_lot_no" data-input="sv_x_lot_no" data-value-separator="<?= $Page->lot_no->displayValueSeparatorAttribute() ?>" name="x_lot_no" id="x_lot_no" value="<?= HtmlEncode($Page->lot_no->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    fpurchase_l_audit_oldsearch.createAutoSuggest(Object.assign({"id":"x_lot_no","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->lot_no->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_audit_old.fields.lot_no.autoSuggestOptions));
});
</script>
<?= $Page->lot_no->Lookup->getParamTag($Page, "p_x_lot_no") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="purchase_l_audit_old" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight" class="row"<?= $Page->net_weight->rowAttributes() ?>>
        <label for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_net_weight"><?= $Page->net_weight->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->net_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_net_weight" id="z_net_weight" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->net_weight->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->net_weight->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_audit_old_net_weight" class="ew-search-field">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_l_audit_old" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_audit_old_net_weight" class="ew-search-field2 d-none">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="y_net_weight" id="y_net_weight" data-table="purchase_l_audit_old" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_packets"><?= $Page->packets->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_packets" id="z_packets" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->packets->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->packets->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_audit_old_packets" class="ew-search-field">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_l_audit_old" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_audit_old_packets" class="ew-search-field2 d-none">
<input type="<?= $Page->packets->getInputTextType() ?>" name="y_packets" id="y_packets" data-table="purchase_l_audit_old" data-field="x_packets" value="<?= $Page->packets->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_packing_type"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_l_audit_oldsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_40->Visible) { // @ ?>
    <div id="r__40" class="row"<?= $Page->_40->rowAttributes() ?>>
        <label for="x__40" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old__40"><?= $Page->_40->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__40" id="z__40" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_40->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old__40" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_40->getInputTextType() ?>" name="x__40" id="x__40" data-table="purchase_l_audit_old" data-field="x__40" value="<?= $Page->_40->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_40->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_40->formatPattern()) ?>"<?= $Page->_40->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_40->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount" class="row"<?= $Page->amount->rowAttributes() ?>>
        <label for="x_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_amount"><?= $Page->amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_amount" id="z_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->amount->getInputTextType() ?>" name="x_amount" id="x_amount" data-table="purchase_l_audit_old" data-field="x_amount" value="<?= $Page->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->amount->formatPattern()) ?>"<?= $Page->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_godown"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_godown", selectId: "fpurchase_l_audit_oldsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
    <div id="r_rack" class="row"<?= $Page->rack->rowAttributes() ?>>
        <label for="x_rack" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_rack"><?= $Page->rack->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rack" id="z_rack" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rack->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_rack" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_l_audit_old" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_dated"><?= $Page->dated->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_dated" id="z_dated" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->dated->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->dated->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_audit_old_dated" class="ew-search-field">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="purchase_l_audit_old" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_audit_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_audit_oldsearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_audit_old_dated" class="ew-search-field2 d-none">
<input type="<?= $Page->dated->getInputTextType() ?>" name="y_dated" id="y_dated" data-table="purchase_l_audit_old" data-field="x_dated" value="<?= $Page->dated->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_l_audit_oldsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_l_audit_oldsearch", "y_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->goods_inward->Visible) { // goods_inward ?>
    <div id="r_goods_inward" class="row"<?= $Page->goods_inward->rowAttributes() ?>>
        <label for="x_goods_inward" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_goods_inward"><?= $Page->goods_inward->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_goods_inward" id="z_goods_inward" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->goods_inward->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_goods_inward" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->goods_inward->getInputTextType() ?>" name="x_goods_inward" id="x_goods_inward" data-table="purchase_l_audit_old" data-field="x_goods_inward" value="<?= $Page->goods_inward->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->goods_inward->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->goods_inward->formatPattern()) ?>"<?= $Page->goods_inward->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->goods_inward->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
    <div id="r_invoice_details" class="row"<?= $Page->invoice_details->rowAttributes() ?>>
        <label for="x_invoice_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_invoice_details"><?= $Page->invoice_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_invoice_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_l_audit_old" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->return_details->Visible) { // return_details ?>
    <div id="r_return_details" class="row"<?= $Page->return_details->rowAttributes() ?>>
        <label for="x_return_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_return_details"><?= $Page->return_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_return_details" id="z_return_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->return_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_return_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->return_details->getInputTextType() ?>" name="x_return_details" id="x_return_details" data-table="purchase_l_audit_old" data-field="x_return_details" value="<?= $Page->return_details->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->return_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->return_details->formatPattern()) ?>"<?= $Page->return_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->return_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_operator"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_operator", selectId: "fpurchase_l_audit_oldsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_l_audit_old_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="purchase_l_audit_old" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_l_audit_old_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="purchase_l_audit_old" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="purchase_l_audit_old" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->audit->Visible) { // audit ?>
    <div id="r_audit" class="row"<?= $Page->audit->rowAttributes() ?>>
        <label for="x_audit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_audit"><?= $Page->audit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_audit" id="z_audit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->audit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_audit" class="ew-search-field ew-search-field-single">
    <select
        id="x_audit"
        name="x_audit"
        class="form-select ew-select<?= $Page->audit->isInvalidClass() ?>"
        <?php if (!$Page->audit->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_audit_oldsearch_x_audit"
        <?php } ?>
        data-table="purchase_l_audit_old"
        data-field="x_audit"
        data-value-separator="<?= $Page->audit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->audit->getPlaceHolder()) ?>"
        <?= $Page->audit->editAttributes() ?>>
        <?= $Page->audit->selectOptionListHtml("x_audit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->audit->getErrorMessage(false) ?></div>
<?php if (!$Page->audit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_audit_oldsearch", function() {
    var options = { name: "x_audit", selectId: "fpurchase_l_audit_oldsearch_x_audit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_audit_oldsearch.lists.audit?.lookupOptions.length) {
        options.data = { id: "x_audit", form: "fpurchase_l_audit_oldsearch" };
    } else {
        options.ajax = { id: "x_audit", form: "fpurchase_l_audit_oldsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit_old.fields.audit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_a_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_operator->getInputTextType() ?>" name="x_a_operator" id="x_a_operator" data-table="purchase_l_audit_old" data-field="x_a_operator" value="<?= $Page->a_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_operator->formatPattern()) ?>"<?= $Page->a_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
    <div id="r_a_datetime" class="row"<?= $Page->a_datetime->rowAttributes() ?>>
        <label for="x_a_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_l_audit_old_a_datetime"><?= $Page->a_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_datetime" id="z_a_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_l_audit_old_a_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->a_datetime->getInputTextType() ?>" name="x_a_datetime" id="x_a_datetime" data-table="purchase_l_audit_old" data-field="x_a_datetime" value="<?= $Page->a_datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->a_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->a_datetime->formatPattern()) ?>"<?= $Page->a_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->a_datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpurchase_l_audit_oldsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_l_audit_oldsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpurchase_l_audit_oldsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_l_audit_old");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
