<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseLAuditList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l_audit: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpurchase_l_auditsrch" id="fpurchase_l_auditsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpurchase_l_auditsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_l_audit: currentTable } });
var currentForm;
var fpurchase_l_auditsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_l_auditsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["type", [], fields.type.isInvalid],
            ["supplier", [ew.Validators.integer], fields.supplier.isInvalid],
            ["invoice_details", [], fields.invoice_details.isInvalid],
            ["audit", [], fields.audit.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "audit": <?= $Page->audit->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->type->Visible) { // type ?>
<?php
if (!$Page->type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->type->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_type" class="ew-search-caption ew-label"><?= $Page->type->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</div>
        </div>
        <div id="el_purchase_l_audit_type" class="ew-search-field">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_auditsrch_x_type"
        <?php } ?>
        data-table="purchase_l_audit"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?= $Page->type->Lookup->getParamTag($Page, "p_x_type") ?>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_auditsrch", function() {
    var options = { name: "x_type", selectId: "fpurchase_l_auditsrch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_auditsrch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fpurchase_l_auditsrch" };
    } else {
        options.ajax = { id: "x_type", form: "fpurchase_l_auditsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
<?php
if (!$Page->supplier->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_supplier" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->supplier->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->supplier->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</div>
        </div>
        <div id="el_purchase_l_audit_supplier" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->supplier->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_supplier" class="ew-auto-suggest">
    <input type="<?= $Page->supplier->getInputTextType() ?>" class="form-control" name="sv_x_supplier" id="sv_x_supplier" value="<?= RemoveHtml($Page->supplier->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->supplier->formatPattern()) ?>"<?= $Page->supplier->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="purchase_l_audit" data-field="x_supplier" data-input="sv_x_supplier" data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>" name="x_supplier" id="x_supplier" value="<?= HtmlEncode($Page->supplier->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fpurchase_l_auditsrch", function() {
    fpurchase_l_auditsrch.createAutoSuggest(Object.assign({"id":"x_supplier","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->supplier->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.purchase_l_audit.fields.supplier.autoSuggestOptions));
});
</script>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
<?php
if (!$Page->invoice_details->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_invoice_details" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->invoice_details->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_invoice_details" class="ew-search-caption ew-label"><?= $Page->invoice_details->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice_details" id="z_invoice_details" value="LIKE">
</div>
        </div>
        <div id="el_purchase_l_audit_invoice_details" class="ew-search-field">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_l_audit" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->audit->Visible) { // audit ?>
<?php
if (!$Page->audit->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_audit" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->audit->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_audit" class="ew-search-caption ew-label"><?= $Page->audit->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_audit" id="z_audit" value="=">
</div>
        </div>
        <div id="el_purchase_l_audit_audit" class="ew-search-field">
    <select
        id="x_audit"
        name="x_audit"
        class="form-select ew-select<?= $Page->audit->isInvalidClass() ?>"
        <?php if (!$Page->audit->IsNativeSelect) { ?>
        data-select2-id="fpurchase_l_auditsrch_x_audit"
        <?php } ?>
        data-table="purchase_l_audit"
        data-field="x_audit"
        data-value-separator="<?= $Page->audit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->audit->getPlaceHolder()) ?>"
        <?= $Page->audit->editAttributes() ?>>
        <?= $Page->audit->selectOptionListHtml("x_audit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->audit->getErrorMessage(false) ?></div>
<?php if (!$Page->audit->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_l_auditsrch", function() {
    var options = { name: "x_audit", selectId: "fpurchase_l_auditsrch_x_audit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_l_auditsrch.lists.audit?.lookupOptions.length) {
        options.data = { id: "x_audit", form: "fpurchase_l_auditsrch" };
    } else {
        options.ajax = { id: "x_audit", form: "fpurchase_l_auditsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_l_audit.fields.audit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpurchase_l_auditsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpurchase_l_auditsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpurchase_l_auditsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpurchase_l_auditsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpurchase_l_auditsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpurchase_l_auditsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpurchase_l_auditsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_l_audit">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_purchase_l_audit" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_purchase_l_auditlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_purchase_l_audit_id" class="purchase_l_audit_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Page->type->headerCellClass() ?>"><div id="elh_purchase_l_audit_type" class="purchase_l_audit_type"><?= $Page->renderFieldHeader($Page->type) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_purchase_l_audit_company_id" class="purchase_l_audit_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
        <th data-name="supplier" class="<?= $Page->supplier->headerCellClass() ?>"><div id="elh_purchase_l_audit_supplier" class="purchase_l_audit_supplier"><?= $Page->renderFieldHeader($Page->supplier) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_purchase_l_audit_rid" class="purchase_l_audit_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_purchase_l_audit_lot_no" class="purchase_l_audit_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
        <th data-name="_barcode" class="<?= $Page->_barcode->headerCellClass() ?>"><div id="elh_purchase_l_audit__barcode" class="purchase_l_audit__barcode"><?= $Page->renderFieldHeader($Page->_barcode) ?></div></th>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
        <th data-name="net_weight" class="<?= $Page->net_weight->headerCellClass() ?>"><div id="elh_purchase_l_audit_net_weight" class="purchase_l_audit_net_weight"><?= $Page->renderFieldHeader($Page->net_weight) ?></div></th>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Page->packets->headerCellClass() ?>"><div id="elh_purchase_l_audit_packets" class="purchase_l_audit_packets"><?= $Page->renderFieldHeader($Page->packets) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_purchase_l_audit_packing_type" class="purchase_l_audit_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>"><div id="elh_purchase_l_audit_amount" class="purchase_l_audit_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_purchase_l_audit_godown" class="purchase_l_audit_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_purchase_l_audit_dated" class="purchase_l_audit_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->goods_inward->Visible) { // goods_inward ?>
        <th data-name="goods_inward" class="<?= $Page->goods_inward->headerCellClass() ?>"><div id="elh_purchase_l_audit_goods_inward" class="purchase_l_audit_goods_inward"><?= $Page->renderFieldHeader($Page->goods_inward) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
        <th data-name="invoice_details" class="<?= $Page->invoice_details->headerCellClass() ?>"><div id="elh_purchase_l_audit_invoice_details" class="purchase_l_audit_invoice_details"><?= $Page->renderFieldHeader($Page->invoice_details) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_dated->Visible) { // invoice_dated ?>
        <th data-name="invoice_dated" class="<?= $Page->invoice_dated->headerCellClass() ?>"><div id="elh_purchase_l_audit_invoice_dated" class="purchase_l_audit_invoice_dated"><?= $Page->renderFieldHeader($Page->invoice_dated) ?></div></th>
<?php } ?>
<?php if ($Page->return_details->Visible) { // return_details ?>
        <th data-name="return_details" class="<?= $Page->return_details->headerCellClass() ?>"><div id="elh_purchase_l_audit_return_details" class="purchase_l_audit_return_details"><?= $Page->renderFieldHeader($Page->return_details) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_purchase_l_audit_operator" class="purchase_l_audit_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_purchase_l_audit_datetime" class="purchase_l_audit_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_purchase_l_audit_remarks" class="purchase_l_audit_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->audit->Visible) { // audit ?>
        <th data-name="audit" class="<?= $Page->audit->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_l_audit_audit" class="purchase_l_audit_audit"><?= $Page->renderFieldHeader($Page->audit) ?></div></th>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
        <th data-name="a_operator" class="<?= $Page->a_operator->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_l_audit_a_operator" class="purchase_l_audit_a_operator"><?= $Page->renderFieldHeader($Page->a_operator) ?></div></th>
<?php } ?>
<?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <th data-name="a_datetime" class="<?= $Page->a_datetime->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_l_audit_a_datetime" class="purchase_l_audit_a_datetime"><?= $Page->renderFieldHeader($Page->a_datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_id" class="el_purchase_l_audit_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type"<?= $Page->type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_type" class="el_purchase_l_audit_type">
<span<?= $Page->type->viewAttributes() ?>>
<?= $Page->type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_company_id" class="el_purchase_l_audit_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->supplier->Visible) { // supplier ?>
        <td data-name="supplier"<?= $Page->supplier->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_supplier" class="el_purchase_l_audit_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Page->supplier->getViewValue()) && $Page->supplier->linkAttributes() != "") { ?>
<a<?= $Page->supplier->linkAttributes() ?>><?= $Page->supplier->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_rid" class="el_purchase_l_audit_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->getViewValue()) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><?= $Page->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_lot_no" class="el_purchase_l_audit_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode"<?= $Page->_barcode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit__barcode" class="el_purchase_l_audit__barcode">
<span<?= $Page->_barcode->viewAttributes() ?>>
<?= $Page->_barcode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->net_weight->Visible) { // net_weight ?>
        <td data-name="net_weight"<?= $Page->net_weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_net_weight" class="el_purchase_l_audit_net_weight">
<span<?= $Page->net_weight->viewAttributes() ?>>
<?= $Page->net_weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Page->packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_packets" class="el_purchase_l_audit_packets">
<span<?= $Page->packets->viewAttributes() ?>>
<?= $Page->packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_packing_type" class="el_purchase_l_audit_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?php if (!EmptyString($Page->packing_type->getViewValue()) && $Page->packing_type->linkAttributes() != "") { ?>
<a<?= $Page->packing_type->linkAttributes() ?>><?= $Page->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_amount" class="el_purchase_l_audit_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_godown" class="el_purchase_l_audit_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?php if (!EmptyString($Page->godown->getViewValue()) && $Page->godown->linkAttributes() != "") { ?>
<a<?= $Page->godown->linkAttributes() ?>><?= $Page->godown->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_dated" class="el_purchase_l_audit_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->goods_inward->Visible) { // goods_inward ?>
        <td data-name="goods_inward"<?= $Page->goods_inward->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_goods_inward" class="el_purchase_l_audit_goods_inward">
<span<?= $Page->goods_inward->viewAttributes() ?>>
<?= $Page->goods_inward->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_details->Visible) { // invoice_details ?>
        <td data-name="invoice_details"<?= $Page->invoice_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_invoice_details" class="el_purchase_l_audit_invoice_details">
<span<?= $Page->invoice_details->viewAttributes() ?>>
<?php if (!EmptyString($Page->invoice_details->getViewValue()) && $Page->invoice_details->linkAttributes() != "") { ?>
<a<?= $Page->invoice_details->linkAttributes() ?>><?= $Page->invoice_details->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->invoice_details->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_dated->Visible) { // invoice_dated ?>
        <td data-name="invoice_dated"<?= $Page->invoice_dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_invoice_dated" class="el_purchase_l_audit_invoice_dated">
<span<?= $Page->invoice_dated->viewAttributes() ?>>
<?php if (!EmptyString($Page->invoice_dated->getViewValue()) && $Page->invoice_dated->linkAttributes() != "") { ?>
<a<?= $Page->invoice_dated->linkAttributes() ?>><?= $Page->invoice_dated->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->invoice_dated->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->return_details->Visible) { // return_details ?>
        <td data-name="return_details"<?= $Page->return_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_return_details" class="el_purchase_l_audit_return_details">
<span<?= $Page->return_details->viewAttributes() ?>>
<?= $Page->return_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_operator" class="el_purchase_l_audit_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_datetime" class="el_purchase_l_audit_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_remarks" class="el_purchase_l_audit_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->audit->Visible) { // audit ?>
        <td data-name="audit"<?= $Page->audit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_audit" class="el_purchase_l_audit_audit">
<span<?= $Page->audit->viewAttributes() ?>>
<?= $Page->audit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_operator->Visible) { // a_operator ?>
        <td data-name="a_operator"<?= $Page->a_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_a_operator" class="el_purchase_l_audit_a_operator">
<span<?= $Page->a_operator->viewAttributes() ?>>
<?= $Page->a_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <td data-name="a_datetime"<?= $Page->a_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_l_audit_a_datetime" class="el_purchase_l_audit_a_datetime">
<span<?= $Page->a_datetime->viewAttributes() ?>>
<?= $Page->a_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_purchase_l_audit_id" class="purchase_l_audit_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type" class="<?= $Page->type->footerCellClass() ?>"><span id="elf_purchase_l_audit_type" class="purchase_l_audit_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_purchase_l_audit_company_id" class="purchase_l_audit_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->supplier->Visible) { // supplier ?>
        <td data-name="supplier" class="<?= $Page->supplier->footerCellClass() ?>"><span id="elf_purchase_l_audit_supplier" class="purchase_l_audit_supplier">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_purchase_l_audit_rid" class="purchase_l_audit_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no" class="<?= $Page->lot_no->footerCellClass() ?>"><span id="elf_purchase_l_audit_lot_no" class="purchase_l_audit_lot_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->_barcode->Visible) { // barcode ?>
        <td data-name="_barcode" class="<?= $Page->_barcode->footerCellClass() ?>"><span id="elf_purchase_l_audit__barcode" class="purchase_l_audit__barcode">
        </span></td>
    <?php } ?>
    <?php if ($Page->net_weight->Visible) { // net_weight ?>
        <td data-name="net_weight" class="<?= $Page->net_weight->footerCellClass() ?>"><span id="elf_purchase_l_audit_net_weight" class="purchase_l_audit_net_weight">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->net_weight->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets" class="<?= $Page->packets->footerCellClass() ?>"><span id="elf_purchase_l_audit_packets" class="purchase_l_audit_packets">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->packets->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_purchase_l_audit_packing_type" class="purchase_l_audit_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_purchase_l_audit_amount" class="purchase_l_audit_amount">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->amount->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown" class="<?= $Page->godown->footerCellClass() ?>"><span id="elf_purchase_l_audit_godown" class="purchase_l_audit_godown">
        </span></td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated" class="<?= $Page->dated->footerCellClass() ?>"><span id="elf_purchase_l_audit_dated" class="purchase_l_audit_dated">
        </span></td>
    <?php } ?>
    <?php if ($Page->goods_inward->Visible) { // goods_inward ?>
        <td data-name="goods_inward" class="<?= $Page->goods_inward->footerCellClass() ?>"><span id="elf_purchase_l_audit_goods_inward" class="purchase_l_audit_goods_inward">
        </span></td>
    <?php } ?>
    <?php if ($Page->invoice_details->Visible) { // invoice_details ?>
        <td data-name="invoice_details" class="<?= $Page->invoice_details->footerCellClass() ?>"><span id="elf_purchase_l_audit_invoice_details" class="purchase_l_audit_invoice_details">
        </span></td>
    <?php } ?>
    <?php if ($Page->invoice_dated->Visible) { // invoice_dated ?>
        <td data-name="invoice_dated" class="<?= $Page->invoice_dated->footerCellClass() ?>"><span id="elf_purchase_l_audit_invoice_dated" class="purchase_l_audit_invoice_dated">
        </span></td>
    <?php } ?>
    <?php if ($Page->return_details->Visible) { // return_details ?>
        <td data-name="return_details" class="<?= $Page->return_details->footerCellClass() ?>"><span id="elf_purchase_l_audit_return_details" class="purchase_l_audit_return_details">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_purchase_l_audit_operator" class="purchase_l_audit_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_purchase_l_audit_datetime" class="purchase_l_audit_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks" class="<?= $Page->remarks->footerCellClass() ?>"><span id="elf_purchase_l_audit_remarks" class="purchase_l_audit_remarks">
        </span></td>
    <?php } ?>
    <?php if ($Page->audit->Visible) { // audit ?>
        <td data-name="audit" class="<?= $Page->audit->footerCellClass() ?>"><span id="elf_purchase_l_audit_audit" class="purchase_l_audit_audit">
        </span></td>
    <?php } ?>
    <?php if ($Page->a_operator->Visible) { // a_operator ?>
        <td data-name="a_operator" class="<?= $Page->a_operator->footerCellClass() ?>"><span id="elf_purchase_l_audit_a_operator" class="purchase_l_audit_a_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->a_datetime->Visible) { // a_datetime ?>
        <td data-name="a_datetime" class="<?= $Page->a_datetime->footerCellClass() ?>"><span id="elf_purchase_l_audit_a_datetime" class="purchase_l_audit_a_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_l_audit");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
