<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseASearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_a: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fpurchase_asearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_asearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["supplier", [], fields.supplier.isInvalid],
            ["booking_reference", [], fields.booking_reference.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["gross_weight", [ew.Validators.float], fields.gross_weight.isInvalid],
            ["net_weight", [ew.Validators.float], fields.net_weight.isInvalid],
            ["y_net_weight", [ew.Validators.between], false],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["y_packets", [ew.Validators.between], false],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["containers", [ew.Validators.float], fields.containers.isInvalid],
            ["y_containers", [ew.Validators.between], false],
            ["shipping_line", [], fields.shipping_line.isInvalid],
            ["port_arrival_date", [ew.Validators.datetime(fields.port_arrival_date.clientFormatPattern)], fields.port_arrival_date.isInvalid],
            ["y_port_arrival_date", [ew.Validators.between], false],
            ["godown_arrival_date", [ew.Validators.datetime(fields.godown_arrival_date.clientFormatPattern)], fields.godown_arrival_date.isInvalid],
            ["y_godown_arrival_date", [ew.Validators.between], false],
            ["godown", [], fields.godown.isInvalid],
            ["rack", [], fields.rack.isInvalid],
            ["invoice_details", [], fields.invoice_details.isInvalid],
            ["invoice_value", [ew.Validators.float], fields.invoice_value.isInvalid],
            ["currency_rate", [ew.Validators.float], fields.currency_rate.isInvalid],
            ["purchase_amount_inr", [ew.Validators.float], fields.purchase_amount_inr.isInvalid],
            ["y_purchase_amount_inr", [ew.Validators.between], false],
            ["duty_paid_by", [], fields.duty_paid_by.isInvalid],
            ["custom_duty", [ew.Validators.float], fields.custom_duty.isInvalid],
            ["transportation_charges", [ew.Validators.float], fields.transportation_charges.isInvalid],
            ["port_clearing_charge", [ew.Validators.float], fields.port_clearing_charge.isInvalid],
            ["cha_commission", [ew.Validators.float], fields.cha_commission.isInvalid],
            ["cha_agent", [], fields.cha_agent.isInvalid],
            ["clearance_bank", [], fields.clearance_bank.isInvalid],
            ["bank_charges", [], fields.bank_charges.isInvalid],
            ["importer", [], fields.importer.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["fiba_fibd", [], fields.fiba_fibd.isInvalid],
            ["fibc", [], fields.fibc.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "booking_reference": <?= $Page->booking_reference->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "shipping_line": <?= $Page->shipping_line->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "duty_paid_by": <?= $Page->duty_paid_by->toClientList($Page) ?>,
            "cha_agent": <?= $Page->cha_agent->toClientList($Page) ?>,
            "clearance_bank": <?= $Page->clearance_bank->toClientList($Page) ?>,
            "importer": <?= $Page->importer->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fpurchase_asearch" id="fpurchase_asearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="purchase_a" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier" class="row"<?= $Page->supplier->rowAttributes() ?>>
        <label for="x_supplier" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_supplier"><?= $Page->supplier->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->supplier->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_supplier" class="ew-search-field ew-search-field-single">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_supplier"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_supplier", selectId: "fpurchase_asearch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->booking_reference->Visible) { // booking_reference ?>
    <div id="r_booking_reference" class="row"<?= $Page->booking_reference->rowAttributes() ?>>
        <label for="x_booking_reference" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_booking_reference"><?= $Page->booking_reference->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_booking_reference" id="z_booking_reference" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->booking_reference->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_booking_reference" class="ew-search-field ew-search-field-single">
    <select
        id="x_booking_reference"
        name="x_booking_reference"
        class="form-select ew-select<?= $Page->booking_reference->isInvalidClass() ?>"
        <?php if (!$Page->booking_reference->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_booking_reference"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_booking_reference"
        data-value-separator="<?= $Page->booking_reference->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->booking_reference->getPlaceHolder()) ?>"
        <?= $Page->booking_reference->editAttributes() ?>>
        <?= $Page->booking_reference->selectOptionListHtml("x_booking_reference") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->booking_reference->getErrorMessage(false) ?></div>
<?= $Page->booking_reference->Lookup->getParamTag($Page, "p_x_booking_reference") ?>
<?php if (!$Page->booking_reference->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_booking_reference", selectId: "fpurchase_asearch_x_booking_reference" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.booking_reference?.lookupOptions.length) {
        options.data = { id: "x_booking_reference", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_booking_reference", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.booking_reference.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="purchase_a" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gross_weight->Visible) { // gross_weight ?>
    <div id="r_gross_weight" class="row"<?= $Page->gross_weight->rowAttributes() ?>>
        <label for="x_gross_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_gross_weight"><?= $Page->gross_weight->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gross_weight" id="z_gross_weight" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gross_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_gross_weight" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->gross_weight->getInputTextType() ?>" name="x_gross_weight" id="x_gross_weight" data-table="purchase_a" data-field="x_gross_weight" value="<?= $Page->gross_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gross_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gross_weight->formatPattern()) ?>"<?= $Page->gross_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->gross_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight" class="row"<?= $Page->net_weight->rowAttributes() ?>>
        <label for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_net_weight"><?= $Page->net_weight->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->net_weight->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_net_weight" id="z_net_weight" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->net_weight->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->net_weight->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_net_weight" class="ew-search-field">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_a" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_net_weight" class="ew-search-field2 d-none">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="y_net_weight" id="y_net_weight" data-table="purchase_a" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_packets"><?= $Page->packets->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_packets" id="z_packets" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->packets->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->packets->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_packets" class="ew-search-field">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_a" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_packets" class="ew-search-field2 d-none">
<input type="<?= $Page->packets->getInputTextType() ?>" name="y_packets" id="y_packets" data-table="purchase_a" data-field="x_packets" value="<?= $Page->packets->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_packing_type"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_asearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->containers->Visible) { // containers ?>
    <div id="r_containers" class="row"<?= $Page->containers->rowAttributes() ?>>
        <label for="x_containers" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_containers"><?= $Page->containers->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->containers->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_containers" id="z_containers" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->containers->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->containers->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_containers" class="ew-search-field">
<input type="<?= $Page->containers->getInputTextType() ?>" name="x_containers" id="x_containers" data-table="purchase_a" data-field="x_containers" value="<?= $Page->containers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->containers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containers->formatPattern()) ?>"<?= $Page->containers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->containers->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_containers" class="ew-search-field2 d-none">
<input type="<?= $Page->containers->getInputTextType() ?>" name="y_containers" id="y_containers" data-table="purchase_a" data-field="x_containers" value="<?= $Page->containers->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->containers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containers->formatPattern()) ?>"<?= $Page->containers->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->containers->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipping_line->Visible) { // shipping_line ?>
    <div id="r_shipping_line" class="row"<?= $Page->shipping_line->rowAttributes() ?>>
        <label for="x_shipping_line" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_shipping_line"><?= $Page->shipping_line->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shipping_line" id="z_shipping_line" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_line->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_shipping_line" class="ew-search-field ew-search-field-single">
    <select
        id="x_shipping_line"
        name="x_shipping_line"
        class="form-select ew-select<?= $Page->shipping_line->isInvalidClass() ?>"
        <?php if (!$Page->shipping_line->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_shipping_line"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_shipping_line"
        data-value-separator="<?= $Page->shipping_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipping_line->getPlaceHolder()) ?>"
        <?= $Page->shipping_line->editAttributes() ?>>
        <?= $Page->shipping_line->selectOptionListHtml("x_shipping_line") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shipping_line->getErrorMessage(false) ?></div>
<?= $Page->shipping_line->Lookup->getParamTag($Page, "p_x_shipping_line") ?>
<?php if (!$Page->shipping_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_shipping_line", selectId: "fpurchase_asearch_x_shipping_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.shipping_line?.lookupOptions.length) {
        options.data = { id: "x_shipping_line", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_shipping_line", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.shipping_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_arrival_date->Visible) { // port_arrival_date ?>
    <div id="r_port_arrival_date" class="row"<?= $Page->port_arrival_date->rowAttributes() ?>>
        <label for="x_port_arrival_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_port_arrival_date"><?= $Page->port_arrival_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_arrival_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_port_arrival_date" id="z_port_arrival_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->port_arrival_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->port_arrival_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_port_arrival_date" class="ew-search-field">
<input type="<?= $Page->port_arrival_date->getInputTextType() ?>" name="x_port_arrival_date" id="x_port_arrival_date" data-table="purchase_a" data-field="x_port_arrival_date" value="<?= $Page->port_arrival_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->port_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_arrival_date->formatPattern()) ?>"<?= $Page->port_arrival_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_arrival_date->getErrorMessage(false) ?></div>
<?php if (!$Page->port_arrival_date->ReadOnly && !$Page->port_arrival_date->Disabled && !isset($Page->port_arrival_date->EditAttrs["readonly"]) && !isset($Page->port_arrival_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_asearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_asearch", "x_port_arrival_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_port_arrival_date" class="ew-search-field2 d-none">
<input type="<?= $Page->port_arrival_date->getInputTextType() ?>" name="y_port_arrival_date" id="y_port_arrival_date" data-table="purchase_a" data-field="x_port_arrival_date" value="<?= $Page->port_arrival_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->port_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_arrival_date->formatPattern()) ?>"<?= $Page->port_arrival_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_arrival_date->getErrorMessage(false) ?></div>
<?php if (!$Page->port_arrival_date->ReadOnly && !$Page->port_arrival_date->Disabled && !isset($Page->port_arrival_date->EditAttrs["readonly"]) && !isset($Page->port_arrival_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_asearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_asearch", "y_port_arrival_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown_arrival_date->Visible) { // godown_arrival_date ?>
    <div id="r_godown_arrival_date" class="row"<?= $Page->godown_arrival_date->rowAttributes() ?>>
        <label for="x_godown_arrival_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_godown_arrival_date"><?= $Page->godown_arrival_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown_arrival_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_godown_arrival_date" id="z_godown_arrival_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->godown_arrival_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->godown_arrival_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_godown_arrival_date" class="ew-search-field">
<input type="<?= $Page->godown_arrival_date->getInputTextType() ?>" name="x_godown_arrival_date" id="x_godown_arrival_date" data-table="purchase_a" data-field="x_godown_arrival_date" value="<?= $Page->godown_arrival_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->godown_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown_arrival_date->formatPattern()) ?>"<?= $Page->godown_arrival_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->godown_arrival_date->getErrorMessage(false) ?></div>
<?php if (!$Page->godown_arrival_date->ReadOnly && !$Page->godown_arrival_date->Disabled && !isset($Page->godown_arrival_date->EditAttrs["readonly"]) && !isset($Page->godown_arrival_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_asearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_asearch", "x_godown_arrival_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_godown_arrival_date" class="ew-search-field2 d-none">
<input type="<?= $Page->godown_arrival_date->getInputTextType() ?>" name="y_godown_arrival_date" id="y_godown_arrival_date" data-table="purchase_a" data-field="x_godown_arrival_date" value="<?= $Page->godown_arrival_date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->godown_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown_arrival_date->formatPattern()) ?>"<?= $Page->godown_arrival_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->godown_arrival_date->getErrorMessage(false) ?></div>
<?php if (!$Page->godown_arrival_date->ReadOnly && !$Page->godown_arrival_date->Disabled && !isset($Page->godown_arrival_date->EditAttrs["readonly"]) && !isset($Page->godown_arrival_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_asearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_asearch", "y_godown_arrival_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_godown"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_godown", selectId: "fpurchase_asearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
    <div id="r_rack" class="row"<?= $Page->rack->rowAttributes() ?>>
        <label for="x_rack" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_rack"><?= $Page->rack->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rack" id="z_rack" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rack->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_rack" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_a" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
    <div id="r_invoice_details" class="row"<?= $Page->invoice_details->rowAttributes() ?>>
        <label for="x_invoice_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_invoice_details"><?= $Page->invoice_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_details" id="z_invoice_details" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_invoice_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_a" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_value->Visible) { // invoice_value ?>
    <div id="r_invoice_value" class="row"<?= $Page->invoice_value->rowAttributes() ?>>
        <label for="x_invoice_value" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_invoice_value"><?= $Page->invoice_value->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_value" id="z_invoice_value" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_value->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_invoice_value" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_value->getInputTextType() ?>" name="x_invoice_value" id="x_invoice_value" data-table="purchase_a" data-field="x_invoice_value" value="<?= $Page->invoice_value->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->invoice_value->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_value->formatPattern()) ?>"<?= $Page->invoice_value->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_value->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency_rate->Visible) { // currency_rate ?>
    <div id="r_currency_rate" class="row"<?= $Page->currency_rate->rowAttributes() ?>>
        <label for="x_currency_rate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_currency_rate"><?= $Page->currency_rate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency_rate" id="z_currency_rate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency_rate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_currency_rate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->currency_rate->getInputTextType() ?>" name="x_currency_rate" id="x_currency_rate" data-table="purchase_a" data-field="x_currency_rate" value="<?= $Page->currency_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_rate->formatPattern()) ?>"<?= $Page->currency_rate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->currency_rate->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
    <div id="r_purchase_amount_inr" class="row"<?= $Page->purchase_amount_inr->rowAttributes() ?>>
        <label for="x_purchase_amount_inr" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_purchase_amount_inr"><?= $Page->purchase_amount_inr->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->purchase_amount_inr->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_purchase_amount_inr" id="z_purchase_amount_inr" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->purchase_amount_inr->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->purchase_amount_inr->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_purchase_amount_inr" class="ew-search-field">
<input type="<?= $Page->purchase_amount_inr->getInputTextType() ?>" name="x_purchase_amount_inr" id="x_purchase_amount_inr" data-table="purchase_a" data-field="x_purchase_amount_inr" value="<?= $Page->purchase_amount_inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->purchase_amount_inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->purchase_amount_inr->formatPattern()) ?>"<?= $Page->purchase_amount_inr->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->purchase_amount_inr->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_purchase_amount_inr" class="ew-search-field2 d-none">
<input type="<?= $Page->purchase_amount_inr->getInputTextType() ?>" name="y_purchase_amount_inr" id="y_purchase_amount_inr" data-table="purchase_a" data-field="x_purchase_amount_inr" value="<?= $Page->purchase_amount_inr->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->purchase_amount_inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->purchase_amount_inr->formatPattern()) ?>"<?= $Page->purchase_amount_inr->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->purchase_amount_inr->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->duty_paid_by->Visible) { // duty_paid_by ?>
    <div id="r_duty_paid_by" class="row"<?= $Page->duty_paid_by->rowAttributes() ?>>
        <label for="x_duty_paid_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_duty_paid_by"><?= $Page->duty_paid_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_duty_paid_by" id="z_duty_paid_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->duty_paid_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_duty_paid_by" class="ew-search-field ew-search-field-single">
    <select
        id="x_duty_paid_by"
        name="x_duty_paid_by"
        class="form-select ew-select<?= $Page->duty_paid_by->isInvalidClass() ?>"
        <?php if (!$Page->duty_paid_by->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_duty_paid_by"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_duty_paid_by"
        data-value-separator="<?= $Page->duty_paid_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->duty_paid_by->getPlaceHolder()) ?>"
        <?= $Page->duty_paid_by->editAttributes() ?>>
        <?= $Page->duty_paid_by->selectOptionListHtml("x_duty_paid_by") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->duty_paid_by->getErrorMessage(false) ?></div>
<?php if (!$Page->duty_paid_by->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_duty_paid_by", selectId: "fpurchase_asearch_x_duty_paid_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.duty_paid_by?.lookupOptions.length) {
        options.data = { id: "x_duty_paid_by", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_duty_paid_by", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.duty_paid_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->custom_duty->Visible) { // custom_duty ?>
    <div id="r_custom_duty" class="row"<?= $Page->custom_duty->rowAttributes() ?>>
        <label for="x_custom_duty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_custom_duty"><?= $Page->custom_duty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_custom_duty" id="z_custom_duty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->custom_duty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_custom_duty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->custom_duty->getInputTextType() ?>" name="x_custom_duty" id="x_custom_duty" data-table="purchase_a" data-field="x_custom_duty" value="<?= $Page->custom_duty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_duty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_duty->formatPattern()) ?>"<?= $Page->custom_duty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->custom_duty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transportation_charges->Visible) { // transportation_charges ?>
    <div id="r_transportation_charges" class="row"<?= $Page->transportation_charges->rowAttributes() ?>>
        <label for="x_transportation_charges" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_transportation_charges"><?= $Page->transportation_charges->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_transportation_charges" id="z_transportation_charges" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transportation_charges->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_transportation_charges" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->transportation_charges->getInputTextType() ?>" name="x_transportation_charges" id="x_transportation_charges" data-table="purchase_a" data-field="x_transportation_charges" value="<?= $Page->transportation_charges->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transportation_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transportation_charges->formatPattern()) ?>"<?= $Page->transportation_charges->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transportation_charges->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->port_clearing_charge->Visible) { // port_clearing_charge ?>
    <div id="r_port_clearing_charge" class="row"<?= $Page->port_clearing_charge->rowAttributes() ?>>
        <label for="x_port_clearing_charge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_port_clearing_charge"><?= $Page->port_clearing_charge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_port_clearing_charge" id="z_port_clearing_charge" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->port_clearing_charge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_port_clearing_charge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->port_clearing_charge->getInputTextType() ?>" name="x_port_clearing_charge" id="x_port_clearing_charge" data-table="purchase_a" data-field="x_port_clearing_charge" value="<?= $Page->port_clearing_charge->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->port_clearing_charge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_clearing_charge->formatPattern()) ?>"<?= $Page->port_clearing_charge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->port_clearing_charge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cha_commission->Visible) { // cha_commission ?>
    <div id="r_cha_commission" class="row"<?= $Page->cha_commission->rowAttributes() ?>>
        <label for="x_cha_commission" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_cha_commission"><?= $Page->cha_commission->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cha_commission" id="z_cha_commission" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cha_commission->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_cha_commission" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cha_commission->getInputTextType() ?>" name="x_cha_commission" id="x_cha_commission" data-table="purchase_a" data-field="x_cha_commission" value="<?= $Page->cha_commission->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cha_commission->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cha_commission->formatPattern()) ?>"<?= $Page->cha_commission->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cha_commission->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cha_agent->Visible) { // cha_agent ?>
    <div id="r_cha_agent" class="row"<?= $Page->cha_agent->rowAttributes() ?>>
        <label for="x_cha_agent" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_cha_agent"><?= $Page->cha_agent->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cha_agent" id="z_cha_agent" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cha_agent->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_cha_agent" class="ew-search-field ew-search-field-single">
    <select
        id="x_cha_agent"
        name="x_cha_agent"
        class="form-select ew-select<?= $Page->cha_agent->isInvalidClass() ?>"
        <?php if (!$Page->cha_agent->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_cha_agent"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_cha_agent"
        data-value-separator="<?= $Page->cha_agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cha_agent->getPlaceHolder()) ?>"
        <?= $Page->cha_agent->editAttributes() ?>>
        <?= $Page->cha_agent->selectOptionListHtml("x_cha_agent") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->cha_agent->getErrorMessage(false) ?></div>
<?= $Page->cha_agent->Lookup->getParamTag($Page, "p_x_cha_agent") ?>
<?php if (!$Page->cha_agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_cha_agent", selectId: "fpurchase_asearch_x_cha_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.cha_agent?.lookupOptions.length) {
        options.data = { id: "x_cha_agent", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_cha_agent", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.cha_agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->clearance_bank->Visible) { // clearance_bank ?>
    <div id="r_clearance_bank" class="row"<?= $Page->clearance_bank->rowAttributes() ?>>
        <label for="x_clearance_bank" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_clearance_bank"><?= $Page->clearance_bank->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_clearance_bank" id="z_clearance_bank" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->clearance_bank->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_clearance_bank" class="ew-search-field ew-search-field-single">
    <select
        id="x_clearance_bank"
        name="x_clearance_bank"
        class="form-select ew-select<?= $Page->clearance_bank->isInvalidClass() ?>"
        <?php if (!$Page->clearance_bank->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_clearance_bank"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_clearance_bank"
        data-value-separator="<?= $Page->clearance_bank->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->clearance_bank->getPlaceHolder()) ?>"
        <?= $Page->clearance_bank->editAttributes() ?>>
        <?= $Page->clearance_bank->selectOptionListHtml("x_clearance_bank") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->clearance_bank->getErrorMessage(false) ?></div>
<?= $Page->clearance_bank->Lookup->getParamTag($Page, "p_x_clearance_bank") ?>
<?php if (!$Page->clearance_bank->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_clearance_bank", selectId: "fpurchase_asearch_x_clearance_bank" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.clearance_bank?.lookupOptions.length) {
        options.data = { id: "x_clearance_bank", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_clearance_bank", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.clearance_bank.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_charges->Visible) { // bank_charges ?>
    <div id="r_bank_charges" class="row"<?= $Page->bank_charges->rowAttributes() ?>>
        <label for="x_bank_charges" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_bank_charges"><?= $Page->bank_charges->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_bank_charges" id="z_bank_charges" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_charges->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_bank_charges" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_charges->getInputTextType() ?>" name="x_bank_charges" id="x_bank_charges" data-table="purchase_a" data-field="x_bank_charges" value="<?= $Page->bank_charges->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bank_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_charges->formatPattern()) ?>"<?= $Page->bank_charges->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_charges->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->importer->Visible) { // importer ?>
    <div id="r_importer" class="row"<?= $Page->importer->rowAttributes() ?>>
        <label for="x_importer" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_importer"><?= $Page->importer->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_importer" id="z_importer" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->importer->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_importer" class="ew-search-field ew-search-field-single">
    <select
        id="x_importer"
        name="x_importer"
        class="form-select ew-select<?= $Page->importer->isInvalidClass() ?>"
        <?php if (!$Page->importer->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_importer"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_importer"
        data-value-separator="<?= $Page->importer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->importer->getPlaceHolder()) ?>"
        <?= $Page->importer->editAttributes() ?>>
        <?= $Page->importer->selectOptionListHtml("x_importer") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->importer->getErrorMessage(false) ?></div>
<?= $Page->importer->Lookup->getParamTag($Page, "p_x_importer") ?>
<?php if (!$Page->importer->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_importer", selectId: "fpurchase_asearch_x_importer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.importer?.lookupOptions.length) {
        options.data = { id: "x_importer", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_importer", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.importer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="purchase_a" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fiba_fibd->Visible) { // fiba_fibd ?>
    <div id="r_fiba_fibd" class="row"<?= $Page->fiba_fibd->rowAttributes() ?>>
        <label for="x_fiba_fibd" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_fiba_fibd"><?= $Page->fiba_fibd->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_fiba_fibd" id="z_fiba_fibd" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fiba_fibd->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_fiba_fibd" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fiba_fibd->getInputTextType() ?>" name="x_fiba_fibd" id="x_fiba_fibd" data-table="purchase_a" data-field="x_fiba_fibd" value="<?= $Page->fiba_fibd->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->fiba_fibd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fiba_fibd->formatPattern()) ?>"<?= $Page->fiba_fibd->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fiba_fibd->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fibc->Visible) { // fibc ?>
    <div id="r_fibc" class="row"<?= $Page->fibc->rowAttributes() ?>>
        <label for="x_fibc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_fibc"><?= $Page->fibc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_fibc" id="z_fibc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fibc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_fibc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fibc->getInputTextType() ?>" name="x_fibc" id="x_fibc" data-table="purchase_a" data-field="x_fibc" value="<?= $Page->fibc->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->fibc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fibc->formatPattern()) ?>"<?= $Page->fibc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fibc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_purchase_a_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asearch_x_operator"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asearch", function() {
    var options = { name: "x_operator", selectId: "fpurchase_asearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fpurchase_asearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fpurchase_asearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_purchase_a_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_purchase_a_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="purchase_a" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_purchase_a_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="purchase_a" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpurchase_asearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_asearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fpurchase_asearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_a");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
