<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseAList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_a: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fpurchase_asrch" id="fpurchase_asrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fpurchase_asrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_a: currentTable } });
var currentForm;
var fpurchase_asrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fpurchase_asrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["supplier", [], fields.supplier.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["packets", [ew.Validators.integer], fields.packets.isInvalid],
            ["y_packets", [ew.Validators.between], false],
            ["godown", [], fields.godown.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "supplier": <?= $Page->supplier->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->supplier->Visible) { // supplier ?>
<?php
if (!$Page->supplier->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_supplier" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->supplier->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_supplier" class="ew-search-caption ew-label"><?= $Page->supplier->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_supplier" id="z_supplier" value="=">
</div>
        </div>
        <div id="el_purchase_a_supplier" class="ew-search-field">
    <select
        id="x_supplier"
        name="x_supplier"
        class="form-select ew-select<?= $Page->supplier->isInvalidClass() ?>"
        <?php if (!$Page->supplier->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asrch_x_supplier"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_supplier"
        data-value-separator="<?= $Page->supplier->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->supplier->getPlaceHolder()) ?>"
        <?= $Page->supplier->editAttributes() ?>>
        <?= $Page->supplier->selectOptionListHtml("x_supplier") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->supplier->getErrorMessage(false) ?></div>
<?= $Page->supplier->Lookup->getParamTag($Page, "p_x_supplier") ?>
<?php if (!$Page->supplier->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asrch", function() {
    var options = { name: "x_supplier", selectId: "fpurchase_asrch_x_supplier" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asrch.lists.supplier?.lookupOptions.length) {
        options.data = { id: "x_supplier", form: "fpurchase_asrch" };
    } else {
        options.ajax = { id: "x_supplier", form: "fpurchase_asrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.supplier.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
<?php
if (!$Page->lot_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_lot_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->lot_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_lot_no" class="ew-search-caption ew-label"><?= $Page->lot_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="=">
</div>
        </div>
        <div id="el_purchase_a_lot_no" class="ew-search-field">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="purchase_a" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
<?php
if (!$Page->packets->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_packets" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->packets->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_packets" class="ew-search-caption ew-label"><?= $Page->packets->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_packets" id="z_packets" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->packets->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->packets->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_purchase_a_packets" class="ew-search-field">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_a" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_purchase_a_packets" class="ew-search-field2 d-none">
<input type="<?= $Page->packets->getInputTextType() ?>" name="y_packets" id="y_packets" data-table="purchase_a" data-field="x_packets" value="<?= $Page->packets->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
<?php
if (!$Page->godown->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_godown" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->godown->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_godown" class="ew-search-caption ew-label"><?= $Page->godown->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</div>
        </div>
        <div id="el_purchase_a_godown" class="ew-search-field">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_asrch_x_godown"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_asrch", function() {
    var options = { name: "x_godown", selectId: "fpurchase_asrch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_asrch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_asrch" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_asrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fpurchase_asrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fpurchase_asrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fpurchase_asrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fpurchase_asrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fpurchase_asrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fpurchase_asrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fpurchase_asrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_purchase_a" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_purchase_alist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_purchase_a_id" class="purchase_a_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
        <th data-name="supplier" class="<?= $Page->supplier->headerCellClass() ?>"><div id="elh_purchase_a_supplier" class="purchase_a_supplier"><?= $Page->renderFieldHeader($Page->supplier) ?></div></th>
<?php } ?>
<?php if ($Page->booking_reference->Visible) { // booking_reference ?>
        <th data-name="booking_reference" class="<?= $Page->booking_reference->headerCellClass() ?>"><div id="elh_purchase_a_booking_reference" class="purchase_a_booking_reference"><?= $Page->renderFieldHeader($Page->booking_reference) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_a_rid" class="purchase_a_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_purchase_a_lot_no" class="purchase_a_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
        <th data-name="net_weight" class="<?= $Page->net_weight->headerCellClass() ?>"><div id="elh_purchase_a_net_weight" class="purchase_a_net_weight"><?= $Page->renderFieldHeader($Page->net_weight) ?></div></th>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Page->packets->headerCellClass() ?>"><div id="elh_purchase_a_packets" class="purchase_a_packets"><?= $Page->renderFieldHeader($Page->packets) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_purchase_a_packing_type" class="purchase_a_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->containers->Visible) { // containers ?>
        <th data-name="containers" class="<?= $Page->containers->headerCellClass() ?>"><div id="elh_purchase_a_containers" class="purchase_a_containers"><?= $Page->renderFieldHeader($Page->containers) ?></div></th>
<?php } ?>
<?php if ($Page->godown_arrival_date->Visible) { // godown_arrival_date ?>
        <th data-name="godown_arrival_date" class="<?= $Page->godown_arrival_date->headerCellClass() ?>"><div id="elh_purchase_a_godown_arrival_date" class="purchase_a_godown_arrival_date"><?= $Page->renderFieldHeader($Page->godown_arrival_date) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_purchase_a_godown" class="purchase_a_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
        <th data-name="rack" class="<?= $Page->rack->headerCellClass() ?>"><div id="elh_purchase_a_rack" class="purchase_a_rack"><?= $Page->renderFieldHeader($Page->rack) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
        <th data-name="invoice_details" class="<?= $Page->invoice_details->headerCellClass() ?>"><div id="elh_purchase_a_invoice_details" class="purchase_a_invoice_details"><?= $Page->renderFieldHeader($Page->invoice_details) ?></div></th>
<?php } ?>
<?php if ($Page->invoice_value->Visible) { // invoice_value ?>
        <th data-name="invoice_value" class="<?= $Page->invoice_value->headerCellClass() ?>"><div id="elh_purchase_a_invoice_value" class="purchase_a_invoice_value"><?= $Page->renderFieldHeader($Page->invoice_value) ?></div></th>
<?php } ?>
<?php if ($Page->currency_rate->Visible) { // currency_rate ?>
        <th data-name="currency_rate" class="<?= $Page->currency_rate->headerCellClass() ?>"><div id="elh_purchase_a_currency_rate" class="purchase_a_currency_rate"><?= $Page->renderFieldHeader($Page->currency_rate) ?></div></th>
<?php } ?>
<?php if ($Page->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
        <th data-name="purchase_amount_inr" class="<?= $Page->purchase_amount_inr->headerCellClass() ?>"><div id="elh_purchase_a_purchase_amount_inr" class="purchase_a_purchase_amount_inr"><?= $Page->renderFieldHeader($Page->purchase_amount_inr) ?></div></th>
<?php } ?>
<?php if ($Page->duty_paid_by->Visible) { // duty_paid_by ?>
        <th data-name="duty_paid_by" class="<?= $Page->duty_paid_by->headerCellClass() ?>"><div id="elh_purchase_a_duty_paid_by" class="purchase_a_duty_paid_by"><?= $Page->renderFieldHeader($Page->duty_paid_by) ?></div></th>
<?php } ?>
<?php if ($Page->custom_duty->Visible) { // custom_duty ?>
        <th data-name="custom_duty" class="<?= $Page->custom_duty->headerCellClass() ?>"><div id="elh_purchase_a_custom_duty" class="purchase_a_custom_duty"><?= $Page->renderFieldHeader($Page->custom_duty) ?></div></th>
<?php } ?>
<?php if ($Page->port_clearing_charge->Visible) { // port_clearing_charge ?>
        <th data-name="port_clearing_charge" class="<?= $Page->port_clearing_charge->headerCellClass() ?>"><div id="elh_purchase_a_port_clearing_charge" class="purchase_a_port_clearing_charge"><?= $Page->renderFieldHeader($Page->port_clearing_charge) ?></div></th>
<?php } ?>
<?php if ($Page->cha_commission->Visible) { // cha_commission ?>
        <th data-name="cha_commission" class="<?= $Page->cha_commission->headerCellClass() ?>"><div id="elh_purchase_a_cha_commission" class="purchase_a_cha_commission"><?= $Page->renderFieldHeader($Page->cha_commission) ?></div></th>
<?php } ?>
<?php if ($Page->cha_agent->Visible) { // cha_agent ?>
        <th data-name="cha_agent" class="<?= $Page->cha_agent->headerCellClass() ?>"><div id="elh_purchase_a_cha_agent" class="purchase_a_cha_agent"><?= $Page->renderFieldHeader($Page->cha_agent) ?></div></th>
<?php } ?>
<?php if ($Page->bank_charges->Visible) { // bank_charges ?>
        <th data-name="bank_charges" class="<?= $Page->bank_charges->headerCellClass() ?>"><div id="elh_purchase_a_bank_charges" class="purchase_a_bank_charges"><?= $Page->renderFieldHeader($Page->bank_charges) ?></div></th>
<?php } ?>
<?php if ($Page->importer->Visible) { // importer ?>
        <th data-name="importer" class="<?= $Page->importer->headerCellClass() ?>"><div id="elh_purchase_a_importer" class="purchase_a_importer"><?= $Page->renderFieldHeader($Page->importer) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_purchase_a_remarks" class="purchase_a_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->fiba_fibd->Visible) { // fiba_fibd ?>
        <th data-name="fiba_fibd" class="<?= $Page->fiba_fibd->headerCellClass() ?>"><div id="elh_purchase_a_fiba_fibd" class="purchase_a_fiba_fibd"><?= $Page->renderFieldHeader($Page->fiba_fibd) ?></div></th>
<?php } ?>
<?php if ($Page->fibc->Visible) { // fibc ?>
        <th data-name="fibc" class="<?= $Page->fibc->headerCellClass() ?>"><div id="elh_purchase_a_fibc" class="purchase_a_fibc"><?= $Page->renderFieldHeader($Page->fibc) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_purchase_a_operator" class="purchase_a_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_purchase_a_datetime" class="purchase_a_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
        <th data-name="rbi_compliance_date" class="<?= $Page->rbi_compliance_date->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_purchase_a_rbi_compliance_date" class="purchase_a_rbi_compliance_date"><?= $Page->renderFieldHeader($Page->rbi_compliance_date) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_id" class="el_purchase_a_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->supplier->Visible) { // supplier ?>
        <td data-name="supplier"<?= $Page->supplier->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_supplier" class="el_purchase_a_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Page->supplier->getViewValue()) && $Page->supplier->linkAttributes() != "") { ?>
<a<?= $Page->supplier->linkAttributes() ?>><?= $Page->supplier->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->supplier->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->booking_reference->Visible) { // booking_reference ?>
        <td data-name="booking_reference"<?= $Page->booking_reference->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_booking_reference" class="el_purchase_a_booking_reference">
<span<?= $Page->booking_reference->viewAttributes() ?>>
<?= $Page->booking_reference->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_rid" class="el_purchase_a_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->getViewValue()) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><?= $Page->rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_lot_no" class="el_purchase_a_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->net_weight->Visible) { // net_weight ?>
        <td data-name="net_weight"<?= $Page->net_weight->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_net_weight" class="el_purchase_a_net_weight">
<span<?= $Page->net_weight->viewAttributes() ?>>
<?= $Page->net_weight->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Page->packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_packets" class="el_purchase_a_packets">
<span<?= $Page->packets->viewAttributes() ?>>
<?= $Page->packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_packing_type" class="el_purchase_a_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?php if (!EmptyString($Page->packing_type->getViewValue()) && $Page->packing_type->linkAttributes() != "") { ?>
<a<?= $Page->packing_type->linkAttributes() ?>><?= $Page->packing_type->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->packing_type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->containers->Visible) { // containers ?>
        <td data-name="containers"<?= $Page->containers->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_containers" class="el_purchase_a_containers">
<span<?= $Page->containers->viewAttributes() ?>>
<?= $Page->containers->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown_arrival_date->Visible) { // godown_arrival_date ?>
        <td data-name="godown_arrival_date"<?= $Page->godown_arrival_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_godown_arrival_date" class="el_purchase_a_godown_arrival_date">
<span<?= $Page->godown_arrival_date->viewAttributes() ?>>
<?= $Page->godown_arrival_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_godown" class="el_purchase_a_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?php if (!EmptyString($Page->godown->getViewValue()) && $Page->godown->linkAttributes() != "") { ?>
<a<?= $Page->godown->linkAttributes() ?>><?= $Page->godown->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->godown->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rack->Visible) { // rack ?>
        <td data-name="rack"<?= $Page->rack->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_rack" class="el_purchase_a_rack">
<span<?= $Page->rack->viewAttributes() ?>>
<?= $Page->rack->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_details->Visible) { // invoice_details ?>
        <td data-name="invoice_details"<?= $Page->invoice_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_invoice_details" class="el_purchase_a_invoice_details">
<span<?= $Page->invoice_details->viewAttributes() ?>>
<?= $Page->invoice_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->invoice_value->Visible) { // invoice_value ?>
        <td data-name="invoice_value"<?= $Page->invoice_value->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_invoice_value" class="el_purchase_a_invoice_value">
<span<?= $Page->invoice_value->viewAttributes() ?>>
<?= $Page->invoice_value->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->currency_rate->Visible) { // currency_rate ?>
        <td data-name="currency_rate"<?= $Page->currency_rate->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_currency_rate" class="el_purchase_a_currency_rate">
<span<?= $Page->currency_rate->viewAttributes() ?>>
<?= $Page->currency_rate->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
        <td data-name="purchase_amount_inr"<?= $Page->purchase_amount_inr->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_purchase_amount_inr" class="el_purchase_a_purchase_amount_inr">
<span<?= $Page->purchase_amount_inr->viewAttributes() ?>>
<?= $Page->purchase_amount_inr->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->duty_paid_by->Visible) { // duty_paid_by ?>
        <td data-name="duty_paid_by"<?= $Page->duty_paid_by->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_duty_paid_by" class="el_purchase_a_duty_paid_by">
<span<?= $Page->duty_paid_by->viewAttributes() ?>>
<?= $Page->duty_paid_by->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->custom_duty->Visible) { // custom_duty ?>
        <td data-name="custom_duty"<?= $Page->custom_duty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_custom_duty" class="el_purchase_a_custom_duty">
<span<?= $Page->custom_duty->viewAttributes() ?>>
<?= $Page->custom_duty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->port_clearing_charge->Visible) { // port_clearing_charge ?>
        <td data-name="port_clearing_charge"<?= $Page->port_clearing_charge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_port_clearing_charge" class="el_purchase_a_port_clearing_charge">
<span<?= $Page->port_clearing_charge->viewAttributes() ?>>
<?= $Page->port_clearing_charge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cha_commission->Visible) { // cha_commission ?>
        <td data-name="cha_commission"<?= $Page->cha_commission->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_cha_commission" class="el_purchase_a_cha_commission">
<span<?= $Page->cha_commission->viewAttributes() ?>>
<?= $Page->cha_commission->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cha_agent->Visible) { // cha_agent ?>
        <td data-name="cha_agent"<?= $Page->cha_agent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_cha_agent" class="el_purchase_a_cha_agent">
<span<?= $Page->cha_agent->viewAttributes() ?>>
<?= $Page->cha_agent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_charges->Visible) { // bank_charges ?>
        <td data-name="bank_charges"<?= $Page->bank_charges->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_bank_charges" class="el_purchase_a_bank_charges">
<span<?= $Page->bank_charges->viewAttributes() ?>>
<?= $Page->bank_charges->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->importer->Visible) { // importer ?>
        <td data-name="importer"<?= $Page->importer->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_importer" class="el_purchase_a_importer">
<span<?= $Page->importer->viewAttributes() ?>>
<?= $Page->importer->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_remarks" class="el_purchase_a_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fiba_fibd->Visible) { // fiba_fibd ?>
        <td data-name="fiba_fibd"<?= $Page->fiba_fibd->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_fiba_fibd" class="el_purchase_a_fiba_fibd">
<span<?= $Page->fiba_fibd->viewAttributes() ?>>
<?= $Page->fiba_fibd->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fibc->Visible) { // fibc ?>
        <td data-name="fibc"<?= $Page->fibc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_fibc" class="el_purchase_a_fibc">
<span<?= $Page->fibc->viewAttributes() ?>>
<?= $Page->fibc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_operator" class="el_purchase_a_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_datetime" class="el_purchase_a_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rbi_compliance_date->Visible) { // rbi_compliance_date ?>
        <td data-name="rbi_compliance_date"<?= $Page->rbi_compliance_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_purchase_a_rbi_compliance_date" class="el_purchase_a_rbi_compliance_date">
<span<?= $Page->rbi_compliance_date->viewAttributes() ?>>
<?= $Page->rbi_compliance_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_a");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
