<?php

namespace PHPMaker2024\fibre;

// Page object
$PurchaseAEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fpurchase_aedit" id="fpurchase_aedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { purchase_a: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fpurchase_aedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fpurchase_aedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["supplier", [fields.supplier.visible && fields.supplier.required ? ew.Validators.required(fields.supplier.caption) : null], fields.supplier.isInvalid],
            ["booking_reference", [fields.booking_reference.visible && fields.booking_reference.required ? ew.Validators.required(fields.booking_reference.caption) : null], fields.booking_reference.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["gross_weight", [fields.gross_weight.visible && fields.gross_weight.required ? ew.Validators.required(fields.gross_weight.caption) : null, ew.Validators.float], fields.gross_weight.isInvalid],
            ["net_weight", [fields.net_weight.visible && fields.net_weight.required ? ew.Validators.required(fields.net_weight.caption) : null, ew.Validators.float], fields.net_weight.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.integer], fields.packets.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["containers", [fields.containers.visible && fields.containers.required ? ew.Validators.required(fields.containers.caption) : null, ew.Validators.float], fields.containers.isInvalid],
            ["shipping_line", [fields.shipping_line.visible && fields.shipping_line.required ? ew.Validators.required(fields.shipping_line.caption) : null], fields.shipping_line.isInvalid],
            ["port_arrival_date", [fields.port_arrival_date.visible && fields.port_arrival_date.required ? ew.Validators.required(fields.port_arrival_date.caption) : null, ew.Validators.datetime(fields.port_arrival_date.clientFormatPattern)], fields.port_arrival_date.isInvalid],
            ["godown_arrival_date", [fields.godown_arrival_date.visible && fields.godown_arrival_date.required ? ew.Validators.required(fields.godown_arrival_date.caption) : null, ew.Validators.datetime(fields.godown_arrival_date.clientFormatPattern)], fields.godown_arrival_date.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid],
            ["rack", [fields.rack.visible && fields.rack.required ? ew.Validators.required(fields.rack.caption) : null], fields.rack.isInvalid],
            ["invoice_details", [fields.invoice_details.visible && fields.invoice_details.required ? ew.Validators.required(fields.invoice_details.caption) : null], fields.invoice_details.isInvalid],
            ["invoice_value", [fields.invoice_value.visible && fields.invoice_value.required ? ew.Validators.required(fields.invoice_value.caption) : null, ew.Validators.float], fields.invoice_value.isInvalid],
            ["currency_rate", [fields.currency_rate.visible && fields.currency_rate.required ? ew.Validators.required(fields.currency_rate.caption) : null, ew.Validators.float], fields.currency_rate.isInvalid],
            ["purchase_amount_inr", [fields.purchase_amount_inr.visible && fields.purchase_amount_inr.required ? ew.Validators.required(fields.purchase_amount_inr.caption) : null, ew.Validators.float], fields.purchase_amount_inr.isInvalid],
            ["duty_paid_by", [fields.duty_paid_by.visible && fields.duty_paid_by.required ? ew.Validators.required(fields.duty_paid_by.caption) : null], fields.duty_paid_by.isInvalid],
            ["custom_duty", [fields.custom_duty.visible && fields.custom_duty.required ? ew.Validators.required(fields.custom_duty.caption) : null, ew.Validators.float], fields.custom_duty.isInvalid],
            ["transportation_charges", [fields.transportation_charges.visible && fields.transportation_charges.required ? ew.Validators.required(fields.transportation_charges.caption) : null, ew.Validators.float], fields.transportation_charges.isInvalid],
            ["port_clearing_charge", [fields.port_clearing_charge.visible && fields.port_clearing_charge.required ? ew.Validators.required(fields.port_clearing_charge.caption) : null, ew.Validators.float], fields.port_clearing_charge.isInvalid],
            ["cha_commission", [fields.cha_commission.visible && fields.cha_commission.required ? ew.Validators.required(fields.cha_commission.caption) : null, ew.Validators.float], fields.cha_commission.isInvalid],
            ["cha_agent", [fields.cha_agent.visible && fields.cha_agent.required ? ew.Validators.required(fields.cha_agent.caption) : null], fields.cha_agent.isInvalid],
            ["clearance_bank", [fields.clearance_bank.visible && fields.clearance_bank.required ? ew.Validators.required(fields.clearance_bank.caption) : null], fields.clearance_bank.isInvalid],
            ["bank_charges", [fields.bank_charges.visible && fields.bank_charges.required ? ew.Validators.required(fields.bank_charges.caption) : null], fields.bank_charges.isInvalid],
            ["importer", [fields.importer.visible && fields.importer.required ? ew.Validators.required(fields.importer.caption) : null], fields.importer.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["fiba_fibd", [fields.fiba_fibd.visible && fields.fiba_fibd.required ? ew.Validators.required(fields.fiba_fibd.caption) : null], fields.fiba_fibd.isInvalid],
            ["fibc", [fields.fibc.visible && fields.fibc.required ? ew.Validators.required(fields.fibc.caption) : null], fields.fibc.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "shipping_line": <?= $Page->shipping_line->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "duty_paid_by": <?= $Page->duty_paid_by->toClientList($Page) ?>,
            "cha_agent": <?= $Page->cha_agent->toClientList($Page) ?>,
            "clearance_bank": <?= $Page->clearance_bank->toClientList($Page) ?>,
            "importer": <?= $Page->importer->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="purchase_a">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_purchase_a_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_purchase_a_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="purchase_a" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->supplier->Visible) { // supplier ?>
    <div id="r_supplier"<?= $Page->supplier->rowAttributes() ?>>
        <label id="elh_purchase_a_supplier" for="x_supplier" class="<?= $Page->LeftColumnClass ?>"><?= $Page->supplier->caption() ?><?= $Page->supplier->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->supplier->cellAttributes() ?>>
<span id="el_purchase_a_supplier">
<span<?= $Page->supplier->viewAttributes() ?>>
<?php if (!EmptyString($Page->supplier->EditValue) && $Page->supplier->linkAttributes() != "") { ?>
<a<?= $Page->supplier->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->supplier->getDisplayValue($Page->supplier->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->supplier->getDisplayValue($Page->supplier->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_supplier" data-hidden="1" name="x_supplier" id="x_supplier" value="<?= HtmlEncode($Page->supplier->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->booking_reference->Visible) { // booking_reference ?>
    <div id="r_booking_reference"<?= $Page->booking_reference->rowAttributes() ?>>
        <label id="elh_purchase_a_booking_reference" for="x_booking_reference" class="<?= $Page->LeftColumnClass ?>"><?= $Page->booking_reference->caption() ?><?= $Page->booking_reference->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->booking_reference->cellAttributes() ?>>
<span id="el_purchase_a_booking_reference">
<span<?= $Page->booking_reference->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->booking_reference->getDisplayValue($Page->booking_reference->EditValue) ?></span></span>
<input type="hidden" data-table="purchase_a" data-field="x_booking_reference" data-hidden="1" name="x_booking_reference" id="x_booking_reference" value="<?= HtmlEncode($Page->booking_reference->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid"<?= $Page->rid->rowAttributes() ?>>
        <label id="elh_purchase_a_rid" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rid->caption() ?><?= $Page->rid->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rid->cellAttributes() ?>>
<span id="el_purchase_a_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->rid->EditValue) && $Page->rid->linkAttributes() != "") { ?>
<a<?= $Page->rid->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->rid->getDisplayValue($Page->rid->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Page->rid->getDisplayValue($Page->rid->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="purchase_a" data-field="x_rid" data-hidden="1" name="x_rid" id="x_rid" value="<?= HtmlEncode($Page->rid->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no"<?= $Page->lot_no->rowAttributes() ?>>
        <label id="elh_purchase_a_lot_no" for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lot_no->caption() ?><?= $Page->lot_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lot_no->cellAttributes() ?>>
<span id="el_purchase_a_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->lot_no->getDisplayValue($Page->lot_no->EditValue))) ?>"></span>
<input type="hidden" data-table="purchase_a" data-field="x_lot_no" data-hidden="1" name="x_lot_no" id="x_lot_no" value="<?= HtmlEncode($Page->lot_no->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gross_weight->Visible) { // gross_weight ?>
    <div id="r_gross_weight"<?= $Page->gross_weight->rowAttributes() ?>>
        <label id="elh_purchase_a_gross_weight" for="x_gross_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gross_weight->caption() ?><?= $Page->gross_weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gross_weight->cellAttributes() ?>>
<span id="el_purchase_a_gross_weight">
<input type="<?= $Page->gross_weight->getInputTextType() ?>" name="x_gross_weight" id="x_gross_weight" data-table="purchase_a" data-field="x_gross_weight" value="<?= $Page->gross_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->gross_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gross_weight->formatPattern()) ?>"<?= $Page->gross_weight->editAttributes() ?> aria-describedby="x_gross_weight_help">
<?= $Page->gross_weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gross_weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->net_weight->Visible) { // net_weight ?>
    <div id="r_net_weight"<?= $Page->net_weight->rowAttributes() ?>>
        <label id="elh_purchase_a_net_weight" for="x_net_weight" class="<?= $Page->LeftColumnClass ?>"><?= $Page->net_weight->caption() ?><?= $Page->net_weight->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->net_weight->cellAttributes() ?>>
<span id="el_purchase_a_net_weight">
<input type="<?= $Page->net_weight->getInputTextType() ?>" name="x_net_weight" id="x_net_weight" data-table="purchase_a" data-field="x_net_weight" value="<?= $Page->net_weight->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->net_weight->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->net_weight->formatPattern()) ?>"<?= $Page->net_weight->editAttributes() ?> aria-describedby="x_net_weight_help">
<?= $Page->net_weight->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->net_weight->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets"<?= $Page->packets->rowAttributes() ?>>
        <label id="elh_purchase_a_packets" for="x_packets" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packets->caption() ?><?= $Page->packets->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packets->cellAttributes() ?>>
<span id="el_purchase_a_packets">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="purchase_a" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?> aria-describedby="x_packets_help">
<?= $Page->packets->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type"<?= $Page->packing_type->rowAttributes() ?>>
        <label id="elh_purchase_a_packing_type" for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->packing_type->caption() ?><?= $Page->packing_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->packing_type->cellAttributes() ?>>
<span id="el_purchase_a_packing_type">
<div class="input-group flex-nowrap">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_packing_type"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "packing_type") && !$Page->packing_type->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_packing_type" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->packing_type->caption() ?>" data-title="<?= $Page->packing_type->caption() ?>" data-ew-action="add-option" data-el="x_packing_type" data-url="<?= GetUrl("packingtypeaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->packing_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage() ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_packing_type", selectId: "fpurchase_aedit_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->containers->Visible) { // containers ?>
    <div id="r_containers"<?= $Page->containers->rowAttributes() ?>>
        <label id="elh_purchase_a_containers" for="x_containers" class="<?= $Page->LeftColumnClass ?>"><?= $Page->containers->caption() ?><?= $Page->containers->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->containers->cellAttributes() ?>>
<span id="el_purchase_a_containers">
<input type="<?= $Page->containers->getInputTextType() ?>" name="x_containers" id="x_containers" data-table="purchase_a" data-field="x_containers" value="<?= $Page->containers->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->containers->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->containers->formatPattern()) ?>"<?= $Page->containers->editAttributes() ?> aria-describedby="x_containers_help">
<?= $Page->containers->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->containers->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_line->Visible) { // shipping_line ?>
    <div id="r_shipping_line"<?= $Page->shipping_line->rowAttributes() ?>>
        <label id="elh_purchase_a_shipping_line" for="x_shipping_line" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_line->caption() ?><?= $Page->shipping_line->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_line->cellAttributes() ?>>
<span id="el_purchase_a_shipping_line">
<div class="input-group flex-nowrap">
    <select
        id="x_shipping_line"
        name="x_shipping_line"
        class="form-select ew-select<?= $Page->shipping_line->isInvalidClass() ?>"
        <?php if (!$Page->shipping_line->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_shipping_line"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_shipping_line"
        data-value-separator="<?= $Page->shipping_line->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipping_line->getPlaceHolder()) ?>"
        <?= $Page->shipping_line->editAttributes() ?>>
        <?= $Page->shipping_line->selectOptionListHtml("x_shipping_line") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "shipping_line") && !$Page->shipping_line->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_shipping_line" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->shipping_line->caption() ?>" data-title="<?= $Page->shipping_line->caption() ?>" data-ew-action="add-option" data-el="x_shipping_line" data-url="<?= GetUrl("shippinglineaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->shipping_line->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_line->getErrorMessage() ?></div>
<?= $Page->shipping_line->Lookup->getParamTag($Page, "p_x_shipping_line") ?>
<?php if (!$Page->shipping_line->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_shipping_line", selectId: "fpurchase_aedit_x_shipping_line" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.shipping_line?.lookupOptions.length) {
        options.data = { id: "x_shipping_line", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_shipping_line", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.shipping_line.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_arrival_date->Visible) { // port_arrival_date ?>
    <div id="r_port_arrival_date"<?= $Page->port_arrival_date->rowAttributes() ?>>
        <label id="elh_purchase_a_port_arrival_date" for="x_port_arrival_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_arrival_date->caption() ?><?= $Page->port_arrival_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_arrival_date->cellAttributes() ?>>
<span id="el_purchase_a_port_arrival_date">
<input type="<?= $Page->port_arrival_date->getInputTextType() ?>" name="x_port_arrival_date" id="x_port_arrival_date" data-table="purchase_a" data-field="x_port_arrival_date" value="<?= $Page->port_arrival_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->port_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_arrival_date->formatPattern()) ?>"<?= $Page->port_arrival_date->editAttributes() ?> aria-describedby="x_port_arrival_date_help">
<?= $Page->port_arrival_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_arrival_date->getErrorMessage() ?></div>
<?php if (!$Page->port_arrival_date->ReadOnly && !$Page->port_arrival_date->Disabled && !isset($Page->port_arrival_date->EditAttrs["readonly"]) && !isset($Page->port_arrival_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_aedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_aedit", "x_port_arrival_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown_arrival_date->Visible) { // godown_arrival_date ?>
    <div id="r_godown_arrival_date"<?= $Page->godown_arrival_date->rowAttributes() ?>>
        <label id="elh_purchase_a_godown_arrival_date" for="x_godown_arrival_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown_arrival_date->caption() ?><?= $Page->godown_arrival_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown_arrival_date->cellAttributes() ?>>
<span id="el_purchase_a_godown_arrival_date">
<input type="<?= $Page->godown_arrival_date->getInputTextType() ?>" name="x_godown_arrival_date" id="x_godown_arrival_date" data-table="purchase_a" data-field="x_godown_arrival_date" value="<?= $Page->godown_arrival_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->godown_arrival_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown_arrival_date->formatPattern()) ?>"<?= $Page->godown_arrival_date->editAttributes() ?> aria-describedby="x_godown_arrival_date_help">
<?= $Page->godown_arrival_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown_arrival_date->getErrorMessage() ?></div>
<?php if (!$Page->godown_arrival_date->ReadOnly && !$Page->godown_arrival_date->Disabled && !isset($Page->godown_arrival_date->EditAttrs["readonly"]) && !isset($Page->godown_arrival_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fpurchase_aedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fpurchase_aedit", "x_godown_arrival_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown"<?= $Page->godown->rowAttributes() ?>>
        <label id="elh_purchase_a_godown" for="x_godown" class="<?= $Page->LeftColumnClass ?>"><?= $Page->godown->caption() ?><?= $Page->godown->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->godown->cellAttributes() ?>>
<span id="el_purchase_a_godown">
<div class="input-group flex-nowrap">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_godown"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "godown_table") && !$Page->godown->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_godown" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->godown->caption() ?>" data-title="<?= $Page->godown->caption() ?>" data-ew-action="add-option" data-el="x_godown" data-url="<?= GetUrl("godowntableaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->godown->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->godown->getErrorMessage() ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_godown", selectId: "fpurchase_aedit_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_godown", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rack->Visible) { // rack ?>
    <div id="r_rack"<?= $Page->rack->rowAttributes() ?>>
        <label id="elh_purchase_a_rack" for="x_rack" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rack->caption() ?><?= $Page->rack->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rack->cellAttributes() ?>>
<span id="el_purchase_a_rack">
<input type="<?= $Page->rack->getInputTextType() ?>" name="x_rack" id="x_rack" data-table="purchase_a" data-field="x_rack" value="<?= $Page->rack->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->rack->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rack->formatPattern()) ?>"<?= $Page->rack->editAttributes() ?> aria-describedby="x_rack_help">
<?= $Page->rack->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rack->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_details->Visible) { // invoice_details ?>
    <div id="r_invoice_details"<?= $Page->invoice_details->rowAttributes() ?>>
        <label id="elh_purchase_a_invoice_details" for="x_invoice_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_details->caption() ?><?= $Page->invoice_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_details->cellAttributes() ?>>
<span id="el_purchase_a_invoice_details">
<input type="<?= $Page->invoice_details->getInputTextType() ?>" name="x_invoice_details" id="x_invoice_details" data-table="purchase_a" data-field="x_invoice_details" value="<?= $Page->invoice_details->EditValue ?>" maxlength="48" placeholder="<?= HtmlEncode($Page->invoice_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_details->formatPattern()) ?>"<?= $Page->invoice_details->editAttributes() ?> aria-describedby="x_invoice_details_help">
<?= $Page->invoice_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_value->Visible) { // invoice_value ?>
    <div id="r_invoice_value"<?= $Page->invoice_value->rowAttributes() ?>>
        <label id="elh_purchase_a_invoice_value" for="x_invoice_value" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_value->caption() ?><?= $Page->invoice_value->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_value->cellAttributes() ?>>
<span id="el_purchase_a_invoice_value">
<input type="<?= $Page->invoice_value->getInputTextType() ?>" name="x_invoice_value" id="x_invoice_value" data-table="purchase_a" data-field="x_invoice_value" value="<?= $Page->invoice_value->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->invoice_value->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_value->formatPattern()) ?>"<?= $Page->invoice_value->editAttributes() ?> aria-describedby="x_invoice_value_help">
<?= $Page->invoice_value->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_value->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->currency_rate->Visible) { // currency_rate ?>
    <div id="r_currency_rate"<?= $Page->currency_rate->rowAttributes() ?>>
        <label id="elh_purchase_a_currency_rate" for="x_currency_rate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->currency_rate->caption() ?><?= $Page->currency_rate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->currency_rate->cellAttributes() ?>>
<span id="el_purchase_a_currency_rate">
<input type="<?= $Page->currency_rate->getInputTextType() ?>" name="x_currency_rate" id="x_currency_rate" data-table="purchase_a" data-field="x_currency_rate" value="<?= $Page->currency_rate->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->currency_rate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->currency_rate->formatPattern()) ?>"<?= $Page->currency_rate->editAttributes() ?> aria-describedby="x_currency_rate_help">
<?= $Page->currency_rate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->currency_rate->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->purchase_amount_inr->Visible) { // purchase_amount_inr ?>
    <div id="r_purchase_amount_inr"<?= $Page->purchase_amount_inr->rowAttributes() ?>>
        <label id="elh_purchase_a_purchase_amount_inr" for="x_purchase_amount_inr" class="<?= $Page->LeftColumnClass ?>"><?= $Page->purchase_amount_inr->caption() ?><?= $Page->purchase_amount_inr->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->purchase_amount_inr->cellAttributes() ?>>
<span id="el_purchase_a_purchase_amount_inr">
<input type="<?= $Page->purchase_amount_inr->getInputTextType() ?>" name="x_purchase_amount_inr" id="x_purchase_amount_inr" data-table="purchase_a" data-field="x_purchase_amount_inr" value="<?= $Page->purchase_amount_inr->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->purchase_amount_inr->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->purchase_amount_inr->formatPattern()) ?>"<?= $Page->purchase_amount_inr->editAttributes() ?> aria-describedby="x_purchase_amount_inr_help">
<?= $Page->purchase_amount_inr->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->purchase_amount_inr->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->duty_paid_by->Visible) { // duty_paid_by ?>
    <div id="r_duty_paid_by"<?= $Page->duty_paid_by->rowAttributes() ?>>
        <label id="elh_purchase_a_duty_paid_by" for="x_duty_paid_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->duty_paid_by->caption() ?><?= $Page->duty_paid_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->duty_paid_by->cellAttributes() ?>>
<span id="el_purchase_a_duty_paid_by">
    <select
        id="x_duty_paid_by"
        name="x_duty_paid_by"
        class="form-select ew-select<?= $Page->duty_paid_by->isInvalidClass() ?>"
        <?php if (!$Page->duty_paid_by->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_duty_paid_by"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_duty_paid_by"
        data-value-separator="<?= $Page->duty_paid_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->duty_paid_by->getPlaceHolder()) ?>"
        <?= $Page->duty_paid_by->editAttributes() ?>>
        <?= $Page->duty_paid_by->selectOptionListHtml("x_duty_paid_by") ?>
    </select>
    <?= $Page->duty_paid_by->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->duty_paid_by->getErrorMessage() ?></div>
<?php if (!$Page->duty_paid_by->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_duty_paid_by", selectId: "fpurchase_aedit_x_duty_paid_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.duty_paid_by?.lookupOptions.length) {
        options.data = { id: "x_duty_paid_by", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_duty_paid_by", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.duty_paid_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->custom_duty->Visible) { // custom_duty ?>
    <div id="r_custom_duty"<?= $Page->custom_duty->rowAttributes() ?>>
        <label id="elh_purchase_a_custom_duty" for="x_custom_duty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->custom_duty->caption() ?><?= $Page->custom_duty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->custom_duty->cellAttributes() ?>>
<span id="el_purchase_a_custom_duty">
<input type="<?= $Page->custom_duty->getInputTextType() ?>" name="x_custom_duty" id="x_custom_duty" data-table="purchase_a" data-field="x_custom_duty" value="<?= $Page->custom_duty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->custom_duty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->custom_duty->formatPattern()) ?>"<?= $Page->custom_duty->editAttributes() ?> aria-describedby="x_custom_duty_help">
<?= $Page->custom_duty->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->custom_duty->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->transportation_charges->Visible) { // transportation_charges ?>
    <div id="r_transportation_charges"<?= $Page->transportation_charges->rowAttributes() ?>>
        <label id="elh_purchase_a_transportation_charges" for="x_transportation_charges" class="<?= $Page->LeftColumnClass ?>"><?= $Page->transportation_charges->caption() ?><?= $Page->transportation_charges->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->transportation_charges->cellAttributes() ?>>
<span id="el_purchase_a_transportation_charges">
<input type="<?= $Page->transportation_charges->getInputTextType() ?>" name="x_transportation_charges" id="x_transportation_charges" data-table="purchase_a" data-field="x_transportation_charges" value="<?= $Page->transportation_charges->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transportation_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transportation_charges->formatPattern()) ?>"<?= $Page->transportation_charges->editAttributes() ?> aria-describedby="x_transportation_charges_help">
<?= $Page->transportation_charges->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->transportation_charges->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_clearing_charge->Visible) { // port_clearing_charge ?>
    <div id="r_port_clearing_charge"<?= $Page->port_clearing_charge->rowAttributes() ?>>
        <label id="elh_purchase_a_port_clearing_charge" for="x_port_clearing_charge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_clearing_charge->caption() ?><?= $Page->port_clearing_charge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_clearing_charge->cellAttributes() ?>>
<span id="el_purchase_a_port_clearing_charge">
<input type="<?= $Page->port_clearing_charge->getInputTextType() ?>" name="x_port_clearing_charge" id="x_port_clearing_charge" data-table="purchase_a" data-field="x_port_clearing_charge" value="<?= $Page->port_clearing_charge->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->port_clearing_charge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->port_clearing_charge->formatPattern()) ?>"<?= $Page->port_clearing_charge->editAttributes() ?> aria-describedby="x_port_clearing_charge_help">
<?= $Page->port_clearing_charge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_clearing_charge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cha_commission->Visible) { // cha_commission ?>
    <div id="r_cha_commission"<?= $Page->cha_commission->rowAttributes() ?>>
        <label id="elh_purchase_a_cha_commission" for="x_cha_commission" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cha_commission->caption() ?><?= $Page->cha_commission->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cha_commission->cellAttributes() ?>>
<span id="el_purchase_a_cha_commission">
<input type="<?= $Page->cha_commission->getInputTextType() ?>" name="x_cha_commission" id="x_cha_commission" data-table="purchase_a" data-field="x_cha_commission" value="<?= $Page->cha_commission->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cha_commission->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cha_commission->formatPattern()) ?>"<?= $Page->cha_commission->editAttributes() ?> aria-describedby="x_cha_commission_help">
<?= $Page->cha_commission->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cha_commission->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cha_agent->Visible) { // cha_agent ?>
    <div id="r_cha_agent"<?= $Page->cha_agent->rowAttributes() ?>>
        <label id="elh_purchase_a_cha_agent" for="x_cha_agent" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cha_agent->caption() ?><?= $Page->cha_agent->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cha_agent->cellAttributes() ?>>
<span id="el_purchase_a_cha_agent">
<div class="input-group flex-nowrap">
    <select
        id="x_cha_agent"
        name="x_cha_agent"
        class="form-select ew-select<?= $Page->cha_agent->isInvalidClass() ?>"
        <?php if (!$Page->cha_agent->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_cha_agent"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_cha_agent"
        data-value-separator="<?= $Page->cha_agent->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->cha_agent->getPlaceHolder()) ?>"
        <?= $Page->cha_agent->editAttributes() ?>>
        <?= $Page->cha_agent->selectOptionListHtml("x_cha_agent") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "cha_agent") && !$Page->cha_agent->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_cha_agent" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->cha_agent->caption() ?>" data-title="<?= $Page->cha_agent->caption() ?>" data-ew-action="add-option" data-el="x_cha_agent" data-url="<?= GetUrl("chaagentaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->cha_agent->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cha_agent->getErrorMessage() ?></div>
<?= $Page->cha_agent->Lookup->getParamTag($Page, "p_x_cha_agent") ?>
<?php if (!$Page->cha_agent->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_cha_agent", selectId: "fpurchase_aedit_x_cha_agent" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.cha_agent?.lookupOptions.length) {
        options.data = { id: "x_cha_agent", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_cha_agent", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.cha_agent.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->clearance_bank->Visible) { // clearance_bank ?>
    <div id="r_clearance_bank"<?= $Page->clearance_bank->rowAttributes() ?>>
        <label id="elh_purchase_a_clearance_bank" for="x_clearance_bank" class="<?= $Page->LeftColumnClass ?>"><?= $Page->clearance_bank->caption() ?><?= $Page->clearance_bank->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->clearance_bank->cellAttributes() ?>>
<span id="el_purchase_a_clearance_bank">
<div class="input-group flex-nowrap">
    <select
        id="x_clearance_bank"
        name="x_clearance_bank"
        class="form-select ew-select<?= $Page->clearance_bank->isInvalidClass() ?>"
        <?php if (!$Page->clearance_bank->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_clearance_bank"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_clearance_bank"
        data-value-separator="<?= $Page->clearance_bank->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->clearance_bank->getPlaceHolder()) ?>"
        <?= $Page->clearance_bank->editAttributes() ?>>
        <?= $Page->clearance_bank->selectOptionListHtml("x_clearance_bank") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "bank") && !$Page->clearance_bank->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_clearance_bank" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->clearance_bank->caption() ?>" data-title="<?= $Page->clearance_bank->caption() ?>" data-ew-action="add-option" data-el="x_clearance_bank" data-url="<?= GetUrl("bankaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->clearance_bank->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->clearance_bank->getErrorMessage() ?></div>
<?= $Page->clearance_bank->Lookup->getParamTag($Page, "p_x_clearance_bank") ?>
<?php if (!$Page->clearance_bank->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_clearance_bank", selectId: "fpurchase_aedit_x_clearance_bank" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.clearance_bank?.lookupOptions.length) {
        options.data = { id: "x_clearance_bank", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_clearance_bank", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.clearance_bank.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_charges->Visible) { // bank_charges ?>
    <div id="r_bank_charges"<?= $Page->bank_charges->rowAttributes() ?>>
        <label id="elh_purchase_a_bank_charges" for="x_bank_charges" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_charges->caption() ?><?= $Page->bank_charges->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_charges->cellAttributes() ?>>
<span id="el_purchase_a_bank_charges">
<input type="<?= $Page->bank_charges->getInputTextType() ?>" name="x_bank_charges" id="x_bank_charges" data-table="purchase_a" data-field="x_bank_charges" value="<?= $Page->bank_charges->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->bank_charges->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_charges->formatPattern()) ?>"<?= $Page->bank_charges->editAttributes() ?> aria-describedby="x_bank_charges_help">
<?= $Page->bank_charges->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_charges->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->importer->Visible) { // importer ?>
    <div id="r_importer"<?= $Page->importer->rowAttributes() ?>>
        <label id="elh_purchase_a_importer" for="x_importer" class="<?= $Page->LeftColumnClass ?>"><?= $Page->importer->caption() ?><?= $Page->importer->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->importer->cellAttributes() ?>>
<span id="el_purchase_a_importer">
<div class="input-group flex-nowrap">
    <select
        id="x_importer"
        name="x_importer"
        class="form-select ew-select<?= $Page->importer->isInvalidClass() ?>"
        <?php if (!$Page->importer->IsNativeSelect) { ?>
        data-select2-id="fpurchase_aedit_x_importer"
        <?php } ?>
        data-table="purchase_a"
        data-field="x_importer"
        data-value-separator="<?= $Page->importer->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->importer->getPlaceHolder()) ?>"
        <?= $Page->importer->editAttributes() ?>>
        <?= $Page->importer->selectOptionListHtml("x_importer") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_partner") && !$Page->importer->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_importer" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->importer->caption() ?>" data-title="<?= $Page->importer->caption() ?>" data-ew-action="add-option" data-el="x_importer" data-url="<?= GetUrl("productionpartneraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->importer->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->importer->getErrorMessage() ?></div>
<?= $Page->importer->Lookup->getParamTag($Page, "p_x_importer") ?>
<?php if (!$Page->importer->IsNativeSelect) { ?>
<script>
loadjs.ready("fpurchase_aedit", function() {
    var options = { name: "x_importer", selectId: "fpurchase_aedit_x_importer" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fpurchase_aedit.lists.importer?.lookupOptions.length) {
        options.data = { id: "x_importer", form: "fpurchase_aedit" };
    } else {
        options.ajax = { id: "x_importer", form: "fpurchase_aedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.purchase_a.fields.importer.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_purchase_a_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_purchase_a_remarks">
<textarea data-table="purchase_a" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fiba_fibd->Visible) { // fiba_fibd ?>
    <div id="r_fiba_fibd"<?= $Page->fiba_fibd->rowAttributes() ?>>
        <label id="elh_purchase_a_fiba_fibd" for="x_fiba_fibd" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fiba_fibd->caption() ?><?= $Page->fiba_fibd->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fiba_fibd->cellAttributes() ?>>
<span id="el_purchase_a_fiba_fibd">
<input type="<?= $Page->fiba_fibd->getInputTextType() ?>" name="x_fiba_fibd" id="x_fiba_fibd" data-table="purchase_a" data-field="x_fiba_fibd" value="<?= $Page->fiba_fibd->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->fiba_fibd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fiba_fibd->formatPattern()) ?>"<?= $Page->fiba_fibd->editAttributes() ?> aria-describedby="x_fiba_fibd_help">
<?= $Page->fiba_fibd->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fiba_fibd->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->fibc->Visible) { // fibc ?>
    <div id="r_fibc"<?= $Page->fibc->rowAttributes() ?>>
        <label id="elh_purchase_a_fibc" for="x_fibc" class="<?= $Page->LeftColumnClass ?>"><?= $Page->fibc->caption() ?><?= $Page->fibc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->fibc->cellAttributes() ?>>
<span id="el_purchase_a_fibc">
<input type="<?= $Page->fibc->getInputTextType() ?>" name="x_fibc" id="x_fibc" data-table="purchase_a" data-field="x_fibc" value="<?= $Page->fibc->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->fibc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fibc->formatPattern()) ?>"<?= $Page->fibc->editAttributes() ?> aria-describedby="x_fibc_help">
<?= $Page->fibc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->fibc->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fpurchase_aedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fpurchase_aedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("purchase_a");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
