<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionPartnerSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_partner: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fproduction_partnersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduction_partnersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["code", [ew.Validators.regex(/^([a-zA-Z0-9_-]){3,8}$/)], fields.code.isInvalid],
            ["country", [], fields.country.isInvalid],
            ["region", [], fields.region.isInvalid],
            ["city_name", [], fields.city_name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["_email", [], fields._email.isInvalid],
            ["url", [], fields.url.isInvalid],
            ["bank_name", [], fields.bank_name.isInvalid],
            ["bank_account_no", [], fields.bank_account_no.isInvalid],
            ["bank_code", [], fields.bank_code.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["reports_to", [], fields.reports_to.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["performance", [ew.Validators.integer], fields.performance.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["tax_registration", [], fields.tax_registration.isInvalid],
            ["cin", [], fields.cin.isInvalid],
            ["pan", [], fields.pan.isInvalid],
            ["tan", [], fields.tan.isInvalid],
            ["msme", [], fields.msme.isInvalid],
            ["iec", [], fields.iec.isInvalid],
            ["rex", [], fields.rex.isInvalid],
            ["rcmc", [], fields.rcmc.isInvalid],
            ["delivery_terms", [], fields.delivery_terms.isInvalid],
            ["shipping_terms", [], fields.shipping_terms.isInvalid],
            ["payment_terms", [], fields.payment_terms.isInvalid],
            ["export_type", [], fields.export_type.isInvalid],
            ["lead_time_ss", [ew.Validators.float], fields.lead_time_ss.isInvalid],
            ["lead_time_cs", [ew.Validators.float], fields.lead_time_cs.isInvalid],
            ["cha", [], fields.cha.isInvalid],
            ["cha_email", [], fields.cha_email.isInvalid],
            ["cha_phone", [], fields.cha_phone.isInvalid],
            ["forwarder", [], fields.forwarder.isInvalid],
            ["forwarder_email", [], fields.forwarder_email.isInvalid],
            ["forwarder_phone", [], fields.forwarder_phone.isInvalid],
            ["merchant", [], fields.merchant.isInvalid],
            ["merchant_email", [], fields.merchant_email.isInvalid],
            ["merchant_phone", [], fields.merchant_phone.isInvalid],
            ["shipping_incharge", [], fields.shipping_incharge.isInvalid],
            ["shipping_email", [], fields.shipping_email.isInvalid],
            ["shipping_phone", [], fields.shipping_phone.isInvalid],
            ["account_incharge", [], fields.account_incharge.isInvalid],
            ["accounts_email", [], fields.accounts_email.isInvalid],
            ["accounts_phone", [], fields.accounts_phone.isInvalid],
            ["warehouse_incharge", [], fields.warehouse_incharge.isInvalid],
            ["warehouse_email", [], fields.warehouse_email.isInvalid],
            ["warehouse_phone", [], fields.warehouse_phone.isInvalid],
            ["production_incharge", [], fields.production_incharge.isInvalid],
            ["production_email", [], fields.production_email.isInvalid],
            ["production_phone", [], fields.production_phone.isInvalid],
            ["qc_incharge", [], fields.qc_incharge.isInvalid],
            ["qc_email", [], fields.qc_email.isInvalid],
            ["qc_phone", [], fields.qc_phone.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "country": <?= $Page->country->toClientList($Page) ?>,
            "region": <?= $Page->region->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduction_partnersearch" id="fproduction_partnersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="production_partner" data-field="x_id" value="<?= $Page->id->EditValue ?>" data-page="0" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="production_partner" data-field="x_name" value="<?= $Page->name->EditValue ?>" data-page="0" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code" class="row"<?= $Page->code->rowAttributes() ?>>
        <label for="x_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_code"><?= $Page->code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_code" id="z_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="production_partner" data-field="x_code" value="<?= $Page->code->EditValue ?>" data-page="0" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_ProductionPartnerSearch"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country" class="row"<?= $Page->country->rowAttributes() ?>>
        <label for="x_country" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_country"><?= $Page->country->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_country" id="z_country" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->country->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_country" class="ew-search-field ew-search-field-single">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fproduction_partnersearch_x_country"
        <?php } ?>
        data-table="production_partner"
        data-field="x_country"
        data-page="1"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage(false) ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partnersearch", function() {
    var options = { name: "x_country", selectId: "fproduction_partnersearch_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partnersearch.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fproduction_partnersearch" };
    } else {
        options.ajax = { id: "x_country", form: "fproduction_partnersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->region->Visible) { // region ?>
    <div id="r_region" class="row"<?= $Page->region->rowAttributes() ?>>
        <label for="x_region" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_region"><?= $Page->region->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_region" id="z_region" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->region->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_region" class="ew-search-field ew-search-field-single">
    <select
        id="x_region"
        name="x_region"
        class="form-select ew-select<?= $Page->region->isInvalidClass() ?>"
        <?php if (!$Page->region->IsNativeSelect) { ?>
        data-select2-id="fproduction_partnersearch_x_region"
        <?php } ?>
        data-table="production_partner"
        data-field="x_region"
        data-page="1"
        data-value-separator="<?= $Page->region->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->region->getPlaceHolder()) ?>"
        <?= $Page->region->editAttributes() ?>>
        <?= $Page->region->selectOptionListHtml("x_region") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->region->getErrorMessage(false) ?></div>
<?= $Page->region->Lookup->getParamTag($Page, "p_x_region") ?>
<?php if (!$Page->region->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partnersearch", function() {
    var options = { name: "x_region", selectId: "fproduction_partnersearch_x_region" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partnersearch.lists.region?.lookupOptions.length) {
        options.data = { id: "x_region", form: "fproduction_partnersearch" };
    } else {
        options.ajax = { id: "x_region", form: "fproduction_partnersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.region.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
    <div id="r_city_name" class="row"<?= $Page->city_name->rowAttributes() ?>>
        <label for="x_city_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_city_name"><?= $Page->city_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_city_name" id="z_city_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_city_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city_name->getInputTextType() ?>" name="x_city_name" id="x_city_name" data-table="production_partner" data-field="x_city_name" value="<?= $Page->city_name->EditValue ?>" data-page="1" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city_name->formatPattern()) ?>"<?= $Page->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="production_partner" data-field="x_address" value="<?= $Page->address->EditValue ?>" data-page="1" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="production_partner" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email" class="row"<?= $Page->_email->rowAttributes() ?>>
        <label for="x__email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner__email"><?= $Page->_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__email" id="z__email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner__email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="production_partner" data-field="x__email" value="<?= $Page->_email->EditValue ?>" data-page="1" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url" class="row"<?= $Page->url->rowAttributes() ?>>
        <label for="x_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_url"><?= $Page->url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url" id="z_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="production_partner" data-field="x_url" value="<?= $Page->url->EditValue ?>" data-page="1" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name" class="row"<?= $Page->bank_name->rowAttributes() ?>>
        <label for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_bank_name"><?= $Page->bank_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_name" id="z_bank_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_bank_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="production_partner" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" data-page="1" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no" class="row"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_bank_account_no"><?= $Page->bank_account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_account_no" id="z_bank_account_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_bank_account_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="production_partner" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_code->Visible) { // bank_code ?>
    <div id="r_bank_code" class="row"<?= $Page->bank_code->rowAttributes() ?>>
        <label for="x_bank_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_bank_code"><?= $Page->bank_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_code" id="z_bank_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_bank_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_code->getInputTextType() ?>" name="x_bank_code" id="x_bank_code" data-table="production_partner" data-field="x_bank_code" value="<?= $Page->bank_code->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->bank_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_code->formatPattern()) ?>"<?= $Page->bank_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_partner" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="production_partner"
    data-field="x_grp"
    data-page="2"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fproduction_partnersearch_x_category"
        <?php } ?>
        data-table="production_partner"
        data-field="x_category"
        data-page="2"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partnersearch", function() {
    var options = { name: "x_category", selectId: "fproduction_partnersearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partnersearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fproduction_partnersearch" };
    } else {
        options.ajax = { id: "x_category", form: "fproduction_partnersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to" class="row"<?= $Page->reports_to->rowAttributes() ?>>
        <label for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_reports_to"><?= $Page->reports_to->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_reports_to" id="z_reports_to" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reports_to->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_reports_to" class="ew-search-field ew-search-field-single">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fproduction_partnersearch_x_reports_to"
        <?php } ?>
        data-table="production_partner"
        data-field="x_reports_to"
        data-page="2"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage(false) ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partnersearch", function() {
    var options = { name: "x_reports_to", selectId: "fproduction_partnersearch_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partnersearch.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fproduction_partnersearch" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fproduction_partnersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduction_partnersearch_x_status"
        <?php } ?>
        data-table="production_partner"
        data-field="x_status"
        data-page="2"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partnersearch", function() {
    var options = { name: "x_status", selectId: "fproduction_partnersearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partnersearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduction_partnersearch" };
    } else {
        options.ajax = { id: "x_status", form: "fproduction_partnersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->performance->Visible) { // performance ?>
    <div id="r_performance" class="row"<?= $Page->performance->rowAttributes() ?>>
        <label for="x_performance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_performance"><?= $Page->performance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_performance" id="z_performance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->performance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_performance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->performance->getInputTextType() ?>" name="x_performance" id="x_performance" data-table="production_partner" data-field="x_performance" value="<?= $Page->performance->EditValue ?>" data-page="2" size="30" placeholder="<?= HtmlEncode($Page->performance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->performance->formatPattern()) ?>"<?= $Page->performance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->performance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fproduction_partnersearch_x_operator"
        <?php } ?>
        data-table="production_partner"
        data-field="x_operator"
        data-page="2"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partnersearch", function() {
    var options = { name: "x_operator", selectId: "fproduction_partnersearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partnersearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fproduction_partnersearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fproduction_partnersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="production_partner" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" data-page="2" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->tax_registration->Visible) { // tax_registration ?>
    <div id="r_tax_registration" class="row"<?= $Page->tax_registration->rowAttributes() ?>>
        <label for="x_tax_registration" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_tax_registration"><?= $Page->tax_registration->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_tax_registration" id="z_tax_registration" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tax_registration->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_tax_registration" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tax_registration->getInputTextType() ?>" name="x_tax_registration" id="x_tax_registration" data-table="production_partner" data-field="x_tax_registration" value="<?= $Page->tax_registration->EditValue ?>" data-page="3" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->tax_registration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_registration->formatPattern()) ?>"<?= $Page->tax_registration->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tax_registration->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cin->Visible) { // cin ?>
    <div id="r_cin" class="row"<?= $Page->cin->rowAttributes() ?>>
        <label for="x_cin" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_cin"><?= $Page->cin->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cin" id="z_cin" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cin->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_cin" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cin->getInputTextType() ?>" name="x_cin" id="x_cin" data-table="production_partner" data-field="x_cin" value="<?= $Page->cin->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->cin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cin->formatPattern()) ?>"<?= $Page->cin->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cin->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan->Visible) { // pan ?>
    <div id="r_pan" class="row"<?= $Page->pan->rowAttributes() ?>>
        <label for="x_pan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_pan"><?= $Page->pan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pan" id="z_pan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_pan" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan->getInputTextType() ?>" name="x_pan" id="x_pan" data-table="production_partner" data-field="x_pan" value="<?= $Page->pan->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan->formatPattern()) ?>"<?= $Page->pan->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->tan->Visible) { // tan ?>
    <div id="r_tan" class="row"<?= $Page->tan->rowAttributes() ?>>
        <label for="x_tan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_tan"><?= $Page->tan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_tan" id="z_tan" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->tan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_tan" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->tan->getInputTextType() ?>" name="x_tan" id="x_tan" data-table="production_partner" data-field="x_tan" value="<?= $Page->tan->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->tan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tan->formatPattern()) ?>"<?= $Page->tan->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->tan->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->msme->Visible) { // msme ?>
    <div id="r_msme" class="row"<?= $Page->msme->rowAttributes() ?>>
        <label for="x_msme" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_msme"><?= $Page->msme->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_msme" id="z_msme" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->msme->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_msme" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->msme->getInputTextType() ?>" name="x_msme" id="x_msme" data-table="production_partner" data-field="x_msme" value="<?= $Page->msme->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->msme->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->msme->formatPattern()) ?>"<?= $Page->msme->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->msme->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->iec->Visible) { // iec ?>
    <div id="r_iec" class="row"<?= $Page->iec->rowAttributes() ?>>
        <label for="x_iec" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_iec"><?= $Page->iec->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_iec" id="z_iec" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->iec->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_iec" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->iec->getInputTextType() ?>" name="x_iec" id="x_iec" data-table="production_partner" data-field="x_iec" value="<?= $Page->iec->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->iec->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->iec->formatPattern()) ?>"<?= $Page->iec->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->iec->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rex->Visible) { // rex ?>
    <div id="r_rex" class="row"<?= $Page->rex->rowAttributes() ?>>
        <label for="x_rex" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_rex"><?= $Page->rex->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rex" id="z_rex" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rex->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_rex" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rex->getInputTextType() ?>" name="x_rex" id="x_rex" data-table="production_partner" data-field="x_rex" value="<?= $Page->rex->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->rex->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rex->formatPattern()) ?>"<?= $Page->rex->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rex->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rcmc->Visible) { // rcmc ?>
    <div id="r_rcmc" class="row"<?= $Page->rcmc->rowAttributes() ?>>
        <label for="x_rcmc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_rcmc"><?= $Page->rcmc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rcmc" id="z_rcmc" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rcmc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_rcmc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->rcmc->getInputTextType() ?>" name="x_rcmc" id="x_rcmc" data-table="production_partner" data-field="x_rcmc" value="<?= $Page->rcmc->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->rcmc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rcmc->formatPattern()) ?>"<?= $Page->rcmc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->rcmc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_terms->Visible) { // delivery_terms ?>
    <div id="r_delivery_terms" class="row"<?= $Page->delivery_terms->rowAttributes() ?>>
        <label for="x_delivery_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_delivery_terms"><?= $Page->delivery_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_terms" id="z_delivery_terms" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_delivery_terms" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->delivery_terms->getInputTextType() ?>" name="x_delivery_terms" id="x_delivery_terms" data-table="production_partner" data-field="x_delivery_terms" value="<?= $Page->delivery_terms->EditValue ?>" data-page="4" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->delivery_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_terms->formatPattern()) ?>"<?= $Page->delivery_terms->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->delivery_terms->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipping_terms->Visible) { // shipping_terms ?>
    <div id="r_shipping_terms" class="row"<?= $Page->shipping_terms->rowAttributes() ?>>
        <label for="x_shipping_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_shipping_terms"><?= $Page->shipping_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shipping_terms" id="z_shipping_terms" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_shipping_terms" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shipping_terms->getInputTextType() ?>" name="x_shipping_terms" id="x_shipping_terms" data-table="production_partner" data-field="x_shipping_terms" value="<?= $Page->shipping_terms->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->shipping_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_terms->formatPattern()) ?>"<?= $Page->shipping_terms->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipping_terms->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms" class="row"<?= $Page->payment_terms->rowAttributes() ?>>
        <label for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_payment_terms"><?= $Page->payment_terms->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_payment_terms" id="z_payment_terms" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_terms->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_payment_terms" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment_terms->getInputTextType() ?>" name="x_payment_terms" id="x_payment_terms" data-table="production_partner" data-field="x_payment_terms" value="<?= $Page->payment_terms->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_terms->formatPattern()) ?>"<?= $Page->payment_terms->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->export_type->Visible) { // export_type ?>
    <div id="r_export_type" class="row"<?= $Page->export_type->rowAttributes() ?>>
        <label for="x_export_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_export_type"><?= $Page->export_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_export_type" id="z_export_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->export_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_export_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->export_type->getInputTextType() ?>" name="x_export_type" id="x_export_type" data-table="production_partner" data-field="x_export_type" value="<?= $Page->export_type->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->export_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->export_type->formatPattern()) ?>"<?= $Page->export_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->export_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lead_time_ss->Visible) { // lead_time_ss ?>
    <div id="r_lead_time_ss" class="row"<?= $Page->lead_time_ss->rowAttributes() ?>>
        <label for="x_lead_time_ss" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_lead_time_ss"><?= $Page->lead_time_ss->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lead_time_ss" id="z_lead_time_ss" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lead_time_ss->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_lead_time_ss" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lead_time_ss->getInputTextType() ?>" name="x_lead_time_ss" id="x_lead_time_ss" data-table="production_partner" data-field="x_lead_time_ss" value="<?= $Page->lead_time_ss->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->lead_time_ss->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_time_ss->formatPattern()) ?>"<?= $Page->lead_time_ss->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lead_time_ss->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lead_time_cs->Visible) { // lead_time_cs ?>
    <div id="r_lead_time_cs" class="row"<?= $Page->lead_time_cs->rowAttributes() ?>>
        <label for="x_lead_time_cs" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_lead_time_cs"><?= $Page->lead_time_cs->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_lead_time_cs" id="z_lead_time_cs" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lead_time_cs->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_lead_time_cs" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lead_time_cs->getInputTextType() ?>" name="x_lead_time_cs" id="x_lead_time_cs" data-table="production_partner" data-field="x_lead_time_cs" value="<?= $Page->lead_time_cs->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->lead_time_cs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_time_cs->formatPattern()) ?>"<?= $Page->lead_time_cs->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lead_time_cs->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(5)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner5"><?= $Page->pageCaption(5) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(5)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner5"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->cha->Visible) { // cha ?>
    <div id="r_cha" class="row"<?= $Page->cha->rowAttributes() ?>>
        <label for="x_cha" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_cha"><?= $Page->cha->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cha" id="z_cha" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cha->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_cha" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cha->getInputTextType() ?>" name="x_cha" id="x_cha" data-table="production_partner" data-field="x_cha" value="<?= $Page->cha->EditValue ?>" data-page="5" maxlength="96" placeholder="<?= HtmlEncode($Page->cha->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cha->formatPattern()) ?>"<?= $Page->cha->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cha->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cha_email->Visible) { // cha_email ?>
    <div id="r_cha_email" class="row"<?= $Page->cha_email->rowAttributes() ?>>
        <label for="x_cha_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_cha_email"><?= $Page->cha_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cha_email" id="z_cha_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cha_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_cha_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cha_email->getInputTextType() ?>" name="x_cha_email" id="x_cha_email" data-table="production_partner" data-field="x_cha_email" value="<?= $Page->cha_email->EditValue ?>" data-page="5" maxlength="192" placeholder="<?= HtmlEncode($Page->cha_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cha_email->formatPattern()) ?>"<?= $Page->cha_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cha_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cha_phone->Visible) { // cha_phone ?>
    <div id="r_cha_phone" class="row"<?= $Page->cha_phone->rowAttributes() ?>>
        <label for="x_cha_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_cha_phone"><?= $Page->cha_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_cha_phone" id="z_cha_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cha_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_cha_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cha_phone->getInputTextType() ?>" name="x_cha_phone" id="x_cha_phone" data-table="production_partner" data-field="x_cha_phone" value="<?= $Page->cha_phone->EditValue ?>" data-page="5" maxlength="192" placeholder="<?= HtmlEncode($Page->cha_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cha_phone->formatPattern()) ?>"<?= $Page->cha_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cha_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(6)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(6)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner6"><?= $Page->pageCaption(6) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(6)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner6"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->forwarder->Visible) { // forwarder ?>
    <div id="r_forwarder" class="row"<?= $Page->forwarder->rowAttributes() ?>>
        <label for="x_forwarder" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_forwarder"><?= $Page->forwarder->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_forwarder" id="z_forwarder" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->forwarder->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_forwarder" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->forwarder->getInputTextType() ?>" name="x_forwarder" id="x_forwarder" data-table="production_partner" data-field="x_forwarder" value="<?= $Page->forwarder->EditValue ?>" data-page="6" maxlength="96" placeholder="<?= HtmlEncode($Page->forwarder->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->forwarder->formatPattern()) ?>"<?= $Page->forwarder->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->forwarder->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->forwarder_email->Visible) { // forwarder_email ?>
    <div id="r_forwarder_email" class="row"<?= $Page->forwarder_email->rowAttributes() ?>>
        <label for="x_forwarder_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_forwarder_email"><?= $Page->forwarder_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_forwarder_email" id="z_forwarder_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->forwarder_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_forwarder_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->forwarder_email->getInputTextType() ?>" name="x_forwarder_email" id="x_forwarder_email" data-table="production_partner" data-field="x_forwarder_email" value="<?= $Page->forwarder_email->EditValue ?>" data-page="6" maxlength="192" placeholder="<?= HtmlEncode($Page->forwarder_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->forwarder_email->formatPattern()) ?>"<?= $Page->forwarder_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->forwarder_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->forwarder_phone->Visible) { // forwarder_phone ?>
    <div id="r_forwarder_phone" class="row"<?= $Page->forwarder_phone->rowAttributes() ?>>
        <label for="x_forwarder_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_forwarder_phone"><?= $Page->forwarder_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_forwarder_phone" id="z_forwarder_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->forwarder_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_forwarder_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->forwarder_phone->getInputTextType() ?>" name="x_forwarder_phone" id="x_forwarder_phone" data-table="production_partner" data-field="x_forwarder_phone" value="<?= $Page->forwarder_phone->EditValue ?>" data-page="6" maxlength="192" placeholder="<?= HtmlEncode($Page->forwarder_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->forwarder_phone->formatPattern()) ?>"<?= $Page->forwarder_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->forwarder_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(7)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(7)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner7"><?= $Page->pageCaption(7) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(7)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner7"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->merchant->Visible) { // merchant ?>
    <div id="r_merchant" class="row"<?= $Page->merchant->rowAttributes() ?>>
        <label for="x_merchant" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_merchant"><?= $Page->merchant->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_merchant" id="z_merchant" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->merchant->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_merchant" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->merchant->getInputTextType() ?>" name="x_merchant" id="x_merchant" data-table="production_partner" data-field="x_merchant" value="<?= $Page->merchant->EditValue ?>" data-page="7" maxlength="192" placeholder="<?= HtmlEncode($Page->merchant->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->merchant->formatPattern()) ?>"<?= $Page->merchant->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->merchant->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->merchant_email->Visible) { // merchant_email ?>
    <div id="r_merchant_email" class="row"<?= $Page->merchant_email->rowAttributes() ?>>
        <label for="x_merchant_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_merchant_email"><?= $Page->merchant_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_merchant_email" id="z_merchant_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->merchant_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_merchant_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->merchant_email->getInputTextType() ?>" name="x_merchant_email" id="x_merchant_email" data-table="production_partner" data-field="x_merchant_email" value="<?= $Page->merchant_email->EditValue ?>" data-page="7" maxlength="192" placeholder="<?= HtmlEncode($Page->merchant_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->merchant_email->formatPattern()) ?>"<?= $Page->merchant_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->merchant_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->merchant_phone->Visible) { // merchant_phone ?>
    <div id="r_merchant_phone" class="row"<?= $Page->merchant_phone->rowAttributes() ?>>
        <label for="x_merchant_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_merchant_phone"><?= $Page->merchant_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_merchant_phone" id="z_merchant_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->merchant_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_merchant_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->merchant_phone->getInputTextType() ?>" name="x_merchant_phone" id="x_merchant_phone" data-table="production_partner" data-field="x_merchant_phone" value="<?= $Page->merchant_phone->EditValue ?>" data-page="7" maxlength="192" placeholder="<?= HtmlEncode($Page->merchant_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->merchant_phone->formatPattern()) ?>"<?= $Page->merchant_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->merchant_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(8)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(8)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner8"><?= $Page->pageCaption(8) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(8)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner8"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->shipping_incharge->Visible) { // shipping_incharge ?>
    <div id="r_shipping_incharge" class="row"<?= $Page->shipping_incharge->rowAttributes() ?>>
        <label for="x_shipping_incharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_shipping_incharge"><?= $Page->shipping_incharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shipping_incharge" id="z_shipping_incharge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_incharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_shipping_incharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shipping_incharge->getInputTextType() ?>" name="x_shipping_incharge" id="x_shipping_incharge" data-table="production_partner" data-field="x_shipping_incharge" value="<?= $Page->shipping_incharge->EditValue ?>" data-page="8" maxlength="192" placeholder="<?= HtmlEncode($Page->shipping_incharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_incharge->formatPattern()) ?>"<?= $Page->shipping_incharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipping_incharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipping_email->Visible) { // shipping_email ?>
    <div id="r_shipping_email" class="row"<?= $Page->shipping_email->rowAttributes() ?>>
        <label for="x_shipping_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_shipping_email"><?= $Page->shipping_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shipping_email" id="z_shipping_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_shipping_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shipping_email->getInputTextType() ?>" name="x_shipping_email" id="x_shipping_email" data-table="production_partner" data-field="x_shipping_email" value="<?= $Page->shipping_email->EditValue ?>" data-page="8" maxlength="192" placeholder="<?= HtmlEncode($Page->shipping_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_email->formatPattern()) ?>"<?= $Page->shipping_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipping_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipping_phone->Visible) { // shipping_phone ?>
    <div id="r_shipping_phone" class="row"<?= $Page->shipping_phone->rowAttributes() ?>>
        <label for="x_shipping_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_shipping_phone"><?= $Page->shipping_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_shipping_phone" id="z_shipping_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_shipping_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->shipping_phone->getInputTextType() ?>" name="x_shipping_phone" id="x_shipping_phone" data-table="production_partner" data-field="x_shipping_phone" value="<?= $Page->shipping_phone->EditValue ?>" data-page="8" maxlength="192" placeholder="<?= HtmlEncode($Page->shipping_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_phone->formatPattern()) ?>"<?= $Page->shipping_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->shipping_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(9)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(9)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner9"><?= $Page->pageCaption(9) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(9)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner9"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->account_incharge->Visible) { // account_incharge ?>
    <div id="r_account_incharge" class="row"<?= $Page->account_incharge->rowAttributes() ?>>
        <label for="x_account_incharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_account_incharge"><?= $Page->account_incharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_account_incharge" id="z_account_incharge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->account_incharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_account_incharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->account_incharge->getInputTextType() ?>" name="x_account_incharge" id="x_account_incharge" data-table="production_partner" data-field="x_account_incharge" value="<?= $Page->account_incharge->EditValue ?>" data-page="9" maxlength="192" placeholder="<?= HtmlEncode($Page->account_incharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->account_incharge->formatPattern()) ?>"<?= $Page->account_incharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->account_incharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->accounts_email->Visible) { // accounts_email ?>
    <div id="r_accounts_email" class="row"<?= $Page->accounts_email->rowAttributes() ?>>
        <label for="x_accounts_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_accounts_email"><?= $Page->accounts_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_accounts_email" id="z_accounts_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->accounts_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_accounts_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->accounts_email->getInputTextType() ?>" name="x_accounts_email" id="x_accounts_email" data-table="production_partner" data-field="x_accounts_email" value="<?= $Page->accounts_email->EditValue ?>" data-page="9" maxlength="192" placeholder="<?= HtmlEncode($Page->accounts_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->accounts_email->formatPattern()) ?>"<?= $Page->accounts_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->accounts_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->accounts_phone->Visible) { // accounts_phone ?>
    <div id="r_accounts_phone" class="row"<?= $Page->accounts_phone->rowAttributes() ?>>
        <label for="x_accounts_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_accounts_phone"><?= $Page->accounts_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_accounts_phone" id="z_accounts_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->accounts_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_accounts_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->accounts_phone->getInputTextType() ?>" name="x_accounts_phone" id="x_accounts_phone" data-table="production_partner" data-field="x_accounts_phone" value="<?= $Page->accounts_phone->EditValue ?>" data-page="9" maxlength="192" placeholder="<?= HtmlEncode($Page->accounts_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->accounts_phone->formatPattern()) ?>"<?= $Page->accounts_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->accounts_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(10)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(10)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner10"><?= $Page->pageCaption(10) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(10)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner10"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->warehouse_incharge->Visible) { // warehouse_incharge ?>
    <div id="r_warehouse_incharge" class="row"<?= $Page->warehouse_incharge->rowAttributes() ?>>
        <label for="x_warehouse_incharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_warehouse_incharge"><?= $Page->warehouse_incharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_warehouse_incharge" id="z_warehouse_incharge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->warehouse_incharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_warehouse_incharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->warehouse_incharge->getInputTextType() ?>" name="x_warehouse_incharge" id="x_warehouse_incharge" data-table="production_partner" data-field="x_warehouse_incharge" value="<?= $Page->warehouse_incharge->EditValue ?>" data-page="10" maxlength="192" placeholder="<?= HtmlEncode($Page->warehouse_incharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->warehouse_incharge->formatPattern()) ?>"<?= $Page->warehouse_incharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->warehouse_incharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->warehouse_email->Visible) { // warehouse_email ?>
    <div id="r_warehouse_email" class="row"<?= $Page->warehouse_email->rowAttributes() ?>>
        <label for="x_warehouse_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_warehouse_email"><?= $Page->warehouse_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_warehouse_email" id="z_warehouse_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->warehouse_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_warehouse_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->warehouse_email->getInputTextType() ?>" name="x_warehouse_email" id="x_warehouse_email" data-table="production_partner" data-field="x_warehouse_email" value="<?= $Page->warehouse_email->EditValue ?>" data-page="10" maxlength="192" placeholder="<?= HtmlEncode($Page->warehouse_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->warehouse_email->formatPattern()) ?>"<?= $Page->warehouse_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->warehouse_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->warehouse_phone->Visible) { // warehouse_phone ?>
    <div id="r_warehouse_phone" class="row"<?= $Page->warehouse_phone->rowAttributes() ?>>
        <label for="x_warehouse_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_warehouse_phone"><?= $Page->warehouse_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_warehouse_phone" id="z_warehouse_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->warehouse_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_warehouse_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->warehouse_phone->getInputTextType() ?>" name="x_warehouse_phone" id="x_warehouse_phone" data-table="production_partner" data-field="x_warehouse_phone" value="<?= $Page->warehouse_phone->EditValue ?>" data-page="10" maxlength="192" placeholder="<?= HtmlEncode($Page->warehouse_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->warehouse_phone->formatPattern()) ?>"<?= $Page->warehouse_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->warehouse_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(11)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(11)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner11"><?= $Page->pageCaption(11) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(11)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner11"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->production_incharge->Visible) { // production_incharge ?>
    <div id="r_production_incharge" class="row"<?= $Page->production_incharge->rowAttributes() ?>>
        <label for="x_production_incharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_production_incharge"><?= $Page->production_incharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_production_incharge" id="z_production_incharge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->production_incharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_production_incharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->production_incharge->getInputTextType() ?>" name="x_production_incharge" id="x_production_incharge" data-table="production_partner" data-field="x_production_incharge" value="<?= $Page->production_incharge->EditValue ?>" data-page="11" maxlength="192" placeholder="<?= HtmlEncode($Page->production_incharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->production_incharge->formatPattern()) ?>"<?= $Page->production_incharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->production_incharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->production_email->Visible) { // production_email ?>
    <div id="r_production_email" class="row"<?= $Page->production_email->rowAttributes() ?>>
        <label for="x_production_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_production_email"><?= $Page->production_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_production_email" id="z_production_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->production_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_production_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->production_email->getInputTextType() ?>" name="x_production_email" id="x_production_email" data-table="production_partner" data-field="x_production_email" value="<?= $Page->production_email->EditValue ?>" data-page="11" maxlength="192" placeholder="<?= HtmlEncode($Page->production_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->production_email->formatPattern()) ?>"<?= $Page->production_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->production_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->production_phone->Visible) { // production_phone ?>
    <div id="r_production_phone" class="row"<?= $Page->production_phone->rowAttributes() ?>>
        <label for="x_production_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_production_phone"><?= $Page->production_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_production_phone" id="z_production_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->production_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_production_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->production_phone->getInputTextType() ?>" name="x_production_phone" id="x_production_phone" data-table="production_partner" data-field="x_production_phone" value="<?= $Page->production_phone->EditValue ?>" data-page="11" maxlength="192" placeholder="<?= HtmlEncode($Page->production_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->production_phone->formatPattern()) ?>"<?= $Page->production_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->production_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
    <div class="accordion-item ew-accordion-item">
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(12)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(12)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner12"><?= $Page->pageCaption(12) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(12)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner12"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->qc_incharge->Visible) { // qc_incharge ?>
    <div id="r_qc_incharge" class="row"<?= $Page->qc_incharge->rowAttributes() ?>>
        <label for="x_qc_incharge" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_qc_incharge"><?= $Page->qc_incharge->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_qc_incharge" id="z_qc_incharge" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_incharge->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_qc_incharge" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_incharge->getInputTextType() ?>" name="x_qc_incharge" id="x_qc_incharge" data-table="production_partner" data-field="x_qc_incharge" value="<?= $Page->qc_incharge->EditValue ?>" data-page="12" maxlength="192" placeholder="<?= HtmlEncode($Page->qc_incharge->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_incharge->formatPattern()) ?>"<?= $Page->qc_incharge->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_incharge->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_email->Visible) { // qc_email ?>
    <div id="r_qc_email" class="row"<?= $Page->qc_email->rowAttributes() ?>>
        <label for="x_qc_email" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_qc_email"><?= $Page->qc_email->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_qc_email" id="z_qc_email" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_email->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_qc_email" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_email->getInputTextType() ?>" name="x_qc_email" id="x_qc_email" data-table="production_partner" data-field="x_qc_email" value="<?= $Page->qc_email->EditValue ?>" data-page="12" maxlength="192" placeholder="<?= HtmlEncode($Page->qc_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_email->formatPattern()) ?>"<?= $Page->qc_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_email->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->qc_phone->Visible) { // qc_phone ?>
    <div id="r_qc_phone" class="row"<?= $Page->qc_phone->rowAttributes() ?>>
        <label for="x_qc_phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_partner_qc_phone"><?= $Page->qc_phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_qc_phone" id="z_qc_phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->qc_phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_partner_qc_phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->qc_phone->getInputTextType() ?>" name="x_qc_phone" id="x_qc_phone" data-table="production_partner" data-field="x_qc_phone" value="<?= $Page->qc_phone->EditValue ?>" data-page="12" maxlength="192" placeholder="<?= HtmlEncode($Page->qc_phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->qc_phone->formatPattern()) ?>"<?= $Page->qc_phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->qc_phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduction_partnersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduction_partnersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fproduction_partnersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_partner");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
