<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionPartnerList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_partner: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fproduction_partnersrch" id="fproduction_partnersrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fproduction_partnersrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_partner: currentTable } });
var currentForm;
var fproduction_partnersrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduction_partnersrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fproduction_partnersrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fproduction_partnersrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fproduction_partnersrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fproduction_partnersrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fproduction_partnersrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fproduction_partnersrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fproduction_partnersrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_production_partner" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_production_partnerlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_production_partner_id" class="production_partner_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Page->name->headerCellClass() ?>"><div id="elh_production_partner_name" class="production_partner_name"><?= $Page->renderFieldHeader($Page->name) ?></div></th>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
        <th data-name="code" class="<?= $Page->code->headerCellClass() ?>"><div id="elh_production_partner_code" class="production_partner_code"><?= $Page->renderFieldHeader($Page->code) ?></div></th>
<?php } ?>
<?php if ($Page->country->Visible) { // country ?>
        <th data-name="country" class="<?= $Page->country->headerCellClass() ?>"><div id="elh_production_partner_country" class="production_partner_country"><?= $Page->renderFieldHeader($Page->country) ?></div></th>
<?php } ?>
<?php if ($Page->region->Visible) { // region ?>
        <th data-name="region" class="<?= $Page->region->headerCellClass() ?>"><div id="elh_production_partner_region" class="production_partner_region"><?= $Page->renderFieldHeader($Page->region) ?></div></th>
<?php } ?>
<?php if ($Page->city_name->Visible) { // city_name ?>
        <th data-name="city_name" class="<?= $Page->city_name->headerCellClass() ?>"><div id="elh_production_partner_city_name" class="production_partner_city_name"><?= $Page->renderFieldHeader($Page->city_name) ?></div></th>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Page->address->headerCellClass() ?>"><div id="elh_production_partner_address" class="production_partner_address"><?= $Page->renderFieldHeader($Page->address) ?></div></th>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Page->mobile->headerCellClass() ?>"><div id="elh_production_partner_mobile" class="production_partner_mobile"><?= $Page->renderFieldHeader($Page->mobile) ?></div></th>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
        <th data-name="_email" class="<?= $Page->_email->headerCellClass() ?>"><div id="elh_production_partner__email" class="production_partner__email"><?= $Page->renderFieldHeader($Page->_email) ?></div></th>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
        <th data-name="url" class="<?= $Page->url->headerCellClass() ?>"><div id="elh_production_partner_url" class="production_partner_url"><?= $Page->renderFieldHeader($Page->url) ?></div></th>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
        <th data-name="bank_name" class="<?= $Page->bank_name->headerCellClass() ?>"><div id="elh_production_partner_bank_name" class="production_partner_bank_name"><?= $Page->renderFieldHeader($Page->bank_name) ?></div></th>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
        <th data-name="bank_account_no" class="<?= $Page->bank_account_no->headerCellClass() ?>"><div id="elh_production_partner_bank_account_no" class="production_partner_bank_account_no"><?= $Page->renderFieldHeader($Page->bank_account_no) ?></div></th>
<?php } ?>
<?php if ($Page->bank_code->Visible) { // bank_code ?>
        <th data-name="bank_code" class="<?= $Page->bank_code->headerCellClass() ?>"><div id="elh_production_partner_bank_code" class="production_partner_bank_code"><?= $Page->renderFieldHeader($Page->bank_code) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_production_partner_grp" class="production_partner_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_production_partner_category" class="production_partner_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
        <th data-name="reports_to" class="<?= $Page->reports_to->headerCellClass() ?>"><div id="elh_production_partner_reports_to" class="production_partner_reports_to"><?= $Page->renderFieldHeader($Page->reports_to) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_production_partner_status" class="production_partner_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->performance->Visible) { // performance ?>
        <th data-name="performance" class="<?= $Page->performance->headerCellClass() ?>"><div id="elh_production_partner_performance" class="production_partner_performance"><?= $Page->renderFieldHeader($Page->performance) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_production_partner_operator" class="production_partner_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_production_partner_datetime" class="production_partner_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Page->type->headerCellClass() ?>"><div id="elh_production_partner_type" class="production_partner_type"><?= $Page->renderFieldHeader($Page->type) ?></div></th>
<?php } ?>
<?php if ($Page->tax_registration->Visible) { // tax_registration ?>
        <th data-name="tax_registration" class="<?= $Page->tax_registration->headerCellClass() ?>"><div id="elh_production_partner_tax_registration" class="production_partner_tax_registration"><?= $Page->renderFieldHeader($Page->tax_registration) ?></div></th>
<?php } ?>
<?php if ($Page->cin->Visible) { // cin ?>
        <th data-name="cin" class="<?= $Page->cin->headerCellClass() ?>"><div id="elh_production_partner_cin" class="production_partner_cin"><?= $Page->renderFieldHeader($Page->cin) ?></div></th>
<?php } ?>
<?php if ($Page->pan->Visible) { // pan ?>
        <th data-name="pan" class="<?= $Page->pan->headerCellClass() ?>"><div id="elh_production_partner_pan" class="production_partner_pan"><?= $Page->renderFieldHeader($Page->pan) ?></div></th>
<?php } ?>
<?php if ($Page->tan->Visible) { // tan ?>
        <th data-name="tan" class="<?= $Page->tan->headerCellClass() ?>"><div id="elh_production_partner_tan" class="production_partner_tan"><?= $Page->renderFieldHeader($Page->tan) ?></div></th>
<?php } ?>
<?php if ($Page->msme->Visible) { // msme ?>
        <th data-name="msme" class="<?= $Page->msme->headerCellClass() ?>"><div id="elh_production_partner_msme" class="production_partner_msme"><?= $Page->renderFieldHeader($Page->msme) ?></div></th>
<?php } ?>
<?php if ($Page->port_air->Visible) { // port_air ?>
        <th data-name="port_air" class="<?= $Page->port_air->headerCellClass() ?>"><div id="elh_production_partner_port_air" class="production_partner_port_air"><?= $Page->renderFieldHeader($Page->port_air) ?></div></th>
<?php } ?>
<?php if ($Page->port_sea->Visible) { // port_sea ?>
        <th data-name="port_sea" class="<?= $Page->port_sea->headerCellClass() ?>"><div id="elh_production_partner_port_sea" class="production_partner_port_sea"><?= $Page->renderFieldHeader($Page->port_sea) ?></div></th>
<?php } ?>
<?php if ($Page->iec->Visible) { // iec ?>
        <th data-name="iec" class="<?= $Page->iec->headerCellClass() ?>"><div id="elh_production_partner_iec" class="production_partner_iec"><?= $Page->renderFieldHeader($Page->iec) ?></div></th>
<?php } ?>
<?php if ($Page->rex->Visible) { // rex ?>
        <th data-name="rex" class="<?= $Page->rex->headerCellClass() ?>"><div id="elh_production_partner_rex" class="production_partner_rex"><?= $Page->renderFieldHeader($Page->rex) ?></div></th>
<?php } ?>
<?php if ($Page->rcmc->Visible) { // rcmc ?>
        <th data-name="rcmc" class="<?= $Page->rcmc->headerCellClass() ?>"><div id="elh_production_partner_rcmc" class="production_partner_rcmc"><?= $Page->renderFieldHeader($Page->rcmc) ?></div></th>
<?php } ?>
<?php if ($Page->delivery_terms->Visible) { // delivery_terms ?>
        <th data-name="delivery_terms" class="<?= $Page->delivery_terms->headerCellClass() ?>"><div id="elh_production_partner_delivery_terms" class="production_partner_delivery_terms"><?= $Page->renderFieldHeader($Page->delivery_terms) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_terms->Visible) { // shipping_terms ?>
        <th data-name="shipping_terms" class="<?= $Page->shipping_terms->headerCellClass() ?>"><div id="elh_production_partner_shipping_terms" class="production_partner_shipping_terms"><?= $Page->renderFieldHeader($Page->shipping_terms) ?></div></th>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
        <th data-name="payment_terms" class="<?= $Page->payment_terms->headerCellClass() ?>"><div id="elh_production_partner_payment_terms" class="production_partner_payment_terms"><?= $Page->renderFieldHeader($Page->payment_terms) ?></div></th>
<?php } ?>
<?php if ($Page->export_type->Visible) { // export_type ?>
        <th data-name="export_type" class="<?= $Page->export_type->headerCellClass() ?>"><div id="elh_production_partner_export_type" class="production_partner_export_type"><?= $Page->renderFieldHeader($Page->export_type) ?></div></th>
<?php } ?>
<?php if ($Page->lead_time_ss->Visible) { // lead_time_ss ?>
        <th data-name="lead_time_ss" class="<?= $Page->lead_time_ss->headerCellClass() ?>"><div id="elh_production_partner_lead_time_ss" class="production_partner_lead_time_ss"><?= $Page->renderFieldHeader($Page->lead_time_ss) ?></div></th>
<?php } ?>
<?php if ($Page->lead_time_cs->Visible) { // lead_time_cs ?>
        <th data-name="lead_time_cs" class="<?= $Page->lead_time_cs->headerCellClass() ?>"><div id="elh_production_partner_lead_time_cs" class="production_partner_lead_time_cs"><?= $Page->renderFieldHeader($Page->lead_time_cs) ?></div></th>
<?php } ?>
<?php if ($Page->cha->Visible) { // cha ?>
        <th data-name="cha" class="<?= $Page->cha->headerCellClass() ?>"><div id="elh_production_partner_cha" class="production_partner_cha"><?= $Page->renderFieldHeader($Page->cha) ?></div></th>
<?php } ?>
<?php if ($Page->cha_email->Visible) { // cha_email ?>
        <th data-name="cha_email" class="<?= $Page->cha_email->headerCellClass() ?>"><div id="elh_production_partner_cha_email" class="production_partner_cha_email"><?= $Page->renderFieldHeader($Page->cha_email) ?></div></th>
<?php } ?>
<?php if ($Page->cha_phone->Visible) { // cha_phone ?>
        <th data-name="cha_phone" class="<?= $Page->cha_phone->headerCellClass() ?>"><div id="elh_production_partner_cha_phone" class="production_partner_cha_phone"><?= $Page->renderFieldHeader($Page->cha_phone) ?></div></th>
<?php } ?>
<?php if ($Page->forwarder->Visible) { // forwarder ?>
        <th data-name="forwarder" class="<?= $Page->forwarder->headerCellClass() ?>"><div id="elh_production_partner_forwarder" class="production_partner_forwarder"><?= $Page->renderFieldHeader($Page->forwarder) ?></div></th>
<?php } ?>
<?php if ($Page->forwarder_email->Visible) { // forwarder_email ?>
        <th data-name="forwarder_email" class="<?= $Page->forwarder_email->headerCellClass() ?>"><div id="elh_production_partner_forwarder_email" class="production_partner_forwarder_email"><?= $Page->renderFieldHeader($Page->forwarder_email) ?></div></th>
<?php } ?>
<?php if ($Page->forwarder_phone->Visible) { // forwarder_phone ?>
        <th data-name="forwarder_phone" class="<?= $Page->forwarder_phone->headerCellClass() ?>"><div id="elh_production_partner_forwarder_phone" class="production_partner_forwarder_phone"><?= $Page->renderFieldHeader($Page->forwarder_phone) ?></div></th>
<?php } ?>
<?php if ($Page->merchant->Visible) { // merchant ?>
        <th data-name="merchant" class="<?= $Page->merchant->headerCellClass() ?>"><div id="elh_production_partner_merchant" class="production_partner_merchant"><?= $Page->renderFieldHeader($Page->merchant) ?></div></th>
<?php } ?>
<?php if ($Page->merchant_email->Visible) { // merchant_email ?>
        <th data-name="merchant_email" class="<?= $Page->merchant_email->headerCellClass() ?>"><div id="elh_production_partner_merchant_email" class="production_partner_merchant_email"><?= $Page->renderFieldHeader($Page->merchant_email) ?></div></th>
<?php } ?>
<?php if ($Page->merchant_phone->Visible) { // merchant_phone ?>
        <th data-name="merchant_phone" class="<?= $Page->merchant_phone->headerCellClass() ?>"><div id="elh_production_partner_merchant_phone" class="production_partner_merchant_phone"><?= $Page->renderFieldHeader($Page->merchant_phone) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_incharge->Visible) { // shipping_incharge ?>
        <th data-name="shipping_incharge" class="<?= $Page->shipping_incharge->headerCellClass() ?>"><div id="elh_production_partner_shipping_incharge" class="production_partner_shipping_incharge"><?= $Page->renderFieldHeader($Page->shipping_incharge) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_email->Visible) { // shipping_email ?>
        <th data-name="shipping_email" class="<?= $Page->shipping_email->headerCellClass() ?>"><div id="elh_production_partner_shipping_email" class="production_partner_shipping_email"><?= $Page->renderFieldHeader($Page->shipping_email) ?></div></th>
<?php } ?>
<?php if ($Page->shipping_phone->Visible) { // shipping_phone ?>
        <th data-name="shipping_phone" class="<?= $Page->shipping_phone->headerCellClass() ?>"><div id="elh_production_partner_shipping_phone" class="production_partner_shipping_phone"><?= $Page->renderFieldHeader($Page->shipping_phone) ?></div></th>
<?php } ?>
<?php if ($Page->account_incharge->Visible) { // account_incharge ?>
        <th data-name="account_incharge" class="<?= $Page->account_incharge->headerCellClass() ?>"><div id="elh_production_partner_account_incharge" class="production_partner_account_incharge"><?= $Page->renderFieldHeader($Page->account_incharge) ?></div></th>
<?php } ?>
<?php if ($Page->accounts_email->Visible) { // accounts_email ?>
        <th data-name="accounts_email" class="<?= $Page->accounts_email->headerCellClass() ?>"><div id="elh_production_partner_accounts_email" class="production_partner_accounts_email"><?= $Page->renderFieldHeader($Page->accounts_email) ?></div></th>
<?php } ?>
<?php if ($Page->accounts_phone->Visible) { // accounts_phone ?>
        <th data-name="accounts_phone" class="<?= $Page->accounts_phone->headerCellClass() ?>"><div id="elh_production_partner_accounts_phone" class="production_partner_accounts_phone"><?= $Page->renderFieldHeader($Page->accounts_phone) ?></div></th>
<?php } ?>
<?php if ($Page->warehouse_incharge->Visible) { // warehouse_incharge ?>
        <th data-name="warehouse_incharge" class="<?= $Page->warehouse_incharge->headerCellClass() ?>"><div id="elh_production_partner_warehouse_incharge" class="production_partner_warehouse_incharge"><?= $Page->renderFieldHeader($Page->warehouse_incharge) ?></div></th>
<?php } ?>
<?php if ($Page->warehouse_email->Visible) { // warehouse_email ?>
        <th data-name="warehouse_email" class="<?= $Page->warehouse_email->headerCellClass() ?>"><div id="elh_production_partner_warehouse_email" class="production_partner_warehouse_email"><?= $Page->renderFieldHeader($Page->warehouse_email) ?></div></th>
<?php } ?>
<?php if ($Page->warehouse_phone->Visible) { // warehouse_phone ?>
        <th data-name="warehouse_phone" class="<?= $Page->warehouse_phone->headerCellClass() ?>"><div id="elh_production_partner_warehouse_phone" class="production_partner_warehouse_phone"><?= $Page->renderFieldHeader($Page->warehouse_phone) ?></div></th>
<?php } ?>
<?php if ($Page->production_incharge->Visible) { // production_incharge ?>
        <th data-name="production_incharge" class="<?= $Page->production_incharge->headerCellClass() ?>"><div id="elh_production_partner_production_incharge" class="production_partner_production_incharge"><?= $Page->renderFieldHeader($Page->production_incharge) ?></div></th>
<?php } ?>
<?php if ($Page->production_email->Visible) { // production_email ?>
        <th data-name="production_email" class="<?= $Page->production_email->headerCellClass() ?>"><div id="elh_production_partner_production_email" class="production_partner_production_email"><?= $Page->renderFieldHeader($Page->production_email) ?></div></th>
<?php } ?>
<?php if ($Page->production_phone->Visible) { // production_phone ?>
        <th data-name="production_phone" class="<?= $Page->production_phone->headerCellClass() ?>"><div id="elh_production_partner_production_phone" class="production_partner_production_phone"><?= $Page->renderFieldHeader($Page->production_phone) ?></div></th>
<?php } ?>
<?php if ($Page->qc_incharge->Visible) { // qc_incharge ?>
        <th data-name="qc_incharge" class="<?= $Page->qc_incharge->headerCellClass() ?>"><div id="elh_production_partner_qc_incharge" class="production_partner_qc_incharge"><?= $Page->renderFieldHeader($Page->qc_incharge) ?></div></th>
<?php } ?>
<?php if ($Page->qc_email->Visible) { // qc_email ?>
        <th data-name="qc_email" class="<?= $Page->qc_email->headerCellClass() ?>"><div id="elh_production_partner_qc_email" class="production_partner_qc_email"><?= $Page->renderFieldHeader($Page->qc_email) ?></div></th>
<?php } ?>
<?php if ($Page->qc_phone->Visible) { // qc_phone ?>
        <th data-name="qc_phone" class="<?= $Page->qc_phone->headerCellClass() ?>"><div id="elh_production_partner_qc_phone" class="production_partner_qc_phone"><?= $Page->renderFieldHeader($Page->qc_phone) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_id" class="el_production_partner_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name"<?= $Page->name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_name" class="el_production_partner_name">
<span<?= $Page->name->viewAttributes() ?>>
<?= $Page->name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->code->Visible) { // code ?>
        <td data-name="code"<?= $Page->code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_code" class="el_production_partner_code">
<span<?= $Page->code->viewAttributes() ?>>
<?= $Page->code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->country->Visible) { // country ?>
        <td data-name="country"<?= $Page->country->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_country" class="el_production_partner_country">
<span<?= $Page->country->viewAttributes() ?>>
<?= $Page->country->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->region->Visible) { // region ?>
        <td data-name="region"<?= $Page->region->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_region" class="el_production_partner_region">
<span<?= $Page->region->viewAttributes() ?>>
<?= $Page->region->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city_name->Visible) { // city_name ?>
        <td data-name="city_name"<?= $Page->city_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_city_name" class="el_production_partner_city_name">
<span<?= $Page->city_name->viewAttributes() ?>>
<?= $Page->city_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->address->Visible) { // address ?>
        <td data-name="address"<?= $Page->address->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_address" class="el_production_partner_address">
<span<?= $Page->address->viewAttributes() ?>>
<?= $Page->address->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_mobile" class="el_production_partner_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_email->Visible) { // email ?>
        <td data-name="_email"<?= $Page->_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner__email" class="el_production_partner__email">
<span<?= $Page->_email->viewAttributes() ?>>
<?= $Page->_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->url->Visible) { // url ?>
        <td data-name="url"<?= $Page->url->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_url" class="el_production_partner_url">
<span<?= $Page->url->viewAttributes() ?>>
<?= $Page->url->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_name->Visible) { // bank_name ?>
        <td data-name="bank_name"<?= $Page->bank_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_bank_name" class="el_production_partner_bank_name">
<span<?= $Page->bank_name->viewAttributes() ?>>
<?= $Page->bank_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
        <td data-name="bank_account_no"<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_bank_account_no" class="el_production_partner_bank_account_no">
<span<?= $Page->bank_account_no->viewAttributes() ?>>
<?= $Page->bank_account_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_code->Visible) { // bank_code ?>
        <td data-name="bank_code"<?= $Page->bank_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_bank_code" class="el_production_partner_bank_code">
<span<?= $Page->bank_code->viewAttributes() ?>>
<?= $Page->bank_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_grp" class="el_production_partner_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_category" class="el_production_partner_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reports_to->Visible) { // reports_to ?>
        <td data-name="reports_to"<?= $Page->reports_to->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_reports_to" class="el_production_partner_reports_to">
<span<?= $Page->reports_to->viewAttributes() ?>>
<?= $Page->reports_to->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_status" class="el_production_partner_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->performance->Visible) { // performance ?>
        <td data-name="performance"<?= $Page->performance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_performance" class="el_production_partner_performance">
<span<?= $Page->performance->viewAttributes() ?>>
<?= $Page->performance->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_operator" class="el_production_partner_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_datetime" class="el_production_partner_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->type->Visible) { // type ?>
        <td data-name="type"<?= $Page->type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_type" class="el_production_partner_type">
<span<?= $Page->type->viewAttributes() ?>>
<?= $Page->type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tax_registration->Visible) { // tax_registration ?>
        <td data-name="tax_registration"<?= $Page->tax_registration->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_tax_registration" class="el_production_partner_tax_registration">
<span<?= $Page->tax_registration->viewAttributes() ?>>
<?= $Page->tax_registration->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cin->Visible) { // cin ?>
        <td data-name="cin"<?= $Page->cin->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_cin" class="el_production_partner_cin">
<span<?= $Page->cin->viewAttributes() ?>>
<?= $Page->cin->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pan->Visible) { // pan ?>
        <td data-name="pan"<?= $Page->pan->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_pan" class="el_production_partner_pan">
<span<?= $Page->pan->viewAttributes() ?>>
<?= $Page->pan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->tan->Visible) { // tan ?>
        <td data-name="tan"<?= $Page->tan->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_tan" class="el_production_partner_tan">
<span<?= $Page->tan->viewAttributes() ?>>
<?= $Page->tan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->msme->Visible) { // msme ?>
        <td data-name="msme"<?= $Page->msme->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_msme" class="el_production_partner_msme">
<span<?= $Page->msme->viewAttributes() ?>>
<?= $Page->msme->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->port_air->Visible) { // port_air ?>
        <td data-name="port_air"<?= $Page->port_air->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_port_air" class="el_production_partner_port_air">
<span<?= $Page->port_air->viewAttributes() ?>>
<?= $Page->port_air->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->port_sea->Visible) { // port_sea ?>
        <td data-name="port_sea"<?= $Page->port_sea->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_port_sea" class="el_production_partner_port_sea">
<span<?= $Page->port_sea->viewAttributes() ?>>
<?= $Page->port_sea->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->iec->Visible) { // iec ?>
        <td data-name="iec"<?= $Page->iec->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_iec" class="el_production_partner_iec">
<span<?= $Page->iec->viewAttributes() ?>>
<?= $Page->iec->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rex->Visible) { // rex ?>
        <td data-name="rex"<?= $Page->rex->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_rex" class="el_production_partner_rex">
<span<?= $Page->rex->viewAttributes() ?>>
<?= $Page->rex->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rcmc->Visible) { // rcmc ?>
        <td data-name="rcmc"<?= $Page->rcmc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_rcmc" class="el_production_partner_rcmc">
<span<?= $Page->rcmc->viewAttributes() ?>>
<?= $Page->rcmc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->delivery_terms->Visible) { // delivery_terms ?>
        <td data-name="delivery_terms"<?= $Page->delivery_terms->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_delivery_terms" class="el_production_partner_delivery_terms">
<span<?= $Page->delivery_terms->viewAttributes() ?>>
<?= $Page->delivery_terms->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_terms->Visible) { // shipping_terms ?>
        <td data-name="shipping_terms"<?= $Page->shipping_terms->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_shipping_terms" class="el_production_partner_shipping_terms">
<span<?= $Page->shipping_terms->viewAttributes() ?>>
<?= $Page->shipping_terms->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->payment_terms->Visible) { // payment_terms ?>
        <td data-name="payment_terms"<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_payment_terms" class="el_production_partner_payment_terms">
<span<?= $Page->payment_terms->viewAttributes() ?>>
<?= $Page->payment_terms->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->export_type->Visible) { // export_type ?>
        <td data-name="export_type"<?= $Page->export_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_export_type" class="el_production_partner_export_type">
<span<?= $Page->export_type->viewAttributes() ?>>
<?= $Page->export_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lead_time_ss->Visible) { // lead_time_ss ?>
        <td data-name="lead_time_ss"<?= $Page->lead_time_ss->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_lead_time_ss" class="el_production_partner_lead_time_ss">
<span<?= $Page->lead_time_ss->viewAttributes() ?>>
<?= $Page->lead_time_ss->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lead_time_cs->Visible) { // lead_time_cs ?>
        <td data-name="lead_time_cs"<?= $Page->lead_time_cs->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_lead_time_cs" class="el_production_partner_lead_time_cs">
<span<?= $Page->lead_time_cs->viewAttributes() ?>>
<?= $Page->lead_time_cs->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cha->Visible) { // cha ?>
        <td data-name="cha"<?= $Page->cha->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_cha" class="el_production_partner_cha">
<span<?= $Page->cha->viewAttributes() ?>>
<?= $Page->cha->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cha_email->Visible) { // cha_email ?>
        <td data-name="cha_email"<?= $Page->cha_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_cha_email" class="el_production_partner_cha_email">
<span<?= $Page->cha_email->viewAttributes() ?>>
<?= $Page->cha_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cha_phone->Visible) { // cha_phone ?>
        <td data-name="cha_phone"<?= $Page->cha_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_cha_phone" class="el_production_partner_cha_phone">
<span<?= $Page->cha_phone->viewAttributes() ?>>
<?= $Page->cha_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->forwarder->Visible) { // forwarder ?>
        <td data-name="forwarder"<?= $Page->forwarder->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_forwarder" class="el_production_partner_forwarder">
<span<?= $Page->forwarder->viewAttributes() ?>>
<?= $Page->forwarder->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->forwarder_email->Visible) { // forwarder_email ?>
        <td data-name="forwarder_email"<?= $Page->forwarder_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_forwarder_email" class="el_production_partner_forwarder_email">
<span<?= $Page->forwarder_email->viewAttributes() ?>>
<?= $Page->forwarder_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->forwarder_phone->Visible) { // forwarder_phone ?>
        <td data-name="forwarder_phone"<?= $Page->forwarder_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_forwarder_phone" class="el_production_partner_forwarder_phone">
<span<?= $Page->forwarder_phone->viewAttributes() ?>>
<?= $Page->forwarder_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->merchant->Visible) { // merchant ?>
        <td data-name="merchant"<?= $Page->merchant->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_merchant" class="el_production_partner_merchant">
<span<?= $Page->merchant->viewAttributes() ?>>
<?= $Page->merchant->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->merchant_email->Visible) { // merchant_email ?>
        <td data-name="merchant_email"<?= $Page->merchant_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_merchant_email" class="el_production_partner_merchant_email">
<span<?= $Page->merchant_email->viewAttributes() ?>>
<?= $Page->merchant_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->merchant_phone->Visible) { // merchant_phone ?>
        <td data-name="merchant_phone"<?= $Page->merchant_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_merchant_phone" class="el_production_partner_merchant_phone">
<span<?= $Page->merchant_phone->viewAttributes() ?>>
<?= $Page->merchant_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_incharge->Visible) { // shipping_incharge ?>
        <td data-name="shipping_incharge"<?= $Page->shipping_incharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_shipping_incharge" class="el_production_partner_shipping_incharge">
<span<?= $Page->shipping_incharge->viewAttributes() ?>>
<?= $Page->shipping_incharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_email->Visible) { // shipping_email ?>
        <td data-name="shipping_email"<?= $Page->shipping_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_shipping_email" class="el_production_partner_shipping_email">
<span<?= $Page->shipping_email->viewAttributes() ?>>
<?= $Page->shipping_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shipping_phone->Visible) { // shipping_phone ?>
        <td data-name="shipping_phone"<?= $Page->shipping_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_shipping_phone" class="el_production_partner_shipping_phone">
<span<?= $Page->shipping_phone->viewAttributes() ?>>
<?= $Page->shipping_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->account_incharge->Visible) { // account_incharge ?>
        <td data-name="account_incharge"<?= $Page->account_incharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_account_incharge" class="el_production_partner_account_incharge">
<span<?= $Page->account_incharge->viewAttributes() ?>>
<?= $Page->account_incharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->accounts_email->Visible) { // accounts_email ?>
        <td data-name="accounts_email"<?= $Page->accounts_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_accounts_email" class="el_production_partner_accounts_email">
<span<?= $Page->accounts_email->viewAttributes() ?>>
<?= $Page->accounts_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->accounts_phone->Visible) { // accounts_phone ?>
        <td data-name="accounts_phone"<?= $Page->accounts_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_accounts_phone" class="el_production_partner_accounts_phone">
<span<?= $Page->accounts_phone->viewAttributes() ?>>
<?= $Page->accounts_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->warehouse_incharge->Visible) { // warehouse_incharge ?>
        <td data-name="warehouse_incharge"<?= $Page->warehouse_incharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_warehouse_incharge" class="el_production_partner_warehouse_incharge">
<span<?= $Page->warehouse_incharge->viewAttributes() ?>>
<?= $Page->warehouse_incharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->warehouse_email->Visible) { // warehouse_email ?>
        <td data-name="warehouse_email"<?= $Page->warehouse_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_warehouse_email" class="el_production_partner_warehouse_email">
<span<?= $Page->warehouse_email->viewAttributes() ?>>
<?= $Page->warehouse_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->warehouse_phone->Visible) { // warehouse_phone ?>
        <td data-name="warehouse_phone"<?= $Page->warehouse_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_warehouse_phone" class="el_production_partner_warehouse_phone">
<span<?= $Page->warehouse_phone->viewAttributes() ?>>
<?= $Page->warehouse_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->production_incharge->Visible) { // production_incharge ?>
        <td data-name="production_incharge"<?= $Page->production_incharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_production_incharge" class="el_production_partner_production_incharge">
<span<?= $Page->production_incharge->viewAttributes() ?>>
<?= $Page->production_incharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->production_email->Visible) { // production_email ?>
        <td data-name="production_email"<?= $Page->production_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_production_email" class="el_production_partner_production_email">
<span<?= $Page->production_email->viewAttributes() ?>>
<?= $Page->production_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->production_phone->Visible) { // production_phone ?>
        <td data-name="production_phone"<?= $Page->production_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_production_phone" class="el_production_partner_production_phone">
<span<?= $Page->production_phone->viewAttributes() ?>>
<?= $Page->production_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qc_incharge->Visible) { // qc_incharge ?>
        <td data-name="qc_incharge"<?= $Page->qc_incharge->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_qc_incharge" class="el_production_partner_qc_incharge">
<span<?= $Page->qc_incharge->viewAttributes() ?>>
<?= $Page->qc_incharge->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qc_email->Visible) { // qc_email ?>
        <td data-name="qc_email"<?= $Page->qc_email->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_qc_email" class="el_production_partner_qc_email">
<span<?= $Page->qc_email->viewAttributes() ?>>
<?= $Page->qc_email->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->qc_phone->Visible) { // qc_phone ?>
        <td data-name="qc_phone"<?= $Page->qc_phone->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_partner_qc_phone" class="el_production_partner_qc_phone">
<span<?= $Page->qc_phone->viewAttributes() ?>>
<?= $Page->qc_phone->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_partner");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
