<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionPartnerEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fproduction_partneredit" id="fproduction_partneredit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_partner: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fproduction_partneredit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduction_partneredit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,8}$/)], fields.code.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null], fields.country.isInvalid],
            ["region", [fields.region.visible && fields.region.required ? ew.Validators.required(fields.region.caption) : null], fields.region.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["url", [fields.url.visible && fields.url.required ? ew.Validators.required(fields.url.caption) : null], fields.url.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["bank_code", [fields.bank_code.visible && fields.bank_code.required ? ew.Validators.required(fields.bank_code.caption) : null], fields.bank_code.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["reports_to", [fields.reports_to.visible && fields.reports_to.required ? ew.Validators.required(fields.reports_to.caption) : null], fields.reports_to.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["tax_registration", [fields.tax_registration.visible && fields.tax_registration.required ? ew.Validators.required(fields.tax_registration.caption) : null], fields.tax_registration.isInvalid],
            ["cin", [fields.cin.visible && fields.cin.required ? ew.Validators.required(fields.cin.caption) : null], fields.cin.isInvalid],
            ["pan", [fields.pan.visible && fields.pan.required ? ew.Validators.required(fields.pan.caption) : null], fields.pan.isInvalid],
            ["tan", [fields.tan.visible && fields.tan.required ? ew.Validators.required(fields.tan.caption) : null], fields.tan.isInvalid],
            ["msme", [fields.msme.visible && fields.msme.required ? ew.Validators.required(fields.msme.caption) : null], fields.msme.isInvalid],
            ["port_air", [fields.port_air.visible && fields.port_air.required ? ew.Validators.required(fields.port_air.caption) : null], fields.port_air.isInvalid],
            ["port_sea", [fields.port_sea.visible && fields.port_sea.required ? ew.Validators.required(fields.port_sea.caption) : null], fields.port_sea.isInvalid],
            ["iec", [fields.iec.visible && fields.iec.required ? ew.Validators.required(fields.iec.caption) : null], fields.iec.isInvalid],
            ["rex", [fields.rex.visible && fields.rex.required ? ew.Validators.required(fields.rex.caption) : null], fields.rex.isInvalid],
            ["rcmc", [fields.rcmc.visible && fields.rcmc.required ? ew.Validators.required(fields.rcmc.caption) : null], fields.rcmc.isInvalid],
            ["delivery_terms", [fields.delivery_terms.visible && fields.delivery_terms.required ? ew.Validators.required(fields.delivery_terms.caption) : null], fields.delivery_terms.isInvalid],
            ["shipping_terms", [fields.shipping_terms.visible && fields.shipping_terms.required ? ew.Validators.required(fields.shipping_terms.caption) : null], fields.shipping_terms.isInvalid],
            ["payment_terms", [fields.payment_terms.visible && fields.payment_terms.required ? ew.Validators.required(fields.payment_terms.caption) : null], fields.payment_terms.isInvalid],
            ["export_type", [fields.export_type.visible && fields.export_type.required ? ew.Validators.required(fields.export_type.caption) : null], fields.export_type.isInvalid],
            ["lead_time_ss", [fields.lead_time_ss.visible && fields.lead_time_ss.required ? ew.Validators.required(fields.lead_time_ss.caption) : null, ew.Validators.float], fields.lead_time_ss.isInvalid],
            ["lead_time_cs", [fields.lead_time_cs.visible && fields.lead_time_cs.required ? ew.Validators.required(fields.lead_time_cs.caption) : null, ew.Validators.float], fields.lead_time_cs.isInvalid],
            ["cha", [fields.cha.visible && fields.cha.required ? ew.Validators.required(fields.cha.caption) : null], fields.cha.isInvalid],
            ["cha_email", [fields.cha_email.visible && fields.cha_email.required ? ew.Validators.required(fields.cha_email.caption) : null], fields.cha_email.isInvalid],
            ["cha_phone", [fields.cha_phone.visible && fields.cha_phone.required ? ew.Validators.required(fields.cha_phone.caption) : null], fields.cha_phone.isInvalid],
            ["forwarder", [fields.forwarder.visible && fields.forwarder.required ? ew.Validators.required(fields.forwarder.caption) : null], fields.forwarder.isInvalid],
            ["forwarder_email", [fields.forwarder_email.visible && fields.forwarder_email.required ? ew.Validators.required(fields.forwarder_email.caption) : null], fields.forwarder_email.isInvalid],
            ["forwarder_phone", [fields.forwarder_phone.visible && fields.forwarder_phone.required ? ew.Validators.required(fields.forwarder_phone.caption) : null], fields.forwarder_phone.isInvalid],
            ["merchant", [fields.merchant.visible && fields.merchant.required ? ew.Validators.required(fields.merchant.caption) : null], fields.merchant.isInvalid],
            ["merchant_email", [fields.merchant_email.visible && fields.merchant_email.required ? ew.Validators.required(fields.merchant_email.caption) : null], fields.merchant_email.isInvalid],
            ["merchant_phone", [fields.merchant_phone.visible && fields.merchant_phone.required ? ew.Validators.required(fields.merchant_phone.caption) : null], fields.merchant_phone.isInvalid],
            ["shipping_incharge", [fields.shipping_incharge.visible && fields.shipping_incharge.required ? ew.Validators.required(fields.shipping_incharge.caption) : null], fields.shipping_incharge.isInvalid],
            ["shipping_email", [fields.shipping_email.visible && fields.shipping_email.required ? ew.Validators.required(fields.shipping_email.caption) : null], fields.shipping_email.isInvalid],
            ["shipping_phone", [fields.shipping_phone.visible && fields.shipping_phone.required ? ew.Validators.required(fields.shipping_phone.caption) : null], fields.shipping_phone.isInvalid],
            ["account_incharge", [fields.account_incharge.visible && fields.account_incharge.required ? ew.Validators.required(fields.account_incharge.caption) : null], fields.account_incharge.isInvalid],
            ["accounts_email", [fields.accounts_email.visible && fields.accounts_email.required ? ew.Validators.required(fields.accounts_email.caption) : null], fields.accounts_email.isInvalid],
            ["accounts_phone", [fields.accounts_phone.visible && fields.accounts_phone.required ? ew.Validators.required(fields.accounts_phone.caption) : null], fields.accounts_phone.isInvalid],
            ["warehouse_incharge", [fields.warehouse_incharge.visible && fields.warehouse_incharge.required ? ew.Validators.required(fields.warehouse_incharge.caption) : null], fields.warehouse_incharge.isInvalid],
            ["warehouse_email", [fields.warehouse_email.visible && fields.warehouse_email.required ? ew.Validators.required(fields.warehouse_email.caption) : null], fields.warehouse_email.isInvalid],
            ["warehouse_phone", [fields.warehouse_phone.visible && fields.warehouse_phone.required ? ew.Validators.required(fields.warehouse_phone.caption) : null], fields.warehouse_phone.isInvalid],
            ["production_incharge", [fields.production_incharge.visible && fields.production_incharge.required ? ew.Validators.required(fields.production_incharge.caption) : null], fields.production_incharge.isInvalid],
            ["production_email", [fields.production_email.visible && fields.production_email.required ? ew.Validators.required(fields.production_email.caption) : null], fields.production_email.isInvalid],
            ["production_phone", [fields.production_phone.visible && fields.production_phone.required ? ew.Validators.required(fields.production_phone.caption) : null], fields.production_phone.isInvalid],
            ["qc_incharge", [fields.qc_incharge.visible && fields.qc_incharge.required ? ew.Validators.required(fields.qc_incharge.caption) : null], fields.qc_incharge.isInvalid],
            ["qc_email", [fields.qc_email.visible && fields.qc_email.required ? ew.Validators.required(fields.qc_email.caption) : null], fields.qc_email.isInvalid],
            ["qc_phone", [fields.qc_phone.visible && fields.qc_phone.required ? ew.Validators.required(fields.qc_phone.caption) : null], fields.qc_phone.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Multi-Page
        .setMultiPage(true)

        // Dynamic selection lists
        .setLists({
            "country": <?= $Page->country->toClientList($Page) ?>,
            "region": <?= $Page->region->toClientList($Page) ?>,
            "city": <?= $Page->city->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "reports_to": <?= $Page->reports_to->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "type": <?= $Page->type->toClientList($Page) ?>,
            "port_air": <?= $Page->port_air->toClientList($Page) ?>,
            "port_sea": <?= $Page->port_sea->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_partner">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_production_partner_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_production_partner_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="production_partner" data-field="x_id" data-hidden="1" data-page="0" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name"<?= $Page->name->rowAttributes() ?>>
        <label id="elh_production_partner_name" for="x_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->name->caption() ?><?= $Page->name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->name->cellAttributes() ?>>
<span id="el_production_partner_name">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="production_partner" data-field="x_name" value="<?= $Page->name->EditValue ?>" data-page="0" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?> aria-describedby="x_name_help">
<?= $Page->name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label id="elh_production_partner_code" for="x_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->code->cellAttributes() ?>>
<span id="el_production_partner_code">
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="production_partner" data-field="x_code" value="<?= $Page->code->EditValue ?>" data-page="0" size="30" maxlength="8" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="accordion_ProductionPartnerEdit"><!-- multi-page accordion -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(1)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(1)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner1"><?= $Page->pageCaption(1) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(1)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner1"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->country->Visible) { // country ?>
    <div id="r_country"<?= $Page->country->rowAttributes() ?>>
        <label id="elh_production_partner_country" for="x_country" class="<?= $Page->LeftColumnClass ?>"><?= $Page->country->caption() ?><?= $Page->country->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->country->cellAttributes() ?>>
<span id="el_production_partner_country">
    <select
        id="x_country"
        name="x_country"
        class="form-select ew-select<?= $Page->country->isInvalidClass() ?>"
        <?php if (!$Page->country->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_country"
        <?php } ?>
        data-table="production_partner"
        data-field="x_country"
        data-page="1"
        data-value-separator="<?= $Page->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->country->editAttributes() ?>>
        <?= $Page->country->selectOptionListHtml("x_country") ?>
    </select>
    <?= $Page->country->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->country->getErrorMessage() ?></div>
<?= $Page->country->Lookup->getParamTag($Page, "p_x_country") ?>
<?php if (!$Page->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_country", selectId: "fproduction_partneredit_x_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.country?.lookupOptions.length) {
        options.data = { id: "x_country", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_country", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->region->Visible) { // region ?>
    <div id="r_region"<?= $Page->region->rowAttributes() ?>>
        <label id="elh_production_partner_region" for="x_region" class="<?= $Page->LeftColumnClass ?>"><?= $Page->region->caption() ?><?= $Page->region->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->region->cellAttributes() ?>>
<span id="el_production_partner_region">
    <select
        id="x_region"
        name="x_region"
        class="form-select ew-select<?= $Page->region->isInvalidClass() ?>"
        <?php if (!$Page->region->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_region"
        <?php } ?>
        data-table="production_partner"
        data-field="x_region"
        data-page="1"
        data-value-separator="<?= $Page->region->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->region->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->region->editAttributes() ?>>
        <?= $Page->region->selectOptionListHtml("x_region") ?>
    </select>
    <?= $Page->region->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->region->getErrorMessage() ?></div>
<?= $Page->region->Lookup->getParamTag($Page, "p_x_region") ?>
<?php if (!$Page->region->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_region", selectId: "fproduction_partneredit_x_region" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.region?.lookupOptions.length) {
        options.data = { id: "x_region", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_region", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.region.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label id="elh_production_partner_city" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city->cellAttributes() ?>>
<span id="el_production_partner_city">
    <select
        id="x_city"
        name="x_city"
        class="form-control ew-select<?= $Page->city->isInvalidClass() ?>"
        data-select2-id="fproduction_partneredit_x_city"
        data-table="production_partner"
        data-field="x_city"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->city->caption())) ?>"
        data-modal-lookup="true"
        data-page="1"
        data-value-separator="<?= $Page->city->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>"
        <?= $Page->city->editAttributes() ?>>
        <?= $Page->city->selectOptionListHtml("x_city") ?>
    </select>
    <?= $Page->city->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
<?= $Page->city->Lookup->getParamTag($Page, "p_x_city") ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_city", selectId: "fproduction_partneredit_x_city" };
    if (fproduction_partneredit.lists.city?.lookupOptions.length) {
        options.data = { id: "x_city", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_city", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.production_partner.fields.city.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_production_partner_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_production_partner_address">
<textarea data-table="production_partner" data-field="x_address" data-page="1" name="x_address" id="x_address" cols="30" rows="4" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_production_partner_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_production_partner_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="production_partner" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_email->Visible) { // email ?>
    <div id="r__email"<?= $Page->_email->rowAttributes() ?>>
        <label id="elh_production_partner__email" for="x__email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_email->caption() ?><?= $Page->_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_email->cellAttributes() ?>>
<span id="el_production_partner__email">
<input type="<?= $Page->_email->getInputTextType() ?>" name="x__email" id="x__email" data-table="production_partner" data-field="x__email" value="<?= $Page->_email->EditValue ?>" data-page="1" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_email->formatPattern()) ?>"<?= $Page->_email->editAttributes() ?> aria-describedby="x__email_help">
<?= $Page->_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url"<?= $Page->url->rowAttributes() ?>>
        <label id="elh_production_partner_url" for="x_url" class="<?= $Page->LeftColumnClass ?>"><?= $Page->url->caption() ?><?= $Page->url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->url->cellAttributes() ?>>
<span id="el_production_partner_url">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="production_partner" data-field="x_url" value="<?= $Page->url->EditValue ?>" data-page="1" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?> aria-describedby="x_url_help">
<?= $Page->url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label id="elh_production_partner_bank_name" for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_name->caption() ?><?= $Page->bank_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_name->cellAttributes() ?>>
<span id="el_production_partner_bank_name">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="production_partner" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" data-page="1" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
<?= $Page->bank_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label id="elh_production_partner_bank_account_no" for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_account_no->caption() ?><?= $Page->bank_account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el_production_partner_bank_account_no">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="production_partner" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
<?= $Page->bank_account_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_code->Visible) { // bank_code ?>
    <div id="r_bank_code"<?= $Page->bank_code->rowAttributes() ?>>
        <label id="elh_production_partner_bank_code" for="x_bank_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_code->caption() ?><?= $Page->bank_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_code->cellAttributes() ?>>
<span id="el_production_partner_bank_code">
<input type="<?= $Page->bank_code->getInputTextType() ?>" name="x_bank_code" id="x_bank_code" data-table="production_partner" data-field="x_bank_code" value="<?= $Page->bank_code->EditValue ?>" data-page="1" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->bank_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_code->formatPattern()) ?>"<?= $Page->bank_code->editAttributes() ?> aria-describedby="x_bank_code_help">
<?= $Page->bank_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(2)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(2)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner2"><?= $Page->pageCaption(2) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(2)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner2"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_production_partner_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_production_partner_grp">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_partner" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="5"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="production_partner"
    data-field="x_grp"
    data-page="2"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<?= $Page->grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category"<?= $Page->category->rowAttributes() ?>>
        <label id="elh_production_partner_category" for="x_category" class="<?= $Page->LeftColumnClass ?>"><?= $Page->category->caption() ?><?= $Page->category->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->category->cellAttributes() ?>>
<span id="el_production_partner_category">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_category"
        <?php } ?>
        data-table="production_partner"
        data-field="x_category"
        data-page="2"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <?= $Page->category->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage() ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_category", selectId: "fproduction_partneredit_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_category", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reports_to->Visible) { // reports_to ?>
    <div id="r_reports_to"<?= $Page->reports_to->rowAttributes() ?>>
        <label id="elh_production_partner_reports_to" for="x_reports_to" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reports_to->caption() ?><?= $Page->reports_to->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reports_to->cellAttributes() ?>>
<span id="el_production_partner_reports_to">
    <select
        id="x_reports_to"
        name="x_reports_to"
        class="form-select ew-select<?= $Page->reports_to->isInvalidClass() ?>"
        <?php if (!$Page->reports_to->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_reports_to"
        <?php } ?>
        data-table="production_partner"
        data-field="x_reports_to"
        data-page="2"
        data-value-separator="<?= $Page->reports_to->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->reports_to->getPlaceHolder()) ?>"
        <?= $Page->reports_to->editAttributes() ?>>
        <?= $Page->reports_to->selectOptionListHtml("x_reports_to") ?>
    </select>
    <?= $Page->reports_to->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->reports_to->getErrorMessage() ?></div>
<?= $Page->reports_to->Lookup->getParamTag($Page, "p_x_reports_to") ?>
<?php if (!$Page->reports_to->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_reports_to", selectId: "fproduction_partneredit_x_reports_to" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.reports_to?.lookupOptions.length) {
        options.data = { id: "x_reports_to", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_reports_to", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.reports_to.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_production_partner_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_production_partner_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_status"
        <?php } ?>
        data-table="production_partner"
        data-field="x_status"
        data-page="2"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_status", selectId: "fproduction_partneredit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_status", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type"<?= $Page->type->rowAttributes() ?>>
        <label id="elh_production_partner_type" for="x_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->type->caption() ?><?= $Page->type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->type->cellAttributes() ?>>
<span id="el_production_partner_type">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_type"
        <?php } ?>
        data-table="production_partner"
        data-field="x_type"
        data-page="2"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <?= $Page->type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage() ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_type", selectId: "fproduction_partneredit_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_type", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(3)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(3)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner3"><?= $Page->pageCaption(3) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(3)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner3"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->tax_registration->Visible) { // tax_registration ?>
    <div id="r_tax_registration"<?= $Page->tax_registration->rowAttributes() ?>>
        <label id="elh_production_partner_tax_registration" for="x_tax_registration" class="<?= $Page->LeftColumnClass ?>"><?= $Page->tax_registration->caption() ?><?= $Page->tax_registration->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->tax_registration->cellAttributes() ?>>
<span id="el_production_partner_tax_registration">
<input type="<?= $Page->tax_registration->getInputTextType() ?>" name="x_tax_registration" id="x_tax_registration" data-table="production_partner" data-field="x_tax_registration" value="<?= $Page->tax_registration->EditValue ?>" data-page="3" size="30" maxlength="15" placeholder="<?= HtmlEncode($Page->tax_registration->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tax_registration->formatPattern()) ?>"<?= $Page->tax_registration->editAttributes() ?> aria-describedby="x_tax_registration_help">
<?= $Page->tax_registration->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->tax_registration->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cin->Visible) { // cin ?>
    <div id="r_cin"<?= $Page->cin->rowAttributes() ?>>
        <label id="elh_production_partner_cin" for="x_cin" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cin->caption() ?><?= $Page->cin->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cin->cellAttributes() ?>>
<span id="el_production_partner_cin">
<input type="<?= $Page->cin->getInputTextType() ?>" name="x_cin" id="x_cin" data-table="production_partner" data-field="x_cin" value="<?= $Page->cin->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->cin->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cin->formatPattern()) ?>"<?= $Page->cin->editAttributes() ?> aria-describedby="x_cin_help">
<?= $Page->cin->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cin->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pan->Visible) { // pan ?>
    <div id="r_pan"<?= $Page->pan->rowAttributes() ?>>
        <label id="elh_production_partner_pan" for="x_pan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->pan->caption() ?><?= $Page->pan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->pan->cellAttributes() ?>>
<span id="el_production_partner_pan">
<input type="<?= $Page->pan->getInputTextType() ?>" name="x_pan" id="x_pan" data-table="production_partner" data-field="x_pan" value="<?= $Page->pan->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->pan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan->formatPattern()) ?>"<?= $Page->pan->editAttributes() ?> aria-describedby="x_pan_help">
<?= $Page->pan->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pan->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->tan->Visible) { // tan ?>
    <div id="r_tan"<?= $Page->tan->rowAttributes() ?>>
        <label id="elh_production_partner_tan" for="x_tan" class="<?= $Page->LeftColumnClass ?>"><?= $Page->tan->caption() ?><?= $Page->tan->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->tan->cellAttributes() ?>>
<span id="el_production_partner_tan">
<input type="<?= $Page->tan->getInputTextType() ?>" name="x_tan" id="x_tan" data-table="production_partner" data-field="x_tan" value="<?= $Page->tan->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->tan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tan->formatPattern()) ?>"<?= $Page->tan->editAttributes() ?> aria-describedby="x_tan_help">
<?= $Page->tan->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->tan->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->msme->Visible) { // msme ?>
    <div id="r_msme"<?= $Page->msme->rowAttributes() ?>>
        <label id="elh_production_partner_msme" for="x_msme" class="<?= $Page->LeftColumnClass ?>"><?= $Page->msme->caption() ?><?= $Page->msme->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->msme->cellAttributes() ?>>
<span id="el_production_partner_msme">
<input type="<?= $Page->msme->getInputTextType() ?>" name="x_msme" id="x_msme" data-table="production_partner" data-field="x_msme" value="<?= $Page->msme->EditValue ?>" data-page="3" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->msme->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->msme->formatPattern()) ?>"<?= $Page->msme->editAttributes() ?> aria-describedby="x_msme_help">
<?= $Page->msme->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->msme->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(4)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(4)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner4"><?= $Page->pageCaption(4) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(4)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner4"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->port_air->Visible) { // port_air ?>
    <div id="r_port_air"<?= $Page->port_air->rowAttributes() ?>>
        <label id="elh_production_partner_port_air" for="x_port_air" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_air->caption() ?><?= $Page->port_air->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_air->cellAttributes() ?>>
<span id="el_production_partner_port_air">
    <select
        id="x_port_air"
        name="x_port_air"
        class="form-select ew-select<?= $Page->port_air->isInvalidClass() ?>"
        <?php if (!$Page->port_air->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_port_air"
        <?php } ?>
        data-table="production_partner"
        data-field="x_port_air"
        data-page="4"
        data-value-separator="<?= $Page->port_air->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_air->getPlaceHolder()) ?>"
        <?= $Page->port_air->editAttributes() ?>>
        <?= $Page->port_air->selectOptionListHtml("x_port_air") ?>
    </select>
    <?= $Page->port_air->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->port_air->getErrorMessage() ?></div>
<?= $Page->port_air->Lookup->getParamTag($Page, "p_x_port_air") ?>
<?php if (!$Page->port_air->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_port_air", selectId: "fproduction_partneredit_x_port_air" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.port_air?.lookupOptions.length) {
        options.data = { id: "x_port_air", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_port_air", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.port_air.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->port_sea->Visible) { // port_sea ?>
    <div id="r_port_sea"<?= $Page->port_sea->rowAttributes() ?>>
        <label id="elh_production_partner_port_sea" for="x_port_sea" class="<?= $Page->LeftColumnClass ?>"><?= $Page->port_sea->caption() ?><?= $Page->port_sea->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->port_sea->cellAttributes() ?>>
<span id="el_production_partner_port_sea">
<div class="input-group flex-nowrap">
    <select
        id="x_port_sea"
        name="x_port_sea"
        class="form-select ew-select<?= $Page->port_sea->isInvalidClass() ?>"
        <?php if (!$Page->port_sea->IsNativeSelect) { ?>
        data-select2-id="fproduction_partneredit_x_port_sea"
        <?php } ?>
        data-table="production_partner"
        data-field="x_port_sea"
        data-page="4"
        data-value-separator="<?= $Page->port_sea->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->port_sea->getPlaceHolder()) ?>"
        <?= $Page->port_sea->editAttributes() ?>>
        <?= $Page->port_sea->selectOptionListHtml("x_port_sea") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "port") && !$Page->port_sea->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_port_sea" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->port_sea->caption() ?>" data-title="<?= $Page->port_sea->caption() ?>" data-ew-action="add-option" data-el="x_port_sea" data-url="<?= GetUrl("portaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->port_sea->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->port_sea->getErrorMessage() ?></div>
<?= $Page->port_sea->Lookup->getParamTag($Page, "p_x_port_sea") ?>
<?php if (!$Page->port_sea->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_partneredit", function() {
    var options = { name: "x_port_sea", selectId: "fproduction_partneredit_x_port_sea" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_partneredit.lists.port_sea?.lookupOptions.length) {
        options.data = { id: "x_port_sea", form: "fproduction_partneredit" };
    } else {
        options.ajax = { id: "x_port_sea", form: "fproduction_partneredit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_partner.fields.port_sea.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->iec->Visible) { // iec ?>
    <div id="r_iec"<?= $Page->iec->rowAttributes() ?>>
        <label id="elh_production_partner_iec" for="x_iec" class="<?= $Page->LeftColumnClass ?>"><?= $Page->iec->caption() ?><?= $Page->iec->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->iec->cellAttributes() ?>>
<span id="el_production_partner_iec">
<input type="<?= $Page->iec->getInputTextType() ?>" name="x_iec" id="x_iec" data-table="production_partner" data-field="x_iec" value="<?= $Page->iec->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->iec->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->iec->formatPattern()) ?>"<?= $Page->iec->editAttributes() ?> aria-describedby="x_iec_help">
<?= $Page->iec->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->iec->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rex->Visible) { // rex ?>
    <div id="r_rex"<?= $Page->rex->rowAttributes() ?>>
        <label id="elh_production_partner_rex" for="x_rex" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rex->caption() ?><?= $Page->rex->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rex->cellAttributes() ?>>
<span id="el_production_partner_rex">
<input type="<?= $Page->rex->getInputTextType() ?>" name="x_rex" id="x_rex" data-table="production_partner" data-field="x_rex" value="<?= $Page->rex->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->rex->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rex->formatPattern()) ?>"<?= $Page->rex->editAttributes() ?> aria-describedby="x_rex_help">
<?= $Page->rex->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rex->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->rcmc->Visible) { // rcmc ?>
    <div id="r_rcmc"<?= $Page->rcmc->rowAttributes() ?>>
        <label id="elh_production_partner_rcmc" for="x_rcmc" class="<?= $Page->LeftColumnClass ?>"><?= $Page->rcmc->caption() ?><?= $Page->rcmc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->rcmc->cellAttributes() ?>>
<span id="el_production_partner_rcmc">
<input type="<?= $Page->rcmc->getInputTextType() ?>" name="x_rcmc" id="x_rcmc" data-table="production_partner" data-field="x_rcmc" value="<?= $Page->rcmc->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->rcmc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->rcmc->formatPattern()) ?>"<?= $Page->rcmc->editAttributes() ?> aria-describedby="x_rcmc_help">
<?= $Page->rcmc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->rcmc->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->delivery_terms->Visible) { // delivery_terms ?>
    <div id="r_delivery_terms"<?= $Page->delivery_terms->rowAttributes() ?>>
        <label id="elh_production_partner_delivery_terms" for="x_delivery_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->delivery_terms->caption() ?><?= $Page->delivery_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->delivery_terms->cellAttributes() ?>>
<span id="el_production_partner_delivery_terms">
<input type="<?= $Page->delivery_terms->getInputTextType() ?>" name="x_delivery_terms" id="x_delivery_terms" data-table="production_partner" data-field="x_delivery_terms" value="<?= $Page->delivery_terms->EditValue ?>" data-page="4" size="30" maxlength="196" placeholder="<?= HtmlEncode($Page->delivery_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->delivery_terms->formatPattern()) ?>"<?= $Page->delivery_terms->editAttributes() ?> aria-describedby="x_delivery_terms_help">
<?= $Page->delivery_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->delivery_terms->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_terms->Visible) { // shipping_terms ?>
    <div id="r_shipping_terms"<?= $Page->shipping_terms->rowAttributes() ?>>
        <label id="elh_production_partner_shipping_terms" for="x_shipping_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_terms->caption() ?><?= $Page->shipping_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_terms->cellAttributes() ?>>
<span id="el_production_partner_shipping_terms">
<input type="<?= $Page->shipping_terms->getInputTextType() ?>" name="x_shipping_terms" id="x_shipping_terms" data-table="production_partner" data-field="x_shipping_terms" value="<?= $Page->shipping_terms->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->shipping_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_terms->formatPattern()) ?>"<?= $Page->shipping_terms->editAttributes() ?> aria-describedby="x_shipping_terms_help">
<?= $Page->shipping_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_terms->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_terms->Visible) { // payment_terms ?>
    <div id="r_payment_terms"<?= $Page->payment_terms->rowAttributes() ?>>
        <label id="elh_production_partner_payment_terms" for="x_payment_terms" class="<?= $Page->LeftColumnClass ?>"><?= $Page->payment_terms->caption() ?><?= $Page->payment_terms->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->payment_terms->cellAttributes() ?>>
<span id="el_production_partner_payment_terms">
<input type="<?= $Page->payment_terms->getInputTextType() ?>" name="x_payment_terms" id="x_payment_terms" data-table="production_partner" data-field="x_payment_terms" value="<?= $Page->payment_terms->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->payment_terms->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_terms->formatPattern()) ?>"<?= $Page->payment_terms->editAttributes() ?> aria-describedby="x_payment_terms_help">
<?= $Page->payment_terms->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->payment_terms->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->export_type->Visible) { // export_type ?>
    <div id="r_export_type"<?= $Page->export_type->rowAttributes() ?>>
        <label id="elh_production_partner_export_type" for="x_export_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->export_type->caption() ?><?= $Page->export_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->export_type->cellAttributes() ?>>
<span id="el_production_partner_export_type">
<input type="<?= $Page->export_type->getInputTextType() ?>" name="x_export_type" id="x_export_type" data-table="production_partner" data-field="x_export_type" value="<?= $Page->export_type->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->export_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->export_type->formatPattern()) ?>"<?= $Page->export_type->editAttributes() ?> aria-describedby="x_export_type_help">
<?= $Page->export_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->export_type->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_time_ss->Visible) { // lead_time_ss ?>
    <div id="r_lead_time_ss"<?= $Page->lead_time_ss->rowAttributes() ?>>
        <label id="elh_production_partner_lead_time_ss" for="x_lead_time_ss" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_time_ss->caption() ?><?= $Page->lead_time_ss->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_time_ss->cellAttributes() ?>>
<span id="el_production_partner_lead_time_ss">
<input type="<?= $Page->lead_time_ss->getInputTextType() ?>" name="x_lead_time_ss" id="x_lead_time_ss" data-table="production_partner" data-field="x_lead_time_ss" value="<?= $Page->lead_time_ss->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->lead_time_ss->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_time_ss->formatPattern()) ?>"<?= $Page->lead_time_ss->editAttributes() ?> aria-describedby="x_lead_time_ss_help">
<?= $Page->lead_time_ss->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lead_time_ss->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->lead_time_cs->Visible) { // lead_time_cs ?>
    <div id="r_lead_time_cs"<?= $Page->lead_time_cs->rowAttributes() ?>>
        <label id="elh_production_partner_lead_time_cs" for="x_lead_time_cs" class="<?= $Page->LeftColumnClass ?>"><?= $Page->lead_time_cs->caption() ?><?= $Page->lead_time_cs->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->lead_time_cs->cellAttributes() ?>>
<span id="el_production_partner_lead_time_cs">
<input type="<?= $Page->lead_time_cs->getInputTextType() ?>" name="x_lead_time_cs" id="x_lead_time_cs" data-table="production_partner" data-field="x_lead_time_cs" value="<?= $Page->lead_time_cs->EditValue ?>" data-page="4" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->lead_time_cs->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lead_time_cs->formatPattern()) ?>"<?= $Page->lead_time_cs->editAttributes() ?> aria-describedby="x_lead_time_cs_help">
<?= $Page->lead_time_cs->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->lead_time_cs->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(5)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(5)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner5"><?= $Page->pageCaption(5) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(5)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner5"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->cha->Visible) { // cha ?>
    <div id="r_cha"<?= $Page->cha->rowAttributes() ?>>
        <label id="elh_production_partner_cha" for="x_cha" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cha->caption() ?><?= $Page->cha->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cha->cellAttributes() ?>>
<span id="el_production_partner_cha">
<textarea data-table="production_partner" data-field="x_cha" data-page="5" name="x_cha" id="x_cha" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->cha->getPlaceHolder()) ?>"<?= $Page->cha->editAttributes() ?> aria-describedby="x_cha_help"><?= $Page->cha->EditValue ?></textarea>
<?= $Page->cha->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cha->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cha_email->Visible) { // cha_email ?>
    <div id="r_cha_email"<?= $Page->cha_email->rowAttributes() ?>>
        <label id="elh_production_partner_cha_email" for="x_cha_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cha_email->caption() ?><?= $Page->cha_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cha_email->cellAttributes() ?>>
<span id="el_production_partner_cha_email">
<textarea data-table="production_partner" data-field="x_cha_email" data-page="5" name="x_cha_email" id="x_cha_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->cha_email->getPlaceHolder()) ?>"<?= $Page->cha_email->editAttributes() ?> aria-describedby="x_cha_email_help"><?= $Page->cha_email->EditValue ?></textarea>
<?= $Page->cha_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cha_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->cha_phone->Visible) { // cha_phone ?>
    <div id="r_cha_phone"<?= $Page->cha_phone->rowAttributes() ?>>
        <label id="elh_production_partner_cha_phone" for="x_cha_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->cha_phone->caption() ?><?= $Page->cha_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->cha_phone->cellAttributes() ?>>
<span id="el_production_partner_cha_phone">
<textarea data-table="production_partner" data-field="x_cha_phone" data-page="5" name="x_cha_phone" id="x_cha_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->cha_phone->getPlaceHolder()) ?>"<?= $Page->cha_phone->editAttributes() ?> aria-describedby="x_cha_phone_help"><?= $Page->cha_phone->EditValue ?></textarea>
<?= $Page->cha_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->cha_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(6)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(6)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner6"><?= $Page->pageCaption(6) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(6)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner6"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->forwarder->Visible) { // forwarder ?>
    <div id="r_forwarder"<?= $Page->forwarder->rowAttributes() ?>>
        <label id="elh_production_partner_forwarder" for="x_forwarder" class="<?= $Page->LeftColumnClass ?>"><?= $Page->forwarder->caption() ?><?= $Page->forwarder->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->forwarder->cellAttributes() ?>>
<span id="el_production_partner_forwarder">
<textarea data-table="production_partner" data-field="x_forwarder" data-page="6" name="x_forwarder" id="x_forwarder" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->forwarder->getPlaceHolder()) ?>"<?= $Page->forwarder->editAttributes() ?> aria-describedby="x_forwarder_help"><?= $Page->forwarder->EditValue ?></textarea>
<?= $Page->forwarder->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->forwarder->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->forwarder_email->Visible) { // forwarder_email ?>
    <div id="r_forwarder_email"<?= $Page->forwarder_email->rowAttributes() ?>>
        <label id="elh_production_partner_forwarder_email" for="x_forwarder_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->forwarder_email->caption() ?><?= $Page->forwarder_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->forwarder_email->cellAttributes() ?>>
<span id="el_production_partner_forwarder_email">
<textarea data-table="production_partner" data-field="x_forwarder_email" data-page="6" name="x_forwarder_email" id="x_forwarder_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->forwarder_email->getPlaceHolder()) ?>"<?= $Page->forwarder_email->editAttributes() ?> aria-describedby="x_forwarder_email_help"><?= $Page->forwarder_email->EditValue ?></textarea>
<?= $Page->forwarder_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->forwarder_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->forwarder_phone->Visible) { // forwarder_phone ?>
    <div id="r_forwarder_phone"<?= $Page->forwarder_phone->rowAttributes() ?>>
        <label id="elh_production_partner_forwarder_phone" for="x_forwarder_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->forwarder_phone->caption() ?><?= $Page->forwarder_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->forwarder_phone->cellAttributes() ?>>
<span id="el_production_partner_forwarder_phone">
<textarea data-table="production_partner" data-field="x_forwarder_phone" data-page="6" name="x_forwarder_phone" id="x_forwarder_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->forwarder_phone->getPlaceHolder()) ?>"<?= $Page->forwarder_phone->editAttributes() ?> aria-describedby="x_forwarder_phone_help"><?= $Page->forwarder_phone->EditValue ?></textarea>
<?= $Page->forwarder_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->forwarder_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(7)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(7)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner7"><?= $Page->pageCaption(7) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(7)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner7"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->merchant->Visible) { // merchant ?>
    <div id="r_merchant"<?= $Page->merchant->rowAttributes() ?>>
        <label id="elh_production_partner_merchant" for="x_merchant" class="<?= $Page->LeftColumnClass ?>"><?= $Page->merchant->caption() ?><?= $Page->merchant->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->merchant->cellAttributes() ?>>
<span id="el_production_partner_merchant">
<textarea data-table="production_partner" data-field="x_merchant" data-page="7" name="x_merchant" id="x_merchant" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->merchant->getPlaceHolder()) ?>"<?= $Page->merchant->editAttributes() ?> aria-describedby="x_merchant_help"><?= $Page->merchant->EditValue ?></textarea>
<?= $Page->merchant->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->merchant->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->merchant_email->Visible) { // merchant_email ?>
    <div id="r_merchant_email"<?= $Page->merchant_email->rowAttributes() ?>>
        <label id="elh_production_partner_merchant_email" for="x_merchant_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->merchant_email->caption() ?><?= $Page->merchant_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->merchant_email->cellAttributes() ?>>
<span id="el_production_partner_merchant_email">
<textarea data-table="production_partner" data-field="x_merchant_email" data-page="7" name="x_merchant_email" id="x_merchant_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->merchant_email->getPlaceHolder()) ?>"<?= $Page->merchant_email->editAttributes() ?> aria-describedby="x_merchant_email_help"><?= $Page->merchant_email->EditValue ?></textarea>
<?= $Page->merchant_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->merchant_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->merchant_phone->Visible) { // merchant_phone ?>
    <div id="r_merchant_phone"<?= $Page->merchant_phone->rowAttributes() ?>>
        <label id="elh_production_partner_merchant_phone" for="x_merchant_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->merchant_phone->caption() ?><?= $Page->merchant_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->merchant_phone->cellAttributes() ?>>
<span id="el_production_partner_merchant_phone">
<textarea data-table="production_partner" data-field="x_merchant_phone" data-page="7" name="x_merchant_phone" id="x_merchant_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->merchant_phone->getPlaceHolder()) ?>"<?= $Page->merchant_phone->editAttributes() ?> aria-describedby="x_merchant_phone_help"><?= $Page->merchant_phone->EditValue ?></textarea>
<?= $Page->merchant_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->merchant_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(8)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(8)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner8"><?= $Page->pageCaption(8) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(8)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner8"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->shipping_incharge->Visible) { // shipping_incharge ?>
    <div id="r_shipping_incharge"<?= $Page->shipping_incharge->rowAttributes() ?>>
        <label id="elh_production_partner_shipping_incharge" for="x_shipping_incharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_incharge->caption() ?><?= $Page->shipping_incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_incharge->cellAttributes() ?>>
<span id="el_production_partner_shipping_incharge">
<textarea data-table="production_partner" data-field="x_shipping_incharge" data-page="8" name="x_shipping_incharge" id="x_shipping_incharge" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->shipping_incharge->getPlaceHolder()) ?>"<?= $Page->shipping_incharge->editAttributes() ?> aria-describedby="x_shipping_incharge_help"><?= $Page->shipping_incharge->EditValue ?></textarea>
<?= $Page->shipping_incharge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_incharge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_email->Visible) { // shipping_email ?>
    <div id="r_shipping_email"<?= $Page->shipping_email->rowAttributes() ?>>
        <label id="elh_production_partner_shipping_email" for="x_shipping_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_email->caption() ?><?= $Page->shipping_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_email->cellAttributes() ?>>
<span id="el_production_partner_shipping_email">
<textarea data-table="production_partner" data-field="x_shipping_email" data-page="8" name="x_shipping_email" id="x_shipping_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->shipping_email->getPlaceHolder()) ?>"<?= $Page->shipping_email->editAttributes() ?> aria-describedby="x_shipping_email_help"><?= $Page->shipping_email->EditValue ?></textarea>
<?= $Page->shipping_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_phone->Visible) { // shipping_phone ?>
    <div id="r_shipping_phone"<?= $Page->shipping_phone->rowAttributes() ?>>
        <label id="elh_production_partner_shipping_phone" for="x_shipping_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_phone->caption() ?><?= $Page->shipping_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_phone->cellAttributes() ?>>
<span id="el_production_partner_shipping_phone">
<textarea data-table="production_partner" data-field="x_shipping_phone" data-page="8" name="x_shipping_phone" id="x_shipping_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->shipping_phone->getPlaceHolder()) ?>"<?= $Page->shipping_phone->editAttributes() ?> aria-describedby="x_shipping_phone_help"><?= $Page->shipping_phone->EditValue ?></textarea>
<?= $Page->shipping_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(9)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(9)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner9"><?= $Page->pageCaption(9) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(9)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner9"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->account_incharge->Visible) { // account_incharge ?>
    <div id="r_account_incharge"<?= $Page->account_incharge->rowAttributes() ?>>
        <label id="elh_production_partner_account_incharge" for="x_account_incharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->account_incharge->caption() ?><?= $Page->account_incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->account_incharge->cellAttributes() ?>>
<span id="el_production_partner_account_incharge">
<textarea data-table="production_partner" data-field="x_account_incharge" data-page="9" name="x_account_incharge" id="x_account_incharge" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->account_incharge->getPlaceHolder()) ?>"<?= $Page->account_incharge->editAttributes() ?> aria-describedby="x_account_incharge_help"><?= $Page->account_incharge->EditValue ?></textarea>
<?= $Page->account_incharge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->account_incharge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->accounts_email->Visible) { // accounts_email ?>
    <div id="r_accounts_email"<?= $Page->accounts_email->rowAttributes() ?>>
        <label id="elh_production_partner_accounts_email" for="x_accounts_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->accounts_email->caption() ?><?= $Page->accounts_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->accounts_email->cellAttributes() ?>>
<span id="el_production_partner_accounts_email">
<textarea data-table="production_partner" data-field="x_accounts_email" data-page="9" name="x_accounts_email" id="x_accounts_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->accounts_email->getPlaceHolder()) ?>"<?= $Page->accounts_email->editAttributes() ?> aria-describedby="x_accounts_email_help"><?= $Page->accounts_email->EditValue ?></textarea>
<?= $Page->accounts_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->accounts_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->accounts_phone->Visible) { // accounts_phone ?>
    <div id="r_accounts_phone"<?= $Page->accounts_phone->rowAttributes() ?>>
        <label id="elh_production_partner_accounts_phone" for="x_accounts_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->accounts_phone->caption() ?><?= $Page->accounts_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->accounts_phone->cellAttributes() ?>>
<span id="el_production_partner_accounts_phone">
<textarea data-table="production_partner" data-field="x_accounts_phone" data-page="9" name="x_accounts_phone" id="x_accounts_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->accounts_phone->getPlaceHolder()) ?>"<?= $Page->accounts_phone->editAttributes() ?> aria-describedby="x_accounts_phone_help"><?= $Page->accounts_phone->EditValue ?></textarea>
<?= $Page->accounts_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->accounts_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(10)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(10)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner10"><?= $Page->pageCaption(10) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(10)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner10"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->warehouse_incharge->Visible) { // warehouse_incharge ?>
    <div id="r_warehouse_incharge"<?= $Page->warehouse_incharge->rowAttributes() ?>>
        <label id="elh_production_partner_warehouse_incharge" for="x_warehouse_incharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->warehouse_incharge->caption() ?><?= $Page->warehouse_incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->warehouse_incharge->cellAttributes() ?>>
<span id="el_production_partner_warehouse_incharge">
<textarea data-table="production_partner" data-field="x_warehouse_incharge" data-page="10" name="x_warehouse_incharge" id="x_warehouse_incharge" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->warehouse_incharge->getPlaceHolder()) ?>"<?= $Page->warehouse_incharge->editAttributes() ?> aria-describedby="x_warehouse_incharge_help"><?= $Page->warehouse_incharge->EditValue ?></textarea>
<?= $Page->warehouse_incharge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->warehouse_incharge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->warehouse_email->Visible) { // warehouse_email ?>
    <div id="r_warehouse_email"<?= $Page->warehouse_email->rowAttributes() ?>>
        <label id="elh_production_partner_warehouse_email" for="x_warehouse_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->warehouse_email->caption() ?><?= $Page->warehouse_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->warehouse_email->cellAttributes() ?>>
<span id="el_production_partner_warehouse_email">
<textarea data-table="production_partner" data-field="x_warehouse_email" data-page="10" name="x_warehouse_email" id="x_warehouse_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->warehouse_email->getPlaceHolder()) ?>"<?= $Page->warehouse_email->editAttributes() ?> aria-describedby="x_warehouse_email_help"><?= $Page->warehouse_email->EditValue ?></textarea>
<?= $Page->warehouse_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->warehouse_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->warehouse_phone->Visible) { // warehouse_phone ?>
    <div id="r_warehouse_phone"<?= $Page->warehouse_phone->rowAttributes() ?>>
        <label id="elh_production_partner_warehouse_phone" for="x_warehouse_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->warehouse_phone->caption() ?><?= $Page->warehouse_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->warehouse_phone->cellAttributes() ?>>
<span id="el_production_partner_warehouse_phone">
<textarea data-table="production_partner" data-field="x_warehouse_phone" data-page="10" name="x_warehouse_phone" id="x_warehouse_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->warehouse_phone->getPlaceHolder()) ?>"<?= $Page->warehouse_phone->editAttributes() ?> aria-describedby="x_warehouse_phone_help"><?= $Page->warehouse_phone->EditValue ?></textarea>
<?= $Page->warehouse_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->warehouse_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(11)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(11)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner11"><?= $Page->pageCaption(11) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(11)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner11"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->production_incharge->Visible) { // production_incharge ?>
    <div id="r_production_incharge"<?= $Page->production_incharge->rowAttributes() ?>>
        <label id="elh_production_partner_production_incharge" for="x_production_incharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_incharge->caption() ?><?= $Page->production_incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_incharge->cellAttributes() ?>>
<span id="el_production_partner_production_incharge">
<textarea data-table="production_partner" data-field="x_production_incharge" data-page="11" name="x_production_incharge" id="x_production_incharge" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->production_incharge->getPlaceHolder()) ?>"<?= $Page->production_incharge->editAttributes() ?> aria-describedby="x_production_incharge_help"><?= $Page->production_incharge->EditValue ?></textarea>
<?= $Page->production_incharge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->production_incharge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_email->Visible) { // production_email ?>
    <div id="r_production_email"<?= $Page->production_email->rowAttributes() ?>>
        <label id="elh_production_partner_production_email" for="x_production_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_email->caption() ?><?= $Page->production_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_email->cellAttributes() ?>>
<span id="el_production_partner_production_email">
<textarea data-table="production_partner" data-field="x_production_email" data-page="11" name="x_production_email" id="x_production_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->production_email->getPlaceHolder()) ?>"<?= $Page->production_email->editAttributes() ?> aria-describedby="x_production_email_help"><?= $Page->production_email->EditValue ?></textarea>
<?= $Page->production_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->production_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->production_phone->Visible) { // production_phone ?>
    <div id="r_production_phone"<?= $Page->production_phone->rowAttributes() ?>>
        <label id="elh_production_partner_production_phone" for="x_production_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->production_phone->caption() ?><?= $Page->production_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->production_phone->cellAttributes() ?>>
<span id="el_production_partner_production_phone">
<textarea data-table="production_partner" data-field="x_production_phone" data-page="11" name="x_production_phone" id="x_production_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->production_phone->getPlaceHolder()) ?>"<?= $Page->production_phone->editAttributes() ?> aria-describedby="x_production_phone_help"><?= $Page->production_phone->EditValue ?></textarea>
<?= $Page->production_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->production_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
    <div class="accordion-item ew-accordion-item"><!-- multi-page .accordion-item -->
        <h4 class="accordion-header">
            <button class="accordion-button<?php if (!$Page->MultiPages->isActive(12)) { ?> collapsed<?php } ?>" type="button" aria-expanded="<?= JsonEncode($Page->MultiPages->isActive(12)) ?>" data-bs-toggle="collapse" data-bs-target="#tab_production_partner12"><?= $Page->pageCaption(12) ?></button>
        </h4>
        <div class="accordion-collapse collapse<?php if ($Page->MultiPages->isActive(12)) { ?> show<?php } ?>" data-bs-parent="<?= $Page->MultiPages->Parent ?>" id="tab_production_partner12"><!-- multi-page accordion .collapse -->
            <div class="accordion-body"><!-- multi-page .accordion-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->qc_incharge->Visible) { // qc_incharge ?>
    <div id="r_qc_incharge"<?= $Page->qc_incharge->rowAttributes() ?>>
        <label id="elh_production_partner_qc_incharge" for="x_qc_incharge" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qc_incharge->caption() ?><?= $Page->qc_incharge->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qc_incharge->cellAttributes() ?>>
<span id="el_production_partner_qc_incharge">
<textarea data-table="production_partner" data-field="x_qc_incharge" data-page="12" name="x_qc_incharge" id="x_qc_incharge" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->qc_incharge->getPlaceHolder()) ?>"<?= $Page->qc_incharge->editAttributes() ?> aria-describedby="x_qc_incharge_help"><?= $Page->qc_incharge->EditValue ?></textarea>
<?= $Page->qc_incharge->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->qc_incharge->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qc_email->Visible) { // qc_email ?>
    <div id="r_qc_email"<?= $Page->qc_email->rowAttributes() ?>>
        <label id="elh_production_partner_qc_email" for="x_qc_email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qc_email->caption() ?><?= $Page->qc_email->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qc_email->cellAttributes() ?>>
<span id="el_production_partner_qc_email">
<textarea data-table="production_partner" data-field="x_qc_email" data-page="12" name="x_qc_email" id="x_qc_email" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->qc_email->getPlaceHolder()) ?>"<?= $Page->qc_email->editAttributes() ?> aria-describedby="x_qc_email_help"><?= $Page->qc_email->EditValue ?></textarea>
<?= $Page->qc_email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->qc_email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->qc_phone->Visible) { // qc_phone ?>
    <div id="r_qc_phone"<?= $Page->qc_phone->rowAttributes() ?>>
        <label id="elh_production_partner_qc_phone" for="x_qc_phone" class="<?= $Page->LeftColumnClass ?>"><?= $Page->qc_phone->caption() ?><?= $Page->qc_phone->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->qc_phone->cellAttributes() ?>>
<span id="el_production_partner_qc_phone">
<textarea data-table="production_partner" data-field="x_qc_phone" data-page="12" name="x_qc_phone" id="x_qc_phone" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->qc_phone->getPlaceHolder()) ?>"<?= $Page->qc_phone->editAttributes() ?> aria-describedby="x_qc_phone_help"><?= $Page->qc_phone->EditValue ?></textarea>
<?= $Page->qc_phone->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->qc_phone->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
            </div><!-- /multi-page .accordion-body -->
        </div><!-- /multi-page accordion .collapse -->
    </div><!-- /multi-page .accordion-item -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
    if (in_array("shipping_address", explode(",", $Page->getCurrentDetailTable())) && $shipping_address->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("shipping_address", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "ShippingAddressGrid.php" ?>
<?php } ?>
<?php
    if (in_array("bank_info", explode(",", $Page->getCurrentDetailTable())) && $bank_info->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("bank_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "BankInfoGrid.php" ?>
<?php } ?>
<?php
    if (in_array("capacity_plan", explode(",", $Page->getCurrentDetailTable())) && $capacity_plan->DetailEdit) {
?>
<?php if ($Page->getCurrentDetailTable() != "") { ?>
<h4 class="ew-detail-caption"><?= $Language->tablePhrase("capacity_plan", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "CapacityPlanGrid.php" ?>
<?php } ?>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduction_partneredit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduction_partneredit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_partner");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
