<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionEmployeeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_employee: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fproduction_employeesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduction_employeesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["uid", [ew.Validators.integer], fields.uid.isInvalid],
            ["y_uid", [ew.Validators.between], false],
            ["grp", [], fields.grp.isInvalid],
            ["site", [], fields.site.isInvalid],
            ["id", [ew.Validators.regex(/^[0-9]{1,5}$/)], fields.id.isInvalid],
            ["user_name", [], fields.user_name.isInvalid],
            ["salary", [ew.Validators.integer], fields.salary.isInvalid],
            ["contractor", [], fields.contractor.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["mobile", [ew.Validators.integer], fields.mobile.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["process", [], fields.process.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["employee_name", [], fields.employee_name.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["designation", [], fields.designation.isInvalid],
            ["permanent_address", [], fields.permanent_address.isInvalid],
            ["city", [], fields.city.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["mobile_other", [], fields.mobile_other.isInvalid],
            ["mobile_family", [], fields.mobile_family.isInvalid],
            ["marital_status", [], fields.marital_status.isInvalid],
            ["spouse_details", [], fields.spouse_details.isInvalid],
            ["emergency_details", [], fields.emergency_details.isInvalid],
            ["pan_no", [], fields.pan_no.isInvalid],
            ["aadhaar_no", [ew.Validators.regex(/^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/)], fields.aadhaar_no.isInvalid],
            ["id_proof", [], fields.id_proof.isInvalid],
            ["reference_details", [], fields.reference_details.isInvalid],
            ["other_details", [], fields.other_details.isInvalid],
            ["doj", [ew.Validators.datetime(fields.doj.clientFormatPattern)], fields.doj.isInvalid],
            ["dol", [ew.Validators.datetime(fields.dol.clientFormatPattern)], fields.dol.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["payment_details", [], fields.payment_details.isInvalid],
            ["bank_name", [], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [], fields.bank_account_no.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["d_operator", [ew.Validators.integer], fields.d_operator.isInvalid],
            ["d_datetime", [ew.Validators.datetime(fields.d_datetime.clientFormatPattern)], fields.d_datetime.isInvalid],
            ["y_d_datetime", [ew.Validators.between], false]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "site": <?= $Page->site->toClientList($Page) ?>,
            "contractor": <?= $Page->contractor->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduction_employeesearch" id="fproduction_employeesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_employee">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_grp" class="ew-search-field ew-search-field-single">
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="3"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="production_employee"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site" class="row"<?= $Page->site->rowAttributes() ?>>
        <label for="x_site" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_site"><?= $Page->site->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_site" id="z_site" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->site->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_site" class="ew-search-field ew-search-field-single">
    <select
        id="x_site[]"
        name="x_site[]"
        class="form-select ew-select<?= $Page->site->isInvalidClass() ?>"
        <?php if (!$Page->site->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesearch_x_site[]"
        <?php } ?>
        data-table="production_employee"
        data-field="x_site"
        multiple
        size="1"
        data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->site->getPlaceHolder()) ?>"
        <?= $Page->site->editAttributes() ?>>
        <?= $Page->site->selectOptionListHtml("x_site[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->site->getErrorMessage(false) ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
<?php if (!$Page->site->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesearch", function() {
    var options = { name: "x_site[]", selectId: "fproduction_employeesearch_x_site[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesearch.lists.site?.lookupOptions.length) {
        options.data = { id: "x_site[]", form: "fproduction_employeesearch" };
    } else {
        options.ajax = { id: "x_site[]", form: "fproduction_employeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.site.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name" class="row"<?= $Page->user_name->rowAttributes() ?>>
        <label for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_user_name"><?= $Page->user_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_user_name" id="z_user_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->user_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_user_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="production_employee" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->salary->Visible) { // salary ?>
    <div id="r_salary" class="row"<?= $Page->salary->rowAttributes() ?>>
        <label for="x_salary" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_salary"><?= $Page->salary->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_salary" id="z_salary" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->salary->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_salary" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->salary->getInputTextType() ?>" name="x_salary" id="x_salary" data-table="production_employee" data-field="x_salary" value="<?= $Page->salary->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->salary->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->salary->formatPattern()) ?>"<?= $Page->salary->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->salary->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
    <div id="r_contractor" class="row"<?= $Page->contractor->rowAttributes() ?>>
        <label for="x_contractor" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_contractor"><?= $Page->contractor->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_contractor" id="z_contractor" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->contractor->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_contractor" class="ew-search-field ew-search-field-single">
    <select
        id="x_contractor"
        name="x_contractor"
        class="form-select ew-select<?= $Page->contractor->isInvalidClass() ?>"
        <?php if (!$Page->contractor->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesearch_x_contractor"
        <?php } ?>
        data-table="production_employee"
        data-field="x_contractor"
        data-value-separator="<?= $Page->contractor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->contractor->getPlaceHolder()) ?>"
        <?= $Page->contractor->editAttributes() ?>>
        <?= $Page->contractor->selectOptionListHtml("x_contractor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->contractor->getErrorMessage(false) ?></div>
<?= $Page->contractor->Lookup->getParamTag($Page, "p_x_contractor") ?>
<?php if (!$Page->contractor->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesearch", function() {
    var options = { name: "x_contractor", selectId: "fproduction_employeesearch_x_contractor" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesearch.lists.contractor?.lookupOptions.length) {
        options.data = { id: "x_contractor", form: "fproduction_employeesearch" };
    } else {
        options.ajax = { id: "x_contractor", form: "fproduction_employeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.contractor.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="production_employee" data-field="x_address" value="<?= $Page->address->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="production_employee" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_category" id="z_category" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesearch_x_category"
        <?php } ?>
        data-table="production_employee"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesearch", function() {
    var options = { name: "x_category", selectId: "fproduction_employeesearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fproduction_employeesearch" };
    } else {
        options.ajax = { id: "x_category", form: "fproduction_employeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process" class="row"<?= $Page->process->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_process"><?= $Page->process->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_process" id="z_process" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->process->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_process" class="ew-search-field ew-search-field-single">
<template id="tp_x_process">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_process" name="x_process" id="x_process"<?= $Page->process->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process" class="ew-item-list"></div>
<selection-list hidden
    id="x_process[]"
    name="x_process[]"
    value="<?= HtmlEncode($Page->process->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process"
    data-target="dsl_x_process"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process->isInvalidClass() ?>"
    data-table="production_employee"
    data-field="x_process"
    data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
    <?= $Page->process->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->process->getErrorMessage(false) ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesearch_x_status"
        <?php } ?>
        data-table="production_employee"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesearch", function() {
    var options = { name: "x_status", selectId: "fproduction_employeesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduction_employeesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fproduction_employeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_name->Visible) { // employee_name ?>
    <div id="r_employee_name" class="row"<?= $Page->employee_name->rowAttributes() ?>>
        <label for="x_employee_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_employee_name"><?= $Page->employee_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_employee_name" id="z_employee_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_employee_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->employee_name->getInputTextType() ?>" name="x_employee_name" id="x_employee_name" data-table="production_employee" data-field="x_employee_name" value="<?= $Page->employee_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->employee_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_name->formatPattern()) ?>"<?= $Page->employee_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->employee_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender" class="row"<?= $Page->gender->rowAttributes() ?>>
        <label for="x_gender" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_gender"><?= $Page->gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_gender" id="z_gender" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesearch_x_gender"
        <?php } ?>
        data-table="production_employee"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesearch", function() {
    var options = { name: "x_gender", selectId: "fproduction_employeesearch_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesearch.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "fproduction_employeesearch" };
    } else {
        options.ajax = { id: "x_gender", form: "fproduction_employeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name" class="row"<?= $Page->father_name->rowAttributes() ?>>
        <label for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_father_name"><?= $Page->father_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_father_name" id="z_father_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->father_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="production_employee" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->designation->Visible) { // designation ?>
    <div id="r_designation" class="row"<?= $Page->designation->rowAttributes() ?>>
        <label for="x_designation" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_designation"><?= $Page->designation->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_designation" id="z_designation" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->designation->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_designation" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->designation->getInputTextType() ?>" name="x_designation" id="x_designation" data-table="production_employee" data-field="x_designation" value="<?= $Page->designation->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->designation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->designation->formatPattern()) ?>"<?= $Page->designation->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->designation->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
    <div id="r_permanent_address" class="row"<?= $Page->permanent_address->rowAttributes() ?>>
        <label for="x_permanent_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_permanent_address"><?= $Page->permanent_address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_permanent_address" id="z_permanent_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->permanent_address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_permanent_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->permanent_address->getInputTextType() ?>" name="x_permanent_address" id="x_permanent_address" data-table="production_employee" data-field="x_permanent_address" value="<?= $Page->permanent_address->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->permanent_address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->permanent_address->formatPattern()) ?>"<?= $Page->permanent_address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->permanent_address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city" class="row"<?= $Page->city->rowAttributes() ?>>
        <label for="x_city" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_city"><?= $Page->city->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_city" id="z_city" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->city->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_city" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->city->getInputTextType() ?>" name="x_city" id="x_city" data-table="production_employee" data-field="x_city" value="<?= $Page->city->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city->formatPattern()) ?>"<?= $Page->city->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->city->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob" class="row"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_dob"><?= $Page->dob->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dob" id="z_dob" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="production_employee" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom" class="row"<?= $Page->dom->rowAttributes() ?>>
        <label for="x_dom" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_dom"><?= $Page->dom->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dom" id="z_dom" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dom->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_dom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="production_employee" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage(false) ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <div id="r_mobile_other" class="row"<?= $Page->mobile_other->rowAttributes() ?>>
        <label for="x_mobile_other" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_mobile_other"><?= $Page->mobile_other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_other" id="z_mobile_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_mobile_other" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="production_employee" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
    <div id="r_mobile_family" class="row"<?= $Page->mobile_family->rowAttributes() ?>>
        <label for="x_mobile_family" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_mobile_family"><?= $Page->mobile_family->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_family" id="z_mobile_family" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_family->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_mobile_family" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_family->getInputTextType() ?>" name="x_mobile_family" id="x_mobile_family" data-table="production_employee" data-field="x_mobile_family" value="<?= $Page->mobile_family->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->mobile_family->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_family->formatPattern()) ?>"<?= $Page->mobile_family->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_family->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status" class="row"<?= $Page->marital_status->rowAttributes() ?>>
        <label for="x_marital_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_marital_status"><?= $Page->marital_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_marital_status" id="z_marital_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->marital_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_marital_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_marital_status"
        name="x_marital_status"
        class="form-select ew-select<?= $Page->marital_status->isInvalidClass() ?>"
        <?php if (!$Page->marital_status->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesearch_x_marital_status"
        <?php } ?>
        data-table="production_employee"
        data-field="x_marital_status"
        data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->marital_status->getPlaceHolder()) ?>"
        <?= $Page->marital_status->editAttributes() ?>>
        <?= $Page->marital_status->selectOptionListHtml("x_marital_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage(false) ?></div>
<?php if (!$Page->marital_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesearch", function() {
    var options = { name: "x_marital_status", selectId: "fproduction_employeesearch_x_marital_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesearch.lists.marital_status?.lookupOptions.length) {
        options.data = { id: "x_marital_status", form: "fproduction_employeesearch" };
    } else {
        options.ajax = { id: "x_marital_status", form: "fproduction_employeesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.marital_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
    <div id="r_spouse_details" class="row"<?= $Page->spouse_details->rowAttributes() ?>>
        <label for="x_spouse_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_spouse_details"><?= $Page->spouse_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_spouse_details" id="z_spouse_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->spouse_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_spouse_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->spouse_details->getInputTextType() ?>" name="x_spouse_details" id="x_spouse_details" data-table="production_employee" data-field="x_spouse_details" value="<?= $Page->spouse_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_details->formatPattern()) ?>"<?= $Page->spouse_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->spouse_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
    <div id="r_emergency_details" class="row"<?= $Page->emergency_details->rowAttributes() ?>>
        <label for="x_emergency_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_emergency_details"><?= $Page->emergency_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_emergency_details" id="z_emergency_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->emergency_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_emergency_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->emergency_details->getInputTextType() ?>" name="x_emergency_details" id="x_emergency_details" data-table="production_employee" data-field="x_emergency_details" value="<?= $Page->emergency_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emergency_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emergency_details->formatPattern()) ?>"<?= $Page->emergency_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->emergency_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no" class="row"<?= $Page->pan_no->rowAttributes() ?>>
        <label for="x_pan_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_pan_no"><?= $Page->pan_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pan_no" id="z_pan_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_pan_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="production_employee" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no" class="row"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_aadhaar_no"><?= $Page->aadhaar_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_aadhaar_no" id="z_aadhaar_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_aadhaar_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="production_employee" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <div id="r_id_proof" class="row"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_id_proof"><?= $Page->id_proof->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_id_proof" id="z_id_proof" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id_proof->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_id_proof" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id_proof->getInputTextType() ?>" name="x_id_proof" id="x_id_proof" data-table="production_employee" data-field="x_id_proof" value="<?= $Page->id_proof->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->id_proof->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id_proof->formatPattern()) ?>"<?= $Page->id_proof->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
    <div id="r_reference_details" class="row"<?= $Page->reference_details->rowAttributes() ?>>
        <label for="x_reference_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_reference_details"><?= $Page->reference_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_reference_details" id="z_reference_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->reference_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_reference_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->reference_details->getInputTextType() ?>" name="x_reference_details" id="x_reference_details" data-table="production_employee" data-field="x_reference_details" value="<?= $Page->reference_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->reference_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference_details->formatPattern()) ?>"<?= $Page->reference_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->reference_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details" class="row"<?= $Page->other_details->rowAttributes() ?>>
        <label for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_other_details"><?= $Page->other_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_other_details" id="z_other_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->other_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_other_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->other_details->getInputTextType() ?>" name="x_other_details" id="x_other_details" data-table="production_employee" data-field="x_other_details" value="<?= $Page->other_details->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->other_details->formatPattern()) ?>"<?= $Page->other_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->doj->Visible) { // doj ?>
    <div id="r_doj" class="row"<?= $Page->doj->rowAttributes() ?>>
        <label for="x_doj" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_doj"><?= $Page->doj->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_doj" id="z_doj" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->doj->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_doj" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->doj->getInputTextType() ?>" name="x_doj" id="x_doj" data-table="production_employee" data-field="x_doj" value="<?= $Page->doj->EditValue ?>" placeholder="<?= HtmlEncode($Page->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doj->formatPattern()) ?>"<?= $Page->doj->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->doj->getErrorMessage(false) ?></div>
<?php if (!$Page->doj->ReadOnly && !$Page->doj->Disabled && !isset($Page->doj->EditAttrs["readonly"]) && !isset($Page->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "x_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dol->Visible) { // dol ?>
    <div id="r_dol" class="row"<?= $Page->dol->rowAttributes() ?>>
        <label for="x_dol" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_dol"><?= $Page->dol->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dol" id="z_dol" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dol->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_dol" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dol->getInputTextType() ?>" name="x_dol" id="x_dol" data-table="production_employee" data-field="x_dol" value="<?= $Page->dol->EditValue ?>" placeholder="<?= HtmlEncode($Page->dol->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dol->formatPattern()) ?>"<?= $Page->dol->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dol->getErrorMessage(false) ?></div>
<?php if (!$Page->dol->ReadOnly && !$Page->dol->Disabled && !isset($Page->dol->EditAttrs["readonly"]) && !isset($Page->dol->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "x_dol", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="production_employee" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->payment_details->Visible) { // payment_details ?>
    <div id="r_payment_details" class="row"<?= $Page->payment_details->rowAttributes() ?>>
        <label for="x_payment_details" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_payment_details"><?= $Page->payment_details->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_payment_details" id="z_payment_details" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->payment_details->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_payment_details" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->payment_details->getInputTextType() ?>" name="x_payment_details" id="x_payment_details" data-table="production_employee" data-field="x_payment_details" value="<?= $Page->payment_details->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->payment_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->payment_details->formatPattern()) ?>"<?= $Page->payment_details->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->payment_details->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name" class="row"<?= $Page->bank_name->rowAttributes() ?>>
        <label for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_bank_name"><?= $Page->bank_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_name" id="z_bank_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_bank_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="production_employee" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code" class="row"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_bank_ifsc_code"><?= $Page->bank_ifsc_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_ifsc_code" id="z_bank_ifsc_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_bank_ifsc_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="production_employee" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no" class="row"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_bank_account_no"><?= $Page->bank_account_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bank_account_no" id="z_bank_account_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bank_account_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_bank_account_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="production_employee" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="production_employee" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_production_employee_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="production_employee" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_production_employee_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="production_employee" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_operator->Visible) { // d_operator ?>
    <div id="r_d_operator" class="row"<?= $Page->d_operator->rowAttributes() ?>>
        <label for="x_d_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_d_operator"><?= $Page->d_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_d_operator" id="z_d_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_production_employee_d_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->d_operator->getInputTextType() ?>" name="x_d_operator" id="x_d_operator" data-table="production_employee" data-field="x_d_operator" value="<?= $Page->d_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->d_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_operator->formatPattern()) ?>"<?= $Page->d_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->d_datetime->Visible) { // d_datetime ?>
    <div id="r_d_datetime" class="row"<?= $Page->d_datetime->rowAttributes() ?>>
        <label for="x_d_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_production_employee_d_datetime"><?= $Page->d_datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->d_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_d_datetime" id="z_d_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->d_datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->d_datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_production_employee_d_datetime" class="ew-search-field">
<input type="<?= $Page->d_datetime->getInputTextType() ?>" name="x_d_datetime" id="x_d_datetime" data-table="production_employee" data-field="x_d_datetime" value="<?= $Page->d_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->d_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_datetime->formatPattern()) ?>"<?= $Page->d_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->d_datetime->ReadOnly && !$Page->d_datetime->Disabled && !isset($Page->d_datetime->EditAttrs["readonly"]) && !isset($Page->d_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "x_d_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_production_employee_d_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->d_datetime->getInputTextType() ?>" name="y_d_datetime" id="y_d_datetime" data-table="production_employee" data-field="x_d_datetime" value="<?= $Page->d_datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->d_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->d_datetime->formatPattern()) ?>"<?= $Page->d_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->d_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->d_datetime->ReadOnly && !$Page->d_datetime->Disabled && !isset($Page->d_datetime->EditAttrs["readonly"]) && !isset($Page->d_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeesearch", "y_d_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduction_employeesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduction_employeesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fproduction_employeesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_employee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
