<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionEmployeeList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_employee: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    // Write your client script here, no need to add script tags.
    var PrintECard = function(CID)
    {
    	  var CAID =[];
    	  $("#tbl_production_employeelist tbody input[type='checkbox']:checked").each(function(){
    	  		 CAID.push($(this).val());	  		 
    	  });
    	  if(CAID.length>0)
    	  {
    	  	//location.href='employeecard?id=' + CAID.toString();
    	  	window.open('employee_card?id=' + CAID.toString(), '_blank');
    	  }
    	  else
    	  {
    	  	ew.alert("Please Select atleast a row to Update");
    	  }
    }
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fproduction_employeesrch" id="fproduction_employeesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fproduction_employeesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_employee: currentTable } });
var currentForm;
var fproduction_employeesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduction_employeesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["uid", [ew.Validators.integer], fields.uid.isInvalid],
            ["y_uid", [ew.Validators.between], false],
            ["site", [], fields.site.isInvalid],
            ["id", [ew.Validators.regex(/^[0-9]{1,5}$/)], fields.id.isInvalid],
            ["user_name", [], fields.user_name.isInvalid],
            ["contractor", [], fields.contractor.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "site": <?= $Page->site->toClientList($Page) ?>,
            "contractor": <?= $Page->contractor->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->uid->Visible) { // uid ?>
<?php
if (!$Page->uid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_uid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->uid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_uid" class="ew-search-caption ew-label"><?= $Page->uid->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_uid" id="z_uid" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->uid->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->uid->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_production_employee_uid" class="ew-search-field">
<input type="<?= $Page->uid->getInputTextType() ?>" name="x_uid" id="x_uid" data-table="production_employee" data-field="x_uid" value="<?= $Page->uid->EditValue ?>" placeholder="<?= HtmlEncode($Page->uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uid->formatPattern()) ?>"<?= $Page->uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uid->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_production_employee_uid" class="ew-search-field2 d-none">
<input type="<?= $Page->uid->getInputTextType() ?>" name="y_uid" id="y_uid" data-table="production_employee" data-field="x_uid" value="<?= $Page->uid->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uid->formatPattern()) ?>"<?= $Page->uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uid->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
<?php
if (!$Page->site->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_site" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->site->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_site" class="ew-search-caption ew-label"><?= $Page->site->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_site" id="z_site" value="LIKE">
</div>
        </div>
        <div id="el_production_employee_site" class="ew-search-field">
    <select
        id="x_site[]"
        name="x_site[]"
        class="form-select ew-select<?= $Page->site->isInvalidClass() ?>"
        <?php if (!$Page->site->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesrch_x_site[]"
        <?php } ?>
        data-table="production_employee"
        data-field="x_site"
        multiple
        size="1"
        data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->site->getPlaceHolder()) ?>"
        <?= $Page->site->editAttributes() ?>>
        <?= $Page->site->selectOptionListHtml("x_site[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->site->getErrorMessage(false) ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
<?php if (!$Page->site->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesrch", function() {
    var options = { name: "x_site[]", selectId: "fproduction_employeesrch_x_site[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesrch.lists.site?.lookupOptions.length) {
        options.data = { id: "x_site[]", form: "fproduction_employeesrch" };
    } else {
        options.ajax = { id: "x_site[]", form: "fproduction_employeesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.site.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->id->Visible) { // id ?>
<?php
if (!$Page->id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_id" class="ew-search-caption ew-label"><?= $Page->id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</div>
        </div>
        <div id="el_production_employee_id" class="ew-search-field">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="production_employee" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
<?php
if (!$Page->user_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_user_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->user_name->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_user_name" class="ew-search-caption ew-label"><?= $Page->user_name->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_user_name" id="z_user_name" value="LIKE">
</div>
        </div>
        <div id="el_production_employee_user_name" class="ew-search-field">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="production_employee" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
<?php
if (!$Page->contractor->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_contractor" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->contractor->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_contractor" class="ew-search-caption ew-label"><?= $Page->contractor->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_contractor" id="z_contractor" value="=">
</div>
        </div>
        <div id="el_production_employee_contractor" class="ew-search-field">
    <select
        id="x_contractor"
        name="x_contractor"
        class="form-select ew-select<?= $Page->contractor->isInvalidClass() ?>"
        <?php if (!$Page->contractor->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesrch_x_contractor"
        <?php } ?>
        data-table="production_employee"
        data-field="x_contractor"
        data-value-separator="<?= $Page->contractor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->contractor->getPlaceHolder()) ?>"
        <?= $Page->contractor->editAttributes() ?>>
        <?= $Page->contractor->selectOptionListHtml("x_contractor") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->contractor->getErrorMessage(false) ?></div>
<?= $Page->contractor->Lookup->getParamTag($Page, "p_x_contractor") ?>
<?php if (!$Page->contractor->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesrch", function() {
    var options = { name: "x_contractor", selectId: "fproduction_employeesrch_x_contractor" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesrch.lists.contractor?.lookupOptions.length) {
        options.data = { id: "x_contractor", form: "fproduction_employeesrch" };
    } else {
        options.ajax = { id: "x_contractor", form: "fproduction_employeesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.contractor.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_production_employee_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeesrch_x_status"
        <?php } ?>
        data-table="production_employee"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeesrch", function() {
    var options = { name: "x_status", selectId: "fproduction_employeesrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeesrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduction_employeesrch" };
    } else {
        options.ajax = { id: "x_status", form: "fproduction_employeesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fproduction_employeesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fproduction_employeesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fproduction_employeesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fproduction_employeesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fproduction_employeesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fproduction_employeesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fproduction_employeesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_employee">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_production_employee" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_production_employeelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->uid->Visible) { // uid ?>
        <th data-name="uid" class="<?= $Page->uid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_production_employee_uid" class="production_employee_uid"><?= $Page->renderFieldHeader($Page->uid) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_production_employee_grp" class="production_employee_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
        <th data-name="site" class="<?= $Page->site->headerCellClass() ?>"><div id="elh_production_employee_site" class="production_employee_site"><?= $Page->renderFieldHeader($Page->site) ?></div></th>
<?php } ?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_production_employee_id" class="production_employee_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
        <th data-name="user_name" class="<?= $Page->user_name->headerCellClass() ?>"><div id="elh_production_employee_user_name" class="production_employee_user_name"><?= $Page->renderFieldHeader($Page->user_name) ?></div></th>
<?php } ?>
<?php if ($Page->salary->Visible) { // salary ?>
        <th data-name="salary" class="<?= $Page->salary->headerCellClass() ?>"><div id="elh_production_employee_salary" class="production_employee_salary"><?= $Page->renderFieldHeader($Page->salary) ?></div></th>
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
        <th data-name="contractor" class="<?= $Page->contractor->headerCellClass() ?>"><div id="elh_production_employee_contractor" class="production_employee_contractor"><?= $Page->renderFieldHeader($Page->contractor) ?></div></th>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Page->mobile->headerCellClass() ?>"><div id="elh_production_employee_mobile" class="production_employee_mobile"><?= $Page->renderFieldHeader($Page->mobile) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_production_employee_process" class="production_employee_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_production_employee_status" class="production_employee_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->employee_name->Visible) { // employee_name ?>
        <th data-name="employee_name" class="<?= $Page->employee_name->headerCellClass() ?>"><div id="elh_production_employee_employee_name" class="production_employee_employee_name"><?= $Page->renderFieldHeader($Page->employee_name) ?></div></th>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
        <th data-name="gender" class="<?= $Page->gender->headerCellClass() ?>"><div id="elh_production_employee_gender" class="production_employee_gender"><?= $Page->renderFieldHeader($Page->gender) ?></div></th>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
        <th data-name="father_name" class="<?= $Page->father_name->headerCellClass() ?>"><div id="elh_production_employee_father_name" class="production_employee_father_name"><?= $Page->renderFieldHeader($Page->father_name) ?></div></th>
<?php } ?>
<?php if ($Page->designation->Visible) { // designation ?>
        <th data-name="designation" class="<?= $Page->designation->headerCellClass() ?>"><div id="elh_production_employee_designation" class="production_employee_designation"><?= $Page->renderFieldHeader($Page->designation) ?></div></th>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
        <th data-name="permanent_address" class="<?= $Page->permanent_address->headerCellClass() ?>"><div id="elh_production_employee_permanent_address" class="production_employee_permanent_address"><?= $Page->renderFieldHeader($Page->permanent_address) ?></div></th>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
        <th data-name="city" class="<?= $Page->city->headerCellClass() ?>"><div id="elh_production_employee_city" class="production_employee_city"><?= $Page->renderFieldHeader($Page->city) ?></div></th>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
        <th data-name="dob" class="<?= $Page->dob->headerCellClass() ?>"><div id="elh_production_employee_dob" class="production_employee_dob"><?= $Page->renderFieldHeader($Page->dob) ?></div></th>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
        <th data-name="dom" class="<?= $Page->dom->headerCellClass() ?>"><div id="elh_production_employee_dom" class="production_employee_dom"><?= $Page->renderFieldHeader($Page->dom) ?></div></th>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
        <th data-name="mobile_other" class="<?= $Page->mobile_other->headerCellClass() ?>"><div id="elh_production_employee_mobile_other" class="production_employee_mobile_other"><?= $Page->renderFieldHeader($Page->mobile_other) ?></div></th>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
        <th data-name="mobile_family" class="<?= $Page->mobile_family->headerCellClass() ?>"><div id="elh_production_employee_mobile_family" class="production_employee_mobile_family"><?= $Page->renderFieldHeader($Page->mobile_family) ?></div></th>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
        <th data-name="marital_status" class="<?= $Page->marital_status->headerCellClass() ?>"><div id="elh_production_employee_marital_status" class="production_employee_marital_status"><?= $Page->renderFieldHeader($Page->marital_status) ?></div></th>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
        <th data-name="spouse_details" class="<?= $Page->spouse_details->headerCellClass() ?>"><div id="elh_production_employee_spouse_details" class="production_employee_spouse_details"><?= $Page->renderFieldHeader($Page->spouse_details) ?></div></th>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
        <th data-name="emergency_details" class="<?= $Page->emergency_details->headerCellClass() ?>"><div id="elh_production_employee_emergency_details" class="production_employee_emergency_details"><?= $Page->renderFieldHeader($Page->emergency_details) ?></div></th>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
        <th data-name="pan_no" class="<?= $Page->pan_no->headerCellClass() ?>"><div id="elh_production_employee_pan_no" class="production_employee_pan_no"><?= $Page->renderFieldHeader($Page->pan_no) ?></div></th>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
        <th data-name="aadhaar_no" class="<?= $Page->aadhaar_no->headerCellClass() ?>"><div id="elh_production_employee_aadhaar_no" class="production_employee_aadhaar_no"><?= $Page->renderFieldHeader($Page->aadhaar_no) ?></div></th>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
        <th data-name="id_proof" class="<?= $Page->id_proof->headerCellClass() ?>"><div id="elh_production_employee_id_proof" class="production_employee_id_proof"><?= $Page->renderFieldHeader($Page->id_proof) ?></div></th>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
        <th data-name="reference_details" class="<?= $Page->reference_details->headerCellClass() ?>"><div id="elh_production_employee_reference_details" class="production_employee_reference_details"><?= $Page->renderFieldHeader($Page->reference_details) ?></div></th>
<?php } ?>
<?php if ($Page->doj->Visible) { // doj ?>
        <th data-name="doj" class="<?= $Page->doj->headerCellClass() ?>"><div id="elh_production_employee_doj" class="production_employee_doj"><?= $Page->renderFieldHeader($Page->doj) ?></div></th>
<?php } ?>
<?php if ($Page->dol->Visible) { // dol ?>
        <th data-name="dol" class="<?= $Page->dol->headerCellClass() ?>"><div id="elh_production_employee_dol" class="production_employee_dol"><?= $Page->renderFieldHeader($Page->dol) ?></div></th>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Page->image->headerCellClass() ?>"><div id="elh_production_employee_image" class="production_employee_image"><?= $Page->renderFieldHeader($Page->image) ?></div></th>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
        <th data-name="bank_name" class="<?= $Page->bank_name->headerCellClass() ?>"><div id="elh_production_employee_bank_name" class="production_employee_bank_name"><?= $Page->renderFieldHeader($Page->bank_name) ?></div></th>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
        <th data-name="bank_ifsc_code" class="<?= $Page->bank_ifsc_code->headerCellClass() ?>"><div id="elh_production_employee_bank_ifsc_code" class="production_employee_bank_ifsc_code"><?= $Page->renderFieldHeader($Page->bank_ifsc_code) ?></div></th>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
        <th data-name="bank_account_no" class="<?= $Page->bank_account_no->headerCellClass() ?>"><div id="elh_production_employee_bank_account_no" class="production_employee_bank_account_no"><?= $Page->renderFieldHeader($Page->bank_account_no) ?></div></th>
<?php } ?>
<?php if ($Page->d_operator->Visible) { // d_operator ?>
        <th data-name="d_operator" class="<?= $Page->d_operator->headerCellClass() ?>"><div id="elh_production_employee_d_operator" class="production_employee_d_operator"><?= $Page->renderFieldHeader($Page->d_operator) ?></div></th>
<?php } ?>
<?php if ($Page->d_datetime->Visible) { // d_datetime ?>
        <th data-name="d_datetime" class="<?= $Page->d_datetime->headerCellClass() ?>"><div id="elh_production_employee_d_datetime" class="production_employee_d_datetime"><?= $Page->renderFieldHeader($Page->d_datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->uid->Visible) { // uid ?>
        <td data-name="uid"<?= $Page->uid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_uid" class="el_production_employee_uid">
<span<?= $Page->uid->viewAttributes() ?>>
<?= $Page->uid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_grp" class="el_production_employee_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->site->Visible) { // site ?>
        <td data-name="site"<?= $Page->site->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_site" class="el_production_employee_site">
<span<?= $Page->site->viewAttributes() ?>>
<?php if (!EmptyString($Page->site->getViewValue()) && $Page->site->linkAttributes() != "") { ?>
<a<?= $Page->site->linkAttributes() ?>><?= $Page->site->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->site->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_id" class="el_production_employee_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->user_name->Visible) { // user_name ?>
        <td data-name="user_name"<?= $Page->user_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_user_name" class="el_production_employee_user_name">
<span<?= $Page->user_name->viewAttributes() ?>>
<?= $Page->user_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->salary->Visible) { // salary ?>
        <td data-name="salary"<?= $Page->salary->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_salary" class="el_production_employee_salary">
<span<?= $Page->salary->viewAttributes() ?>>
<?= $Page->salary->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->contractor->Visible) { // contractor ?>
        <td data-name="contractor"<?= $Page->contractor->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_contractor" class="el_production_employee_contractor">
<span<?= $Page->contractor->viewAttributes() ?>>
<?= $Page->contractor->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_mobile" class="el_production_employee_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_process" class="el_production_employee_process">
<span<?= $Page->process->viewAttributes() ?>>
<?= $Page->process->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_status" class="el_production_employee_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->employee_name->Visible) { // employee_name ?>
        <td data-name="employee_name"<?= $Page->employee_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_employee_name" class="el_production_employee_employee_name">
<span<?= $Page->employee_name->viewAttributes() ?>>
<?= $Page->employee_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gender->Visible) { // gender ?>
        <td data-name="gender"<?= $Page->gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_gender" class="el_production_employee_gender">
<span<?= $Page->gender->viewAttributes() ?>>
<?= $Page->gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->father_name->Visible) { // father_name ?>
        <td data-name="father_name"<?= $Page->father_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_father_name" class="el_production_employee_father_name">
<span<?= $Page->father_name->viewAttributes() ?>>
<?= $Page->father_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->designation->Visible) { // designation ?>
        <td data-name="designation"<?= $Page->designation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_designation" class="el_production_employee_designation">
<span<?= $Page->designation->viewAttributes() ?>>
<?= $Page->designation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->permanent_address->Visible) { // permanent_address ?>
        <td data-name="permanent_address"<?= $Page->permanent_address->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_permanent_address" class="el_production_employee_permanent_address">
<span<?= $Page->permanent_address->viewAttributes() ?>>
<?= $Page->permanent_address->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->city->Visible) { // city ?>
        <td data-name="city"<?= $Page->city->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_city" class="el_production_employee_city">
<span<?= $Page->city->viewAttributes() ?>>
<?= $Page->city->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dob->Visible) { // dob ?>
        <td data-name="dob"<?= $Page->dob->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_dob" class="el_production_employee_dob">
<span<?= $Page->dob->viewAttributes() ?>>
<?= $Page->dob->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dom->Visible) { // dom ?>
        <td data-name="dom"<?= $Page->dom->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_dom" class="el_production_employee_dom">
<span<?= $Page->dom->viewAttributes() ?>>
<?= $Page->dom->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile_other->Visible) { // mobile_other ?>
        <td data-name="mobile_other"<?= $Page->mobile_other->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_mobile_other" class="el_production_employee_mobile_other">
<span<?= $Page->mobile_other->viewAttributes() ?>>
<?= $Page->mobile_other->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile_family->Visible) { // mobile_family ?>
        <td data-name="mobile_family"<?= $Page->mobile_family->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_mobile_family" class="el_production_employee_mobile_family">
<span<?= $Page->mobile_family->viewAttributes() ?>>
<?= $Page->mobile_family->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->marital_status->Visible) { // marital_status ?>
        <td data-name="marital_status"<?= $Page->marital_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_marital_status" class="el_production_employee_marital_status">
<span<?= $Page->marital_status->viewAttributes() ?>>
<?= $Page->marital_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->spouse_details->Visible) { // spouse_details ?>
        <td data-name="spouse_details"<?= $Page->spouse_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_spouse_details" class="el_production_employee_spouse_details">
<span<?= $Page->spouse_details->viewAttributes() ?>>
<?= $Page->spouse_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->emergency_details->Visible) { // emergency_details ?>
        <td data-name="emergency_details"<?= $Page->emergency_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_emergency_details" class="el_production_employee_emergency_details">
<span<?= $Page->emergency_details->viewAttributes() ?>>
<?= $Page->emergency_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pan_no->Visible) { // pan_no ?>
        <td data-name="pan_no"<?= $Page->pan_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_pan_no" class="el_production_employee_pan_no">
<span<?= $Page->pan_no->viewAttributes() ?>>
<?= $Page->pan_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
        <td data-name="aadhaar_no"<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_aadhaar_no" class="el_production_employee_aadhaar_no">
<span<?= $Page->aadhaar_no->viewAttributes() ?>>
<?= $Page->aadhaar_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->id_proof->Visible) { // id_proof ?>
        <td data-name="id_proof"<?= $Page->id_proof->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_id_proof" class="el_production_employee_id_proof">
<span<?= $Page->id_proof->viewAttributes() ?>>
<?= GetFileViewTag($Page->id_proof, $Page->id_proof->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->reference_details->Visible) { // reference_details ?>
        <td data-name="reference_details"<?= $Page->reference_details->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_reference_details" class="el_production_employee_reference_details">
<span<?= $Page->reference_details->viewAttributes() ?>>
<?= $Page->reference_details->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->doj->Visible) { // doj ?>
        <td data-name="doj"<?= $Page->doj->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_doj" class="el_production_employee_doj">
<span<?= $Page->doj->viewAttributes() ?>>
<?= $Page->doj->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dol->Visible) { // dol ?>
        <td data-name="dol"<?= $Page->dol->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_dol" class="el_production_employee_dol">
<span<?= $Page->dol->viewAttributes() ?>>
<?= $Page->dol->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_image" class="el_production_employee_image">
<span<?= $Page->image->viewAttributes() ?>>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_name->Visible) { // bank_name ?>
        <td data-name="bank_name"<?= $Page->bank_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_bank_name" class="el_production_employee_bank_name">
<span<?= $Page->bank_name->viewAttributes() ?>>
<?= $Page->bank_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
        <td data-name="bank_ifsc_code"<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_bank_ifsc_code" class="el_production_employee_bank_ifsc_code">
<span<?= $Page->bank_ifsc_code->viewAttributes() ?>>
<?= $Page->bank_ifsc_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
        <td data-name="bank_account_no"<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_bank_account_no" class="el_production_employee_bank_account_no">
<span<?= $Page->bank_account_no->viewAttributes() ?>>
<?= $Page->bank_account_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_operator->Visible) { // d_operator ?>
        <td data-name="d_operator"<?= $Page->d_operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_d_operator" class="el_production_employee_d_operator">
<span<?= $Page->d_operator->viewAttributes() ?>>
<?= $Page->d_operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->d_datetime->Visible) { // d_datetime ?>
        <td data-name="d_datetime"<?= $Page->d_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_production_employee_d_datetime" class="el_production_employee_d_datetime">
<span<?= $Page->d_datetime->viewAttributes() ?>>
<?= $Page->d_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_employee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
