<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionEmployeeHsAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_employee_hs: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fproduction_employee_hsadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduction_employee_hsadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null, ew.Validators.integer], fields.id.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["site", [fields.site.visible && fields.site.required ? ew.Validators.required(fields.site.caption) : null], fields.site.isInvalid],
            ["user_name", [fields.user_name.visible && fields.user_name.required ? ew.Validators.required(fields.user_name.caption) : null], fields.user_name.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["employee_name", [fields.employee_name.visible && fields.employee_name.required ? ew.Validators.required(fields.employee_name.caption) : null], fields.employee_name.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["father_name", [fields.father_name.visible && fields.father_name.required ? ew.Validators.required(fields.father_name.caption) : null], fields.father_name.isInvalid],
            ["designation", [fields.designation.visible && fields.designation.required ? ew.Validators.required(fields.designation.caption) : null, ew.Validators.integer], fields.designation.isInvalid],
            ["permanent_address", [fields.permanent_address.visible && fields.permanent_address.required ? ew.Validators.required(fields.permanent_address.caption) : null], fields.permanent_address.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [fields.dom.visible && fields.dom.required ? ew.Validators.required(fields.dom.caption) : null, ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["mobile_other", [fields.mobile_other.visible && fields.mobile_other.required ? ew.Validators.required(fields.mobile_other.caption) : null], fields.mobile_other.isInvalid],
            ["mobile_family", [fields.mobile_family.visible && fields.mobile_family.required ? ew.Validators.required(fields.mobile_family.caption) : null], fields.mobile_family.isInvalid],
            ["marital_status", [fields.marital_status.visible && fields.marital_status.required ? ew.Validators.required(fields.marital_status.caption) : null], fields.marital_status.isInvalid],
            ["spouse_details", [fields.spouse_details.visible && fields.spouse_details.required ? ew.Validators.required(fields.spouse_details.caption) : null], fields.spouse_details.isInvalid],
            ["emergency_details", [fields.emergency_details.visible && fields.emergency_details.required ? ew.Validators.required(fields.emergency_details.caption) : null], fields.emergency_details.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null], fields.aadhaar_no.isInvalid],
            ["id_proof", [fields.id_proof.visible && fields.id_proof.required ? ew.Validators.required(fields.id_proof.caption) : null], fields.id_proof.isInvalid],
            ["reference_details", [fields.reference_details.visible && fields.reference_details.required ? ew.Validators.required(fields.reference_details.caption) : null], fields.reference_details.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["doj", [fields.doj.visible && fields.doj.required ? ew.Validators.required(fields.doj.caption) : null, ew.Validators.datetime(fields.doj.clientFormatPattern)], fields.doj.isInvalid],
            ["doc", [fields.doc.visible && fields.doc.required ? ew.Validators.required(fields.doc.caption) : null, ew.Validators.datetime(fields.doc.clientFormatPattern)], fields.doc.isInvalid],
            ["dol", [fields.dol.visible && fields.dol.required ? ew.Validators.required(fields.dol.caption) : null, ew.Validators.datetime(fields.dol.clientFormatPattern)], fields.dol.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["payment_details", [fields.payment_details.visible && fields.payment_details.required ? ew.Validators.required(fields.payment_details.caption) : null], fields.payment_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "site": <?= $Page->site->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduction_employee_hsadd" id="fproduction_employee_hsadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="production_employee_hs">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_production_employee_hs_id" for="x_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_production_employee_hs_id">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="production_employee_hs" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?> aria-describedby="x_id_help">
<?= $Page->id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_production_employee_hs_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_production_employee_hs_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduction_employee_hsadd_x_grp"
        <?php } ?>
        data-table="production_employee_hs"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employee_hsadd", function() {
    var options = { name: "x_grp", selectId: "fproduction_employee_hsadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employee_hsadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduction_employee_hsadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduction_employee_hsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee_hs.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site"<?= $Page->site->rowAttributes() ?>>
        <label id="elh_production_employee_hs_site" for="x_site" class="<?= $Page->LeftColumnClass ?>"><?= $Page->site->caption() ?><?= $Page->site->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->site->cellAttributes() ?>>
<span id="el_production_employee_hs_site">
    <select
        id="x_site"
        name="x_site"
        class="form-select ew-select<?= $Page->site->isInvalidClass() ?>"
        <?php if (!$Page->site->IsNativeSelect) { ?>
        data-select2-id="fproduction_employee_hsadd_x_site"
        <?php } ?>
        data-table="production_employee_hs"
        data-field="x_site"
        data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->site->getPlaceHolder()) ?>"
        <?= $Page->site->editAttributes() ?>>
        <?= $Page->site->selectOptionListHtml("x_site") ?>
    </select>
    <?= $Page->site->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->site->getErrorMessage() ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
<?php if (!$Page->site->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employee_hsadd", function() {
    var options = { name: "x_site", selectId: "fproduction_employee_hsadd_x_site" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employee_hsadd.lists.site?.lookupOptions.length) {
        options.data = { id: "x_site", form: "fproduction_employee_hsadd" };
    } else {
        options.ajax = { id: "x_site", form: "fproduction_employee_hsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee_hs.fields.site.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name"<?= $Page->user_name->rowAttributes() ?>>
        <label id="elh_production_employee_hs_user_name" for="x_user_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->user_name->caption() ?><?= $Page->user_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->user_name->cellAttributes() ?>>
<span id="el_production_employee_hs_user_name">
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="production_employee_hs" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?> aria-describedby="x_user_name_help">
<?= $Page->user_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address"<?= $Page->address->rowAttributes() ?>>
        <label id="elh_production_employee_hs_address" for="x_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->address->caption() ?><?= $Page->address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->address->cellAttributes() ?>>
<span id="el_production_employee_hs_address">
<textarea data-table="production_employee_hs" data-field="x_address" name="x_address" id="x_address" cols="2" rows="3" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>"<?= $Page->address->editAttributes() ?> aria-describedby="x_address_help"><?= $Page->address->EditValue ?></textarea>
<?= $Page->address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label id="elh_production_employee_hs_mobile" for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile->cellAttributes() ?>>
<span id="el_production_employee_hs_mobile">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="production_employee_hs" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label id="elh_production_employee_hs_process" class="<?= $Page->LeftColumnClass ?>"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->process->cellAttributes() ?>>
<span id="el_production_employee_hs_process">
<template id="tp_x_process">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_employee_hs" data-field="x_process" name="x_process" id="x_process"<?= $Page->process->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process" class="ew-item-list"></div>
<selection-list hidden
    id="x_process[]"
    name="x_process[]"
    value="<?= HtmlEncode($Page->process->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process"
    data-target="dsl_x_process"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process->isInvalidClass() ?>"
    data-table="production_employee_hs"
    data-field="x_process"
    data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
    <?= $Page->process->editAttributes() ?>></selection-list>
<?= $Page->process->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_name->Visible) { // employee_name ?>
    <div id="r_employee_name"<?= $Page->employee_name->rowAttributes() ?>>
        <label id="elh_production_employee_hs_employee_name" for="x_employee_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_name->caption() ?><?= $Page->employee_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_name->cellAttributes() ?>>
<span id="el_production_employee_hs_employee_name">
<input type="<?= $Page->employee_name->getInputTextType() ?>" name="x_employee_name" id="x_employee_name" data-table="production_employee_hs" data-field="x_employee_name" value="<?= $Page->employee_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->employee_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_name->formatPattern()) ?>"<?= $Page->employee_name->editAttributes() ?> aria-describedby="x_employee_name_help">
<?= $Page->employee_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label id="elh_production_employee_hs_gender" class="<?= $Page->LeftColumnClass ?>"><?= $Page->gender->caption() ?><?= $Page->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->gender->cellAttributes() ?>>
<span id="el_production_employee_hs_gender">
<template id="tp_x_gender">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="production_employee_hs" data-field="x_gender" name="x_gender" id="x_gender"<?= $Page->gender->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_gender" class="ew-item-list"></div>
<selection-list hidden
    id="x_gender"
    name="x_gender"
    value="<?= HtmlEncode($Page->gender->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_gender"
    data-target="dsl_x_gender"
    data-repeatcolumn="5"
    class="form-control<?= $Page->gender->isInvalidClass() ?>"
    data-table="production_employee_hs"
    data-field="x_gender"
    data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
    <?= $Page->gender->editAttributes() ?>></selection-list>
<?= $Page->gender->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name"<?= $Page->father_name->rowAttributes() ?>>
        <label id="elh_production_employee_hs_father_name" for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->father_name->caption() ?><?= $Page->father_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->father_name->cellAttributes() ?>>
<span id="el_production_employee_hs_father_name">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="production_employee_hs" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?> aria-describedby="x_father_name_help">
<?= $Page->father_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->designation->Visible) { // designation ?>
    <div id="r_designation"<?= $Page->designation->rowAttributes() ?>>
        <label id="elh_production_employee_hs_designation" for="x_designation" class="<?= $Page->LeftColumnClass ?>"><?= $Page->designation->caption() ?><?= $Page->designation->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->designation->cellAttributes() ?>>
<span id="el_production_employee_hs_designation">
<input type="<?= $Page->designation->getInputTextType() ?>" name="x_designation" id="x_designation" data-table="production_employee_hs" data-field="x_designation" value="<?= $Page->designation->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->designation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->designation->formatPattern()) ?>"<?= $Page->designation->editAttributes() ?> aria-describedby="x_designation_help">
<?= $Page->designation->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->designation->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
    <div id="r_permanent_address"<?= $Page->permanent_address->rowAttributes() ?>>
        <label id="elh_production_employee_hs_permanent_address" for="x_permanent_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->permanent_address->caption() ?><?= $Page->permanent_address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->permanent_address->cellAttributes() ?>>
<span id="el_production_employee_hs_permanent_address">
<textarea data-table="production_employee_hs" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" cols="3" rows="3" placeholder="<?= HtmlEncode($Page->permanent_address->getPlaceHolder()) ?>"<?= $Page->permanent_address->editAttributes() ?> aria-describedby="x_permanent_address_help"><?= $Page->permanent_address->EditValue ?></textarea>
<?= $Page->permanent_address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->permanent_address->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label id="elh_production_employee_hs_city" for="x_city" class="<?= $Page->LeftColumnClass ?>"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->city->cellAttributes() ?>>
<span id="el_production_employee_hs_city">
<input type="<?= $Page->city->getInputTextType() ?>" name="x_city" id="x_city" data-table="production_employee_hs" data-field="x_city" value="<?= $Page->city->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city->formatPattern()) ?>"<?= $Page->city->editAttributes() ?> aria-describedby="x_city_help">
<?= $Page->city->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label id="elh_production_employee_hs_dob" for="x_dob" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dob->caption() ?><?= $Page->dob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dob->cellAttributes() ?>>
<span id="el_production_employee_hs_dob">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="production_employee_hs" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
<?= $Page->dob->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employee_hsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employee_hsadd", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <label id="elh_production_employee_hs_dom" for="x_dom" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dom->caption() ?><?= $Page->dom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dom->cellAttributes() ?>>
<span id="el_production_employee_hs_dom">
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="production_employee_hs" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?> aria-describedby="x_dom_help">
<?= $Page->dom->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage() ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employee_hsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employee_hsadd", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <div id="r_mobile_other"<?= $Page->mobile_other->rowAttributes() ?>>
        <label id="elh_production_employee_hs_mobile_other" for="x_mobile_other" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_other->caption() ?><?= $Page->mobile_other->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_other->cellAttributes() ?>>
<span id="el_production_employee_hs_mobile_other">
<input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="production_employee_hs" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?> aria-describedby="x_mobile_other_help">
<?= $Page->mobile_other->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
    <div id="r_mobile_family"<?= $Page->mobile_family->rowAttributes() ?>>
        <label id="elh_production_employee_hs_mobile_family" for="x_mobile_family" class="<?= $Page->LeftColumnClass ?>"><?= $Page->mobile_family->caption() ?><?= $Page->mobile_family->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->mobile_family->cellAttributes() ?>>
<span id="el_production_employee_hs_mobile_family">
<input type="<?= $Page->mobile_family->getInputTextType() ?>" name="x_mobile_family" id="x_mobile_family" data-table="production_employee_hs" data-field="x_mobile_family" value="<?= $Page->mobile_family->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->mobile_family->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_family->formatPattern()) ?>"<?= $Page->mobile_family->editAttributes() ?> aria-describedby="x_mobile_family_help">
<?= $Page->mobile_family->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_family->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <label id="elh_production_employee_hs_marital_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->marital_status->caption() ?><?= $Page->marital_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->marital_status->cellAttributes() ?>>
<span id="el_production_employee_hs_marital_status">
<template id="tp_x_marital_status">
    <div class="form-check">
        <input type="radio" class="form-check-input" data-table="production_employee_hs" data-field="x_marital_status" name="x_marital_status" id="x_marital_status"<?= $Page->marital_status->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_marital_status" class="ew-item-list"></div>
<selection-list hidden
    id="x_marital_status"
    name="x_marital_status"
    value="<?= HtmlEncode($Page->marital_status->CurrentValue) ?>"
    data-type="select-one"
    data-template="tp_x_marital_status"
    data-target="dsl_x_marital_status"
    data-repeatcolumn="5"
    class="form-control<?= $Page->marital_status->isInvalidClass() ?>"
    data-table="production_employee_hs"
    data-field="x_marital_status"
    data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
    <?= $Page->marital_status->editAttributes() ?>></selection-list>
<?= $Page->marital_status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
    <div id="r_spouse_details"<?= $Page->spouse_details->rowAttributes() ?>>
        <label id="elh_production_employee_hs_spouse_details" for="x_spouse_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->spouse_details->caption() ?><?= $Page->spouse_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->spouse_details->cellAttributes() ?>>
<span id="el_production_employee_hs_spouse_details">
<input type="<?= $Page->spouse_details->getInputTextType() ?>" name="x_spouse_details" id="x_spouse_details" data-table="production_employee_hs" data-field="x_spouse_details" value="<?= $Page->spouse_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_details->formatPattern()) ?>"<?= $Page->spouse_details->editAttributes() ?> aria-describedby="x_spouse_details_help">
<?= $Page->spouse_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->spouse_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
    <div id="r_emergency_details"<?= $Page->emergency_details->rowAttributes() ?>>
        <label id="elh_production_employee_hs_emergency_details" for="x_emergency_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->emergency_details->caption() ?><?= $Page->emergency_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->emergency_details->cellAttributes() ?>>
<span id="el_production_employee_hs_emergency_details">
<input type="<?= $Page->emergency_details->getInputTextType() ?>" name="x_emergency_details" id="x_emergency_details" data-table="production_employee_hs" data-field="x_emergency_details" value="<?= $Page->emergency_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emergency_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emergency_details->formatPattern()) ?>"<?= $Page->emergency_details->editAttributes() ?> aria-describedby="x_emergency_details_help">
<?= $Page->emergency_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->emergency_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label id="elh_production_employee_hs_aadhaar_no" for="x_aadhaar_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->aadhaar_no->caption() ?><?= $Page->aadhaar_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->aadhaar_no->cellAttributes() ?>>
<span id="el_production_employee_hs_aadhaar_no">
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="production_employee_hs" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
<?= $Page->aadhaar_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <div id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <label id="elh_production_employee_hs_id_proof" for="x_id_proof" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id_proof->caption() ?><?= $Page->id_proof->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id_proof->cellAttributes() ?>>
<span id="el_production_employee_hs_id_proof">
<input type="<?= $Page->id_proof->getInputTextType() ?>" name="x_id_proof" id="x_id_proof" data-table="production_employee_hs" data-field="x_id_proof" value="<?= $Page->id_proof->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->id_proof->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id_proof->formatPattern()) ?>"<?= $Page->id_proof->editAttributes() ?> aria-describedby="x_id_proof_help">
<?= $Page->id_proof->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
    <div id="r_reference_details"<?= $Page->reference_details->rowAttributes() ?>>
        <label id="elh_production_employee_hs_reference_details" for="x_reference_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->reference_details->caption() ?><?= $Page->reference_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->reference_details->cellAttributes() ?>>
<span id="el_production_employee_hs_reference_details">
<input type="<?= $Page->reference_details->getInputTextType() ?>" name="x_reference_details" id="x_reference_details" data-table="production_employee_hs" data-field="x_reference_details" value="<?= $Page->reference_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->reference_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference_details->formatPattern()) ?>"<?= $Page->reference_details->editAttributes() ?> aria-describedby="x_reference_details_help">
<?= $Page->reference_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label id="elh_production_employee_hs_other_details" for="x_other_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->other_details->caption() ?><?= $Page->other_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->other_details->cellAttributes() ?>>
<span id="el_production_employee_hs_other_details">
<textarea data-table="production_employee_hs" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help"><?= $Page->other_details->EditValue ?></textarea>
<?= $Page->other_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->doj->Visible) { // doj ?>
    <div id="r_doj"<?= $Page->doj->rowAttributes() ?>>
        <label id="elh_production_employee_hs_doj" for="x_doj" class="<?= $Page->LeftColumnClass ?>"><?= $Page->doj->caption() ?><?= $Page->doj->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->doj->cellAttributes() ?>>
<span id="el_production_employee_hs_doj">
<input type="<?= $Page->doj->getInputTextType() ?>" name="x_doj" id="x_doj" data-table="production_employee_hs" data-field="x_doj" value="<?= $Page->doj->EditValue ?>" placeholder="<?= HtmlEncode($Page->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doj->formatPattern()) ?>"<?= $Page->doj->editAttributes() ?> aria-describedby="x_doj_help">
<?= $Page->doj->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->doj->getErrorMessage() ?></div>
<?php if (!$Page->doj->ReadOnly && !$Page->doj->Disabled && !isset($Page->doj->EditAttrs["readonly"]) && !isset($Page->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employee_hsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employee_hsadd", "x_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->doc->Visible) { // doc ?>
    <div id="r_doc"<?= $Page->doc->rowAttributes() ?>>
        <label id="elh_production_employee_hs_doc" for="x_doc" class="<?= $Page->LeftColumnClass ?>"><?= $Page->doc->caption() ?><?= $Page->doc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->doc->cellAttributes() ?>>
<span id="el_production_employee_hs_doc">
<input type="<?= $Page->doc->getInputTextType() ?>" name="x_doc" id="x_doc" data-table="production_employee_hs" data-field="x_doc" value="<?= $Page->doc->EditValue ?>" placeholder="<?= HtmlEncode($Page->doc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doc->formatPattern()) ?>"<?= $Page->doc->editAttributes() ?> aria-describedby="x_doc_help">
<?= $Page->doc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->doc->getErrorMessage() ?></div>
<?php if (!$Page->doc->ReadOnly && !$Page->doc->Disabled && !isset($Page->doc->EditAttrs["readonly"]) && !isset($Page->doc->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employee_hsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employee_hsadd", "x_doc", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dol->Visible) { // dol ?>
    <div id="r_dol"<?= $Page->dol->rowAttributes() ?>>
        <label id="elh_production_employee_hs_dol" for="x_dol" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dol->caption() ?><?= $Page->dol->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dol->cellAttributes() ?>>
<span id="el_production_employee_hs_dol">
<input type="<?= $Page->dol->getInputTextType() ?>" name="x_dol" id="x_dol" data-table="production_employee_hs" data-field="x_dol" value="<?= $Page->dol->EditValue ?>" placeholder="<?= HtmlEncode($Page->dol->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dol->formatPattern()) ?>"<?= $Page->dol->editAttributes() ?> aria-describedby="x_dol_help">
<?= $Page->dol->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dol->getErrorMessage() ?></div>
<?php if (!$Page->dol->ReadOnly && !$Page->dol->Disabled && !isset($Page->dol->EditAttrs["readonly"]) && !isset($Page->dol->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employee_hsadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employee_hsadd", "x_dol", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label id="elh_production_employee_hs_image" class="<?= $Page->LeftColumnClass ?>"><?= $Page->image->caption() ?><?= $Page->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->image->cellAttributes() ?>>
<span id="el_production_employee_hs_image">
<div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_image"
        name="x_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="production_employee_hs"
        data-field="x_image"
        data-size="48"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->image->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_image_help"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_details->Visible) { // payment_details ?>
    <div id="r_payment_details"<?= $Page->payment_details->rowAttributes() ?>>
        <label id="elh_production_employee_hs_payment_details" for="x_payment_details" class="<?= $Page->LeftColumnClass ?>"><?= $Page->payment_details->caption() ?><?= $Page->payment_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->payment_details->cellAttributes() ?>>
<span id="el_production_employee_hs_payment_details">
<textarea data-table="production_employee_hs" data-field="x_payment_details" name="x_payment_details" id="x_payment_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->payment_details->getPlaceHolder()) ?>"<?= $Page->payment_details->editAttributes() ?> aria-describedby="x_payment_details_help"><?= $Page->payment_details->EditValue ?></textarea>
<?= $Page->payment_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->payment_details->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label id="elh_production_employee_hs_bank_name" for="x_bank_name" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_name->caption() ?><?= $Page->bank_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_name->cellAttributes() ?>>
<span id="el_production_employee_hs_bank_name">
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="production_employee_hs" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
<?= $Page->bank_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label id="elh_production_employee_hs_bank_ifsc_code" for="x_bank_ifsc_code" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_ifsc_code->caption() ?><?= $Page->bank_ifsc_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<span id="el_production_employee_hs_bank_ifsc_code">
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="production_employee_hs" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
<?= $Page->bank_ifsc_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label id="elh_production_employee_hs_bank_account_no" for="x_bank_account_no" class="<?= $Page->LeftColumnClass ?>"><?= $Page->bank_account_no->caption() ?><?= $Page->bank_account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->bank_account_no->cellAttributes() ?>>
<span id="el_production_employee_hs_bank_account_no">
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="production_employee_hs" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
<?= $Page->bank_account_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_production_employee_hs_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_production_employee_hs_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduction_employee_hsadd_x_status"
        <?php } ?>
        data-table="production_employee_hs"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employee_hsadd", function() {
    var options = { name: "x_status", selectId: "fproduction_employee_hsadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employee_hsadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduction_employee_hsadd" };
    } else {
        options.ajax = { id: "x_status", form: "fproduction_employee_hsadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee_hs.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduction_employee_hsadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduction_employee_hsadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_employee_hs");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    $("#r_spouse_details").addClass('hide');
});
</script>
