<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductionEmployeeAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { production_employee: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fproduction_employeeaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduction_employeeaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["site", [fields.site.visible && fields.site.required ? ew.Validators.required(fields.site.caption) : null], fields.site.isInvalid],
            ["user_name", [fields.user_name.visible && fields.user_name.required ? ew.Validators.required(fields.user_name.caption) : null], fields.user_name.isInvalid],
            ["salary", [fields.salary.visible && fields.salary.required ? ew.Validators.required(fields.salary.caption) : null, ew.Validators.integer], fields.salary.isInvalid],
            ["contractor", [fields.contractor.visible && fields.contractor.required ? ew.Validators.required(fields.contractor.caption) : null], fields.contractor.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null, ew.Validators.integer], fields.mobile.isInvalid],
            ["process", [fields.process.visible && fields.process.required ? ew.Validators.required(fields.process.caption) : null], fields.process.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["employee_name", [fields.employee_name.visible && fields.employee_name.required ? ew.Validators.required(fields.employee_name.caption) : null], fields.employee_name.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["father_name", [fields.father_name.visible && fields.father_name.required ? ew.Validators.required(fields.father_name.caption) : null], fields.father_name.isInvalid],
            ["designation", [fields.designation.visible && fields.designation.required ? ew.Validators.required(fields.designation.caption) : null], fields.designation.isInvalid],
            ["permanent_address", [fields.permanent_address.visible && fields.permanent_address.required ? ew.Validators.required(fields.permanent_address.caption) : null], fields.permanent_address.isInvalid],
            ["city", [fields.city.visible && fields.city.required ? ew.Validators.required(fields.city.caption) : null], fields.city.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["dom", [fields.dom.visible && fields.dom.required ? ew.Validators.required(fields.dom.caption) : null, ew.Validators.datetime(fields.dom.clientFormatPattern)], fields.dom.isInvalid],
            ["mobile_other", [fields.mobile_other.visible && fields.mobile_other.required ? ew.Validators.required(fields.mobile_other.caption) : null], fields.mobile_other.isInvalid],
            ["mobile_family", [fields.mobile_family.visible && fields.mobile_family.required ? ew.Validators.required(fields.mobile_family.caption) : null], fields.mobile_family.isInvalid],
            ["marital_status", [fields.marital_status.visible && fields.marital_status.required ? ew.Validators.required(fields.marital_status.caption) : null], fields.marital_status.isInvalid],
            ["spouse_details", [fields.spouse_details.visible && fields.spouse_details.required ? ew.Validators.required(fields.spouse_details.caption) : null], fields.spouse_details.isInvalid],
            ["emergency_details", [fields.emergency_details.visible && fields.emergency_details.required ? ew.Validators.required(fields.emergency_details.caption) : null], fields.emergency_details.isInvalid],
            ["pan_no", [fields.pan_no.visible && fields.pan_no.required ? ew.Validators.required(fields.pan_no.caption) : null], fields.pan_no.isInvalid],
            ["aadhaar_no", [fields.aadhaar_no.visible && fields.aadhaar_no.required ? ew.Validators.required(fields.aadhaar_no.caption) : null, ew.Validators.regex(/^[2-9]{1}[0-9]{3}\s[0-9]{4}\s[0-9]{4}$/)], fields.aadhaar_no.isInvalid],
            ["id_proof", [fields.id_proof.visible && fields.id_proof.required ? ew.Validators.fileRequired(fields.id_proof.caption) : null], fields.id_proof.isInvalid],
            ["reference_details", [fields.reference_details.visible && fields.reference_details.required ? ew.Validators.required(fields.reference_details.caption) : null], fields.reference_details.isInvalid],
            ["other_details", [fields.other_details.visible && fields.other_details.required ? ew.Validators.required(fields.other_details.caption) : null], fields.other_details.isInvalid],
            ["doj", [fields.doj.visible && fields.doj.required ? ew.Validators.required(fields.doj.caption) : null, ew.Validators.datetime(fields.doj.clientFormatPattern)], fields.doj.isInvalid],
            ["doc", [fields.doc.visible && fields.doc.required ? ew.Validators.required(fields.doc.caption) : null, ew.Validators.datetime(fields.doc.clientFormatPattern)], fields.doc.isInvalid],
            ["dol", [fields.dol.visible && fields.dol.required ? ew.Validators.required(fields.dol.caption) : null, ew.Validators.datetime(fields.dol.clientFormatPattern)], fields.dol.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["payment_details", [fields.payment_details.visible && fields.payment_details.required ? ew.Validators.required(fields.payment_details.caption) : null], fields.payment_details.isInvalid],
            ["bank_name", [fields.bank_name.visible && fields.bank_name.required ? ew.Validators.required(fields.bank_name.caption) : null], fields.bank_name.isInvalid],
            ["bank_ifsc_code", [fields.bank_ifsc_code.visible && fields.bank_ifsc_code.required ? ew.Validators.required(fields.bank_ifsc_code.caption) : null], fields.bank_ifsc_code.isInvalid],
            ["bank_account_no", [fields.bank_account_no.visible && fields.bank_account_no.required ? ew.Validators.required(fields.bank_account_no.caption) : null], fields.bank_account_no.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null, ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null, ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["d_operator", [fields.d_operator.visible && fields.d_operator.required ? ew.Validators.required(fields.d_operator.caption) : null], fields.d_operator.isInvalid],
            ["d_datetime", [fields.d_datetime.visible && fields.d_datetime.required ? ew.Validators.required(fields.d_datetime.caption) : null], fields.d_datetime.isInvalid],
            ["am_id", [fields.am_id.visible && fields.am_id.required ? ew.Validators.required(fields.am_id.caption) : null, ew.Validators.integer], fields.am_id.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "site": <?= $Page->site->toClientList($Page) ?>,
            "contractor": <?= $Page->contractor->toClientList($Page) ?>,
            "process": <?= $Page->process->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "marital_status": <?= $Page->marital_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fproduction_employeeaddopt" id="fproduction_employeeaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="production_employee">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->grp->cellAttributes() ?>>
<template id="tp_x_grp">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_grp" name="x_grp" id="x_grp"<?= $Page->grp->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_grp" class="ew-item-list"></div>
<selection-list hidden
    id="x_grp[]"
    name="x_grp[]"
    value="<?= HtmlEncode($Page->grp->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_grp"
    data-target="dsl_x_grp"
    data-repeatcolumn="3"
    class="form-control<?= $Page->grp->isInvalidClass() ?>"
    data-table="production_employee"
    data-field="x_grp"
    data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
    <?= $Page->grp->editAttributes() ?>></selection-list>
<?= $Page->grp->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->site->Visible) { // site ?>
    <div id="r_site"<?= $Page->site->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_site"><?= $Page->site->caption() ?><?= $Page->site->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->site->cellAttributes() ?>>
    <select
        id="x_site[]"
        name="x_site[]"
        class="form-select ew-select<?= $Page->site->isInvalidClass() ?>"
        <?php if (!$Page->site->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeeaddopt_x_site[]"
        <?php } ?>
        data-table="production_employee"
        data-field="x_site"
        multiple
        size="1"
        data-value-separator="<?= $Page->site->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->site->getPlaceHolder()) ?>"
        <?= $Page->site->editAttributes() ?>>
        <?= $Page->site->selectOptionListHtml("x_site[]") ?>
    </select>
    <?= $Page->site->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->site->getErrorMessage() ?></div>
<?= $Page->site->Lookup->getParamTag($Page, "p_x_site") ?>
<?php if (!$Page->site->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeeaddopt", function() {
    var options = { name: "x_site[]", selectId: "fproduction_employeeaddopt_x_site[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeeaddopt.lists.site?.lookupOptions.length) {
        options.data = { id: "x_site[]", form: "fproduction_employeeaddopt" };
    } else {
        options.ajax = { id: "x_site[]", form: "fproduction_employeeaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.site.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->user_name->Visible) { // user_name ?>
    <div id="r_user_name"<?= $Page->user_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_user_name"><?= $Page->user_name->caption() ?><?= $Page->user_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->user_name->cellAttributes() ?>>
<input type="<?= $Page->user_name->getInputTextType() ?>" name="x_user_name" id="x_user_name" data-table="production_employee" data-field="x_user_name" value="<?= $Page->user_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->user_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->user_name->formatPattern()) ?>"<?= $Page->user_name->editAttributes() ?> aria-describedby="x_user_name_help">
<?= $Page->user_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->user_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->salary->Visible) { // salary ?>
    <div id="r_salary"<?= $Page->salary->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_salary"><?= $Page->salary->caption() ?><?= $Page->salary->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->salary->cellAttributes() ?>>
<input type="<?= $Page->salary->getInputTextType() ?>" name="x_salary" id="x_salary" data-table="production_employee" data-field="x_salary" value="<?= $Page->salary->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->salary->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->salary->formatPattern()) ?>"<?= $Page->salary->editAttributes() ?> aria-describedby="x_salary_help">
<?= $Page->salary->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->salary->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->contractor->Visible) { // contractor ?>
    <div id="r_contractor"<?= $Page->contractor->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_contractor"><?= $Page->contractor->caption() ?><?= $Page->contractor->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->contractor->cellAttributes() ?>>
    <select
        id="x_contractor"
        name="x_contractor"
        class="form-select ew-select<?= $Page->contractor->isInvalidClass() ?>"
        <?php if (!$Page->contractor->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeeaddopt_x_contractor"
        <?php } ?>
        data-table="production_employee"
        data-field="x_contractor"
        data-value-separator="<?= $Page->contractor->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->contractor->getPlaceHolder()) ?>"
        <?= $Page->contractor->editAttributes() ?>>
        <?= $Page->contractor->selectOptionListHtml("x_contractor") ?>
    </select>
    <?= $Page->contractor->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->contractor->getErrorMessage() ?></div>
<?= $Page->contractor->Lookup->getParamTag($Page, "p_x_contractor") ?>
<?php if (!$Page->contractor->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeeaddopt", function() {
    var options = { name: "x_contractor", selectId: "fproduction_employeeaddopt_x_contractor" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeeaddopt.lists.contractor?.lookupOptions.length) {
        options.data = { id: "x_contractor", form: "fproduction_employeeaddopt" };
    } else {
        options.ajax = { id: "x_contractor", form: "fproduction_employeeaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.contractor.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile"<?= $Page->mobile->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_mobile"><?= $Page->mobile->caption() ?><?= $Page->mobile->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->mobile->cellAttributes() ?>>
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="production_employee" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?> aria-describedby="x_mobile_help">
<?= $Page->mobile->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
    <div id="r_process"<?= $Page->process->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->process->caption() ?><?= $Page->process->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->process->cellAttributes() ?>>
<template id="tp_x_process">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="production_employee" data-field="x_process" name="x_process" id="x_process"<?= $Page->process->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_process" class="ew-item-list"></div>
<selection-list hidden
    id="x_process[]"
    name="x_process[]"
    value="<?= HtmlEncode($Page->process->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_process"
    data-target="dsl_x_process"
    data-repeatcolumn="5"
    class="form-control<?= $Page->process->isInvalidClass() ?>"
    data-table="production_employee"
    data-field="x_process"
    data-value-separator="<?= $Page->process->displayValueSeparatorAttribute() ?>"
    <?= $Page->process->editAttributes() ?>></selection-list>
<?= $Page->process->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->process->getErrorMessage() ?></div>
<?= $Page->process->Lookup->getParamTag($Page, "p_x_process") ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeeaddopt_x_status"
        <?php } ?>
        data-table="production_employee"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeeaddopt", function() {
    var options = { name: "x_status", selectId: "fproduction_employeeaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeeaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduction_employeeaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "fproduction_employeeaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->employee_name->Visible) { // employee_name ?>
    <div id="r_employee_name"<?= $Page->employee_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_employee_name"><?= $Page->employee_name->caption() ?><?= $Page->employee_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->employee_name->cellAttributes() ?>>
<input type="<?= $Page->employee_name->getInputTextType() ?>" name="x_employee_name" id="x_employee_name" data-table="production_employee" data-field="x_employee_name" value="<?= $Page->employee_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->employee_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->employee_name->formatPattern()) ?>"<?= $Page->employee_name->editAttributes() ?> aria-describedby="x_employee_name_help">
<?= $Page->employee_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender"<?= $Page->gender->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_gender"><?= $Page->gender->caption() ?><?= $Page->gender->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->gender->cellAttributes() ?>>
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeeaddopt_x_gender"
        <?php } ?>
        data-table="production_employee"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <?= $Page->gender->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage() ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeeaddopt", function() {
    var options = { name: "x_gender", selectId: "fproduction_employeeaddopt_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeeaddopt.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "fproduction_employeeaddopt" };
    } else {
        options.ajax = { id: "x_gender", form: "fproduction_employeeaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name"<?= $Page->father_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_father_name"><?= $Page->father_name->caption() ?><?= $Page->father_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->father_name->cellAttributes() ?>>
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="production_employee" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?> aria-describedby="x_father_name_help">
<?= $Page->father_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->designation->Visible) { // designation ?>
    <div id="r_designation"<?= $Page->designation->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_designation"><?= $Page->designation->caption() ?><?= $Page->designation->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->designation->cellAttributes() ?>>
<input type="<?= $Page->designation->getInputTextType() ?>" name="x_designation" id="x_designation" data-table="production_employee" data-field="x_designation" value="<?= $Page->designation->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->designation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->designation->formatPattern()) ?>"<?= $Page->designation->editAttributes() ?> aria-describedby="x_designation_help">
<?= $Page->designation->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->designation->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->permanent_address->Visible) { // permanent_address ?>
    <div id="r_permanent_address"<?= $Page->permanent_address->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_permanent_address"><?= $Page->permanent_address->caption() ?><?= $Page->permanent_address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->permanent_address->cellAttributes() ?>>
<textarea data-table="production_employee" data-field="x_permanent_address" name="x_permanent_address" id="x_permanent_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->permanent_address->getPlaceHolder()) ?>"<?= $Page->permanent_address->editAttributes() ?> aria-describedby="x_permanent_address_help"><?= $Page->permanent_address->EditValue ?></textarea>
<?= $Page->permanent_address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->permanent_address->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->city->Visible) { // city ?>
    <div id="r_city"<?= $Page->city->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_city"><?= $Page->city->caption() ?><?= $Page->city->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->city->cellAttributes() ?>>
<input type="<?= $Page->city->getInputTextType() ?>" name="x_city" id="x_city" data-table="production_employee" data-field="x_city" value="<?= $Page->city->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->city->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->city->formatPattern()) ?>"<?= $Page->city->editAttributes() ?> aria-describedby="x_city_help">
<?= $Page->city->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->city->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob"<?= $Page->dob->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_dob"><?= $Page->dob->caption() ?><?= $Page->dob->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->dob->cellAttributes() ?>>
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="production_employee" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?> aria-describedby="x_dob_help">
<?= $Page->dob->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage() ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeeaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeeaddopt", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dom->Visible) { // dom ?>
    <div id="r_dom"<?= $Page->dom->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_dom"><?= $Page->dom->caption() ?><?= $Page->dom->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->dom->cellAttributes() ?>>
<input type="<?= $Page->dom->getInputTextType() ?>" name="x_dom" id="x_dom" data-table="production_employee" data-field="x_dom" value="<?= $Page->dom->EditValue ?>" placeholder="<?= HtmlEncode($Page->dom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dom->formatPattern()) ?>"<?= $Page->dom->editAttributes() ?> aria-describedby="x_dom_help">
<?= $Page->dom->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dom->getErrorMessage() ?></div>
<?php if (!$Page->dom->ReadOnly && !$Page->dom->Disabled && !isset($Page->dom->EditAttrs["readonly"]) && !isset($Page->dom->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeeaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeeaddopt", "x_dom", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <div id="r_mobile_other"<?= $Page->mobile_other->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_mobile_other"><?= $Page->mobile_other->caption() ?><?= $Page->mobile_other->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->mobile_other->cellAttributes() ?>>
<input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="production_employee" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="60" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?> aria-describedby="x_mobile_other_help">
<?= $Page->mobile_other->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->mobile_family->Visible) { // mobile_family ?>
    <div id="r_mobile_family"<?= $Page->mobile_family->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_mobile_family"><?= $Page->mobile_family->caption() ?><?= $Page->mobile_family->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->mobile_family->cellAttributes() ?>>
<input type="<?= $Page->mobile_family->getInputTextType() ?>" name="x_mobile_family" id="x_mobile_family" data-table="production_employee" data-field="x_mobile_family" value="<?= $Page->mobile_family->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->mobile_family->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_family->formatPattern()) ?>"<?= $Page->mobile_family->editAttributes() ?> aria-describedby="x_mobile_family_help">
<?= $Page->mobile_family->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->mobile_family->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->marital_status->Visible) { // marital_status ?>
    <div id="r_marital_status"<?= $Page->marital_status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_marital_status"><?= $Page->marital_status->caption() ?><?= $Page->marital_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->marital_status->cellAttributes() ?>>
    <select
        id="x_marital_status"
        name="x_marital_status"
        class="form-select ew-select<?= $Page->marital_status->isInvalidClass() ?>"
        <?php if (!$Page->marital_status->IsNativeSelect) { ?>
        data-select2-id="fproduction_employeeaddopt_x_marital_status"
        <?php } ?>
        data-table="production_employee"
        data-field="x_marital_status"
        data-value-separator="<?= $Page->marital_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->marital_status->getPlaceHolder()) ?>"
        <?= $Page->marital_status->editAttributes() ?>>
        <?= $Page->marital_status->selectOptionListHtml("x_marital_status") ?>
    </select>
    <?= $Page->marital_status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->marital_status->getErrorMessage() ?></div>
<?php if (!$Page->marital_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduction_employeeaddopt", function() {
    var options = { name: "x_marital_status", selectId: "fproduction_employeeaddopt_x_marital_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduction_employeeaddopt.lists.marital_status?.lookupOptions.length) {
        options.data = { id: "x_marital_status", form: "fproduction_employeeaddopt" };
    } else {
        options.ajax = { id: "x_marital_status", form: "fproduction_employeeaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.production_employee.fields.marital_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->spouse_details->Visible) { // spouse_details ?>
    <div id="r_spouse_details"<?= $Page->spouse_details->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_spouse_details"><?= $Page->spouse_details->caption() ?><?= $Page->spouse_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->spouse_details->cellAttributes() ?>>
<input type="<?= $Page->spouse_details->getInputTextType() ?>" name="x_spouse_details" id="x_spouse_details" data-table="production_employee" data-field="x_spouse_details" value="<?= $Page->spouse_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->spouse_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->spouse_details->formatPattern()) ?>"<?= $Page->spouse_details->editAttributes() ?> aria-describedby="x_spouse_details_help">
<?= $Page->spouse_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->spouse_details->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->emergency_details->Visible) { // emergency_details ?>
    <div id="r_emergency_details"<?= $Page->emergency_details->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_emergency_details"><?= $Page->emergency_details->caption() ?><?= $Page->emergency_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->emergency_details->cellAttributes() ?>>
<input type="<?= $Page->emergency_details->getInputTextType() ?>" name="x_emergency_details" id="x_emergency_details" data-table="production_employee" data-field="x_emergency_details" value="<?= $Page->emergency_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->emergency_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->emergency_details->formatPattern()) ?>"<?= $Page->emergency_details->editAttributes() ?> aria-describedby="x_emergency_details_help">
<?= $Page->emergency_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->emergency_details->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->pan_no->Visible) { // pan_no ?>
    <div id="r_pan_no"<?= $Page->pan_no->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_pan_no"><?= $Page->pan_no->caption() ?><?= $Page->pan_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->pan_no->cellAttributes() ?>>
<input type="<?= $Page->pan_no->getInputTextType() ?>" name="x_pan_no" id="x_pan_no" data-table="production_employee" data-field="x_pan_no" value="<?= $Page->pan_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan_no->formatPattern()) ?>"<?= $Page->pan_no->editAttributes() ?> aria-describedby="x_pan_no_help">
<?= $Page->pan_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->pan_no->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar_no->Visible) { // aadhaar_no ?>
    <div id="r_aadhaar_no"<?= $Page->aadhaar_no->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_aadhaar_no"><?= $Page->aadhaar_no->caption() ?><?= $Page->aadhaar_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->aadhaar_no->cellAttributes() ?>>
<input type="<?= $Page->aadhaar_no->getInputTextType() ?>" name="x_aadhaar_no" id="x_aadhaar_no" data-table="production_employee" data-field="x_aadhaar_no" value="<?= $Page->aadhaar_no->EditValue ?>" size="30" maxlength="14" placeholder="<?= HtmlEncode($Page->aadhaar_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar_no->formatPattern()) ?>"<?= $Page->aadhaar_no->editAttributes() ?> aria-describedby="x_aadhaar_no_help">
<?= $Page->aadhaar_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->aadhaar_no->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->id_proof->Visible) { // id_proof ?>
    <div id="r_id_proof"<?= $Page->id_proof->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->id_proof->caption() ?><?= $Page->id_proof->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->id_proof->cellAttributes() ?>>
<div id="fd_x_id_proof" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_id_proof"
        name="x_id_proof"
        class="form-control ew-file-input"
        title="<?= $Page->id_proof->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="production_employee"
        data-field="x_id_proof"
        data-size="255"
        data-accept-file-types="<?= $Page->id_proof->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->id_proof->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->id_proof->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->id_proof->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_id_proof_help"
        <?= ($Page->id_proof->ReadOnly || $Page->id_proof->Disabled) ? " disabled" : "" ?>
        <?= $Page->id_proof->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->id_proof->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->id_proof->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_id_proof" id= "fn_x_id_proof" value="<?= $Page->id_proof->Upload->FileName ?>">
<input type="hidden" name="fa_x_id_proof" id= "fa_x_id_proof" value="0">
<table id="ft_x_id_proof" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->reference_details->Visible) { // reference_details ?>
    <div id="r_reference_details"<?= $Page->reference_details->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_reference_details"><?= $Page->reference_details->caption() ?><?= $Page->reference_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->reference_details->cellAttributes() ?>>
<input type="<?= $Page->reference_details->getInputTextType() ?>" name="x_reference_details" id="x_reference_details" data-table="production_employee" data-field="x_reference_details" value="<?= $Page->reference_details->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->reference_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->reference_details->formatPattern()) ?>"<?= $Page->reference_details->editAttributes() ?> aria-describedby="x_reference_details_help">
<?= $Page->reference_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->reference_details->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->other_details->Visible) { // other_details ?>
    <div id="r_other_details"<?= $Page->other_details->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_other_details"><?= $Page->other_details->caption() ?><?= $Page->other_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->other_details->cellAttributes() ?>>
<textarea data-table="production_employee" data-field="x_other_details" name="x_other_details" id="x_other_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->other_details->getPlaceHolder()) ?>"<?= $Page->other_details->editAttributes() ?> aria-describedby="x_other_details_help"><?= $Page->other_details->EditValue ?></textarea>
<?= $Page->other_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->other_details->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->doj->Visible) { // doj ?>
    <div id="r_doj"<?= $Page->doj->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_doj"><?= $Page->doj->caption() ?><?= $Page->doj->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->doj->cellAttributes() ?>>
<input type="<?= $Page->doj->getInputTextType() ?>" name="x_doj" id="x_doj" data-table="production_employee" data-field="x_doj" value="<?= $Page->doj->EditValue ?>" placeholder="<?= HtmlEncode($Page->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doj->formatPattern()) ?>"<?= $Page->doj->editAttributes() ?> aria-describedby="x_doj_help">
<?= $Page->doj->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->doj->getErrorMessage() ?></div>
<?php if (!$Page->doj->ReadOnly && !$Page->doj->Disabled && !isset($Page->doj->EditAttrs["readonly"]) && !isset($Page->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeeaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeeaddopt", "x_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->doc->Visible) { // doc ?>
    <div id="r_doc"<?= $Page->doc->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_doc"><?= $Page->doc->caption() ?><?= $Page->doc->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->doc->cellAttributes() ?>>
<input type="<?= $Page->doc->getInputTextType() ?>" name="x_doc" id="x_doc" data-table="production_employee" data-field="x_doc" value="<?= $Page->doc->EditValue ?>" placeholder="<?= HtmlEncode($Page->doc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doc->formatPattern()) ?>"<?= $Page->doc->editAttributes() ?> aria-describedby="x_doc_help">
<?= $Page->doc->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->doc->getErrorMessage() ?></div>
<?php if (!$Page->doc->ReadOnly && !$Page->doc->Disabled && !isset($Page->doc->EditAttrs["readonly"]) && !isset($Page->doc->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeeaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeeaddopt", "x_doc", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dol->Visible) { // dol ?>
    <div id="r_dol"<?= $Page->dol->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_dol"><?= $Page->dol->caption() ?><?= $Page->dol->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->dol->cellAttributes() ?>>
<input type="<?= $Page->dol->getInputTextType() ?>" name="x_dol" id="x_dol" data-table="production_employee" data-field="x_dol" value="<?= $Page->dol->EditValue ?>" placeholder="<?= HtmlEncode($Page->dol->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dol->formatPattern()) ?>"<?= $Page->dol->editAttributes() ?> aria-describedby="x_dol_help">
<?= $Page->dol->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dol->getErrorMessage() ?></div>
<?php if (!$Page->dol->ReadOnly && !$Page->dol->Disabled && !isset($Page->dol->EditAttrs["readonly"]) && !isset($Page->dol->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeeaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeeaddopt", "x_dol", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image"<?= $Page->image->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label"><?= $Page->image->caption() ?><?= $Page->image->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->image->cellAttributes() ?>>
<div id="fd_x_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_image"
        name="x_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="production_employee"
        data-field="x_image"
        data-size="48"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_image_help"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->image->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_image" id= "fn_x_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x_image" id= "fa_x_image" value="0">
<table id="ft_x_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->payment_details->Visible) { // payment_details ?>
    <div id="r_payment_details"<?= $Page->payment_details->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_payment_details"><?= $Page->payment_details->caption() ?><?= $Page->payment_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->payment_details->cellAttributes() ?>>
<textarea data-table="production_employee" data-field="x_payment_details" name="x_payment_details" id="x_payment_details" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->payment_details->getPlaceHolder()) ?>"<?= $Page->payment_details->editAttributes() ?> aria-describedby="x_payment_details_help"><?= $Page->payment_details->EditValue ?></textarea>
<?= $Page->payment_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->payment_details->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_name->Visible) { // bank_name ?>
    <div id="r_bank_name"<?= $Page->bank_name->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_bank_name"><?= $Page->bank_name->caption() ?><?= $Page->bank_name->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->bank_name->cellAttributes() ?>>
<input type="<?= $Page->bank_name->getInputTextType() ?>" name="x_bank_name" id="x_bank_name" data-table="production_employee" data-field="x_bank_name" value="<?= $Page->bank_name->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->bank_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_name->formatPattern()) ?>"<?= $Page->bank_name->editAttributes() ?> aria-describedby="x_bank_name_help">
<?= $Page->bank_name->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_name->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_ifsc_code->Visible) { // bank_ifsc_code ?>
    <div id="r_bank_ifsc_code"<?= $Page->bank_ifsc_code->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_bank_ifsc_code"><?= $Page->bank_ifsc_code->caption() ?><?= $Page->bank_ifsc_code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->bank_ifsc_code->cellAttributes() ?>>
<input type="<?= $Page->bank_ifsc_code->getInputTextType() ?>" name="x_bank_ifsc_code" id="x_bank_ifsc_code" data-table="production_employee" data-field="x_bank_ifsc_code" value="<?= $Page->bank_ifsc_code->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_ifsc_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_ifsc_code->formatPattern()) ?>"<?= $Page->bank_ifsc_code->editAttributes() ?> aria-describedby="x_bank_ifsc_code_help">
<?= $Page->bank_ifsc_code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_ifsc_code->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->bank_account_no->Visible) { // bank_account_no ?>
    <div id="r_bank_account_no"<?= $Page->bank_account_no->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_bank_account_no"><?= $Page->bank_account_no->caption() ?><?= $Page->bank_account_no->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->bank_account_no->cellAttributes() ?>>
<input type="<?= $Page->bank_account_no->getInputTextType() ?>" name="x_bank_account_no" id="x_bank_account_no" data-table="production_employee" data-field="x_bank_account_no" value="<?= $Page->bank_account_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->bank_account_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bank_account_no->formatPattern()) ?>"<?= $Page->bank_account_no->editAttributes() ?> aria-describedby="x_bank_account_no_help">
<?= $Page->bank_account_no->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->bank_account_no->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_operator"><?= $Page->operator->caption() ?><?= $Page->operator->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->operator->cellAttributes() ?>>
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="production_employee" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?> aria-describedby="x_operator_help">
<?= $Page->operator->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_datetime"><?= $Page->datetime->caption() ?><?= $Page->datetime->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->datetime->cellAttributes() ?>>
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="production_employee" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?> aria-describedby="x_datetime_help">
<?= $Page->datetime->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage() ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduction_employeeaddopt", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduction_employeeaddopt", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->d_operator->Visible) { // d_operator ?>
    <input type="hidden" data-table="production_employee" data-field="x_d_operator" data-hidden="1" name="x_d_operator" id="x_d_operator" value="<?= HtmlEncode($Page->d_operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->d_datetime->Visible) { // d_datetime ?>
    <input type="hidden" data-table="production_employee" data-field="x_d_datetime" data-hidden="1" name="x_d_datetime" id="x_d_datetime" value="<?= HtmlEncode($Page->d_datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->am_id->Visible) { // am_id ?>
    <div id="r_am_id"<?= $Page->am_id->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_am_id"><?= $Page->am_id->caption() ?><?= $Page->am_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->am_id->cellAttributes() ?>>
<input type="<?= $Page->am_id->getInputTextType() ?>" name="x_am_id" id="x_am_id" data-table="production_employee" data-field="x_am_id" value="<?= $Page->am_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->am_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->am_id->formatPattern()) ?>"<?= $Page->am_id->editAttributes() ?> aria-describedby="x_am_id_help">
<?= $Page->am_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->am_id->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("production_employee");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var status = $("#x_status").val();
    		if (status == 1)
    		{
    			$("#x_dol").val('');
    			$("#r_dol").hide();
    		}
    		else
    		{
    			$("#r_dol").show();
    		}
});
</script>
