<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductGroupList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_group: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fproduct_groupsrch" id="fproduct_groupsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fproduct_groupsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_group: currentTable } });
var currentForm;
var fproduct_groupsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_groupsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["product_group", [], fields.product_group.isInvalid],
            ["status", [], fields.status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_grp" class="ew-search-caption ew-label"><?= $Page->grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</div>
        </div>
        <div id="el_product_group_grp" class="ew-search-field">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_groupsrch_x_grp"
        <?php } ?>
        data-table="product_group"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_groupsrch", function() {
    var options = { name: "x_grp", selectId: "fproduct_groupsrch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_groupsrch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_groupsrch" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_groupsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_group.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_group->Visible) { // product_group ?>
<?php
if (!$Page->product_group->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_group" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_group->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product_group" class="ew-search-caption ew-label"><?= $Page->product_group->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_group" id="z_product_group" value="LIKE">
</div>
        </div>
        <div id="el_product_group_product_group" class="ew-search-field">
<input type="<?= $Page->product_group->getInputTextType() ?>" name="x_product_group" id="x_product_group" data-table="product_group" data-field="x_product_group" value="<?= $Page->product_group->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product_group->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_group->formatPattern()) ?>"<?= $Page->product_group->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_group->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_status" class="ew-search-caption ew-label"><?= $Page->status->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</div>
        </div>
        <div id="el_product_group_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduct_groupsrch_x_status"
        <?php } ?>
        data-table="product_group"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_groupsrch", function() {
    var options = { name: "x_status", selectId: "fproduct_groupsrch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_groupsrch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduct_groupsrch" };
    } else {
        options.ajax = { id: "x_status", form: "fproduct_groupsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_group.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fproduct_groupsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fproduct_groupsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fproduct_groupsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fproduct_groupsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fproduct_groupsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fproduct_groupsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fproduct_groupsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_group">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_product_group" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_product_grouplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_product_group_id" class="product_group_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_product_group_grp" class="product_group_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->product_group->Visible) { // product_group ?>
        <th data-name="product_group" class="<?= $Page->product_group->headerCellClass() ?>"><div id="elh_product_group_product_group" class="product_group_product_group"><?= $Page->renderFieldHeader($Page->product_group) ?></div></th>
<?php } ?>
<?php if ($Page->calculation_method->Visible) { // calculation_method ?>
        <th data-name="calculation_method" class="<?= $Page->calculation_method->headerCellClass() ?>"><div id="elh_product_group_calculation_method" class="product_group_calculation_method"><?= $Page->renderFieldHeader($Page->calculation_method) ?></div></th>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Page->shape->headerCellClass() ?>"><div id="elh_product_group_shape" class="product_group_shape"><?= $Page->renderFieldHeader($Page->shape) ?></div></th>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
        <th data-name="sqm" class="<?= $Page->sqm->headerCellClass() ?>"><div id="elh_product_group_sqm" class="product_group_sqm"><?= $Page->renderFieldHeader($Page->sqm) ?></div></th>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
        <th data-name="cbm" class="<?= $Page->cbm->headerCellClass() ?>"><div id="elh_product_group_cbm" class="product_group_cbm"><?= $Page->renderFieldHeader($Page->cbm) ?></div></th>
<?php } ?>
<?php if ($Page->process->Visible) { // process ?>
        <th data-name="process" class="<?= $Page->process->headerCellClass() ?>"><div id="elh_product_group_process" class="product_group_process"><?= $Page->renderFieldHeader($Page->process) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_product_group_status" class="product_group_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->v_00->Visible) { // v_00 ?>
        <th data-name="v_00" class="<?= $Page->v_00->headerCellClass() ?>"><div id="elh_product_group_v_00" class="product_group_v_00"><?= $Page->renderFieldHeader($Page->v_00) ?></div></th>
<?php } ?>
<?php if ($Page->v_01->Visible) { // v_01 ?>
        <th data-name="v_01" class="<?= $Page->v_01->headerCellClass() ?>"><div id="elh_product_group_v_01" class="product_group_v_01"><?= $Page->renderFieldHeader($Page->v_01) ?></div></th>
<?php } ?>
<?php if ($Page->v_01_validation->Visible) { // v_01_validation ?>
        <th data-name="v_01_validation" class="<?= $Page->v_01_validation->headerCellClass() ?>"><div id="elh_product_group_v_01_validation" class="product_group_v_01_validation"><?= $Page->renderFieldHeader($Page->v_01_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_02->Visible) { // v_02 ?>
        <th data-name="v_02" class="<?= $Page->v_02->headerCellClass() ?>"><div id="elh_product_group_v_02" class="product_group_v_02"><?= $Page->renderFieldHeader($Page->v_02) ?></div></th>
<?php } ?>
<?php if ($Page->v_02_validation->Visible) { // v_02_validation ?>
        <th data-name="v_02_validation" class="<?= $Page->v_02_validation->headerCellClass() ?>"><div id="elh_product_group_v_02_validation" class="product_group_v_02_validation"><?= $Page->renderFieldHeader($Page->v_02_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_03->Visible) { // v_03 ?>
        <th data-name="v_03" class="<?= $Page->v_03->headerCellClass() ?>"><div id="elh_product_group_v_03" class="product_group_v_03"><?= $Page->renderFieldHeader($Page->v_03) ?></div></th>
<?php } ?>
<?php if ($Page->v_03_validation->Visible) { // v_03_validation ?>
        <th data-name="v_03_validation" class="<?= $Page->v_03_validation->headerCellClass() ?>"><div id="elh_product_group_v_03_validation" class="product_group_v_03_validation"><?= $Page->renderFieldHeader($Page->v_03_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_04->Visible) { // v_04 ?>
        <th data-name="v_04" class="<?= $Page->v_04->headerCellClass() ?>"><div id="elh_product_group_v_04" class="product_group_v_04"><?= $Page->renderFieldHeader($Page->v_04) ?></div></th>
<?php } ?>
<?php if ($Page->v_04_validation->Visible) { // v_04_validation ?>
        <th data-name="v_04_validation" class="<?= $Page->v_04_validation->headerCellClass() ?>"><div id="elh_product_group_v_04_validation" class="product_group_v_04_validation"><?= $Page->renderFieldHeader($Page->v_04_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_05->Visible) { // v_05 ?>
        <th data-name="v_05" class="<?= $Page->v_05->headerCellClass() ?>"><div id="elh_product_group_v_05" class="product_group_v_05"><?= $Page->renderFieldHeader($Page->v_05) ?></div></th>
<?php } ?>
<?php if ($Page->v_05_validation->Visible) { // v_05_validation ?>
        <th data-name="v_05_validation" class="<?= $Page->v_05_validation->headerCellClass() ?>"><div id="elh_product_group_v_05_validation" class="product_group_v_05_validation"><?= $Page->renderFieldHeader($Page->v_05_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_06->Visible) { // v_06 ?>
        <th data-name="v_06" class="<?= $Page->v_06->headerCellClass() ?>"><div id="elh_product_group_v_06" class="product_group_v_06"><?= $Page->renderFieldHeader($Page->v_06) ?></div></th>
<?php } ?>
<?php if ($Page->v_06_validation->Visible) { // v_06_validation ?>
        <th data-name="v_06_validation" class="<?= $Page->v_06_validation->headerCellClass() ?>"><div id="elh_product_group_v_06_validation" class="product_group_v_06_validation"><?= $Page->renderFieldHeader($Page->v_06_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_07->Visible) { // v_07 ?>
        <th data-name="v_07" class="<?= $Page->v_07->headerCellClass() ?>"><div id="elh_product_group_v_07" class="product_group_v_07"><?= $Page->renderFieldHeader($Page->v_07) ?></div></th>
<?php } ?>
<?php if ($Page->v_07_validation->Visible) { // v_07_validation ?>
        <th data-name="v_07_validation" class="<?= $Page->v_07_validation->headerCellClass() ?>"><div id="elh_product_group_v_07_validation" class="product_group_v_07_validation"><?= $Page->renderFieldHeader($Page->v_07_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_08->Visible) { // v_08 ?>
        <th data-name="v_08" class="<?= $Page->v_08->headerCellClass() ?>"><div id="elh_product_group_v_08" class="product_group_v_08"><?= $Page->renderFieldHeader($Page->v_08) ?></div></th>
<?php } ?>
<?php if ($Page->v_08_validation->Visible) { // v_08_validation ?>
        <th data-name="v_08_validation" class="<?= $Page->v_08_validation->headerCellClass() ?>"><div id="elh_product_group_v_08_validation" class="product_group_v_08_validation"><?= $Page->renderFieldHeader($Page->v_08_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_09->Visible) { // v_09 ?>
        <th data-name="v_09" class="<?= $Page->v_09->headerCellClass() ?>"><div id="elh_product_group_v_09" class="product_group_v_09"><?= $Page->renderFieldHeader($Page->v_09) ?></div></th>
<?php } ?>
<?php if ($Page->v_09_validation->Visible) { // v_09_validation ?>
        <th data-name="v_09_validation" class="<?= $Page->v_09_validation->headerCellClass() ?>"><div id="elh_product_group_v_09_validation" class="product_group_v_09_validation"><?= $Page->renderFieldHeader($Page->v_09_validation) ?></div></th>
<?php } ?>
<?php if ($Page->v_10->Visible) { // v_10 ?>
        <th data-name="v_10" class="<?= $Page->v_10->headerCellClass() ?>"><div id="elh_product_group_v_10" class="product_group_v_10"><?= $Page->renderFieldHeader($Page->v_10) ?></div></th>
<?php } ?>
<?php if ($Page->v_10_validation->Visible) { // v_10_validation ?>
        <th data-name="v_10_validation" class="<?= $Page->v_10_validation->headerCellClass() ?>"><div id="elh_product_group_v_10_validation" class="product_group_v_10_validation"><?= $Page->renderFieldHeader($Page->v_10_validation) ?></div></th>
<?php } ?>
<?php if ($Page->b_01_head->Visible) { // b_01_head ?>
        <th data-name="b_01_head" class="<?= $Page->b_01_head->headerCellClass() ?>"><div id="elh_product_group_b_01_head" class="product_group_b_01_head"><?= $Page->renderFieldHeader($Page->b_01_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_02_head->Visible) { // b_02_head ?>
        <th data-name="b_02_head" class="<?= $Page->b_02_head->headerCellClass() ?>"><div id="elh_product_group_b_02_head" class="product_group_b_02_head"><?= $Page->renderFieldHeader($Page->b_02_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_03_head->Visible) { // b_03_head ?>
        <th data-name="b_03_head" class="<?= $Page->b_03_head->headerCellClass() ?>"><div id="elh_product_group_b_03_head" class="product_group_b_03_head"><?= $Page->renderFieldHeader($Page->b_03_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_04_head->Visible) { // b_04_head ?>
        <th data-name="b_04_head" class="<?= $Page->b_04_head->headerCellClass() ?>"><div id="elh_product_group_b_04_head" class="product_group_b_04_head"><?= $Page->renderFieldHeader($Page->b_04_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_05_head->Visible) { // b_05_head ?>
        <th data-name="b_05_head" class="<?= $Page->b_05_head->headerCellClass() ?>"><div id="elh_product_group_b_05_head" class="product_group_b_05_head"><?= $Page->renderFieldHeader($Page->b_05_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_06_head->Visible) { // b_06_head ?>
        <th data-name="b_06_head" class="<?= $Page->b_06_head->headerCellClass() ?>"><div id="elh_product_group_b_06_head" class="product_group_b_06_head"><?= $Page->renderFieldHeader($Page->b_06_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_07_head->Visible) { // b_07_head ?>
        <th data-name="b_07_head" class="<?= $Page->b_07_head->headerCellClass() ?>"><div id="elh_product_group_b_07_head" class="product_group_b_07_head"><?= $Page->renderFieldHeader($Page->b_07_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_08_head->Visible) { // b_08_head ?>
        <th data-name="b_08_head" class="<?= $Page->b_08_head->headerCellClass() ?>"><div id="elh_product_group_b_08_head" class="product_group_b_08_head"><?= $Page->renderFieldHeader($Page->b_08_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_09_head->Visible) { // b_09_head ?>
        <th data-name="b_09_head" class="<?= $Page->b_09_head->headerCellClass() ?>"><div id="elh_product_group_b_09_head" class="product_group_b_09_head"><?= $Page->renderFieldHeader($Page->b_09_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_10_head->Visible) { // b_10_head ?>
        <th data-name="b_10_head" class="<?= $Page->b_10_head->headerCellClass() ?>"><div id="elh_product_group_b_10_head" class="product_group_b_10_head"><?= $Page->renderFieldHeader($Page->b_10_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_11_head->Visible) { // b_11_head ?>
        <th data-name="b_11_head" class="<?= $Page->b_11_head->headerCellClass() ?>"><div id="elh_product_group_b_11_head" class="product_group_b_11_head"><?= $Page->renderFieldHeader($Page->b_11_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_12_head->Visible) { // b_12_head ?>
        <th data-name="b_12_head" class="<?= $Page->b_12_head->headerCellClass() ?>"><div id="elh_product_group_b_12_head" class="product_group_b_12_head"><?= $Page->renderFieldHeader($Page->b_12_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_13_head->Visible) { // b_13_head ?>
        <th data-name="b_13_head" class="<?= $Page->b_13_head->headerCellClass() ?>"><div id="elh_product_group_b_13_head" class="product_group_b_13_head"><?= $Page->renderFieldHeader($Page->b_13_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_14_head->Visible) { // b_14_head ?>
        <th data-name="b_14_head" class="<?= $Page->b_14_head->headerCellClass() ?>"><div id="elh_product_group_b_14_head" class="product_group_b_14_head"><?= $Page->renderFieldHeader($Page->b_14_head) ?></div></th>
<?php } ?>
<?php if ($Page->b_15_head->Visible) { // b_15_head ?>
        <th data-name="b_15_head" class="<?= $Page->b_15_head->headerCellClass() ?>"><div id="elh_product_group_b_15_head" class="product_group_b_15_head"><?= $Page->renderFieldHeader($Page->b_15_head) ?></div></th>
<?php } ?>
<?php if ($Page->q_sku->Visible) { // q_sku ?>
        <th data-name="q_sku" class="<?= $Page->q_sku->headerCellClass() ?>"><div id="elh_product_group_q_sku" class="product_group_q_sku"><?= $Page->renderFieldHeader($Page->q_sku) ?></div></th>
<?php } ?>
<?php if ($Page->t_01_head->Visible) { // t_01_head ?>
        <th data-name="t_01_head" class="<?= $Page->t_01_head->headerCellClass() ?>"><div id="elh_product_group_t_01_head" class="product_group_t_01_head"><?= $Page->renderFieldHeader($Page->t_01_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_02_head->Visible) { // t_02_head ?>
        <th data-name="t_02_head" class="<?= $Page->t_02_head->headerCellClass() ?>"><div id="elh_product_group_t_02_head" class="product_group_t_02_head"><?= $Page->renderFieldHeader($Page->t_02_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_03_head->Visible) { // t_03_head ?>
        <th data-name="t_03_head" class="<?= $Page->t_03_head->headerCellClass() ?>"><div id="elh_product_group_t_03_head" class="product_group_t_03_head"><?= $Page->renderFieldHeader($Page->t_03_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_04_head->Visible) { // t_04_head ?>
        <th data-name="t_04_head" class="<?= $Page->t_04_head->headerCellClass() ?>"><div id="elh_product_group_t_04_head" class="product_group_t_04_head"><?= $Page->renderFieldHeader($Page->t_04_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_05_head->Visible) { // t_05_head ?>
        <th data-name="t_05_head" class="<?= $Page->t_05_head->headerCellClass() ?>"><div id="elh_product_group_t_05_head" class="product_group_t_05_head"><?= $Page->renderFieldHeader($Page->t_05_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_06_head->Visible) { // t_06_head ?>
        <th data-name="t_06_head" class="<?= $Page->t_06_head->headerCellClass() ?>"><div id="elh_product_group_t_06_head" class="product_group_t_06_head"><?= $Page->renderFieldHeader($Page->t_06_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_07_head->Visible) { // t_07_head ?>
        <th data-name="t_07_head" class="<?= $Page->t_07_head->headerCellClass() ?>"><div id="elh_product_group_t_07_head" class="product_group_t_07_head"><?= $Page->renderFieldHeader($Page->t_07_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_08_head->Visible) { // t_08_head ?>
        <th data-name="t_08_head" class="<?= $Page->t_08_head->headerCellClass() ?>"><div id="elh_product_group_t_08_head" class="product_group_t_08_head"><?= $Page->renderFieldHeader($Page->t_08_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_09_head->Visible) { // t_09_head ?>
        <th data-name="t_09_head" class="<?= $Page->t_09_head->headerCellClass() ?>"><div id="elh_product_group_t_09_head" class="product_group_t_09_head"><?= $Page->renderFieldHeader($Page->t_09_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_10_head->Visible) { // t_10_head ?>
        <th data-name="t_10_head" class="<?= $Page->t_10_head->headerCellClass() ?>"><div id="elh_product_group_t_10_head" class="product_group_t_10_head"><?= $Page->renderFieldHeader($Page->t_10_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_11_head->Visible) { // t_11_head ?>
        <th data-name="t_11_head" class="<?= $Page->t_11_head->headerCellClass() ?>"><div id="elh_product_group_t_11_head" class="product_group_t_11_head"><?= $Page->renderFieldHeader($Page->t_11_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_12_head->Visible) { // t_12_head ?>
        <th data-name="t_12_head" class="<?= $Page->t_12_head->headerCellClass() ?>"><div id="elh_product_group_t_12_head" class="product_group_t_12_head"><?= $Page->renderFieldHeader($Page->t_12_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_13_head->Visible) { // t_13_head ?>
        <th data-name="t_13_head" class="<?= $Page->t_13_head->headerCellClass() ?>"><div id="elh_product_group_t_13_head" class="product_group_t_13_head"><?= $Page->renderFieldHeader($Page->t_13_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_14_head->Visible) { // t_14_head ?>
        <th data-name="t_14_head" class="<?= $Page->t_14_head->headerCellClass() ?>"><div id="elh_product_group_t_14_head" class="product_group_t_14_head"><?= $Page->renderFieldHeader($Page->t_14_head) ?></div></th>
<?php } ?>
<?php if ($Page->t_15_head->Visible) { // t_15_head ?>
        <th data-name="t_15_head" class="<?= $Page->t_15_head->headerCellClass() ?>"><div id="elh_product_group_t_15_head" class="product_group_t_15_head"><?= $Page->renderFieldHeader($Page->t_15_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_01_head->Visible) { // po_01_head ?>
        <th data-name="po_01_head" class="<?= $Page->po_01_head->headerCellClass() ?>"><div id="elh_product_group_po_01_head" class="product_group_po_01_head"><?= $Page->renderFieldHeader($Page->po_01_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_02_head->Visible) { // po_02_head ?>
        <th data-name="po_02_head" class="<?= $Page->po_02_head->headerCellClass() ?>"><div id="elh_product_group_po_02_head" class="product_group_po_02_head"><?= $Page->renderFieldHeader($Page->po_02_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_03_head->Visible) { // po_03_head ?>
        <th data-name="po_03_head" class="<?= $Page->po_03_head->headerCellClass() ?>"><div id="elh_product_group_po_03_head" class="product_group_po_03_head"><?= $Page->renderFieldHeader($Page->po_03_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_04_head->Visible) { // po_04_head ?>
        <th data-name="po_04_head" class="<?= $Page->po_04_head->headerCellClass() ?>"><div id="elh_product_group_po_04_head" class="product_group_po_04_head"><?= $Page->renderFieldHeader($Page->po_04_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_05_head->Visible) { // po_05_head ?>
        <th data-name="po_05_head" class="<?= $Page->po_05_head->headerCellClass() ?>"><div id="elh_product_group_po_05_head" class="product_group_po_05_head"><?= $Page->renderFieldHeader($Page->po_05_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_06_head->Visible) { // po_06_head ?>
        <th data-name="po_06_head" class="<?= $Page->po_06_head->headerCellClass() ?>"><div id="elh_product_group_po_06_head" class="product_group_po_06_head"><?= $Page->renderFieldHeader($Page->po_06_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_07_head->Visible) { // po_07_head ?>
        <th data-name="po_07_head" class="<?= $Page->po_07_head->headerCellClass() ?>"><div id="elh_product_group_po_07_head" class="product_group_po_07_head"><?= $Page->renderFieldHeader($Page->po_07_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_08_head->Visible) { // po_08_head ?>
        <th data-name="po_08_head" class="<?= $Page->po_08_head->headerCellClass() ?>"><div id="elh_product_group_po_08_head" class="product_group_po_08_head"><?= $Page->renderFieldHeader($Page->po_08_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_17_head->Visible) { // po_17_head ?>
        <th data-name="po_17_head" class="<?= $Page->po_17_head->headerCellClass() ?>"><div id="elh_product_group_po_17_head" class="product_group_po_17_head"><?= $Page->renderFieldHeader($Page->po_17_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_18_head->Visible) { // po_18_head ?>
        <th data-name="po_18_head" class="<?= $Page->po_18_head->headerCellClass() ?>"><div id="elh_product_group_po_18_head" class="product_group_po_18_head"><?= $Page->renderFieldHeader($Page->po_18_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_19_head->Visible) { // po_19_head ?>
        <th data-name="po_19_head" class="<?= $Page->po_19_head->headerCellClass() ?>"><div id="elh_product_group_po_19_head" class="product_group_po_19_head"><?= $Page->renderFieldHeader($Page->po_19_head) ?></div></th>
<?php } ?>
<?php if ($Page->po_20_head->Visible) { // po_20_head ?>
        <th data-name="po_20_head" class="<?= $Page->po_20_head->headerCellClass() ?>"><div id="elh_product_group_po_20_head" class="product_group_po_20_head"><?= $Page->renderFieldHeader($Page->po_20_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_01_head->Visible) { // jc_01_head ?>
        <th data-name="jc_01_head" class="<?= $Page->jc_01_head->headerCellClass() ?>"><div id="elh_product_group_jc_01_head" class="product_group_jc_01_head"><?= $Page->renderFieldHeader($Page->jc_01_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_02_head->Visible) { // jc_02_head ?>
        <th data-name="jc_02_head" class="<?= $Page->jc_02_head->headerCellClass() ?>"><div id="elh_product_group_jc_02_head" class="product_group_jc_02_head"><?= $Page->renderFieldHeader($Page->jc_02_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_03_head->Visible) { // jc_03_head ?>
        <th data-name="jc_03_head" class="<?= $Page->jc_03_head->headerCellClass() ?>"><div id="elh_product_group_jc_03_head" class="product_group_jc_03_head"><?= $Page->renderFieldHeader($Page->jc_03_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_04_head->Visible) { // jc_04_head ?>
        <th data-name="jc_04_head" class="<?= $Page->jc_04_head->headerCellClass() ?>"><div id="elh_product_group_jc_04_head" class="product_group_jc_04_head"><?= $Page->renderFieldHeader($Page->jc_04_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_05_head->Visible) { // jc_05_head ?>
        <th data-name="jc_05_head" class="<?= $Page->jc_05_head->headerCellClass() ?>"><div id="elh_product_group_jc_05_head" class="product_group_jc_05_head"><?= $Page->renderFieldHeader($Page->jc_05_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_06_head->Visible) { // jc_06_head ?>
        <th data-name="jc_06_head" class="<?= $Page->jc_06_head->headerCellClass() ?>"><div id="elh_product_group_jc_06_head" class="product_group_jc_06_head"><?= $Page->renderFieldHeader($Page->jc_06_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_07_head->Visible) { // jc_07_head ?>
        <th data-name="jc_07_head" class="<?= $Page->jc_07_head->headerCellClass() ?>"><div id="elh_product_group_jc_07_head" class="product_group_jc_07_head"><?= $Page->renderFieldHeader($Page->jc_07_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_08_head->Visible) { // jc_08_head ?>
        <th data-name="jc_08_head" class="<?= $Page->jc_08_head->headerCellClass() ?>"><div id="elh_product_group_jc_08_head" class="product_group_jc_08_head"><?= $Page->renderFieldHeader($Page->jc_08_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_09_head->Visible) { // jc_09_head ?>
        <th data-name="jc_09_head" class="<?= $Page->jc_09_head->headerCellClass() ?>"><div id="elh_product_group_jc_09_head" class="product_group_jc_09_head"><?= $Page->renderFieldHeader($Page->jc_09_head) ?></div></th>
<?php } ?>
<?php if ($Page->jc_10_head->Visible) { // jc_10_head ?>
        <th data-name="jc_10_head" class="<?= $Page->jc_10_head->headerCellClass() ?>"><div id="elh_product_group_jc_10_head" class="product_group_jc_10_head"><?= $Page->renderFieldHeader($Page->jc_10_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_shape->Visible) { // pc_shape ?>
        <th data-name="pc_shape" class="<?= $Page->pc_shape->headerCellClass() ?>"><div id="elh_product_group_pc_shape" class="product_group_pc_shape"><?= $Page->renderFieldHeader($Page->pc_shape) ?></div></th>
<?php } ?>
<?php if ($Page->pc_unit->Visible) { // pc_unit ?>
        <th data-name="pc_unit" class="<?= $Page->pc_unit->headerCellClass() ?>"><div id="elh_product_group_pc_unit" class="product_group_pc_unit"><?= $Page->renderFieldHeader($Page->pc_unit) ?></div></th>
<?php } ?>
<?php if ($Page->pc_w->Visible) { // pc_w ?>
        <th data-name="pc_w" class="<?= $Page->pc_w->headerCellClass() ?>"><div id="elh_product_group_pc_w" class="product_group_pc_w"><?= $Page->renderFieldHeader($Page->pc_w) ?></div></th>
<?php } ?>
<?php if ($Page->pc_l->Visible) { // pc_l ?>
        <th data-name="pc_l" class="<?= $Page->pc_l->headerCellClass() ?>"><div id="elh_product_group_pc_l" class="product_group_pc_l"><?= $Page->renderFieldHeader($Page->pc_l) ?></div></th>
<?php } ?>
<?php if ($Page->pc_h->Visible) { // pc_h ?>
        <th data-name="pc_h" class="<?= $Page->pc_h->headerCellClass() ?>"><div id="elh_product_group_pc_h" class="product_group_pc_h"><?= $Page->renderFieldHeader($Page->pc_h) ?></div></th>
<?php } ?>
<?php if ($Page->pc_partner_size->Visible) { // pc_partner_size ?>
        <th data-name="pc_partner_size" class="<?= $Page->pc_partner_size->headerCellClass() ?>"><div id="elh_product_group_pc_partner_size" class="product_group_pc_partner_size"><?= $Page->renderFieldHeader($Page->pc_partner_size) ?></div></th>
<?php } ?>
<?php if ($Page->pc_sqm->Visible) { // pc_sqm ?>
        <th data-name="pc_sqm" class="<?= $Page->pc_sqm->headerCellClass() ?>"><div id="elh_product_group_pc_sqm" class="product_group_pc_sqm"><?= $Page->renderFieldHeader($Page->pc_sqm) ?></div></th>
<?php } ?>
<?php if ($Page->pc_01_head->Visible) { // pc_01_head ?>
        <th data-name="pc_01_head" class="<?= $Page->pc_01_head->headerCellClass() ?>"><div id="elh_product_group_pc_01_head" class="product_group_pc_01_head"><?= $Page->renderFieldHeader($Page->pc_01_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_02_head->Visible) { // pc_02_head ?>
        <th data-name="pc_02_head" class="<?= $Page->pc_02_head->headerCellClass() ?>"><div id="elh_product_group_pc_02_head" class="product_group_pc_02_head"><?= $Page->renderFieldHeader($Page->pc_02_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_03_head->Visible) { // pc_03_head ?>
        <th data-name="pc_03_head" class="<?= $Page->pc_03_head->headerCellClass() ?>"><div id="elh_product_group_pc_03_head" class="product_group_pc_03_head"><?= $Page->renderFieldHeader($Page->pc_03_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_04_head->Visible) { // pc_04_head ?>
        <th data-name="pc_04_head" class="<?= $Page->pc_04_head->headerCellClass() ?>"><div id="elh_product_group_pc_04_head" class="product_group_pc_04_head"><?= $Page->renderFieldHeader($Page->pc_04_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_05_head->Visible) { // pc_05_head ?>
        <th data-name="pc_05_head" class="<?= $Page->pc_05_head->headerCellClass() ?>"><div id="elh_product_group_pc_05_head" class="product_group_pc_05_head"><?= $Page->renderFieldHeader($Page->pc_05_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_06_head->Visible) { // pc_06_head ?>
        <th data-name="pc_06_head" class="<?= $Page->pc_06_head->headerCellClass() ?>"><div id="elh_product_group_pc_06_head" class="product_group_pc_06_head"><?= $Page->renderFieldHeader($Page->pc_06_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_07_head->Visible) { // pc_07_head ?>
        <th data-name="pc_07_head" class="<?= $Page->pc_07_head->headerCellClass() ?>"><div id="elh_product_group_pc_07_head" class="product_group_pc_07_head"><?= $Page->renderFieldHeader($Page->pc_07_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_08_head->Visible) { // pc_08_head ?>
        <th data-name="pc_08_head" class="<?= $Page->pc_08_head->headerCellClass() ?>"><div id="elh_product_group_pc_08_head" class="product_group_pc_08_head"><?= $Page->renderFieldHeader($Page->pc_08_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_09_head->Visible) { // pc_09_head ?>
        <th data-name="pc_09_head" class="<?= $Page->pc_09_head->headerCellClass() ?>"><div id="elh_product_group_pc_09_head" class="product_group_pc_09_head"><?= $Page->renderFieldHeader($Page->pc_09_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_10_head->Visible) { // pc_10_head ?>
        <th data-name="pc_10_head" class="<?= $Page->pc_10_head->headerCellClass() ?>"><div id="elh_product_group_pc_10_head" class="product_group_pc_10_head"><?= $Page->renderFieldHeader($Page->pc_10_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_11_head->Visible) { // pc_11_head ?>
        <th data-name="pc_11_head" class="<?= $Page->pc_11_head->headerCellClass() ?>"><div id="elh_product_group_pc_11_head" class="product_group_pc_11_head"><?= $Page->renderFieldHeader($Page->pc_11_head) ?></div></th>
<?php } ?>
<?php if ($Page->pc_12_head->Visible) { // pc_12_head ?>
        <th data-name="pc_12_head" class="<?= $Page->pc_12_head->headerCellClass() ?>"><div id="elh_product_group_pc_12_head" class="product_group_pc_12_head"><?= $Page->renderFieldHeader($Page->pc_12_head) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_product_group_operator" class="product_group_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_product_group_datetime" class="product_group_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Page->image->headerCellClass() ?>"><div id="elh_product_group_image" class="product_group_image"><?= $Page->renderFieldHeader($Page->image) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_size_w->Visible) { // pa_process_size_w ?>
        <th data-name="pa_process_size_w" class="<?= $Page->pa_process_size_w->headerCellClass() ?>"><div id="elh_product_group_pa_process_size_w" class="product_group_pa_process_size_w"><?= $Page->renderFieldHeader($Page->pa_process_size_w) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_size_l->Visible) { // pa_process_size_l ?>
        <th data-name="pa_process_size_l" class="<?= $Page->pa_process_size_l->headerCellClass() ?>"><div id="elh_product_group_pa_process_size_l" class="product_group_pa_process_size_l"><?= $Page->renderFieldHeader($Page->pa_process_size_l) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_01->Visible) { // pa_head_01 ?>
        <th data-name="pa_head_01" class="<?= $Page->pa_head_01->headerCellClass() ?>"><div id="elh_product_group_pa_head_01" class="product_group_pa_head_01"><?= $Page->renderFieldHeader($Page->pa_head_01) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_01->Visible) { // pa_process_01 ?>
        <th data-name="pa_process_01" class="<?= $Page->pa_process_01->headerCellClass() ?>"><div id="elh_product_group_pa_process_01" class="product_group_pa_process_01"><?= $Page->renderFieldHeader($Page->pa_process_01) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_02->Visible) { // pa_head_02 ?>
        <th data-name="pa_head_02" class="<?= $Page->pa_head_02->headerCellClass() ?>"><div id="elh_product_group_pa_head_02" class="product_group_pa_head_02"><?= $Page->renderFieldHeader($Page->pa_head_02) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_02->Visible) { // pa_process_02 ?>
        <th data-name="pa_process_02" class="<?= $Page->pa_process_02->headerCellClass() ?>"><div id="elh_product_group_pa_process_02" class="product_group_pa_process_02"><?= $Page->renderFieldHeader($Page->pa_process_02) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_03->Visible) { // pa_head_03 ?>
        <th data-name="pa_head_03" class="<?= $Page->pa_head_03->headerCellClass() ?>"><div id="elh_product_group_pa_head_03" class="product_group_pa_head_03"><?= $Page->renderFieldHeader($Page->pa_head_03) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_03->Visible) { // pa_process_03 ?>
        <th data-name="pa_process_03" class="<?= $Page->pa_process_03->headerCellClass() ?>"><div id="elh_product_group_pa_process_03" class="product_group_pa_process_03"><?= $Page->renderFieldHeader($Page->pa_process_03) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_04->Visible) { // pa_head_04 ?>
        <th data-name="pa_head_04" class="<?= $Page->pa_head_04->headerCellClass() ?>"><div id="elh_product_group_pa_head_04" class="product_group_pa_head_04"><?= $Page->renderFieldHeader($Page->pa_head_04) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_04->Visible) { // pa_process_04 ?>
        <th data-name="pa_process_04" class="<?= $Page->pa_process_04->headerCellClass() ?>"><div id="elh_product_group_pa_process_04" class="product_group_pa_process_04"><?= $Page->renderFieldHeader($Page->pa_process_04) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_05->Visible) { // pa_head_05 ?>
        <th data-name="pa_head_05" class="<?= $Page->pa_head_05->headerCellClass() ?>"><div id="elh_product_group_pa_head_05" class="product_group_pa_head_05"><?= $Page->renderFieldHeader($Page->pa_head_05) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_05->Visible) { // pa_process_05 ?>
        <th data-name="pa_process_05" class="<?= $Page->pa_process_05->headerCellClass() ?>"><div id="elh_product_group_pa_process_05" class="product_group_pa_process_05"><?= $Page->renderFieldHeader($Page->pa_process_05) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_06->Visible) { // pa_head_06 ?>
        <th data-name="pa_head_06" class="<?= $Page->pa_head_06->headerCellClass() ?>"><div id="elh_product_group_pa_head_06" class="product_group_pa_head_06"><?= $Page->renderFieldHeader($Page->pa_head_06) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_06->Visible) { // pa_process_06 ?>
        <th data-name="pa_process_06" class="<?= $Page->pa_process_06->headerCellClass() ?>"><div id="elh_product_group_pa_process_06" class="product_group_pa_process_06"><?= $Page->renderFieldHeader($Page->pa_process_06) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_07->Visible) { // pa_head_07 ?>
        <th data-name="pa_head_07" class="<?= $Page->pa_head_07->headerCellClass() ?>"><div id="elh_product_group_pa_head_07" class="product_group_pa_head_07"><?= $Page->renderFieldHeader($Page->pa_head_07) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_07->Visible) { // pa_process_07 ?>
        <th data-name="pa_process_07" class="<?= $Page->pa_process_07->headerCellClass() ?>"><div id="elh_product_group_pa_process_07" class="product_group_pa_process_07"><?= $Page->renderFieldHeader($Page->pa_process_07) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_08->Visible) { // pa_head_08 ?>
        <th data-name="pa_head_08" class="<?= $Page->pa_head_08->headerCellClass() ?>"><div id="elh_product_group_pa_head_08" class="product_group_pa_head_08"><?= $Page->renderFieldHeader($Page->pa_head_08) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_08->Visible) { // pa_process_08 ?>
        <th data-name="pa_process_08" class="<?= $Page->pa_process_08->headerCellClass() ?>"><div id="elh_product_group_pa_process_08" class="product_group_pa_process_08"><?= $Page->renderFieldHeader($Page->pa_process_08) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_09->Visible) { // pa_head_09 ?>
        <th data-name="pa_head_09" class="<?= $Page->pa_head_09->headerCellClass() ?>"><div id="elh_product_group_pa_head_09" class="product_group_pa_head_09"><?= $Page->renderFieldHeader($Page->pa_head_09) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_09->Visible) { // pa_process_09 ?>
        <th data-name="pa_process_09" class="<?= $Page->pa_process_09->headerCellClass() ?>"><div id="elh_product_group_pa_process_09" class="product_group_pa_process_09"><?= $Page->renderFieldHeader($Page->pa_process_09) ?></div></th>
<?php } ?>
<?php if ($Page->pa_head_10->Visible) { // pa_head_10 ?>
        <th data-name="pa_head_10" class="<?= $Page->pa_head_10->headerCellClass() ?>"><div id="elh_product_group_pa_head_10" class="product_group_pa_head_10"><?= $Page->renderFieldHeader($Page->pa_head_10) ?></div></th>
<?php } ?>
<?php if ($Page->pa_process_10->Visible) { // pa_process_10 ?>
        <th data-name="pa_process_10" class="<?= $Page->pa_process_10->headerCellClass() ?>"><div id="elh_product_group_pa_process_10" class="product_group_pa_process_10"><?= $Page->renderFieldHeader($Page->pa_process_10) ?></div></th>
<?php } ?>
<?php if ($Page->publish->Visible) { // publish ?>
        <th data-name="publish" class="<?= $Page->publish->headerCellClass() ?>"><div id="elh_product_group_publish" class="product_group_publish"><?= $Page->renderFieldHeader($Page->publish) ?></div></th>
<?php } ?>
<?php if ($Page->ppr_01->Visible) { // ppr_01 ?>
        <th data-name="ppr_01" class="<?= $Page->ppr_01->headerCellClass() ?>"><div id="elh_product_group_ppr_01" class="product_group_ppr_01"><?= $Page->renderFieldHeader($Page->ppr_01) ?></div></th>
<?php } ?>
<?php if ($Page->ppr_02->Visible) { // ppr_02 ?>
        <th data-name="ppr_02" class="<?= $Page->ppr_02->headerCellClass() ?>"><div id="elh_product_group_ppr_02" class="product_group_ppr_02"><?= $Page->renderFieldHeader($Page->ppr_02) ?></div></th>
<?php } ?>
<?php if ($Page->ppr_03->Visible) { // ppr_03 ?>
        <th data-name="ppr_03" class="<?= $Page->ppr_03->headerCellClass() ?>"><div id="elh_product_group_ppr_03" class="product_group_ppr_03"><?= $Page->renderFieldHeader($Page->ppr_03) ?></div></th>
<?php } ?>
<?php if ($Page->ppr_04->Visible) { // ppr_04 ?>
        <th data-name="ppr_04" class="<?= $Page->ppr_04->headerCellClass() ?>"><div id="elh_product_group_ppr_04" class="product_group_ppr_04"><?= $Page->renderFieldHeader($Page->ppr_04) ?></div></th>
<?php } ?>
<?php if ($Page->ppr_05->Visible) { // ppr_05 ?>
        <th data-name="ppr_05" class="<?= $Page->ppr_05->headerCellClass() ?>"><div id="elh_product_group_ppr_05" class="product_group_ppr_05"><?= $Page->renderFieldHeader($Page->ppr_05) ?></div></th>
<?php } ?>
<?php if ($Page->ppr_06->Visible) { // ppr_06 ?>
        <th data-name="ppr_06" class="<?= $Page->ppr_06->headerCellClass() ?>"><div id="elh_product_group_ppr_06" class="product_group_ppr_06"><?= $Page->renderFieldHeader($Page->ppr_06) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_id" class="el_product_group_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_grp" class="el_product_group_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?= $Page->grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_group->Visible) { // product_group ?>
        <td data-name="product_group"<?= $Page->product_group->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_product_group" class="el_product_group_product_group">
<span<?= $Page->product_group->viewAttributes() ?>>
<?= $Page->product_group->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->calculation_method->Visible) { // calculation_method ?>
        <td data-name="calculation_method"<?= $Page->calculation_method->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_calculation_method" class="el_product_group_calculation_method">
<span<?= $Page->calculation_method->viewAttributes() ?>>
<?= $Page->calculation_method->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_shape" class="el_product_group_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sqm->Visible) { // sqm ?>
        <td data-name="sqm"<?= $Page->sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_sqm" class="el_product_group_sqm">
<span<?= $Page->sqm->viewAttributes() ?>>
<?= $Page->sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->cbm->Visible) { // cbm ?>
        <td data-name="cbm"<?= $Page->cbm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_cbm" class="el_product_group_cbm">
<span<?= $Page->cbm->viewAttributes() ?>>
<?= $Page->cbm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->process->Visible) { // process ?>
        <td data-name="process"<?= $Page->process->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_process" class="el_product_group_process">
<span<?= $Page->process->viewAttributes() ?>>
<?= $Page->process->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_status" class="el_product_group_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_00->Visible) { // v_00 ?>
        <td data-name="v_00"<?= $Page->v_00->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_00" class="el_product_group_v_00">
<span<?= $Page->v_00->viewAttributes() ?>>
<?= $Page->v_00->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_01->Visible) { // v_01 ?>
        <td data-name="v_01"<?= $Page->v_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_01" class="el_product_group_v_01">
<span<?= $Page->v_01->viewAttributes() ?>>
<?= $Page->v_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_01_validation->Visible) { // v_01_validation ?>
        <td data-name="v_01_validation"<?= $Page->v_01_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_01_validation" class="el_product_group_v_01_validation">
<span<?= $Page->v_01_validation->viewAttributes() ?>>
<?= $Page->v_01_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_02->Visible) { // v_02 ?>
        <td data-name="v_02"<?= $Page->v_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_02" class="el_product_group_v_02">
<span<?= $Page->v_02->viewAttributes() ?>>
<?= $Page->v_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_02_validation->Visible) { // v_02_validation ?>
        <td data-name="v_02_validation"<?= $Page->v_02_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_02_validation" class="el_product_group_v_02_validation">
<span<?= $Page->v_02_validation->viewAttributes() ?>>
<?= $Page->v_02_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_03->Visible) { // v_03 ?>
        <td data-name="v_03"<?= $Page->v_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_03" class="el_product_group_v_03">
<span<?= $Page->v_03->viewAttributes() ?>>
<?= $Page->v_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_03_validation->Visible) { // v_03_validation ?>
        <td data-name="v_03_validation"<?= $Page->v_03_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_03_validation" class="el_product_group_v_03_validation">
<span<?= $Page->v_03_validation->viewAttributes() ?>>
<?= $Page->v_03_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_04->Visible) { // v_04 ?>
        <td data-name="v_04"<?= $Page->v_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_04" class="el_product_group_v_04">
<span<?= $Page->v_04->viewAttributes() ?>>
<?= $Page->v_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_04_validation->Visible) { // v_04_validation ?>
        <td data-name="v_04_validation"<?= $Page->v_04_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_04_validation" class="el_product_group_v_04_validation">
<span<?= $Page->v_04_validation->viewAttributes() ?>>
<?= $Page->v_04_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_05->Visible) { // v_05 ?>
        <td data-name="v_05"<?= $Page->v_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_05" class="el_product_group_v_05">
<span<?= $Page->v_05->viewAttributes() ?>>
<?= $Page->v_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_05_validation->Visible) { // v_05_validation ?>
        <td data-name="v_05_validation"<?= $Page->v_05_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_05_validation" class="el_product_group_v_05_validation">
<span<?= $Page->v_05_validation->viewAttributes() ?>>
<?= $Page->v_05_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_06->Visible) { // v_06 ?>
        <td data-name="v_06"<?= $Page->v_06->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_06" class="el_product_group_v_06">
<span<?= $Page->v_06->viewAttributes() ?>>
<?= $Page->v_06->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_06_validation->Visible) { // v_06_validation ?>
        <td data-name="v_06_validation"<?= $Page->v_06_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_06_validation" class="el_product_group_v_06_validation">
<span<?= $Page->v_06_validation->viewAttributes() ?>>
<?= $Page->v_06_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_07->Visible) { // v_07 ?>
        <td data-name="v_07"<?= $Page->v_07->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_07" class="el_product_group_v_07">
<span<?= $Page->v_07->viewAttributes() ?>>
<?= $Page->v_07->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_07_validation->Visible) { // v_07_validation ?>
        <td data-name="v_07_validation"<?= $Page->v_07_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_07_validation" class="el_product_group_v_07_validation">
<span<?= $Page->v_07_validation->viewAttributes() ?>>
<?= $Page->v_07_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_08->Visible) { // v_08 ?>
        <td data-name="v_08"<?= $Page->v_08->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_08" class="el_product_group_v_08">
<span<?= $Page->v_08->viewAttributes() ?>>
<?= $Page->v_08->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_08_validation->Visible) { // v_08_validation ?>
        <td data-name="v_08_validation"<?= $Page->v_08_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_08_validation" class="el_product_group_v_08_validation">
<span<?= $Page->v_08_validation->viewAttributes() ?>>
<?= $Page->v_08_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_09->Visible) { // v_09 ?>
        <td data-name="v_09"<?= $Page->v_09->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_09" class="el_product_group_v_09">
<span<?= $Page->v_09->viewAttributes() ?>>
<?= $Page->v_09->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_09_validation->Visible) { // v_09_validation ?>
        <td data-name="v_09_validation"<?= $Page->v_09_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_09_validation" class="el_product_group_v_09_validation">
<span<?= $Page->v_09_validation->viewAttributes() ?>>
<?= $Page->v_09_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_10->Visible) { // v_10 ?>
        <td data-name="v_10"<?= $Page->v_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_10" class="el_product_group_v_10">
<span<?= $Page->v_10->viewAttributes() ?>>
<?= $Page->v_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->v_10_validation->Visible) { // v_10_validation ?>
        <td data-name="v_10_validation"<?= $Page->v_10_validation->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_v_10_validation" class="el_product_group_v_10_validation">
<span<?= $Page->v_10_validation->viewAttributes() ?>>
<?= $Page->v_10_validation->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_01_head->Visible) { // b_01_head ?>
        <td data-name="b_01_head"<?= $Page->b_01_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_01_head" class="el_product_group_b_01_head">
<span<?= $Page->b_01_head->viewAttributes() ?>>
<?= $Page->b_01_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_02_head->Visible) { // b_02_head ?>
        <td data-name="b_02_head"<?= $Page->b_02_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_02_head" class="el_product_group_b_02_head">
<span<?= $Page->b_02_head->viewAttributes() ?>>
<?= $Page->b_02_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_03_head->Visible) { // b_03_head ?>
        <td data-name="b_03_head"<?= $Page->b_03_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_03_head" class="el_product_group_b_03_head">
<span<?= $Page->b_03_head->viewAttributes() ?>>
<?= $Page->b_03_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_04_head->Visible) { // b_04_head ?>
        <td data-name="b_04_head"<?= $Page->b_04_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_04_head" class="el_product_group_b_04_head">
<span<?= $Page->b_04_head->viewAttributes() ?>>
<?= $Page->b_04_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_05_head->Visible) { // b_05_head ?>
        <td data-name="b_05_head"<?= $Page->b_05_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_05_head" class="el_product_group_b_05_head">
<span<?= $Page->b_05_head->viewAttributes() ?>>
<?= $Page->b_05_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_06_head->Visible) { // b_06_head ?>
        <td data-name="b_06_head"<?= $Page->b_06_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_06_head" class="el_product_group_b_06_head">
<span<?= $Page->b_06_head->viewAttributes() ?>>
<?= $Page->b_06_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_07_head->Visible) { // b_07_head ?>
        <td data-name="b_07_head"<?= $Page->b_07_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_07_head" class="el_product_group_b_07_head">
<span<?= $Page->b_07_head->viewAttributes() ?>>
<?= $Page->b_07_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_08_head->Visible) { // b_08_head ?>
        <td data-name="b_08_head"<?= $Page->b_08_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_08_head" class="el_product_group_b_08_head">
<span<?= $Page->b_08_head->viewAttributes() ?>>
<?= $Page->b_08_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_09_head->Visible) { // b_09_head ?>
        <td data-name="b_09_head"<?= $Page->b_09_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_09_head" class="el_product_group_b_09_head">
<span<?= $Page->b_09_head->viewAttributes() ?>>
<?= $Page->b_09_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_10_head->Visible) { // b_10_head ?>
        <td data-name="b_10_head"<?= $Page->b_10_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_10_head" class="el_product_group_b_10_head">
<span<?= $Page->b_10_head->viewAttributes() ?>>
<?= $Page->b_10_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_11_head->Visible) { // b_11_head ?>
        <td data-name="b_11_head"<?= $Page->b_11_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_11_head" class="el_product_group_b_11_head">
<span<?= $Page->b_11_head->viewAttributes() ?>>
<?= $Page->b_11_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_12_head->Visible) { // b_12_head ?>
        <td data-name="b_12_head"<?= $Page->b_12_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_12_head" class="el_product_group_b_12_head">
<span<?= $Page->b_12_head->viewAttributes() ?>>
<?= $Page->b_12_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_13_head->Visible) { // b_13_head ?>
        <td data-name="b_13_head"<?= $Page->b_13_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_13_head" class="el_product_group_b_13_head">
<span<?= $Page->b_13_head->viewAttributes() ?>>
<?= $Page->b_13_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_14_head->Visible) { // b_14_head ?>
        <td data-name="b_14_head"<?= $Page->b_14_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_14_head" class="el_product_group_b_14_head">
<span<?= $Page->b_14_head->viewAttributes() ?>>
<?= $Page->b_14_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->b_15_head->Visible) { // b_15_head ?>
        <td data-name="b_15_head"<?= $Page->b_15_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_b_15_head" class="el_product_group_b_15_head">
<span<?= $Page->b_15_head->viewAttributes() ?>>
<?= $Page->b_15_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->q_sku->Visible) { // q_sku ?>
        <td data-name="q_sku"<?= $Page->q_sku->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_q_sku" class="el_product_group_q_sku">
<span<?= $Page->q_sku->viewAttributes() ?>>
<?= $Page->q_sku->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_01_head->Visible) { // t_01_head ?>
        <td data-name="t_01_head"<?= $Page->t_01_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_01_head" class="el_product_group_t_01_head">
<span<?= $Page->t_01_head->viewAttributes() ?>>
<?= $Page->t_01_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_02_head->Visible) { // t_02_head ?>
        <td data-name="t_02_head"<?= $Page->t_02_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_02_head" class="el_product_group_t_02_head">
<span<?= $Page->t_02_head->viewAttributes() ?>>
<?= $Page->t_02_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_03_head->Visible) { // t_03_head ?>
        <td data-name="t_03_head"<?= $Page->t_03_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_03_head" class="el_product_group_t_03_head">
<span<?= $Page->t_03_head->viewAttributes() ?>>
<?= $Page->t_03_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_04_head->Visible) { // t_04_head ?>
        <td data-name="t_04_head"<?= $Page->t_04_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_04_head" class="el_product_group_t_04_head">
<span<?= $Page->t_04_head->viewAttributes() ?>>
<?= $Page->t_04_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_05_head->Visible) { // t_05_head ?>
        <td data-name="t_05_head"<?= $Page->t_05_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_05_head" class="el_product_group_t_05_head">
<span<?= $Page->t_05_head->viewAttributes() ?>>
<?= $Page->t_05_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_06_head->Visible) { // t_06_head ?>
        <td data-name="t_06_head"<?= $Page->t_06_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_06_head" class="el_product_group_t_06_head">
<span<?= $Page->t_06_head->viewAttributes() ?>>
<?= $Page->t_06_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_07_head->Visible) { // t_07_head ?>
        <td data-name="t_07_head"<?= $Page->t_07_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_07_head" class="el_product_group_t_07_head">
<span<?= $Page->t_07_head->viewAttributes() ?>>
<?= $Page->t_07_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_08_head->Visible) { // t_08_head ?>
        <td data-name="t_08_head"<?= $Page->t_08_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_08_head" class="el_product_group_t_08_head">
<span<?= $Page->t_08_head->viewAttributes() ?>>
<?= $Page->t_08_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_09_head->Visible) { // t_09_head ?>
        <td data-name="t_09_head"<?= $Page->t_09_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_09_head" class="el_product_group_t_09_head">
<span<?= $Page->t_09_head->viewAttributes() ?>>
<?= $Page->t_09_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_10_head->Visible) { // t_10_head ?>
        <td data-name="t_10_head"<?= $Page->t_10_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_10_head" class="el_product_group_t_10_head">
<span<?= $Page->t_10_head->viewAttributes() ?>>
<?= $Page->t_10_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_11_head->Visible) { // t_11_head ?>
        <td data-name="t_11_head"<?= $Page->t_11_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_11_head" class="el_product_group_t_11_head">
<span<?= $Page->t_11_head->viewAttributes() ?>>
<?= $Page->t_11_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_12_head->Visible) { // t_12_head ?>
        <td data-name="t_12_head"<?= $Page->t_12_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_12_head" class="el_product_group_t_12_head">
<span<?= $Page->t_12_head->viewAttributes() ?>>
<?= $Page->t_12_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_13_head->Visible) { // t_13_head ?>
        <td data-name="t_13_head"<?= $Page->t_13_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_13_head" class="el_product_group_t_13_head">
<span<?= $Page->t_13_head->viewAttributes() ?>>
<?= $Page->t_13_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_14_head->Visible) { // t_14_head ?>
        <td data-name="t_14_head"<?= $Page->t_14_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_14_head" class="el_product_group_t_14_head">
<span<?= $Page->t_14_head->viewAttributes() ?>>
<?= $Page->t_14_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->t_15_head->Visible) { // t_15_head ?>
        <td data-name="t_15_head"<?= $Page->t_15_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_t_15_head" class="el_product_group_t_15_head">
<span<?= $Page->t_15_head->viewAttributes() ?>>
<?= $Page->t_15_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_01_head->Visible) { // po_01_head ?>
        <td data-name="po_01_head"<?= $Page->po_01_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_01_head" class="el_product_group_po_01_head">
<span<?= $Page->po_01_head->viewAttributes() ?>>
<?= $Page->po_01_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_02_head->Visible) { // po_02_head ?>
        <td data-name="po_02_head"<?= $Page->po_02_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_02_head" class="el_product_group_po_02_head">
<span<?= $Page->po_02_head->viewAttributes() ?>>
<?= $Page->po_02_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_03_head->Visible) { // po_03_head ?>
        <td data-name="po_03_head"<?= $Page->po_03_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_03_head" class="el_product_group_po_03_head">
<span<?= $Page->po_03_head->viewAttributes() ?>>
<?= $Page->po_03_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_04_head->Visible) { // po_04_head ?>
        <td data-name="po_04_head"<?= $Page->po_04_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_04_head" class="el_product_group_po_04_head">
<span<?= $Page->po_04_head->viewAttributes() ?>>
<?= $Page->po_04_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_05_head->Visible) { // po_05_head ?>
        <td data-name="po_05_head"<?= $Page->po_05_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_05_head" class="el_product_group_po_05_head">
<span<?= $Page->po_05_head->viewAttributes() ?>>
<?= $Page->po_05_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_06_head->Visible) { // po_06_head ?>
        <td data-name="po_06_head"<?= $Page->po_06_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_06_head" class="el_product_group_po_06_head">
<span<?= $Page->po_06_head->viewAttributes() ?>>
<?= $Page->po_06_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_07_head->Visible) { // po_07_head ?>
        <td data-name="po_07_head"<?= $Page->po_07_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_07_head" class="el_product_group_po_07_head">
<span<?= $Page->po_07_head->viewAttributes() ?>>
<?= $Page->po_07_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_08_head->Visible) { // po_08_head ?>
        <td data-name="po_08_head"<?= $Page->po_08_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_08_head" class="el_product_group_po_08_head">
<span<?= $Page->po_08_head->viewAttributes() ?>>
<?= $Page->po_08_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_17_head->Visible) { // po_17_head ?>
        <td data-name="po_17_head"<?= $Page->po_17_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_17_head" class="el_product_group_po_17_head">
<span<?= $Page->po_17_head->viewAttributes() ?>>
<?= $Page->po_17_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_18_head->Visible) { // po_18_head ?>
        <td data-name="po_18_head"<?= $Page->po_18_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_18_head" class="el_product_group_po_18_head">
<span<?= $Page->po_18_head->viewAttributes() ?>>
<?= $Page->po_18_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_19_head->Visible) { // po_19_head ?>
        <td data-name="po_19_head"<?= $Page->po_19_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_19_head" class="el_product_group_po_19_head">
<span<?= $Page->po_19_head->viewAttributes() ?>>
<?= $Page->po_19_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_20_head->Visible) { // po_20_head ?>
        <td data-name="po_20_head"<?= $Page->po_20_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_po_20_head" class="el_product_group_po_20_head">
<span<?= $Page->po_20_head->viewAttributes() ?>>
<?= $Page->po_20_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_01_head->Visible) { // jc_01_head ?>
        <td data-name="jc_01_head"<?= $Page->jc_01_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_01_head" class="el_product_group_jc_01_head">
<span<?= $Page->jc_01_head->viewAttributes() ?>>
<?= $Page->jc_01_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_02_head->Visible) { // jc_02_head ?>
        <td data-name="jc_02_head"<?= $Page->jc_02_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_02_head" class="el_product_group_jc_02_head">
<span<?= $Page->jc_02_head->viewAttributes() ?>>
<?= $Page->jc_02_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_03_head->Visible) { // jc_03_head ?>
        <td data-name="jc_03_head"<?= $Page->jc_03_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_03_head" class="el_product_group_jc_03_head">
<span<?= $Page->jc_03_head->viewAttributes() ?>>
<?= $Page->jc_03_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_04_head->Visible) { // jc_04_head ?>
        <td data-name="jc_04_head"<?= $Page->jc_04_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_04_head" class="el_product_group_jc_04_head">
<span<?= $Page->jc_04_head->viewAttributes() ?>>
<?= $Page->jc_04_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_05_head->Visible) { // jc_05_head ?>
        <td data-name="jc_05_head"<?= $Page->jc_05_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_05_head" class="el_product_group_jc_05_head">
<span<?= $Page->jc_05_head->viewAttributes() ?>>
<?= $Page->jc_05_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_06_head->Visible) { // jc_06_head ?>
        <td data-name="jc_06_head"<?= $Page->jc_06_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_06_head" class="el_product_group_jc_06_head">
<span<?= $Page->jc_06_head->viewAttributes() ?>>
<?= $Page->jc_06_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_07_head->Visible) { // jc_07_head ?>
        <td data-name="jc_07_head"<?= $Page->jc_07_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_07_head" class="el_product_group_jc_07_head">
<span<?= $Page->jc_07_head->viewAttributes() ?>>
<?= $Page->jc_07_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_08_head->Visible) { // jc_08_head ?>
        <td data-name="jc_08_head"<?= $Page->jc_08_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_08_head" class="el_product_group_jc_08_head">
<span<?= $Page->jc_08_head->viewAttributes() ?>>
<?= $Page->jc_08_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_09_head->Visible) { // jc_09_head ?>
        <td data-name="jc_09_head"<?= $Page->jc_09_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_09_head" class="el_product_group_jc_09_head">
<span<?= $Page->jc_09_head->viewAttributes() ?>>
<?= $Page->jc_09_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->jc_10_head->Visible) { // jc_10_head ?>
        <td data-name="jc_10_head"<?= $Page->jc_10_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_jc_10_head" class="el_product_group_jc_10_head">
<span<?= $Page->jc_10_head->viewAttributes() ?>>
<?= $Page->jc_10_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_shape->Visible) { // pc_shape ?>
        <td data-name="pc_shape"<?= $Page->pc_shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_shape" class="el_product_group_pc_shape">
<span<?= $Page->pc_shape->viewAttributes() ?>>
<?= $Page->pc_shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_unit->Visible) { // pc_unit ?>
        <td data-name="pc_unit"<?= $Page->pc_unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_unit" class="el_product_group_pc_unit">
<span<?= $Page->pc_unit->viewAttributes() ?>>
<?= $Page->pc_unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_w->Visible) { // pc_w ?>
        <td data-name="pc_w"<?= $Page->pc_w->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_w" class="el_product_group_pc_w">
<span<?= $Page->pc_w->viewAttributes() ?>>
<?= $Page->pc_w->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_l->Visible) { // pc_l ?>
        <td data-name="pc_l"<?= $Page->pc_l->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_l" class="el_product_group_pc_l">
<span<?= $Page->pc_l->viewAttributes() ?>>
<?= $Page->pc_l->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_h->Visible) { // pc_h ?>
        <td data-name="pc_h"<?= $Page->pc_h->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_h" class="el_product_group_pc_h">
<span<?= $Page->pc_h->viewAttributes() ?>>
<?= $Page->pc_h->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_partner_size->Visible) { // pc_partner_size ?>
        <td data-name="pc_partner_size"<?= $Page->pc_partner_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_partner_size" class="el_product_group_pc_partner_size">
<span<?= $Page->pc_partner_size->viewAttributes() ?>>
<?= $Page->pc_partner_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_sqm->Visible) { // pc_sqm ?>
        <td data-name="pc_sqm"<?= $Page->pc_sqm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_sqm" class="el_product_group_pc_sqm">
<span<?= $Page->pc_sqm->viewAttributes() ?>>
<?= $Page->pc_sqm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_01_head->Visible) { // pc_01_head ?>
        <td data-name="pc_01_head"<?= $Page->pc_01_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_01_head" class="el_product_group_pc_01_head">
<span<?= $Page->pc_01_head->viewAttributes() ?>>
<?= $Page->pc_01_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_02_head->Visible) { // pc_02_head ?>
        <td data-name="pc_02_head"<?= $Page->pc_02_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_02_head" class="el_product_group_pc_02_head">
<span<?= $Page->pc_02_head->viewAttributes() ?>>
<?= $Page->pc_02_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_03_head->Visible) { // pc_03_head ?>
        <td data-name="pc_03_head"<?= $Page->pc_03_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_03_head" class="el_product_group_pc_03_head">
<span<?= $Page->pc_03_head->viewAttributes() ?>>
<?= $Page->pc_03_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_04_head->Visible) { // pc_04_head ?>
        <td data-name="pc_04_head"<?= $Page->pc_04_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_04_head" class="el_product_group_pc_04_head">
<span<?= $Page->pc_04_head->viewAttributes() ?>>
<?= $Page->pc_04_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_05_head->Visible) { // pc_05_head ?>
        <td data-name="pc_05_head"<?= $Page->pc_05_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_05_head" class="el_product_group_pc_05_head">
<span<?= $Page->pc_05_head->viewAttributes() ?>>
<?= $Page->pc_05_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_06_head->Visible) { // pc_06_head ?>
        <td data-name="pc_06_head"<?= $Page->pc_06_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_06_head" class="el_product_group_pc_06_head">
<span<?= $Page->pc_06_head->viewAttributes() ?>>
<?= $Page->pc_06_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_07_head->Visible) { // pc_07_head ?>
        <td data-name="pc_07_head"<?= $Page->pc_07_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_07_head" class="el_product_group_pc_07_head">
<span<?= $Page->pc_07_head->viewAttributes() ?>>
<?= $Page->pc_07_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_08_head->Visible) { // pc_08_head ?>
        <td data-name="pc_08_head"<?= $Page->pc_08_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_08_head" class="el_product_group_pc_08_head">
<span<?= $Page->pc_08_head->viewAttributes() ?>>
<?= $Page->pc_08_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_09_head->Visible) { // pc_09_head ?>
        <td data-name="pc_09_head"<?= $Page->pc_09_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_09_head" class="el_product_group_pc_09_head">
<span<?= $Page->pc_09_head->viewAttributes() ?>>
<?= $Page->pc_09_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_10_head->Visible) { // pc_10_head ?>
        <td data-name="pc_10_head"<?= $Page->pc_10_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_10_head" class="el_product_group_pc_10_head">
<span<?= $Page->pc_10_head->viewAttributes() ?>>
<?= $Page->pc_10_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_11_head->Visible) { // pc_11_head ?>
        <td data-name="pc_11_head"<?= $Page->pc_11_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_11_head" class="el_product_group_pc_11_head">
<span<?= $Page->pc_11_head->viewAttributes() ?>>
<?= $Page->pc_11_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pc_12_head->Visible) { // pc_12_head ?>
        <td data-name="pc_12_head"<?= $Page->pc_12_head->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pc_12_head" class="el_product_group_pc_12_head">
<span<?= $Page->pc_12_head->viewAttributes() ?>>
<?= $Page->pc_12_head->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_operator" class="el_product_group_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_datetime" class="el_product_group_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_image" class="el_product_group_image">
<span>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_size_w->Visible) { // pa_process_size_w ?>
        <td data-name="pa_process_size_w"<?= $Page->pa_process_size_w->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_size_w" class="el_product_group_pa_process_size_w">
<span<?= $Page->pa_process_size_w->viewAttributes() ?>>
<?= $Page->pa_process_size_w->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_size_l->Visible) { // pa_process_size_l ?>
        <td data-name="pa_process_size_l"<?= $Page->pa_process_size_l->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_size_l" class="el_product_group_pa_process_size_l">
<span<?= $Page->pa_process_size_l->viewAttributes() ?>>
<?= $Page->pa_process_size_l->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_01->Visible) { // pa_head_01 ?>
        <td data-name="pa_head_01"<?= $Page->pa_head_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_01" class="el_product_group_pa_head_01">
<span<?= $Page->pa_head_01->viewAttributes() ?>>
<?= $Page->pa_head_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_01->Visible) { // pa_process_01 ?>
        <td data-name="pa_process_01"<?= $Page->pa_process_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_01" class="el_product_group_pa_process_01">
<span<?= $Page->pa_process_01->viewAttributes() ?>>
<?= $Page->pa_process_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_02->Visible) { // pa_head_02 ?>
        <td data-name="pa_head_02"<?= $Page->pa_head_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_02" class="el_product_group_pa_head_02">
<span<?= $Page->pa_head_02->viewAttributes() ?>>
<?= $Page->pa_head_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_02->Visible) { // pa_process_02 ?>
        <td data-name="pa_process_02"<?= $Page->pa_process_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_02" class="el_product_group_pa_process_02">
<span<?= $Page->pa_process_02->viewAttributes() ?>>
<?= $Page->pa_process_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_03->Visible) { // pa_head_03 ?>
        <td data-name="pa_head_03"<?= $Page->pa_head_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_03" class="el_product_group_pa_head_03">
<span<?= $Page->pa_head_03->viewAttributes() ?>>
<?= $Page->pa_head_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_03->Visible) { // pa_process_03 ?>
        <td data-name="pa_process_03"<?= $Page->pa_process_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_03" class="el_product_group_pa_process_03">
<span<?= $Page->pa_process_03->viewAttributes() ?>>
<?= $Page->pa_process_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_04->Visible) { // pa_head_04 ?>
        <td data-name="pa_head_04"<?= $Page->pa_head_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_04" class="el_product_group_pa_head_04">
<span<?= $Page->pa_head_04->viewAttributes() ?>>
<?= $Page->pa_head_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_04->Visible) { // pa_process_04 ?>
        <td data-name="pa_process_04"<?= $Page->pa_process_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_04" class="el_product_group_pa_process_04">
<span<?= $Page->pa_process_04->viewAttributes() ?>>
<?= $Page->pa_process_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_05->Visible) { // pa_head_05 ?>
        <td data-name="pa_head_05"<?= $Page->pa_head_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_05" class="el_product_group_pa_head_05">
<span<?= $Page->pa_head_05->viewAttributes() ?>>
<?= $Page->pa_head_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_05->Visible) { // pa_process_05 ?>
        <td data-name="pa_process_05"<?= $Page->pa_process_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_05" class="el_product_group_pa_process_05">
<span<?= $Page->pa_process_05->viewAttributes() ?>>
<?= $Page->pa_process_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_06->Visible) { // pa_head_06 ?>
        <td data-name="pa_head_06"<?= $Page->pa_head_06->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_06" class="el_product_group_pa_head_06">
<span<?= $Page->pa_head_06->viewAttributes() ?>>
<?= $Page->pa_head_06->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_06->Visible) { // pa_process_06 ?>
        <td data-name="pa_process_06"<?= $Page->pa_process_06->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_06" class="el_product_group_pa_process_06">
<span<?= $Page->pa_process_06->viewAttributes() ?>>
<?= $Page->pa_process_06->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_07->Visible) { // pa_head_07 ?>
        <td data-name="pa_head_07"<?= $Page->pa_head_07->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_07" class="el_product_group_pa_head_07">
<span<?= $Page->pa_head_07->viewAttributes() ?>>
<?= $Page->pa_head_07->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_07->Visible) { // pa_process_07 ?>
        <td data-name="pa_process_07"<?= $Page->pa_process_07->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_07" class="el_product_group_pa_process_07">
<span<?= $Page->pa_process_07->viewAttributes() ?>>
<?= $Page->pa_process_07->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_08->Visible) { // pa_head_08 ?>
        <td data-name="pa_head_08"<?= $Page->pa_head_08->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_08" class="el_product_group_pa_head_08">
<span<?= $Page->pa_head_08->viewAttributes() ?>>
<?= $Page->pa_head_08->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_08->Visible) { // pa_process_08 ?>
        <td data-name="pa_process_08"<?= $Page->pa_process_08->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_08" class="el_product_group_pa_process_08">
<span<?= $Page->pa_process_08->viewAttributes() ?>>
<?= $Page->pa_process_08->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_09->Visible) { // pa_head_09 ?>
        <td data-name="pa_head_09"<?= $Page->pa_head_09->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_09" class="el_product_group_pa_head_09">
<span<?= $Page->pa_head_09->viewAttributes() ?>>
<?= $Page->pa_head_09->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_09->Visible) { // pa_process_09 ?>
        <td data-name="pa_process_09"<?= $Page->pa_process_09->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_09" class="el_product_group_pa_process_09">
<span<?= $Page->pa_process_09->viewAttributes() ?>>
<?= $Page->pa_process_09->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_head_10->Visible) { // pa_head_10 ?>
        <td data-name="pa_head_10"<?= $Page->pa_head_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_head_10" class="el_product_group_pa_head_10">
<span<?= $Page->pa_head_10->viewAttributes() ?>>
<?= $Page->pa_head_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pa_process_10->Visible) { // pa_process_10 ?>
        <td data-name="pa_process_10"<?= $Page->pa_process_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_pa_process_10" class="el_product_group_pa_process_10">
<span<?= $Page->pa_process_10->viewAttributes() ?>>
<?= $Page->pa_process_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->publish->Visible) { // publish ?>
        <td data-name="publish"<?= $Page->publish->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_publish" class="el_product_group_publish">
<span<?= $Page->publish->viewAttributes() ?>>
<?= $Page->publish->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ppr_01->Visible) { // ppr_01 ?>
        <td data-name="ppr_01"<?= $Page->ppr_01->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_ppr_01" class="el_product_group_ppr_01">
<span<?= $Page->ppr_01->viewAttributes() ?>>
<?= $Page->ppr_01->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ppr_02->Visible) { // ppr_02 ?>
        <td data-name="ppr_02"<?= $Page->ppr_02->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_ppr_02" class="el_product_group_ppr_02">
<span<?= $Page->ppr_02->viewAttributes() ?>>
<?= $Page->ppr_02->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ppr_03->Visible) { // ppr_03 ?>
        <td data-name="ppr_03"<?= $Page->ppr_03->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_ppr_03" class="el_product_group_ppr_03">
<span<?= $Page->ppr_03->viewAttributes() ?>>
<?= $Page->ppr_03->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ppr_04->Visible) { // ppr_04 ?>
        <td data-name="ppr_04"<?= $Page->ppr_04->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_ppr_04" class="el_product_group_ppr_04">
<span<?= $Page->ppr_04->viewAttributes() ?>>
<?= $Page->ppr_04->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ppr_05->Visible) { // ppr_05 ?>
        <td data-name="ppr_05"<?= $Page->ppr_05->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_ppr_05" class="el_product_group_ppr_05">
<span<?= $Page->ppr_05->viewAttributes() ?>>
<?= $Page->ppr_05->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ppr_06->Visible) { // ppr_06 ?>
        <td data-name="ppr_06"<?= $Page->ppr_06->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_group_ppr_06" class="el_product_group_ppr_06">
<span<?= $Page->ppr_06->viewAttributes() ?>>
<?= $Page->ppr_06->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_group");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
