<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductFAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_f: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fproduct_fadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduct_fadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null, ew.Validators.regex(/^[^_]+$/)], fields.product.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_fadd" id="fproduct_fadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_f">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp"<?= $Page->grp->rowAttributes() ?>>
        <label id="elh_product_f_grp" for="x_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->grp->caption() ?><?= $Page->grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->grp->cellAttributes() ?>>
<span id="el_product_f_grp">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_fadd_x_grp"
        <?php } ?>
        data-table="product_f"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <?= $Page->grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage() ?></div>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_fadd", function() {
    var options = { name: "x_grp", selectId: "fproduct_fadd_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_fadd.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_fadd" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_fadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_f.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp"<?= $Page->s_grp->rowAttributes() ?>>
        <label id="elh_product_f_s_grp" for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><?= $Page->s_grp->caption() ?><?= $Page->s_grp->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->s_grp->cellAttributes() ?>>
<span id="el_product_f_s_grp">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_fadd_x_s_grp"
        <?php } ?>
        data-table="product_f"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <?= $Page->s_grp->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage() ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_fadd", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_fadd_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_fadd.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_fadd" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_fadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_f.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product"<?= $Page->product->rowAttributes() ?>>
        <label id="elh_product_f_product" for="x_product" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product->caption() ?><?= $Page->product->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product->cellAttributes() ?>>
<span id="el_product_f_product">
<input type="<?= $Page->product->getInputTextType() ?>" name="x_product" id="x_product" data-table="product_f" data-field="x_product" value="<?= $Page->product->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product->formatPattern()) ?>"<?= $Page->product->editAttributes() ?> aria-describedby="x_product_help">
<?= $Page->product->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_product_f_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_product_f_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="product_f" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_product_f_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_product_f_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fproduct_fadd_x_status"
        <?php } ?>
        data-table="product_f"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_fadd", function() {
    var options = { name: "x_status", selectId: "fproduct_fadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_fadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fproduct_fadd" };
    } else {
        options.ajax = { id: "x_status", form: "fproduct_fadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_f.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_fadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_fadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_f");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
