<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartSUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_s: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fproduct_cart_supdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_supdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null], fields.partner_id.isInvalid],
            ["p_remarks", [fields.p_remarks.visible && fields.p_remarks.required ? ew.Validators.required(fields.p_remarks.caption) : null], fields.p_remarks.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_cart_supdate" id="fproduct_cart_supdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_s">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_product_cart_supdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->partner_id->Visible && (!$Page->isConfirm() || $Page->partner_id->multiUpdateSelected())) { // partner_id ?>
    <div id="r_partner_id"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_partner_id" id="u_partner_id" class="form-check-input ew-multi-select" value="1"<?= $Page->partner_id->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_partner_id"><?= $Page->partner_id->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_partner_id" id="u_partner_id" value="<?= $Page->partner_id->MultiUpdate ?>">
            <?= $Page->partner_id->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_product_cart_s_partner_id">
                    <select
                        id="x_partner_id"
                        name="x_partner_id"
                        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
                        data-select2-id="fproduct_cart_supdate_x_partner_id"
                        data-table="product_cart_s"
                        data-field="x_partner_id"
                        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
                        data-modal-lookup="true"
                        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
                        <?= $Page->partner_id->editAttributes() ?>>
                        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
                    </select>
                    <?= $Page->partner_id->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage() ?></div>
                <?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
                <script>
                loadjs.ready("fproduct_cart_supdate", function() {
                    var options = { name: "x_partner_id", selectId: "fproduct_cart_supdate_x_partner_id" };
                    if (fproduct_cart_supdate.lists.partner_id?.lookupOptions.length) {
                        options.data = { id: "x_partner_id", form: "fproduct_cart_supdate" };
                    } else {
                        options.ajax = { id: "x_partner_id", form: "fproduct_cart_supdate", limit: 5 };
                    }
                    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.partner_id.modalLookupOptions);
                    ew.createModalLookup(options);
                });
                </script>
                </span>
                <?php } else { ?>
                <span id="el_product_cart_s_partner_id">
                <span<?= $Page->partner_id->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->partner_id->getDisplayValue($Page->partner_id->ViewValue) ?></span></span>
                <input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-hidden="1" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->p_remarks->Visible && (!$Page->isConfirm() || $Page->p_remarks->multiUpdateSelected())) { // p_remarks ?>
    <div id="r_p_remarks"<?= $Page->p_remarks->rowAttributes() ?>>
        <label for="x_p_remarks" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_p_remarks" id="u_p_remarks" class="form-check-input ew-multi-select" value="1"<?= $Page->p_remarks->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_p_remarks"><?= $Page->p_remarks->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_p_remarks" id="u_p_remarks" value="<?= $Page->p_remarks->MultiUpdate ?>">
            <?= $Page->p_remarks->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->p_remarks->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_product_cart_s_p_remarks">
                <input type="<?= $Page->p_remarks->getInputTextType() ?>" name="x_p_remarks" id="x_p_remarks" data-table="product_cart_s" data-field="x_p_remarks" value="<?= $Page->p_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->p_remarks->formatPattern()) ?>"<?= $Page->p_remarks->editAttributes() ?> aria-describedby="x_p_remarks_help">
                <?= $Page->p_remarks->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->p_remarks->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_product_cart_s_p_remarks">
                <span<?= $Page->p_remarks->viewAttributes() ?>>
                <input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->p_remarks->getDisplayValue($Page->p_remarks->ViewValue))) ?>"></span>
                <input type="hidden" data-table="product_cart_s" data-field="x_p_remarks" data-hidden="1" name="x_p_remarks" id="x_p_remarks" value="<?= HtmlEncode($Page->p_remarks->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_supdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_cart_supdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_supdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fproduct_cart_supdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
