<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartSList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_s: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    // Write your client script here, no need to add script tags.
    window.CreateOrder = function(CID, PID){
    	  var CAID =[];
    	  $("#tbl_product_cart_slist tbody input[type='checkbox']:checked").each(function(){
    	  		 CAID.push($(this).val());	  		 
    	  });
    	  if(CAID.length>0)
    	  {
    	  	$.getJSON(window.location.origin +"/apcajax?t=product_cart_s&getCIDPID=" + CAID,function(data) {
    	  	location.href='posadd?CID='+ data.company_id + '&PID=' + data.partner_id + '&CAID=' + CAID.toString();
    	  	});
    	  }
    	  else
    	  {
    	  	ew.alert("Please Select atleast a row to Update");
    	  }
    }
    					$.getJSON(window.location.origin +"/apcajax?pdbyepass=9",function(data) {
    			 		if (data == '2') {$("#r_batch_no").hide();}});	
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "material_status") {
    if ($Page->MasterRecordExists) {
        include_once "views/MaterialStatusMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fproduct_cart_ssrch" id="fproduct_cart_ssrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fproduct_cart_ssrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_s: currentTable } });
var currentForm;
var fproduct_cart_ssrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_ssrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["partner_id", [], fields.partner_id.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["po_id", [ew.Validators.integer], fields.po_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
<?php
if (!$Page->partner_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->partner_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="LIKE">
</div>
        </div>
        <div id="el_product_cart_s_partner_id" class="ew-search-field">
    <select
        id="x_partner_id"
        name="x_partner_id"
        class="form-control ew-select<?= $Page->partner_id->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_ssrch_x_partner_id"
        data-table="product_cart_s"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>"
        <?= $Page->partner_id->editAttributes() ?>>
        <?= $Page->partner_id->selectOptionListHtml("x_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
<script>
loadjs.ready("fproduct_cart_ssrch", function() {
    var options = { name: "x_partner_id", selectId: "fproduct_cart_ssrch_x_partner_id" };
    if (fproduct_cart_ssrch.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x_partner_id", form: "fproduct_cart_ssrch" };
    } else {
        options.ajax = { id: "x_partner_id", form: "fproduct_cart_ssrch", limit: 5 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_rid" class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</div>
        </div>
        <div id="el_product_cart_s_rid" class="ew-search-field">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_ssrch_x_rid"
        data-table="product_cart_s"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fproduct_cart_ssrch", function() {
    var options = { name: "x_rid", selectId: "fproduct_cart_ssrch_x_rid" };
    if (fproduct_cart_ssrch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fproduct_cart_ssrch" };
    } else {
        options.ajax = { id: "x_rid", form: "fproduct_cart_ssrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_rid_1" name="v_rid" value="AND"<?= ($Page->rid->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_rid_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_rid_2" name="v_rid" value="OR"<?= ($Page->rid->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_rid_2"><?= $Language->phrase("OR") ?></label></div></div>
            <div class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_rid" id="w_rid" value="=">
</div>
        </div><!-- /.ew-search-field -->
        <div id="el2_product_cart_s_rid" class="ew-search-field2">
    <select
        id="y_rid"
        name="y_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_ssrch_y_rid"
        data-table="product_cart_s"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("y_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_y_rid") ?>
<script>
loadjs.ready("fproduct_cart_ssrch", function() {
    var options = { name: "y_rid", selectId: "fproduct_cart_ssrch_y_rid" };
    if (fproduct_cart_ssrch.lists.rid?.lookupOptions.length) {
        options.data = { id: "y_rid", form: "fproduct_cart_ssrch" };
    } else {
        options.ajax = { id: "y_rid", form: "fproduct_cart_ssrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
<?php
if (!$Page->po_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_po_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->po_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->po_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_id" id="z_po_id" value="=">
</div>
        </div>
        <div id="el_product_cart_s_po_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->po_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_po_id" class="ew-auto-suggest">
    <input type="<?= $Page->po_id->getInputTextType() ?>" class="form-control" name="sv_x_po_id" id="sv_x_po_id" value="<?= RemoveHtml($Page->po_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_id->formatPattern()) ?>"<?= $Page->po_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_s" data-field="x_po_id" data-input="sv_x_po_id" data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>" name="x_po_id" id="x_po_id" value="<?= HtmlEncode($Page->po_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_ssrch", function() {
    fproduct_cart_ssrch.createAutoSuggest(Object.assign({"id":"x_po_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->po_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_s.fields.po_id.autoSuggestOptions));
});
</script>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fproduct_cart_ssrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fproduct_cart_ssrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fproduct_cart_ssrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fproduct_cart_ssrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fproduct_cart_ssrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fproduct_cart_ssrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fproduct_cart_ssrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_s">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "material_status" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="material_status">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->rid->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_product_cart_s" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_product_cart_slist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_product_cart_s_id" class="product_cart_s_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Page->location->headerCellClass() ?>"><div id="elh_product_cart_s_location" class="product_cart_s_location"><?= $Page->renderFieldHeader($Page->location) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_product_cart_s_company_id" class="product_cart_s_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Page->partner_id->headerCellClass() ?>"><div id="elh_product_cart_s_partner_id" class="product_cart_s_partner_id"><?= $Page->renderFieldHeader($Page->partner_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_rid->Visible) { // partner_rid ?>
        <th data-name="partner_rid" class="<?= $Page->partner_rid->headerCellClass() ?>"><div id="elh_product_cart_s_partner_rid" class="product_cart_s_partner_rid"><?= $Page->renderFieldHeader($Page->partner_rid) ?></div></th>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Page->product_type->headerCellClass() ?>"><div id="elh_product_cart_s_product_type" class="product_cart_s_product_type"><?= $Page->renderFieldHeader($Page->product_type) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_product_cart_s_grp" class="product_cart_s_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_product_cart_s_s_grp" class="product_cart_s_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_product_cart_s_product" class="product_cart_s_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_rid" class="product_cart_s_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_product_cart_s_packing_type" class="product_cart_s_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_product_cart_s_batch_no" class="product_cart_s_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Page->shape->headerCellClass() ?>"><div id="elh_product_cart_s_shape" class="product_cart_s_shape"><?= $Page->renderFieldHeader($Page->shape) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>"><div id="elh_product_cart_s_unit" class="product_cart_s_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
        <th data-name="w" class="<?= $Page->w->headerCellClass() ?>"><div id="elh_product_cart_s_w" class="product_cart_s_w"><?= $Page->renderFieldHeader($Page->w) ?></div></th>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
        <th data-name="w_cm" class="<?= $Page->w_cm->headerCellClass() ?>"><div id="elh_product_cart_s_w_cm" class="product_cart_s_w_cm"><?= $Page->renderFieldHeader($Page->w_cm) ?></div></th>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
        <th data-name="l" class="<?= $Page->l->headerCellClass() ?>"><div id="elh_product_cart_s_l" class="product_cart_s_l"><?= $Page->renderFieldHeader($Page->l) ?></div></th>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
        <th data-name="l_cm" class="<?= $Page->l_cm->headerCellClass() ?>"><div id="elh_product_cart_s_l_cm" class="product_cart_s_l_cm"><?= $Page->renderFieldHeader($Page->l_cm) ?></div></th>
<?php } ?>
<?php if ($Page->h->Visible) { // h ?>
        <th data-name="h" class="<?= $Page->h->headerCellClass() ?>"><div id="elh_product_cart_s_h" class="product_cart_s_h"><?= $Page->renderFieldHeader($Page->h) ?></div></th>
<?php } ?>
<?php if ($Page->h_cm->Visible) { // h_cm ?>
        <th data-name="h_cm" class="<?= $Page->h_cm->headerCellClass() ?>"><div id="elh_product_cart_s_h_cm" class="product_cart_s_h_cm"><?= $Page->renderFieldHeader($Page->h_cm) ?></div></th>
<?php } ?>
<?php if ($Page->partner_size->Visible) { // partner_size ?>
        <th data-name="partner_size" class="<?= $Page->partner_size->headerCellClass() ?>"><div id="elh_product_cart_s_partner_size" class="product_cart_s_partner_size"><?= $Page->renderFieldHeader($Page->partner_size) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_product_cart_s_quantity" class="product_cart_s_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Page->price->headerCellClass() ?>"><div id="elh_product_cart_s_price" class="product_cart_s_price"><?= $Page->renderFieldHeader($Page->price) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_amount" class="product_cart_s_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_status" class="product_cart_s_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
        <th data-name="po_id" class="<?= $Page->po_id->headerCellClass() ?>"><div id="elh_product_cart_s_po_id" class="product_cart_s_po_id"><?= $Page->renderFieldHeader($Page->po_id) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_product_cart_s_remarks" class="product_cart_s_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <th data-name="p_remarks" class="<?= $Page->p_remarks->headerCellClass() ?>"><div id="elh_product_cart_s_p_remarks" class="product_cart_s_p_remarks"><?= $Page->renderFieldHeader($Page->p_remarks) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_product_cart_s_operator" class="product_cart_s_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_product_cart_s_datetime" class="product_cart_s_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_id" class="el_product_cart_s_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->location->Visible) { // location ?>
        <td data-name="location"<?= $Page->location->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_location" class="el_product_cart_s_location">
<span<?= $Page->location->viewAttributes() ?>>
<?= $Page->location->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_company_id" class="el_product_cart_s_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Page->partner_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_partner_id" class="el_product_cart_s_partner_id">
<span<?= $Page->partner_id->viewAttributes() ?>>
<?= $Page->partner_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_rid->Visible) { // partner_rid ?>
        <td data-name="partner_rid"<?= $Page->partner_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_partner_rid" class="el_product_cart_s_partner_rid">
<span<?= $Page->partner_rid->viewAttributes() ?>>
<?= $Page->partner_rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_product_type" class="el_product_cart_s_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_grp" class="el_product_cart_s_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->getViewValue()) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><?= $Page->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_s_grp" class="el_product_cart_s_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_product" class="el_product_cart_s_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_rid" class="el_product_cart_s_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_packing_type" class="el_product_cart_s_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_batch_no" class="el_product_cart_s_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?= $Page->batch_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Page->shape->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_shape" class="el_product_cart_s_shape">
<span<?= $Page->shape->viewAttributes() ?>>
<?= $Page->shape->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_unit" class="el_product_cart_s_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?php if (!EmptyString($Page->unit->getViewValue()) && $Page->unit->linkAttributes() != "") { ?>
<a<?= $Page->unit->linkAttributes() ?>><?= $Page->unit->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->w->Visible) { // w ?>
        <td data-name="w"<?= $Page->w->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_w" class="el_product_cart_s_w">
<span<?= $Page->w->viewAttributes() ?>>
<?= $Page->w->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->w_cm->Visible) { // w_cm ?>
        <td data-name="w_cm"<?= $Page->w_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_w_cm" class="el_product_cart_s_w_cm">
<span<?= $Page->w_cm->viewAttributes() ?>>
<?= $Page->w_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->l->Visible) { // l ?>
        <td data-name="l"<?= $Page->l->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_l" class="el_product_cart_s_l">
<span<?= $Page->l->viewAttributes() ?>>
<?= $Page->l->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->l_cm->Visible) { // l_cm ?>
        <td data-name="l_cm"<?= $Page->l_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_l_cm" class="el_product_cart_s_l_cm">
<span<?= $Page->l_cm->viewAttributes() ?>>
<?= $Page->l_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->h->Visible) { // h ?>
        <td data-name="h"<?= $Page->h->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_h" class="el_product_cart_s_h">
<span<?= $Page->h->viewAttributes() ?>>
<?= $Page->h->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->h_cm->Visible) { // h_cm ?>
        <td data-name="h_cm"<?= $Page->h_cm->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_h_cm" class="el_product_cart_s_h_cm">
<span<?= $Page->h_cm->viewAttributes() ?>>
<?= $Page->h_cm->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_size->Visible) { // partner_size ?>
        <td data-name="partner_size"<?= $Page->partner_size->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_partner_size" class="el_product_cart_s_partner_size">
<span<?= $Page->partner_size->viewAttributes() ?>>
<?= $Page->partner_size->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_quantity" class="el_product_cart_s_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price"<?= $Page->price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_price" class="el_product_cart_s_price">
<span<?= $Page->price->viewAttributes() ?>>
<?= $Page->price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_amount" class="el_product_cart_s_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_status" class="el_product_cart_s_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_id->Visible) { // po_id ?>
        <td data-name="po_id"<?= $Page->po_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_po_id" class="el_product_cart_s_po_id">
<span<?= $Page->po_id->viewAttributes() ?>>
<?= $Page->po_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_remarks" class="el_product_cart_s_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->p_remarks->Visible) { // p_remarks ?>
        <td data-name="p_remarks"<?= $Page->p_remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_p_remarks" class="el_product_cart_s_p_remarks">
<span<?= $Page->p_remarks->viewAttributes() ?>>
<?= $Page->p_remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_operator" class="el_product_cart_s_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_s_datetime" class="el_product_cart_s_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
