<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("ProductCartSGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fproduct_cart_sgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { product_cart_s: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_sgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null, ew.Validators.integer], fields.company_id.isInvalid],
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null], fields.partner_id.isInvalid],
            ["partner_rid", [fields.partner_rid.visible && fields.partner_rid.required ? ew.Validators.required(fields.partner_rid.caption) : null], fields.partner_rid.isInvalid],
            ["product_type", [fields.product_type.visible && fields.product_type.required ? ew.Validators.required(fields.product_type.caption) : null], fields.product_type.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null], fields.rid.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["batch_no", [fields.batch_no.visible && fields.batch_no.required ? ew.Validators.required(fields.batch_no.caption) : null], fields.batch_no.isInvalid],
            ["shape", [fields.shape.visible && fields.shape.required ? ew.Validators.required(fields.shape.caption) : null], fields.shape.isInvalid],
            ["unit", [fields.unit.visible && fields.unit.required ? ew.Validators.required(fields.unit.caption) : null], fields.unit.isInvalid],
            ["w", [fields.w.visible && fields.w.required ? ew.Validators.required(fields.w.caption) : null], fields.w.isInvalid],
            ["w_cm", [fields.w_cm.visible && fields.w_cm.required ? ew.Validators.required(fields.w_cm.caption) : null, ew.Validators.float], fields.w_cm.isInvalid],
            ["l", [fields.l.visible && fields.l.required ? ew.Validators.required(fields.l.caption) : null], fields.l.isInvalid],
            ["l_cm", [fields.l_cm.visible && fields.l_cm.required ? ew.Validators.required(fields.l_cm.caption) : null, ew.Validators.float], fields.l_cm.isInvalid],
            ["h", [fields.h.visible && fields.h.required ? ew.Validators.required(fields.h.caption) : null], fields.h.isInvalid],
            ["h_cm", [fields.h_cm.visible && fields.h_cm.required ? ew.Validators.required(fields.h_cm.caption) : null, ew.Validators.float], fields.h_cm.isInvalid],
            ["partner_size", [fields.partner_size.visible && fields.partner_size.required ? ew.Validators.required(fields.partner_size.caption) : null], fields.partner_size.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.float], fields.quantity.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null, ew.Validators.float], fields.price.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null, ew.Validators.float], fields.amount.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["po_id", [fields.po_id.visible && fields.po_id.required ? ew.Validators.required(fields.po_id.caption) : null], fields.po_id.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["p_remarks", [fields.p_remarks.visible && fields.p_remarks.required ? ew.Validators.required(fields.p_remarks.caption) : null], fields.p_remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["location",false],["company_id",false],["partner_id",false],["partner_rid",false],["product_type",false],["grp",false],["s_grp",false],["product",false],["rid",false],["packing_type",false],["batch_no",false],["shape",false],["unit",false],["w",false],["w_cm",false],["l",false],["l_cm",false],["h",false],["h_cm",false],["partner_size",false],["quantity",false],["price",false],["amount",false],["status",false],["po_id",false],["remarks",false],["p_remarks",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Grid->location->toClientList($Grid) ?>,
            "company_id": <?= $Grid->company_id->toClientList($Grid) ?>,
            "partner_id": <?= $Grid->partner_id->toClientList($Grid) ?>,
            "partner_rid": <?= $Grid->partner_rid->toClientList($Grid) ?>,
            "product_type": <?= $Grid->product_type->toClientList($Grid) ?>,
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "s_grp": <?= $Grid->s_grp->toClientList($Grid) ?>,
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "rid": <?= $Grid->rid->toClientList($Grid) ?>,
            "packing_type": <?= $Grid->packing_type->toClientList($Grid) ?>,
            "batch_no": <?= $Grid->batch_no->toClientList($Grid) ?>,
            "shape": <?= $Grid->shape->toClientList($Grid) ?>,
            "unit": <?= $Grid->unit->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "po_id": <?= $Grid->po_id->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fproduct_cart_sgrid" class="ew-form ew-list-form">
<div id="gmp_product_cart_s" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_product_cart_sgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_product_cart_s_id" class="product_cart_s_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->location->Visible) { // location ?>
        <th data-name="location" class="<?= $Grid->location->headerCellClass() ?>"><div id="elh_product_cart_s_location" class="product_cart_s_location"><?= $Grid->renderFieldHeader($Grid->location) ?></div></th>
<?php } ?>
<?php if ($Grid->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Grid->company_id->headerCellClass() ?>"><div id="elh_product_cart_s_company_id" class="product_cart_s_company_id"><?= $Grid->renderFieldHeader($Grid->company_id) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Grid->partner_id->headerCellClass() ?>"><div id="elh_product_cart_s_partner_id" class="product_cart_s_partner_id"><?= $Grid->renderFieldHeader($Grid->partner_id) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_rid->Visible) { // partner_rid ?>
        <th data-name="partner_rid" class="<?= $Grid->partner_rid->headerCellClass() ?>"><div id="elh_product_cart_s_partner_rid" class="product_cart_s_partner_rid"><?= $Grid->renderFieldHeader($Grid->partner_rid) ?></div></th>
<?php } ?>
<?php if ($Grid->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Grid->product_type->headerCellClass() ?>"><div id="elh_product_cart_s_product_type" class="product_cart_s_product_type"><?= $Grid->renderFieldHeader($Grid->product_type) ?></div></th>
<?php } ?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_product_cart_s_grp" class="product_cart_s_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Grid->s_grp->headerCellClass() ?>"><div id="elh_product_cart_s_s_grp" class="product_cart_s_s_grp"><?= $Grid->renderFieldHeader($Grid->s_grp) ?></div></th>
<?php } ?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_product_cart_s_product" class="product_cart_s_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Grid->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_rid" class="product_cart_s_rid"><?= $Grid->renderFieldHeader($Grid->rid) ?></div></th>
<?php } ?>
<?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Grid->packing_type->headerCellClass() ?>"><div id="elh_product_cart_s_packing_type" class="product_cart_s_packing_type"><?= $Grid->renderFieldHeader($Grid->packing_type) ?></div></th>
<?php } ?>
<?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Grid->batch_no->headerCellClass() ?>"><div id="elh_product_cart_s_batch_no" class="product_cart_s_batch_no"><?= $Grid->renderFieldHeader($Grid->batch_no) ?></div></th>
<?php } ?>
<?php if ($Grid->shape->Visible) { // shape ?>
        <th data-name="shape" class="<?= $Grid->shape->headerCellClass() ?>"><div id="elh_product_cart_s_shape" class="product_cart_s_shape"><?= $Grid->renderFieldHeader($Grid->shape) ?></div></th>
<?php } ?>
<?php if ($Grid->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Grid->unit->headerCellClass() ?>"><div id="elh_product_cart_s_unit" class="product_cart_s_unit"><?= $Grid->renderFieldHeader($Grid->unit) ?></div></th>
<?php } ?>
<?php if ($Grid->w->Visible) { // w ?>
        <th data-name="w" class="<?= $Grid->w->headerCellClass() ?>"><div id="elh_product_cart_s_w" class="product_cart_s_w"><?= $Grid->renderFieldHeader($Grid->w) ?></div></th>
<?php } ?>
<?php if ($Grid->w_cm->Visible) { // w_cm ?>
        <th data-name="w_cm" class="<?= $Grid->w_cm->headerCellClass() ?>"><div id="elh_product_cart_s_w_cm" class="product_cart_s_w_cm"><?= $Grid->renderFieldHeader($Grid->w_cm) ?></div></th>
<?php } ?>
<?php if ($Grid->l->Visible) { // l ?>
        <th data-name="l" class="<?= $Grid->l->headerCellClass() ?>"><div id="elh_product_cart_s_l" class="product_cart_s_l"><?= $Grid->renderFieldHeader($Grid->l) ?></div></th>
<?php } ?>
<?php if ($Grid->l_cm->Visible) { // l_cm ?>
        <th data-name="l_cm" class="<?= $Grid->l_cm->headerCellClass() ?>"><div id="elh_product_cart_s_l_cm" class="product_cart_s_l_cm"><?= $Grid->renderFieldHeader($Grid->l_cm) ?></div></th>
<?php } ?>
<?php if ($Grid->h->Visible) { // h ?>
        <th data-name="h" class="<?= $Grid->h->headerCellClass() ?>"><div id="elh_product_cart_s_h" class="product_cart_s_h"><?= $Grid->renderFieldHeader($Grid->h) ?></div></th>
<?php } ?>
<?php if ($Grid->h_cm->Visible) { // h_cm ?>
        <th data-name="h_cm" class="<?= $Grid->h_cm->headerCellClass() ?>"><div id="elh_product_cart_s_h_cm" class="product_cart_s_h_cm"><?= $Grid->renderFieldHeader($Grid->h_cm) ?></div></th>
<?php } ?>
<?php if ($Grid->partner_size->Visible) { // partner_size ?>
        <th data-name="partner_size" class="<?= $Grid->partner_size->headerCellClass() ?>"><div id="elh_product_cart_s_partner_size" class="product_cart_s_partner_size"><?= $Grid->renderFieldHeader($Grid->partner_size) ?></div></th>
<?php } ?>
<?php if ($Grid->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Grid->quantity->headerCellClass() ?>"><div id="elh_product_cart_s_quantity" class="product_cart_s_quantity"><?= $Grid->renderFieldHeader($Grid->quantity) ?></div></th>
<?php } ?>
<?php if ($Grid->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Grid->price->headerCellClass() ?>"><div id="elh_product_cart_s_price" class="product_cart_s_price"><?= $Grid->renderFieldHeader($Grid->price) ?></div></th>
<?php } ?>
<?php if ($Grid->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Grid->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_amount" class="product_cart_s_amount"><?= $Grid->renderFieldHeader($Grid->amount) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_s_status" class="product_cart_s_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->po_id->Visible) { // po_id ?>
        <th data-name="po_id" class="<?= $Grid->po_id->headerCellClass() ?>"><div id="elh_product_cart_s_po_id" class="product_cart_s_po_id"><?= $Grid->renderFieldHeader($Grid->po_id) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_product_cart_s_remarks" class="product_cart_s_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->p_remarks->Visible) { // p_remarks ?>
        <th data-name="p_remarks" class="<?= $Grid->p_remarks->headerCellClass() ?>"><div id="elh_product_cart_s_p_remarks" class="product_cart_s_p_remarks"><?= $Grid->renderFieldHeader($Grid->p_remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_product_cart_s_operator" class="product_cart_s_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_product_cart_s_datetime" class="product_cart_s_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_id" class="el_product_cart_s_id"></span>
<input type="hidden" data-table="product_cart_s" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_id" class="el_product_cart_s_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="product_cart_s" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_id" class="el_product_cart_s_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_id" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_id" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_id" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_id" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="product_cart_s" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->location->Visible) { // location ?>
        <td data-name="location"<?= $Grid->location->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_location" class="el_product_cart_s_location">
    <select
        id="x<?= $Grid->RowIndex ?>_location"
        name="x<?= $Grid->RowIndex ?>_location"
        class="form-select ew-select<?= $Grid->location->isInvalidClass() ?>"
        <?php if (!$Grid->location->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_location"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_location"
        data-value-separator="<?= $Grid->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->location->getPlaceHolder()) ?>"
        <?= $Grid->location->editAttributes() ?>>
        <?= $Grid->location->selectOptionListHtml("x{$Grid->RowIndex}_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->location->getErrorMessage() ?></div>
<?= $Grid->location->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_location") ?>
<?php if (!$Grid->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_location", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.location?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_location", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_location", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_location" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_location" id="o<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_location" class="el_product_cart_s_location">
    <select
        id="x<?= $Grid->RowIndex ?>_location"
        name="x<?= $Grid->RowIndex ?>_location"
        class="form-select ew-select<?= $Grid->location->isInvalidClass() ?>"
        <?php if (!$Grid->location->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_location"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_location"
        data-value-separator="<?= $Grid->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->location->getPlaceHolder()) ?>"
        <?= $Grid->location->editAttributes() ?>>
        <?= $Grid->location->selectOptionListHtml("x{$Grid->RowIndex}_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->location->getErrorMessage() ?></div>
<?= $Grid->location->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_location") ?>
<?php if (!$Grid->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_location", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.location?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_location", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_location", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_location" class="el_product_cart_s_location">
<span<?= $Grid->location->viewAttributes() ?>>
<?= $Grid->location->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_location" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_location" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_location" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_location" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_location" value="<?= HtmlEncode($Grid->location->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Grid->company_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_company_id" class="el_product_cart_s_company_id">
<?php
if (IsRTL()) {
    $Grid->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_company_id" class="ew-auto-suggest">
    <input type="<?= $Grid->company_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_company_id" id="sv_x<?= $Grid->RowIndex ?>_company_id" value="<?= RemoveHtml($Grid->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->company_id->formatPattern()) ?>"<?= $Grid->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_s" data-field="x_company_id" data-input="sv_x<?= $Grid->RowIndex ?>_company_id" data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_company_id" id="x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    fproduct_cart_sgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_company_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Grid->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_s.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_company_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_company_id" id="o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_company_id" class="el_product_cart_s_company_id">
<?php
if (IsRTL()) {
    $Grid->company_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_company_id" class="ew-auto-suggest">
    <input type="<?= $Grid->company_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_company_id" id="sv_x<?= $Grid->RowIndex ?>_company_id" value="<?= RemoveHtml($Grid->company_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->company_id->formatPattern()) ?>"<?= $Grid->company_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_s" data-field="x_company_id" data-input="sv_x<?= $Grid->RowIndex ?>_company_id" data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_company_id" id="x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    fproduct_cart_sgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_company_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Grid->company_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_s.fields.company_id.autoSuggestOptions));
});
</script>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_company_id" class="el_product_cart_s_company_id">
<span<?= $Grid->company_id->viewAttributes() ?>>
<?= $Grid->company_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_company_id" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_company_id" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_company_id" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_company_id" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Grid->partner_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_id" class="el_product_cart_s_partner_id">
    <select
        id="x<?= $Grid->RowIndex ?>_partner_id"
        name="x<?= $Grid->RowIndex ?>_partner_id"
        class="form-control ew-select<?= $Grid->partner_id->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_id"
        data-table="product_cart_s"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->partner_id->editAttributes() ?>>
        <?= $Grid->partner_id->selectOptionListHtml("x{$Grid->RowIndex}_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner_id->getErrorMessage() ?></div>
<?= $Grid->partner_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_id") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner_id", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_id" };
    if (fproduct_cart_sgrid.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner_id", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner_id", form: "fproduct_cart_sgrid", limit: 5 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_id" id="o<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_id" class="el_product_cart_s_partner_id">
    <select
        id="x<?= $Grid->RowIndex ?>_partner_id"
        name="x<?= $Grid->RowIndex ?>_partner_id"
        class="form-control ew-select<?= $Grid->partner_id->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_id"
        data-table="product_cart_s"
        data-field="x_partner_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->partner_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->partner_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->partner_id->editAttributes() ?>>
        <?= $Grid->partner_id->selectOptionListHtml("x{$Grid->RowIndex}_partner_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner_id->getErrorMessage() ?></div>
<?= $Grid->partner_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_id") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner_id", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_id" };
    if (fproduct_cart_sgrid.lists.partner_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner_id", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner_id", form: "fproduct_cart_sgrid", limit: 5 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.partner_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_id" class="el_product_cart_s_partner_id">
<span<?= $Grid->partner_id->viewAttributes() ?>>
<?= $Grid->partner_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_partner_id" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_partner_id" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_partner_id" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_partner_id" value="<?= HtmlEncode($Grid->partner_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_rid->Visible) { // partner_rid ?>
        <td data-name="partner_rid"<?= $Grid->partner_rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_rid" class="el_product_cart_s_partner_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_partner_rid"
        name="x<?= $Grid->RowIndex ?>_partner_rid"
        class="form-control ew-select<?= $Grid->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_rid"
        data-table="product_cart_s"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner_rid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->partner_rid->editAttributes() ?>>
        <?= $Grid->partner_rid->selectOptionListHtml("x{$Grid->RowIndex}_partner_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner_rid->getErrorMessage() ?></div>
<?= $Grid->partner_rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner_rid", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_rid" };
    if (fproduct_cart_sgrid.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner_rid", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner_rid", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_rid" id="o<?= $Grid->RowIndex ?>_partner_rid" value="<?= HtmlEncode($Grid->partner_rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_rid" class="el_product_cart_s_partner_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_partner_rid"
        name="x<?= $Grid->RowIndex ?>_partner_rid"
        class="form-control ew-select<?= $Grid->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_rid"
        data-table="product_cart_s"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->partner_rid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->partner_rid->editAttributes() ?>>
        <?= $Grid->partner_rid->selectOptionListHtml("x{$Grid->RowIndex}_partner_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->partner_rid->getErrorMessage() ?></div>
<?= $Grid->partner_rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_partner_rid", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_partner_rid" };
    if (fproduct_cart_sgrid.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_partner_rid", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_partner_rid", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_rid" class="el_product_cart_s_partner_rid">
<span<?= $Grid->partner_rid->viewAttributes() ?>>
<?= $Grid->partner_rid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_rid" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_partner_rid" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_partner_rid" value="<?= HtmlEncode($Grid->partner_rid->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_partner_rid" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_partner_rid" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_partner_rid" value="<?= HtmlEncode($Grid->partner_rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Grid->product_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_product_type" class="el_product_cart_s_product_type">
    <select
        id="x<?= $Grid->RowIndex ?>_product_type"
        name="x<?= $Grid->RowIndex ?>_product_type"
        class="form-select ew-select<?= $Grid->product_type->isInvalidClass() ?>"
        <?php if (!$Grid->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product_type"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_product_type"
        data-value-separator="<?= $Grid->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_type->getPlaceHolder()) ?>"
        <?= $Grid->product_type->editAttributes() ?>>
        <?= $Grid->product_type->selectOptionListHtml("x{$Grid->RowIndex}_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_type->getErrorMessage() ?></div>
<?= $Grid->product_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_type") ?>
<?php if (!$Grid->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_type", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_product_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product_type" id="o<?= $Grid->RowIndex ?>_product_type" value="<?= HtmlEncode($Grid->product_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_product_type" class="el_product_cart_s_product_type">
    <select
        id="x<?= $Grid->RowIndex ?>_product_type"
        name="x<?= $Grid->RowIndex ?>_product_type"
        class="form-select ew-select<?= $Grid->product_type->isInvalidClass() ?>"
        <?php if (!$Grid->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product_type"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_product_type"
        data-value-separator="<?= $Grid->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product_type->getPlaceHolder()) ?>"
        <?= $Grid->product_type->editAttributes() ?>>
        <?= $Grid->product_type->selectOptionListHtml("x{$Grid->RowIndex}_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product_type->getErrorMessage() ?></div>
<?= $Grid->product_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product_type") ?>
<?php if (!$Grid->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product_type", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product_type", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_product_type" class="el_product_cart_s_product_type">
<span<?= $Grid->product_type->viewAttributes() ?>>
<?= $Grid->product_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_product_type" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_product_type" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_product_type" value="<?= HtmlEncode($Grid->product_type->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_product_type" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_product_type" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_product_type" value="<?= HtmlEncode($Grid->product_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_grp" class="el_product_cart_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-control ew-select<?= $Grid->grp->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_grp"
        data-table="product_cart_s"
        data-field="x_grp"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->grp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_grp" };
    if (fproduct_cart_sgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.grp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_grp" class="el_product_cart_s_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->EditValue) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><span class="form-control-plaintext"><?= $Grid->grp->getDisplayValue($Grid->grp->EditValue) ?></span></a>
<?php } else { ?>
<span class="form-control-plaintext"><?= $Grid->grp->getDisplayValue($Grid->grp->EditValue) ?></span>
<?php } ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_grp" data-hidden="1" name="x<?= $Grid->RowIndex ?>_grp" id="x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_grp" class="el_product_cart_s_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->getViewValue()) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><?= $Grid->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_grp" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_grp" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_grp" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_grp" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Grid->s_grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_s_grp" class="el_product_cart_s_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-control ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_s_grp"
        data-table="product_cart_s"
        data-field="x_s_grp"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->s_grp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_s_grp" };
    if (fproduct_cart_sgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.s_grp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_grp" id="o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_s_grp" class="el_product_cart_s_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-control ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_s_grp"
        data-table="product_cart_s"
        data-field="x_s_grp"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->s_grp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_s_grp" };
    if (fproduct_cart_sgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.s_grp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_s_grp" class="el_product_cart_s_s_grp">
<span<?= $Grid->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->s_grp->getViewValue()) && $Grid->s_grp->linkAttributes() != "") { ?>
<a<?= $Grid->s_grp->linkAttributes() ?>><?= $Grid->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_s_grp" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_s_grp" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_s_grp" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_s_grp" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_product" class="el_product_cart_s_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-control ew-select<?= $Grid->product->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product"
        data-table="product_cart_s"
        data-field="x_product"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->product->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product" };
    if (fproduct_cart_sgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.product.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_product" class="el_product_cart_s_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-control ew-select<?= $Grid->product->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product"
        data-table="product_cart_s"
        data-field="x_product"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->product->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_product" };
    if (fproduct_cart_sgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.product.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_product" class="el_product_cart_s_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_product" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_product" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_product" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_product" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Grid->rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->rid->getDisplayValue($Grid->rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_rid" class="el_product_cart_s_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-control ew-select<?= $Grid->rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_rid"
        data-table="product_cart_s"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_rid" };
    if (fproduct_cart_sgrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="product_cart_s" data-field="x_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rid" id="o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->rid->getDisplayValue($Grid->rid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_rid" class="el_product_cart_s_rid">
    <select
        id="x<?= $Grid->RowIndex ?>_rid"
        name="x<?= $Grid->RowIndex ?>_rid"
        class="form-control ew-select<?= $Grid->rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_rid"
        data-table="product_cart_s"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->rid->editAttributes() ?>>
        <?= $Grid->rid->selectOptionListHtml("x{$Grid->RowIndex}_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
<?= $Grid->rid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_rid") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_rid", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_rid" };
    if (fproduct_cart_sgrid.lists.rid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_rid", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_rid" class="el_product_cart_s_rid">
<span<?= $Grid->rid->viewAttributes() ?>>
<?= $Grid->rid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_rid" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_rid" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_rid" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_rid" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Grid->packing_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_packing_type" class="el_product_cart_s_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_packing_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packing_type" id="o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_packing_type" class="el_product_cart_s_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_packing_type" class="el_product_cart_s_packing_type">
<span<?= $Grid->packing_type->viewAttributes() ?>>
<?= $Grid->packing_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_packing_type" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_packing_type" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_packing_type" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_packing_type" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Grid->batch_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_batch_no" class="el_product_cart_s_batch_no">
    <select
        id="x<?= $Grid->RowIndex ?>_batch_no"
        name="x<?= $Grid->RowIndex ?>_batch_no"
        class="form-control ew-select<?= $Grid->batch_no->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_batch_no"
        data-table="product_cart_s"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>"
        <?= $Grid->batch_no->editAttributes() ?>>
        <?= $Grid->batch_no->selectOptionListHtml("x{$Grid->RowIndex}_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->batch_no->getErrorMessage() ?></div>
<?= $Grid->batch_no->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_batch_no") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_batch_no", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_batch_no" };
    if (fproduct_cart_sgrid.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_batch_no", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_batch_no", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_batch_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_batch_no" id="o<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_batch_no" class="el_product_cart_s_batch_no">
    <select
        id="x<?= $Grid->RowIndex ?>_batch_no"
        name="x<?= $Grid->RowIndex ?>_batch_no"
        class="form-control ew-select<?= $Grid->batch_no->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_batch_no"
        data-table="product_cart_s"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->batch_no->getPlaceHolder()) ?>"
        <?= $Grid->batch_no->editAttributes() ?>>
        <?= $Grid->batch_no->selectOptionListHtml("x{$Grid->RowIndex}_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->batch_no->getErrorMessage() ?></div>
<?= $Grid->batch_no->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_batch_no") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_batch_no", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_batch_no" };
    if (fproduct_cart_sgrid.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_batch_no", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_batch_no", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_batch_no" class="el_product_cart_s_batch_no">
<span<?= $Grid->batch_no->viewAttributes() ?>>
<?= $Grid->batch_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_batch_no" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_batch_no" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_batch_no" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_batch_no" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_batch_no" value="<?= HtmlEncode($Grid->batch_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->shape->Visible) { // shape ?>
        <td data-name="shape"<?= $Grid->shape->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_shape" class="el_product_cart_s_shape">
    <select
        id="x<?= $Grid->RowIndex ?>_shape"
        name="x<?= $Grid->RowIndex ?>_shape"
        class="form-control ew-select<?= $Grid->shape->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_shape"
        data-table="product_cart_s"
        data-field="x_shape"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->shape->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->shape->getPlaceHolder()) ?>"
        <?= $Grid->shape->editAttributes() ?>>
        <?= $Grid->shape->selectOptionListHtml("x{$Grid->RowIndex}_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->shape->getErrorMessage() ?></div>
<?= $Grid->shape->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_shape") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_shape", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_shape" };
    if (fproduct_cart_sgrid.lists.shape?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.shape.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_shape" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_shape" id="o<?= $Grid->RowIndex ?>_shape" value="<?= HtmlEncode($Grid->shape->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_shape" class="el_product_cart_s_shape">
    <select
        id="x<?= $Grid->RowIndex ?>_shape"
        name="x<?= $Grid->RowIndex ?>_shape"
        class="form-control ew-select<?= $Grid->shape->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_shape"
        data-table="product_cart_s"
        data-field="x_shape"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->shape->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->shape->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->shape->getPlaceHolder()) ?>"
        <?= $Grid->shape->editAttributes() ?>>
        <?= $Grid->shape->selectOptionListHtml("x{$Grid->RowIndex}_shape") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->shape->getErrorMessage() ?></div>
<?= $Grid->shape->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_shape") ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_shape", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_shape" };
    if (fproduct_cart_sgrid.lists.shape?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_shape", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_s.fields.shape.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_shape" class="el_product_cart_s_shape">
<span<?= $Grid->shape->viewAttributes() ?>>
<?= $Grid->shape->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_shape" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_shape" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_shape" value="<?= HtmlEncode($Grid->shape->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_shape" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_shape" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_shape" value="<?= HtmlEncode($Grid->shape->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Grid->unit->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_unit" class="el_product_cart_s_unit">
    <select
        id="x<?= $Grid->RowIndex ?>_unit"
        name="x<?= $Grid->RowIndex ?>_unit"
        class="form-select ew-select<?= $Grid->unit->isInvalidClass() ?>"
        <?php if (!$Grid->unit->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_unit"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_unit"
        data-value-separator="<?= $Grid->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->unit->getPlaceHolder()) ?>"
        <?= $Grid->unit->editAttributes() ?>>
        <?= $Grid->unit->selectOptionListHtml("x{$Grid->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->unit->getErrorMessage() ?></div>
<?= $Grid->unit->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_unit") ?>
<?php if (!$Grid->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_unit", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_unit" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_unit" id="o<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_unit" class="el_product_cart_s_unit">
    <select
        id="x<?= $Grid->RowIndex ?>_unit"
        name="x<?= $Grid->RowIndex ?>_unit"
        class="form-select ew-select<?= $Grid->unit->isInvalidClass() ?>"
        <?php if (!$Grid->unit->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_unit"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_unit"
        data-value-separator="<?= $Grid->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->unit->getPlaceHolder()) ?>"
        <?= $Grid->unit->editAttributes() ?>>
        <?= $Grid->unit->selectOptionListHtml("x{$Grid->RowIndex}_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->unit->getErrorMessage() ?></div>
<?= $Grid->unit->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_unit") ?>
<?php if (!$Grid->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_unit", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.unit?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_unit", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_unit" class="el_product_cart_s_unit">
<span<?= $Grid->unit->viewAttributes() ?>>
<?php if (!EmptyString($Grid->unit->getViewValue()) && $Grid->unit->linkAttributes() != "") { ?>
<a<?= $Grid->unit->linkAttributes() ?>><?= $Grid->unit->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->unit->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_unit" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_unit" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_unit" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_unit" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_unit" value="<?= HtmlEncode($Grid->unit->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->w->Visible) { // w ?>
        <td data-name="w"<?= $Grid->w->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_w" class="el_product_cart_s_w">
<input type="<?= $Grid->w->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w" id="x<?= $Grid->RowIndex ?>_w" data-table="product_cart_s" data-field="x_w" value="<?= $Grid->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w->formatPattern()) ?>"<?= $Grid->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_w" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_w" id="o<?= $Grid->RowIndex ?>_w" value="<?= HtmlEncode($Grid->w->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_w" class="el_product_cart_s_w">
<input type="<?= $Grid->w->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w" id="x<?= $Grid->RowIndex ?>_w" data-table="product_cart_s" data-field="x_w" value="<?= $Grid->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w->formatPattern()) ?>"<?= $Grid->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_w" class="el_product_cart_s_w">
<span<?= $Grid->w->viewAttributes() ?>>
<?= $Grid->w->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_w" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_w" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_w" value="<?= HtmlEncode($Grid->w->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_w" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_w" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_w" value="<?= HtmlEncode($Grid->w->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->w_cm->Visible) { // w_cm ?>
        <td data-name="w_cm"<?= $Grid->w_cm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_w_cm" class="el_product_cart_s_w_cm">
<input type="<?= $Grid->w_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w_cm" id="x<?= $Grid->RowIndex ?>_w_cm" data-table="product_cart_s" data-field="x_w_cm" value="<?= $Grid->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w_cm->formatPattern()) ?>"<?= $Grid->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_w_cm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_w_cm" id="o<?= $Grid->RowIndex ?>_w_cm" value="<?= HtmlEncode($Grid->w_cm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_w_cm" class="el_product_cart_s_w_cm">
<input type="<?= $Grid->w_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_w_cm" id="x<?= $Grid->RowIndex ?>_w_cm" data-table="product_cart_s" data-field="x_w_cm" value="<?= $Grid->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->w_cm->formatPattern()) ?>"<?= $Grid->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->w_cm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_w_cm" class="el_product_cart_s_w_cm">
<span<?= $Grid->w_cm->viewAttributes() ?>>
<?= $Grid->w_cm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_w_cm" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_w_cm" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_w_cm" value="<?= HtmlEncode($Grid->w_cm->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_w_cm" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_w_cm" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_w_cm" value="<?= HtmlEncode($Grid->w_cm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->l->Visible) { // l ?>
        <td data-name="l"<?= $Grid->l->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_l" class="el_product_cart_s_l">
<input type="<?= $Grid->l->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l" id="x<?= $Grid->RowIndex ?>_l" data-table="product_cart_s" data-field="x_l" value="<?= $Grid->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l->formatPattern()) ?>"<?= $Grid->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_l" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_l" id="o<?= $Grid->RowIndex ?>_l" value="<?= HtmlEncode($Grid->l->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_l" class="el_product_cart_s_l">
<input type="<?= $Grid->l->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l" id="x<?= $Grid->RowIndex ?>_l" data-table="product_cart_s" data-field="x_l" value="<?= $Grid->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l->formatPattern()) ?>"<?= $Grid->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_l" class="el_product_cart_s_l">
<span<?= $Grid->l->viewAttributes() ?>>
<?= $Grid->l->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_l" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_l" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_l" value="<?= HtmlEncode($Grid->l->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_l" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_l" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_l" value="<?= HtmlEncode($Grid->l->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->l_cm->Visible) { // l_cm ?>
        <td data-name="l_cm"<?= $Grid->l_cm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_l_cm" class="el_product_cart_s_l_cm">
<input type="<?= $Grid->l_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l_cm" id="x<?= $Grid->RowIndex ?>_l_cm" data-table="product_cart_s" data-field="x_l_cm" value="<?= $Grid->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l_cm->formatPattern()) ?>"<?= $Grid->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_l_cm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_l_cm" id="o<?= $Grid->RowIndex ?>_l_cm" value="<?= HtmlEncode($Grid->l_cm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_l_cm" class="el_product_cart_s_l_cm">
<input type="<?= $Grid->l_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_l_cm" id="x<?= $Grid->RowIndex ?>_l_cm" data-table="product_cart_s" data-field="x_l_cm" value="<?= $Grid->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->l_cm->formatPattern()) ?>"<?= $Grid->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->l_cm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_l_cm" class="el_product_cart_s_l_cm">
<span<?= $Grid->l_cm->viewAttributes() ?>>
<?= $Grid->l_cm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_l_cm" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_l_cm" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_l_cm" value="<?= HtmlEncode($Grid->l_cm->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_l_cm" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_l_cm" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_l_cm" value="<?= HtmlEncode($Grid->l_cm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->h->Visible) { // h ?>
        <td data-name="h"<?= $Grid->h->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_h" class="el_product_cart_s_h">
<input type="<?= $Grid->h->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h" id="x<?= $Grid->RowIndex ?>_h" data-table="product_cart_s" data-field="x_h" value="<?= $Grid->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h->formatPattern()) ?>"<?= $Grid->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_h" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_h" id="o<?= $Grid->RowIndex ?>_h" value="<?= HtmlEncode($Grid->h->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_h" class="el_product_cart_s_h">
<input type="<?= $Grid->h->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h" id="x<?= $Grid->RowIndex ?>_h" data-table="product_cart_s" data-field="x_h" value="<?= $Grid->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h->formatPattern()) ?>"<?= $Grid->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_h" class="el_product_cart_s_h">
<span<?= $Grid->h->viewAttributes() ?>>
<?= $Grid->h->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_h" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_h" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_h" value="<?= HtmlEncode($Grid->h->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_h" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_h" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_h" value="<?= HtmlEncode($Grid->h->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->h_cm->Visible) { // h_cm ?>
        <td data-name="h_cm"<?= $Grid->h_cm->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_h_cm" class="el_product_cart_s_h_cm">
<input type="<?= $Grid->h_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h_cm" id="x<?= $Grid->RowIndex ?>_h_cm" data-table="product_cart_s" data-field="x_h_cm" value="<?= $Grid->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h_cm->formatPattern()) ?>"<?= $Grid->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h_cm->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_h_cm" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_h_cm" id="o<?= $Grid->RowIndex ?>_h_cm" value="<?= HtmlEncode($Grid->h_cm->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_h_cm" class="el_product_cart_s_h_cm">
<input type="<?= $Grid->h_cm->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_h_cm" id="x<?= $Grid->RowIndex ?>_h_cm" data-table="product_cart_s" data-field="x_h_cm" value="<?= $Grid->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->h_cm->formatPattern()) ?>"<?= $Grid->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->h_cm->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_h_cm" class="el_product_cart_s_h_cm">
<span<?= $Grid->h_cm->viewAttributes() ?>>
<?= $Grid->h_cm->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_h_cm" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_h_cm" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_h_cm" value="<?= HtmlEncode($Grid->h_cm->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_h_cm" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_h_cm" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_h_cm" value="<?= HtmlEncode($Grid->h_cm->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->partner_size->Visible) { // partner_size ?>
        <td data-name="partner_size"<?= $Grid->partner_size->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_size" class="el_product_cart_s_partner_size">
<input type="<?= $Grid->partner_size->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_size" id="x<?= $Grid->RowIndex ?>_partner_size" data-table="product_cart_s" data-field="x_partner_size" value="<?= $Grid->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_size->formatPattern()) ?>"<?= $Grid->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_size->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_size" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_partner_size" id="o<?= $Grid->RowIndex ?>_partner_size" value="<?= HtmlEncode($Grid->partner_size->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_size" class="el_product_cart_s_partner_size">
<input type="<?= $Grid->partner_size->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_partner_size" id="x<?= $Grid->RowIndex ?>_partner_size" data-table="product_cart_s" data-field="x_partner_size" value="<?= $Grid->partner_size->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->partner_size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->partner_size->formatPattern()) ?>"<?= $Grid->partner_size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->partner_size->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_partner_size" class="el_product_cart_s_partner_size">
<span<?= $Grid->partner_size->viewAttributes() ?>>
<?= $Grid->partner_size->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_partner_size" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_partner_size" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_partner_size" value="<?= HtmlEncode($Grid->partner_size->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_partner_size" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_partner_size" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_partner_size" value="<?= HtmlEncode($Grid->partner_size->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Grid->quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_quantity" class="el_product_cart_s_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="product_cart_s" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_quantity" id="o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_quantity" class="el_product_cart_s_quantity">
<input type="<?= $Grid->quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_quantity" id="x<?= $Grid->RowIndex ?>_quantity" data-table="product_cart_s" data-field="x_quantity" value="<?= $Grid->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->quantity->formatPattern()) ?>"<?= $Grid->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_quantity" class="el_product_cart_s_quantity">
<span<?= $Grid->quantity->viewAttributes() ?>>
<?= $Grid->quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_quantity" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_quantity" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_quantity" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_quantity" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_quantity" value="<?= HtmlEncode($Grid->quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->price->Visible) { // price ?>
        <td data-name="price"<?= $Grid->price->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_price" class="el_product_cart_s_price">
<input type="<?= $Grid->price->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price" id="x<?= $Grid->RowIndex ?>_price" data-table="product_cart_s" data-field="x_price" value="<?= $Grid->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price->formatPattern()) ?>"<?= $Grid->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_price" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_price" id="o<?= $Grid->RowIndex ?>_price" value="<?= HtmlEncode($Grid->price->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_price" class="el_product_cart_s_price">
<input type="<?= $Grid->price->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_price" id="x<?= $Grid->RowIndex ?>_price" data-table="product_cart_s" data-field="x_price" value="<?= $Grid->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->price->formatPattern()) ?>"<?= $Grid->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->price->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_price" class="el_product_cart_s_price">
<span<?= $Grid->price->viewAttributes() ?>>
<?= $Grid->price->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_price" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_price" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_price" value="<?= HtmlEncode($Grid->price->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_price" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_price" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_price" value="<?= HtmlEncode($Grid->price->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Grid->amount->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_amount" class="el_product_cart_s_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="product_cart_s" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_amount" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_amount" id="o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_amount" class="el_product_cart_s_amount">
<input type="<?= $Grid->amount->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_amount" id="x<?= $Grid->RowIndex ?>_amount" data-table="product_cart_s" data-field="x_amount" value="<?= $Grid->amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->amount->formatPattern()) ?>"<?= $Grid->amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->amount->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_amount" class="el_product_cart_s_amount">
<span<?= $Grid->amount->viewAttributes() ?>>
<?= $Grid->amount->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_amount" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_amount" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_amount" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_amount" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_amount" value="<?= HtmlEncode($Grid->amount->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_status" class="el_product_cart_s_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="product_cart_s"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fproduct_cart_sgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_sgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fproduct_cart_sgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fproduct_cart_sgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_s.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_status" class="el_product_cart_s_status">
<span<?= $Grid->status->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->status->getDisplayValue($Grid->status->EditValue) ?></span></span>
<input type="hidden" data-table="product_cart_s" data-field="x_status" data-hidden="1" name="x<?= $Grid->RowIndex ?>_status" id="x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_status" class="el_product_cart_s_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_status" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_status" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_status" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_status" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->po_id->Visible) { // po_id ?>
        <td data-name="po_id"<?= $Grid->po_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_po_id" class="el_product_cart_s_po_id">
<?php
if (IsRTL()) {
    $Grid->po_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_po_id" class="ew-auto-suggest">
    <input type="<?= $Grid->po_id->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_po_id" id="sv_x<?= $Grid->RowIndex ?>_po_id" value="<?= RemoveHtml($Grid->po_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->po_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->po_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->po_id->formatPattern()) ?>"<?= $Grid->po_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_s" data-field="x_po_id" data-input="sv_x<?= $Grid->RowIndex ?>_po_id" data-value-separator="<?= $Grid->po_id->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_po_id" id="x<?= $Grid->RowIndex ?>_po_id" value="<?= HtmlEncode($Grid->po_id->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->po_id->getErrorMessage() ?></div>
<script>
loadjs.ready("fproduct_cart_sgrid", function() {
    fproduct_cart_sgrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_po_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->po_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_s.fields.po_id.autoSuggestOptions));
});
</script>
<?= $Grid->po_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_po_id") ?>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_po_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_po_id" id="o<?= $Grid->RowIndex ?>_po_id" value="<?= HtmlEncode($Grid->po_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_po_id" class="el_product_cart_s_po_id">
<span<?= $Grid->po_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->po_id->getDisplayValue($Grid->po_id->EditValue) ?></span></span>
<input type="hidden" data-table="product_cart_s" data-field="x_po_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_po_id" id="x<?= $Grid->RowIndex ?>_po_id" value="<?= HtmlEncode($Grid->po_id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_po_id" class="el_product_cart_s_po_id">
<span<?= $Grid->po_id->viewAttributes() ?>>
<?= $Grid->po_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_po_id" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_po_id" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_po_id" value="<?= HtmlEncode($Grid->po_id->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_po_id" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_po_id" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_po_id" value="<?= HtmlEncode($Grid->po_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_remarks" class="el_product_cart_s_remarks">
<textarea data-table="product_cart_s" data-field="x_remarks" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>"<?= $Grid->remarks->editAttributes() ?>><?= $Grid->remarks->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_remarks" class="el_product_cart_s_remarks">
<textarea data-table="product_cart_s" data-field="x_remarks" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" cols="35" rows="2" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>"<?= $Grid->remarks->editAttributes() ?>><?= $Grid->remarks->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_remarks" class="el_product_cart_s_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_remarks" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_remarks" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_remarks" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_remarks" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->p_remarks->Visible) { // p_remarks ?>
        <td data-name="p_remarks"<?= $Grid->p_remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_p_remarks" class="el_product_cart_s_p_remarks">
<input type="<?= $Grid->p_remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_p_remarks" id="x<?= $Grid->RowIndex ?>_p_remarks" data-table="product_cart_s" data-field="x_p_remarks" value="<?= $Grid->p_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Grid->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->p_remarks->formatPattern()) ?>"<?= $Grid->p_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->p_remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="product_cart_s" data-field="x_p_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_p_remarks" id="o<?= $Grid->RowIndex ?>_p_remarks" value="<?= HtmlEncode($Grid->p_remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_p_remarks" class="el_product_cart_s_p_remarks">
<input type="<?= $Grid->p_remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_p_remarks" id="x<?= $Grid->RowIndex ?>_p_remarks" data-table="product_cart_s" data-field="x_p_remarks" value="<?= $Grid->p_remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Grid->p_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->p_remarks->formatPattern()) ?>"<?= $Grid->p_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->p_remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_p_remarks" class="el_product_cart_s_p_remarks">
<span<?= $Grid->p_remarks->viewAttributes() ?>>
<?= $Grid->p_remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_p_remarks" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_p_remarks" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_p_remarks" value="<?= HtmlEncode($Grid->p_remarks->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_p_remarks" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_p_remarks" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_p_remarks" value="<?= HtmlEncode($Grid->p_remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="product_cart_s" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_operator" class="el_product_cart_s_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_operator" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_operator" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_operator" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_operator" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="product_cart_s" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_product_cart_s_datetime" class="el_product_cart_s_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="product_cart_s" data-field="x_datetime" data-hidden="1" name="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_datetime" id="fproduct_cart_sgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="product_cart_s" data-field="x_datetime" data-hidden="1" data-old name="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_datetime" id="fproduct_cart_sgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fproduct_cart_sgrid","load"], () => fproduct_cart_sgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fproduct_cart_sgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_s");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
