<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartBWbcSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b_wbc: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fproduct_cart_b_wbcsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_b_wbcsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["level", [ew.Validators.integer], fields.level.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["po_id", [], fields.po_id.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["partner_rid", [], fields.partner_rid.isInvalid],
            ["partner_code", [], fields.partner_code.isInvalid],
            ["product_type", [], fields.product_type.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["packing_type", [], fields.packing_type.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["quantity", [ew.Validators.float], fields.quantity.isInvalid],
            ["price", [ew.Validators.float], fields.price.isInvalid],
            ["currency", [], fields.currency.isInvalid],
            ["cbm", [ew.Validators.float], fields.cbm.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [], fields.datetime.isInvalid],
            ["w", [], fields.w.isInvalid],
            ["l", [], fields.l.isInvalid],
            ["h", [], fields.h.isInvalid],
            ["w_cm", [ew.Validators.float], fields.w_cm.isInvalid],
            ["l_cm", [ew.Validators.float], fields.l_cm.isInvalid],
            ["h_cm", [ew.Validators.float], fields.h_cm.isInvalid],
            ["image", [], fields.image.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "level": <?= $Page->level->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "location": <?= $Page->location->toClientList($Page) ?>,
            "po_id": <?= $Page->po_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "partner_rid": <?= $Page->partner_rid->toClientList($Page) ?>,
            "product_type": <?= $Page->product_type->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "packing_type": <?= $Page->packing_type->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "currency": <?= $Page->currency->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fproduct_cart_b_wbcsearch" id="fproduct_cart_b_wbcsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_b_wbc">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="product_cart_b_wbc" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level" class="row"<?= $Page->level->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_level"><?= $Page->level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_level" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->level->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_level" class="ew-auto-suggest">
    <input type="<?= $Page->level->getInputTextType() ?>" class="form-control" name="sv_x_level" id="sv_x_level" value="<?= RemoveHtml($Page->level->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->level->formatPattern()) ?>"<?= $Page->level->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b_wbc" data-field="x_level" data-input="sv_x_level" data-value-separator="<?= $Page->level->displayValueSeparatorAttribute() ?>" name="x_level" id="x_level" value="<?= HtmlEncode($Page->level->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    fproduct_cart_b_wbcsearch.createAutoSuggest(Object.assign({"id":"x_level","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->level->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b_wbc.fields.level.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsearch_x_company_id"
        data-table="product_cart_b_wbc"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_company_id", selectId: "fproduct_cart_b_wbcsearch_x_company_id" };
    if (fproduct_cart_b_wbcsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
    <div id="r_partner_order_no" class="row"<?= $Page->partner_order_no->rowAttributes() ?>>
        <label for="x_partner_order_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_partner_order_no"><?= $Page->partner_order_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_order_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_partner_order_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="product_cart_b_wbc" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_location"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_location", selectId: "fproduct_cart_b_wbcsearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_location", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
    <div id="r_po_id" class="row"<?= $Page->po_id->rowAttributes() ?>>
        <label for="x_po_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_po_id"><?= $Page->po_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_id" id="z_po_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_po_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_po_id"
        name="x_po_id"
        class="form-select ew-select<?= $Page->po_id->isInvalidClass() ?>"
        <?php if (!$Page->po_id->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_po_id"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_po_id"
        data-value-separator="<?= $Page->po_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->po_id->getPlaceHolder()) ?>"
        <?= $Page->po_id->editAttributes() ?>>
        <?= $Page->po_id->selectOptionListHtml("x_po_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->po_id->getErrorMessage(false) ?></div>
<?= $Page->po_id->Lookup->getParamTag($Page, "p_x_po_id") ?>
<?php if (!$Page->po_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_po_id", selectId: "fproduct_cart_b_wbcsearch_x_po_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.po_id?.lookupOptions.length) {
        options.data = { id: "x_po_id", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_po_id", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.po_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
    <div id="r_partner_id" class="row"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_partner_id"><?= $Page->partner_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_partner_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_partner_id" class="ew-auto-suggest">
    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b_wbc" data-field="x_partner_id" data-input="sv_x_partner_id" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    fproduct_cart_b_wbcsearch.createAutoSuggest(Object.assign({"id":"x_partner_id","forceSelect":true,"limit":20}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b_wbc.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_rid->Visible) { // partner_rid ?>
    <div id="r_partner_rid" class="row"<?= $Page->partner_rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_partner_rid"><?= $Page->partner_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_rid" id="z_partner_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_partner_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_partner_rid"
        name="x_partner_rid"
        class="form-control ew-select<?= $Page->partner_rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsearch_x_partner_rid"
        data-table="product_cart_b_wbc"
        data-field="x_partner_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->partner_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->partner_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->partner_rid->getPlaceHolder()) ?>"
        <?= $Page->partner_rid->editAttributes() ?>>
        <?= $Page->partner_rid->selectOptionListHtml("x_partner_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->partner_rid->getErrorMessage(false) ?></div>
<?= $Page->partner_rid->Lookup->getParamTag($Page, "p_x_partner_rid") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_partner_rid", selectId: "fproduct_cart_b_wbcsearch_x_partner_rid" };
    if (fproduct_cart_b_wbcsearch.lists.partner_rid?.lookupOptions.length) {
        options.data = { id: "x_partner_rid", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_partner_rid", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.partner_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
    <div id="r_partner_code" class="row"<?= $Page->partner_code->rowAttributes() ?>>
        <label for="x_partner_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_partner_code"><?= $Page->partner_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_code" id="z_partner_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_partner_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->partner_code->getInputTextType() ?>" name="x_partner_code" id="x_partner_code" data-table="product_cart_b_wbc" data-field="x_partner_code" value="<?= $Page->partner_code->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_code->formatPattern()) ?>"<?= $Page->partner_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
    <div id="r_product_type" class="row"<?= $Page->product_type->rowAttributes() ?>>
        <label for="x_product_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_product_type"><?= $Page->product_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_type" id="z_product_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_product_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_type"
        name="x_product_type"
        class="form-select ew-select<?= $Page->product_type->isInvalidClass() ?>"
        <?php if (!$Page->product_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_product_type"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_product_type"
        data-value-separator="<?= $Page->product_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_type->getPlaceHolder()) ?>"
        <?= $Page->product_type->editAttributes() ?>>
        <?= $Page->product_type->selectOptionListHtml("x_product_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_type->getErrorMessage(false) ?></div>
<?= $Page->product_type->Lookup->getParamTag($Page, "p_x_product_type") ?>
<?php if (!$Page->product_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_product_type", selectId: "fproduct_cart_b_wbcsearch_x_product_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.product_type?.lookupOptions.length) {
        options.data = { id: "x_product_type", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_product_type", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.product_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_grp"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_grp", selectId: "fproduct_cart_b_wbcsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-control ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsearch_x_s_grp"
        data-table="product_cart_b_wbc"
        data-field="x_s_grp"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_grp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_cart_b_wbcsearch_x_s_grp" };
    if (fproduct_cart_b_wbcsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.s_grp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-control ew-select<?= $Page->product->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsearch_x_product"
        data-table="product_cart_b_wbc"
        data-field="x_product"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_product", selectId: "fproduct_cart_b_wbcsearch_x_product" };
    if (fproduct_cart_b_wbcsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.product.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsearch_x_rid"
        data-table="product_cart_b_wbc"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_rid", selectId: "fproduct_cart_b_wbcsearch_x_rid" };
    if (fproduct_cart_b_wbcsearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_packing_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_packing_type"
        name="x_packing_type"
        class="form-select ew-select<?= $Page->packing_type->isInvalidClass() ?>"
        <?php if (!$Page->packing_type->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_packing_type"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_packing_type"
        data-value-separator="<?= $Page->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->packing_type->editAttributes() ?>>
        <?= $Page->packing_type->selectOptionListHtml("x_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
<?= $Page->packing_type->Lookup->getParamTag($Page, "p_x_packing_type") ?>
<?php if (!$Page->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_packing_type", selectId: "fproduct_cart_b_wbcsearch_x_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x_packing_type", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_packing_type", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_batch_no" class="ew-search-field ew-search-field-single">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-control ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsearch_x_batch_no"
        data-table="product_cart_b_wbc"
        data-field="x_batch_no"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->batch_no->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_batch_no", selectId: "fproduct_cart_b_wbcsearch_x_batch_no" };
    if (fproduct_cart_b_wbcsearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.batch_no.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="product_cart_b_wbc" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price" class="row"<?= $Page->price->rowAttributes() ?>>
        <label for="x_price" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_price"><?= $Page->price->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_price" id="z_price" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->price->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_price" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->price->getInputTextType() ?>" name="x_price" id="x_price" data-table="product_cart_b_wbc" data-field="x_price" value="<?= $Page->price->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->price->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->price->formatPattern()) ?>"<?= $Page->price->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->price->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->currency->Visible) { // currency ?>
    <div id="r_currency" class="row"<?= $Page->currency->rowAttributes() ?>>
        <label for="x_currency" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_currency"><?= $Page->currency->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_currency" id="z_currency" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->currency->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_currency" class="ew-search-field ew-search-field-single">
    <select
        id="x_currency"
        name="x_currency"
        class="form-select ew-select<?= $Page->currency->isInvalidClass() ?>"
        <?php if (!$Page->currency->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_currency"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_currency"
        data-value-separator="<?= $Page->currency->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->currency->getPlaceHolder()) ?>"
        <?= $Page->currency->editAttributes() ?>>
        <?= $Page->currency->selectOptionListHtml("x_currency") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->currency->getErrorMessage(false) ?></div>
<?= $Page->currency->Lookup->getParamTag($Page, "p_x_currency") ?>
<?php if (!$Page->currency->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_currency", selectId: "fproduct_cart_b_wbcsearch_x_currency" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.currency?.lookupOptions.length) {
        options.data = { id: "x_currency", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_currency", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.currency.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->cbm->Visible) { // cbm ?>
    <div id="r_cbm" class="row"<?= $Page->cbm->rowAttributes() ?>>
        <label for="x_cbm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_cbm"><?= $Page->cbm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_cbm" id="z_cbm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->cbm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_cbm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->cbm->getInputTextType() ?>" name="x_cbm" id="x_cbm" data-table="product_cart_b_wbc" data-field="x_cbm" value="<?= $Page->cbm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->cbm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->cbm->formatPattern()) ?>"<?= $Page->cbm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->cbm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="product_cart_b_wbc" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsearch_x_operator"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsearch", function() {
    var options = { name: "x_operator", selectId: "fproduct_cart_b_wbcsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fproduct_cart_b_wbcsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fproduct_cart_b_wbcsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="product_cart_b_wbc" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fproduct_cart_b_wbcsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fproduct_cart_b_wbcsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w->Visible) { // w ?>
    <div id="r_w" class="row"<?= $Page->w->rowAttributes() ?>>
        <label for="x_w" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_w"><?= $Page->w->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_w" id="z_w" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_w" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w->getInputTextType() ?>" name="x_w" id="x_w" data-table="product_cart_b_wbc" data-field="x_w" value="<?= $Page->w->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->w->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w->formatPattern()) ?>"<?= $Page->w->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l->Visible) { // l ?>
    <div id="r_l" class="row"<?= $Page->l->rowAttributes() ?>>
        <label for="x_l" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_l"><?= $Page->l->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_l" id="z_l" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_l" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l->getInputTextType() ?>" name="x_l" id="x_l" data-table="product_cart_b_wbc" data-field="x_l" value="<?= $Page->l->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->l->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l->formatPattern()) ?>"<?= $Page->l->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->h->Visible) { // h ?>
    <div id="r_h" class="row"<?= $Page->h->rowAttributes() ?>>
        <label for="x_h" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_h"><?= $Page->h->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_h" id="z_h" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->h->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_h" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h->getInputTextType() ?>" name="x_h" id="x_h" data-table="product_cart_b_wbc" data-field="x_h" value="<?= $Page->h->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->h->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h->formatPattern()) ?>"<?= $Page->h->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm" class="row"<?= $Page->w_cm->rowAttributes() ?>>
        <label for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_w_cm"><?= $Page->w_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_w_cm" id="z_w_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->w_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_w_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="product_cart_b_wbc" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm" class="row"<?= $Page->l_cm->rowAttributes() ?>>
        <label for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_l_cm"><?= $Page->l_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_l_cm" id="z_l_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->l_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_l_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="product_cart_b_wbc" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->h_cm->Visible) { // h_cm ?>
    <div id="r_h_cm" class="row"<?= $Page->h_cm->rowAttributes() ?>>
        <label for="x_h_cm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_h_cm"><?= $Page->h_cm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_h_cm" id="z_h_cm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->h_cm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_h_cm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->h_cm->getInputTextType() ?>" name="x_h_cm" id="x_h_cm" data-table="product_cart_b_wbc" data-field="x_h_cm" value="<?= $Page->h_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->h_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->h_cm->formatPattern()) ?>"<?= $Page->h_cm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->h_cm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_product_cart_b_wbc_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_product_cart_b_wbc_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="product_cart_b_wbc" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fproduct_cart_b_wbcsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fproduct_cart_b_wbcsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fproduct_cart_b_wbcsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_b_wbc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
