<?php

namespace PHPMaker2024\fibre;

// Page object
$ProductCartBWbcList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b_wbc: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    // Write your client script here, no need to add script tags.
    window.CreateOrder = function(CID, PID){
    	  var CAID =[];
    	  $("#tbl_product_cart_b_wbclist tbody input[type='checkbox']:checked").each(function(){
    	  		 CAID.push($(this).val());	  		 
    	  });
    	  if(CAID.length>0)
    	  {
    	  	$.getJSON(window.location.origin +"/apcajax?t=product_cart_b&getCIDPID=" + CAID,function(data) {
    	  	location.href='pobwbcadd?GRP='+data.grp+'&CID='+ data.company_id + '&PID=' + data.partner_id + '&CAID=' + CAID.toString();
    	  	});
    	  }
    	  else
    	  {
    	  	ew.alert("Please Select atleast a row to Update");
    	  }
    }
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fproduct_cart_b_wbcsrch" id="fproduct_cart_b_wbcsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fproduct_cart_b_wbcsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { product_cart_b_wbc: currentTable } });
var currentForm;
var fproduct_cart_b_wbcsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fproduct_cart_b_wbcsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["company_id", [], fields.company_id.isInvalid],
            ["partner_order_no", [], fields.partner_order_no.isInvalid],
            ["partner_id", [], fields.partner_id.isInvalid],
            ["grp", [], fields.grp.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->company_id->Visible) { // company_id ?>
<?php
if (!$Page->company_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_company_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->company_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->company_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</div>
        </div>
        <div id="el_product_cart_b_wbc_company_id" class="ew-search-field">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-control ew-select<?= $Page->company_id->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsrch_x_company_id"
        data-table="product_cart_b_wbc"
        data-field="x_company_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->company_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsrch", function() {
    var options = { name: "x_company_id", selectId: "fproduct_cart_b_wbcsrch_x_company_id" };
    if (fproduct_cart_b_wbcsrch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fproduct_cart_b_wbcsrch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fproduct_cart_b_wbcsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.company_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
<?php
if (!$Page->partner_order_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_order_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_order_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_partner_order_no" class="ew-search-caption ew-label"><?= $Page->partner_order_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_partner_order_no" id="z_partner_order_no" value="LIKE">
</div>
        </div>
        <div id="el_product_cart_b_wbc_partner_order_no" class="ew-search-field">
<input type="<?= $Page->partner_order_no->getInputTextType() ?>" name="x_partner_order_no" id="x_partner_order_no" data-table="product_cart_b_wbc" data-field="x_partner_order_no" value="<?= $Page->partner_order_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->partner_order_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_order_no->formatPattern()) ?>"<?= $Page->partner_order_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->partner_order_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
<?php
if (!$Page->partner_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_partner_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->partner_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->partner_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_partner_id" id="z_partner_id" value="=">
</div>
        </div>
        <div id="el_product_cart_b_wbc_partner_id" class="ew-search-field">
<?php
if (IsRTL()) {
    $Page->partner_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_partner_id" class="ew-auto-suggest">
    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="product_cart_b_wbc" data-field="x_partner_id" data-input="sv_x_partner_id" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fproduct_cart_b_wbcsrch", function() {
    fproduct_cart_b_wbcsrch.createAutoSuggest(Object.assign({"id":"x_partner_id","forceSelect":true,"limit":20}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.product_cart_b_wbc.fields.partner_id.autoSuggestOptions));
});
</script>
<?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_grp" class="ew-search-caption ew-label"><?= $Page->grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</div>
        </div>
        <div id="el_product_cart_b_wbc_grp" class="ew-search-field">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fproduct_cart_b_wbcsrch_x_grp"
        <?php } ?>
        data-table="product_cart_b_wbc"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsrch", function() {
    var options = { name: "x_grp", selectId: "fproduct_cart_b_wbcsrch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fproduct_cart_b_wbcsrch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fproduct_cart_b_wbcsrch" };
    } else {
        options.ajax = { id: "x_grp", form: "fproduct_cart_b_wbcsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.product_cart_b_wbc.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
<?php
if (!$Page->s_grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_s_grp" class="ew-search-caption ew-label"><?= $Page->s_grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</div>
        </div>
        <div id="el_product_cart_b_wbc_s_grp" class="ew-search-field">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-control ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsrch_x_s_grp"
        data-table="product_cart_b_wbc"
        data-field="x_s_grp"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_grp->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsrch", function() {
    var options = { name: "x_s_grp", selectId: "fproduct_cart_b_wbcsrch_x_s_grp" };
    if (fproduct_cart_b_wbcsrch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fproduct_cart_b_wbcsrch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fproduct_cart_b_wbcsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.s_grp.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
<?php
if (!$Page->product->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_product" class="ew-search-caption ew-label"><?= $Page->product->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</div>
        </div>
        <div id="el_product_cart_b_wbc_product" class="ew-search-field">
    <select
        id="x_product"
        name="x_product"
        class="form-control ew-select<?= $Page->product->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsrch_x_product"
        data-table="product_cart_b_wbc"
        data-field="x_product"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsrch", function() {
    var options = { name: "x_product", selectId: "fproduct_cart_b_wbcsrch_x_product" };
    if (fproduct_cart_b_wbcsrch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fproduct_cart_b_wbcsrch" };
    } else {
        options.ajax = { id: "x_product", form: "fproduct_cart_b_wbcsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.product.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_rid" class="ew-search-caption ew-label"><?= $Page->rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_rid" id="z_rid" value="LIKE">
</div>
        </div>
        <div id="el_product_cart_b_wbc_rid" class="ew-search-field">
    <select
        id="x_rid"
        name="x_rid"
        class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
        data-select2-id="fproduct_cart_b_wbcsrch_x_rid"
        data-table="product_cart_b_wbc"
        data-field="x_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<script>
loadjs.ready("fproduct_cart_b_wbcsrch", function() {
    var options = { name: "x_rid", selectId: "fproduct_cart_b_wbcsrch_x_rid" };
    if (fproduct_cart_b_wbcsrch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fproduct_cart_b_wbcsrch" };
    } else {
        options.ajax = { id: "x_rid", form: "fproduct_cart_b_wbcsrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.product_cart_b_wbc.fields.rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fproduct_cart_b_wbcsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fproduct_cart_b_wbcsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fproduct_cart_b_wbcsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fproduct_cart_b_wbcsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fproduct_cart_b_wbcsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fproduct_cart_b_wbcsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fproduct_cart_b_wbcsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="product_cart_b_wbc">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_product_cart_b_wbc" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_product_cart_b_wbclist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_id" class="product_cart_b_wbc_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
        <th data-name="level" class="<?= $Page->level->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_level" class="product_cart_b_wbc_level"><?= $Page->renderFieldHeader($Page->level) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_company_id" class="product_cart_b_wbc_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
        <th data-name="partner_order_no" class="<?= $Page->partner_order_no->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_order_no" class="product_cart_b_wbc_partner_order_no"><?= $Page->renderFieldHeader($Page->partner_order_no) ?></div></th>
<?php } ?>
<?php if ($Page->po_id->Visible) { // po_id ?>
        <th data-name="po_id" class="<?= $Page->po_id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_po_id" class="product_cart_b_wbc_po_id"><?= $Page->renderFieldHeader($Page->po_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_id->Visible) { // partner_id ?>
        <th data-name="partner_id" class="<?= $Page->partner_id->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_id" class="product_cart_b_wbc_partner_id"><?= $Page->renderFieldHeader($Page->partner_id) ?></div></th>
<?php } ?>
<?php if ($Page->partner_rid->Visible) { // partner_rid ?>
        <th data-name="partner_rid" class="<?= $Page->partner_rid->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_rid" class="product_cart_b_wbc_partner_rid"><?= $Page->renderFieldHeader($Page->partner_rid) ?></div></th>
<?php } ?>
<?php if ($Page->partner_code->Visible) { // partner_code ?>
        <th data-name="partner_code" class="<?= $Page->partner_code->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_partner_code" class="product_cart_b_wbc_partner_code"><?= $Page->renderFieldHeader($Page->partner_code) ?></div></th>
<?php } ?>
<?php if ($Page->product_type->Visible) { // product_type ?>
        <th data-name="product_type" class="<?= $Page->product_type->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_product_type" class="product_cart_b_wbc_product_type"><?= $Page->renderFieldHeader($Page->product_type) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_grp" class="product_cart_b_wbc_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_s_grp" class="product_cart_b_wbc_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_product" class="product_cart_b_wbc_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_rid" class="product_cart_b_wbc_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Page->packing_type->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_packing_type" class="product_cart_b_wbc_packing_type"><?= $Page->renderFieldHeader($Page->packing_type) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_quantity" class="product_cart_b_wbc_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
        <th data-name="price" class="<?= $Page->price->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_price" class="product_cart_b_wbc_price"><?= $Page->renderFieldHeader($Page->price) ?></div></th>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
        <th data-name="amount" class="<?= $Page->amount->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_b_wbc_amount" class="product_cart_b_wbc_amount"><?= $Page->renderFieldHeader($Page->amount) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_product_cart_b_wbc_status" class="product_cart_b_wbc_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_operator" class="product_cart_b_wbc_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_datetime" class="product_cart_b_wbc_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Page->image->headerCellClass() ?>"><div id="elh_product_cart_b_wbc_image" class="product_cart_b_wbc_image"><?= $Page->renderFieldHeader($Page->image) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_id" class="el_product_cart_b_wbc_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->level->Visible) { // level ?>
        <td data-name="level"<?= $Page->level->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_level" class="el_product_cart_b_wbc_level">
<span<?= $Page->level->viewAttributes() ?>>
<?= $Page->level->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_company_id" class="el_product_cart_b_wbc_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
        <td data-name="partner_order_no"<?= $Page->partner_order_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_partner_order_no" class="el_product_cart_b_wbc_partner_order_no">
<span<?= $Page->partner_order_no->viewAttributes() ?>>
<?= $Page->partner_order_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_id->Visible) { // po_id ?>
        <td data-name="po_id"<?= $Page->po_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_po_id" class="el_product_cart_b_wbc_po_id">
<span<?= $Page->po_id->viewAttributes() ?>>
<?php if (!EmptyString($Page->po_id->getViewValue()) && $Page->po_id->linkAttributes() != "") { ?>
<a<?= $Page->po_id->linkAttributes() ?>><?= $Page->po_id->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->po_id->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id"<?= $Page->partner_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_partner_id" class="el_product_cart_b_wbc_partner_id">
<span<?= $Page->partner_id->viewAttributes() ?>>
<?= $Page->partner_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_rid->Visible) { // partner_rid ?>
        <td data-name="partner_rid"<?= $Page->partner_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_partner_rid" class="el_product_cart_b_wbc_partner_rid">
<span<?= $Page->partner_rid->viewAttributes() ?>>
<?= $Page->partner_rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->partner_code->Visible) { // partner_code ?>
        <td data-name="partner_code"<?= $Page->partner_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_partner_code" class="el_product_cart_b_wbc_partner_code">
<span<?= $Page->partner_code->viewAttributes() ?>>
<?= $Page->partner_code->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_type->Visible) { // product_type ?>
        <td data-name="product_type"<?= $Page->product_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_product_type" class="el_product_cart_b_wbc_product_type">
<span<?= $Page->product_type->viewAttributes() ?>>
<?= $Page->product_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_grp" class="el_product_cart_b_wbc_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->getViewValue()) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><?= $Page->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_s_grp" class="el_product_cart_b_wbc_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->s_grp->getViewValue()) && $Page->s_grp->linkAttributes() != "") { ?>
<a<?= $Page->s_grp->linkAttributes() ?>><?= $Page->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_product" class="el_product_cart_b_wbc_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_rid" class="el_product_cart_b_wbc_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Page->packing_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_packing_type" class="el_product_cart_b_wbc_packing_type">
<span<?= $Page->packing_type->viewAttributes() ?>>
<?= $Page->packing_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_quantity" class="el_product_cart_b_wbc_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price"<?= $Page->price->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_price" class="el_product_cart_b_wbc_price">
<span<?= $Page->price->viewAttributes() ?>>
<?= $Page->price->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount"<?= $Page->amount->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_amount" class="el_product_cart_b_wbc_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<?= $Page->amount->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_status" class="el_product_cart_b_wbc_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_operator" class="el_product_cart_b_wbc_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_datetime" class="el_product_cart_b_wbc_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_product_cart_b_wbc_image" class="el_product_cart_b_wbc_image">
<span>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_id" class="product_cart_b_wbc_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->level->Visible) { // level ?>
        <td data-name="level" class="<?= $Page->level->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_level" class="product_cart_b_wbc_level">
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_company_id" class="product_cart_b_wbc_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_order_no->Visible) { // partner_order_no ?>
        <td data-name="partner_order_no" class="<?= $Page->partner_order_no->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_order_no" class="product_cart_b_wbc_partner_order_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->po_id->Visible) { // po_id ?>
        <td data-name="po_id" class="<?= $Page->po_id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_po_id" class="product_cart_b_wbc_po_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_id->Visible) { // partner_id ?>
        <td data-name="partner_id" class="<?= $Page->partner_id->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_id" class="product_cart_b_wbc_partner_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_rid->Visible) { // partner_rid ?>
        <td data-name="partner_rid" class="<?= $Page->partner_rid->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_rid" class="product_cart_b_wbc_partner_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->partner_code->Visible) { // partner_code ?>
        <td data-name="partner_code" class="<?= $Page->partner_code->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_partner_code" class="product_cart_b_wbc_partner_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_type->Visible) { // product_type ?>
        <td data-name="product_type" class="<?= $Page->product_type->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_product_type" class="product_cart_b_wbc_product_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_grp" class="product_cart_b_wbc_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp" class="<?= $Page->s_grp->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_s_grp" class="product_cart_b_wbc_s_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_product" class="product_cart_b_wbc_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_rid" class="product_cart_b_wbc_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Page->packing_type->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_packing_type" class="product_cart_b_wbc_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_quantity" class="product_cart_b_wbc_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->price->Visible) { // price ?>
        <td data-name="price" class="<?= $Page->price->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_price" class="product_cart_b_wbc_price">
        </span></td>
    <?php } ?>
    <?php if ($Page->amount->Visible) { // amount ?>
        <td data-name="amount" class="<?= $Page->amount->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_amount" class="product_cart_b_wbc_amount">
        </span></td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status" class="<?= $Page->status->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_status" class="product_cart_b_wbc_status">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_operator" class="product_cart_b_wbc_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_datetime" class="product_cart_b_wbc_datetime">
        </span></td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image" class="<?= $Page->image->footerCellClass() ?>"><span id="elf_product_cart_b_wbc_image" class="product_cart_b_wbc_image">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("product_cart_b_wbc");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
